// Code generated by "./generator ./session/org.ayatana.bamf"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package bamf

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus/v5"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type Control interface {
	control // interface org.ayatana.bamf.control
	proxy.Object
}

type objectControl struct {
	interfaceControl // interface org.ayatana.bamf.control
	proxy.ImplObject
}

func NewControl(conn *dbus.Conn) Control {
	obj := new(objectControl)
	obj.ImplObject.Init_(conn, "org.ayatana.bamf", "/org/ayatana/bamf/control")
	return obj
}

type control interface {
	GoQuit(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Quit(flags dbus.Flags) error
	GoInsertDesktopFile(flags dbus.Flags, ch chan *dbus.Call, desktop_path string) *dbus.Call
	InsertDesktopFile(flags dbus.Flags, desktop_path string) error
	GoRegisterApplicationForPid(flags dbus.Flags, ch chan *dbus.Call, application string, pid int32) *dbus.Call
	RegisterApplicationForPid(flags dbus.Flags, application string, pid int32) error
	GoCreateLocalDesktopFile(flags dbus.Flags, ch chan *dbus.Call, application string) *dbus.Call
	CreateLocalDesktopFile(flags dbus.Flags, application string) error
	GoOmNomNomDesktopFile(flags dbus.Flags, ch chan *dbus.Call, desktop_path string) *dbus.Call
	OmNomNomDesktopFile(flags dbus.Flags, desktop_path string) error
}

type interfaceControl struct{}

func (v *interfaceControl) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceControl) GetInterfaceName_() string {
	return "org.ayatana.bamf.control"
}

// method Quit

func (v *interfaceControl) GoQuit(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Quit", flags, ch)
}

func (v *interfaceControl) Quit(flags dbus.Flags) error {
	return (<-v.GoQuit(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method InsertDesktopFile

func (v *interfaceControl) GoInsertDesktopFile(flags dbus.Flags, ch chan *dbus.Call, desktop_path string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".InsertDesktopFile", flags, ch, desktop_path)
}

func (v *interfaceControl) InsertDesktopFile(flags dbus.Flags, desktop_path string) error {
	return (<-v.GoInsertDesktopFile(flags, make(chan *dbus.Call, 1), desktop_path).Done).Err
}

// method RegisterApplicationForPid

func (v *interfaceControl) GoRegisterApplicationForPid(flags dbus.Flags, ch chan *dbus.Call, application string, pid int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RegisterApplicationForPid", flags, ch, application, pid)
}

func (v *interfaceControl) RegisterApplicationForPid(flags dbus.Flags, application string, pid int32) error {
	return (<-v.GoRegisterApplicationForPid(flags, make(chan *dbus.Call, 1), application, pid).Done).Err
}

// method CreateLocalDesktopFile

func (v *interfaceControl) GoCreateLocalDesktopFile(flags dbus.Flags, ch chan *dbus.Call, application string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CreateLocalDesktopFile", flags, ch, application)
}

func (v *interfaceControl) CreateLocalDesktopFile(flags dbus.Flags, application string) error {
	return (<-v.GoCreateLocalDesktopFile(flags, make(chan *dbus.Call, 1), application).Done).Err
}

// method OmNomNomDesktopFile

func (v *interfaceControl) GoOmNomNomDesktopFile(flags dbus.Flags, ch chan *dbus.Call, desktop_path string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".OmNomNomDesktopFile", flags, ch, desktop_path)
}

func (v *interfaceControl) OmNomNomDesktopFile(flags dbus.Flags, desktop_path string) error {
	return (<-v.GoOmNomNomDesktopFile(flags, make(chan *dbus.Call, 1), desktop_path).Done).Err
}

type Matcher interface {
	matcher // interface org.ayatana.bamf.matcher
	proxy.Object
}

type objectMatcher struct {
	interfaceMatcher // interface org.ayatana.bamf.matcher
	proxy.ImplObject
}

func NewMatcher(conn *dbus.Conn) Matcher {
	obj := new(objectMatcher)
	obj.ImplObject.Init_(conn, "org.ayatana.bamf", "/org/ayatana/bamf/matcher")
	return obj
}

type matcher interface {
	GoXidsForApplication(flags dbus.Flags, ch chan *dbus.Call, desktop_file string) *dbus.Call
	XidsForApplication(flags dbus.Flags, desktop_file string) ([]uint32, error)
	GoTabPaths(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	TabPaths(flags dbus.Flags) ([]string, error)
	GoRunningApplications(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RunningApplications(flags dbus.Flags) ([]string, error)
	GoRunningApplicationsDesktopFiles(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RunningApplicationsDesktopFiles(flags dbus.Flags) ([]string, error)
	GoRegisterFavorites(flags dbus.Flags, ch chan *dbus.Call, favorites []string) *dbus.Call
	RegisterFavorites(flags dbus.Flags, favorites []string) error
	GoPathForApplication(flags dbus.Flags, ch chan *dbus.Call, desktop_file string) *dbus.Call
	PathForApplication(flags dbus.Flags, desktop_file string) (string, error)
	GoWindowPaths(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	WindowPaths(flags dbus.Flags) ([]string, error)
	GoApplicationPaths(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ApplicationPaths(flags dbus.Flags) ([]string, error)
	GoApplicationIsRunning(flags dbus.Flags, ch chan *dbus.Call, desktop_file string) *dbus.Call
	ApplicationIsRunning(flags dbus.Flags, desktop_file string) (bool, error)
	GoApplicationForXid(flags dbus.Flags, ch chan *dbus.Call, xid uint32) *dbus.Call
	ApplicationForXid(flags dbus.Flags, xid uint32) (string, error)
	GoActiveWindow(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ActiveWindow(flags dbus.Flags) (string, error)
	GoActiveApplication(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ActiveApplication(flags dbus.Flags) (string, error)
	GoWindowStackForMonitor(flags dbus.Flags, ch chan *dbus.Call, monitor_id int32) *dbus.Call
	WindowStackForMonitor(flags dbus.Flags, monitor_id int32) ([]string, error)
	ConnectActiveApplicationChanged(cb func(old_app string, new_app string)) (dbusutil.SignalHandlerId, error)
	ConnectActiveWindowChanged(cb func(old_win string, new_win string)) (dbusutil.SignalHandlerId, error)
	ConnectViewClosed(cb func(path string, type0 string)) (dbusutil.SignalHandlerId, error)
	ConnectViewOpened(cb func(path string, type0 string)) (dbusutil.SignalHandlerId, error)
	ConnectStackingOrderChanged(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectRunningApplicationsChanged(cb func(opened_desktop_files []string, closed_desktop_files []string)) (dbusutil.SignalHandlerId, error)
}

type interfaceMatcher struct{}

func (v *interfaceMatcher) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceMatcher) GetInterfaceName_() string {
	return "org.ayatana.bamf.matcher"
}

// method XidsForApplication

func (v *interfaceMatcher) GoXidsForApplication(flags dbus.Flags, ch chan *dbus.Call, desktop_file string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".XidsForApplication", flags, ch, desktop_file)
}

func (*interfaceMatcher) StoreXidsForApplication(call *dbus.Call) (xids []uint32, err error) {
	err = call.Store(&xids)
	return
}

func (v *interfaceMatcher) XidsForApplication(flags dbus.Flags, desktop_file string) ([]uint32, error) {
	return v.StoreXidsForApplication(
		<-v.GoXidsForApplication(flags, make(chan *dbus.Call, 1), desktop_file).Done)
}

// method TabPaths

func (v *interfaceMatcher) GoTabPaths(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TabPaths", flags, ch)
}

func (*interfaceMatcher) StoreTabPaths(call *dbus.Call) (paths []string, err error) {
	err = call.Store(&paths)
	return
}

func (v *interfaceMatcher) TabPaths(flags dbus.Flags) ([]string, error) {
	return v.StoreTabPaths(
		<-v.GoTabPaths(flags, make(chan *dbus.Call, 1)).Done)
}

// method RunningApplications

func (v *interfaceMatcher) GoRunningApplications(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RunningApplications", flags, ch)
}

func (*interfaceMatcher) StoreRunningApplications(call *dbus.Call) (paths []string, err error) {
	err = call.Store(&paths)
	return
}

func (v *interfaceMatcher) RunningApplications(flags dbus.Flags) ([]string, error) {
	return v.StoreRunningApplications(
		<-v.GoRunningApplications(flags, make(chan *dbus.Call, 1)).Done)
}

// method RunningApplicationsDesktopFiles

func (v *interfaceMatcher) GoRunningApplicationsDesktopFiles(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RunningApplicationsDesktopFiles", flags, ch)
}

func (*interfaceMatcher) StoreRunningApplicationsDesktopFiles(call *dbus.Call) (paths []string, err error) {
	err = call.Store(&paths)
	return
}

func (v *interfaceMatcher) RunningApplicationsDesktopFiles(flags dbus.Flags) ([]string, error) {
	return v.StoreRunningApplicationsDesktopFiles(
		<-v.GoRunningApplicationsDesktopFiles(flags, make(chan *dbus.Call, 1)).Done)
}

// method RegisterFavorites

func (v *interfaceMatcher) GoRegisterFavorites(flags dbus.Flags, ch chan *dbus.Call, favorites []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RegisterFavorites", flags, ch, favorites)
}

func (v *interfaceMatcher) RegisterFavorites(flags dbus.Flags, favorites []string) error {
	return (<-v.GoRegisterFavorites(flags, make(chan *dbus.Call, 1), favorites).Done).Err
}

// method PathForApplication

func (v *interfaceMatcher) GoPathForApplication(flags dbus.Flags, ch chan *dbus.Call, desktop_file string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PathForApplication", flags, ch, desktop_file)
}

func (*interfaceMatcher) StorePathForApplication(call *dbus.Call) (path string, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceMatcher) PathForApplication(flags dbus.Flags, desktop_file string) (string, error) {
	return v.StorePathForApplication(
		<-v.GoPathForApplication(flags, make(chan *dbus.Call, 1), desktop_file).Done)
}

// method WindowPaths

func (v *interfaceMatcher) GoWindowPaths(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".WindowPaths", flags, ch)
}

func (*interfaceMatcher) StoreWindowPaths(call *dbus.Call) (paths []string, err error) {
	err = call.Store(&paths)
	return
}

func (v *interfaceMatcher) WindowPaths(flags dbus.Flags) ([]string, error) {
	return v.StoreWindowPaths(
		<-v.GoWindowPaths(flags, make(chan *dbus.Call, 1)).Done)
}

// method ApplicationPaths

func (v *interfaceMatcher) GoApplicationPaths(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ApplicationPaths", flags, ch)
}

func (*interfaceMatcher) StoreApplicationPaths(call *dbus.Call) (paths []string, err error) {
	err = call.Store(&paths)
	return
}

func (v *interfaceMatcher) ApplicationPaths(flags dbus.Flags) ([]string, error) {
	return v.StoreApplicationPaths(
		<-v.GoApplicationPaths(flags, make(chan *dbus.Call, 1)).Done)
}

// method ApplicationIsRunning

func (v *interfaceMatcher) GoApplicationIsRunning(flags dbus.Flags, ch chan *dbus.Call, desktop_file string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ApplicationIsRunning", flags, ch, desktop_file)
}

func (*interfaceMatcher) StoreApplicationIsRunning(call *dbus.Call) (running bool, err error) {
	err = call.Store(&running)
	return
}

func (v *interfaceMatcher) ApplicationIsRunning(flags dbus.Flags, desktop_file string) (bool, error) {
	return v.StoreApplicationIsRunning(
		<-v.GoApplicationIsRunning(flags, make(chan *dbus.Call, 1), desktop_file).Done)
}

// method ApplicationForXid

func (v *interfaceMatcher) GoApplicationForXid(flags dbus.Flags, ch chan *dbus.Call, xid uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ApplicationForXid", flags, ch, xid)
}

func (*interfaceMatcher) StoreApplicationForXid(call *dbus.Call) (application string, err error) {
	err = call.Store(&application)
	return
}

func (v *interfaceMatcher) ApplicationForXid(flags dbus.Flags, xid uint32) (string, error) {
	return v.StoreApplicationForXid(
		<-v.GoApplicationForXid(flags, make(chan *dbus.Call, 1), xid).Done)
}

// method ActiveWindow

func (v *interfaceMatcher) GoActiveWindow(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ActiveWindow", flags, ch)
}

func (*interfaceMatcher) StoreActiveWindow(call *dbus.Call) (window string, err error) {
	err = call.Store(&window)
	return
}

func (v *interfaceMatcher) ActiveWindow(flags dbus.Flags) (string, error) {
	return v.StoreActiveWindow(
		<-v.GoActiveWindow(flags, make(chan *dbus.Call, 1)).Done)
}

// method ActiveApplication

func (v *interfaceMatcher) GoActiveApplication(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ActiveApplication", flags, ch)
}

func (*interfaceMatcher) StoreActiveApplication(call *dbus.Call) (application string, err error) {
	err = call.Store(&application)
	return
}

func (v *interfaceMatcher) ActiveApplication(flags dbus.Flags) (string, error) {
	return v.StoreActiveApplication(
		<-v.GoActiveApplication(flags, make(chan *dbus.Call, 1)).Done)
}

// method WindowStackForMonitor

func (v *interfaceMatcher) GoWindowStackForMonitor(flags dbus.Flags, ch chan *dbus.Call, monitor_id int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".WindowStackForMonitor", flags, ch, monitor_id)
}

func (*interfaceMatcher) StoreWindowStackForMonitor(call *dbus.Call) (window_list []string, err error) {
	err = call.Store(&window_list)
	return
}

func (v *interfaceMatcher) WindowStackForMonitor(flags dbus.Flags, monitor_id int32) ([]string, error) {
	return v.StoreWindowStackForMonitor(
		<-v.GoWindowStackForMonitor(flags, make(chan *dbus.Call, 1), monitor_id).Done)
}

// signal ActiveApplicationChanged

func (v *interfaceMatcher) ConnectActiveApplicationChanged(cb func(old_app string, new_app string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ActiveApplicationChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ActiveApplicationChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var old_app string
		var new_app string
		err := dbus.Store(sig.Body, &old_app, &new_app)
		if err == nil {
			cb(old_app, new_app)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ActiveWindowChanged

func (v *interfaceMatcher) ConnectActiveWindowChanged(cb func(old_win string, new_win string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ActiveWindowChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ActiveWindowChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var old_win string
		var new_win string
		err := dbus.Store(sig.Body, &old_win, &new_win)
		if err == nil {
			cb(old_win, new_win)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ViewClosed

func (v *interfaceMatcher) ConnectViewClosed(cb func(path string, type0 string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ViewClosed", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ViewClosed",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path string
		var type0 string
		err := dbus.Store(sig.Body, &path, &type0)
		if err == nil {
			cb(path, type0)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ViewOpened

func (v *interfaceMatcher) ConnectViewOpened(cb func(path string, type0 string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ViewOpened", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ViewOpened",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path string
		var type0 string
		err := dbus.Store(sig.Body, &path, &type0)
		if err == nil {
			cb(path, type0)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal StackingOrderChanged

func (v *interfaceMatcher) ConnectStackingOrderChanged(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "StackingOrderChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".StackingOrderChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal RunningApplicationsChanged

func (v *interfaceMatcher) ConnectRunningApplicationsChanged(cb func(opened_desktop_files []string, closed_desktop_files []string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "RunningApplicationsChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".RunningApplicationsChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var opened_desktop_files []string
		var closed_desktop_files []string
		err := dbus.Store(sig.Body, &opened_desktop_files, &closed_desktop_files)
		if err == nil {
			cb(opened_desktop_files, closed_desktop_files)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

type Application interface {
	Application() application // interface org.ayatana.bamf.application
	View() view               // interface org.ayatana.bamf.view
	proxy.Object
}

type objectApplication struct {
	interfaceApplication // interface org.ayatana.bamf.application
	interfaceView        // interface org.ayatana.bamf.view
	proxy.ImplObject
}

func NewApplication(conn *dbus.Conn, path dbus.ObjectPath) (Application, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectApplication)
	obj.ImplObject.Init_(conn, "org.ayatana.bamf", path)
	return obj, nil
}

func (obj *objectApplication) Application() application {
	return &obj.interfaceApplication
}

type application interface {
	GoShowStubs(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ShowStubs(flags dbus.Flags) (bool, error)
	GoXids(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Xids(flags dbus.Flags) ([]uint32, error)
	GoDesktopFile(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	DesktopFile(flags dbus.Flags) (string, error)
	GoSupportedMimeTypes(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	SupportedMimeTypes(flags dbus.Flags) ([]string, error)
	GoApplicationType(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ApplicationType(flags dbus.Flags) (string, error)
	GoApplicationMenu(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ApplicationMenu(flags dbus.Flags) (string, string, error)
	GoFocusableChild(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	FocusableChild(flags dbus.Flags) (string, error)
	ConnectWindowRemoved(cb func(path string)) (dbusutil.SignalHandlerId, error)
	ConnectWindowAdded(cb func(path string)) (dbusutil.SignalHandlerId, error)
	ConnectSupportedMimeTypesChanged(cb func(dnd_mimes []string)) (dbusutil.SignalHandlerId, error)
	ConnectDesktopFileUpdated(cb func(desktop_file string)) (dbusutil.SignalHandlerId, error)
}

type interfaceApplication struct{}

func (v *interfaceApplication) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceApplication) GetInterfaceName_() string {
	return "org.ayatana.bamf.application"
}

// method ShowStubs

func (v *interfaceApplication) GoShowStubs(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ShowStubs", flags, ch)
}

func (*interfaceApplication) StoreShowStubs(call *dbus.Call) (show_stubs bool, err error) {
	err = call.Store(&show_stubs)
	return
}

func (v *interfaceApplication) ShowStubs(flags dbus.Flags) (bool, error) {
	return v.StoreShowStubs(
		<-v.GoShowStubs(flags, make(chan *dbus.Call, 1)).Done)
}

// method Xids

func (v *interfaceApplication) GoXids(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Xids", flags, ch)
}

func (*interfaceApplication) StoreXids(call *dbus.Call) (xids []uint32, err error) {
	err = call.Store(&xids)
	return
}

func (v *interfaceApplication) Xids(flags dbus.Flags) ([]uint32, error) {
	return v.StoreXids(
		<-v.GoXids(flags, make(chan *dbus.Call, 1)).Done)
}

// method DesktopFile

func (v *interfaceApplication) GoDesktopFile(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DesktopFile", flags, ch)
}

func (*interfaceApplication) StoreDesktopFile(call *dbus.Call) (desktop_file string, err error) {
	err = call.Store(&desktop_file)
	return
}

func (v *interfaceApplication) DesktopFile(flags dbus.Flags) (string, error) {
	return v.StoreDesktopFile(
		<-v.GoDesktopFile(flags, make(chan *dbus.Call, 1)).Done)
}

// method SupportedMimeTypes

func (v *interfaceApplication) GoSupportedMimeTypes(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SupportedMimeTypes", flags, ch)
}

func (*interfaceApplication) StoreSupportedMimeTypes(call *dbus.Call) (mime_types []string, err error) {
	err = call.Store(&mime_types)
	return
}

func (v *interfaceApplication) SupportedMimeTypes(flags dbus.Flags) ([]string, error) {
	return v.StoreSupportedMimeTypes(
		<-v.GoSupportedMimeTypes(flags, make(chan *dbus.Call, 1)).Done)
}

// method ApplicationType

func (v *interfaceApplication) GoApplicationType(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ApplicationType", flags, ch)
}

func (*interfaceApplication) StoreApplicationType(call *dbus.Call) (type0 string, err error) {
	err = call.Store(&type0)
	return
}

func (v *interfaceApplication) ApplicationType(flags dbus.Flags) (string, error) {
	return v.StoreApplicationType(
		<-v.GoApplicationType(flags, make(chan *dbus.Call, 1)).Done)
}

// method ApplicationMenu

func (v *interfaceApplication) GoApplicationMenu(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ApplicationMenu", flags, ch)
}

func (*interfaceApplication) StoreApplicationMenu(call *dbus.Call) (busname string, objectpath string, err error) {
	err = call.Store(&busname, &objectpath)
	return
}

func (v *interfaceApplication) ApplicationMenu(flags dbus.Flags) (string, string, error) {
	return v.StoreApplicationMenu(
		<-v.GoApplicationMenu(flags, make(chan *dbus.Call, 1)).Done)
}

// method FocusableChild

func (v *interfaceApplication) GoFocusableChild(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".FocusableChild", flags, ch)
}

func (*interfaceApplication) StoreFocusableChild(call *dbus.Call) (path string, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceApplication) FocusableChild(flags dbus.Flags) (string, error) {
	return v.StoreFocusableChild(
		<-v.GoFocusableChild(flags, make(chan *dbus.Call, 1)).Done)
}

// signal WindowRemoved

func (v *interfaceApplication) ConnectWindowRemoved(cb func(path string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "WindowRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".WindowRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path string
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal WindowAdded

func (v *interfaceApplication) ConnectWindowAdded(cb func(path string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "WindowAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".WindowAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path string
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SupportedMimeTypesChanged

func (v *interfaceApplication) ConnectSupportedMimeTypesChanged(cb func(dnd_mimes []string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SupportedMimeTypesChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SupportedMimeTypesChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var dnd_mimes []string
		err := dbus.Store(sig.Body, &dnd_mimes)
		if err == nil {
			cb(dnd_mimes)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal DesktopFileUpdated

func (v *interfaceApplication) ConnectDesktopFileUpdated(cb func(desktop_file string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DesktopFileUpdated", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DesktopFileUpdated",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var desktop_file string
		err := dbus.Store(sig.Body, &desktop_file)
		if err == nil {
			cb(desktop_file)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

func (obj *objectApplication) View() view {
	return &obj.interfaceView
}

type view interface {
	GoViewType(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ViewType(flags dbus.Flags) (string, error)
	GoIcon(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Icon(flags dbus.Flags) (string, error)
	GoName(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Name(flags dbus.Flags) (string, error)
	GoUserVisible(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	UserVisible(flags dbus.Flags) (bool, error)
	GoIsUrgent(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsUrgent(flags dbus.Flags) (bool, error)
	GoIsRunning(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsRunning(flags dbus.Flags) (bool, error)
	GoIsActive(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	IsActive(flags dbus.Flags) (bool, error)
	GoParents(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Parents(flags dbus.Flags) ([]string, error)
	GoChildren(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Children(flags dbus.Flags) ([]string, error)
	ConnectNameChanged(cb func(old_name string, new_name string)) (dbusutil.SignalHandlerId, error)
	ConnectUserVisibleChanged(cb func(user_visible bool)) (dbusutil.SignalHandlerId, error)
	ConnectUrgentChanged(cb func(is_urgent bool)) (dbusutil.SignalHandlerId, error)
	ConnectRunningChanged(cb func(is_running bool)) (dbusutil.SignalHandlerId, error)
	ConnectActiveChanged(cb func(is_active bool)) (dbusutil.SignalHandlerId, error)
	ConnectChildRemoved(cb func(path string)) (dbusutil.SignalHandlerId, error)
	ConnectChildAdded(cb func(path string)) (dbusutil.SignalHandlerId, error)
	ConnectClosed(cb func()) (dbusutil.SignalHandlerId, error)
	PropName() proxy.PropString
	PropIcon() proxy.PropString
	PropUserVisible() proxy.PropBool
	Running() proxy.PropBool
	Starting() proxy.PropBool
	Urgent() proxy.PropBool
	Active() proxy.PropBool
}

type interfaceView struct{}

func (v *interfaceView) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceView) GetInterfaceName_() string {
	return "org.ayatana.bamf.view"
}

// method ViewType

func (v *interfaceView) GoViewType(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ViewType", flags, ch)
}

func (*interfaceView) StoreViewType(call *dbus.Call) (view_type string, err error) {
	err = call.Store(&view_type)
	return
}

func (v *interfaceView) ViewType(flags dbus.Flags) (string, error) {
	return v.StoreViewType(
		<-v.GoViewType(flags, make(chan *dbus.Call, 1)).Done)
}

// method Icon

func (v *interfaceView) GoIcon(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Icon", flags, ch)
}

func (*interfaceView) StoreIcon(call *dbus.Call) (name string, err error) {
	err = call.Store(&name)
	return
}

func (v *interfaceView) Icon(flags dbus.Flags) (string, error) {
	return v.StoreIcon(
		<-v.GoIcon(flags, make(chan *dbus.Call, 1)).Done)
}

// method Name

func (v *interfaceView) GoName(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Name", flags, ch)
}

func (*interfaceView) StoreName(call *dbus.Call) (name string, err error) {
	err = call.Store(&name)
	return
}

func (v *interfaceView) Name(flags dbus.Flags) (string, error) {
	return v.StoreName(
		<-v.GoName(flags, make(chan *dbus.Call, 1)).Done)
}

// method UserVisible

func (v *interfaceView) GoUserVisible(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UserVisible", flags, ch)
}

func (*interfaceView) StoreUserVisible(call *dbus.Call) (visible bool, err error) {
	err = call.Store(&visible)
	return
}

func (v *interfaceView) UserVisible(flags dbus.Flags) (bool, error) {
	return v.StoreUserVisible(
		<-v.GoUserVisible(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsUrgent

func (v *interfaceView) GoIsUrgent(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsUrgent", flags, ch)
}

func (*interfaceView) StoreIsUrgent(call *dbus.Call) (urgent bool, err error) {
	err = call.Store(&urgent)
	return
}

func (v *interfaceView) IsUrgent(flags dbus.Flags) (bool, error) {
	return v.StoreIsUrgent(
		<-v.GoIsUrgent(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsRunning

func (v *interfaceView) GoIsRunning(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsRunning", flags, ch)
}

func (*interfaceView) StoreIsRunning(call *dbus.Call) (running bool, err error) {
	err = call.Store(&running)
	return
}

func (v *interfaceView) IsRunning(flags dbus.Flags) (bool, error) {
	return v.StoreIsRunning(
		<-v.GoIsRunning(flags, make(chan *dbus.Call, 1)).Done)
}

// method IsActive

func (v *interfaceView) GoIsActive(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsActive", flags, ch)
}

func (*interfaceView) StoreIsActive(call *dbus.Call) (active bool, err error) {
	err = call.Store(&active)
	return
}

func (v *interfaceView) IsActive(flags dbus.Flags) (bool, error) {
	return v.StoreIsActive(
		<-v.GoIsActive(flags, make(chan *dbus.Call, 1)).Done)
}

// method Parents

func (v *interfaceView) GoParents(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Parents", flags, ch)
}

func (*interfaceView) StoreParents(call *dbus.Call) (parents_paths []string, err error) {
	err = call.Store(&parents_paths)
	return
}

func (v *interfaceView) Parents(flags dbus.Flags) ([]string, error) {
	return v.StoreParents(
		<-v.GoParents(flags, make(chan *dbus.Call, 1)).Done)
}

// method Children

func (v *interfaceView) GoChildren(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Children", flags, ch)
}

func (*interfaceView) StoreChildren(call *dbus.Call) (children_paths []string, err error) {
	err = call.Store(&children_paths)
	return
}

func (v *interfaceView) Children(flags dbus.Flags) ([]string, error) {
	return v.StoreChildren(
		<-v.GoChildren(flags, make(chan *dbus.Call, 1)).Done)
}

// signal NameChanged

func (v *interfaceView) ConnectNameChanged(cb func(old_name string, new_name string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "NameChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".NameChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var old_name string
		var new_name string
		err := dbus.Store(sig.Body, &old_name, &new_name)
		if err == nil {
			cb(old_name, new_name)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal UserVisibleChanged

func (v *interfaceView) ConnectUserVisibleChanged(cb func(user_visible bool)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "UserVisibleChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".UserVisibleChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var user_visible bool
		err := dbus.Store(sig.Body, &user_visible)
		if err == nil {
			cb(user_visible)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal UrgentChanged

func (v *interfaceView) ConnectUrgentChanged(cb func(is_urgent bool)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "UrgentChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".UrgentChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var is_urgent bool
		err := dbus.Store(sig.Body, &is_urgent)
		if err == nil {
			cb(is_urgent)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal RunningChanged

func (v *interfaceView) ConnectRunningChanged(cb func(is_running bool)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "RunningChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".RunningChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var is_running bool
		err := dbus.Store(sig.Body, &is_running)
		if err == nil {
			cb(is_running)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ActiveChanged

func (v *interfaceView) ConnectActiveChanged(cb func(is_active bool)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ActiveChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ActiveChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var is_active bool
		err := dbus.Store(sig.Body, &is_active)
		if err == nil {
			cb(is_active)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ChildRemoved

func (v *interfaceView) ConnectChildRemoved(cb func(path string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ChildRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ChildRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path string
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ChildAdded

func (v *interfaceView) ConnectChildAdded(cb func(path string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ChildAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ChildAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path string
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Closed

func (v *interfaceView) ConnectClosed(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Closed", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Closed",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Name s

func (v *interfaceView) PropName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property Icon s

func (v *interfaceView) PropIcon() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Icon",
	}
}

// property UserVisible b

func (v *interfaceView) PropUserVisible() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "UserVisible",
	}
}

// property Running b

func (v *interfaceView) Running() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Running",
	}
}

// property Starting b

func (v *interfaceView) Starting() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Starting",
	}
}

// property Urgent b

func (v *interfaceView) Urgent() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Urgent",
	}
}

// property Active b

func (v *interfaceView) Active() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Active",
	}
}

type Window interface {
	Window() window // interface org.ayatana.bamf.window
	View() view     // interface org.ayatana.bamf.view
	proxy.Object
}

type objectWindow struct {
	interfaceWindow // interface org.ayatana.bamf.window
	interfaceView   // interface org.ayatana.bamf.view
	proxy.ImplObject
}

func NewWindow(conn *dbus.Conn, path dbus.ObjectPath) (Window, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectWindow)
	obj.ImplObject.Init_(conn, "org.ayatana.bamf", path)
	return obj, nil
}

func (obj *objectWindow) Window() window {
	return &obj.interfaceWindow
}

type window interface {
	GoGetXid(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetXid(flags dbus.Flags) (uint32, error)
	GoGetPid(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetPid(flags dbus.Flags) (uint32, error)
	GoTransient(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Transient(flags dbus.Flags) (string, error)
	GoWindowType(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	WindowType(flags dbus.Flags) (uint32, error)
	GoXprop(flags dbus.Flags, ch chan *dbus.Call, xprop string) *dbus.Call
	Xprop(flags dbus.Flags, xprop string) (string, error)
	GoMonitor(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Monitor(flags dbus.Flags) (int32, error)
	GoMaximized(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Maximized(flags dbus.Flags) (int32, error)
	ConnectMonitorChanged(cb func(old int32, new int32)) (dbusutil.SignalHandlerId, error)
	ConnectMaximizedChanged(cb func(old int32, new int32)) (dbusutil.SignalHandlerId, error)
}

type interfaceWindow struct{}

func (v *interfaceWindow) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceWindow) GetInterfaceName_() string {
	return "org.ayatana.bamf.window"
}

// method GetXid

func (v *interfaceWindow) GoGetXid(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetXid", flags, ch)
}

func (*interfaceWindow) StoreGetXid(call *dbus.Call) (xid uint32, err error) {
	err = call.Store(&xid)
	return
}

func (v *interfaceWindow) GetXid(flags dbus.Flags) (uint32, error) {
	return v.StoreGetXid(
		<-v.GoGetXid(flags, make(chan *dbus.Call, 1)).Done)
}

// method GetPid

func (v *interfaceWindow) GoGetPid(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetPid", flags, ch)
}

func (*interfaceWindow) StoreGetPid(call *dbus.Call) (pid uint32, err error) {
	err = call.Store(&pid)
	return
}

func (v *interfaceWindow) GetPid(flags dbus.Flags) (uint32, error) {
	return v.StoreGetPid(
		<-v.GoGetPid(flags, make(chan *dbus.Call, 1)).Done)
}

// method Transient

func (v *interfaceWindow) GoTransient(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Transient", flags, ch)
}

func (*interfaceWindow) StoreTransient(call *dbus.Call) (path string, err error) {
	err = call.Store(&path)
	return
}

func (v *interfaceWindow) Transient(flags dbus.Flags) (string, error) {
	return v.StoreTransient(
		<-v.GoTransient(flags, make(chan *dbus.Call, 1)).Done)
}

// method WindowType

func (v *interfaceWindow) GoWindowType(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".WindowType", flags, ch)
}

func (*interfaceWindow) StoreWindowType(call *dbus.Call) (type0 uint32, err error) {
	err = call.Store(&type0)
	return
}

func (v *interfaceWindow) WindowType(flags dbus.Flags) (uint32, error) {
	return v.StoreWindowType(
		<-v.GoWindowType(flags, make(chan *dbus.Call, 1)).Done)
}

// method Xprop

func (v *interfaceWindow) GoXprop(flags dbus.Flags, ch chan *dbus.Call, xprop string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Xprop", flags, ch, xprop)
}

func (*interfaceWindow) StoreXprop(call *dbus.Call) (name string, err error) {
	err = call.Store(&name)
	return
}

func (v *interfaceWindow) Xprop(flags dbus.Flags, xprop string) (string, error) {
	return v.StoreXprop(
		<-v.GoXprop(flags, make(chan *dbus.Call, 1), xprop).Done)
}

// method Monitor

func (v *interfaceWindow) GoMonitor(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Monitor", flags, ch)
}

func (*interfaceWindow) StoreMonitor(call *dbus.Call) (monitor_number int32, err error) {
	err = call.Store(&monitor_number)
	return
}

func (v *interfaceWindow) Monitor(flags dbus.Flags) (int32, error) {
	return v.StoreMonitor(
		<-v.GoMonitor(flags, make(chan *dbus.Call, 1)).Done)
}

// method Maximized

func (v *interfaceWindow) GoMaximized(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Maximized", flags, ch)
}

func (*interfaceWindow) StoreMaximized(call *dbus.Call) (maximized int32, err error) {
	err = call.Store(&maximized)
	return
}

func (v *interfaceWindow) Maximized(flags dbus.Flags) (int32, error) {
	return v.StoreMaximized(
		<-v.GoMaximized(flags, make(chan *dbus.Call, 1)).Done)
}

// signal MonitorChanged

func (v *interfaceWindow) ConnectMonitorChanged(cb func(old int32, new int32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "MonitorChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".MonitorChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var old int32
		var new int32
		err := dbus.Store(sig.Body, &old, &new)
		if err == nil {
			cb(old, new)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal MaximizedChanged

func (v *interfaceWindow) ConnectMaximizedChanged(cb func(old int32, new int32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "MaximizedChanged", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".MaximizedChanged",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var old int32
		var new int32
		err := dbus.Store(sig.Body, &old, &new)
		if err == nil {
			cb(old, new)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

func (obj *objectWindow) View() view {
	return &obj.interfaceView
}
