/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.imports.AbstractImportControl;
import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;
import com.puppycrawl.tools.checkstyle.checks.imports.ImportControlLoader;
import com.puppycrawl.tools.checkstyle.checks.imports.PkgImportControl;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;

@FileStatefulCheck
public class ImportControlCheck
extends AbstractCheck
implements ExternalResourceHolder {
    public static final String MSG_MISSING_FILE = "import.control.missing.file";
    public static final String MSG_UNKNOWN_PKG = "import.control.unknown.pkg";
    public static final String MSG_DISALLOWED = "import.control.disallowed";
    private static final String UNABLE_TO_LOAD = "Unable to load ";
    private URI file;
    private Pattern path = Pattern.compile(".*");
    private boolean processCurrentFile;
    private PkgImportControl root;
    private String packageName;
    private String fileName;
    private AbstractImportControl currentImportControl;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{16, 30, 152};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.currentImportControl = null;
        this.processCurrentFile = this.path.matcher(this.getFilePath()).find();
        this.fileName = this.getFileContents().getText().getFile().getName();
        int period = this.fileName.lastIndexOf(46);
        if (period != -1) {
            this.fileName = this.fileName.substring(0, period);
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.processCurrentFile) {
            String importText;
            AccessResult access;
            if (ast.getType() == 16) {
                if (this.root == null) {
                    this.log(ast, MSG_MISSING_FILE, new Object[0]);
                } else {
                    this.packageName = ImportControlCheck.getPackageText(ast);
                    this.currentImportControl = this.root.locateFinest(this.packageName, this.fileName);
                    if (this.currentImportControl == null) {
                        this.log(ast, MSG_UNKNOWN_PKG, new Object[0]);
                    }
                }
            } else if (this.currentImportControl != null && (access = this.currentImportControl.checkAccess(this.packageName, this.fileName, importText = ImportControlCheck.getImportText(ast))) != AccessResult.ALLOWED) {
                this.log(ast, MSG_DISALLOWED, importText);
            }
        }
    }

    @Override
    public Set<String> getExternalResourceLocations() {
        return Collections.singleton(this.file.toString());
    }

    private static String getPackageText(DetailAST ast) {
        DetailAST nameAST = ast.getLastChild().getPreviousSibling();
        return FullIdent.createFullIdent(nameAST).getText();
    }

    private static String getImportText(DetailAST ast) {
        FullIdent imp = ast.getType() == 30 ? FullIdent.createFullIdentBelow(ast) : FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
        return imp.getText();
    }

    public void setFile(URI uri) {
        if (uri != null) {
            try {
                this.root = ImportControlLoader.load(uri);
                this.file = uri;
            }
            catch (CheckstyleException ex) {
                throw new IllegalArgumentException(UNABLE_TO_LOAD + uri, ex);
            }
        }
    }

    public void setPath(Pattern pattern) {
        this.path = pattern;
    }
}

