// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef LLAMAMODELWRAPPER_H
#define LLAMAMODELWRAPPER_H

#include "modelproxy.h"

#include <QString>
#include <QVariantHash>

class llama_model;
class gpt_params;
class llama_context;

GLOBAL_BEGIN_NAMESPACE

class LlamaModelWrapper
{
public:
    explicit LlamaModelWrapper();
    virtual ~LlamaModelWrapper();

    virtual bool initialize(const QString &bin, const QVariantHash &params);
protected:
    llama_model *gModel = nullptr;
    gpt_params *gParams = nullptr;
    llama_context *gCtx = nullptr;
};

GLOBAL_END_NAMESPACE

#endif // LLAMAMODELWRAPPER_H
