/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.emboss.jemboss.gui.form.JembossComboPopup;
import org.emboss.jemboss.gui.form.PlafMacros;
import org.emboss.jemboss.parser.ParseAcd;

public class AlignFormat {
    private static String[] align_msf = new String[]{"unknown", "multiple", "simple", "fasta", "msf", "srs"};
    private static String[] align_pairwise = new String[]{"unknown", "multiple", "simple", "fasta", "msf", "srs", "pair", "markx0", "markx1", "markx2", "markx3", "markx10", "srspair", "score"};
    private JembossComboPopup cp;
    private String def;
    private boolean lpair;

    public AlignFormat(ParseAcd parseAcd, int nf) {
        this.lpair = this.isPairWise(parseAcd, nf);
        this.cp = new JembossComboPopup(this.getAlignFormats(this.lpair));
        int np = parseAcd.getNumofParams(nf);
        for (int i = 0; i < np; ++i) {
            if (!parseAcd.getParameterAttribute(nf, i).equals("aformat")) continue;
            this.def = parseAcd.getParamValueStr(nf, i).toLowerCase();
            this.cp.setSelectedItem(this.def);
        }
        Dimension d = this.cp.getPreferredSize();
        d = new Dimension(150, (int)d.getHeight());
        this.cp.setMaximumSize(d);
        this.cp.setPreferredSize(d);
    }

    public AlignFormat(String def, boolean lpair) {
        this.def = def;
        this.lpair = lpair;
        this.cp = new JembossComboPopup(this.getAlignFormats(lpair));
        this.cp.setSelectedItem(def);
        Dimension d = this.cp.getPreferredSize();
        d = new Dimension(150, (int)d.getHeight());
        this.cp.setMaximumSize(d);
        this.cp.setPreferredSize(d);
    }

    public JembossComboPopup getComboPopup() {
        return this.cp;
    }

    public String getDefaultFormat() {
        return this.def;
    }

    private String[] getAlignFormats(boolean lpair) {
        if (lpair) {
            return align_pairwise;
        }
        return align_msf;
    }

    public String getAlignFormat() {
        String report = " -aformat " + this.cp.getSelectedItem();
        return report;
    }

    public List getAlignFormatA() {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add("-aformat");
        ret.add(this.cp.getSelectedItem());
        return ret;
    }

    private boolean isPairWise(ParseAcd parseAcd, int nf) {
        for (int i = 0; i < nf; ++i) {
            if (!parseAcd.getParameterAttribute(i, 0).equalsIgnoreCase("seqset")) continue;
            return false;
        }
        return true;
    }

    public String getToolTip() {
        String ls = PlafMacros.getLineSeparator();
        String commonFormat = "unknown - synonym for simple format." + ls + "multiple - synonym for simple format." + ls + "simple - displays the sequence names and positions and" + ls + "puts the markup line underneath the sequences." + ls + "fasta - Fasta sequence format with gaps" + ls + "msf - MSF sequence format." + ls + "srs - shows the sequence ID name and position." + ls;
        if (this.lpair) {
            return commonFormat + ls + "pair - default format used with only 2 sequences." + ls + "markx0 - default output format for FASTA programs." + ls + "markx1 - alternative format for FASTA programs in which" + ls + "identities are not marked. Conservative replacements are" + ls + "denoted by 'x' and non-conservative substitutions by 'X'." + ls + "markx2 - alternative format for FASTA programs in which" + ls + "residues in the second sequence are only shown if they" + ls + "are different from the first." + ls + "markx3 - alternative format for FASTA programs in which" + ls + "the sequences are displayed in FASTA format. These can" + ls + "be used to build a primitive multiple alignment." + ls + "markx10 - alternative format for FASTA programs in which" + ls + "the sequences are displayed in FASTA format and the" + ls + "sequence length, alignment start and stop is given in" + ls + "in lines starting with a semi colon after the title line" + ls + "srspair - similar in style to pair format." + ls + "score - does not display the sequence alignment. Only" + ls + "shows names of the sequences, length of the alignment and" + ls + "the score in brackets.";
        }
        return commonFormat;
    }
}

