/*

   The WebDruid languages strings constant

*/

/* lib gettext */
#include <libintl.h>
#include <locale.h>

#define _(String) gettext (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

/* Help display... */
char *h_msg[]= {
         gettext_noop("-h        = print this help message")             ,
         gettext_noop("-v -V     = print version information")           ,
         gettext_noop("-d        = print additional debug info")         ,
         gettext_noop("-F type   = Log type.  type = (clf | w3c)"),
         gettext_noop("-f        = Fold sequence errors")                ,
         gettext_noop("-i        = ignore history file")                 ,
         gettext_noop("-p        = preserve state (incremental)")        ,
         gettext_noop("-q        = supress informational messages")      ,
         gettext_noop("-Q        = supress _ALL_ messages")              ,
         gettext_noop("-Y        = supress country graph")               ,
         gettext_noop("-G        = supress hourly graph")                ,
         gettext_noop("-H        = supress hourly stats")                ,
         gettext_noop("-L        = supress color coded graph legends")   ,
         gettext_noop("-l num    = use num background lines on graph")   ,
         gettext_noop("-m num    = Visit timout value (seconds)")        ,
         gettext_noop("-T        = print timing information")            ,
         gettext_noop("-c file   = use configuration file 'file'")       ,
         gettext_noop("-n name   = hostname to use")                     ,
         gettext_noop("-o dir    = output directory to use")             ,
         gettext_noop("-t name   = report title 'name'")                 ,
         gettext_noop("-a name   = hide user agent 'name'")              ,
         gettext_noop("-r name   = hide referrer 'name'")                ,
         gettext_noop("-s name   = hide site 'name'")                    ,
         gettext_noop("-u name   = hide URL 'name'")                     ,
         gettext_noop("-x name   = Use filename extension 'name'")       ,
         gettext_noop("-P name   = Page type extension 'name'")          ,
         gettext_noop("-I name   = Index alias 'name'")                  ,
         gettext_noop("-A num    = Display num top agents")              ,
         gettext_noop("-C num    = Display num top countries")           ,
         gettext_noop("-R num    = Display num top referrers")           ,
         gettext_noop("-S num    = Display num top sites")               ,
         gettext_noop("-U num    = Display num top URLs")                ,
         gettext_noop("-e num    = Display num top Entry Pages")         ,
         gettext_noop("-E num    = Display num top Exit Pages")          ,
         gettext_noop("-g num    = Group Domains to 'num' levels")       ,
         gettext_noop("-X        = Hide individual sites")               ,
         gettext_noop("-D name   = Use DNS Cache file 'name'")           ,
         gettext_noop("-N num    = Number of DNS processes (0=disable)") ,
         NULL};

/* short month names MUST BE 3 CHARS in size... pad if needed*/
char *s_month[12]={ gettext_noop("Jan"), gettext_noop("Feb"), gettext_noop("Mar"),
                    gettext_noop("Apr"), gettext_noop("May"), gettext_noop("Jun"),
                    gettext_noop("Jul"), gettext_noop("Aug"), gettext_noop("Sep"),
                    gettext_noop("Oct"), gettext_noop("Nov"), gettext_noop("Dec")};

/* long month names - can be any length */
char *l_month[12]={ gettext_noop("January"),  gettext_noop("February"), gettext_noop("March"),   gettext_noop("April"),
                    gettext_noop("May"),      gettext_noop("June"),     gettext_noop("July"),    gettext_noop("August"),
                    gettext_noop("September"),gettext_noop("October"),  gettext_noop("November"),gettext_noop("December")};

/* response code descriptions... order IS important!      */
struct response_code response[] =
       { { gettext_noop("Undefined response code"),                    0 },
         { gettext_noop("Code 100 - Continue"),                        0 },
         { gettext_noop("Code 101 - Switching Protocols"),             0 },
         { gettext_noop("Code 200 - OK"),                              0 },
         { gettext_noop("Code 201 - Created"),                         0 },
         { gettext_noop("Code 202 - Accepted"),                        0 },
         { gettext_noop("Code 203 - Non-Authoritative Information"),   0 },
         { gettext_noop("Code 204 - No Content"),                      0 },
         { gettext_noop("Code 205 - Reset Content"),                   0 },
         { gettext_noop("Code 206 - Partial Content"),                 0 },
         { gettext_noop("Code 300 - Multiple Choices"),                0 },
         { gettext_noop("Code 301 - Moved Permanently"),               0 },
         { gettext_noop("Code 302 - Found"),                           0 },
         { gettext_noop("Code 303 - See Other"),                       0 },
         { gettext_noop("Code 304 - Not Modified"),                    0 },
         { gettext_noop("Code 305 - Use Proxy"),                       0 },
         { gettext_noop("Code 307 - Moved Temporarily"),               0 },
         { gettext_noop("Code 400 - Bad Request"),                     0 },
         { gettext_noop("Code 401 - Unauthorized"),                    0 },
         { gettext_noop("Code 402 - Payment Required"),                0 },
         { gettext_noop("Code 403 - Forbidden"),                       0 },
         { gettext_noop("Code 404 - Not Found"),                       0 },
         { gettext_noop("Code 405 - Method Not Allowed"),              0 },
         { gettext_noop("Code 406 - Not Acceptable"),                  0 },
         { gettext_noop("Code 407 - Proxy Authentication Required"),   0 },
         { gettext_noop("Code 408 - Request Timeout"),                 0 },
         { gettext_noop("Code 409 - Conflict"),                        0 },
         { gettext_noop("Code 410 - Gone"),                            0 },
         { gettext_noop("Code 411 - Length Required"),                 0 },
         { gettext_noop("Code 412 - Precondition Failed"),             0 },
         { gettext_noop("Code 413 - Request Entity Too Large"),        0 },
         { gettext_noop("Code 414 - Request-URI Too Long"),            0 },
         { gettext_noop("Code 415 - Unsupported Media Type"),          0 },
         { gettext_noop("Code 416 - Requested Range Not Satisfiable"), 0 },
         { gettext_noop("Code 417 - Expectation Failed"),              0 },
         { gettext_noop("Code 500 - Internal Server Error"),           0 },
         { gettext_noop("Code 501 - Not Implemented"),                 0 },
         { gettext_noop("Code 502 - Bad Gateway"),                     0 },
         { gettext_noop("Code 503 - Service Unavailable"),             0 },
         { gettext_noop("Code 504 - Gateway Timeout"),                 0 },
         { gettext_noop("Code 505 - HTTP Version Not Supported"),      0 } };

char *msg_title   = gettext_noop("Usage Statistics for");
char *msg_h_other = gettext_noop("Other");

/* Country codes (previously in ctry.h header file) */

struct  country_code ctry[] = {
{ 0,                      gettext_noop("Unresolved/Unknown"),               0,0,0 },
{ IDX_3C('c','o','m'),    gettext_noop("US Commercial"),                    0,0,0 },
{ IDX_3C('e','d','u'),    gettext_noop("US Educational"),                   0,0,0 },
{ IDX_3C('g','o','v'),    gettext_noop("US Government"),                    0,0,0 },
{ IDX_3C('i','n','t'),    gettext_noop("International (int)"),              0,0,0 },
{ IDX_3C('m','i','l'),    gettext_noop("US Military"),                      0,0,0 },
{ IDX_3C('n','e','t'),    gettext_noop("Network"),                          0,0,0 },
{ IDX_3C('o','r','g'),    gettext_noop("Non-Profit Organization"),          0,0,0 },
{ IDX_4C('a','r','p','a'),gettext_noop("Old style Arpanet (arpa)"),         0,0,0 },
{ IDX_4C('n','a','t','o'),gettext_noop("Nato field (nato)"),                0,0,0 },
{ IDX_2C('a','d'),        gettext_noop("Andorra"),                          0,0,0 },
{ IDX_2C('a','e'),        gettext_noop("United Arab Emirates"),             0,0,0 },
{ IDX_2C('a','f'),        gettext_noop("Afghanistan"),                      0,0,0 },
{ IDX_2C('a','g'),        gettext_noop("Antigua and Barbuda"),              0,0,0 },
{ IDX_2C('a','i'),        gettext_noop("Anguilla"),                         0,0,0 },
{ IDX_2C('a','l'),        gettext_noop("Albania"),                          0,0,0 },
{ IDX_2C('a','m'),        gettext_noop("Armenia"),                          0,0,0 },
{ IDX_2C('a','n'),        gettext_noop("Netherlands Antilles"),             0,0,0 },
{ IDX_2C('a','o'),        gettext_noop("Angola"),                           0,0,0 },
{ IDX_2C('a','q'),        gettext_noop("Antarctica"),                       0,0,0 },
{ IDX_2C('a','r'),        gettext_noop("Argentina"),                        0,0,0 },
{ IDX_2C('a','s'),        gettext_noop("American Samoa"),                   0,0,0 },
{ IDX_2C('a','t'),        gettext_noop("Austria"),                          0,0,0 },
{ IDX_2C('a','u'),        gettext_noop("Australia"),                        0,0,0 },
{ IDX_2C('a','w'),        gettext_noop("Aruba"),                            0,0,0 },
{ IDX_2C('a','z'),        gettext_noop("Azerbaijan"),                       0,0,0 },
{ IDX_2C('b','a'),        gettext_noop("Bosnia and Herzegovina"),           0,0,0 },
{ IDX_2C('b','b'),        gettext_noop("Barbados"),                         0,0,0 },
{ IDX_2C('b','d'),        gettext_noop("Bangladesh"),                       0,0,0 },
{ IDX_2C('b','e'),        gettext_noop("Belgium"),                          0,0,0 },
{ IDX_2C('b','f'),        gettext_noop("Burkina Faso"),                     0,0,0 },
{ IDX_2C('b','g'),        gettext_noop("Bulgaria"),                         0,0,0 },
{ IDX_2C('b','h'),        gettext_noop("Bahrain"),                          0,0,0 },
{ IDX_2C('b','i'),        gettext_noop("Burundi"),                          0,0,0 },
{ IDX_2C('b','j'),        gettext_noop("Benin"),                            0,0,0 },
{ IDX_2C('b','m'),        gettext_noop("Bermuda"),                          0,0,0 },
{ IDX_2C('b','n'),        gettext_noop("Brunei Darussalam"),                0,0,0 },
{ IDX_2C('b','o'),        gettext_noop("Bolivia"),                          0,0,0 },
{ IDX_2C('b','r'),        gettext_noop("Brazil"),                           0,0,0 },
{ IDX_2C('b','s'),        gettext_noop("Bahamas"),                          0,0,0 },
{ IDX_2C('b','t'),        gettext_noop("Bhutan"),                           0,0,0 },
{ IDX_2C('b','v'),        gettext_noop("Bouvet Island"),                    0,0,0 },
{ IDX_2C('b','w'),        gettext_noop("Botswana"),                         0,0,0 },
{ IDX_2C('b','y'),        gettext_noop("Belarus"),                          0,0,0 },
{ IDX_2C('b','z'),        gettext_noop("Belize"),                           0,0,0 },
{ IDX_2C('c','a'),        gettext_noop("Canada"),                           0,0,0 },
{ IDX_2C('c','c'),        gettext_noop("Cocos (Keeling) Islands"),          0,0,0 },
{ IDX_2C('c','f'),        gettext_noop("Central African Republic"),         0,0,0 },
{ IDX_2C('c','g'),        gettext_noop("Congo"),                            0,0,0 },
{ IDX_2C('c','h'),        gettext_noop("Switzerland"),                      0,0,0 },
{ IDX_2C('c','i'),        gettext_noop("Cote D'Ivoire (Ivory Coast)"),      0,0,0 },
{ IDX_2C('c','k'),        gettext_noop("Cook Islands"),                     0,0,0 },
{ IDX_2C('c','l'),        gettext_noop("Chile"),                            0,0,0 },
{ IDX_2C('c','m'),        gettext_noop("Cameroon"),                         0,0,0 },
{ IDX_2C('c','n'),        gettext_noop("China"),                            0,0,0 },
{ IDX_2C('c','o'),        gettext_noop("Colombia"),                         0,0,0 },
{ IDX_2C('c','r'),        gettext_noop("Costa Rica"),                       0,0,0 },
{ IDX_2C('c','s'),        gettext_noop("Czechoslovakia (former)"),          0,0,0 },
{ IDX_2C('c','u'),        gettext_noop("Cuba"),                             0,0,0 },
{ IDX_2C('c','v'),        gettext_noop("Cape Verde"),                       0,0,0 },
{ IDX_2C('c','x'),        gettext_noop("Christmas Island"),                 0,0,0 },
{ IDX_2C('c','y'),        gettext_noop("Cyprus"),                           0,0,0 },
{ IDX_2C('c','z'),        gettext_noop("Czech Republic"),                   0,0,0 },
{ IDX_2C('d','e'),        gettext_noop("Germany"),                          0,0,0 },
{ IDX_2C('d','j'),        gettext_noop("Djibouti"),                         0,0,0 },
{ IDX_2C('d','k'),        gettext_noop("Denmark"),                          0,0,0 },
{ IDX_2C('d','m'),        gettext_noop("Dominica"),                         0,0,0 },
{ IDX_2C('d','o'),        gettext_noop("Dominican Republic"),               0,0,0 },
{ IDX_2C('d','z'),        gettext_noop("Algeria"),                          0,0,0 },
{ IDX_2C('e','c'),        gettext_noop("Ecuador"),                          0,0,0 },
{ IDX_2C('e','e'),        gettext_noop("Estonia"),                          0,0,0 },
{ IDX_2C('e','g'),        gettext_noop("Egypt"),                            0,0,0 },
{ IDX_2C('e','h'),        gettext_noop("Western Sahara"),                   0,0,0 },
{ IDX_2C('e','r'),        gettext_noop("Eritrea"),                          0,0,0 },
{ IDX_2C('e','s'),        gettext_noop("Spain"),                            0,0,0 },
{ IDX_2C('e','t'),        gettext_noop("Ethiopia"),                         0,0,0 },
{ IDX_2C('f','i'),        gettext_noop("Finland"),                          0,0,0 },
{ IDX_2C('f','j'),        gettext_noop("Fiji"),                             0,0,0 },
{ IDX_2C('f','k'),        gettext_noop("Falkland Islands (Malvinas)"),      0,0,0 },
{ IDX_2C('f','m'),        gettext_noop("Micronesia"),                       0,0,0 },
{ IDX_2C('f','o'),        gettext_noop("Faroe Islands"),                    0,0,0 },
{ IDX_2C('f','r'),        gettext_noop("France"),                           0,0,0 },
{ IDX_2C('f','x'),        gettext_noop("France, Metropolitan"),             0,0,0 },
{ IDX_2C('g','a'),        gettext_noop("Gabon"),                            0,0,0 },
{ IDX_2C('g','b'),        gettext_noop("Great Britain (UK)"),               0,0,0 },
{ IDX_2C('g','d'),        gettext_noop("Grenada"),                          0,0,0 },
{ IDX_2C('g','e'),        gettext_noop("Georgia"),                          0,0,0 },
{ IDX_2C('g','f'),        gettext_noop("French Guiana"),                    0,0,0 },
{ IDX_2C('g','h'),        gettext_noop("Ghana"),                            0,0,0 },
{ IDX_2C('g','i'),        gettext_noop("Gibraltar"),                        0,0,0 },
{ IDX_2C('g','l'),        gettext_noop("Greenland"),                        0,0,0 },
{ IDX_2C('g','m'),        gettext_noop("Gambia"),                           0,0,0 },
{ IDX_2C('g','n'),        gettext_noop("Guinea"),                           0,0,0 },
{ IDX_2C('g','p'),        gettext_noop("Guadeloupe"),                       0,0,0 },
{ IDX_2C('g','q'),        gettext_noop("Equatorial Guinea"),                0,0,0 },
{ IDX_2C('g','r'),        gettext_noop("Greece"),                           0,0,0 },
{ IDX_2C('g','s'),        gettext_noop("S. Georgia and S. Sandwich Isls."), 0,0,0 },
{ IDX_2C('g','t'),        gettext_noop("Guatemala"),                        0,0,0 },
{ IDX_2C('g','u'),        gettext_noop("Guam"),                             0,0,0 },
{ IDX_2C('g','w'),        gettext_noop("Guinea-Bissau"),                    0,0,0 },
{ IDX_2C('g','y'),        gettext_noop("Guyana"),                           0,0,0 },
{ IDX_2C('h','k'),        gettext_noop("Hong Kong"),                        0,0,0 },
{ IDX_2C('h','m'),        gettext_noop("Heard and McDonald Islands"),       0,0,0 },
{ IDX_2C('h','n'),        gettext_noop("Honduras"),                         0,0,0 },
{ IDX_2C('h','r'),        gettext_noop("Croatia (Hrvatska)"),               0,0,0 },
{ IDX_2C('h','t'),        gettext_noop("Haiti"),                            0,0,0 },
{ IDX_2C('h','u'),        gettext_noop("Hungary"),                          0,0,0 },
{ IDX_2C('i','d'),        gettext_noop("Indonesia"),                        0,0,0 },
{ IDX_2C('i','e'),        gettext_noop("Ireland"),                          0,0,0 },
{ IDX_2C('i','l'),        gettext_noop("Israel"),                           0,0,0 },
{ IDX_2C('i','n'),        gettext_noop("India"),                            0,0,0 },
{ IDX_2C('i','o'),        gettext_noop("British Indian Ocean Territory"),   0,0,0 },
{ IDX_2C('i','q'),        gettext_noop("Iraq"),                             0,0,0 },
{ IDX_2C('i','r'),        gettext_noop("Iran"),                             0,0,0 },
{ IDX_2C('i','s'),        gettext_noop("Iceland"),                          0,0,0 },
{ IDX_2C('i','t'),        gettext_noop("Italy"),                            0,0,0 },
{ IDX_2C('j','m'),        gettext_noop("Jamaica"),                          0,0,0 },
{ IDX_2C('j','o'),        gettext_noop("Jordan"),                           0,0,0 },
{ IDX_2C('j','p'),        gettext_noop("Japan"),                            0,0,0 },
{ IDX_2C('k','e'),        gettext_noop("Kenya"),                            0,0,0 },
{ IDX_2C('k','g'),        gettext_noop("Kyrgyzstan"),                       0,0,0 },
{ IDX_2C('k','h'),        gettext_noop("Cambodia"),                         0,0,0 },
{ IDX_2C('k','i'),        gettext_noop("Kiribati"),                         0,0,0 },
{ IDX_2C('k','m'),        gettext_noop("Comoros"),                          0,0,0 },
{ IDX_2C('k','n'),        gettext_noop("Saint Kitts and Nevis"),            0,0,0 },
{ IDX_2C('k','p'),        gettext_noop("Korea (North)"),                    0,0,0 },
{ IDX_2C('k','r'),        gettext_noop("Korea (South)"),                    0,0,0 },
{ IDX_2C('k','w'),        gettext_noop("Kuwait"),                           0,0,0 },
{ IDX_2C('k','y'),        gettext_noop("Cayman Islands"),                   0,0,0 },
{ IDX_2C('k','z'),        gettext_noop("Kazakhstan"),                       0,0,0 },
{ IDX_2C('l','a'),        gettext_noop("Laos"),                             0,0,0 },
{ IDX_2C('l','b'),        gettext_noop("Lebanon"),                          0,0,0 },
{ IDX_2C('l','c'),        gettext_noop("Saint Lucia"),                      0,0,0 },
{ IDX_2C('l','i'),        gettext_noop("Liechtenstein"),                    0,0,0 },
{ IDX_2C('l','k'),        gettext_noop("Sri Lanka"),                        0,0,0 },
{ IDX_2C('l','r'),        gettext_noop("Liberia"),                          0,0,0 },
{ IDX_2C('l','s'),        gettext_noop("Lesotho"),                          0,0,0 },
{ IDX_2C('l','t'),        gettext_noop("Lithuania"),                        0,0,0 },
{ IDX_2C('l','u'),        gettext_noop("Luxembourg"),                       0,0,0 },
{ IDX_2C('l','v'),        gettext_noop("Latvia"),                           0,0,0 },
{ IDX_2C('l','y'),        gettext_noop("Libya"),                            0,0,0 },
{ IDX_2C('m','a'),        gettext_noop("Morocco"),                          0,0,0 },
{ IDX_2C('m','c'),        gettext_noop("Monaco"),                           0,0,0 },
{ IDX_2C('m','d'),        gettext_noop("Moldova"),                          0,0,0 },
{ IDX_2C('m','g'),        gettext_noop("Madagascar"),                       0,0,0 },
{ IDX_2C('m','h'),        gettext_noop("Marshall Islands"),                 0,0,0 },
{ IDX_2C('m','k'),        gettext_noop("Macedonia"),                        0,0,0 },
{ IDX_2C('m','l'),        gettext_noop("Mali"),                             0,0,0 },
{ IDX_2C('m','m'),        gettext_noop("Myanmar"),                          0,0,0 },
{ IDX_2C('m','n'),        gettext_noop("Mongolia"),                         0,0,0 },
{ IDX_2C('m','o'),        gettext_noop("Macau"),                            0,0,0 },
{ IDX_2C('m','p'),        gettext_noop("Northern Mariana Islands"),         0,0,0 },
{ IDX_2C('m','q'),        gettext_noop("Martinique"),                       0,0,0 },
{ IDX_2C('m','r'),        gettext_noop("Mauritania"),                       0,0,0 },
{ IDX_2C('m','s'),        gettext_noop("Montserrat"),                       0,0,0 },
{ IDX_2C('m','t'),        gettext_noop("Malta"),                            0,0,0 },
{ IDX_2C('m','u'),        gettext_noop("Mauritius"),                        0,0,0 },
{ IDX_2C('m','v'),        gettext_noop("Maldives"),                         0,0,0 },
{ IDX_2C('m','w'),        gettext_noop("Malawi"),                           0,0,0 },
{ IDX_2C('m','x'),        gettext_noop("Mexico"),                           0,0,0 },
{ IDX_2C('m','y'),        gettext_noop("Malaysia"),                         0,0,0 },
{ IDX_2C('m','z'),        gettext_noop("Mozambique"),                       0,0,0 },
{ IDX_2C('n','a'),        gettext_noop("Namibia"),                          0,0,0 },
{ IDX_2C('n','c'),        gettext_noop("New Caledonia"),                    0,0,0 },
{ IDX_2C('n','e'),        gettext_noop("Niger"),                            0,0,0 },
{ IDX_2C('n','f'),        gettext_noop("Norfolk Island"),                   0,0,0 },
{ IDX_2C('n','g'),        gettext_noop("Nigeria"),                          0,0,0 },
{ IDX_2C('n','i'),        gettext_noop("Nicaragua"),                        0,0,0 },
{ IDX_2C('n','l'),        gettext_noop("Netherlands"),                      0,0,0 },
{ IDX_2C('n','o'),        gettext_noop("Norway"),                           0,0,0 },
{ IDX_2C('n','p'),        gettext_noop("Nepal"),                            0,0,0 },
{ IDX_2C('n','r'),        gettext_noop("Nauru"),                            0,0,0 },
{ IDX_2C('n','t'),        gettext_noop("Neutral Zone"),                     0,0,0 },
{ IDX_2C('n','u'),        gettext_noop("Niue"),                             0,0,0 },
{ IDX_2C('n','z'),        gettext_noop("New Zealand (Aotearoa)"),           0,0,0 },
{ IDX_2C('o','m'),        gettext_noop("Oman"),                             0,0,0 },
{ IDX_2C('p','a'),        gettext_noop("Panama"),                           0,0,0 },
{ IDX_2C('p','e'),        gettext_noop("Peru"),                             0,0,0 },
{ IDX_2C('p','f'),        gettext_noop("French Polynesia"),                 0,0,0 },
{ IDX_2C('p','g'),        gettext_noop("Papua New Guinea"),                 0,0,0 },
{ IDX_2C('p','h'),        gettext_noop("Philippines"),                      0,0,0 },
{ IDX_2C('p','k'),        gettext_noop("Pakistan"),                         0,0,0 },
{ IDX_2C('p','l'),        gettext_noop("Poland"),                           0,0,0 },
{ IDX_2C('p','m'),        gettext_noop("St. Pierre and Miquelon"),          0,0,0 },
{ IDX_2C('p','n'),        gettext_noop("Pitcairn"),                         0,0,0 },
{ IDX_2C('p','r'),        gettext_noop("Puerto Rico"),                      0,0,0 },
{ IDX_2C('p','t'),        gettext_noop("Portugal"),                         0,0,0 },
{ IDX_2C('p','w'),        gettext_noop("Palau"),                            0,0,0 },
{ IDX_2C('p','y'),        gettext_noop("Paraguay"),                         0,0,0 },
{ IDX_2C('q','a'),        gettext_noop("Qatar"),                            0,0,0 },
{ IDX_2C('r','e'),        gettext_noop("Reunion"),                          0,0,0 },
{ IDX_2C('r','o'),        gettext_noop("Romania"),                          0,0,0 },
{ IDX_2C('r','u'),        gettext_noop("Russian Federation"),               0,0,0 },
{ IDX_2C('r','w'),        gettext_noop("Rwanda"),                           0,0,0 },
{ IDX_2C('s','a'),        gettext_noop("Saudi Arabia"),                     0,0,0 },
{ IDX_2C('s','B'),        gettext_noop("Solomon Islands"),                  0,0,0 },
{ IDX_2C('s','c'),        gettext_noop("Seychelles"),                       0,0,0 },
{ IDX_2C('s','d'),        gettext_noop("Sudan"),                            0,0,0 },
{ IDX_2C('s','e'),        gettext_noop("Sweden"),                           0,0,0 },
{ IDX_2C('s','g'),        gettext_noop("Singapore"),                        0,0,0 },
{ IDX_2C('s','h'),        gettext_noop("St. Helena"),                       0,0,0 },
{ IDX_2C('s','i'),        gettext_noop("Slovenia"),                         0,0,0 },
{ IDX_2C('s','j'),        gettext_noop("Svalbard and Jan Mayen Islands"),   0,0,0 },
{ IDX_2C('s','k'),        gettext_noop("Slovak Republic"),                  0,0,0 },
{ IDX_2C('s','l'),        gettext_noop("Sierra Leone"),                     0,0,0 },
{ IDX_2C('s','m'),        gettext_noop("San Marino"),                       0,0,0 },
{ IDX_2C('s','n'),        gettext_noop("Senegal"),                          0,0,0 },
{ IDX_2C('s','o'),        gettext_noop("Somalia"),                          0,0,0 },
{ IDX_2C('s','r'),        gettext_noop("Suriname"),                         0,0,0 },
{ IDX_2C('s','t'),        gettext_noop("Sao Tome and Principe"),            0,0,0 },
{ IDX_2C('s','u'),        gettext_noop("USSR (former)"),                    0,0,0 },
{ IDX_2C('s','v'),        gettext_noop("El Salvador"),                      0,0,0 },
{ IDX_2C('s','y'),        gettext_noop("Syria"),                            0,0,0 },
{ IDX_2C('s','z'),        gettext_noop("Swaziland"),                        0,0,0 },
{ IDX_2C('t','c'),        gettext_noop("Turks and Caicos Islands"),         0,0,0 },
{ IDX_2C('t','d'),        gettext_noop("Chad"),                             0,0,0 },
{ IDX_2C('t','f'),        gettext_noop("French Southern Territories"),      0,0,0 },
{ IDX_2C('t','g'),        gettext_noop("Togo"),                             0,0,0 },
{ IDX_2C('t','h'),        gettext_noop("Thailand"),                         0,0,0 },
{ IDX_2C('t','j'),        gettext_noop("Tajikistan"),                       0,0,0 },
{ IDX_2C('t','k'),        gettext_noop("Tokelau"),                          0,0,0 },
{ IDX_2C('t','m'),        gettext_noop("Turkmenistan"),                     0,0,0 },
{ IDX_2C('t','n'),        gettext_noop("Tunisia"),                          0,0,0 },
{ IDX_2C('t','o'),        gettext_noop("Tonga"),                            0,0,0 },
{ IDX_2C('t','p'),        gettext_noop("East Timor"),                       0,0,0 },
{ IDX_2C('t','r'),        gettext_noop("Turkey"),                           0,0,0 },
{ IDX_2C('t','t'),        gettext_noop("Trinidad and Tobago"),              0,0,0 },
{ IDX_2C('t','v'),        gettext_noop("Tuvalu"),                           0,0,0 },
{ IDX_2C('t','w'),        gettext_noop("Taiwan"),                           0,0,0 },
{ IDX_2C('t','z'),        gettext_noop("Tanzania"),                         0,0,0 },
{ IDX_2C('u','a'),        gettext_noop("Ukraine"),                          0,0,0 },
{ IDX_2C('u','g'),        gettext_noop("Uganda"),                           0,0,0 },
{ IDX_2C('u','k'),        gettext_noop("United Kingdom"),                   0,0,0 },
{ IDX_2C('u','m'),        gettext_noop("US Minor Outlying Islands"),        0,0,0 },
{ IDX_2C('u','s'),        gettext_noop("United States"),                    0,0,0 },
{ IDX_2C('u','y'),        gettext_noop("Uruguay"),                          0,0,0 },
{ IDX_2C('u','z'),        gettext_noop("Uzbekistan"),                       0,0,0 },
{ IDX_2C('v','a'),        gettext_noop("Vatican City State (Holy See)"),    0,0,0 },
{ IDX_2C('v','c'),        gettext_noop("Saint Vincent and the Grenadines"), 0,0,0 },
{ IDX_2C('v','e'),        gettext_noop("Venezuela"),                        0,0,0 },
{ IDX_2C('v','g'),        gettext_noop("Virgin Islands (British)"),         0,0,0 },
{ IDX_2C('v','i'),        gettext_noop("Virgin Islands (U.S.)"),            0,0,0 },
{ IDX_2C('v','n'),        gettext_noop("Viet Nam"),                         0,0,0 },
{ IDX_2C('v','u'),        gettext_noop("Vanuatu"),                          0,0,0 },
{ IDX_2C('w','f'),        gettext_noop("Wallis and Futuna Islands"),        0,0,0 },
{ IDX_2C('w','s'),        gettext_noop("Samoa"),                            0,0,0 },
{ IDX_2C('y','e'),        gettext_noop("Yemen"),                            0,0,0 },
{ IDX_2C('y','t'),        gettext_noop("Mayotte"),                          0,0,0 },
{ IDX_2C('y','u'),        gettext_noop("Yugoslavia"),                       0,0,0 },
{ IDX_2C('z','a'),        gettext_noop("South Africa"),                     0,0,0 },
{ IDX_2C('z','m'),        gettext_noop("Zambia"),                           0,0,0 },
{ IDX_2C('z','r'),        gettext_noop("Zaire"),                            0,0,0 },
{ IDX_2C('z','w'),        gettext_noop("Zimbabwe"),                         0,0,0 },
{ 0              ,        NULL,                               0,0,0 }};
