// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use File;
use FileMonitorEvent;
use ffi;
use glib;
use glib::StaticType;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct FileMonitor(Object<ffi::GFileMonitor, ffi::GFileMonitorClass>);

    match fn {
        get_type => || ffi::g_file_monitor_get_type(),
    }
}

pub trait FileMonitorExt {
    fn cancel(&self) -> bool;

    fn emit_event<P: IsA<File>, Q: IsA<File>>(&self, child: &P, other_file: &Q, event_type: FileMonitorEvent);

    fn is_cancelled(&self) -> bool;

    fn set_rate_limit(&self, limit_msecs: i32);

    fn get_property_cancelled(&self) -> bool;

    fn get_property_rate_limit(&self) -> i32;

    fn connect_changed<F: Fn(&Self, &File, &Option<File>, FileMonitorEvent) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_cancelled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_rate_limit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<FileMonitor> + IsA<glib::object::Object>> FileMonitorExt for O {
    fn cancel(&self) -> bool {
        unsafe {
            from_glib(ffi::g_file_monitor_cancel(self.to_glib_none().0))
        }
    }

    fn emit_event<P: IsA<File>, Q: IsA<File>>(&self, child: &P, other_file: &Q, event_type: FileMonitorEvent) {
        unsafe {
            ffi::g_file_monitor_emit_event(self.to_glib_none().0, child.to_glib_none().0, other_file.to_glib_none().0, event_type.to_glib());
        }
    }

    fn is_cancelled(&self) -> bool {
        unsafe {
            from_glib(ffi::g_file_monitor_is_cancelled(self.to_glib_none().0))
        }
    }

    fn set_rate_limit(&self, limit_msecs: i32) {
        unsafe {
            ffi::g_file_monitor_set_rate_limit(self.to_glib_none().0, limit_msecs);
        }
    }

    fn get_property_cancelled(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "cancelled".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_rate_limit(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "rate-limit".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn connect_changed<F: Fn(&Self, &File, &Option<File>, FileMonitorEvent) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &File, &Option<File>, FileMonitorEvent) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "changed",
                transmute(changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_cancelled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::cancelled",
                transmute(notify_cancelled_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_rate_limit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::rate-limit",
                transmute(notify_rate_limit_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn changed_trampoline<P>(this: *mut ffi::GFileMonitor, file: *mut ffi::GFile, other_file: *mut ffi::GFile, event_type: ffi::GFileMonitorEvent, f: glib_ffi::gpointer)
where P: IsA<FileMonitor> {
    let f: &&(Fn(&P, &File, &Option<File>, FileMonitorEvent) + 'static) = transmute(f);
    f(&FileMonitor::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(file), &from_glib_borrow(other_file), from_glib(event_type))
}

unsafe extern "C" fn notify_cancelled_trampoline<P>(this: *mut ffi::GFileMonitor, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<FileMonitor> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&FileMonitor::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_rate_limit_trampoline<P>(this: *mut ffi::GFileMonitor, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<FileMonitor> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&FileMonitor::from_glib_borrow(this).downcast_unchecked())
}
