% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesplot-ggplot-themes.R
\name{theme_default}
\alias{theme_default}
\title{Default bayesplot plotting theme}
\usage{
theme_default(base_size = getOption("bayesplot.base_size", 12),
  base_family = getOption("bayesplot.base_family", "serif"))
}
\arguments{
\item{base_size, base_family}{Base font size and family (passed to
\code{\link[ggplot2]{theme_bw}}). It is possible to set
\code{"bayesplot.base_size"} and \code{"bayesplot.base_family"} via
\code{\link{options}} to change the defaults, which are \code{12} and
\code{"serif"}, respectively.}
}
\value{
A ggplot \link[ggplot2]{theme} object.
}
\description{
The \code{\link{theme_default}} function returns the default ggplot
\link{theme} used by the \pkg{bayesplot} plotting functions. See
\code{\link{bayesplot_theme_set}} for details on setting and updating the
plotting theme.
}
\examples{
class(theme_default())

bayesplot_theme_set() # defaults to setting theme_default()
x <- example_mcmc_draws()
mcmc_hist(x)

# change the default font size and family for bayesplots
bayesplot_theme_set(theme_default(base_size = 8, base_family = "sans"))
mcmc_hist(x)
mcmc_areas(x, regex_pars = "beta")

# change back
bayesplot_theme_set()
mcmc_areas(x, regex_pars = "beta")

}
\seealso{
\link{bayesplot-helpers} for a variety of convenience functions,
  many of which provide shortcuts for tweaking theme elements after creating
  a plot.

\code{\link{bayesplot-colors}} to set or view the color scheme used
  for plotting.
}
