description("Test that getting color properties from a CanvasRenderingContext2D returns properly formatted values.");

ctx = document.createElement('canvas').getContext('2d');

function trySettingStrokeStyle(value) {
    ctx.strokeStyle = '#666';
    ctx.strokeStyle = value;
    return ctx.strokeStyle;
}

function trySettingFillStyle(value) {
    ctx.fillStyle = '#666';
    ctx.fillStyle = value;
    return ctx.fillStyle;
}

function trySettingShadowColor(value) {
    ctx.shadowColor = '#666';
    ctx.shadowColor = value;
    return ctx.shadowColor;
}

function trySettingColor(value, expected) {
    shouldBe("trySettingStrokeStyle(" + value + ")", expected);
    shouldBe("trySettingFillStyle(" + value + ")", expected);
    shouldBe("trySettingShadowColor(" + value + ")", expected);
}

function trySettingStrokeColorWithSetter(value) {
    ctx.strokeStyle = '#666';
    ctx.setStrokeColor(value);
    return ctx.strokeStyle;
}

function trySettingFillColorWithSetter(value) {
    ctx.fillStyle = '#666';
    ctx.setFillColor(value);
    return ctx.fillStyle;
}

function trySettingShadowWithSetter(value) {
    ctx.shadowColor = '#666';
    ctx.setShadow(0, 0, 0, value);
    return ctx.shadowColor;
}

function trySettingColorWithSetter(value, expected) {
    shouldBe("trySettingStrokeColorWithSetter(" + value + ")", expected);
    shouldBe("trySettingFillColorWithSetter(" + value + ")", expected);
    shouldBe("trySettingShadowWithSetter(" + value + ")", expected);
}

function trySettingFillColorRGBA(r, g, b, a) {
    ctx.fillStyle = '#666';
    ctx.setFillColor(r, g, b, a);
    return ctx.fillStyle;
}

function trySettingStrokeColorRGBA(r, g, b, a) {
    ctx.strokeStyle = '#666';
    ctx.setStrokeColor(r, g, b, a);
    return ctx.strokeStyle;
}

function trySettingShadowRGBA(r, g, b, a) {
    ctx.strokeStyle = '#666';
    ctx.setStrokeColor(r, g, b, a);
    return ctx.strokeStyle;
}

function trySettingRGBA(r, g, b, a, expected) {
    shouldBe("trySettingFillColorRGBA(" + r + ", " + g + ", " + b + ", " + a + ")", expected);
    shouldBe("trySettingStrokeColorRGBA(" + r + ", " + g + ", " + b + ", " + a + ")", expected);
    shouldBe("trySettingShadowRGBA(" + r + ", " + g + ", " + b + ", " + a + ")", expected);
}

function trySettingFillColorCMYKA(c, m, y, k, a) {
    ctx.fillStyle = '#666';
    ctx.setFillColor(c, m, y, k, a);
    return ctx.fillStyle;
}

function trySettingStrokeColorCMYKA(c, m, y, k, a) {
    ctx.strokeStyle = '#666';
    ctx.setStrokeColor(c, m, y, k, a);
    return ctx.strokeStyle;
}

function trySettingShadowCMYKA(c, m, y, k, a) {
    ctx.strokeStyle = '#666';
    ctx.setStrokeColor(c, m, y, k, a);
    return ctx.strokeStyle;
}

function trySettingCMYKA(c, m, y, k, a, expected) {
    shouldBe("trySettingFillColorCMYKA(" + c + ", " + m + ", " + y + ", " + k + ", " + a + ")", expected);
    shouldBe("trySettingStrokeColorCMYKA(" + c + ", " + m + ", " + y + ", " + k + ", " + a + ")", expected);
    shouldBe("trySettingShadowCMYKA(" + c + ", " + m + ", " + y + ", " + k + ", " + a + ")", expected);
}

function trySettingFillColorWithOverrideAlpha(color, alpha) {
    ctx.fillStyle = '#666';
    ctx.setFillColor(color, alpha);
    return ctx.fillStyle;
}

function trySettingStrokeColorWithOverrideAlpha(color, alpha) {
    ctx.strokeStyle = '#666';
    ctx.setStrokeColor(color, alpha);
    return ctx.strokeStyle;
}

function trySettingShadowWithOverrideAlpha(color, alpha) {
    ctx.shadowColor = '#666';
    ctx.setShadow(0, 0, 0, color, alpha);
    return ctx.shadowColor;
}

function trySettingColorWithOverrideAlpha(color, alpha, expected) {
    shouldBe("trySettingFillColorWithOverrideAlpha(" + color + ", " + alpha + ")", expected);
    shouldBe("trySettingStrokeColorWithOverrideAlpha(" + color + ", " + alpha + ")", expected);
    shouldBe("trySettingShadowWithOverrideAlpha(" + color + ", " + alpha + ")", expected);
}

function trySettingFillColorGrayLevel(grayLevel) {
    ctx.fillStyle = '#666';
    ctx.setFillColor(grayLevel);
    return ctx.fillStyle;
}

function trySettingStrokeColorGrayLevel(grayLevel) {
    ctx.strokeStyle = '#666';
    ctx.setStrokeColor(grayLevel);
    return ctx.strokeStyle;
}

function trySettingShadowGrayLevel(grayLevel) {
    ctx.shadowColor = '#666';
    ctx.setShadow(0, 0, 0, grayLevel);
    return ctx.shadowColor;
}

function trySettingGrayLevel(grayLevel, expected) {
    shouldBe("trySettingFillColorGrayLevel(" + grayLevel + ")", expected);
    shouldBe("trySettingStrokeColorGrayLevel(" + grayLevel + ")", expected);
    shouldBe("trySettingShadowGrayLevel(" + grayLevel + ")", expected);
}

function trySettingFillColorGrayLevelWithAlpha(grayLevel, alpha) {
    ctx.fillStyle = '#666';
    ctx.setFillColor(grayLevel, alpha);
    return ctx.fillStyle;
}

function trySettingStrokeColorGrayLevelWithAlpha(grayLevel, alpha) {
    ctx.strokeStyle = '#666';
    ctx.setStrokeColor(grayLevel, alpha);
    return ctx.strokeStyle;
}

function trySettingShadowGrayLevelWithAlpha(grayLevel, alpha) {
    ctx.shadowColor = '#666';
    ctx.setShadow(0, 0, 0, grayLevel, alpha);
    return ctx.shadowColor;
}

function trySettingGrayLevelWithAlpha(grayLevel, alpha, expected) {
    shouldBe("trySettingFillColorGrayLevelWithAlpha(" + grayLevel + ", " + alpha + ")", expected);
    shouldBe("trySettingStrokeColorGrayLevelWithAlpha(" + grayLevel + ", " + alpha + ")", expected);
    shouldBe("trySettingShadowGrayLevelWithAlpha(" + grayLevel + ", " + alpha + ")", expected);
}

function tryClearShadowAfterSettingColor(value) {
    ctx.shadowColor = value;
    ctx.clearShadow();
    return ctx.shadowColor;
}

function checkDefaultValue(value) {
    return value;
}

shouldBe("checkDefaultValue(ctx.strokeStyle)", "'#000000'");
shouldBe("checkDefaultValue(ctx.fillStyle)", "'#000000'");
shouldBe("checkDefaultValue(ctx.shadowColor)", "'rgba(0, 0, 0, 0)'");

trySettingColorWithOverrideAlpha("'red'", 0, "'rgba(255, 0, 0, 0)'");
trySettingColorWithOverrideAlpha("'black'", 1, "'#000000'");

trySettingRGBA(0, 0, 0, 0.0, "'rgba(0, 0, 0, 0)'");
trySettingRGBA(255, 255, 255, 1.0, "'#ffffff'");
trySettingRGBA(255, 0, 0, 0.0, "'rgba(255, 0, 0, 0)'");
trySettingRGBA(255, 0, 0, 0.4, "'rgba(255, 0, 0, 0.4)'");

trySettingCMYKA(0, 0, 0, 0, 0.0, "'rgba(255, 255, 255, 0)'");
trySettingCMYKA(0, 0, 0, 0, 1.0, "'#ffffff'");
trySettingCMYKA(0, 1, 0, 0, 0.0, "'rgba(255, 0, 255, 0)'");
trySettingCMYKA(0, 1, 0, 0, 1.0, "'#ff00ff'");
trySettingCMYKA(0, 0, 0, 1, 0.0, "'rgba(0, 0, 0, 0)'");
trySettingCMYKA(0, 0, 0, 1, 1.0, "'#000000'");

trySettingGrayLevel(0.0, "'#000000'");
trySettingGrayLevel(0.5, "'#808080'");
trySettingGrayLevel(1.0, "'#ffffff'");

trySettingGrayLevelWithAlpha(0.0, 0.0, "'rgba(0, 0, 0, 0)'");
trySettingGrayLevelWithAlpha(0.0, 0.4, "'rgba(0, 0, 0, 0.4)'");
trySettingGrayLevelWithAlpha(0.0, 1.0, "'#000000'");
trySettingGrayLevelWithAlpha(0.5, 0.0, "'rgba(128, 128, 128, 0)'");
trySettingGrayLevelWithAlpha(0.5, 0.4, "'rgba(128, 128, 128, 0.4)'");
trySettingGrayLevelWithAlpha(0.5, 1.0, "'#808080'");
trySettingGrayLevelWithAlpha(1.0, 0.0, "'rgba(255, 255, 255, 0)'");
trySettingGrayLevelWithAlpha(1.0, 0.4, "'rgba(255, 255, 255, 0.4)'");
trySettingGrayLevelWithAlpha(1.0, 1.0, "'#ffffff'");

trySettingColor("'transparent'", "'rgba(0, 0, 0, 0)'");
trySettingColor("'red'", "'#ff0000'");
trySettingColor("'white'", "'#ffffff'");
trySettingColor("''", "'#666666'");
trySettingColor("'RGBA(0, 0, 0, 0)'", "'rgba(0, 0, 0, 0)'");
trySettingColor("'rgba(0,255,0,1.0)'", "'#00ff00'");
trySettingColor("'rgba(1,2,3,0.4)'", "'rgba(1, 2, 3, 0.4)'");
trySettingColor("'RgB(1,2,3)'", "'#010203'");
trySettingColor("'rGbA(1,2,3,0)'", "'rgba(1, 2, 3, 0)'");
trySettingColor("true", "'#666666'");
trySettingColor("false", "'#666666'");
trySettingColor("0", "'#666666'");
trySettingColor("1", "'#666666'");
trySettingColor("-1", "'#666666'");
trySettingColor("NaN", "'#666666'");
trySettingColor("Infinity", "'#666666'");
trySettingColor("null", "'#666666'");
trySettingColor("'left'", "'#666666'");
trySettingColor("'right'", "'#666666'");
trySettingColor("'center'", "'#666666'");
trySettingColor("'border'", "'#666666'");
trySettingColor("'border-box'", "'#666666'");
trySettingColor("'content'", "'#666666'");
trySettingColor("'logical'", "'#666666'");
trySettingColor("'visual'", "'#666666'");

trySettingColorWithSetter("'transparent'", "'rgba(0, 0, 0, 0)'");
trySettingColorWithSetter("'red'", "'#ff0000'");
trySettingColorWithSetter("'white'", "'#ffffff'");
trySettingColorWithSetter("''", "'#666666'");
trySettingColorWithSetter("'RGBA(0, 0, 0, 0)'", "'rgba(0, 0, 0, 0)'");
trySettingColorWithSetter("'rgba(0,255,0,1.0)'", "'#00ff00'");
trySettingColorWithSetter("'rgba(1,2,3,0.4)'", "'rgba(1, 2, 3, 0.4)'");
trySettingColorWithSetter("'RgB(1,2,3)'", "'#010203'");
trySettingColorWithSetter("'rGbA(1,2,3,0)'", "'rgba(1, 2, 3, 0)'");

shouldBe("tryClearShadowAfterSettingColor('red')", "'rgba(0, 0, 0, 0)'");
shouldBe("tryClearShadowAfterSettingColor('rgba(0, 5, 10, 0.4)')", "'rgba(0, 0, 0, 0)'");
