/*
Open Asset Import Library (ASSIMP)
----------------------------------------------------------------------

Copyright (c) 2006-2018, ASSIMP Development Team
All rights reserved.

Redistribution and use of this software in source and binary forms, 
with or without modification, are permitted provided that the 
following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.

* Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the
  following disclaimer in the documentation and/or other
  materials provided with the distribution.

* Neither the name of the ASSIMP team, nor the names of its
  contributors may be used to endorse or promote products
  derived from this software without specific prior
  written permission of the ASSIMP Development Team.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

----------------------------------------------------------------------
*/

/** MACHINE-GENERATED by scripts/ICFImporter/CppGenerator.py */

#ifndef ASSIMP_BUILD_NO_STEP_IMPORTER

#include "code/Importer/StepFile/StepReaderGen.h"

namespace Assimp {
using namespace StepFile;

namespace {

	typedef EXPRESS::ConversionSchema::SchemaEntry SchemaEntry;

	const SchemaEntry schema_raw[] =  {
		SchemaEntry("absorbed_dose_measure",NULL )
,		SchemaEntry("acceleration_measure",NULL )
,		SchemaEntry("action_items",NULL )
,		SchemaEntry("action_method_items",NULL )
,		SchemaEntry("action_request_item",NULL )
,		SchemaEntry("ahead_or_behind",NULL )
,		SchemaEntry("amount_of_substance_measure",NULL )
,		SchemaEntry("angle_direction_reference_select",NULL )
,		SchemaEntry("angle_direction_reference_with_a2p3d_select",NULL )
,		SchemaEntry("angle_relator",NULL )
,		SchemaEntry("annotation_plane_element",NULL )
,		SchemaEntry("annotation_representation_select",NULL )
,		SchemaEntry("annotation_symbol_occurrence_item",NULL )
,		SchemaEntry("annotation_text_occurrence_item",NULL )
,		SchemaEntry("approval_item",NULL )
,		SchemaEntry("approved_item",NULL )
,		SchemaEntry("area_measure",NULL )
,		SchemaEntry("area_or_view",NULL )
,		SchemaEntry("attribute_classification_item",NULL )
,		SchemaEntry("attribute_language_item",NULL )
,		SchemaEntry("attribute_type",NULL )
,		SchemaEntry("axis2_placement",NULL )
,		SchemaEntry("b_spline_curve_form",NULL )
,		SchemaEntry("b_spline_surface_form",NULL )
,		SchemaEntry("base_solid_select",NULL )
,		SchemaEntry("blend_end_condition_select",NULL )
,		SchemaEntry("blend_radius_variation_type",NULL )
,		SchemaEntry("boolean_operand",NULL )
,		SchemaEntry("boolean_operator",NULL )
,		SchemaEntry("box_characteristic_select",NULL )
,		SchemaEntry("box_height",NULL )
,		SchemaEntry("box_rotate_angle",NULL )
,		SchemaEntry("box_slant_angle",NULL )
,		SchemaEntry("box_width",NULL )
,		SchemaEntry("camera_model_d3_multi_clipping_interection_select",NULL )
,		SchemaEntry("camera_model_d3_multi_clipping_union_select",NULL )
,		SchemaEntry("capacitance_measure",NULL )
,		SchemaEntry("category_usage_item",NULL )
,		SchemaEntry("cc_classified_item",NULL )
,		SchemaEntry("cc_person_organization_item",NULL )
,		SchemaEntry("cc_specified_item",NULL )
,		SchemaEntry("celsius_temperature_measure",NULL )
,		SchemaEntry("central_or_parallel",NULL )
,		SchemaEntry("certification_item",NULL )
,		SchemaEntry("certified_item",NULL )
,		SchemaEntry("change_request_item",NULL )
,		SchemaEntry("character_spacing_select",NULL )
,		SchemaEntry("character_style_select",NULL )
,		SchemaEntry("characterized_action_definition",NULL )
,		SchemaEntry("characterized_definition",NULL )
,		SchemaEntry("characterized_material_property",NULL )
,		SchemaEntry("characterized_product_composition_value",NULL )
,		SchemaEntry("characterized_product_definition",NULL )
,		SchemaEntry("class_usage_effectivity_context_item",NULL )
,		SchemaEntry("classification_item",NULL )
,		SchemaEntry("classified_item",NULL )
,		SchemaEntry("compound_item_definition",NULL )
,		SchemaEntry("conductance_measure",NULL )
,		SchemaEntry("configuration_design_item",NULL )
,		SchemaEntry("configured_effectivity_context_item",NULL )
,		SchemaEntry("configured_effectivity_item",NULL )
,		SchemaEntry("constructive_geometry_representation_or_shape_represenation",NULL )
,		SchemaEntry("context_dependent_measure",NULL )
,		SchemaEntry("contract_item",NULL )
,		SchemaEntry("contracted_item",NULL )
,		SchemaEntry("count_measure",NULL )
,		SchemaEntry("csg_primitive",NULL )
,		SchemaEntry("csg_select",NULL )
,		SchemaEntry("curve_font_or_scaled_curve_font_select",NULL )
,		SchemaEntry("curve_on_surface",NULL )
,		SchemaEntry("curve_or_annotation_curve_occurrence",NULL )
,		SchemaEntry("curve_or_render",NULL )
,		SchemaEntry("curve_style_font_select",NULL )
,		SchemaEntry("date_and_time_item",NULL )
,		SchemaEntry("date_item",NULL )
,		SchemaEntry("date_time_item",NULL )
,		SchemaEntry("date_time_or_event_occurrence",NULL )
,		SchemaEntry("date_time_select",NULL )
,		SchemaEntry("day_in_month_number",NULL )
,		SchemaEntry("day_in_week_number",NULL )
,		SchemaEntry("day_in_year_number",NULL )
,		SchemaEntry("defined_symbol_select",NULL )
,		SchemaEntry("derived_property_select",NULL )
,		SchemaEntry("description_attribute_select",NULL )
,		SchemaEntry("descriptive_measure",NULL )
,		SchemaEntry("dimension_count",NULL )
,		SchemaEntry("dimension_extent_usage",NULL )
,		SchemaEntry("dimensional_characteristic",NULL )
,		SchemaEntry("direction_count_select",NULL )
,		SchemaEntry("document_identifier_assigned_item",NULL )
,		SchemaEntry("document_reference_item",NULL )
,		SchemaEntry("dose_equivalent_measure",NULL )
,		SchemaEntry("draughting_callout_element",NULL )
,		SchemaEntry("draughting_model_item_association_select",NULL )
,		SchemaEntry("draughting_model_item_select",NULL )
,		SchemaEntry("draughting_titled_item",NULL )
,		SchemaEntry("effectivity_item",NULL )
,		SchemaEntry("electric_charge_measure",NULL )
,		SchemaEntry("electric_current_measure",NULL )
,		SchemaEntry("electric_potential_measure",NULL )
,		SchemaEntry("energy_measure",NULL )
,		SchemaEntry("event_occurrence_item",NULL )
,		SchemaEntry("external_identification_item",NULL )
,		SchemaEntry("fill_area_style_tile_shape_select",NULL )
,		SchemaEntry("fill_style_select",NULL )
,		SchemaEntry("font_select",NULL )
,		SchemaEntry("force_measure",NULL )
,		SchemaEntry("founded_item_select",NULL )
,		SchemaEntry("frequency_measure",NULL )
,		SchemaEntry("generalized_surface_select",NULL )
,		SchemaEntry("geometric_item_specific_usage_select",NULL )
,		SchemaEntry("geometric_set_select",NULL )
,		SchemaEntry("groupable_item",NULL )
,		SchemaEntry("hour_in_day",NULL )
,		SchemaEntry("id_attribute_select",NULL )
,		SchemaEntry("identification_item",NULL )
,		SchemaEntry("identifier",NULL )
,		SchemaEntry("illuminance_measure",NULL )
,		SchemaEntry("inductance_measure",NULL )
,		SchemaEntry("instance_usage_context_select",NULL )
,		SchemaEntry("invisibility_context",NULL )
,		SchemaEntry("invisible_item",NULL )
,		SchemaEntry("ir_usage_item",NULL )
,		SchemaEntry("knot_type",NULL )
,		SchemaEntry("label",NULL )
,		SchemaEntry("layered_item",NULL )
,		SchemaEntry("length_measure",NULL )
,		SchemaEntry("limit_condition",NULL )
,		SchemaEntry("list_of_reversible_topology_item",NULL )
,		SchemaEntry("list_representation_item",NULL )
,		SchemaEntry("luminous_flux_measure",NULL )
,		SchemaEntry("luminous_intensity_measure",NULL )
,		SchemaEntry("magnetic_flux_density_measure",NULL )
,		SchemaEntry("magnetic_flux_measure",NULL )
,		SchemaEntry("marker_select",NULL )
,		SchemaEntry("marker_type",NULL )
,		SchemaEntry("mass_measure",NULL )
,		SchemaEntry("measure_value",NULL )
,		SchemaEntry("mechanical_design_and_draughting_relationship_select",NULL )
,		SchemaEntry("mechanical_design_geometric_presentation_area_items",NULL )
,		SchemaEntry("mechanical_design_geometric_presentation_representation_items",NULL )
,		SchemaEntry("message",NULL )
,		SchemaEntry("minute_in_hour",NULL )
,		SchemaEntry("month_in_year_number",NULL )
,		SchemaEntry("multi_language_attribute_item",NULL )
,		SchemaEntry("name_attribute_select",NULL )
,		SchemaEntry("name_item",NULL )
,		SchemaEntry("non_negative_length_measure",NULL )
,		SchemaEntry("nonnegative_integer",NULL )
,		SchemaEntry("null_style",NULL )
,		SchemaEntry("numeric_measure",NULL )
,		SchemaEntry("organization_item",NULL )
,		SchemaEntry("orientation_basis_select",NULL )
,		SchemaEntry("parameter_value",NULL )
,		SchemaEntry("pcurve_or_surface",NULL )
,		SchemaEntry("person_and_organization_item",NULL )
,		SchemaEntry("person_organization_select",NULL )
,		SchemaEntry("picture_representation_item_select",NULL )
,		SchemaEntry("plane_angle_measure",NULL )
,		SchemaEntry("plane_or_planar_box",NULL )
,		SchemaEntry("point_and_vector_member",NULL )
,		SchemaEntry("point_and_vector_members",NULL )
,		SchemaEntry("point_path_members",NULL )
,		SchemaEntry("positive_integer",NULL )
,		SchemaEntry("positive_length_measure",NULL )
,		SchemaEntry("positive_plane_angle_measure",NULL )
,		SchemaEntry("positive_ratio_measure",NULL )
,		SchemaEntry("power_measure",NULL )
,		SchemaEntry("preferred_surface_curve_representation",NULL )
,		SchemaEntry("presentable_text",NULL )
,		SchemaEntry("presentation_representation_select",NULL )
,		SchemaEntry("presentation_size_assignment_select",NULL )
,		SchemaEntry("presentation_style_select",NULL )
,		SchemaEntry("presented_item_select",NULL )
,		SchemaEntry("pressure_measure",NULL )
,		SchemaEntry("product_definition_or_assembly_relationship",NULL )
,		SchemaEntry("product_definition_or_breakdown_element_usage",NULL )
,		SchemaEntry("product_definition_or_product_definition_relationship",NULL )
,		SchemaEntry("product_or_formation_or_definition",NULL )
,		SchemaEntry("project_item",NULL )
,		SchemaEntry("radioactivity_measure",NULL )
,		SchemaEntry("ratio_measure",NULL )
,		SchemaEntry("rendering_properties_select",NULL )
,		SchemaEntry("represented_definition",NULL )
,		SchemaEntry("requirement_assigned_item",NULL )
,		SchemaEntry("requirement_satisfaction_item",NULL )
,		SchemaEntry("requirement_source_item",NULL )
,		SchemaEntry("resistance_measure",NULL )
,		SchemaEntry("reversible_topology",NULL )
,		SchemaEntry("reversible_topology_item",NULL )
,		SchemaEntry("role_select",NULL )
,		SchemaEntry("rule_superseded_item",NULL )
,		SchemaEntry("second_in_minute",NULL )
,		SchemaEntry("security_classification_item",NULL )
,		SchemaEntry("set_of_reversible_topology_item",NULL )
,		SchemaEntry("set_representation_item",NULL )
,		SchemaEntry("shading_curve_method",NULL )
,		SchemaEntry("shading_surface_method",NULL )
,		SchemaEntry("shape_definition",NULL )
,		SchemaEntry("shell",NULL )
,		SchemaEntry("si_prefix",NULL )
,		SchemaEntry("si_unit_name",NULL )
,		SchemaEntry("size_select",NULL )
,		SchemaEntry("sketch_basis_select",NULL )
,		SchemaEntry("solid_angle_measure",NULL )
,		SchemaEntry("source",NULL )
,		SchemaEntry("source_item",NULL )
,		SchemaEntry("start_request_item",NULL )
,		SchemaEntry("string_representation_item_select",NULL )
,		SchemaEntry("style_context_select",NULL )
,		SchemaEntry("surface_side",NULL )
,		SchemaEntry("surface_side_style_select",NULL )
,		SchemaEntry("surface_style_element_select",NULL )
,		SchemaEntry("symbol_style_select",NULL )
,		SchemaEntry("text",NULL )
,		SchemaEntry("text_alignment",NULL )
,		SchemaEntry("text_delineation",NULL )
,		SchemaEntry("text_or_character",NULL )
,		SchemaEntry("text_path",NULL )
,		SchemaEntry("text_string_representation_item",NULL )
,		SchemaEntry("thermodynamic_temperature_measure",NULL )
,		SchemaEntry("time_interval_item",NULL )
,		SchemaEntry("time_measure",NULL )
,		SchemaEntry("tolerance_method_definition",NULL )
,		SchemaEntry("transformation",NULL )
,		SchemaEntry("transition_code",NULL )
,		SchemaEntry("trim_condition_select",NULL )
,		SchemaEntry("trim_intent",NULL )
,		SchemaEntry("trimming_preference",NULL )
,		SchemaEntry("trimming_select",NULL )
,		SchemaEntry("u_direction_count",NULL )
,		SchemaEntry("unit",NULL )
,		SchemaEntry("v_direction_count",NULL )
,		SchemaEntry("value_qualifier",NULL )
,		SchemaEntry("vector_or_direction",NULL )
,		SchemaEntry("velocity_measure",NULL )
,		SchemaEntry("volume_measure",NULL )
,		SchemaEntry("week_in_year_number",NULL )
,		SchemaEntry("work_item",NULL )
,		SchemaEntry("year_number",NULL )
,		SchemaEntry("measure_with_unit",&STEP::ObjectHelper<measure_with_unit,2>::Construct )
,		SchemaEntry("absorbed_dose_measure_with_unit",&STEP::ObjectHelper<absorbed_dose_measure_with_unit,0>::Construct )
,		SchemaEntry("derived_unit",&STEP::ObjectHelper<derived_unit,1>::Construct )
,		SchemaEntry("absorbed_dose_unit",&STEP::ObjectHelper<absorbed_dose_unit,0>::Construct )
,		SchemaEntry("abstract_variable",&STEP::ObjectHelper<abstract_variable,0>::Construct )
,		SchemaEntry("acceleration_measure_with_unit",&STEP::ObjectHelper<acceleration_measure_with_unit,0>::Construct )
,		SchemaEntry("acceleration_unit",&STEP::ObjectHelper<acceleration_unit,0>::Construct )
,		SchemaEntry("action",&STEP::ObjectHelper<action,3>::Construct )
,		SchemaEntry("action_assignment",&STEP::ObjectHelper<action_assignment,1>::Construct )
,		SchemaEntry("action_directive",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("action_method",&STEP::ObjectHelper<action_method,4>::Construct )
,		SchemaEntry("action_method_assignment",&STEP::ObjectHelper<action_method_assignment,2>::Construct )
,		SchemaEntry("action_method_relationship",&STEP::ObjectHelper<action_method_relationship,4>::Construct )
,		SchemaEntry("action_method_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("action_property",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("action_property_representation",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("action_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("action_request_assignment",&STEP::ObjectHelper<action_request_assignment,1>::Construct )
,		SchemaEntry("action_request_solution",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("action_request_status",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("action_status",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("address",&STEP::ObjectHelper<address,12>::Construct )
,		SchemaEntry("representation",&STEP::ObjectHelper<representation,3>::Construct )
,		SchemaEntry("shape_representation",&STEP::ObjectHelper<shape_representation,0>::Construct )
,		SchemaEntry("advanced_brep_shape_representation",&STEP::ObjectHelper<advanced_brep_shape_representation,0>::Construct )
,		SchemaEntry("face_surface",&STEP::ObjectHelper<face_surface,2>::Construct )
,		SchemaEntry("advanced_face",&STEP::ObjectHelper<advanced_face,0>::Construct )
,		SchemaEntry("alternate_product_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("amount_of_substance_measure_with_unit",&STEP::ObjectHelper<amount_of_substance_measure_with_unit,0>::Construct )
,		SchemaEntry("named_unit",&STEP::ObjectHelper<named_unit,1>::Construct )
,		SchemaEntry("amount_of_substance_unit",&STEP::ObjectHelper<amount_of_substance_unit,0>::Construct )
,		SchemaEntry("angle_direction_reference",&STEP::ObjectHelper<angle_direction_reference,0>::Construct )
,		SchemaEntry("representation_item",&STEP::ObjectHelper<representation_item,1>::Construct )
,		SchemaEntry("geometric_representation_item",&STEP::ObjectHelper<geometric_representation_item,0>::Construct )
,		SchemaEntry("draughting_callout",&STEP::ObjectHelper<draughting_callout,1>::Construct )
,		SchemaEntry("dimension_curve_directed_callout",&STEP::ObjectHelper<dimension_curve_directed_callout,0>::Construct )
,		SchemaEntry("angular_dimension",&STEP::ObjectHelper<angular_dimension,0>::Construct )
,		SchemaEntry("shape_aspect_relationship",&STEP::ObjectHelper<shape_aspect_relationship,4>::Construct )
,		SchemaEntry("dimensional_location",&STEP::ObjectHelper<dimensional_location,0>::Construct )
,		SchemaEntry("angular_location",&STEP::ObjectHelper<angular_location,1>::Construct )
,		SchemaEntry("dimensional_size",&STEP::ObjectHelper<dimensional_size,2>::Construct )
,		SchemaEntry("angular_size",&STEP::ObjectHelper<angular_size,1>::Construct )
,		SchemaEntry("geometric_tolerance",&STEP::ObjectHelper<geometric_tolerance,4>::Construct )
,		SchemaEntry("geometric_tolerance_with_datum_reference",&STEP::ObjectHelper<geometric_tolerance_with_datum_reference,1>::Construct )
,		SchemaEntry("angularity_tolerance",&STEP::ObjectHelper<angularity_tolerance,0>::Construct )
,		SchemaEntry("styled_item",&STEP::ObjectHelper<styled_item,2>::Construct )
,		SchemaEntry("annotation_occurrence",&STEP::ObjectHelper<annotation_occurrence,0>::Construct )
,		SchemaEntry("annotation_curve_occurrence",&STEP::ObjectHelper<annotation_curve_occurrence,0>::Construct )
,		SchemaEntry("annotation_fill_area",&STEP::ObjectHelper<annotation_fill_area,1>::Construct )
,		SchemaEntry("annotation_fill_area_occurrence",&STEP::ObjectHelper<annotation_fill_area_occurrence,1>::Construct )
,		SchemaEntry("annotation_occurrence_relationship",&STEP::ObjectHelper<annotation_occurrence_relationship,4>::Construct )
,		SchemaEntry("annotation_occurrence_associativity",&STEP::ObjectHelper<annotation_occurrence_associativity,0>::Construct )
,		SchemaEntry("annotation_plane",&STEP::ObjectHelper<annotation_plane,1>::Construct )
,		SchemaEntry("annotation_symbol_occurrence",&STEP::ObjectHelper<annotation_symbol_occurrence,0>::Construct )
,		SchemaEntry("annotation_subfigure_occurrence",&STEP::ObjectHelper<annotation_subfigure_occurrence,0>::Construct )
,		SchemaEntry("mapped_item",&STEP::ObjectHelper<mapped_item,2>::Construct )
,		SchemaEntry("annotation_symbol",&STEP::ObjectHelper<annotation_symbol,0>::Construct )
,		SchemaEntry("annotation_text",&STEP::ObjectHelper<annotation_text,0>::Construct )
,		SchemaEntry("annotation_text_character",&STEP::ObjectHelper<annotation_text_character,1>::Construct )
,		SchemaEntry("annotation_text_occurrence",&STEP::ObjectHelper<annotation_text_occurrence,0>::Construct )
,		SchemaEntry("shape_aspect",&STEP::ObjectHelper<shape_aspect,4>::Construct )
,		SchemaEntry("derived_shape_aspect",&STEP::ObjectHelper<derived_shape_aspect,0>::Construct )
,		SchemaEntry("apex",&STEP::ObjectHelper<apex,0>::Construct )
,		SchemaEntry("application_context",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("application_context_element",&STEP::ObjectHelper<application_context_element,2>::Construct )
,		SchemaEntry("application_protocol_definition",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("applied_action_assignment",&STEP::ObjectHelper<applied_action_assignment,1>::Construct )
,		SchemaEntry("applied_action_method_assignment",&STEP::ObjectHelper<applied_action_method_assignment,1>::Construct )
,		SchemaEntry("applied_action_request_assignment",&STEP::ObjectHelper<applied_action_request_assignment,1>::Construct )
,		SchemaEntry("approval_assignment",&STEP::ObjectHelper<approval_assignment,1>::Construct )
,		SchemaEntry("applied_approval_assignment",&STEP::ObjectHelper<applied_approval_assignment,1>::Construct )
,		SchemaEntry("attribute_classification_assignment",&STEP::ObjectHelper<attribute_classification_assignment,3>::Construct )
,		SchemaEntry("applied_attribute_classification_assignment",&STEP::ObjectHelper<applied_attribute_classification_assignment,1>::Construct )
,		SchemaEntry("certification_assignment",&STEP::ObjectHelper<certification_assignment,1>::Construct )
,		SchemaEntry("applied_certification_assignment",&STEP::ObjectHelper<applied_certification_assignment,1>::Construct )
,		SchemaEntry("classification_assignment",&STEP::ObjectHelper<classification_assignment,2>::Construct )
,		SchemaEntry("applied_classification_assignment",&STEP::ObjectHelper<applied_classification_assignment,1>::Construct )
,		SchemaEntry("contract_assignment",&STEP::ObjectHelper<contract_assignment,1>::Construct )
,		SchemaEntry("applied_contract_assignment",&STEP::ObjectHelper<applied_contract_assignment,1>::Construct )
,		SchemaEntry("date_and_time_assignment",&STEP::ObjectHelper<date_and_time_assignment,2>::Construct )
,		SchemaEntry("applied_date_and_time_assignment",&STEP::ObjectHelper<applied_date_and_time_assignment,1>::Construct )
,		SchemaEntry("date_assignment",&STEP::ObjectHelper<date_assignment,2>::Construct )
,		SchemaEntry("applied_date_assignment",&STEP::ObjectHelper<applied_date_assignment,1>::Construct )
,		SchemaEntry("document_reference",&STEP::ObjectHelper<document_reference,2>::Construct )
,		SchemaEntry("applied_document_reference",&STEP::ObjectHelper<applied_document_reference,1>::Construct )
,		SchemaEntry("document_usage_constraint_assignment",&STEP::ObjectHelper<document_usage_constraint_assignment,2>::Construct )
,		SchemaEntry("applied_document_usage_constraint_assignment",&STEP::ObjectHelper<applied_document_usage_constraint_assignment,1>::Construct )
,		SchemaEntry("effectivity_assignment",&STEP::ObjectHelper<effectivity_assignment,1>::Construct )
,		SchemaEntry("applied_effectivity_assignment",&STEP::ObjectHelper<applied_effectivity_assignment,1>::Construct )
,		SchemaEntry("event_occurrence_assignment",&STEP::ObjectHelper<event_occurrence_assignment,2>::Construct )
,		SchemaEntry("applied_event_occurrence_assignment",&STEP::ObjectHelper<applied_event_occurrence_assignment,1>::Construct )
,		SchemaEntry("identification_assignment",&STEP::ObjectHelper<identification_assignment,2>::Construct )
,		SchemaEntry("external_identification_assignment",&STEP::ObjectHelper<external_identification_assignment,1>::Construct )
,		SchemaEntry("applied_external_identification_assignment",&STEP::ObjectHelper<applied_external_identification_assignment,1>::Construct )
,		SchemaEntry("group_assignment",&STEP::ObjectHelper<group_assignment,1>::Construct )
,		SchemaEntry("applied_group_assignment",&STEP::ObjectHelper<applied_group_assignment,1>::Construct )
,		SchemaEntry("applied_identification_assignment",&STEP::ObjectHelper<applied_identification_assignment,1>::Construct )
,		SchemaEntry("name_assignment",&STEP::ObjectHelper<name_assignment,1>::Construct )
,		SchemaEntry("applied_name_assignment",&STEP::ObjectHelper<applied_name_assignment,1>::Construct )
,		SchemaEntry("organization_assignment",&STEP::ObjectHelper<organization_assignment,2>::Construct )
,		SchemaEntry("applied_organization_assignment",&STEP::ObjectHelper<applied_organization_assignment,1>::Construct )
,		SchemaEntry("organizational_project_assignment",&STEP::ObjectHelper<organizational_project_assignment,2>::Construct )
,		SchemaEntry("applied_organizational_project_assignment",&STEP::ObjectHelper<applied_organizational_project_assignment,1>::Construct )
,		SchemaEntry("person_and_organization_assignment",&STEP::ObjectHelper<person_and_organization_assignment,2>::Construct )
,		SchemaEntry("applied_person_and_organization_assignment",&STEP::ObjectHelper<applied_person_and_organization_assignment,1>::Construct )
,		SchemaEntry("presented_item",&STEP::ObjectHelper<presented_item,0>::Construct )
,		SchemaEntry("applied_presented_item",&STEP::ObjectHelper<applied_presented_item,1>::Construct )
,		SchemaEntry("security_classification_assignment",&STEP::ObjectHelper<security_classification_assignment,1>::Construct )
,		SchemaEntry("applied_security_classification_assignment",&STEP::ObjectHelper<applied_security_classification_assignment,1>::Construct )
,		SchemaEntry("time_interval_assignment",&STEP::ObjectHelper<time_interval_assignment,2>::Construct )
,		SchemaEntry("applied_time_interval_assignment",&STEP::ObjectHelper<applied_time_interval_assignment,1>::Construct )
,		SchemaEntry("applied_usage_right",&STEP::ObjectHelper<applied_usage_right,0>::Construct )
,		SchemaEntry("approval",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("approval_date_time",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("approval_person_organization",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("approval_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("approval_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("approval_status",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("area_in_set",&STEP::ObjectHelper<area_in_set,2>::Construct )
,		SchemaEntry("area_measure_with_unit",&STEP::ObjectHelper<area_measure_with_unit,0>::Construct )
,		SchemaEntry("area_unit",&STEP::ObjectHelper<area_unit,0>::Construct )
,		SchemaEntry("product_definition_relationship",&STEP::ObjectHelper<product_definition_relationship,5>::Construct )
,		SchemaEntry("product_definition_usage",&STEP::ObjectHelper<product_definition_usage,0>::Construct )
,		SchemaEntry("assembly_component_usage",&STEP::ObjectHelper<assembly_component_usage,1>::Construct )
,		SchemaEntry("assembly_component_usage_substitute",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("assigned_requirement",&STEP::ObjectHelper<assigned_requirement,1>::Construct )
,		SchemaEntry("compound_representation_item",&STEP::ObjectHelper<compound_representation_item,1>::Construct )
,		SchemaEntry("atomic_formula",&STEP::ObjectHelper<atomic_formula,0>::Construct )
,		SchemaEntry("attribute_assertion",&STEP::ObjectHelper<attribute_assertion,0>::Construct )
,		SchemaEntry("attribute_language_assignment",&STEP::ObjectHelper<attribute_language_assignment,1>::Construct )
,		SchemaEntry("attribute_value_assignment",&STEP::ObjectHelper<attribute_value_assignment,3>::Construct )
,		SchemaEntry("attribute_value_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("auxiliary_geometric_representation_item",&STEP::ObjectHelper<auxiliary_geometric_representation_item,0>::Construct )
,		SchemaEntry("placement",&STEP::ObjectHelper<placement,1>::Construct )
,		SchemaEntry("axis1_placement",&STEP::ObjectHelper<axis1_placement,1>::Construct )
,		SchemaEntry("axis2_placement_2d",&STEP::ObjectHelper<axis2_placement_2d,1>::Construct )
,		SchemaEntry("axis2_placement_3d",&STEP::ObjectHelper<axis2_placement_3d,2>::Construct )
,		SchemaEntry("curve",&STEP::ObjectHelper<curve,0>::Construct )
,		SchemaEntry("bounded_curve",&STEP::ObjectHelper<bounded_curve,0>::Construct )
,		SchemaEntry("b_spline_curve",&STEP::ObjectHelper<b_spline_curve,5>::Construct )
,		SchemaEntry("b_spline_curve_with_knots",&STEP::ObjectHelper<b_spline_curve_with_knots,3>::Construct )
,		SchemaEntry("surface",&STEP::ObjectHelper<surface,0>::Construct )
,		SchemaEntry("bounded_surface",&STEP::ObjectHelper<bounded_surface,0>::Construct )
,		SchemaEntry("b_spline_surface",&STEP::ObjectHelper<b_spline_surface,6>::Construct )
,		SchemaEntry("b_spline_surface_with_knots",&STEP::ObjectHelper<b_spline_surface_with_knots,5>::Construct )
,		SchemaEntry("product_definition",&STEP::ObjectHelper<product_definition,4>::Construct )
,		SchemaEntry("rule_software_definition",&STEP::ObjectHelper<rule_software_definition,0>::Construct )
,		SchemaEntry("rule_definition",&STEP::ObjectHelper<rule_definition,0>::Construct )
,		SchemaEntry("back_chaining_rule",&STEP::ObjectHelper<back_chaining_rule,0>::Construct )
,		SchemaEntry("back_chaining_rule_body",&STEP::ObjectHelper<back_chaining_rule_body,0>::Construct )
,		SchemaEntry("colour",&STEP::ObjectHelper<colour,0>::Construct )
,		SchemaEntry("background_colour",&STEP::ObjectHelper<background_colour,1>::Construct )
,		SchemaEntry("beveled_sheet_representation",&STEP::ObjectHelper<beveled_sheet_representation,0>::Construct )
,		SchemaEntry("bezier_curve",&STEP::ObjectHelper<bezier_curve,0>::Construct )
,		SchemaEntry("bezier_surface",&STEP::ObjectHelper<bezier_surface,0>::Construct )
,		SchemaEntry("generic_expression",&STEP::ObjectHelper<generic_expression,0>::Construct )
,		SchemaEntry("binary_generic_expression",&STEP::ObjectHelper<binary_generic_expression,1>::Construct )
,		SchemaEntry("binary_numeric_expression",&STEP::ObjectHelper<binary_numeric_expression,0>::Construct )
,		SchemaEntry("binary_representation_item",&STEP::ObjectHelper<binary_representation_item,1>::Construct )
,		SchemaEntry("block",&STEP::ObjectHelper<block,4>::Construct )
,		SchemaEntry("expression",&STEP::ObjectHelper<expression,0>::Construct )
,		SchemaEntry("boolean_expression",&STEP::ObjectHelper<boolean_expression,0>::Construct )
,		SchemaEntry("boolean_literal",&STEP::ObjectHelper<boolean_literal,1>::Construct )
,		SchemaEntry("boolean_representation_item",&STEP::ObjectHelper<boolean_representation_item,0>::Construct )
,		SchemaEntry("boolean_result",&STEP::ObjectHelper<boolean_result,3>::Construct )
,		SchemaEntry("composite_curve",&STEP::ObjectHelper<composite_curve,2>::Construct )
,		SchemaEntry("composite_curve_on_surface",&STEP::ObjectHelper<composite_curve_on_surface,0>::Construct )
,		SchemaEntry("boundary_curve",&STEP::ObjectHelper<boundary_curve,0>::Construct )
,		SchemaEntry("bounded_pcurve",&STEP::ObjectHelper<bounded_pcurve,0>::Construct )
,		SchemaEntry("bounded_surface_curve",&STEP::ObjectHelper<bounded_surface_curve,0>::Construct )
,		SchemaEntry("founded_item",&STEP::ObjectHelper<founded_item,0>::Construct )
,		SchemaEntry("box_domain",&STEP::ObjectHelper<box_domain,4>::Construct )
,		SchemaEntry("half_space_solid",&STEP::ObjectHelper<half_space_solid,2>::Construct )
,		SchemaEntry("boxed_half_space",&STEP::ObjectHelper<boxed_half_space,1>::Construct )
,		SchemaEntry("breakdown_context",&STEP::ObjectHelper<breakdown_context,0>::Construct )
,		SchemaEntry("breakdown_element_group_assignment",&STEP::ObjectHelper<breakdown_element_group_assignment,1>::Construct )
,		SchemaEntry("breakdown_element_realization",&STEP::ObjectHelper<breakdown_element_realization,0>::Construct )
,		SchemaEntry("breakdown_element_usage",&STEP::ObjectHelper<breakdown_element_usage,0>::Construct )
,		SchemaEntry("breakdown_of",&STEP::ObjectHelper<breakdown_of,0>::Construct )
,		SchemaEntry("solid_model",&STEP::ObjectHelper<solid_model,0>::Construct )
,		SchemaEntry("manifold_solid_brep",&STEP::ObjectHelper<manifold_solid_brep,1>::Construct )
,		SchemaEntry("brep_with_voids",&STEP::ObjectHelper<brep_with_voids,1>::Construct )
,		SchemaEntry("bytes_representation_item",&STEP::ObjectHelper<bytes_representation_item,0>::Construct )
,		SchemaEntry("date",&STEP::ObjectHelper<date,1>::Construct )
,		SchemaEntry("calendar_date",&STEP::ObjectHelper<calendar_date,2>::Construct )
,		SchemaEntry("camera_image",&STEP::ObjectHelper<camera_image,0>::Construct )
,		SchemaEntry("camera_image_3d_with_scale",&STEP::ObjectHelper<camera_image_3d_with_scale,0>::Construct )
,		SchemaEntry("camera_model",&STEP::ObjectHelper<camera_model,0>::Construct )
,		SchemaEntry("camera_model_d3",&STEP::ObjectHelper<camera_model_d3,2>::Construct )
,		SchemaEntry("camera_model_d3_multi_clipping",&STEP::ObjectHelper<camera_model_d3_multi_clipping,1>::Construct )
,		SchemaEntry("camera_model_d3_multi_clipping_intersection",&STEP::ObjectHelper<camera_model_d3_multi_clipping_intersection,1>::Construct )
,		SchemaEntry("camera_model_d3_multi_clipping_union",&STEP::ObjectHelper<camera_model_d3_multi_clipping_union,1>::Construct )
,		SchemaEntry("camera_model_d3_with_hlhsr",&STEP::ObjectHelper<camera_model_d3_with_hlhsr,1>::Construct )
,		SchemaEntry("camera_model_with_light_sources",&STEP::ObjectHelper<camera_model_with_light_sources,1>::Construct )
,		SchemaEntry("representation_map",&STEP::ObjectHelper<representation_map,2>::Construct )
,		SchemaEntry("camera_usage",&STEP::ObjectHelper<camera_usage,0>::Construct )
,		SchemaEntry("capacitance_measure_with_unit",&STEP::ObjectHelper<capacitance_measure_with_unit,0>::Construct )
,		SchemaEntry("capacitance_unit",&STEP::ObjectHelper<capacitance_unit,0>::Construct )
,		SchemaEntry("point",&STEP::ObjectHelper<point,0>::Construct )
,		SchemaEntry("cartesian_point",&STEP::ObjectHelper<cartesian_point,1>::Construct )
,		SchemaEntry("cartesian_transformation_operator",&STEP::ObjectHelper<cartesian_transformation_operator,4>::Construct )
,		SchemaEntry("cartesian_transformation_operator_2d",&STEP::ObjectHelper<cartesian_transformation_operator_2d,0>::Construct )
,		SchemaEntry("cartesian_transformation_operator_3d",&STEP::ObjectHelper<cartesian_transformation_operator_3d,1>::Construct )
,		SchemaEntry("cc_design_approval",&STEP::ObjectHelper<cc_design_approval,1>::Construct )
,		SchemaEntry("cc_design_certification",&STEP::ObjectHelper<cc_design_certification,1>::Construct )
,		SchemaEntry("cc_design_contract",&STEP::ObjectHelper<cc_design_contract,1>::Construct )
,		SchemaEntry("cc_design_date_and_time_assignment",&STEP::ObjectHelper<cc_design_date_and_time_assignment,1>::Construct )
,		SchemaEntry("cc_design_person_and_organization_assignment",&STEP::ObjectHelper<cc_design_person_and_organization_assignment,1>::Construct )
,		SchemaEntry("cc_design_security_classification",&STEP::ObjectHelper<cc_design_security_classification,1>::Construct )
,		SchemaEntry("cc_design_specification_reference",&STEP::ObjectHelper<cc_design_specification_reference,1>::Construct )
,		SchemaEntry("celsius_temperature_measure_with_unit",&STEP::ObjectHelper<celsius_temperature_measure_with_unit,0>::Construct )
,		SchemaEntry("centre_of_symmetry",&STEP::ObjectHelper<centre_of_symmetry,0>::Construct )
,		SchemaEntry("certification",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("certification_type",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("change",&STEP::ObjectHelper<change,1>::Construct )
,		SchemaEntry("change_request",&STEP::ObjectHelper<change_request,1>::Construct )
,		SchemaEntry("character_glyph_font_usage",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("character_glyph_style_outline",&STEP::ObjectHelper<character_glyph_style_outline,1>::Construct )
,		SchemaEntry("character_glyph_style_stroke",&STEP::ObjectHelper<character_glyph_style_stroke,1>::Construct )
,		SchemaEntry("symbol_representation",&STEP::ObjectHelper<symbol_representation,0>::Construct )
,		SchemaEntry("generic_character_glyph_symbol",&STEP::ObjectHelper<generic_character_glyph_symbol,0>::Construct )
,		SchemaEntry("character_glyph_symbol",&STEP::ObjectHelper<character_glyph_symbol,2>::Construct )
,		SchemaEntry("character_glyph_symbol_outline",&STEP::ObjectHelper<character_glyph_symbol_outline,1>::Construct )
,		SchemaEntry("character_glyph_symbol_stroke",&STEP::ObjectHelper<character_glyph_symbol_stroke,1>::Construct )
,		SchemaEntry("general_property",&STEP::ObjectHelper<general_property,3>::Construct )
,		SchemaEntry("characteristic_data_column_header",&STEP::ObjectHelper<characteristic_data_column_header,0>::Construct )
,		SchemaEntry("general_property_relationship",&STEP::ObjectHelper<general_property_relationship,4>::Construct )
,		SchemaEntry("characteristic_data_column_header_link",&STEP::ObjectHelper<characteristic_data_column_header_link,0>::Construct )
,		SchemaEntry("characteristic_data_table_header",&STEP::ObjectHelper<characteristic_data_table_header,0>::Construct )
,		SchemaEntry("characteristic_data_table_header_decomposition",&STEP::ObjectHelper<characteristic_data_table_header_decomposition,0>::Construct )
,		SchemaEntry("group",&STEP::ObjectHelper<group,2>::Construct )
,		SchemaEntry("characteristic_type",&STEP::ObjectHelper<characteristic_type,0>::Construct )
,		SchemaEntry("characterized_class",&STEP::ObjectHelper<characterized_class,0>::Construct )
,		SchemaEntry("characterized_object",&STEP::ObjectHelper<characterized_object,2>::Construct )
,		SchemaEntry("conic",&STEP::ObjectHelper<conic,1>::Construct )
,		SchemaEntry("circle",&STEP::ObjectHelper<circle,1>::Construct )
,		SchemaEntry("circular_runout_tolerance",&STEP::ObjectHelper<circular_runout_tolerance,0>::Construct )
,		SchemaEntry("class_t",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("class_by_extension",&STEP::ObjectHelper<class_by_extension,0>::Construct )
,		SchemaEntry("class_by_intension",&STEP::ObjectHelper<class_by_intension,0>::Construct )
,		SchemaEntry("class_system",&STEP::ObjectHelper<class_system,0>::Construct )
,		SchemaEntry("effectivity_context_assignment",&STEP::ObjectHelper<effectivity_context_assignment,2>::Construct )
,		SchemaEntry("class_usage_effectivity_context_assignment",&STEP::ObjectHelper<class_usage_effectivity_context_assignment,1>::Construct )
,		SchemaEntry("classification_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("topological_representation_item",&STEP::ObjectHelper<topological_representation_item,0>::Construct )
,		SchemaEntry("connected_face_set",&STEP::ObjectHelper<connected_face_set,1>::Construct )
,		SchemaEntry("closed_shell",&STEP::ObjectHelper<closed_shell,0>::Construct )
,		SchemaEntry("coaxiality_tolerance",&STEP::ObjectHelper<coaxiality_tolerance,0>::Construct )
,		SchemaEntry("colour_specification",&STEP::ObjectHelper<colour_specification,1>::Construct )
,		SchemaEntry("colour_rgb",&STEP::ObjectHelper<colour_rgb,3>::Construct )
,		SchemaEntry("common_datum",&STEP::ObjectHelper<common_datum,0>::Construct )
,		SchemaEntry("comparison_expression",&STEP::ObjectHelper<comparison_expression,0>::Construct )
,		SchemaEntry("complex_clause",&STEP::ObjectHelper<complex_clause,0>::Construct )
,		SchemaEntry("complex_conjunctive_clause",&STEP::ObjectHelper<complex_conjunctive_clause,0>::Construct )
,		SchemaEntry("complex_disjunctive_clause",&STEP::ObjectHelper<complex_disjunctive_clause,0>::Construct )
,		SchemaEntry("modified_solid",&STEP::ObjectHelper<modified_solid,2>::Construct )
,		SchemaEntry("shelled_solid",&STEP::ObjectHelper<shelled_solid,2>::Construct )
,		SchemaEntry("complex_shelled_solid",&STEP::ObjectHelper<complex_shelled_solid,1>::Construct )
,		SchemaEntry("composite_assembly_definition",&STEP::ObjectHelper<composite_assembly_definition,0>::Construct )
,		SchemaEntry("composite_assembly_sequence_definition",&STEP::ObjectHelper<composite_assembly_sequence_definition,0>::Construct )
,		SchemaEntry("laminate_table",&STEP::ObjectHelper<laminate_table,0>::Construct )
,		SchemaEntry("part_laminate_table",&STEP::ObjectHelper<part_laminate_table,0>::Construct )
,		SchemaEntry("composite_assembly_table",&STEP::ObjectHelper<composite_assembly_table,0>::Construct )
,		SchemaEntry("composite_curve_segment",&STEP::ObjectHelper<composite_curve_segment,3>::Construct )
,		SchemaEntry("material_designation",&STEP::ObjectHelper<material_designation,2>::Construct )
,		SchemaEntry("composite_material_designation",&STEP::ObjectHelper<composite_material_designation,0>::Construct )
,		SchemaEntry("composite_shape_aspect",&STEP::ObjectHelper<composite_shape_aspect,0>::Construct )
,		SchemaEntry("composite_sheet_representation",&STEP::ObjectHelper<composite_sheet_representation,0>::Construct )
,		SchemaEntry("composite_text",&STEP::ObjectHelper<composite_text,1>::Construct )
,		SchemaEntry("composite_text_with_associated_curves",&STEP::ObjectHelper<composite_text_with_associated_curves,1>::Construct )
,		SchemaEntry("composite_text_with_blanking_box",&STEP::ObjectHelper<composite_text_with_blanking_box,1>::Construct )
,		SchemaEntry("composite_text_with_delineation",&STEP::ObjectHelper<composite_text_with_delineation,1>::Construct )
,		SchemaEntry("composite_text_with_extent",&STEP::ObjectHelper<composite_text_with_extent,1>::Construct )
,		SchemaEntry("compound_shape_representation",&STEP::ObjectHelper<compound_shape_representation,0>::Construct )
,		SchemaEntry("concentricity_tolerance",&STEP::ObjectHelper<concentricity_tolerance,0>::Construct )
,		SchemaEntry("concept_feature_operator",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("concept_feature_relationship",&STEP::ObjectHelper<concept_feature_relationship,4>::Construct )
,		SchemaEntry("concept_feature_relationship_with_condition",&STEP::ObjectHelper<concept_feature_relationship_with_condition,1>::Construct )
,		SchemaEntry("product_concept_feature",&STEP::ObjectHelper<product_concept_feature,3>::Construct )
,		SchemaEntry("conditional_concept_feature",&STEP::ObjectHelper<conditional_concept_feature,1>::Construct )
,		SchemaEntry("conductance_measure_with_unit",&STEP::ObjectHelper<conductance_measure_with_unit,0>::Construct )
,		SchemaEntry("conductance_unit",&STEP::ObjectHelper<conductance_unit,0>::Construct )
,		SchemaEntry("configuration_item",&STEP::ObjectHelper<configuration_item,5>::Construct )
,		SchemaEntry("configurable_item",&STEP::ObjectHelper<configurable_item,1>::Construct )
,		SchemaEntry("configuration_design",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("effectivity",&STEP::ObjectHelper<effectivity,1>::Construct )
,		SchemaEntry("product_definition_effectivity",&STEP::ObjectHelper<product_definition_effectivity,1>::Construct )
,		SchemaEntry("configuration_effectivity",&STEP::ObjectHelper<configuration_effectivity,1>::Construct )
,		SchemaEntry("configuration_item_relationship",&STEP::ObjectHelper<configuration_item_relationship,4>::Construct )
,		SchemaEntry("configuration_item_hierarchical_relationship",&STEP::ObjectHelper<configuration_item_hierarchical_relationship,0>::Construct )
,		SchemaEntry("configuration_item_revision_sequence",&STEP::ObjectHelper<configuration_item_revision_sequence,0>::Construct )
,		SchemaEntry("configured_effectivity_assignment",&STEP::ObjectHelper<configured_effectivity_assignment,1>::Construct )
,		SchemaEntry("configured_effectivity_context_assignment",&STEP::ObjectHelper<configured_effectivity_context_assignment,1>::Construct )
,		SchemaEntry("conical_stepped_hole_transition",&STEP::ObjectHelper<conical_stepped_hole_transition,3>::Construct )
,		SchemaEntry("elementary_surface",&STEP::ObjectHelper<elementary_surface,1>::Construct )
,		SchemaEntry("conical_surface",&STEP::ObjectHelper<conical_surface,2>::Construct )
,		SchemaEntry("connected_edge_set",&STEP::ObjectHelper<connected_edge_set,1>::Construct )
,		SchemaEntry("connected_face_sub_set",&STEP::ObjectHelper<connected_face_sub_set,1>::Construct )
,		SchemaEntry("constructive_geometry_representation",&STEP::ObjectHelper<constructive_geometry_representation,0>::Construct )
,		SchemaEntry("representation_relationship",&STEP::ObjectHelper<representation_relationship,4>::Construct )
,		SchemaEntry("constructive_geometry_representation_relationship",&STEP::ObjectHelper<constructive_geometry_representation_relationship,0>::Construct )
,		SchemaEntry("contact_ratio_representation",&STEP::ObjectHelper<contact_ratio_representation,0>::Construct )
,		SchemaEntry("invisibility",&STEP::ObjectHelper<invisibility,1>::Construct )
,		SchemaEntry("context_dependent_invisibility",&STEP::ObjectHelper<context_dependent_invisibility,1>::Construct )
,		SchemaEntry("over_riding_styled_item",&STEP::ObjectHelper<over_riding_styled_item,1>::Construct )
,		SchemaEntry("context_dependent_over_riding_styled_item",&STEP::ObjectHelper<context_dependent_over_riding_styled_item,1>::Construct )
,		SchemaEntry("context_dependent_shape_representation",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("context_dependent_unit",&STEP::ObjectHelper<context_dependent_unit,1>::Construct )
,		SchemaEntry("contract",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("contract_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("contract_type",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("conversion_based_unit",&STEP::ObjectHelper<conversion_based_unit,2>::Construct )
,		SchemaEntry("coordinated_universal_time_offset",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("csg_shape_representation",&STEP::ObjectHelper<csg_shape_representation,0>::Construct )
,		SchemaEntry("csg_solid",&STEP::ObjectHelper<csg_solid,1>::Construct )
,		SchemaEntry("currency",&STEP::ObjectHelper<currency,0>::Construct )
,		SchemaEntry("currency_measure_with_unit",&STEP::ObjectHelper<currency_measure_with_unit,0>::Construct )
,		SchemaEntry("curve_bounded_surface",&STEP::ObjectHelper<curve_bounded_surface,3>::Construct )
,		SchemaEntry("curve_dimension",&STEP::ObjectHelper<curve_dimension,0>::Construct )
,		SchemaEntry("curve_replica",&STEP::ObjectHelper<curve_replica,2>::Construct )
,		SchemaEntry("curve_style",&STEP::ObjectHelper<curve_style,4>::Construct )
,		SchemaEntry("curve_style_font",&STEP::ObjectHelper<curve_style_font,2>::Construct )
,		SchemaEntry("curve_style_font_and_scaling",&STEP::ObjectHelper<curve_style_font_and_scaling,3>::Construct )
,		SchemaEntry("curve_style_font_pattern",&STEP::ObjectHelper<curve_style_font_pattern,2>::Construct )
,		SchemaEntry("curve_style_rendering",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("curve_swept_solid_shape_representation",&STEP::ObjectHelper<curve_swept_solid_shape_representation,0>::Construct )
,		SchemaEntry("cylindrical_surface",&STEP::ObjectHelper<cylindrical_surface,1>::Construct )
,		SchemaEntry("cylindricity_tolerance",&STEP::ObjectHelper<cylindricity_tolerance,0>::Construct )
,		SchemaEntry("data_environment",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("date_and_time",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("date_representation_item",&STEP::ObjectHelper<date_representation_item,0>::Construct )
,		SchemaEntry("date_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("date_time_representation_item",&STEP::ObjectHelper<date_time_representation_item,0>::Construct )
,		SchemaEntry("date_time_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("dated_effectivity",&STEP::ObjectHelper<dated_effectivity,2>::Construct )
,		SchemaEntry("datum",&STEP::ObjectHelper<datum,1>::Construct )
,		SchemaEntry("datum_feature",&STEP::ObjectHelper<datum_feature,0>::Construct )
,		SchemaEntry("datum_feature_callout",&STEP::ObjectHelper<datum_feature_callout,0>::Construct )
,		SchemaEntry("datum_reference",&STEP::ObjectHelper<datum_reference,2>::Construct )
,		SchemaEntry("datum_target",&STEP::ObjectHelper<datum_target,1>::Construct )
,		SchemaEntry("datum_target_callout",&STEP::ObjectHelper<datum_target_callout,0>::Construct )
,		SchemaEntry("default_tolerance_table",&STEP::ObjectHelper<default_tolerance_table,0>::Construct )
,		SchemaEntry("default_tolerance_table_cell",&STEP::ObjectHelper<default_tolerance_table_cell,0>::Construct )
,		SchemaEntry("defined_symbol",&STEP::ObjectHelper<defined_symbol,2>::Construct )
,		SchemaEntry("definitional_representation",&STEP::ObjectHelper<definitional_representation,0>::Construct )
,		SchemaEntry("definitional_representation_relationship",&STEP::ObjectHelper<definitional_representation_relationship,0>::Construct )
,		SchemaEntry("definitional_representation_relationship_with_same_context",&STEP::ObjectHelper<definitional_representation_relationship_with_same_context,0>::Construct )
,		SchemaEntry("degenerate_pcurve",&STEP::ObjectHelper<degenerate_pcurve,2>::Construct )
,		SchemaEntry("toroidal_surface",&STEP::ObjectHelper<toroidal_surface,2>::Construct )
,		SchemaEntry("degenerate_toroidal_surface",&STEP::ObjectHelper<degenerate_toroidal_surface,1>::Construct )
,		SchemaEntry("derived_unit_element",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("description_attribute",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("descriptive_representation_item",&STEP::ObjectHelper<descriptive_representation_item,1>::Construct )
,		SchemaEntry("product_definition_context",&STEP::ObjectHelper<product_definition_context,1>::Construct )
,		SchemaEntry("design_context",&STEP::ObjectHelper<design_context,0>::Construct )
,		SchemaEntry("design_make_from_relationship",&STEP::ObjectHelper<design_make_from_relationship,0>::Construct )
,		SchemaEntry("diameter_dimension",&STEP::ObjectHelper<diameter_dimension,0>::Construct )
,		SchemaEntry("ratio_measure_with_unit",&STEP::ObjectHelper<ratio_measure_with_unit,0>::Construct )
,		SchemaEntry("dielectric_constant_measure_with_unit",&STEP::ObjectHelper<dielectric_constant_measure_with_unit,0>::Construct )
,		SchemaEntry("dimension_callout",&STEP::ObjectHelper<dimension_callout,0>::Construct )
,		SchemaEntry("draughting_callout_relationship",&STEP::ObjectHelper<draughting_callout_relationship,4>::Construct )
,		SchemaEntry("dimension_callout_component_relationship",&STEP::ObjectHelper<dimension_callout_component_relationship,0>::Construct )
,		SchemaEntry("dimension_callout_relationship",&STEP::ObjectHelper<dimension_callout_relationship,0>::Construct )
,		SchemaEntry("dimension_curve",&STEP::ObjectHelper<dimension_curve,0>::Construct )
,		SchemaEntry("terminator_symbol",&STEP::ObjectHelper<terminator_symbol,1>::Construct )
,		SchemaEntry("dimension_curve_terminator",&STEP::ObjectHelper<dimension_curve_terminator,1>::Construct )
,		SchemaEntry("dimension_curve_terminator_to_projection_curve_associativity",&STEP::ObjectHelper<dimension_curve_terminator_to_projection_curve_associativity,0>::Construct )
,		SchemaEntry("dimension_pair",&STEP::ObjectHelper<dimension_pair,0>::Construct )
,		SchemaEntry("dimension_related_tolerance_zone_element",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("dimension_text_associativity",&STEP::ObjectHelper<dimension_text_associativity,0>::Construct )
,		SchemaEntry("dimensional_characteristic_representation",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("dimensional_exponents",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("dimensional_location_with_path",&STEP::ObjectHelper<dimensional_location_with_path,1>::Construct )
,		SchemaEntry("dimensional_size_with_path",&STEP::ObjectHelper<dimensional_size_with_path,1>::Construct )
,		SchemaEntry("executed_action",&STEP::ObjectHelper<executed_action,0>::Construct )
,		SchemaEntry("directed_action",&STEP::ObjectHelper<directed_action,1>::Construct )
,		SchemaEntry("directed_dimensional_location",&STEP::ObjectHelper<directed_dimensional_location,0>::Construct )
,		SchemaEntry("direction",&STEP::ObjectHelper<direction,1>::Construct )
,		SchemaEntry("document",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("document_file",&STEP::ObjectHelper<document_file,0>::Construct )
,		SchemaEntry("document_identifier",&STEP::ObjectHelper<document_identifier,0>::Construct )
,		SchemaEntry("document_identifier_assignment",&STEP::ObjectHelper<document_identifier_assignment,1>::Construct )
,		SchemaEntry("document_product_association",&STEP::ObjectHelper<document_product_association,4>::Construct )
,		SchemaEntry("document_product_equivalence",&STEP::ObjectHelper<document_product_equivalence,0>::Construct )
,		SchemaEntry("document_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("document_representation_type",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("document_type",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("document_usage_constraint",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("document_usage_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("dose_equivalent_measure_with_unit",&STEP::ObjectHelper<dose_equivalent_measure_with_unit,0>::Construct )
,		SchemaEntry("dose_equivalent_unit",&STEP::ObjectHelper<dose_equivalent_unit,0>::Construct )
,		SchemaEntry("double_offset_shelled_solid",&STEP::ObjectHelper<double_offset_shelled_solid,1>::Construct )
,		SchemaEntry("item_defined_transformation",&STEP::ObjectHelper<item_defined_transformation,4>::Construct )
,		SchemaEntry("transformation_with_derived_angle",&STEP::ObjectHelper<transformation_with_derived_angle,0>::Construct )
,		SchemaEntry("draped_defined_transformation",&STEP::ObjectHelper<draped_defined_transformation,0>::Construct )
,		SchemaEntry("draughting_annotation_occurrence",&STEP::ObjectHelper<draughting_annotation_occurrence,0>::Construct )
,		SchemaEntry("draughting_elements",&STEP::ObjectHelper<draughting_elements,0>::Construct )
,		SchemaEntry("draughting_model",&STEP::ObjectHelper<draughting_model,0>::Construct )
,		SchemaEntry("item_identified_representation_usage",&STEP::ObjectHelper<item_identified_representation_usage,5>::Construct )
,		SchemaEntry("draughting_model_item_association",&STEP::ObjectHelper<draughting_model_item_association,0>::Construct )
,		SchemaEntry("pre_defined_colour",&STEP::ObjectHelper<pre_defined_colour,0>::Construct )
,		SchemaEntry("draughting_pre_defined_colour",&STEP::ObjectHelper<draughting_pre_defined_colour,0>::Construct )
,		SchemaEntry("pre_defined_item",&STEP::ObjectHelper<pre_defined_item,1>::Construct )
,		SchemaEntry("pre_defined_curve_font",&STEP::ObjectHelper<pre_defined_curve_font,0>::Construct )
,		SchemaEntry("draughting_pre_defined_curve_font",&STEP::ObjectHelper<draughting_pre_defined_curve_font,0>::Construct )
,		SchemaEntry("pre_defined_text_font",&STEP::ObjectHelper<pre_defined_text_font,0>::Construct )
,		SchemaEntry("draughting_pre_defined_text_font",&STEP::ObjectHelper<draughting_pre_defined_text_font,0>::Construct )
,		SchemaEntry("draughting_subfigure_representation",&STEP::ObjectHelper<draughting_subfigure_representation,0>::Construct )
,		SchemaEntry("draughting_symbol_representation",&STEP::ObjectHelper<draughting_symbol_representation,0>::Construct )
,		SchemaEntry("text_literal",&STEP::ObjectHelper<text_literal,5>::Construct )
,		SchemaEntry("text_literal_with_delineation",&STEP::ObjectHelper<text_literal_with_delineation,1>::Construct )
,		SchemaEntry("draughting_text_literal_with_delineation",&STEP::ObjectHelper<draughting_text_literal_with_delineation,0>::Construct )
,		SchemaEntry("draughting_title",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("drawing_definition",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("presentation_set",&STEP::ObjectHelper<presentation_set,0>::Construct )
,		SchemaEntry("drawing_revision",&STEP::ObjectHelper<drawing_revision,3>::Construct )
,		SchemaEntry("drawing_revision_sequence",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("presentation_representation",&STEP::ObjectHelper<presentation_representation,0>::Construct )
,		SchemaEntry("presentation_area",&STEP::ObjectHelper<presentation_area,0>::Construct )
,		SchemaEntry("drawing_sheet_revision",&STEP::ObjectHelper<drawing_sheet_revision,1>::Construct )
,		SchemaEntry("drawing_sheet_revision_sequence",&STEP::ObjectHelper<drawing_sheet_revision_sequence,0>::Construct )
,		SchemaEntry("drawing_sheet_revision_usage",&STEP::ObjectHelper<drawing_sheet_revision_usage,1>::Construct )
,		SchemaEntry("edge",&STEP::ObjectHelper<edge,2>::Construct )
,		SchemaEntry("edge_based_wireframe_model",&STEP::ObjectHelper<edge_based_wireframe_model,1>::Construct )
,		SchemaEntry("edge_based_wireframe_shape_representation",&STEP::ObjectHelper<edge_based_wireframe_shape_representation,0>::Construct )
,		SchemaEntry("edge_blended_solid",&STEP::ObjectHelper<edge_blended_solid,1>::Construct )
,		SchemaEntry("edge_curve",&STEP::ObjectHelper<edge_curve,2>::Construct )
,		SchemaEntry("edge_loop",&STEP::ObjectHelper<edge_loop,0>::Construct )
,		SchemaEntry("effectivity_context_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("effectivity_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("electric_charge_measure_with_unit",&STEP::ObjectHelper<electric_charge_measure_with_unit,0>::Construct )
,		SchemaEntry("electric_charge_unit",&STEP::ObjectHelper<electric_charge_unit,0>::Construct )
,		SchemaEntry("electric_current_measure_with_unit",&STEP::ObjectHelper<electric_current_measure_with_unit,0>::Construct )
,		SchemaEntry("electric_current_unit",&STEP::ObjectHelper<electric_current_unit,0>::Construct )
,		SchemaEntry("electric_potential_measure_with_unit",&STEP::ObjectHelper<electric_potential_measure_with_unit,0>::Construct )
,		SchemaEntry("electric_potential_unit",&STEP::ObjectHelper<electric_potential_unit,0>::Construct )
,		SchemaEntry("elementary_brep_shape_representation",&STEP::ObjectHelper<elementary_brep_shape_representation,0>::Construct )
,		SchemaEntry("ellipse",&STEP::ObjectHelper<ellipse,2>::Construct )
,		SchemaEntry("energy_measure_with_unit",&STEP::ObjectHelper<energy_measure_with_unit,0>::Construct )
,		SchemaEntry("energy_unit",&STEP::ObjectHelper<energy_unit,0>::Construct )
,		SchemaEntry("property_definition",&STEP::ObjectHelper<property_definition,3>::Construct )
,		SchemaEntry("fact_type",&STEP::ObjectHelper<fact_type,0>::Construct )
,		SchemaEntry("entity_assertion",&STEP::ObjectHelper<entity_assertion,0>::Construct )
,		SchemaEntry("enum_reference_prefix",&STEP::ObjectHelper<enum_reference_prefix,0>::Construct )
,		SchemaEntry("environment",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("evaluated_characteristic",&STEP::ObjectHelper<evaluated_characteristic,0>::Construct )
,		SchemaEntry("evaluated_degenerate_pcurve",&STEP::ObjectHelper<evaluated_degenerate_pcurve,1>::Construct )
,		SchemaEntry("evaluation_product_definition",&STEP::ObjectHelper<evaluation_product_definition,0>::Construct )
,		SchemaEntry("event_occurrence",&STEP::ObjectHelper<event_occurrence,3>::Construct )
,		SchemaEntry("event_occurrence_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("event_occurrence_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("product_concept_feature_category",&STEP::ObjectHelper<product_concept_feature_category,0>::Construct )
,		SchemaEntry("exclusive_product_concept_feature_category",&STEP::ObjectHelper<exclusive_product_concept_feature_category,0>::Construct )
,		SchemaEntry("uncertainty_qualifier",&STEP::ObjectHelper<uncertainty_qualifier,2>::Construct )
,		SchemaEntry("standard_uncertainty",&STEP::ObjectHelper<standard_uncertainty,1>::Construct )
,		SchemaEntry("expanded_uncertainty",&STEP::ObjectHelper<expanded_uncertainty,1>::Construct )
,		SchemaEntry("representation_item_relationship",&STEP::ObjectHelper<representation_item_relationship,4>::Construct )
,		SchemaEntry("explicit_procedural_representation_item_relationship",&STEP::ObjectHelper<explicit_procedural_representation_item_relationship,0>::Construct )
,		SchemaEntry("explicit_procedural_geometric_representation_item_relationship",&STEP::ObjectHelper<explicit_procedural_geometric_representation_item_relationship,0>::Construct )
,		SchemaEntry("explicit_procedural_representation_relationship",&STEP::ObjectHelper<explicit_procedural_representation_relationship,0>::Construct )
,		SchemaEntry("explicit_procedural_shape_representation_relationship",&STEP::ObjectHelper<explicit_procedural_shape_representation_relationship,0>::Construct )
,		SchemaEntry("expression_conversion_based_unit",&STEP::ObjectHelper<expression_conversion_based_unit,0>::Construct )
,		SchemaEntry("extension",&STEP::ObjectHelper<extension,0>::Construct )
,		SchemaEntry("extent",&STEP::ObjectHelper<extent,0>::Construct )
,		SchemaEntry("external_source",&STEP::ObjectHelper<external_source,1>::Construct )
,		SchemaEntry("external_class_library",&STEP::ObjectHelper<external_class_library,0>::Construct )
,		SchemaEntry("external_source_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("externally_defined_class",&STEP::ObjectHelper<externally_defined_class,0>::Construct )
,		SchemaEntry("externally_defined_colour",&STEP::ObjectHelper<externally_defined_colour,0>::Construct )
,		SchemaEntry("externally_defined_context_dependent_unit",&STEP::ObjectHelper<externally_defined_context_dependent_unit,0>::Construct )
,		SchemaEntry("externally_defined_conversion_based_unit",&STEP::ObjectHelper<externally_defined_conversion_based_unit,0>::Construct )
,		SchemaEntry("externally_defined_currency",&STEP::ObjectHelper<externally_defined_currency,0>::Construct )
,		SchemaEntry("externally_defined_item",&STEP::ObjectHelper<externally_defined_item,2>::Construct )
,		SchemaEntry("externally_defined_curve_font",&STEP::ObjectHelper<externally_defined_curve_font,0>::Construct )
,		SchemaEntry("externally_defined_dimension_definition",&STEP::ObjectHelper<externally_defined_dimension_definition,0>::Construct )
,		SchemaEntry("externally_defined_general_property",&STEP::ObjectHelper<externally_defined_general_property,0>::Construct )
,		SchemaEntry("externally_defined_hatch_style",&STEP::ObjectHelper<externally_defined_hatch_style,0>::Construct )
,		SchemaEntry("externally_defined_item_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("externally_defined_marker",&STEP::ObjectHelper<externally_defined_marker,0>::Construct )
,		SchemaEntry("picture_representation_item",&STEP::ObjectHelper<picture_representation_item,0>::Construct )
,		SchemaEntry("externally_defined_picture_representation_item",&STEP::ObjectHelper<externally_defined_picture_representation_item,0>::Construct )
,		SchemaEntry("externally_defined_representation_item",&STEP::ObjectHelper<externally_defined_representation_item,0>::Construct )
,		SchemaEntry("externally_defined_string",&STEP::ObjectHelper<externally_defined_string,0>::Construct )
,		SchemaEntry("externally_defined_symbol",&STEP::ObjectHelper<externally_defined_symbol,0>::Construct )
,		SchemaEntry("externally_defined_terminator_symbol",&STEP::ObjectHelper<externally_defined_terminator_symbol,0>::Construct )
,		SchemaEntry("externally_defined_text_font",&STEP::ObjectHelper<externally_defined_text_font,0>::Construct )
,		SchemaEntry("externally_defined_tile",&STEP::ObjectHelper<externally_defined_tile,0>::Construct )
,		SchemaEntry("externally_defined_tile_style",&STEP::ObjectHelper<externally_defined_tile_style,0>::Construct )
,		SchemaEntry("swept_area_solid",&STEP::ObjectHelper<swept_area_solid,1>::Construct )
,		SchemaEntry("extruded_area_solid",&STEP::ObjectHelper<extruded_area_solid,2>::Construct )
,		SchemaEntry("swept_face_solid",&STEP::ObjectHelper<swept_face_solid,1>::Construct )
,		SchemaEntry("extruded_face_solid",&STEP::ObjectHelper<extruded_face_solid,2>::Construct )
,		SchemaEntry("extruded_face_solid_with_trim_conditions",&STEP::ObjectHelper<extruded_face_solid_with_trim_conditions,6>::Construct )
,		SchemaEntry("extruded_face_solid_with_draft_angle",&STEP::ObjectHelper<extruded_face_solid_with_draft_angle,1>::Construct )
,		SchemaEntry("extruded_face_solid_with_multiple_draft_angles",&STEP::ObjectHelper<extruded_face_solid_with_multiple_draft_angles,1>::Construct )
,		SchemaEntry("face",&STEP::ObjectHelper<face,1>::Construct )
,		SchemaEntry("face_based_surface_model",&STEP::ObjectHelper<face_based_surface_model,1>::Construct )
,		SchemaEntry("face_bound",&STEP::ObjectHelper<face_bound,2>::Construct )
,		SchemaEntry("face_outer_bound",&STEP::ObjectHelper<face_outer_bound,0>::Construct )
,		SchemaEntry("faceted_brep",&STEP::ObjectHelper<faceted_brep,0>::Construct )
,		SchemaEntry("faceted_brep_shape_representation",&STEP::ObjectHelper<faceted_brep_shape_representation,0>::Construct )
,		SchemaEntry("fill_area_style",&STEP::ObjectHelper<fill_area_style,2>::Construct )
,		SchemaEntry("fill_area_style_colour",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("fill_area_style_hatching",&STEP::ObjectHelper<fill_area_style_hatching,5>::Construct )
,		SchemaEntry("fill_area_style_tile_coloured_region",&STEP::ObjectHelper<fill_area_style_tile_coloured_region,2>::Construct )
,		SchemaEntry("fill_area_style_tile_curve_with_style",&STEP::ObjectHelper<fill_area_style_tile_curve_with_style,1>::Construct )
,		SchemaEntry("fill_area_style_tile_symbol_with_style",&STEP::ObjectHelper<fill_area_style_tile_symbol_with_style,1>::Construct )
,		SchemaEntry("fill_area_style_tiles",&STEP::ObjectHelper<fill_area_style_tiles,3>::Construct )
,		SchemaEntry("shape_representation_relationship",&STEP::ObjectHelper<shape_representation_relationship,0>::Construct )
,		SchemaEntry("flat_pattern_ply_representation_relationship",&STEP::ObjectHelper<flat_pattern_ply_representation_relationship,0>::Construct )
,		SchemaEntry("flatness_tolerance",&STEP::ObjectHelper<flatness_tolerance,0>::Construct )
,		SchemaEntry("force_measure_with_unit",&STEP::ObjectHelper<force_measure_with_unit,0>::Construct )
,		SchemaEntry("force_unit",&STEP::ObjectHelper<force_unit,0>::Construct )
,		SchemaEntry("forward_chaining_rule",&STEP::ObjectHelper<forward_chaining_rule,0>::Construct )
,		SchemaEntry("forward_chaining_rule_premise",&STEP::ObjectHelper<forward_chaining_rule_premise,0>::Construct )
,		SchemaEntry("frequency_measure_with_unit",&STEP::ObjectHelper<frequency_measure_with_unit,0>::Construct )
,		SchemaEntry("frequency_unit",&STEP::ObjectHelper<frequency_unit,0>::Construct )
,		SchemaEntry("func",&STEP::ObjectHelper<func,0>::Construct )
,		SchemaEntry("functional_breakdown_context",&STEP::ObjectHelper<functional_breakdown_context,0>::Construct )
,		SchemaEntry("functional_element_usage",&STEP::ObjectHelper<functional_element_usage,0>::Construct )
,		SchemaEntry("functionally_defined_transformation",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("general_material_property",&STEP::ObjectHelper<general_material_property,0>::Construct )
,		SchemaEntry("general_property_association",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("simple_generic_expression",&STEP::ObjectHelper<simple_generic_expression,0>::Construct )
,		SchemaEntry("generic_literal",&STEP::ObjectHelper<generic_literal,0>::Construct )
,		SchemaEntry("generic_variable",&STEP::ObjectHelper<generic_variable,0>::Construct )
,		SchemaEntry("geometric_alignment",&STEP::ObjectHelper<geometric_alignment,0>::Construct )
,		SchemaEntry("geometric_set",&STEP::ObjectHelper<geometric_set,1>::Construct )
,		SchemaEntry("geometric_curve_set",&STEP::ObjectHelper<geometric_curve_set,0>::Construct )
,		SchemaEntry("geometric_intersection",&STEP::ObjectHelper<geometric_intersection,0>::Construct )
,		SchemaEntry("geometric_item_specific_usage",&STEP::ObjectHelper<geometric_item_specific_usage,0>::Construct )
,		SchemaEntry("geometric_model_element_relationship",&STEP::ObjectHelper<geometric_model_element_relationship,0>::Construct )
,		SchemaEntry("representation_context",&STEP::ObjectHelper<representation_context,2>::Construct )
,		SchemaEntry("geometric_representation_context",&STEP::ObjectHelper<geometric_representation_context,1>::Construct )
,		SchemaEntry("geometric_tolerance_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("geometric_tolerance_with_defined_unit",&STEP::ObjectHelper<geometric_tolerance_with_defined_unit,1>::Construct )
,		SchemaEntry("geometrical_tolerance_callout",&STEP::ObjectHelper<geometrical_tolerance_callout,0>::Construct )
,		SchemaEntry("geometrically_bounded_2d_wireframe_representation",&STEP::ObjectHelper<geometrically_bounded_2d_wireframe_representation,0>::Construct )
,		SchemaEntry("geometrically_bounded_surface_shape_representation",&STEP::ObjectHelper<geometrically_bounded_surface_shape_representation,0>::Construct )
,		SchemaEntry("geometrically_bounded_wireframe_shape_representation",&STEP::ObjectHelper<geometrically_bounded_wireframe_shape_representation,0>::Construct )
,		SchemaEntry("global_assignment",&STEP::ObjectHelper<global_assignment,0>::Construct )
,		SchemaEntry("global_uncertainty_assigned_context",&STEP::ObjectHelper<global_uncertainty_assigned_context,1>::Construct )
,		SchemaEntry("global_unit_assigned_context",&STEP::ObjectHelper<global_unit_assigned_context,1>::Construct )
,		SchemaEntry("ground_fact",&STEP::ObjectHelper<ground_fact,0>::Construct )
,		SchemaEntry("group_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("hardness_representation",&STEP::ObjectHelper<hardness_representation,0>::Construct )
,		SchemaEntry("hidden_element_over_riding_styled_item",&STEP::ObjectHelper<hidden_element_over_riding_styled_item,0>::Construct )
,		SchemaEntry("hyperbola",&STEP::ObjectHelper<hyperbola,2>::Construct )
,		SchemaEntry("id_attribute",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("identification_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("illuminance_measure_with_unit",&STEP::ObjectHelper<illuminance_measure_with_unit,0>::Construct )
,		SchemaEntry("illuminance_unit",&STEP::ObjectHelper<illuminance_unit,0>::Construct )
,		SchemaEntry("included_text_block",&STEP::ObjectHelper<included_text_block,0>::Construct )
,		SchemaEntry("inclusion_product_concept_feature",&STEP::ObjectHelper<inclusion_product_concept_feature,0>::Construct )
,		SchemaEntry("user_selected_elements",&STEP::ObjectHelper<user_selected_elements,1>::Construct )
,		SchemaEntry("indirectly_selected_elements",&STEP::ObjectHelper<indirectly_selected_elements,1>::Construct )
,		SchemaEntry("indirectly_selected_shape_elements",&STEP::ObjectHelper<indirectly_selected_shape_elements,0>::Construct )
,		SchemaEntry("inductance_measure_with_unit",&STEP::ObjectHelper<inductance_measure_with_unit,0>::Construct )
,		SchemaEntry("inductance_unit",&STEP::ObjectHelper<inductance_unit,0>::Construct )
,		SchemaEntry("information_right",&STEP::ObjectHelper<information_right,0>::Construct )
,		SchemaEntry("information_usage_right",&STEP::ObjectHelper<information_usage_right,0>::Construct )
,		SchemaEntry("instance_usage_context_assignment",&STEP::ObjectHelper<instance_usage_context_assignment,1>::Construct )
,		SchemaEntry("instanced_feature",&STEP::ObjectHelper<instanced_feature,0>::Construct )
,		SchemaEntry("literal_number",&STEP::ObjectHelper<literal_number,1>::Construct )
,		SchemaEntry("int_literal",&STEP::ObjectHelper<int_literal,0>::Construct )
,		SchemaEntry("integer_representation_item",&STEP::ObjectHelper<integer_representation_item,0>::Construct )
,		SchemaEntry("surface_curve",&STEP::ObjectHelper<surface_curve,3>::Construct )
,		SchemaEntry("intersection_curve",&STEP::ObjectHelper<intersection_curve,0>::Construct )
,		SchemaEntry("interval_expression",&STEP::ObjectHelper<interval_expression,0>::Construct )
,		SchemaEntry("iso4217_currency",&STEP::ObjectHelper<iso4217_currency,0>::Construct )
,		SchemaEntry("known_source",&STEP::ObjectHelper<known_source,0>::Construct )
,		SchemaEntry("laid_defined_transformation",&STEP::ObjectHelper<laid_defined_transformation,0>::Construct )
,		SchemaEntry("language",&STEP::ObjectHelper<language,0>::Construct )
,		SchemaEntry("leader_curve",&STEP::ObjectHelper<leader_curve,0>::Construct )
,		SchemaEntry("leader_directed_callout",&STEP::ObjectHelper<leader_directed_callout,0>::Construct )
,		SchemaEntry("leader_directed_dimension",&STEP::ObjectHelper<leader_directed_dimension,0>::Construct )
,		SchemaEntry("leader_terminator",&STEP::ObjectHelper<leader_terminator,0>::Construct )
,		SchemaEntry("length_measure_with_unit",&STEP::ObjectHelper<length_measure_with_unit,0>::Construct )
,		SchemaEntry("length_unit",&STEP::ObjectHelper<length_unit,0>::Construct )
,		SchemaEntry("light_source",&STEP::ObjectHelper<light_source,1>::Construct )
,		SchemaEntry("light_source_ambient",&STEP::ObjectHelper<light_source_ambient,0>::Construct )
,		SchemaEntry("light_source_directional",&STEP::ObjectHelper<light_source_directional,1>::Construct )
,		SchemaEntry("light_source_positional",&STEP::ObjectHelper<light_source_positional,3>::Construct )
,		SchemaEntry("light_source_spot",&STEP::ObjectHelper<light_source_spot,6>::Construct )
,		SchemaEntry("limits_and_fits",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("line",&STEP::ObjectHelper<line,2>::Construct )
,		SchemaEntry("line_profile_tolerance",&STEP::ObjectHelper<line_profile_tolerance,0>::Construct )
,		SchemaEntry("linear_dimension",&STEP::ObjectHelper<linear_dimension,0>::Construct )
,		SchemaEntry("simple_clause",&STEP::ObjectHelper<simple_clause,0>::Construct )
,		SchemaEntry("literal_conjunction",&STEP::ObjectHelper<literal_conjunction,0>::Construct )
,		SchemaEntry("literal_disjunction",&STEP::ObjectHelper<literal_disjunction,0>::Construct )
,		SchemaEntry("local_time",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("logical_literal",&STEP::ObjectHelper<logical_literal,1>::Construct )
,		SchemaEntry("logical_representation_item",&STEP::ObjectHelper<logical_representation_item,0>::Construct )
,		SchemaEntry("loop",&STEP::ObjectHelper<loop,0>::Construct )
,		SchemaEntry("loss_tangent_measure_with_unit",&STEP::ObjectHelper<loss_tangent_measure_with_unit,0>::Construct )
,		SchemaEntry("lot_effectivity",&STEP::ObjectHelper<lot_effectivity,2>::Construct )
,		SchemaEntry("luminous_flux_measure_with_unit",&STEP::ObjectHelper<luminous_flux_measure_with_unit,0>::Construct )
,		SchemaEntry("luminous_flux_unit",&STEP::ObjectHelper<luminous_flux_unit,0>::Construct )
,		SchemaEntry("luminous_intensity_measure_with_unit",&STEP::ObjectHelper<luminous_intensity_measure_with_unit,0>::Construct )
,		SchemaEntry("luminous_intensity_unit",&STEP::ObjectHelper<luminous_intensity_unit,0>::Construct )
,		SchemaEntry("magnetic_flux_density_measure_with_unit",&STEP::ObjectHelper<magnetic_flux_density_measure_with_unit,0>::Construct )
,		SchemaEntry("magnetic_flux_density_unit",&STEP::ObjectHelper<magnetic_flux_density_unit,0>::Construct )
,		SchemaEntry("magnetic_flux_measure_with_unit",&STEP::ObjectHelper<magnetic_flux_measure_with_unit,0>::Construct )
,		SchemaEntry("magnetic_flux_unit",&STEP::ObjectHelper<magnetic_flux_unit,0>::Construct )
,		SchemaEntry("make_from_usage_option",&STEP::ObjectHelper<make_from_usage_option,3>::Construct )
,		SchemaEntry("manifold_subsurface_shape_representation",&STEP::ObjectHelper<manifold_subsurface_shape_representation,0>::Construct )
,		SchemaEntry("manifold_surface_shape_representation",&STEP::ObjectHelper<manifold_surface_shape_representation,0>::Construct )
,		SchemaEntry("mass_measure_with_unit",&STEP::ObjectHelper<mass_measure_with_unit,0>::Construct )
,		SchemaEntry("mass_unit",&STEP::ObjectHelper<mass_unit,0>::Construct )
,		SchemaEntry("material_designation_characterization",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("material_property",&STEP::ObjectHelper<material_property,0>::Construct )
,		SchemaEntry("property_definition_representation",&STEP::ObjectHelper<property_definition_representation,2>::Construct )
,		SchemaEntry("material_property_representation",&STEP::ObjectHelper<material_property_representation,1>::Construct )
,		SchemaEntry("measure_qualification",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("measure_representation_item",&STEP::ObjectHelper<measure_representation_item,0>::Construct )
,		SchemaEntry("product_context",&STEP::ObjectHelper<product_context,1>::Construct )
,		SchemaEntry("mechanical_context",&STEP::ObjectHelper<mechanical_context,0>::Construct )
,		SchemaEntry("mechanical_design_and_draughting_relationship",&STEP::ObjectHelper<mechanical_design_and_draughting_relationship,0>::Construct )
,		SchemaEntry("mechanical_design_geometric_presentation_area",&STEP::ObjectHelper<mechanical_design_geometric_presentation_area,0>::Construct )
,		SchemaEntry("mechanical_design_geometric_presentation_representation",&STEP::ObjectHelper<mechanical_design_geometric_presentation_representation,0>::Construct )
,		SchemaEntry("mechanical_design_presentation_representation_with_draughting",&STEP::ObjectHelper<mechanical_design_presentation_representation_with_draughting,0>::Construct )
,		SchemaEntry("mechanical_design_shaded_presentation_area",&STEP::ObjectHelper<mechanical_design_shaded_presentation_area,0>::Construct )
,		SchemaEntry("mechanical_design_shaded_presentation_representation",&STEP::ObjectHelper<mechanical_design_shaded_presentation_representation,0>::Construct )
,		SchemaEntry("min_and_major_ply_orientation_basis",&STEP::ObjectHelper<min_and_major_ply_orientation_basis,0>::Construct )
,		SchemaEntry("modified_geometric_tolerance",&STEP::ObjectHelper<modified_geometric_tolerance,1>::Construct )
,		SchemaEntry("modified_solid_with_placed_configuration",&STEP::ObjectHelper<modified_solid_with_placed_configuration,1>::Construct )
,		SchemaEntry("moments_of_inertia_representation",&STEP::ObjectHelper<moments_of_inertia_representation,0>::Construct )
,		SchemaEntry("multi_language_attribute_assignment",&STEP::ObjectHelper<multi_language_attribute_assignment,1>::Construct )
,		SchemaEntry("multiple_arity_boolean_expression",&STEP::ObjectHelper<multiple_arity_boolean_expression,0>::Construct )
,		SchemaEntry("multiple_arity_generic_expression",&STEP::ObjectHelper<multiple_arity_generic_expression,1>::Construct )
,		SchemaEntry("multiple_arity_numeric_expression",&STEP::ObjectHelper<multiple_arity_numeric_expression,0>::Construct )
,		SchemaEntry("name_attribute",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("next_assembly_usage_occurrence",&STEP::ObjectHelper<next_assembly_usage_occurrence,0>::Construct )
,		SchemaEntry("non_manifold_surface_shape_representation",&STEP::ObjectHelper<non_manifold_surface_shape_representation,0>::Construct )
,		SchemaEntry("null_representation_item",&STEP::ObjectHelper<null_representation_item,0>::Construct )
,		SchemaEntry("numeric_expression",&STEP::ObjectHelper<numeric_expression,0>::Construct )
,		SchemaEntry("object_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("offset_curve_2d",&STEP::ObjectHelper<offset_curve_2d,3>::Construct )
,		SchemaEntry("offset_curve_3d",&STEP::ObjectHelper<offset_curve_3d,4>::Construct )
,		SchemaEntry("offset_surface",&STEP::ObjectHelper<offset_surface,3>::Construct )
,		SchemaEntry("one_direction_repeat_factor",&STEP::ObjectHelper<one_direction_repeat_factor,1>::Construct )
,		SchemaEntry("open_shell",&STEP::ObjectHelper<open_shell,0>::Construct )
,		SchemaEntry("ordinal_date",&STEP::ObjectHelper<ordinal_date,1>::Construct )
,		SchemaEntry("projection_directed_callout",&STEP::ObjectHelper<projection_directed_callout,0>::Construct )
,		SchemaEntry("ordinate_dimension",&STEP::ObjectHelper<ordinate_dimension,0>::Construct )
,		SchemaEntry("organization",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("organization_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("organization_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("organizational_address",&STEP::ObjectHelper<organizational_address,2>::Construct )
,		SchemaEntry("organizational_project",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("organizational_project_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("organizational_project_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("oriented_closed_shell",&STEP::ObjectHelper<oriented_closed_shell,2>::Construct )
,		SchemaEntry("oriented_edge",&STEP::ObjectHelper<oriented_edge,2>::Construct )
,		SchemaEntry("oriented_face",&STEP::ObjectHelper<oriented_face,2>::Construct )
,		SchemaEntry("oriented_open_shell",&STEP::ObjectHelper<oriented_open_shell,2>::Construct )
,		SchemaEntry("path",&STEP::ObjectHelper<path,1>::Construct )
,		SchemaEntry("oriented_path",&STEP::ObjectHelper<oriented_path,2>::Construct )
,		SchemaEntry("oriented_surface",&STEP::ObjectHelper<oriented_surface,1>::Construct )
,		SchemaEntry("outer_boundary_curve",&STEP::ObjectHelper<outer_boundary_curve,0>::Construct )
,		SchemaEntry("package_product_concept_feature",&STEP::ObjectHelper<package_product_concept_feature,0>::Construct )
,		SchemaEntry("parabola",&STEP::ObjectHelper<parabola,1>::Construct )
,		SchemaEntry("parallel_offset",&STEP::ObjectHelper<parallel_offset,1>::Construct )
,		SchemaEntry("parallelism_tolerance",&STEP::ObjectHelper<parallelism_tolerance,0>::Construct )
,		SchemaEntry("parametric_representation_context",&STEP::ObjectHelper<parametric_representation_context,0>::Construct )
,		SchemaEntry("partial_document_with_structured_text_representation_assignment",&STEP::ObjectHelper<partial_document_with_structured_text_representation_assignment,0>::Construct )
,		SchemaEntry("pcurve",&STEP::ObjectHelper<pcurve,2>::Construct )
,		SchemaEntry("percentage_laminate_definition",&STEP::ObjectHelper<percentage_laminate_definition,0>::Construct )
,		SchemaEntry("zone_structural_makeup",&STEP::ObjectHelper<zone_structural_makeup,0>::Construct )
,		SchemaEntry("percentage_laminate_table",&STEP::ObjectHelper<percentage_laminate_table,0>::Construct )
,		SchemaEntry("percentage_ply_definition",&STEP::ObjectHelper<percentage_ply_definition,0>::Construct )
,		SchemaEntry("perpendicular_to",&STEP::ObjectHelper<perpendicular_to,0>::Construct )
,		SchemaEntry("perpendicularity_tolerance",&STEP::ObjectHelper<perpendicularity_tolerance,0>::Construct )
,		SchemaEntry("person",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("person_and_organization",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("person_and_organization_address",&STEP::ObjectHelper<person_and_organization_address,0>::Construct )
,		SchemaEntry("person_and_organization_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("personal_address",&STEP::ObjectHelper<personal_address,2>::Construct )
,		SchemaEntry("physical_breakdown_context",&STEP::ObjectHelper<physical_breakdown_context,0>::Construct )
,		SchemaEntry("physical_element_usage",&STEP::ObjectHelper<physical_element_usage,0>::Construct )
,		SchemaEntry("presentation_view",&STEP::ObjectHelper<presentation_view,0>::Construct )
,		SchemaEntry("picture_representation",&STEP::ObjectHelper<picture_representation,0>::Construct )
,		SchemaEntry("placed_datum_target_feature",&STEP::ObjectHelper<placed_datum_target_feature,0>::Construct )
,		SchemaEntry("placed_feature",&STEP::ObjectHelper<placed_feature,0>::Construct )
,		SchemaEntry("planar_extent",&STEP::ObjectHelper<planar_extent,2>::Construct )
,		SchemaEntry("planar_box",&STEP::ObjectHelper<planar_box,1>::Construct )
,		SchemaEntry("plane",&STEP::ObjectHelper<plane,0>::Construct )
,		SchemaEntry("plane_angle_measure_with_unit",&STEP::ObjectHelper<plane_angle_measure_with_unit,0>::Construct )
,		SchemaEntry("plane_angle_unit",&STEP::ObjectHelper<plane_angle_unit,0>::Construct )
,		SchemaEntry("plus_minus_tolerance",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("ply_laminate_definition",&STEP::ObjectHelper<ply_laminate_definition,0>::Construct )
,		SchemaEntry("ply_laminate_sequence_definition",&STEP::ObjectHelper<ply_laminate_sequence_definition,0>::Construct )
,		SchemaEntry("ply_laminate_table",&STEP::ObjectHelper<ply_laminate_table,0>::Construct )
,		SchemaEntry("point_and_vector",&STEP::ObjectHelper<point_and_vector,0>::Construct )
,		SchemaEntry("point_on_curve",&STEP::ObjectHelper<point_on_curve,2>::Construct )
,		SchemaEntry("point_on_surface",&STEP::ObjectHelper<point_on_surface,3>::Construct )
,		SchemaEntry("point_path",&STEP::ObjectHelper<point_path,0>::Construct )
,		SchemaEntry("point_replica",&STEP::ObjectHelper<point_replica,2>::Construct )
,		SchemaEntry("point_style",&STEP::ObjectHelper<point_style,4>::Construct )
,		SchemaEntry("polar_complex_number_literal",&STEP::ObjectHelper<polar_complex_number_literal,2>::Construct )
,		SchemaEntry("poly_loop",&STEP::ObjectHelper<poly_loop,1>::Construct )
,		SchemaEntry("polyline",&STEP::ObjectHelper<polyline,1>::Construct )
,		SchemaEntry("position_tolerance",&STEP::ObjectHelper<position_tolerance,0>::Construct )
,		SchemaEntry("positioned_sketch",&STEP::ObjectHelper<positioned_sketch,2>::Construct )
,		SchemaEntry("power_measure_with_unit",&STEP::ObjectHelper<power_measure_with_unit,0>::Construct )
,		SchemaEntry("power_unit",&STEP::ObjectHelper<power_unit,0>::Construct )
,		SchemaEntry("pre_defined_symbol",&STEP::ObjectHelper<pre_defined_symbol,0>::Construct )
,		SchemaEntry("pre_defined_dimension_symbol",&STEP::ObjectHelper<pre_defined_dimension_symbol,0>::Construct )
,		SchemaEntry("pre_defined_geometrical_tolerance_symbol",&STEP::ObjectHelper<pre_defined_geometrical_tolerance_symbol,0>::Construct )
,		SchemaEntry("pre_defined_marker",&STEP::ObjectHelper<pre_defined_marker,0>::Construct )
,		SchemaEntry("pre_defined_point_marker_symbol",&STEP::ObjectHelper<pre_defined_point_marker_symbol,0>::Construct )
,		SchemaEntry("pre_defined_surface_condition_symbol",&STEP::ObjectHelper<pre_defined_surface_condition_symbol,0>::Construct )
,		SchemaEntry("pre_defined_surface_side_style",&STEP::ObjectHelper<pre_defined_surface_side_style,0>::Construct )
,		SchemaEntry("pre_defined_terminator_symbol",&STEP::ObjectHelper<pre_defined_terminator_symbol,0>::Construct )
,		SchemaEntry("pre_defined_tile",&STEP::ObjectHelper<pre_defined_tile,0>::Construct )
,		SchemaEntry("precision_qualifier",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("predefined_picture_representation_item",&STEP::ObjectHelper<predefined_picture_representation_item,0>::Construct )
,		SchemaEntry("presentation_layer_assignment",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("presentation_size",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("presentation_style_assignment",&STEP::ObjectHelper<presentation_style_assignment,1>::Construct )
,		SchemaEntry("presentation_style_by_context",&STEP::ObjectHelper<presentation_style_by_context,1>::Construct )
,		SchemaEntry("presented_item_representation",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("pressure_measure_with_unit",&STEP::ObjectHelper<pressure_measure_with_unit,0>::Construct )
,		SchemaEntry("pressure_unit",&STEP::ObjectHelper<pressure_unit,0>::Construct )
,		SchemaEntry("procedural_representation",&STEP::ObjectHelper<procedural_representation,0>::Construct )
,		SchemaEntry("procedural_representation_sequence",&STEP::ObjectHelper<procedural_representation_sequence,3>::Construct )
,		SchemaEntry("procedural_shape_representation",&STEP::ObjectHelper<procedural_shape_representation,0>::Construct )
,		SchemaEntry("procedural_shape_representation_sequence",&STEP::ObjectHelper<procedural_shape_representation_sequence,0>::Construct )
,		SchemaEntry("product",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("product_category",&STEP::ObjectHelper<product_category,2>::Construct )
,		SchemaEntry("product_class",&STEP::ObjectHelper<product_class,0>::Construct )
,		SchemaEntry("product_concept",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("product_concept_context",&STEP::ObjectHelper<product_concept_context,1>::Construct )
,		SchemaEntry("product_concept_feature_association",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("product_concept_feature_category_usage",&STEP::ObjectHelper<product_concept_feature_category_usage,1>::Construct )
,		SchemaEntry("product_concept_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("product_definition_context_association",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("product_definition_context_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("product_definition_element_relationship",&STEP::ObjectHelper<product_definition_element_relationship,0>::Construct )
,		SchemaEntry("product_definition_formation",&STEP::ObjectHelper<product_definition_formation,3>::Construct )
,		SchemaEntry("product_definition_formation_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("product_definition_formation_with_specified_source",&STEP::ObjectHelper<product_definition_formation_with_specified_source,1>::Construct )
,		SchemaEntry("product_definition_group_assignment",&STEP::ObjectHelper<product_definition_group_assignment,1>::Construct )
,		SchemaEntry("product_definition_occurrence_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("product_definition_shape",&STEP::ObjectHelper<product_definition_shape,0>::Construct )
,		SchemaEntry("product_definition_substitute",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("product_definition_with_associated_documents",&STEP::ObjectHelper<product_definition_with_associated_documents,1>::Construct )
,		SchemaEntry("product_identification",&STEP::ObjectHelper<product_identification,0>::Construct )
,		SchemaEntry("product_material_composition_relationship",&STEP::ObjectHelper<product_material_composition_relationship,4>::Construct )
,		SchemaEntry("product_related_product_category",&STEP::ObjectHelper<product_related_product_category,1>::Construct )
,		SchemaEntry("product_specification",&STEP::ObjectHelper<product_specification,0>::Construct )
,		SchemaEntry("tolerance_zone_definition",&STEP::ObjectHelper<tolerance_zone_definition,2>::Construct )
,		SchemaEntry("projected_zone_definition",&STEP::ObjectHelper<projected_zone_definition,2>::Construct )
,		SchemaEntry("projection_curve",&STEP::ObjectHelper<projection_curve,0>::Construct )
,		SchemaEntry("promissory_usage_occurrence",&STEP::ObjectHelper<promissory_usage_occurrence,0>::Construct )
,		SchemaEntry("property_definition_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("qualified_representation_item",&STEP::ObjectHelper<qualified_representation_item,1>::Construct )
,		SchemaEntry("qualitative_uncertainty",&STEP::ObjectHelper<qualitative_uncertainty,1>::Construct )
,		SchemaEntry("quantified_assembly_component_usage",&STEP::ObjectHelper<quantified_assembly_component_usage,1>::Construct )
,		SchemaEntry("quasi_uniform_curve",&STEP::ObjectHelper<quasi_uniform_curve,0>::Construct )
,		SchemaEntry("quasi_uniform_surface",&STEP::ObjectHelper<quasi_uniform_surface,0>::Construct )
,		SchemaEntry("radioactivity_measure_with_unit",&STEP::ObjectHelper<radioactivity_measure_with_unit,0>::Construct )
,		SchemaEntry("radioactivity_unit",&STEP::ObjectHelper<radioactivity_unit,0>::Construct )
,		SchemaEntry("radius_dimension",&STEP::ObjectHelper<radius_dimension,0>::Construct )
,		SchemaEntry("range_characteristic",&STEP::ObjectHelper<range_characteristic,0>::Construct )
,		SchemaEntry("ratio_unit",&STEP::ObjectHelper<ratio_unit,0>::Construct )
,		SchemaEntry("rational_b_spline_curve",&STEP::ObjectHelper<rational_b_spline_curve,1>::Construct )
,		SchemaEntry("rational_b_spline_surface",&STEP::ObjectHelper<rational_b_spline_surface,0>::Construct )
,		SchemaEntry("rational_representation_item",&STEP::ObjectHelper<rational_representation_item,0>::Construct )
,		SchemaEntry("real_literal",&STEP::ObjectHelper<real_literal,0>::Construct )
,		SchemaEntry("real_representation_item",&STEP::ObjectHelper<real_representation_item,0>::Construct )
,		SchemaEntry("rectangular_composite_surface",&STEP::ObjectHelper<rectangular_composite_surface,0>::Construct )
,		SchemaEntry("rectangular_trimmed_surface",&STEP::ObjectHelper<rectangular_trimmed_surface,7>::Construct )
,		SchemaEntry("referenced_modified_datum",&STEP::ObjectHelper<referenced_modified_datum,1>::Construct )
,		SchemaEntry("relative_event_occurrence",&STEP::ObjectHelper<relative_event_occurrence,2>::Construct )
,		SchemaEntry("rep_item_group",&STEP::ObjectHelper<rep_item_group,0>::Construct )
,		SchemaEntry("reparametrised_composite_curve_segment",&STEP::ObjectHelper<reparametrised_composite_curve_segment,1>::Construct )
,		SchemaEntry("representation_relationship_with_transformation",&STEP::ObjectHelper<representation_relationship_with_transformation,1>::Construct )
,		SchemaEntry("requirement_assigned_object",&STEP::ObjectHelper<requirement_assigned_object,1>::Construct )
,		SchemaEntry("requirement_assignment",&STEP::ObjectHelper<requirement_assignment,0>::Construct )
,		SchemaEntry("requirement_source",&STEP::ObjectHelper<requirement_source,0>::Construct )
,		SchemaEntry("requirement_view_definition_relationship",&STEP::ObjectHelper<requirement_view_definition_relationship,0>::Construct )
,		SchemaEntry("resistance_measure_with_unit",&STEP::ObjectHelper<resistance_measure_with_unit,0>::Construct )
,		SchemaEntry("resistance_unit",&STEP::ObjectHelper<resistance_unit,0>::Construct )
,		SchemaEntry("revolved_area_solid",&STEP::ObjectHelper<revolved_area_solid,2>::Construct )
,		SchemaEntry("revolved_face_solid",&STEP::ObjectHelper<revolved_face_solid,2>::Construct )
,		SchemaEntry("revolved_face_solid_with_trim_conditions",&STEP::ObjectHelper<revolved_face_solid_with_trim_conditions,2>::Construct )
,		SchemaEntry("right_angular_wedge",&STEP::ObjectHelper<right_angular_wedge,5>::Construct )
,		SchemaEntry("right_circular_cone",&STEP::ObjectHelper<right_circular_cone,4>::Construct )
,		SchemaEntry("right_circular_cylinder",&STEP::ObjectHelper<right_circular_cylinder,3>::Construct )
,		SchemaEntry("right_to_usage_association",&STEP::ObjectHelper<right_to_usage_association,0>::Construct )
,		SchemaEntry("role_association",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("roundness_tolerance",&STEP::ObjectHelper<roundness_tolerance,0>::Construct )
,		SchemaEntry("row_representation_item",&STEP::ObjectHelper<row_representation_item,0>::Construct )
,		SchemaEntry("row_value",&STEP::ObjectHelper<row_value,0>::Construct )
,		SchemaEntry("row_variable",&STEP::ObjectHelper<row_variable,0>::Construct )
,		SchemaEntry("rule_action",&STEP::ObjectHelper<rule_action,0>::Construct )
,		SchemaEntry("rule_condition",&STEP::ObjectHelper<rule_condition,0>::Construct )
,		SchemaEntry("rule_set",&STEP::ObjectHelper<rule_set,0>::Construct )
,		SchemaEntry("rule_set_group",&STEP::ObjectHelper<rule_set_group,0>::Construct )
,		SchemaEntry("rule_superseded_assignment",&STEP::ObjectHelper<rule_superseded_assignment,1>::Construct )
,		SchemaEntry("rule_supersedence",&STEP::ObjectHelper<rule_supersedence,0>::Construct )
,		SchemaEntry("surface_curve_swept_area_solid",&STEP::ObjectHelper<surface_curve_swept_area_solid,4>::Construct )
,		SchemaEntry("ruled_surface_swept_area_solid",&STEP::ObjectHelper<ruled_surface_swept_area_solid,0>::Construct )
,		SchemaEntry("runout_zone_definition",&STEP::ObjectHelper<runout_zone_definition,1>::Construct )
,		SchemaEntry("runout_zone_orientation",&STEP::ObjectHelper<runout_zone_orientation,1>::Construct )
,		SchemaEntry("runout_zone_orientation_reference_direction",&STEP::ObjectHelper<runout_zone_orientation_reference_direction,1>::Construct )
,		SchemaEntry("satisfied_requirement",&STEP::ObjectHelper<satisfied_requirement,1>::Construct )
,		SchemaEntry("satisfies_requirement",&STEP::ObjectHelper<satisfies_requirement,0>::Construct )
,		SchemaEntry("satisfying_item",&STEP::ObjectHelper<satisfying_item,1>::Construct )
,		SchemaEntry("scalar_variable",&STEP::ObjectHelper<scalar_variable,0>::Construct )
,		SchemaEntry("scattering_parameter",&STEP::ObjectHelper<scattering_parameter,0>::Construct )
,		SchemaEntry("sculptured_solid",&STEP::ObjectHelper<sculptured_solid,2>::Construct )
,		SchemaEntry("seam_curve",&STEP::ObjectHelper<seam_curve,0>::Construct )
,		SchemaEntry("security_classification",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("security_classification_level",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("serial_numbered_effectivity",&STEP::ObjectHelper<serial_numbered_effectivity,2>::Construct )
,		SchemaEntry("shape_aspect_associativity",&STEP::ObjectHelper<shape_aspect_associativity,0>::Construct )
,		SchemaEntry("shape_aspect_deriving_relationship",&STEP::ObjectHelper<shape_aspect_deriving_relationship,0>::Construct )
,		SchemaEntry("shape_definition_representation",&STEP::ObjectHelper<shape_definition_representation,0>::Construct )
,		SchemaEntry("shape_dimension_representation",&STEP::ObjectHelper<shape_dimension_representation,0>::Construct )
,		SchemaEntry("shape_feature_definition",&STEP::ObjectHelper<shape_feature_definition,0>::Construct )
,		SchemaEntry("shape_representation_with_parameters",&STEP::ObjectHelper<shape_representation_with_parameters,0>::Construct )
,		SchemaEntry("shell_based_surface_model",&STEP::ObjectHelper<shell_based_surface_model,1>::Construct )
,		SchemaEntry("shell_based_wireframe_model",&STEP::ObjectHelper<shell_based_wireframe_model,1>::Construct )
,		SchemaEntry("shell_based_wireframe_shape_representation",&STEP::ObjectHelper<shell_based_wireframe_shape_representation,0>::Construct )
,		SchemaEntry("si_absorbed_dose_unit",&STEP::ObjectHelper<si_absorbed_dose_unit,0>::Construct )
,		SchemaEntry("si_capacitance_unit",&STEP::ObjectHelper<si_capacitance_unit,0>::Construct )
,		SchemaEntry("si_conductance_unit",&STEP::ObjectHelper<si_conductance_unit,0>::Construct )
,		SchemaEntry("si_dose_equivalent_unit",&STEP::ObjectHelper<si_dose_equivalent_unit,0>::Construct )
,		SchemaEntry("si_electric_charge_unit",&STEP::ObjectHelper<si_electric_charge_unit,0>::Construct )
,		SchemaEntry("si_electric_potential_unit",&STEP::ObjectHelper<si_electric_potential_unit,0>::Construct )
,		SchemaEntry("si_energy_unit",&STEP::ObjectHelper<si_energy_unit,0>::Construct )
,		SchemaEntry("si_force_unit",&STEP::ObjectHelper<si_force_unit,0>::Construct )
,		SchemaEntry("si_frequency_unit",&STEP::ObjectHelper<si_frequency_unit,0>::Construct )
,		SchemaEntry("si_illuminance_unit",&STEP::ObjectHelper<si_illuminance_unit,0>::Construct )
,		SchemaEntry("si_inductance_unit",&STEP::ObjectHelper<si_inductance_unit,0>::Construct )
,		SchemaEntry("si_magnetic_flux_density_unit",&STEP::ObjectHelper<si_magnetic_flux_density_unit,0>::Construct )
,		SchemaEntry("si_magnetic_flux_unit",&STEP::ObjectHelper<si_magnetic_flux_unit,0>::Construct )
,		SchemaEntry("si_power_unit",&STEP::ObjectHelper<si_power_unit,0>::Construct )
,		SchemaEntry("si_pressure_unit",&STEP::ObjectHelper<si_pressure_unit,0>::Construct )
,		SchemaEntry("si_radioactivity_unit",&STEP::ObjectHelper<si_radioactivity_unit,0>::Construct )
,		SchemaEntry("si_resistance_unit",&STEP::ObjectHelper<si_resistance_unit,0>::Construct )
,		SchemaEntry("si_unit",&STEP::ObjectHelper<si_unit,2>::Construct )
,		SchemaEntry("simple_boolean_expression",&STEP::ObjectHelper<simple_boolean_expression,0>::Construct )
,		SchemaEntry("simple_numeric_expression",&STEP::ObjectHelper<simple_numeric_expression,0>::Construct )
,		SchemaEntry("slash_expression",&STEP::ObjectHelper<slash_expression,0>::Construct )
,		SchemaEntry("smeared_material_definition",&STEP::ObjectHelper<smeared_material_definition,0>::Construct )
,		SchemaEntry("solid_angle_measure_with_unit",&STEP::ObjectHelper<solid_angle_measure_with_unit,0>::Construct )
,		SchemaEntry("solid_angle_unit",&STEP::ObjectHelper<solid_angle_unit,0>::Construct )
,		SchemaEntry("solid_curve_font",&STEP::ObjectHelper<solid_curve_font,0>::Construct )
,		SchemaEntry("solid_replica",&STEP::ObjectHelper<solid_replica,2>::Construct )
,		SchemaEntry("solid_with_chamfered_edges",&STEP::ObjectHelper<solid_with_chamfered_edges,0>::Construct )
,		SchemaEntry("solid_with_angle_based_chamfer",&STEP::ObjectHelper<solid_with_angle_based_chamfer,3>::Construct )
,		SchemaEntry("solid_with_shape_element_pattern",&STEP::ObjectHelper<solid_with_shape_element_pattern,1>::Construct )
,		SchemaEntry("solid_with_circular_pattern",&STEP::ObjectHelper<solid_with_circular_pattern,4>::Construct )
,		SchemaEntry("solid_with_depression",&STEP::ObjectHelper<solid_with_depression,1>::Construct )
,		SchemaEntry("solid_with_pocket",&STEP::ObjectHelper<solid_with_pocket,2>::Construct )
,		SchemaEntry("solid_with_circular_pocket",&STEP::ObjectHelper<solid_with_circular_pocket,1>::Construct )
,		SchemaEntry("solid_with_protrusion",&STEP::ObjectHelper<solid_with_protrusion,2>::Construct )
,		SchemaEntry("solid_with_circular_protrusion",&STEP::ObjectHelper<solid_with_circular_protrusion,1>::Construct )
,		SchemaEntry("solid_with_hole",&STEP::ObjectHelper<solid_with_hole,0>::Construct )
,		SchemaEntry("solid_with_stepped_round_hole",&STEP::ObjectHelper<solid_with_stepped_round_hole,1>::Construct )
,		SchemaEntry("solid_with_conical_bottom_round_hole",&STEP::ObjectHelper<solid_with_conical_bottom_round_hole,2>::Construct )
,		SchemaEntry("solid_with_constant_radius_edge_blend",&STEP::ObjectHelper<solid_with_constant_radius_edge_blend,1>::Construct )
,		SchemaEntry("solid_with_slot",&STEP::ObjectHelper<solid_with_slot,2>::Construct )
,		SchemaEntry("solid_with_curved_slot",&STEP::ObjectHelper<solid_with_curved_slot,1>::Construct )
,		SchemaEntry("solid_with_double_offset_chamfer",&STEP::ObjectHelper<solid_with_double_offset_chamfer,2>::Construct )
,		SchemaEntry("solid_with_flat_bottom_round_hole",&STEP::ObjectHelper<solid_with_flat_bottom_round_hole,1>::Construct )
,		SchemaEntry("solid_with_general_pocket",&STEP::ObjectHelper<solid_with_general_pocket,2>::Construct )
,		SchemaEntry("solid_with_general_protrusion",&STEP::ObjectHelper<solid_with_general_protrusion,2>::Construct )
,		SchemaEntry("solid_with_groove",&STEP::ObjectHelper<solid_with_groove,5>::Construct )
,		SchemaEntry("solid_with_incomplete_circular_pattern",&STEP::ObjectHelper<solid_with_incomplete_circular_pattern,1>::Construct )
,		SchemaEntry("solid_with_rectangular_pattern",&STEP::ObjectHelper<solid_with_rectangular_pattern,4>::Construct )
,		SchemaEntry("solid_with_incomplete_rectangular_pattern",&STEP::ObjectHelper<solid_with_incomplete_rectangular_pattern,0>::Construct )
,		SchemaEntry("solid_with_rectangular_pocket",&STEP::ObjectHelper<solid_with_rectangular_pocket,3>::Construct )
,		SchemaEntry("solid_with_rectangular_protrusion",&STEP::ObjectHelper<solid_with_rectangular_protrusion,3>::Construct )
,		SchemaEntry("solid_with_single_offset_chamfer",&STEP::ObjectHelper<solid_with_single_offset_chamfer,1>::Construct )
,		SchemaEntry("solid_with_spherical_bottom_round_hole",&STEP::ObjectHelper<solid_with_spherical_bottom_round_hole,1>::Construct )
,		SchemaEntry("solid_with_stepped_round_hole_and_conical_transitions",&STEP::ObjectHelper<solid_with_stepped_round_hole_and_conical_transitions,1>::Construct )
,		SchemaEntry("solid_with_straight_slot",&STEP::ObjectHelper<solid_with_straight_slot,1>::Construct )
,		SchemaEntry("solid_with_tee_section_slot",&STEP::ObjectHelper<solid_with_tee_section_slot,2>::Construct )
,		SchemaEntry("solid_with_through_depression",&STEP::ObjectHelper<solid_with_through_depression,1>::Construct )
,		SchemaEntry("solid_with_trapezoidal_section_slot",&STEP::ObjectHelper<solid_with_trapezoidal_section_slot,2>::Construct )
,		SchemaEntry("solid_with_variable_radius_edge_blend",&STEP::ObjectHelper<solid_with_variable_radius_edge_blend,3>::Construct )
,		SchemaEntry("source_for_requirement",&STEP::ObjectHelper<source_for_requirement,1>::Construct )
,		SchemaEntry("sourced_requirement",&STEP::ObjectHelper<sourced_requirement,1>::Construct )
,		SchemaEntry("specification_definition",&STEP::ObjectHelper<specification_definition,0>::Construct )
,		SchemaEntry("specified_higher_usage_occurrence",&STEP::ObjectHelper<specified_higher_usage_occurrence,2>::Construct )
,		SchemaEntry("sphere",&STEP::ObjectHelper<sphere,2>::Construct )
,		SchemaEntry("spherical_surface",&STEP::ObjectHelper<spherical_surface,1>::Construct )
,		SchemaEntry("start_request",&STEP::ObjectHelper<start_request,1>::Construct )
,		SchemaEntry("start_work",&STEP::ObjectHelper<start_work,1>::Construct )
,		SchemaEntry("straightness_tolerance",&STEP::ObjectHelper<straightness_tolerance,0>::Construct )
,		SchemaEntry("structured_dimension_callout",&STEP::ObjectHelper<structured_dimension_callout,0>::Construct )
,		SchemaEntry("structured_text_composition",&STEP::ObjectHelper<structured_text_composition,0>::Construct )
,		SchemaEntry("structured_text_representation",&STEP::ObjectHelper<structured_text_representation,0>::Construct )
,		SchemaEntry("subedge",&STEP::ObjectHelper<subedge,1>::Construct )
,		SchemaEntry("subface",&STEP::ObjectHelper<subface,1>::Construct )
,		SchemaEntry("supplied_part_relationship",&STEP::ObjectHelper<supplied_part_relationship,0>::Construct )
,		SchemaEntry("surface_condition_callout",&STEP::ObjectHelper<surface_condition_callout,0>::Construct )
,		SchemaEntry("swept_surface",&STEP::ObjectHelper<swept_surface,1>::Construct )
,		SchemaEntry("surface_of_linear_extrusion",&STEP::ObjectHelper<surface_of_linear_extrusion,1>::Construct )
,		SchemaEntry("surface_of_revolution",&STEP::ObjectHelper<surface_of_revolution,1>::Construct )
,		SchemaEntry("surface_patch",&STEP::ObjectHelper<surface_patch,5>::Construct )
,		SchemaEntry("surface_profile_tolerance",&STEP::ObjectHelper<surface_profile_tolerance,0>::Construct )
,		SchemaEntry("surface_rendering_properties",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("surface_replica",&STEP::ObjectHelper<surface_replica,2>::Construct )
,		SchemaEntry("surface_side_style",&STEP::ObjectHelper<surface_side_style,2>::Construct )
,		SchemaEntry("surface_style_boundary",&STEP::ObjectHelper<surface_style_boundary,1>::Construct )
,		SchemaEntry("surface_style_control_grid",&STEP::ObjectHelper<surface_style_control_grid,1>::Construct )
,		SchemaEntry("surface_style_fill_area",&STEP::ObjectHelper<surface_style_fill_area,1>::Construct )
,		SchemaEntry("surface_style_parameter_line",&STEP::ObjectHelper<surface_style_parameter_line,2>::Construct )
,		SchemaEntry("surface_style_reflectance_ambient",&STEP::ObjectHelper<surface_style_reflectance_ambient,1>::Construct )
,		SchemaEntry("surface_style_reflectance_ambient_diffuse",&STEP::ObjectHelper<surface_style_reflectance_ambient_diffuse,1>::Construct )
,		SchemaEntry("surface_style_reflectance_ambient_diffuse_specular",&STEP::ObjectHelper<surface_style_reflectance_ambient_diffuse_specular,3>::Construct )
,		SchemaEntry("surface_style_rendering",&STEP::ObjectHelper<surface_style_rendering,2>::Construct )
,		SchemaEntry("surface_style_rendering_with_properties",&STEP::ObjectHelper<surface_style_rendering_with_properties,1>::Construct )
,		SchemaEntry("surface_style_segmentation_curve",&STEP::ObjectHelper<surface_style_segmentation_curve,1>::Construct )
,		SchemaEntry("surface_style_silhouette",&STEP::ObjectHelper<surface_style_silhouette,1>::Construct )
,		SchemaEntry("surface_style_transparent",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("surface_style_usage",&STEP::ObjectHelper<surface_style_usage,2>::Construct )
,		SchemaEntry("surface_texture_representation",&STEP::ObjectHelper<surface_texture_representation,0>::Construct )
,		SchemaEntry("surfaced_open_shell",&STEP::ObjectHelper<surfaced_open_shell,0>::Construct )
,		SchemaEntry("swept_disk_solid",&STEP::ObjectHelper<swept_disk_solid,5>::Construct )
,		SchemaEntry("symbol",&STEP::ObjectHelper<symbol,0>::Construct )
,		SchemaEntry("symbol_colour",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("symbol_representation_map",&STEP::ObjectHelper<symbol_representation_map,0>::Construct )
,		SchemaEntry("symbol_style",&STEP::ObjectHelper<symbol_style,2>::Construct )
,		SchemaEntry("symbol_target",&STEP::ObjectHelper<symbol_target,3>::Construct )
,		SchemaEntry("symmetric_shape_aspect",&STEP::ObjectHelper<symmetric_shape_aspect,0>::Construct )
,		SchemaEntry("symmetry_tolerance",&STEP::ObjectHelper<symmetry_tolerance,0>::Construct )
,		SchemaEntry("table_representation_item",&STEP::ObjectHelper<table_representation_item,0>::Construct )
,		SchemaEntry("tactile_appearance_representation",&STEP::ObjectHelper<tactile_appearance_representation,0>::Construct )
,		SchemaEntry("tagged_text_format",&STEP::ObjectHelper<tagged_text_format,0>::Construct )
,		SchemaEntry("tagged_text_item",&STEP::ObjectHelper<tagged_text_item,0>::Construct )
,		SchemaEntry("tangent",&STEP::ObjectHelper<tangent,0>::Construct )
,		SchemaEntry("text_font",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("text_font_family",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("text_font_in_family",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("text_literal_with_associated_curves",&STEP::ObjectHelper<text_literal_with_associated_curves,1>::Construct )
,		SchemaEntry("text_literal_with_blanking_box",&STEP::ObjectHelper<text_literal_with_blanking_box,1>::Construct )
,		SchemaEntry("text_literal_with_extent",&STEP::ObjectHelper<text_literal_with_extent,1>::Construct )
,		SchemaEntry("text_string_representation",&STEP::ObjectHelper<text_string_representation,0>::Construct )
,		SchemaEntry("text_style",&STEP::ObjectHelper<text_style,2>::Construct )
,		SchemaEntry("text_style_for_defined_font",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("text_style_with_box_characteristics",&STEP::ObjectHelper<text_style_with_box_characteristics,1>::Construct )
,		SchemaEntry("text_style_with_mirror",&STEP::ObjectHelper<text_style_with_mirror,1>::Construct )
,		SchemaEntry("text_style_with_spacing",&STEP::ObjectHelper<text_style_with_spacing,1>::Construct )
,		SchemaEntry("thermal_resistance_measure_with_unit",&STEP::ObjectHelper<thermal_resistance_measure_with_unit,0>::Construct )
,		SchemaEntry("thermal_resistance_unit",&STEP::ObjectHelper<thermal_resistance_unit,0>::Construct )
,		SchemaEntry("thermodynamic_temperature_measure_with_unit",&STEP::ObjectHelper<thermodynamic_temperature_measure_with_unit,0>::Construct )
,		SchemaEntry("thermodynamic_temperature_unit",&STEP::ObjectHelper<thermodynamic_temperature_unit,0>::Construct )
,		SchemaEntry("thickened_face_solid",&STEP::ObjectHelper<thickened_face_solid,3>::Construct )
,		SchemaEntry("thickness_laminate_definition",&STEP::ObjectHelper<thickness_laminate_definition,0>::Construct )
,		SchemaEntry("thickness_laminate_table",&STEP::ObjectHelper<thickness_laminate_table,0>::Construct )
,		SchemaEntry("time_interval",&STEP::ObjectHelper<time_interval,3>::Construct )
,		SchemaEntry("time_interval_based_effectivity",&STEP::ObjectHelper<time_interval_based_effectivity,1>::Construct )
,		SchemaEntry("time_interval_relationship",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("time_interval_role",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("time_interval_with_bounds",&STEP::ObjectHelper<time_interval_with_bounds,3>::Construct )
,		SchemaEntry("time_measure_with_unit",&STEP::ObjectHelper<time_measure_with_unit,0>::Construct )
,		SchemaEntry("time_unit",&STEP::ObjectHelper<time_unit,0>::Construct )
,		SchemaEntry("tolerance_value",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("tolerance_zone",&STEP::ObjectHelper<tolerance_zone,2>::Construct )
,		SchemaEntry("tolerance_zone_form",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("torus",&STEP::ObjectHelper<torus,3>::Construct )
,		SchemaEntry("total_runout_tolerance",&STEP::ObjectHelper<total_runout_tolerance,0>::Construct )
,		SchemaEntry("track_blended_solid",&STEP::ObjectHelper<track_blended_solid,0>::Construct )
,		SchemaEntry("track_blended_solid_with_end_conditions",&STEP::ObjectHelper<track_blended_solid_with_end_conditions,1>::Construct )
,		SchemaEntry("trimmed_curve",&STEP::ObjectHelper<trimmed_curve,5>::Construct )
,		SchemaEntry("two_direction_repeat_factor",&STEP::ObjectHelper<two_direction_repeat_factor,1>::Construct )
,		SchemaEntry("type_qualifier",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("unary_generic_expression",&STEP::ObjectHelper<unary_generic_expression,1>::Construct )
,		SchemaEntry("unary_numeric_expression",&STEP::ObjectHelper<unary_numeric_expression,0>::Construct )
,		SchemaEntry("uncertainty_assigned_representation",&STEP::ObjectHelper<uncertainty_assigned_representation,1>::Construct )
,		SchemaEntry("uncertainty_measure_with_unit",&STEP::ObjectHelper<uncertainty_measure_with_unit,2>::Construct )
,		SchemaEntry("uniform_curve",&STEP::ObjectHelper<uniform_curve,0>::Construct )
,		SchemaEntry("uniform_resource_identifier",&STEP::ObjectHelper<uniform_resource_identifier,0>::Construct )
,		SchemaEntry("uniform_surface",&STEP::ObjectHelper<uniform_surface,0>::Construct )
,		SchemaEntry("usage_association",&STEP::ObjectHelper<usage_association,0>::Construct )
,		SchemaEntry("user_defined_curve_font",&STEP::ObjectHelper<user_defined_curve_font,0>::Construct )
,		SchemaEntry("user_defined_marker",&STEP::ObjectHelper<user_defined_marker,0>::Construct )
,		SchemaEntry("user_defined_terminator_symbol",&STEP::ObjectHelper<user_defined_terminator_symbol,0>::Construct )
,		SchemaEntry("user_selected_shape_elements",&STEP::ObjectHelper<user_selected_shape_elements,0>::Construct )
,		SchemaEntry("value_range",&STEP::ObjectHelper<value_range,0>::Construct )
,		SchemaEntry("value_representation_item",&STEP::ObjectHelper<value_representation_item,1>::Construct )
,		SchemaEntry("variable_semantics",&STEP::ObjectHelper<variable_semantics,0>::Construct )
,		SchemaEntry("variational_representation_item",&STEP::ObjectHelper<variational_representation_item,0>::Construct )
,		SchemaEntry("vector",&STEP::ObjectHelper<vector,2>::Construct )
,		SchemaEntry("vector_style",&STEP::ObjectHelper<vector_style,0>::Construct )
,		SchemaEntry("velocity_measure_with_unit",&STEP::ObjectHelper<velocity_measure_with_unit,0>::Construct )
,		SchemaEntry("velocity_unit",&STEP::ObjectHelper<velocity_unit,0>::Construct )
,		SchemaEntry("versioned_action_request",&STEP::ObjectHelper<NotImplemented,0>::Construct )
,		SchemaEntry("vertex",&STEP::ObjectHelper<vertex,0>::Construct )
,		SchemaEntry("vertex_loop",&STEP::ObjectHelper<vertex_loop,1>::Construct )
,		SchemaEntry("vertex_point",&STEP::ObjectHelper<vertex_point,1>::Construct )
,		SchemaEntry("vertex_shell",&STEP::ObjectHelper<vertex_shell,1>::Construct )
,		SchemaEntry("view_volume",&STEP::ObjectHelper<view_volume,9>::Construct )
,		SchemaEntry("visual_appearance_representation",&STEP::ObjectHelper<visual_appearance_representation,0>::Construct )
,		SchemaEntry("volume_measure_with_unit",&STEP::ObjectHelper<volume_measure_with_unit,0>::Construct )
,		SchemaEntry("volume_unit",&STEP::ObjectHelper<volume_unit,0>::Construct )
,		SchemaEntry("week_of_year_and_day_date",&STEP::ObjectHelper<week_of_year_and_day_date,2>::Construct )
,		SchemaEntry("wire_shell",&STEP::ObjectHelper<wire_shell,1>::Construct )
,		SchemaEntry("year_month",&STEP::ObjectHelper<year_month,1>::Construct )

	};
}

// -----------------------------------------------------------------------------------------------------------
void StepFile::GetSchema(EXPRESS::ConversionSchema& out)
{
	out = EXPRESS::ConversionSchema(schema_raw);
}

namespace STEP {

    // -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<NotImplemented>(const STEP::DB& db, const LIST& params, NotImplemented* in)
{
	return 0;
}

// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<measure_with_unit>(const DB& db, const LIST& params, measure_with_unit* in)
{
	size_t base = 0;
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to measure_with_unit"); }    do { // convert the 'value_component' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::measure_with_unit,2>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->value_component, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to measure_with_unit to be a `measure_value`")); }
    } while(0);
    do { // convert the 'unit_component' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::measure_with_unit,2>::aux_is_derived[1]=true; break; }
        try { GenericConvert( in->unit_component, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to measure_with_unit to be a `unit`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<absorbed_dose_measure_with_unit>(const DB& db, const LIST& params, absorbed_dose_measure_with_unit* in)
{
	size_t base = GenericFill(db,params,static_cast<measure_with_unit*>(in));
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to absorbed_dose_measure_with_unit"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<derived_unit>(const DB& db, const LIST& params, derived_unit* in)
{
	size_t base = 0;
	if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to derived_unit"); }    do { // convert the 'elements' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::derived_unit,1>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->elements, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to derived_unit to be a `SET [1:?] OF derived_unit_element`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<absorbed_dose_unit>(const DB& db, const LIST& params, absorbed_dose_unit* in)
{
	size_t base = GenericFill(db,params,static_cast<derived_unit*>(in));
	if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to absorbed_dose_unit"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<abstract_variable>(const DB& db, const LIST& params, abstract_variable* in)
{
	size_t base = 0;
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<acceleration_measure_with_unit>(const DB& db, const LIST& params, acceleration_measure_with_unit* in)
{
	size_t base = GenericFill(db,params,static_cast<measure_with_unit*>(in));
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to acceleration_measure_with_unit"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<acceleration_unit>(const DB& db, const LIST& params, acceleration_unit* in)
{
	size_t base = GenericFill(db,params,static_cast<derived_unit*>(in));
	if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to acceleration_unit"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<action>(const DB& db, const LIST& params, action* in)
{
	size_t base = 0;
	if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to action"); }    do { // convert the 'name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action,3>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->name, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to action to be a `label`")); }
    } while(0);
    do { // convert the 'description' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action,3>::aux_is_derived[1]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->description, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to action to be a `text`")); }
    } while(0);
    do { // convert the 'chosen_method' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action,3>::aux_is_derived[2]=true; break; }
        try { GenericConvert( in->chosen_method, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to action to be a `action_method`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<action_assignment>(const DB& db, const LIST& params, action_assignment* in)
{
	size_t base = 0;
	if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to action_assignment"); }    do { // convert the 'assigned_action' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_assignment,1>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->assigned_action, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to action_assignment to be a `action`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<action_method>(const DB& db, const LIST& params, action_method* in)
{
	size_t base = 0;
	if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to action_method"); }    do { // convert the 'name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_method,4>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->name, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to action_method to be a `label`")); }
    } while(0);
    do { // convert the 'description' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_method,4>::aux_is_derived[1]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->description, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to action_method to be a `text`")); }
    } while(0);
    do { // convert the 'consequence' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_method,4>::aux_is_derived[2]=true; break; }
        try { GenericConvert( in->consequence, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to action_method to be a `text`")); }
    } while(0);
    do { // convert the 'purpose' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_method,4>::aux_is_derived[3]=true; break; }
        try { GenericConvert( in->purpose, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to action_method to be a `text`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<action_method_assignment>(const DB& db, const LIST& params, action_method_assignment* in)
{
	size_t base = 0;
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to action_method_assignment"); }    do { // convert the 'assigned_action_method' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_method_assignment,2>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->assigned_action_method, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to action_method_assignment to be a `action_method`")); }
    } while(0);
    do { // convert the 'role' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_method_assignment,2>::aux_is_derived[1]=true; break; }
        try { GenericConvert( in->role, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to action_method_assignment to be a `action_method_role`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<action_method_relationship>(const DB& db, const LIST& params, action_method_relationship* in)
{
	size_t base = 0;
	if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to action_method_relationship"); }    do { // convert the 'name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_method_relationship,4>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->name, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to action_method_relationship to be a `label`")); }
    } while(0);
    do { // convert the 'description' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_method_relationship,4>::aux_is_derived[1]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->description, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to action_method_relationship to be a `text`")); }
    } while(0);
    do { // convert the 'relating_method' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_method_relationship,4>::aux_is_derived[2]=true; break; }
        try { GenericConvert( in->relating_method, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to action_method_relationship to be a `action_method`")); }
    } while(0);
    do { // convert the 'related_method' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_method_relationship,4>::aux_is_derived[3]=true; break; }
        try { GenericConvert( in->related_method, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to action_method_relationship to be a `action_method`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<action_request_assignment>(const DB& db, const LIST& params, action_request_assignment* in)
{
	size_t base = 0;
	if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to action_request_assignment"); }    do { // convert the 'assigned_action_request' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::action_request_assignment,1>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->assigned_action_request, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to action_request_assignment to be a `versioned_action_request`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<address>(const DB& db, const LIST& params, address* in)
{
	size_t base = 0;
	if (params.GetSize() < 12) { throw STEP::TypeError("expected 12 arguments to address"); }    do { // convert the 'internal_location' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[0]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->internal_location, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to address to be a `label`")); }
    } while(0);
    do { // convert the 'street_number' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[1]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->street_number, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to address to be a `label`")); }
    } while(0);
    do { // convert the 'street' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[2]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->street, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to address to be a `label`")); }
    } while(0);
    do { // convert the 'postal_box' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[3]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->postal_box, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to address to be a `label`")); }
    } while(0);
    do { // convert the 'town' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[4]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->town, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to address to be a `label`")); }
    } while(0);
    do { // convert the 'region' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[5]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->region, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 5 to address to be a `label`")); }
    } while(0);
    do { // convert the 'postal_code' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[6]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->postal_code, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 6 to address to be a `label`")); }
    } while(0);
    do { // convert the 'country' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[7]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->country, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 7 to address to be a `label`")); }
    } while(0);
    do { // convert the 'facsimile_number' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[8]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->facsimile_number, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 8 to address to be a `label`")); }
    } while(0);
    do { // convert the 'telephone_number' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[9]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->telephone_number, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 9 to address to be a `label`")); }
    } while(0);
    do { // convert the 'electronic_mail_address' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[10]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->electronic_mail_address, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 10 to address to be a `label`")); }
    } while(0);
    do { // convert the 'telex_number' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::address,12>::aux_is_derived[11]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->telex_number, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 11 to address to be a `label`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<representation>(const DB& db, const LIST& params, representation* in)
{
	size_t base = 0;
	if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to representation"); }    do { // convert the 'name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::representation,3>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->name, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to representation to be a `label`")); }
    } while(0);
    do { // convert the 'items' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::representation,3>::aux_is_derived[1]=true; break; }
        try { GenericConvert( in->items, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to representation to be a `SET [1:?] OF representation_item`")); }
    } while(0);
    do { // convert the 'context_of_items' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::representation,3>::aux_is_derived[2]=true; break; }
        try { GenericConvert( in->context_of_items, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to representation to be a `representation_context`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<shape_representation>(const DB& db, const LIST& params, shape_representation* in)
{
	size_t base = GenericFill(db,params,static_cast<representation*>(in));
	if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to shape_representation"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<advanced_brep_shape_representation>(const DB& db, const LIST& params, advanced_brep_shape_representation* in)
{
	size_t base = GenericFill(db,params,static_cast<shape_representation*>(in));
	if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to advanced_brep_shape_representation"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<face_surface>(const DB& db, const LIST& params, face_surface* in)
{
	size_t base = 0;
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to face_surface"); }    do { // convert the 'face_geometry' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::face_surface,2>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->face_geometry, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to face_surface to be a `surface`")); }
    } while(0);
    do { // convert the 'same_sense' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::face_surface,2>::aux_is_derived[1]=true; break; }
        try { GenericConvert( in->same_sense, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to face_surface to be a `BOOLEAN`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<advanced_face>(const DB& db, const LIST& params, advanced_face* in)
{
	size_t base = GenericFill(db,params,static_cast<face_surface*>(in));
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to advanced_face"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<amount_of_substance_measure_with_unit>(const DB& db, const LIST& params, amount_of_substance_measure_with_unit* in)
{
	size_t base = GenericFill(db,params,static_cast<measure_with_unit*>(in));
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to amount_of_substance_measure_with_unit"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<named_unit>(const DB& db, const LIST& params, named_unit* in)
{
	size_t base = 0;
	if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to named_unit"); }    do { // convert the 'dimensions' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::named_unit,1>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->dimensions, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to named_unit to be a `dimensional_exponents`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<amount_of_substance_unit>(const DB& db, const LIST& params, amount_of_substance_unit* in)
{
	size_t base = GenericFill(db,params,static_cast<named_unit*>(in));
	if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to amount_of_substance_unit"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<angle_direction_reference>(const DB& db, const LIST& params, angle_direction_reference* in)
{
	size_t base = 0;
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<representation_item>(const DB& db, const LIST& params, representation_item* in)
{
	size_t base = 0;
	if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to representation_item"); }    do { // convert the 'name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::representation_item,1>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->name, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to representation_item to be a `label`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<geometric_representation_item>(const DB& db, const LIST& params, geometric_representation_item* in)
{
	size_t base = GenericFill(db,params,static_cast<representation_item*>(in));
	if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to geometric_representation_item"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<draughting_callout>(const DB& db, const LIST& params, draughting_callout* in)
{
	size_t base = GenericFill(db,params,static_cast<geometric_representation_item*>(in));
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to draughting_callout"); }    do { // convert the 'contents' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::draughting_callout,1>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->contents, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to draughting_callout to be a `SET [1:?] OF draughting_callout_element`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<dimension_curve_directed_callout>(const DB& db, const LIST& params, dimension_curve_directed_callout* in)
{
	size_t base = GenericFill(db,params,static_cast<draughting_callout*>(in));
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to dimension_curve_directed_callout"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<angular_dimension>(const DB& db, const LIST& params, angular_dimension* in)
{
	size_t base = GenericFill(db,params,static_cast<dimension_curve_directed_callout*>(in));
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to angular_dimension"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<shape_aspect_relationship>(const DB& db, const LIST& params, shape_aspect_relationship* in)
{
	size_t base = 0;
	if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to shape_aspect_relationship"); }    do { // convert the 'name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::shape_aspect_relationship,4>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->name, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to shape_aspect_relationship to be a `label`")); }
    } while(0);
    do { // convert the 'description' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::shape_aspect_relationship,4>::aux_is_derived[1]=true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->description, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to shape_aspect_relationship to be a `text`")); }
    } while(0);
    do { // convert the 'relating_shape_aspect' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::shape_aspect_relationship,4>::aux_is_derived[2]=true; break; }
        try { GenericConvert( in->relating_shape_aspect, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to shape_aspect_relationship to be a `shape_aspect`")); }
    } while(0);
    do { // convert the 'related_shape_aspect' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::shape_aspect_relationship,4>::aux_is_derived[3]=true; break; }
        try { GenericConvert( in->related_shape_aspect, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to shape_aspect_relationship to be a `shape_aspect`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<dimensional_location>(const DB& db, const LIST& params, dimensional_location* in)
{
	size_t base = GenericFill(db,params,static_cast<shape_aspect_relationship*>(in));
	if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to dimensional_location"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<angular_location>(const DB& db, const LIST& params, angular_location* in)
{
	size_t base = GenericFill(db,params,static_cast<dimensional_location*>(in));
	if (params.GetSize() < 5) { throw STEP::TypeError("expected 5 arguments to angular_location"); }    do { // convert the 'angle_selection' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->angle_selection, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to angular_location to be a `angle_relator`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<dimensional_size>(const DB& db, const LIST& params, dimensional_size* in)
{
	size_t base = 0;
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to dimensional_size"); }    do { // convert the 'applies_to' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::dimensional_size,2>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->applies_to, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to dimensional_size to be a `shape_aspect`")); }
    } while(0);
    do { // convert the 'name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::dimensional_size,2>::aux_is_derived[1]=true; break; }
        try { GenericConvert( in->name, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to dimensional_size to be a `label`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<angular_size>(const DB& db, const LIST& params, angular_size* in)
{
	size_t base = GenericFill(db,params,static_cast<dimensional_size*>(in));
	if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to angular_size"); }    do { // convert the 'angle_selection' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->angle_selection, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to angular_size to be a `angle_relator`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<geometric_tolerance>(const DB& db, const LIST& params, geometric_tolerance* in)
{
	size_t base = 0;
	if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to geometric_tolerance"); }    do { // convert the 'name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::geometric_tolerance,4>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->name, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to geometric_tolerance to be a `label`")); }
    } while(0);
    do { // convert the 'description' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::geometric_tolerance,4>::aux_is_derived[1]=true; break; }
        try { GenericConvert( in->description, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to geometric_tolerance to be a `text`")); }
    } while(0);
    do { // convert the 'magnitude' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::geometric_tolerance,4>::aux_is_derived[2]=true; break; }
        try { GenericConvert( in->magnitude, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to geometric_tolerance to be a `measure_with_unit`")); }
    } while(0);
    do { // convert the 'toleranced_shape_aspect' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::geometric_tolerance,4>::aux_is_derived[3]=true; break; }
        try { GenericConvert( in->toleranced_shape_aspect, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to geometric_tolerance to be a `shape_aspect`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<geometric_tolerance_with_datum_reference>(const DB& db, const LIST& params, geometric_tolerance_with_datum_reference* in)
{
	size_t base = GenericFill(db,params,static_cast<geometric_tolerance*>(in));
	if (params.GetSize() < 5) { throw STEP::TypeError("expected 5 arguments to geometric_tolerance_with_datum_reference"); }    do { // convert the 'datum_system' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::geometric_tolerance_with_datum_reference,1>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->datum_system, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 4 to geometric_tolerance_with_datum_reference to be a `SET [1:?] OF datum_reference`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<angularity_tolerance>(const DB& db, const LIST& params, angularity_tolerance* in)
{
	size_t base = GenericFill(db,params,static_cast<geometric_tolerance_with_datum_reference*>(in));
	if (params.GetSize() < 5) { throw STEP::TypeError("expected 5 arguments to angularity_tolerance"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<styled_item>(const DB& db, const LIST& params, styled_item* in)
{
	size_t base = GenericFill(db,params,static_cast<representation_item*>(in));
	if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to styled_item"); }    do { // convert the 'styles' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::styled_item,2>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->styles, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to styled_item to be a `SET [1:?] OF presentation_style_assignment`")); }
    } while(0);
    do { // convert the 'item' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::styled_item,2>::aux_is_derived[1]=true; break; }
        try { GenericConvert( in->item, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to styled_item to be a `representation_item`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_occurrence>(const DB& db, const LIST& params, annotation_occurrence* in)
{
	size_t base = GenericFill(db,params,static_cast<styled_item*>(in));
	if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to annotation_occurrence"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_curve_occurrence>(const DB& db, const LIST& params, annotation_curve_occurrence* in)
{
	size_t base = GenericFill(db,params,static_cast<annotation_occurrence*>(in));
	if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to annotation_curve_occurrence"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_fill_area>(const DB& db, const LIST& params, annotation_fill_area* in)
{
	size_t base = GenericFill(db,params,static_cast<geometric_representation_item*>(in));
	if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to annotation_fill_area"); }    do { // convert the 'boundaries' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->boundaries, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to annotation_fill_area to be a `SET [1:?] OF curve`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_fill_area_occurrence>(const DB& db, const LIST& params, annotation_fill_area_occurrence* in)
{
	size_t base = GenericFill(db,params,static_cast<annotation_occurrence*>(in));
	if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to annotation_fill_area_occurrence"); }    do { // convert the 'fill_style_target' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert( in->fill_style_target, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to annotation_fill_area_occurrence to be a `point`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_occurrence_relationship>(const DB& db, const LIST& params, annotation_occurrence_relationship* in)
{
	size_t base = 0;
	if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to annotation_occurrence_relationship"); }    do { // convert the 'name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::annotation_occurrence_relationship,4>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->name, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to annotation_occurrence_relationship to be a `label`")); }
    } while(0);
    do { // convert the 'description' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::annotation_occurrence_relationship,4>::aux_is_derived[1]=true; break; }
        try { GenericConvert( in->description, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to annotation_occurrence_relationship to be a `text`")); }
    } while(0);
    do { // convert the 'relating_annotation_occurrence' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::annotation_occurrence_relationship,4>::aux_is_derived[2]=true; break; }
        try { GenericConvert( in->relating_annotation_occurrence, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to annotation_occurrence_relationship to be a `annotation_occurrence`")); }
    } while(0);
    do { // convert the 'related_annotation_occurrence' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::annotation_occurrence_relationship,4>::aux_is_derived[3]=true; break; }
        try { GenericConvert( in->related_annotation_occurrence, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to annotation_occurrence_relationship to be a `annotation_occurrence`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_occurrence_associativity>(const DB& db, const LIST& params, annotation_occurrence_associativity* in)
{
	size_t base = GenericFill(db,params,static_cast<annotation_occurrence_relationship*>(in));
	if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to annotation_occurrence_associativity"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_plane>(const DB& db, const LIST& params, annotation_plane* in)
{
	size_t base = 0;
	if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to annotation_plane"); }    do { // convert the 'elements' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert( in->elements, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to annotation_plane to be a `SET [1:?] OF annotation_plane_element`")); }
    } while(0);
	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_symbol_occurrence>(const DB& db, const LIST& params, annotation_symbol_occurrence* in)
{
	size_t base = GenericFill(db,params,static_cast<annotation_occurrence*>(in));
	if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to annotation_symbol_occurrence"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_subfigure_occurrence>(const DB& db, const LIST& params, annotation_subfigure_occurrence* in)
{
	size_t base = GenericFill(db,params,static_cast<annotation_symbol_occurrence*>(in));
	if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to annotation_subfigure_occurrence"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<mapped_item>(const DB& db, const LIST& params, mapped_item* in)
{
	size_t base = GenericFill(db,params,static_cast<representation_item*>(in));
	if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to mapped_item"); }    do { // convert the 'mapping_source' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::mapped_item,2>::aux_is_derived[0]=true; break; }
        try { GenericConvert( in->mapping_source, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to mapped_item to be a `representation_map`")); }
    } while(0);
    do { // convert the 'mapping_target' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::mapped_item,2>::aux_is_derived[1]=true; break; }
        try { GenericConvert( in->mapping_target, arg, db ); break; } 
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to mapped_item to be a `representation_item`")); }
    } while(0);
	return base;
}

// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_symbol>(const DB& db, const LIST& params, annotation_symbol* in)
{
    size_t base = GenericFill(db, params, static_cast<mapped_item*>(in));
    if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to annotation_symbol"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_text>(const DB& db, const LIST& params, annotation_text* in)
{
    size_t base = GenericFill(db, params, static_cast<mapped_item*>(in));
    if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to annotation_text"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_text_character>(const DB& db, const LIST& params, annotation_text_character* in)
{
    size_t base = GenericFill(db, params, static_cast<mapped_item*>(in));
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to annotation_text_character"); }    do { // convert the 'alignment' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert(in->alignment, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to annotation_text_character to be a `text_alignment`")); }
    } while (0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<annotation_text_occurrence>(const DB& db, const LIST& params, annotation_text_occurrence* in)
{
    size_t base = GenericFill(db, params, static_cast<annotation_occurrence*>(in));
    if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to annotation_text_occurrence"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<shape_aspect>(const DB& db, const LIST& params, shape_aspect* in)
{
    size_t base = 0;
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to shape_aspect"); }    do { // convert the 'name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::shape_aspect, 4>::aux_is_derived[0] = true; break; }
        try { GenericConvert(in->name, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to shape_aspect to be a `label`")); }
    } while (0);
    do { // convert the 'description' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::shape_aspect, 4>::aux_is_derived[1] = true; break; }
        if (dynamic_cast<const UNSET*>(&*arg)) break;
        try { GenericConvert(in->description, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to shape_aspect to be a `text`")); }
    } while (0);
    do { // convert the 'of_shape' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::shape_aspect, 4>::aux_is_derived[2] = true; break; }
        try { GenericConvert(in->of_shape, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to shape_aspect to be a `product_definition_shape`")); }
    } while (0);
    do { // convert the 'product_definitional' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::shape_aspect, 4>::aux_is_derived[3] = true; break; }
        try { GenericConvert(in->product_definitional, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to shape_aspect to be a `LOGICAL`")); }
    } while (0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<derived_shape_aspect>(const DB& db, const LIST& params, derived_shape_aspect* in)
{
    size_t base = GenericFill(db, params, static_cast<shape_aspect*>(in));
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to derived_shape_aspect"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<apex>(const DB& db, const LIST& params, apex* in)
{
    size_t base = GenericFill(db, params, static_cast<derived_shape_aspect*>(in));
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to apex"); }	return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<application_context_element>(const DB& db, const LIST& params, application_context_element* in)
{
    size_t base = 0;
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to application_context_element"); }    do { // convert the 'name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::application_context_element, 2>::aux_is_derived[0] = true; break; }
        try { GenericConvert(in->name, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to application_context_element to be a `label`")); }
    } while (0);
    do { // convert the 'frame_of_reference' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::application_context_element, 2>::aux_is_derived[1] = true; break; }
        try { GenericConvert(in->frame_of_reference, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to application_context_element to be a `application_context`")); }
    } while (0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<applied_action_assignment>(const DB& db, const LIST& params, applied_action_assignment* in)
{
    size_t base = GenericFill(db, params, static_cast<action_assignment*>(in));
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to applied_action_assignment"); }    do { // convert the 'items' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::applied_action_assignment, 1>::aux_is_derived[0] = true; break; }
        try { GenericConvert(in->items, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to applied_action_assignment to be a `SET [1:?] OF action_items`")); }
    } while (0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<applied_action_method_assignment>(const DB& db, const LIST& params, applied_action_method_assignment* in)
{
    size_t base = GenericFill(db, params, static_cast<action_method_assignment*>(in));
    if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to applied_action_method_assignment"); }    do { // convert the 'items' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert(in->items, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to applied_action_method_assignment to be a `SET [1:?] OF action_method_items`")); }
    } while (0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<applied_action_request_assignment>(const DB& db, const LIST& params, applied_action_request_assignment* in)
{
    size_t base = GenericFill(db, params, static_cast<action_request_assignment*>(in));
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to applied_action_request_assignment"); }    do { // convert the 'items' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert(in->items, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to applied_action_request_assignment to be a `SET [1:?] OF action_request_item`")); }
    } while (0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<approval_assignment>(const DB& db, const LIST& params, approval_assignment* in)
{
    size_t base = 0;
    if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to approval_assignment"); }    do { // convert the 'assigned_approval' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::approval_assignment, 1>::aux_is_derived[0] = true; break; }
        try { GenericConvert(in->assigned_approval, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to approval_assignment to be a `approval`")); }
    } while (0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<applied_approval_assignment>(const DB& db, const LIST& params, applied_approval_assignment* in)
{
    size_t base = GenericFill(db, params, static_cast<approval_assignment*>(in));
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to applied_approval_assignment"); }    do { // convert the 'items' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert(in->items, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to applied_approval_assignment to be a `SET [1:?] OF approval_item`")); }
    } while (0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<attribute_classification_assignment>(const DB& db, const LIST& params, attribute_classification_assignment* in)
{
    size_t base = 0;
    if (params.GetSize() < 3) { throw STEP::TypeError("expected 3 arguments to attribute_classification_assignment"); }    do { // convert the 'assigned_class' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::attribute_classification_assignment, 3>::aux_is_derived[0] = true; break; }
        try { GenericConvert(in->assigned_class, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to attribute_classification_assignment to be a `group`")); }
    } while (0);
    do { // convert the 'attribute_name' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::attribute_classification_assignment, 3>::aux_is_derived[1] = true; break; }
        try { GenericConvert(in->attribute_name, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to attribute_classification_assignment to be a `label`")); }
    } while (0);
    do { // convert the 'role' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::attribute_classification_assignment, 3>::aux_is_derived[2] = true; break; }
        try { GenericConvert(in->role, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 2 to attribute_classification_assignment to be a `classification_role`")); }
    } while (0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<applied_attribute_classification_assignment>(const DB& db, const LIST& params, applied_attribute_classification_assignment* in)
{
    size_t base = GenericFill(db, params, static_cast<attribute_classification_assignment*>(in));
    if (params.GetSize() < 4) { throw STEP::TypeError("expected 4 arguments to applied_attribute_classification_assignment"); }    do { // convert the 'items' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert(in->items, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 3 to applied_attribute_classification_assignment to be a `SET [1:?] OF attribute_classification_item`")); }
    } while (0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<certification_assignment>(const DB& db, const LIST& params, certification_assignment* in)
{
    size_t base = 0;
    if (params.GetSize() < 1) { throw STEP::TypeError("expected 1 arguments to certification_assignment"); }    do { // convert the 'assigned_certification' argument
        std::shared_ptr<const DataType> arg = params[base++];
        if (dynamic_cast<const ISDERIVED*>(&*arg)) { in->ObjectHelper<Assimp::StepFile::certification_assignment, 1>::aux_is_derived[0] = true; break; }
        try { GenericConvert(in->assigned_certification, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 0 to certification_assignment to be a `certification`")); }
    } while (0);
    return base;
}
// -----------------------------------------------------------------------------------------------------------
template <> size_t GenericFill<applied_certification_assignment>(const DB& db, const LIST& params, applied_certification_assignment* in)
{
    size_t base = GenericFill(db, params, static_cast<certification_assignment*>(in));
    if (params.GetSize() < 2) { throw STEP::TypeError("expected 2 arguments to applied_certification_assignment"); }    do { // convert the 'items' argument
        std::shared_ptr<const DataType> arg = params[base++];
        try { GenericConvert(in->items, arg, db); break; }
        catch (const TypeError& t) { throw TypeError(t.what() + std::string(" - expected argument 1 to applied_certification_assignment to be a `SET [1:?] OF certification_item`")); }
    } while (0);
    return base;
}

} // ! STEP
} // ! Assimp

#endif
