# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .preset_py3 import Preset


class StandardEncoderPreset(Preset):
    """Describes all the settings to be used when encoding the input video with
    the Standard Encoder.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param filters: One or more filtering operations that are applied to the
     input media before encoding.
    :type filters: ~azure.mgmt.media.models.Filters
    :param codecs: The list of codecs to be used when encoding the input
     video.
    :type codecs: list[~azure.mgmt.media.models.Codec]
    :param formats: The list of outputs to be produced by the encoder.
    :type formats: list[~azure.mgmt.media.models.Format]
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'filters': {'key': 'filters', 'type': 'Filters'},
        'codecs': {'key': 'codecs', 'type': '[Codec]'},
        'formats': {'key': 'formats', 'type': '[Format]'},
    }

    def __init__(self, *, filters=None, codecs=None, formats=None, **kwargs) -> None:
        super(StandardEncoderPreset, self).__init__(**kwargs)
        self.filters = filters
        self.codecs = codecs
        self.formats = formats
        self.odatatype = '#Microsoft.Media.StandardEncoderPreset'
