/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.io.IOException;
import org.gjt.jclasslib.bytecode.Opcodes;
import org.gjt.jclasslib.bytecode.OpcodesUtil;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;

public abstract class AbstractInstruction
implements Opcodes {
    private int offset;
    private int opcode;

    protected AbstractInstruction(int n) {
        this.opcode = n;
    }

    public int getSize() {
        return 1;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int n) {
        this.opcode = n;
    }

    public String getOpcodeVerbose() {
        String string = OpcodesUtil.getVerbose(this.opcode);
        if (string == null) {
            return "invalid opcode";
        }
        return string;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public void read(ByteCodeInput byteCodeInput) throws IOException {
        this.offset = byteCodeInput.getBytesRead() - 1;
    }

    public void write(ByteCodeOutput byteCodeOutput) throws IOException {
        byteCodeOutput.writeByte(this.opcode);
    }
}

