{-# OPTIONS_GHC -w #-}
{-# OPTIONS -XMagicHash -XBangPatterns -XTypeSynonymInstances -XFlexibleInstances -cpp #-}
#if __GLASGOW_HASKELL__ >= 710
{-# OPTIONS_GHC -XPartialTypeSignatures #-}
#endif
{-# LANGUAGE CPP #-}
{-# OPTIONS_HADDOCK hide #-}
-----------------------------------------------------------------------------
-- |
-- Module      :  Language.Haskell.Exts.Annotated.Parser
-- Copyright   :  (c) Niklas Broberg 2004-2009,
--                Original (c) Simon Marlow, Sven Panne 1997-2000
-- License     :  BSD-style (see the file LICENSE.txt)
--
-- Maintainer  :  Niklas Broberg, d00nibro@chalmers.se
-- Stability   :  stable
-- Portability :  portable
--
--
-----------------------------------------------------------------------------
module Language.Haskell.Exts.InternalParser (
              mparseModule,
              mparseExp,
              mparsePat,
              mparseDecl,
              mparseType,
              mparseStmt,
              mparseImportDecl,
              ngparseModulePragmas,
              ngparseModuleHeadAndImports,
              ngparsePragmasAndModuleHead,
              ngparsePragmasAndModuleName
              ) where
import Language.Haskell.Exts.Syntax hiding ( Type(..), Exp(..), Asst(..), XAttr(..), FieldUpdate(..) )
import Language.Haskell.Exts.Syntax ( Type, Exp, Asst )
import Language.Haskell.Exts.ParseMonad
import Language.Haskell.Exts.InternalLexer
import Language.Haskell.Exts.ParseUtils
import Language.Haskell.Exts.Fixity
import Language.Haskell.Exts.SrcLoc
import Language.Haskell.Exts.Extension

import Control.Monad ( liftM, (<=<), when )
import Control.Applicative ( (<$>) )
import Data.Maybe
#if MIN_VERSION_base(4,11,0)
import Prelude hiding ((<>))
#endif
import qualified Data.Array as Happy_Data_Array
import qualified Data.Bits as Bits
import qualified GHC.Exts as Happy_GHC_Exts
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.9

newtype HappyAbsSyn  = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
happyIn14 :: ([Module L]) -> (HappyAbsSyn )
happyIn14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn14 #-}
happyOut14 :: (HappyAbsSyn ) -> ([Module L])
happyOut14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut14 #-}
happyIn15 :: ([[ModulePragma L] -> [S] -> L -> Module L]) -> (HappyAbsSyn )
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn ) -> ([[ModulePragma L] -> [S] -> L -> Module L])
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: (Module L) -> (HappyAbsSyn )
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn ) -> (Module L)
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: (PExp L) -> (HappyAbsSyn )
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn ) -> (PExp L)
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (([ModulePragma L],[S],L)) -> (HappyAbsSyn )
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn ) -> (([ModulePragma L],[S],L))
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: (([ModulePragma L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn ) -> (([ModulePragma L],[S],Maybe L))
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: (ModulePragma L) -> (HappyAbsSyn )
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn ) -> (ModulePragma L)
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: (([Name L],[S])) -> (HappyAbsSyn )
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn ) -> (([Name L],[S]))
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: ([ModulePragma L] -> [S] -> L -> Module L) -> (HappyAbsSyn )
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn ) -> ([ModulePragma L] -> [S] -> L -> Module L)
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: (Maybe (ModuleHead L)) -> (HappyAbsSyn )
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn ) -> (Maybe (ModuleHead L))
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: (Maybe (WarningText L)) -> (HappyAbsSyn )
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn ) -> (Maybe (WarningText L))
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: (([ImportDecl L],[Decl L],[S],L)) -> (HappyAbsSyn )
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn ) -> (([ImportDecl L],[Decl L],[S],L))
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: (([ImportDecl L],[Decl L],[S])) -> (HappyAbsSyn )
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn ) -> (([ImportDecl L],[Decl L],[S]))
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: ([S]) -> (HappyAbsSyn )
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn ) -> ([S])
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: ([S]) -> (HappyAbsSyn )
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn ) -> ([S])
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: (Maybe (ExportSpecList L)) -> (HappyAbsSyn )
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn ) -> (Maybe (ExportSpecList L))
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: (ExportSpecList L) -> (HappyAbsSyn )
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn ) -> (ExportSpecList L)
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: ([S]) -> (HappyAbsSyn )
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn ) -> ([S])
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: (([ExportSpec L],[S])) -> (HappyAbsSyn )
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn ) -> (([ExportSpec L],[S]))
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: (ExportSpec L) -> (HappyAbsSyn )
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn ) -> (ExportSpec L)
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: (([Either S (CName L)],[S])) -> (HappyAbsSyn )
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn ) -> (([Either S (CName L)],[S]))
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: (Either S (CName L)) -> (HappyAbsSyn )
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn ) -> (Either S (CName L))
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: (QName L) -> (HappyAbsSyn )
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn ) -> (QName L)
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: (([ImportDecl L],[S])) -> (HappyAbsSyn )
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn ) -> (([ImportDecl L],[S]))
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: (ImportDecl L) -> (HappyAbsSyn )
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn ) -> (ImportDecl L)
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: ((Bool,[S])) -> (HappyAbsSyn )
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn ) -> ((Bool,[S]))
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: ((Bool,[S])) -> (HappyAbsSyn )
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn ) -> ((Bool,[S]))
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: ((Bool,[S])) -> (HappyAbsSyn )
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn ) -> ((Bool,[S]))
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: ((Maybe String,[S])) -> (HappyAbsSyn )
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn ) -> ((Maybe String,[S]))
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: ((Maybe (ModuleName L),[S],Maybe L)) -> (HappyAbsSyn )
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn ) -> ((Maybe (ModuleName L),[S],Maybe L))
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: (Maybe (ImportSpecList L)) -> (HappyAbsSyn )
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn ) -> (Maybe (ImportSpecList L))
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: (ImportSpecList L) -> (HappyAbsSyn )
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn ) -> (ImportSpecList L)
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: ((Bool, Maybe L,[S])) -> (HappyAbsSyn )
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn ) -> ((Bool, Maybe L,[S]))
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: (([ImportSpec L],[S])) -> (HappyAbsSyn )
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn ) -> (([ImportSpec L],[S]))
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: (ImportSpec L) -> (HappyAbsSyn )
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn ) -> (ImportSpec L)
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: (([CName L],[S])) -> (HappyAbsSyn )
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn ) -> (([CName L],[S]))
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: (CName L) -> (HappyAbsSyn )
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn ) -> (CName L)
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: (Decl L) -> (HappyAbsSyn )
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn ) -> (Decl L)
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: ((Maybe Int, [S])) -> (HappyAbsSyn )
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn ) -> ((Maybe Int, [S]))
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: (Assoc L) -> (HappyAbsSyn )
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn ) -> (Assoc L)
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: (([Op L],[S],L)) -> (HappyAbsSyn )
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn ) -> (([Op L],[S],L))
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: (Maybe (InjectivityInfo L)) -> (HappyAbsSyn )
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn ) -> (Maybe (InjectivityInfo L))
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: (InjectivityInfo L) -> (HappyAbsSyn )
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn ) -> (InjectivityInfo L)
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: ([Name L]) -> (HappyAbsSyn )
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn ) -> ([Name L])
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: (Decl L) -> (HappyAbsSyn )
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn ) -> (Decl L)
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: (Maybe (ResultSig L)) -> (HappyAbsSyn )
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn ) -> (Maybe (ResultSig L))
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: (Maybe (ResultSig L)) -> (HappyAbsSyn )
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn ) -> (Maybe (ResultSig L))
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: ((Maybe (ResultSig L), Maybe (InjectivityInfo L))) -> (HappyAbsSyn )
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn ) -> ((Maybe (ResultSig L), Maybe (InjectivityInfo L)))
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: ((Maybe (ResultSig L), Maybe (S, Type L), Maybe (InjectivityInfo L))) -> (HappyAbsSyn )
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn ) -> ((Maybe (ResultSig L), Maybe (S, Type L), Maybe (InjectivityInfo L)))
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: (Decl L) -> (HappyAbsSyn )
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn ) -> (Decl L)
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: ([(Maybe String, L)]) -> (HappyAbsSyn )
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn ) -> ([(Maybe String, L)])
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: ((Maybe String, L)) -> (HappyAbsSyn )
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn ) -> ((Maybe String, L))
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: (Maybe (Overlap L)) -> (HappyAbsSyn )
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn ) -> (Maybe (Overlap L))
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: (Maybe ([TypeEqn L], S)) -> (HappyAbsSyn )
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn ) -> (Maybe ([TypeEqn L], S))
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: ([TypeEqn L]) -> (HappyAbsSyn )
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn ) -> ([TypeEqn L])
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: ([TypeEqn L]) -> (HappyAbsSyn )
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn ) -> ([TypeEqn L])
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: (TypeEqn L) -> (HappyAbsSyn )
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn ) -> (TypeEqn L)
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: (DataOrNew L) -> (HappyAbsSyn )
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn ) -> (DataOrNew L)
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: (([Type L],[S])) -> (HappyAbsSyn )
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn ) -> (([Type L],[S]))
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: (Decl L) -> (HappyAbsSyn )
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn ) -> (Decl L)
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: (Binds L) -> (HappyAbsSyn )
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn ) -> (Binds L)
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: (Decl L) -> (HappyAbsSyn )
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn ) -> (Decl L)
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: (Decl L) -> (HappyAbsSyn )
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn ) -> (Decl L)
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: (Decl L) -> (HappyAbsSyn )
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn ) -> (Decl L)
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: (([Type L],[S])) -> (HappyAbsSyn )
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn ) -> (([Type L],[S]))
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: (Type L) -> (HappyAbsSyn )
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn ) -> (Type L)
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: (Maybe (BooleanFormula L)) -> (HappyAbsSyn )
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn ) -> (Maybe (BooleanFormula L))
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyIn85 :: (BooleanFormula L) -> (HappyAbsSyn )
happyIn85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn ) -> (BooleanFormula L)
happyOut85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut85 #-}
happyIn86 :: (BooleanFormula L) -> (HappyAbsSyn )
happyIn86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn ) -> (BooleanFormula L)
happyOut86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut86 #-}
happyIn87 :: (BooleanFormula L) -> (HappyAbsSyn )
happyIn87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn ) -> (BooleanFormula L)
happyOut87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut87 #-}
happyIn88 :: (Binds L) -> (HappyAbsSyn )
happyIn88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn88 #-}
happyOut88 :: (HappyAbsSyn ) -> (Binds L)
happyOut88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut88 #-}
happyIn89 :: (([Name L],[S],L)) -> (HappyAbsSyn )
happyIn89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn89 #-}
happyOut89 :: (HappyAbsSyn ) -> (([Name L],[S],L))
happyOut89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut89 #-}
happyIn90 :: (CallConv L) -> (HappyAbsSyn )
happyIn90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn90 #-}
happyOut90 :: (HappyAbsSyn ) -> (CallConv L)
happyOut90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut90 #-}
happyIn91 :: (Maybe (Safety L)) -> (HappyAbsSyn )
happyIn91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn91 #-}
happyOut91 :: (HappyAbsSyn ) -> (Maybe (Safety L))
happyOut91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut91 #-}
happyIn92 :: ((Maybe String, Name L, Type L, [S])) -> (HappyAbsSyn )
happyIn92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn92 #-}
happyOut92 :: (HappyAbsSyn ) -> ((Maybe String, Name L, Type L, [S]))
happyOut92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut92 #-}
happyIn93 :: ([Rule L]) -> (HappyAbsSyn )
happyIn93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn93 #-}
happyOut93 :: (HappyAbsSyn ) -> ([Rule L])
happyOut93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut93 #-}
happyIn94 :: (Rule L) -> (HappyAbsSyn )
happyIn94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn94 #-}
happyOut94 :: (HappyAbsSyn ) -> (Rule L)
happyOut94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut94 #-}
happyIn95 :: (Maybe (Activation L)) -> (HappyAbsSyn )
happyIn95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn95 #-}
happyOut95 :: (HappyAbsSyn ) -> (Maybe (Activation L))
happyOut95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut95 #-}
happyIn96 :: ((Maybe [RuleVar L],[S])) -> (HappyAbsSyn )
happyIn96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn96 #-}
happyOut96 :: (HappyAbsSyn ) -> ((Maybe [RuleVar L],[S]))
happyOut96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut96 #-}
happyIn97 :: ([RuleVar L]) -> (HappyAbsSyn )
happyIn97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn97 #-}
happyOut97 :: (HappyAbsSyn ) -> ([RuleVar L])
happyOut97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut97 #-}
happyIn98 :: (RuleVar L) -> (HappyAbsSyn )
happyIn98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn98 #-}
happyOut98 :: (HappyAbsSyn ) -> (RuleVar L)
happyOut98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut98 #-}
happyIn99 :: (([([Name L],String)],[S])) -> (HappyAbsSyn )
happyIn99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn99 #-}
happyOut99 :: (HappyAbsSyn ) -> (([([Name L],String)],[S]))
happyOut99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut99 #-}
happyIn100 :: ((([Name L], String),[S])) -> (HappyAbsSyn )
happyIn100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn100 #-}
happyOut100 :: (HappyAbsSyn ) -> ((([Name L], String),[S]))
happyOut100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut100 #-}
happyIn101 :: (([Name L],[S])) -> (HappyAbsSyn )
happyIn101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn101 #-}
happyOut101 :: (HappyAbsSyn ) -> (([Name L],[S]))
happyOut101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut101 #-}
happyIn102 :: (Name L) -> (HappyAbsSyn )
happyIn102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn102 #-}
happyOut102 :: (HappyAbsSyn ) -> (Name L)
happyOut102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut102 #-}
happyIn103 :: (Annotation L) -> (HappyAbsSyn )
happyIn103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn103 #-}
happyOut103 :: (HappyAbsSyn ) -> (Annotation L)
happyOut103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut103 #-}
happyIn104 :: (Type L) -> (HappyAbsSyn )
happyIn104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn104 #-}
happyOut104 :: (HappyAbsSyn ) -> (Type L)
happyOut104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut104 #-}
happyIn105 :: (PType L) -> (HappyAbsSyn )
happyIn105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn105 #-}
happyOut105 :: (HappyAbsSyn ) -> (PType L)
happyOut105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut105 #-}
happyIn106 :: (Type L) -> (HappyAbsSyn )
happyIn106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn106 #-}
happyOut106 :: (HappyAbsSyn ) -> (Type L)
happyOut106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut106 #-}
happyIn107 :: (PType L) -> (HappyAbsSyn )
happyIn107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn107 #-}
happyOut107 :: (HappyAbsSyn ) -> (PType L)
happyOut107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut107 #-}
happyIn108 :: (Type L) -> (HappyAbsSyn )
happyIn108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn108 #-}
happyOut108 :: (HappyAbsSyn ) -> (Type L)
happyOut108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut108 #-}
happyIn109 :: (Type L) -> (HappyAbsSyn )
happyIn109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn109 #-}
happyOut109 :: (HappyAbsSyn ) -> (Type L)
happyOut109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut109 #-}
happyIn110 :: (PType L) -> (HappyAbsSyn )
happyIn110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn110 #-}
happyOut110 :: (HappyAbsSyn ) -> (PType L)
happyOut110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut110 #-}
happyIn111 :: (PType L) -> (HappyAbsSyn )
happyIn111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn111 #-}
happyOut111 :: (HappyAbsSyn ) -> (PType L)
happyOut111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut111 #-}
happyIn112 :: (Promoted L) -> (HappyAbsSyn )
happyIn112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn112 #-}
happyOut112 :: (HappyAbsSyn ) -> (Promoted L)
happyOut112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut112 #-}
happyIn113 :: ((Maybe (L -> BangType L,S), Maybe (Unpackedness L))) -> (HappyAbsSyn )
happyIn113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn113 #-}
happyOut113 :: (HappyAbsSyn ) -> ((Maybe (L -> BangType L,S), Maybe (Unpackedness L)))
happyOut113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut113 #-}
happyIn114 :: ((L -> BangType L, S)) -> (HappyAbsSyn )
happyIn114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn114 #-}
happyOut114 :: (HappyAbsSyn ) -> ((L -> BangType L, S))
happyOut114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut114 #-}
happyIn115 :: (Unpackedness L) -> (HappyAbsSyn )
happyIn115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn115 #-}
happyOut115 :: (HappyAbsSyn ) -> (Unpackedness L)
happyOut115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut115 #-}
happyIn116 :: (QName L) -> (HappyAbsSyn )
happyIn116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn116 #-}
happyOut116 :: (HappyAbsSyn ) -> (QName L)
happyOut116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut116 #-}
happyIn117 :: (QName L) -> (HappyAbsSyn )
happyIn117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn117 #-}
happyOut117 :: (HappyAbsSyn ) -> (QName L)
happyOut117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut117 #-}
happyIn118 :: (MaybePromotedName L) -> (HappyAbsSyn )
happyIn118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn118 #-}
happyOut118 :: (HappyAbsSyn ) -> (MaybePromotedName L)
happyOut118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut118 #-}
happyIn119 :: (Type L) -> (HappyAbsSyn )
happyIn119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn119 #-}
happyOut119 :: (HappyAbsSyn ) -> (Type L)
happyOut119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut119 #-}
happyIn120 :: (PType L) -> (HappyAbsSyn )
happyIn120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn120 #-}
happyOut120 :: (HappyAbsSyn ) -> (PType L)
happyOut120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut120 #-}
happyIn121 :: (PContext L) -> (HappyAbsSyn )
happyIn121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn121 #-}
happyOut121 :: (HappyAbsSyn ) -> (PContext L)
happyOut121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut121 #-}
happyIn122 :: (([PType L],[S])) -> (HappyAbsSyn )
happyIn122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn122 #-}
happyOut122 :: (HappyAbsSyn ) -> (([PType L],[S]))
happyOut122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut122 #-}
happyIn123 :: (([PType L],[S])) -> (HappyAbsSyn )
happyIn123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn123 #-}
happyOut123 :: (HappyAbsSyn ) -> (([PType L],[S]))
happyOut123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut123 #-}
happyIn124 :: (([PType L],[S])) -> (HappyAbsSyn )
happyIn124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn124 #-}
happyOut124 :: (HappyAbsSyn ) -> (([PType L],[S]))
happyOut124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut124 #-}
happyIn125 :: (([TyVarBind L],Maybe L)) -> (HappyAbsSyn )
happyIn125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn125 #-}
happyOut125 :: (HappyAbsSyn ) -> (([TyVarBind L],Maybe L))
happyOut125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut125 #-}
happyIn126 :: (TyVarBind L) -> (HappyAbsSyn )
happyIn126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn126 #-}
happyOut126 :: (HappyAbsSyn ) -> (TyVarBind L)
happyOut126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut126 #-}
happyIn127 :: (([Name L],Maybe L)) -> (HappyAbsSyn )
happyIn127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn127 #-}
happyOut127 :: (HappyAbsSyn ) -> (([Name L],Maybe L))
happyOut127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut127 #-}
happyIn128 :: (([Name L],L)) -> (HappyAbsSyn )
happyIn128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn128 #-}
happyOut128 :: (HappyAbsSyn ) -> (([Name L],L))
happyOut128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut128 #-}
happyIn129 :: (([FunDep L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn129 #-}
happyOut129 :: (HappyAbsSyn ) -> (([FunDep L],[S],Maybe L))
happyOut129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut129 #-}
happyIn130 :: (([FunDep L],[S],L)) -> (HappyAbsSyn )
happyIn130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn130 #-}
happyOut130 :: (HappyAbsSyn ) -> (([FunDep L],[S],L))
happyOut130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut130 #-}
happyIn131 :: (FunDep L) -> (HappyAbsSyn )
happyIn131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn131 #-}
happyOut131 :: (HappyAbsSyn ) -> (FunDep L)
happyOut131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut131 #-}
happyIn132 :: (([GadtDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn132 #-}
happyOut132 :: (HappyAbsSyn ) -> (([GadtDecl L],[S],Maybe L))
happyOut132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut132 #-}
happyIn133 :: (([GadtDecl L],[S])) -> (HappyAbsSyn )
happyIn133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn133 #-}
happyOut133 :: (HappyAbsSyn ) -> (([GadtDecl L],[S]))
happyOut133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut133 #-}
happyIn134 :: (([GadtDecl L],[S])) -> (HappyAbsSyn )
happyIn134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn134 #-}
happyOut134 :: (HappyAbsSyn ) -> (([GadtDecl L],[S]))
happyOut134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut134 #-}
happyIn135 :: ([GadtDecl L]) -> (HappyAbsSyn )
happyIn135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn135 #-}
happyOut135 :: (HappyAbsSyn ) -> ([GadtDecl L])
happyOut135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut135 #-}
happyIn136 :: (([QualConDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn136 #-}
happyOut136 :: (HappyAbsSyn ) -> (([QualConDecl L],[S],Maybe L))
happyOut136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut136 #-}
happyIn137 :: (([QualConDecl L],[S],L)) -> (HappyAbsSyn )
happyIn137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn137 #-}
happyOut137 :: (HappyAbsSyn ) -> (([QualConDecl L],[S],L))
happyOut137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut137 #-}
happyIn138 :: (QualConDecl L) -> (HappyAbsSyn )
happyIn138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn138 #-}
happyOut138 :: (HappyAbsSyn ) -> (QualConDecl L)
happyOut138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut138 #-}
happyIn139 :: ((Maybe [TyVarBind L], [S], Maybe L)) -> (HappyAbsSyn )
happyIn139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn139 #-}
happyOut139 :: (HappyAbsSyn ) -> ((Maybe [TyVarBind L], [S], Maybe L))
happyOut139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut139 #-}
happyIn140 :: (ConDecl L) -> (HappyAbsSyn )
happyIn140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn140 #-}
happyOut140 :: (HappyAbsSyn ) -> (ConDecl L)
happyOut140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut140 #-}
happyIn141 :: ((Name L, [Type L], L)) -> (HappyAbsSyn )
happyIn141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn141 #-}
happyOut141 :: (HappyAbsSyn ) -> ((Name L, [Type L], L))
happyOut141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut141 #-}
happyIn142 :: (([FieldDecl L],[S])) -> (HappyAbsSyn )
happyIn142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn142 #-}
happyOut142 :: (HappyAbsSyn ) -> (([FieldDecl L],[S]))
happyOut142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut142 #-}
happyIn143 :: (FieldDecl L) -> (HappyAbsSyn )
happyIn143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn143 #-}
happyOut143 :: (HappyAbsSyn ) -> (FieldDecl L)
happyOut143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut143 #-}
happyIn144 :: ([Deriving L]) -> (HappyAbsSyn )
happyIn144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn144 #-}
happyOut144 :: (HappyAbsSyn ) -> ([Deriving L])
happyOut144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut144 #-}
happyIn145 :: ([Deriving L]) -> (HappyAbsSyn )
happyIn145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn145 #-}
happyOut145 :: (HappyAbsSyn ) -> ([Deriving L])
happyOut145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut145 #-}
happyIn146 :: (Deriving L) -> (HappyAbsSyn )
happyIn146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn146 #-}
happyOut146 :: (HappyAbsSyn ) -> (Deriving L)
happyOut146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut146 #-}
happyIn147 :: (([InstRule L],[S])) -> (HappyAbsSyn )
happyIn147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn147 #-}
happyOut147 :: (HappyAbsSyn ) -> (([InstRule L],[S]))
happyOut147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut147 #-}
happyIn148 :: (InstHead L) -> (HappyAbsSyn )
happyIn148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn148 #-}
happyOut148 :: (HappyAbsSyn ) -> (InstHead L)
happyOut148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut148 #-}
happyIn149 :: (Kind L) -> (HappyAbsSyn )
happyIn149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn149 #-}
happyOut149 :: (HappyAbsSyn ) -> (Kind L)
happyOut149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut149 #-}
happyIn150 :: (Kind L) -> (HappyAbsSyn )
happyIn150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn150 #-}
happyOut150 :: (HappyAbsSyn ) -> (Kind L)
happyOut150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut150 #-}
happyIn151 :: (Kind L) -> (HappyAbsSyn )
happyIn151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn151 #-}
happyOut151 :: (HappyAbsSyn ) -> (Kind L)
happyOut151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut151 #-}
happyIn152 :: (Kind L) -> (HappyAbsSyn )
happyIn152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn152 #-}
happyOut152 :: (HappyAbsSyn ) -> (Kind L)
happyOut152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut152 #-}
happyIn153 :: (Kind L) -> (HappyAbsSyn )
happyIn153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn153 #-}
happyOut153 :: (HappyAbsSyn ) -> (Kind L)
happyOut153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut153 #-}
happyIn154 :: (([Kind L], [S])) -> (HappyAbsSyn )
happyIn154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn154 #-}
happyOut154 :: (HappyAbsSyn ) -> (([Kind L], [S]))
happyOut154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut154 #-}
happyIn155 :: ((Maybe (Kind L), [S])) -> (HappyAbsSyn )
happyIn155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn155 #-}
happyOut155 :: (HappyAbsSyn ) -> ((Maybe (Kind L), [S]))
happyOut155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut155 #-}
happyIn156 :: (Maybe ( S, QName L )) -> (HappyAbsSyn )
happyIn156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn156 #-}
happyOut156 :: (HappyAbsSyn ) -> (Maybe ( S, QName L ))
happyOut156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut156 #-}
happyIn157 :: ((Maybe [ClassDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn157 #-}
happyOut157 :: (HappyAbsSyn ) -> ((Maybe [ClassDecl L],[S],Maybe L))
happyOut157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut157 #-}
happyIn158 :: (([ClassDecl L],[S])) -> (HappyAbsSyn )
happyIn158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn158 #-}
happyOut158 :: (HappyAbsSyn ) -> (([ClassDecl L],[S]))
happyOut158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut158 #-}
happyIn159 :: (([ClassDecl L],[S])) -> (HappyAbsSyn )
happyIn159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn159 #-}
happyOut159 :: (HappyAbsSyn ) -> (([ClassDecl L],[S]))
happyOut159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut159 #-}
happyIn160 :: (ClassDecl L) -> (HappyAbsSyn )
happyIn160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn160 #-}
happyOut160 :: (HappyAbsSyn ) -> (ClassDecl L)
happyOut160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut160 #-}
happyIn161 :: ([S]) -> (HappyAbsSyn )
happyIn161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn161 #-}
happyOut161 :: (HappyAbsSyn ) -> ([S])
happyOut161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut161 #-}
happyIn162 :: (ClassDecl L) -> (HappyAbsSyn )
happyIn162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn162 #-}
happyOut162 :: (HappyAbsSyn ) -> (ClassDecl L)
happyOut162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut162 #-}
happyIn163 :: ((Maybe [InstDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn163 #-}
happyOut163 :: (HappyAbsSyn ) -> ((Maybe [InstDecl L],[S],Maybe L))
happyOut163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut163 #-}
happyIn164 :: (([InstDecl L],[S])) -> (HappyAbsSyn )
happyIn164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn164 #-}
happyOut164 :: (HappyAbsSyn ) -> (([InstDecl L],[S]))
happyOut164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut164 #-}
happyIn165 :: (([InstDecl L],[S])) -> (HappyAbsSyn )
happyIn165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn165 #-}
happyOut165 :: (HappyAbsSyn ) -> (([InstDecl L],[S]))
happyOut165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut165 #-}
happyIn166 :: (InstDecl L) -> (HappyAbsSyn )
happyIn166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn166 #-}
happyOut166 :: (HappyAbsSyn ) -> (InstDecl L)
happyOut166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut166 #-}
happyIn167 :: (InstDecl L) -> (HappyAbsSyn )
happyIn167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn167 #-}
happyOut167 :: (HappyAbsSyn ) -> (InstDecl L)
happyOut167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut167 #-}
happyIn168 :: (Decl L) -> (HappyAbsSyn )
happyIn168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn168 #-}
happyOut168 :: (HappyAbsSyn ) -> (Decl L)
happyOut168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut168 #-}
happyIn169 :: ((Maybe (Binds L),[S])) -> (HappyAbsSyn )
happyIn169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn169 #-}
happyOut169 :: (HappyAbsSyn ) -> ((Maybe (Binds L),[S]))
happyOut169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut169 #-}
happyIn170 :: ((Maybe (Type L, S))) -> (HappyAbsSyn )
happyIn170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn170 #-}
happyOut170 :: (HappyAbsSyn ) -> ((Maybe (Type L, S)))
happyOut170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut170 #-}
happyIn171 :: (Rhs L) -> (HappyAbsSyn )
happyIn171 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn171 #-}
happyOut171 :: (HappyAbsSyn ) -> (Rhs L)
happyOut171 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut171 #-}
happyIn172 :: (([GuardedRhs L],L)) -> (HappyAbsSyn )
happyIn172 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn172 #-}
happyOut172 :: (HappyAbsSyn ) -> (([GuardedRhs L],L))
happyOut172 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut172 #-}
happyIn173 :: (GuardedRhs L) -> (HappyAbsSyn )
happyIn173 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn173 #-}
happyOut173 :: (HappyAbsSyn ) -> (GuardedRhs L)
happyOut173 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut173 #-}
happyIn174 :: (Exp L) -> (HappyAbsSyn )
happyIn174 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn174 #-}
happyOut174 :: (HappyAbsSyn ) -> (Exp L)
happyOut174 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut174 #-}
happyIn175 :: (PExp L) -> (HappyAbsSyn )
happyIn175 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn175 #-}
happyOut175 :: (HappyAbsSyn ) -> (PExp L)
happyOut175 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut175 #-}
happyIn176 :: (PExp L) -> (HappyAbsSyn )
happyIn176 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn176 #-}
happyOut176 :: (HappyAbsSyn ) -> (PExp L)
happyOut176 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut176 #-}
happyIn177 :: (PExp L) -> (HappyAbsSyn )
happyIn177 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn177 #-}
happyOut177 :: (HappyAbsSyn ) -> (PExp L)
happyOut177 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut177 #-}
happyIn178 :: (PExp L) -> (HappyAbsSyn )
happyIn178 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn178 #-}
happyOut178 :: (HappyAbsSyn ) -> (PExp L)
happyOut178 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut178 #-}
happyIn179 :: (PExp L) -> (HappyAbsSyn )
happyIn179 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn179 #-}
happyOut179 :: (HappyAbsSyn ) -> (PExp L)
happyOut179 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut179 #-}
happyIn180 :: ([S]) -> (HappyAbsSyn )
happyIn180 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn180 #-}
happyOut180 :: (HappyAbsSyn ) -> ([S])
happyOut180 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut180 #-}
happyIn181 :: ([S]) -> (HappyAbsSyn )
happyIn181 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn181 #-}
happyOut181 :: (HappyAbsSyn ) -> ([S])
happyOut181 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut181 #-}
happyIn182 :: (PExp L) -> (HappyAbsSyn )
happyIn182 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn182 #-}
happyOut182 :: (HappyAbsSyn ) -> (PExp L)
happyOut182 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut182 #-}
happyIn183 :: (PExp L) -> (HappyAbsSyn )
happyIn183 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn183 #-}
happyOut183 :: (HappyAbsSyn ) -> (PExp L)
happyOut183 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut183 #-}
happyIn184 :: (PExp L) -> (HappyAbsSyn )
happyIn184 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn184 #-}
happyOut184 :: (HappyAbsSyn ) -> (PExp L)
happyOut184 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut184 #-}
happyIn185 :: ([Pat L]) -> (HappyAbsSyn )
happyIn185 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn185 #-}
happyOut185 :: (HappyAbsSyn ) -> ([Pat L])
happyOut185 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut185 #-}
happyIn186 :: (Pat L) -> (HappyAbsSyn )
happyIn186 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn186 #-}
happyOut186 :: (HappyAbsSyn ) -> (Pat L)
happyOut186 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut186 #-}
happyIn187 :: (PExp L) -> (HappyAbsSyn )
happyIn187 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn187 #-}
happyOut187 :: (HappyAbsSyn ) -> (PExp L)
happyOut187 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut187 #-}
happyIn188 :: (PExp L) -> (HappyAbsSyn )
happyIn188 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn188 #-}
happyOut188 :: (HappyAbsSyn ) -> (PExp L)
happyOut188 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut188 #-}
happyIn189 :: (PExp L) -> (HappyAbsSyn )
happyIn189 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn189 #-}
happyOut189 :: (HappyAbsSyn ) -> (PExp L)
happyOut189 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut189 #-}
happyIn190 :: (([S], SumOrTuple L)) -> (HappyAbsSyn )
happyIn190 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn190 #-}
happyOut190 :: (HappyAbsSyn ) -> (([S], SumOrTuple L))
happyOut190 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut190 #-}
happyIn191 :: (([S], [Maybe (PExp L)])) -> (HappyAbsSyn )
happyIn191 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn191 #-}
happyOut191 :: (HappyAbsSyn ) -> (([S], [Maybe (PExp L)]))
happyOut191 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut191 #-}
happyIn192 :: (([S], [Maybe (PExp L)])) -> (HappyAbsSyn )
happyIn192 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn192 #-}
happyOut192 :: (HappyAbsSyn ) -> (([S], [Maybe (PExp L)]))
happyOut192 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut192 #-}
happyIn193 :: ([S]) -> (HappyAbsSyn )
happyIn193 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn193 #-}
happyOut193 :: (HappyAbsSyn ) -> ([S])
happyOut193 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut193 #-}
happyIn194 :: ([S]) -> (HappyAbsSyn )
happyIn194 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn194 #-}
happyOut194 :: (HappyAbsSyn ) -> ([S])
happyOut194 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut194 #-}
happyIn195 :: ([S]) -> (HappyAbsSyn )
happyIn195 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn195 #-}
happyOut195 :: (HappyAbsSyn ) -> ([S])
happyOut195 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut195 #-}
happyIn196 :: (PExp L) -> (HappyAbsSyn )
happyIn196 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn196 #-}
happyOut196 :: (HappyAbsSyn ) -> (PExp L)
happyOut196 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut196 #-}
happyIn197 :: (([PExp L],[S])) -> (HappyAbsSyn )
happyIn197 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn197 #-}
happyOut197 :: (HappyAbsSyn ) -> (([PExp L],[S]))
happyOut197 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut197 #-}
happyIn198 :: (PExp L) -> (HappyAbsSyn )
happyIn198 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn198 #-}
happyOut198 :: (HappyAbsSyn ) -> (PExp L)
happyOut198 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut198 #-}
happyIn199 :: (PExp L) -> (HappyAbsSyn )
happyIn199 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn199 #-}
happyOut199 :: (HappyAbsSyn ) -> (PExp L)
happyOut199 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut199 #-}
happyIn200 :: ([PExp L]) -> (HappyAbsSyn )
happyIn200 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn200 #-}
happyOut200 :: (HappyAbsSyn ) -> ([PExp L])
happyOut200 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut200 #-}
happyIn201 :: (PExp L) -> (HappyAbsSyn )
happyIn201 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn201 #-}
happyOut201 :: (HappyAbsSyn ) -> (PExp L)
happyOut201 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut201 #-}
happyIn202 :: (XName L) -> (HappyAbsSyn )
happyIn202 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn202 #-}
happyOut202 :: (HappyAbsSyn ) -> (XName L)
happyOut202 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut202 #-}
happyIn203 :: (Loc String) -> (HappyAbsSyn )
happyIn203 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn203 #-}
happyOut203 :: (HappyAbsSyn ) -> (Loc String)
happyOut203 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut203 #-}
happyIn204 :: (Loc String) -> (HappyAbsSyn )
happyIn204 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn204 #-}
happyOut204 :: (HappyAbsSyn ) -> (Loc String)
happyOut204 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut204 #-}
happyIn205 :: ([ParseXAttr L]) -> (HappyAbsSyn )
happyIn205 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn205 #-}
happyOut205 :: (HappyAbsSyn ) -> ([ParseXAttr L])
happyOut205 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut205 #-}
happyIn206 :: (ParseXAttr L) -> (HappyAbsSyn )
happyIn206 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn206 #-}
happyOut206 :: (HappyAbsSyn ) -> (ParseXAttr L)
happyOut206 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut206 #-}
happyIn207 :: (Maybe (PExp L)) -> (HappyAbsSyn )
happyIn207 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn207 #-}
happyOut207 :: (HappyAbsSyn ) -> (Maybe (PExp L))
happyOut207 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut207 #-}
happyIn208 :: (L -> PExp L) -> (HappyAbsSyn )
happyIn208 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn208 #-}
happyOut208 :: (HappyAbsSyn ) -> (L -> PExp L)
happyOut208 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut208 #-}
happyIn209 :: (([PExp L],[S])) -> (HappyAbsSyn )
happyIn209 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn209 #-}
happyOut209 :: (HappyAbsSyn ) -> (([PExp L],[S]))
happyOut209 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut209 #-}
happyIn210 :: (([[QualStmt L]],[S])) -> (HappyAbsSyn )
happyIn210 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn210 #-}
happyOut210 :: (HappyAbsSyn ) -> (([[QualStmt L]],[S]))
happyOut210 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut210 #-}
happyIn211 :: (([QualStmt L],[S])) -> (HappyAbsSyn )
happyIn211 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn211 #-}
happyOut211 :: (HappyAbsSyn ) -> (([QualStmt L],[S]))
happyOut211 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut211 #-}
happyIn212 :: (QualStmt L) -> (HappyAbsSyn )
happyIn212 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn212 #-}
happyOut212 :: (HappyAbsSyn ) -> (QualStmt L)
happyOut212 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut212 #-}
happyIn213 :: (QualStmt L) -> (HappyAbsSyn )
happyIn213 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn213 #-}
happyOut213 :: (HappyAbsSyn ) -> (QualStmt L)
happyOut213 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut213 #-}
happyIn214 :: (([Stmt L],[S])) -> (HappyAbsSyn )
happyIn214 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn214 #-}
happyOut214 :: (HappyAbsSyn ) -> (([Stmt L],[S]))
happyOut214 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut214 #-}
happyIn215 :: (Stmt L) -> (HappyAbsSyn )
happyIn215 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn215 #-}
happyOut215 :: (HappyAbsSyn ) -> (Stmt L)
happyOut215 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut215 #-}
happyIn216 :: (L -> PExp L) -> (HappyAbsSyn )
happyIn216 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn216 #-}
happyOut216 :: (HappyAbsSyn ) -> (L -> PExp L)
happyOut216 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut216 #-}
happyIn217 :: (([Alt L],L,[S])) -> (HappyAbsSyn )
happyIn217 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn217 #-}
happyOut217 :: (HappyAbsSyn ) -> (([Alt L],L,[S]))
happyOut217 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut217 #-}
happyIn218 :: (([Alt L],[S])) -> (HappyAbsSyn )
happyIn218 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn218 #-}
happyOut218 :: (HappyAbsSyn ) -> (([Alt L],[S]))
happyOut218 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut218 #-}
happyIn219 :: (([Alt L],[S])) -> (HappyAbsSyn )
happyIn219 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn219 #-}
happyOut219 :: (HappyAbsSyn ) -> (([Alt L],[S]))
happyOut219 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut219 #-}
happyIn220 :: (Alt L) -> (HappyAbsSyn )
happyIn220 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn220 #-}
happyOut220 :: (HappyAbsSyn ) -> (Alt L)
happyOut220 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut220 #-}
happyIn221 :: (Rhs L) -> (HappyAbsSyn )
happyIn221 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn221 #-}
happyOut221 :: (HappyAbsSyn ) -> (Rhs L)
happyOut221 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut221 #-}
happyIn222 :: (([GuardedRhs L],L)) -> (HappyAbsSyn )
happyIn222 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn222 #-}
happyOut222 :: (HappyAbsSyn ) -> (([GuardedRhs L],L))
happyOut222 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut222 #-}
happyIn223 :: (GuardedRhs L) -> (HappyAbsSyn )
happyIn223 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn223 #-}
happyOut223 :: (HappyAbsSyn ) -> (GuardedRhs L)
happyOut223 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut223 #-}
happyIn224 :: (Pat L) -> (HappyAbsSyn )
happyIn224 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn224 #-}
happyOut224 :: (HappyAbsSyn ) -> (Pat L)
happyOut224 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut224 #-}
happyIn225 :: (([GuardedRhs L], L, [S])) -> (HappyAbsSyn )
happyIn225 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn225 #-}
happyOut225 :: (HappyAbsSyn ) -> (([GuardedRhs L], L, [S]))
happyOut225 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut225 #-}
happyIn226 :: (([GuardedRhs L], [S])) -> (HappyAbsSyn )
happyIn226 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn226 #-}
happyOut226 :: (HappyAbsSyn ) -> (([GuardedRhs L], [S]))
happyOut226 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut226 #-}
happyIn227 :: (([GuardedRhs L], [S])) -> (HappyAbsSyn )
happyIn227 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn227 #-}
happyOut227 :: (HappyAbsSyn ) -> (([GuardedRhs L], [S]))
happyOut227 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut227 #-}
happyIn228 :: (([Stmt L],L,[S])) -> (HappyAbsSyn )
happyIn228 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn228 #-}
happyOut228 :: (HappyAbsSyn ) -> (([Stmt L],L,[S]))
happyOut228 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut228 #-}
happyIn229 :: (([Stmt L],[S])) -> (HappyAbsSyn )
happyIn229 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn229 #-}
happyOut229 :: (HappyAbsSyn ) -> (([Stmt L],[S]))
happyOut229 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut229 #-}
happyIn230 :: (([Stmt L],[S])) -> (HappyAbsSyn )
happyIn230 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn230 #-}
happyOut230 :: (HappyAbsSyn ) -> (([Stmt L],[S]))
happyOut230 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut230 #-}
happyIn231 :: (Stmt L) -> (HappyAbsSyn )
happyIn231 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn231 #-}
happyOut231 :: (HappyAbsSyn ) -> (Stmt L)
happyOut231 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut231 #-}
happyIn232 :: (([PFieldUpdate L],[S])) -> (HappyAbsSyn )
happyIn232 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn232 #-}
happyOut232 :: (HappyAbsSyn ) -> (([PFieldUpdate L],[S]))
happyOut232 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut232 #-}
happyIn233 :: (PFieldUpdate L) -> (HappyAbsSyn )
happyIn233 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn233 #-}
happyOut233 :: (HappyAbsSyn ) -> (PFieldUpdate L)
happyOut233 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut233 #-}
happyIn234 :: (([IPBind L],[S])) -> (HappyAbsSyn )
happyIn234 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn234 #-}
happyOut234 :: (HappyAbsSyn ) -> (([IPBind L],[S]))
happyOut234 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut234 #-}
happyIn235 :: (([IPBind L],[S])) -> (HappyAbsSyn )
happyIn235 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn235 #-}
happyOut235 :: (HappyAbsSyn ) -> (([IPBind L],[S]))
happyOut235 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut235 #-}
happyIn236 :: (IPBind L) -> (HappyAbsSyn )
happyIn236 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn236 #-}
happyOut236 :: (HappyAbsSyn ) -> (IPBind L)
happyOut236 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut236 #-}
happyIn237 :: (PExp L) -> (HappyAbsSyn )
happyIn237 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn237 #-}
happyOut237 :: (HappyAbsSyn ) -> (PExp L)
happyOut237 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut237 #-}
happyIn238 :: (PExp L) -> (HappyAbsSyn )
happyIn238 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn238 #-}
happyOut238 :: (HappyAbsSyn ) -> (PExp L)
happyOut238 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut238 #-}
happyIn239 :: (PExp L) -> (HappyAbsSyn )
happyIn239 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn239 #-}
happyOut239 :: (HappyAbsSyn ) -> (PExp L)
happyOut239 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut239 #-}
happyIn240 :: (PExp L) -> (HappyAbsSyn )
happyIn240 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn240 #-}
happyOut240 :: (HappyAbsSyn ) -> (PExp L)
happyOut240 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut240 #-}
happyIn241 :: (Name L) -> (HappyAbsSyn )
happyIn241 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn241 #-}
happyOut241 :: (HappyAbsSyn ) -> (Name L)
happyOut241 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut241 #-}
happyIn242 :: (Name L) -> (HappyAbsSyn )
happyIn242 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn242 #-}
happyOut242 :: (HappyAbsSyn ) -> (Name L)
happyOut242 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut242 #-}
happyIn243 :: (QName L) -> (HappyAbsSyn )
happyIn243 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn243 #-}
happyOut243 :: (HappyAbsSyn ) -> (QName L)
happyOut243 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut243 #-}
happyIn244 :: (IPName L) -> (HappyAbsSyn )
happyIn244 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn244 #-}
happyOut244 :: (HappyAbsSyn ) -> (IPName L)
happyOut244 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut244 #-}
happyIn245 :: (Name L) -> (HappyAbsSyn )
happyIn245 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn245 #-}
happyOut245 :: (HappyAbsSyn ) -> (Name L)
happyOut245 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut245 #-}
happyIn246 :: (([S], [Name L])) -> (HappyAbsSyn )
happyIn246 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn246 #-}
happyOut246 :: (HappyAbsSyn ) -> (([S], [Name L]))
happyOut246 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut246 #-}
happyIn247 :: (QName L) -> (HappyAbsSyn )
happyIn247 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn247 #-}
happyOut247 :: (HappyAbsSyn ) -> (QName L)
happyOut247 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut247 #-}
happyIn248 :: (Name L) -> (HappyAbsSyn )
happyIn248 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn248 #-}
happyOut248 :: (HappyAbsSyn ) -> (Name L)
happyOut248 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut248 #-}
happyIn249 :: (QName L) -> (HappyAbsSyn )
happyIn249 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn249 #-}
happyOut249 :: (HappyAbsSyn ) -> (QName L)
happyOut249 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut249 #-}
happyIn250 :: (QName L) -> (HappyAbsSyn )
happyIn250 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn250 #-}
happyOut250 :: (HappyAbsSyn ) -> (QName L)
happyOut250 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut250 #-}
happyIn251 :: (Name L) -> (HappyAbsSyn )
happyIn251 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn251 #-}
happyOut251 :: (HappyAbsSyn ) -> (Name L)
happyOut251 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut251 #-}
happyIn252 :: (QName L) -> (HappyAbsSyn )
happyIn252 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn252 #-}
happyOut252 :: (HappyAbsSyn ) -> (QName L)
happyOut252 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut252 #-}
happyIn253 :: (Op L) -> (HappyAbsSyn )
happyIn253 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn253 #-}
happyOut253 :: (HappyAbsSyn ) -> (Op L)
happyOut253 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut253 #-}
happyIn254 :: (QOp L) -> (HappyAbsSyn )
happyIn254 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn254 #-}
happyOut254 :: (HappyAbsSyn ) -> (QOp L)
happyOut254 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut254 #-}
happyIn255 :: (QOp L) -> (HappyAbsSyn )
happyIn255 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn255 #-}
happyOut255 :: (HappyAbsSyn ) -> (QOp L)
happyOut255 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut255 #-}
happyIn256 :: (QName L) -> (HappyAbsSyn )
happyIn256 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn256 #-}
happyOut256 :: (HappyAbsSyn ) -> (QName L)
happyOut256 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut256 #-}
happyIn257 :: (PExp L) -> (HappyAbsSyn )
happyIn257 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn257 #-}
happyOut257 :: (HappyAbsSyn ) -> (PExp L)
happyOut257 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut257 #-}
happyIn258 :: (QName L) -> (HappyAbsSyn )
happyIn258 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn258 #-}
happyOut258 :: (HappyAbsSyn ) -> (QName L)
happyOut258 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut258 #-}
happyIn259 :: (Name L) -> (HappyAbsSyn )
happyIn259 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn259 #-}
happyOut259 :: (HappyAbsSyn ) -> (Name L)
happyOut259 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut259 #-}
happyIn260 :: (Name L) -> (HappyAbsSyn )
happyIn260 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn260 #-}
happyOut260 :: (HappyAbsSyn ) -> (Name L)
happyOut260 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut260 #-}
happyIn261 :: (IPName L) -> (HappyAbsSyn )
happyIn261 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn261 #-}
happyOut261 :: (HappyAbsSyn ) -> (IPName L)
happyOut261 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut261 #-}
happyIn262 :: (QName L) -> (HappyAbsSyn )
happyIn262 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn262 #-}
happyOut262 :: (HappyAbsSyn ) -> (QName L)
happyOut262 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut262 #-}
happyIn263 :: (Name L) -> (HappyAbsSyn )
happyIn263 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn263 #-}
happyOut263 :: (HappyAbsSyn ) -> (Name L)
happyOut263 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut263 #-}
happyIn264 :: (QName L) -> (HappyAbsSyn )
happyIn264 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn264 #-}
happyOut264 :: (HappyAbsSyn ) -> (QName L)
happyOut264 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut264 #-}
happyIn265 :: (Name L) -> (HappyAbsSyn )
happyIn265 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn265 #-}
happyOut265 :: (HappyAbsSyn ) -> (Name L)
happyOut265 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut265 #-}
happyIn266 :: (QName L) -> (HappyAbsSyn )
happyIn266 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn266 #-}
happyOut266 :: (HappyAbsSyn ) -> (QName L)
happyOut266 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut266 #-}
happyIn267 :: (QName L) -> (HappyAbsSyn )
happyIn267 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn267 #-}
happyOut267 :: (HappyAbsSyn ) -> (QName L)
happyOut267 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut267 #-}
happyIn268 :: (Name L) -> (HappyAbsSyn )
happyIn268 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn268 #-}
happyOut268 :: (HappyAbsSyn ) -> (Name L)
happyOut268 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut268 #-}
happyIn269 :: (Name L) -> (HappyAbsSyn )
happyIn269 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn269 #-}
happyOut269 :: (HappyAbsSyn ) -> (Name L)
happyOut269 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut269 #-}
happyIn270 :: (QName L) -> (HappyAbsSyn )
happyIn270 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn270 #-}
happyOut270 :: (HappyAbsSyn ) -> (QName L)
happyOut270 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut270 #-}
happyIn271 :: (Literal L) -> (HappyAbsSyn )
happyIn271 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn271 #-}
happyOut271 :: (HappyAbsSyn ) -> (Literal L)
happyOut271 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut271 #-}
happyIn272 :: (S) -> (HappyAbsSyn )
happyIn272 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn272 #-}
happyOut272 :: (HappyAbsSyn ) -> (S)
happyOut272 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut272 #-}
happyIn273 :: (S) -> (HappyAbsSyn )
happyIn273 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn273 #-}
happyOut273 :: (HappyAbsSyn ) -> (S)
happyOut273 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut273 #-}
happyIn274 :: (Decl L) -> (HappyAbsSyn )
happyIn274 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn274 #-}
happyOut274 :: (HappyAbsSyn ) -> (Decl L)
happyOut274 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut274 #-}
happyIn275 :: (Decl L) -> (HappyAbsSyn )
happyIn275 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn275 #-}
happyOut275 :: (HappyAbsSyn ) -> (Decl L)
happyOut275 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut275 #-}
happyIn276 :: (Pat L) -> (HappyAbsSyn )
happyIn276 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn276 #-}
happyOut276 :: (HappyAbsSyn ) -> (Pat L)
happyOut276 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut276 #-}
happyIn277 :: ([Pat L]) -> (HappyAbsSyn )
happyIn277 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn277 #-}
happyOut277 :: (HappyAbsSyn ) -> ([Pat L])
happyOut277 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut277 #-}
happyIn278 :: (([S], [Name L])) -> (HappyAbsSyn )
happyIn278 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn278 #-}
happyOut278 :: (HappyAbsSyn ) -> (([S], [Name L]))
happyOut278 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut278 #-}
happyIn279 :: (PatternSynDirection L) -> (HappyAbsSyn )
happyIn279 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn279 #-}
happyOut279 :: (HappyAbsSyn ) -> (PatternSynDirection L)
happyOut279 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut279 #-}
happyIn280 :: (Decl L) -> (HappyAbsSyn )
happyIn280 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn280 #-}
happyOut280 :: (HappyAbsSyn ) -> (Decl L)
happyOut280 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut280 #-}
happyIn281 :: ((Maybe [TyVarBind L], [S], Maybe (Context L), Maybe (Context L), Type L )) -> (HappyAbsSyn )
happyIn281 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn281 #-}
happyOut281 :: (HappyAbsSyn ) -> ((Maybe [TyVarBind L], [S], Maybe (Context L), Maybe (Context L), Type L ))
happyOut281 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut281 #-}
happyIn282 :: (Maybe (DerivStrategy L)) -> (HappyAbsSyn )
happyIn282 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn282 #-}
happyOut282 :: (HappyAbsSyn ) -> (Maybe (DerivStrategy L))
happyOut282 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut282 #-}
happyIn283 :: (ModuleName L) -> (HappyAbsSyn )
happyIn283 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn283 #-}
happyOut283 :: (HappyAbsSyn ) -> (ModuleName L)
happyOut283 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut283 #-}
happyIn284 :: (Name L) -> (HappyAbsSyn )
happyIn284 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn284 #-}
happyOut284 :: (HappyAbsSyn ) -> (Name L)
happyOut284 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut284 #-}
happyIn285 :: (QName L) -> (HappyAbsSyn )
happyIn285 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn285 #-}
happyOut285 :: (HappyAbsSyn ) -> (QName L)
happyOut285 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut285 #-}
happyIn286 :: (Name L) -> (HappyAbsSyn )
happyIn286 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn286 #-}
happyOut286 :: (HappyAbsSyn ) -> (Name L)
happyOut286 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut286 #-}
happyIn287 :: (Name L) -> (HappyAbsSyn )
happyIn287 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn287 #-}
happyOut287 :: (HappyAbsSyn ) -> (Name L)
happyOut287 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut287 #-}
happyIn288 :: (QName L) -> (HappyAbsSyn )
happyIn288 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn288 #-}
happyOut288 :: (HappyAbsSyn ) -> (QName L)
happyOut288 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut288 #-}
happyIn289 :: (Name L) -> (HappyAbsSyn )
happyIn289 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn289 #-}
happyOut289 :: (HappyAbsSyn ) -> (Name L)
happyOut289 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut289 #-}
happyIn290 :: (([ImportDecl L],[S],L)) -> (HappyAbsSyn )
happyIn290 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn290 #-}
happyOut290 :: (HappyAbsSyn ) -> (([ImportDecl L],[S],L))
happyOut290 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut290 #-}
happyIn291 :: ((([ModulePragma L], [S], L), Maybe (ModuleName L))) -> (HappyAbsSyn )
happyIn291 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn291 #-}
happyOut291 :: (HappyAbsSyn ) -> ((([ModulePragma L], [S], L), Maybe (ModuleName L)))
happyOut291 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut291 #-}
happyIn292 :: ((([ModulePragma L], [S], L), Maybe (ModuleHead L))) -> (HappyAbsSyn )
happyIn292 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn292 #-}
happyOut292 :: (HappyAbsSyn ) -> ((([ModulePragma L], [S], L), Maybe (ModuleHead L)))
happyOut292 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut292 #-}
happyIn293 :: ((([ModulePragma L], [S], L), Maybe (ModuleHead L), Maybe ([ImportDecl L],[S],L))) -> (HappyAbsSyn )
happyIn293 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn293 #-}
happyOut293 :: (HappyAbsSyn ) -> ((([ModulePragma L], [S], L), Maybe (ModuleHead L), Maybe ([ImportDecl L],[S],L)))
happyOut293 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut293 #-}
happyInTok :: (Loc Token) -> (HappyAbsSyn )
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn ) -> (Loc Token)
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyExpList :: HappyAddr
happyExpList = HappyA# "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x81\xfc\xae\x81\xff\x5f\x68\x03\x23\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x06\xf9\x5d\x03\xff\xbf\xd0\x06\x46\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x0a\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xc1\xff\x05\x25\x10\x36\xc8\xef\x1a\xf8\xff\x85\x36\x30\x86\x0d\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\xb0\x01\xfc\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x17\x94\x00\x18\x20\xbf\x6b\xe0\xff\x07\x58\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xfd\xff\x07\xf5\x32\x76\xc8\xef\x1a\xf8\xff\x85\x36\x30\x82\x0d\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\xfb\xff\x1b\xea\x65\xec\x90\xdf\x35\xf0\xff\x0b\x6d\x60\x04\x1b\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\xf7\xff\x17\x9c\x4b\xd8\x21\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\xef\xff\x2f\x28\x97\xb0\x43\x7e\xd7\xc0\xff\x2f\xb4\x81\x11\x6c\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc0\x04\xf9\x5d\x03\xff\xbf\xc0\x02\x00\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x90\x40\x41\x09\x00\x09\x30\x28\x00\xde\x7f\x00\x04\x00\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xe0\xff\x82\x12\x00\x03\xe4\x77\x0d\xfc\xff\x00\x0b\x00\xc0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xc1\xff\x05\x25\x00\x06\xc8\xef\x1a\xf8\xff\x01\x16\x00\x80\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x83\xff\x0b\x4a\x00\x0c\x90\xdf\x35\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x17\x94\x40\x58\x20\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x81\xfc\xae\x81\xff\x5f\x68\x03\x23\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x06\x46\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xf0\x7f\x41\x09\x84\x05\xf2\xbb\x06\xfe\x7f\xa1\x0d\x8c\x60\x03\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x0a\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x03\x00\x02\x40\x00\x00\x00\x00\x00\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x06\x00\x14\x04\x00\x00\x00\x00\x00\xe0\xfd\x07\x40\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x28\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xff\xff\xff\xff\xff\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x06\x46\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x06\x46\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x97\x94\x40\x58\x20\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc0\x04\xf9\x5d\x03\xff\x3f\xc0\x02\x00\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x6d\x02\x05\x65\x02\x7c\xc0\xa0\x00\x78\xff\x01\x10\x00\x80\x0c\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0c\x12\x28\x28\x01\x20\x01\x06\x05\xc0\xfb\x0f\x80\x00\x00\x64\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x07\x09\x14\x94\x00\x90\x00\x83\x02\xe0\xfd\x07\x50\x00\x00\x32\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\xf7\x09\x1c\xd4\x0a\xd2\x01\x83\x02\xe0\xfd\x07\x50\x00\x00\x32\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0f\x12\x68\xa8\x01\x20\x01\x06\x05\xc0\xfb\x0f\xa0\x00\x00\x64\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1e\x24\x50\x70\x02\x40\x02\x0c\x0a\x80\xf7\x1f\x40\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3c\x48\xa0\xa0\x04\x80\x04\x18\x14\x00\xef\x3f\x00\x02\x00\x90\x01\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x17\x94\x40\x58\x20\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x00\x28\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x02\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x83\xff\x2b\x4a\x20\x6c\x90\xdf\x35\xf8\xff\xfb\xed\x7e\x25\xff\xfd\x30\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x20\x00\x10\x00\x00\x00\x00\x00\xef\x3f\x00\x02\x00\x90\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\xd3\x04\x0e\x6a\x04\x48\x80\x41\x01\xf0\xfe\x03\x28\x00\x00\x19\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0f\x12\x28\x38\x01\x20\x01\x06\x05\xc0\xfb\x0f\xa0\x00\x00\x64\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x9b\x40\x41\x99\x00\x1d\x30\x28\x00\xde\x7f\x00\x04\x00\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x08\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x18\x24\x50\x50\x02\x40\x02\x0c\x0a\x80\xf7\x1f\x00\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x08\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x06\x00\x00\x00\x00\x00\x00\x00\x00\xe0\xfd\x07\x40\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0f\x12\x28\x28\x01\x20\x01\x06\x05\xc0\xfb\x0f\xa0\x00\x00\x64\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x14\x80\x82\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x51\x02\x61\x83\xfc\xae\x81\xff\x5f\x68\x03\x63\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa2\x04\xc2\x06\xf9\x5d\x03\xff\xbf\xd0\x06\xc6\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xc1\xff\x05\x25\x00\x06\xc8\xef\x1a\xf8\xff\x01\x16\x00\x80\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x36\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x04\x20\x05\xe1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x80\x00\xa0\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xe0\xff\x82\x12\x08\x1b\xe4\x77\x0d\xfe\xff\x7e\x9b\x5f\xc9\x7f\x3f\x0c\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x00\x00\x00\x0b\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xc1\xff\x05\x25\x00\x06\xc8\xef\x1a\xf8\xff\x01\x16\x00\x80\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x68\x82\xfc\xae\x81\xff\x1f\x60\x01\x00\xd8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x21\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x06\x46\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x03\x00\x00\x40\x00\x00\x00\x00\x00\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x08\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xfd\xff\x05\xf5\x12\x76\xc8\xef\x1a\xf8\xff\x85\x36\x30\x82\x0d\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\xfb\xff\x0b\xca\x65\xec\x90\xdf\x35\xf0\xff\x0b\x6d\x60\x04\x1b\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x40\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xfe\xff\x82\x7a\x09\x3b\xe4\x77\x0d\xfc\xff\x42\x1b\x18\xc1\x06\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xe0\xff\x82\x12\x00\x03\xe4\x77\x0d\xfc\xff\x00\x0b\x00\xc0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xc1\xff\x05\x25\x00\x06\xc8\xef\x1a\xf8\xff\x01\x16\x00\x80\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x83\xff\x0b\x4a\x00\x0c\x90\xdf\x35\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x17\x94\x40\x58\x20\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\x00\x08\x02\x09\x00\x00\x00\x00\xc0\xff\x0f\xb0\x00\x00\x6c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xe0\xff\x82\x12\x08\x0b\xe4\x77\x0d\xfc\xff\x42\x1b\x18\xc1\x06\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x03\x00\x00\x40\x00\x00\x00\x00\x00\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x07\x09\x14\x94\x00\x90\x00\x83\x02\xe0\xfd\x07\x50\x00\x00\x32\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\xfe\x2f\x28\x81\xb0\x40\x7e\xd7\xc0\xff\x2f\xb4\x81\x11\x6c\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x81\xfc\xae\x81\xff\x5f\x68\x03\x23\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x06\x46\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xf0\x7f\x41\x09\x84\x05\xf2\xbb\x06\xfe\x7f\xa1\x0d\x8c\x60\x03\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x00\x00\x01\x00\x00\x00\x00\x00\x00\xf8\xff\x01\x16\x40\x90\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x60\x80\xfc\xae\x81\xff\x1f\x60\x01\x00\xd8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x02\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\xfe\x2f\x28\x01\x30\x40\x7e\xd7\xc0\xff\x0f\xb0\x00\x00\x6c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x01\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\xef\xff\x2f\xa8\x97\xb0\x43\x7e\xd7\xc0\xff\x2f\xb4\x81\x11\x6c\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\xfe\x2f\x28\x81\xb0\x40\x7e\xd7\xc0\xff\x2f\xb4\x81\x11\x6c\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x83\xfc\xae\x81\xff\x5f\x68\x03\x23\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\xf7\xff\x17\x94\x4b\xd8\x21\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xdf\xff\x5f\x50\x2e\x61\x87\xfc\xae\x81\xff\x5f\x68\x03\x23\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x06\x46\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xf0\x7f\x41\x09\x84\x0d\xf2\xbb\x06\xfe\x7f\xa1\x0d\x8c\x62\x03\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\xf7\xff\x17\x94\x4b\xd8\x21\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\xfe\x2f\x28\x81\xb0\x40\x7e\xd7\xc0\xff\x2f\xb4\x81\x11\x6c\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x83\xfc\xae\x81\xff\x5f\x68\x03\xa3\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x83\xff\x0b\x4a\x20\x2c\x90\xdf\x35\xf0\xff\x0b\x6d\x60\x04\x1b\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x17\x94\x40\x58\x20\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x83\xfc\xae\x81\xff\x5f\x68\x03\x23\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xe0\xff\x82\x12\x08\x0b\xe4\x77\x0d\xfc\xff\x42\x1b\x18\xc1\x06\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x41\x02\x05\x25\x00\x24\xc0\xa0\x00\x78\xff\x01\x14\x08\x80\x0c\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x68\x03\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\xfe\x2f\x28\x01\x30\x40\x7e\xd7\xc0\xff\x0f\xb0\x00\x00\x6c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3c\x48\xa0\xa0\x04\x80\x04\x18\x14\x00\xef\x3f\x80\x02\x00\x90\x01\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x90\x40\x41\x09\x00\x09\x30\x28\x00\xde\x7f\x80\x04\x02\x60\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x80\x00\x00\x00\x00\x00\x00\x00\xfc\xff\x00\x0b\x00\xc0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x10\x00\x20\x00\x00\x00\x00\x00\x00\x00\xff\x3f\xc0\x02\x00\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\x40\x00\x00\x00\x00\x00\x00\x00\xfe\x7f\x80\x05\x00\x60\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x80\x00\x00\x00\x00\x00\x00\x00\xfc\xff\x00\x0b\x20\xc8\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x01\x00\x00\x00\x00\x00\x00\xf8\xff\x01\x16\x00\x80\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x28\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xff\xff\xff\xff\xff\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x7f\xf8\xbf\xa0\x04\xc0\x00\xf9\x5d\x83\xff\xff\xff\xff\xff\xbf\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x81\xfc\xae\x81\xff\x5f\x68\x03\x23\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\xfe\x2f\x28\x81\xb0\x40\x7e\xd7\xc0\xff\x2f\xb4\x81\x11\x6c\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x06\x46\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xc1\xff\x15\x25\x10\x36\xc8\xef\x1a\xf8\xff\x85\x36\x30\x86\x0d\x1c\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x17\x94\x40\x58\x20\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\xfe\x2f\x28\x81\xb0\x40\x7e\xd7\xc0\xff\x2f\xb4\x81\x11\x6c\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x03\x00\x02\x42\x00\x80\x00\x00\x00\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1e\x24\x50\x50\x02\x40\x02\x0c\x0a\x80\xf7\x1f\x40\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x90\x40\x41\x09\x00\x09\x30\x28\x00\xde\x7f\x00\x05\x00\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x0a\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x41\x02\x05\x25\x00\x24\xc0\xa0\x00\x78\xff\x01\x14\x00\x80\x0c\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xf7\x1f\x00\x01\x00\xc8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3c\x48\xa0\xa0\x04\x80\x04\x18\x14\x00\xef\x3f\x80\x02\x00\x90\x01\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x51\x02\x61\x83\xfc\xae\x81\xff\x5f\x68\x71\x02\xf8\x0f\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x7f\xf8\xbf\xa0\x04\xc0\x00\xf9\x5d\x83\xff\xff\xff\xff\xff\xbf\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x00\xd0\x06\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x06\xf9\x5d\x83\xff\xbf\xdf\xee\x57\xf2\xdf\x0f\x03\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x06\x00\x04\x84\x00\x02\x01\x00\x00\xe0\xff\x07\x58\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x29\x00\x03\x21\x02\x40\x00\x00\x00\xf8\xff\x01\x16\x00\x80\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x03\x00\x02\x42\x00\x80\x00\x00\x00\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x57\x94\x40\xd8\x20\xbf\x6b\xe0\xff\x17\xda\xc0\x18\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xf0\x7f\x41\x09\x84\x05\xf2\xbb\x06\xfe\x7f\xa1\x0d\x8c\x60\x03\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\xfe\x2f\x28\x81\xb0\x41\x7e\xd7\xc0\xff\x2f\xb4\x81\x11\x6c\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x08\x00\x02\x00\x01\xe0\x00\x00\x00\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\x00\x08\x00\x01\x00\x00\x00\x00\xc0\xff\x0f\xb0\x00\x00\x6c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x02\x00\x20\x00\x04\x00\x00\x00\x00\x00\xff\x3f\xc0\x02\x00\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x90\x40\x41\x09\x00\x09\x30\x28\x00\xde\x7f\x00\x05\x00\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x80\x00\x10\x00\x00\x00\x00\x00\xfc\xff\x00\x0b\x00\xc0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x01\x20\x00\x00\x00\x00\x00\xf8\xff\x01\x16\x00\x80\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x40\x20\x00\x00\x00\x00\x00\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x90\x40\x41\x09\x00\x09\x30\x28\x00\xde\x7f\x00\x04\x00\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x08\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x83\x04\x0a\x4a\x00\x48\x80\x41\x01\xf0\xfe\x03\x28\x00\x00\x19\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1e\x24\x50\x50\x02\x40\x02\x0c\x0a\x80\xf7\x1f\x40\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3c\x48\xa0\xa0\x04\x80\x04\x18\x14\x00\xef\x3f\x80\x02\x00\x90\x01\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x7f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\x00\x08\x00\x01\x00\x00\x00\x00\xc0\xff\x0f\xb0\x00\x00\x6c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1e\x24\x50\x50\x02\x40\x02\x0c\x0a\x80\xf7\x1f\x40\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x90\x40\x41\x09\x00\x09\x30\x28\x00\xde\x7f\x00\x05\x00\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xe0\xff\x82\x12\x08\x1b\xe4\x77\x0d\xfe\xff\x7e\x9b\x5f\xc9\x7f\x3f\x0c\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x03\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\xfe\xaf\x28\x81\xb0\x41\x7e\xd7\xc0\xff\x2f\xb4\x81\x11\x6c\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x81\xfc\xae\x81\xff\x5f\xe8\x03\x23\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x81\xfc\xae\x81\xff\x5f\x68\x03\x23\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x02\x00\x20\x00\x24\x00\x00\x00\x00\x00\xff\x3f\xc0\x02\x00\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x17\x94\x00\x18\x20\xbf\x6b\xe0\xff\x07\x58\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\xfe\x2f\x28\x81\xb0\x40\x7e\xd7\xc0\xff\x2f\xb4\x81\x11\x6c\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x83\xfc\xae\x81\xff\x5f\x68\x03\xa3\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x06\x46\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xc1\xff\x05\x25\x10\x36\xc8\xef\x1a\xf8\xff\x85\x36\x30\x8a\x0d\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xe0\xff\x82\x12\x08\x0b\xe4\x77\x0d\xfc\xff\x42\x1b\x18\xc1\x06\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xc1\xff\x05\x25\x10\x36\xc8\xef\x1a\xf8\xff\x85\x36\x30\x82\x0d\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\xff\x01\x16\x00\x80\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x65\x00\x40\x40\x08\x00\x10\x00\x00\x00\xfe\x7f\x80\x05\x00\x60\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xf0\x7f\x41\x09\x84\x05\xf2\xbb\x06\xfe\x7f\xa1\x0d\x8c\x60\x03\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xe0\xff\x82\x12\x08\x1b\xe4\x77\x0d\xfc\xff\x42\x1b\x18\xc1\x06\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x08\x04\x00\x00\x00\x00\x00\x00\x20\xfc\x07\x40\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x01\x00\x00\x14\x80\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x0a\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xc1\xff\x05\x25\x10\x36\xc8\xef\x1a\xf8\xff\x85\x36\x30\x82\x0d\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x83\xff\x0b\x4a\x20\x6c\x90\xdf\x35\xf0\xff\x0b\x6d\x60\x04\x1b\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\xff\x07\x58\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0f\x12\x28\x28\x01\x20\x01\x06\x05\xc0\xfb\x0f\xa0\x00\x00\x64\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xff\x1f\x60\x01\x00\xd8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x7f\x80\x05\x00\x60\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x02\x00\x04\x00\x00\x00\x00\x00\x00\xe0\xff\x07\x58\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x08\x00\x10\x00\x00\x00\x00\x00\x00\x80\xff\x1f\x60\x01\x00\xd8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x02\x00\x00\x00\x00\x00\x00\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x04\x00\x00\x00\x00\x00\x00\xe0\xff\x07\x58\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\xa0\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xc1\xff\x05\x25\x00\x06\xc8\xef\x1a\xf8\xff\x01\x16\x00\x80\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x32\x00\x20\x20\x04\x00\x08\x00\x00\x00\xff\x3f\xc0\x02\x00\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\x00\x80\x80\x10\x00\x20\x00\x00\x00\xfc\xff\x00\x0b\x00\xc0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x17\x94\x40\x58\x20\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x02\x04\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xf0\x7f\x41\x09\x84\x0d\xf2\xbb\x06\xfe\x7f\xa1\xc5\x09\xe0\x3f\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x19\x00\x10\x00\x03\x00\x00\x00\x00\x80\xff\x1f\x60\x01\x04\xf9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\xa0\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x03\x00\x02\x40\x00\x00\x00\x00\x00\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x32\x00\x20\x20\x04\x00\x08\x00\x00\x00\xff\x3f\xc0\x02\x00\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x17\x94\x40\x58\x20\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\xb0\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x06\x46\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x40\x00\x00\x00\x00\x00\x00\x00\xfe\x7f\x80\x05\x00\x60\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x0a\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x07\x09\x14\x94\x00\x90\x00\x83\x02\xe0\xfd\x07\x50\x00\x00\x32\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0f\x12\x28\x28\x01\x20\x01\x06\x05\xc0\xfb\x0f\x80\x00\x00\x64\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x0c\x00\x08\x08\x01\x00\x02\x00\x00\xc0\xff\x0f\xb0\x00\x00\x6c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x10\x00\x00\x00\x00\x00\x00\x80\xf7\x1f\x00\x01\x00\xc8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3c\x48\xa0\xa0\x04\x80\x04\x18\x14\x00\xef\x3f\x80\x02\x00\x90\x01\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x83\x04\x0a\x4a\x00\x48\x80\x41\x01\xf0\xfe\x03\x28\x00\x00\x19\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x19\x00\x10\x10\x02\x00\x04\x00\x00\x80\xff\x1f\x60\x01\x00\xd8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\xef\x3f\x00\x02\x00\x90\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\xe1\x3f\x00\x02\x00\x90\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x20\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x81\x00\x00\x00\x00\x00\x00\x00\x84\xff\x00\x08\x00\x40\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x04\x00\x00\x00\x00\x00\x00\xe0\xff\x07\x58\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0f\x12\x28\x28\x01\x20\x01\x06\x05\xc0\xfb\x0f\xa0\x00\x00\x64\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x90\x40\x41\x09\x00\x09\x30\x28\x00\xde\x7f\x00\x04\x00\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x00\x00\x00\x06\x80\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x83\xff\x0b\x4a\x20\x2c\x90\xdf\x35\xf0\xff\x0b\x6d\x60\x04\x1b\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x17\x94\x40\xd8\x20\xbf\x6b\xe0\xff\x17\xda\xc0\x08\x36\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x06\x46\xb0\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xf0\x7f\x41\x09\x84\x05\xf2\xbb\x06\xfe\x7f\xa1\x0d\x8c\x60\x03\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xe0\xff\x82\x12\x08\x0b\xe4\x77\x0d\xfc\xff\x42\x1b\x18\xc1\x06\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x10\x00\x08\x00\x00\x00\x00\x80\xf7\x1f\x00\x01\x00\xc8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x90\x40\x41\x09\x00\x0b\x30\x28\x00\xde\x7f\x00\x04\x00\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x08\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\xde\x27\x70\x50\x2b\x48\x07\x0c\x0a\x80\xf7\x1f\x40\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x80\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x83\xff\x0b\x4a\x20\x2c\x90\xdf\x35\xf0\xff\x0b\x6d\x60\x04\x1b\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x90\x40\x41\x09\x00\x09\x30\x28\x00\xde\x7f\x00\x04\x00\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\xff\x01\x10\x00\x80\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x08\x00\x04\x00\x00\x00\x00\xc0\xfb\x0f\x80\x00\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3c\x48\xa0\xa0\x04\x80\x04\x18\x14\x00\xef\x3f\x00\x02\x00\x90\x01\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xff\x00\x0b\x00\xc0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x40\x00\x00\x00\x00\x00\x00\x00\xfe\x7f\x80\x05\x00\x60\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\xff\x01\x16\x00\x80\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x81\xfc\xae\x81\xff\x5f\x68\x03\x23\xd8\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x80\x01\x80\x00\x00\x00\x00\x00\xfc\xff\x00\x0b\x00\xc0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x03\x00\x02\x40\x00\x00\x00\x00\x00\xf0\xff\x03\x2c\x80\x20\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x28\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xff\xff\xff\xff\xff\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\x00\x80\x80\x10\x00\x20\x00\x00\x00\xfc\xff\x00\x0b\x00\xc0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x0a\x00\x00\x00\x00\x00\x00\x00\x00\xf0\xff\xff\xff\xff\xff\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x0f\xfe\x2f\x28\x81\xb0\x40\x7e\xd7\xc0\xff\x2f\xb4\x81\x11\x6c\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x41\x02\x05\x25\x00\x24\xc0\xa0\x00\x78\xff\x01\x14\x00\x80\x0c\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1e\x24\x50\x50\x02\x40\x02\x0c\x0a\x80\xf7\x1f\x40\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x57\x94\x40\xd8\x20\xbf\x6b\xe0\xff\x57\x5a\x80\x42\xf6\x03\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xef\x3f\x00\x02\x00\x90\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xc1\xff\x15\x25\x10\x36\xc8\xef\x1a\xf8\xff\xb5\x16\x27\x90\xff\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x18\x24\x50\x50\x02\x40\x02\x0c\x0a\x80\xf7\x1f\x00\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x82\x40\x00\x00\x00\x00\x00\xf0\xff\x03\x2c\x00\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x06\x09\x14\x94\x00\x90\x00\x83\x02\xe0\xfd\x07\x40\x00\x00\x32\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x18\x24\x50\x50\x02\x40\x02\x0c\x0a\x80\xf7\x1f\x00\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x80\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1e\x24\x70\x50\x02\x40\x02\x0c\x0a\x80\xf7\x1f\x40\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xf0\x7f\x41\x09\x84\x05\xf2\xbb\x06\xfe\x7f\xa1\x0d\x8c\x60\x03\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x08\x00\x10\x00\x01\x00\x00\x00\x00\x80\xff\x1f\x60\x01\x00\xf9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x08\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3f\xf8\xbf\xa0\x04\xc2\x02\xf9\x5d\x03\xff\xbf\xd0\x02\x04\xb0\x1f\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x90\x40\x41\x09\x00\x09\x30\x28\x00\xde\x7f\x80\x04\x02\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x07\x09\x14\x94\x00\x90\x00\x83\x02\xe0\xfd\x07\x50\x00\x00\x32\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x06\x09\x14\x94\x00\x90\x00\x83\x02\xe0\xfd\x07\x40\x00\x00\x32\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1e\x24\x50\x50\x02\x40\x02\x0c\x0a\x80\xf7\x1f\x40\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3c\x48\xa0\xa0\x04\x80\x04\x18\x14\x00\xef\x3f\x80\x02\x00\x90\x01\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x7f\x00\x04\x00\x20\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xe0\xff\x8a\x12\x08\x1b\xe4\x77\x0d\xfc\xff\x42\x8b\x13\xc0\x7f\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x1e\x24\x50\x50\x02\x40\x02\x0c\x0a\x80\xf7\x1f\x40\x01\x00\xc8\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x02\x00\x04\x00\x04\x00\x00\x00\x00\xe0\xff\x07\x58\x00\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xf0\x7f\x41\x09\x84\x05\xf2\xbb\x06\xfe\x7f\xa1\x0d\x8c\x60\x03\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xfb\x0f\x80\x00\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xff\x17\x94\x40\xd8\x20\xbf\x6b\xe0\xff\x57\x5a\x80\x42\xf6\x03\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x90\x40\x41\x09\x00\x09\x30\x28\x00\xde\x7f\x00\x04\x00\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x0a\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x00\x00\xa0\x0d\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x07\x09\x14\x94\x00\x90\x00\x83\x02\xe0\xfd\x07\x40\x00\x00\x32\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x1f\xfc\x5f\x50\x02\x61\x83\xfc\xae\x81\xff\x5f\x6b\x71\x02\xf9\x0f\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x80\x00\x10\x00\x00\x00\x00\x00\xfc\xff\x00\x0b\x00\xc0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x41\x02\x05\x25\x00\x24\xc0\xa0\x00\x78\xff\x01\x14\x00\x80\x0c\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x83\x04\x4a\x4a\x00\x48\x80\x41\x01\xf0\xfe\x03\x28\x00\x00\x19\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x08\x00\x00\x00\x00\x00\x00\xc0\xff\x0f\xb0\x00\x00\x6c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x80\x01\x80\x00\x00\x00\x00\x00\xfc\xff\x00\x0b\x00\xc0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x01\x00\x02\x00\x00\x00\x00\x00\x00\xf0\xff\x03\x2c\x00\x20\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x02\x00\x20\x00\x04\x00\x00\x00\x00\x00\xff\x3f\xc0\x02\x00\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x07\x09\x14\x94\x00\x90\x00\x83\x02\xe0\xfd\x07\x50\x00\x00\x32\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x65\x00\x40\x40\x08\x00\x10\x00\x00\x00\xfe\x7f\x80\x05\x00\x60\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x0a\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0f\x12\x28\x28\x01\x20\x01\x06\x05\xc0\xfb\x0f\xa0\x00\x00\x64\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x3c\x48\xa0\xa0\x04\x80\x04\x18\x14\x00\xef\x3f\x80\x02\x00\x90\x01\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x90\x40\x41\x09\x00\x09\x30\x28\x00\xde\x7f\x00\x05\x00\x20\x03\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x0c\x00\x08\x08\x01\x00\x02\x00\x00\xc0\xff\x0f\xb0\x00\x00\x6c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x10\x00\x00\x00\x00\x00\x00\x80\xf7\x1f\x00\x01\x00\xc8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x00\x00\x01\x00\x00\x00\x00\x00\x00\xf8\xff\x01\x16\x00\x80\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x20\x81\x82\x12\x00\x12\x60\x50\x00\xbc\xff\x00\x0a\x00\x40\x06\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

{-# NOINLINE happyExpListPerState #-}
happyExpListPerState st =
    token_strs_expected
  where token_strs = ["error","%dummy","%start_mparseModule","%start_mparseExp","%start_mparsePat","%start_mparseDeclAux","%start_mparseType","%start_mparseStmt","%start_mparseImportDecl","%start_ngparseModulePragmas","%start_ngparseModuleHeadAndImports","%start_ngparsePragmasAndModuleHead","%start_ngparsePragmasAndModuleName","modules","modules1","page","topxml","toppragmas","toppragmasaux","toppragma","conids","module","optmodulehead","maybemodwarning","body","bodyaux","semis","optsemis","maybeexports","exports","optcomma","exportlist","export","export_names","cname_w_wildcard","qcname","impdecls","impdecl","optsrc","optsafe","optqualified","maybepkg","maybeas","maybeimpspec","impspec","opthiding","importlist","importspec","import_names","cname","fixdecl","prec","infix","ops","opt_injectivity_info","injectivity_info","inj_varids","topdecls","topdecls1","topdecl","opt_datafam_kind_sig","opt_tyfam_kind_sig","opt_at_kind_inj_sig","opt_at_kind_inj_sig2","role_annot","roles","role","optoverlap","where_type_family","ty_fam_inst_eqn_list","ty_fam_inst_eqns","ty_fam_inst_eqn","data_or_newtype","typelist","decls","decls1","decl","decllist","signdecl","signdecl0","specinldecl","sigtypes","sigtype","name_boolformula","name_boolformula1","name_boolformula_and","name_boolformula_atom","binds","vars","callconv","safety","fspec","rules","rule","activation","ruleforall","rulevars","rulevar","warndeprs","warndepr","namevars","namevar","annotation","truedtype","dtype","truetype","type","truebtype","trueatype","btype","atype","ptype","strict_mark","strictness","unpackedness","gtycon","otycon","qtyconop","truectype","ctype","context","types","types1","types_bars2","ktyvars","ktyvar","tyvars","tyvars1","fds","fds1","fd","gadtlist","gadtconstrs1","gadtconstrs","gadtconstr","constrs0","constrs","constr","forall","constr1","scontype","fielddecls","fielddecl","maybe_derivings","derivings","deriving","dclasses","qtycls1","kind","kind1","bkind","akind","pkind","comma_kinds1","optkind","opt_tyconsig","optcbody","cldecls","cldecls1","cldecl","opt_family","atdecl","optvaldefs","valdefs","valdefs1","insvaldef","atinst","valdef","optwhere","optsig","rhs","gdrhs","gdrh","trueexp","exp","exp0","exp0a","exp0b","exp10a","optlayoutsemi","opthsxsemi","exp10b","exppragma","fexp","apats","apat","aexp","aexp1","aexp2","tup_exprs","commas_tup_tail","tup_tail","commas","bars","bars0","texp","sexps","erpats","xml","children","child","name","xmlname","xmlkeyword","attrs","attr","mattr","list","lexps","pqualstmts","qualstmts","qualstmt","transformqual","quals","qual","parr","altslist","alts","alts1","alt","ralt","gdpats","gdpat","pat","ifaltslist","ifalts","ifalts1","stmtlist","stmts","stmts1","stmt","fbinds","fbind","ipbinds","ipbinds1","ipbind","gcon","gcon_nolist","sysdcon_nolist","sysdcon","var","var_no_safety","qvar","ivar","con","con_list","qcon","varop","qvarop","qvaropm","conop","qconop","op","qop","qopm","gconsym","overloaded_label","qvarid","varid_no_safety","varid","ivarid","qconid","conid","qconsym","consym","qvarsym","qvarsymm","varsym","varsymm","qvarsym1","literal","open","close","pat_syn","pattern_synonym_decl","pattern_synonym_lhs","vars0","commavars","where_decls","pattern_synonym_sig","pstype","deriv_strategy","modid","tyconorcls","qtyconorcls","tyvar","tyvarid","qtyvarop","tyvarsym","impdeclsblock","moduletopname","moduletophead","moduletopimps","VARID","LABELVARID","QVARID","IDUPID","ILINID","CONID","QCONID","DVARID","VARSYM","CONSYM","QVARSYM","QCONSYM","INT","RATIONAL","CHAR","STRING","PRIMINT","PRIMWORD","PRIMFLOAT","PRIMDOUBLE","PRIMCHAR","PRIMSTRING","'('","')'","'(#'","'#)'","';'","'{'","'}'","vccurly","'['","']'","'[:'","':]'","','","'_'","'`'","'.'","'..'","':'","'::'","'='","'\\\\'","'|'","'<-'","'->'","'@'","TYPEAPP","'~'","'=>'","'-'","'!'","'*'","'-<'","'>-'","'-<<'","'>>-'","'(|'","'|)'","'@:'","IDSPLICE","'$('","'[|'","'[p|'","'[t|'","'[d|'","'|]'","VARQUOTE","TYPQUOTE","QUASIQUOTE","PCDATA","'<'","'</'","'<%'","'<%>'","'>'","'/>'","'%>'","'<['","']>'","'foreign'","'export'","'safe'","'unsafe'","'threadsafe'","'interruptible'","'stdcall'","'ccall'","'cplusplus'","'dotnet'","'jvm'","'js'","'javascript'","'capi'","'as'","'by'","'case'","'class'","'data'","'default'","'deriving'","'do'","'else'","'family'","'forall'","'group'","'hiding'","'if'","'import'","'in'","'infix'","'infixl'","'infixr'","'instance'","'let'","'mdo'","'module'","'newtype'","'of'","'proc'","'rec'","'then'","'type'","'using'","'where'","'qualified'","'role'","'pattern'","'stock'","'anyclass'","'{-# INLINE'","'{-# INLINE CONLIKE'","'{-# SPECIALISE'","'{-# SPECIALISE INLINE'","'{-# SOURCE'","'{-# RULES'","'{-# CORE'","'{-# SCC'","'{-# GENERATED'","'{-# DEPRECATED'","'{-# WARNING'","'{-# UNPACK'","'{-# NOUNPACK'","'{-# OPTIONS'","'{-# LANGUAGE'","'{-# ANN'","'{-# MINIMAL'","'{-# NO_OVERLAP'","'{-# OVERLAP'","'{-# OVERLAPS'","'{-# OVERLAPPING'","'{-# OVERLAPPABLE'","'{-# INCOHERENT'","'{-# COMPLETE'","'#-}'","%eof"]
        bit_start = st * 449
        bit_end = (st + 1) * 449
        read_bit = readArrayBit happyExpList
        bits = map read_bit [bit_start..bit_end - 1]
        bits_indexed = zip bits [0..448]
        token_strs_expected = concatMap f bits_indexed
        f (False, _) = []
        f (True, nr) = [token_strs !! nr]

happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\x00\x00\x75\x29\xa8\x25\x42\x00\x3f\x18\x7c\x23\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3e\x00\x60\x03\x67\x00\x50\x01\x6a\x01\x0b\x02\xc1\x01\x4e\x02\x4e\x02\xda\xff\xdc\x01\x00\x00\x45\x02\x00\x00\x00\x00\x48\x1e\x00\x00\x00\x00\x00\x00\x5a\x2c\x00\x00\x7d\x02\x00\x00\x00\x00\x97\x02\x38\x02\x00\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x1e\x24\x1f\xc5\x20\x66\x22\x00\x00\xf8\x2a\x3e\x1d\x5a\x2c\x5a\x2c\x5a\x2c\x75\x29\x00\x00\x75\x29\x75\x29\x75\x29\x3f\x18\x00\x00\x59\x2e\xd4\x31\x00\x00\x7b\x34\x75\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x29\x03\x03\x00\x00\x00\x00\x00\x00\x33\x26\x0b\x03\x35\x03\xe4\x2b\x35\x03\x00\x00\x00\x00\x00\x00\x00\x00\x59\x03\x5e\x03\x62\x03\x00\x00\x00\x00\xdb\x13\x00\x00\x00\x00\x3e\x1d\x00\x00\xc8\x01\x00\x00\x00\x00\xe0\x02\x00\x00\x3f\x18\x57\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x13\x2d\x15\x99\x15\x06\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x75\x29\x39\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbc\x02\xf3\x02\xf5\x02\x00\x00\x00\x00\x00\x00\xf5\x02\x81\x03\x0e\x03\x00\x00\x0e\x03\x1f\x00\x00\x00\x00\x00\xa0\x03\x7b\x34\x0f\x03\x30\x01\x00\x00\x5c\x03\x00\x00\x00\x00\xb0\x03\x00\x00\xec\x0d\x5a\x00\x00\x00\x00\x00\x0a\x33\x00\x00\x00\x00\x00\x00\x4e\x14\x69\x01\x05\x16\xbe\x03\xbb\x03\xba\x14\xc2\x03\x00\x00\xc5\x03\xc9\x03\x00\x00\xe1\x03\x9a\x01\x59\x01\xca\x01\x00\x00\x00\x00\x24\x02\x47\x04\xaa\x00\x71\x04\x00\x00\x00\x00\x75\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x04\x00\x00\x7d\x04\x00\x00\x3e\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x3e\x1d\x00\x00\x00\x00\x3e\x1d\x00\x00\x00\x00\x40\x33\x3f\x18\x00\x00\x00\x00\x00\x00\xb2\x08\x99\x04\x02\x04\x11\x04\x00\x00\xf1\x22\xf1\x22\xb8\x04\x00\x00\x5a\x2c\x00\x00\x7b\x04\xdd\x04\x00\x00\x00\x00\x00\x00\x00\x00\x8f\x04\x3a\x00\xbd\x04\x00\x00\xec\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x19\xfe\x01\x21\x05\x00\x00\x00\x00\x78\x0e\x20\x0f\x0a\x05\x1a\x05\x1d\x05\x3b\x05\x6d\x05\x62\x05\x43\x01\x00\x00\x5a\x2c\x00\x00\x00\x00\x00\x00\x6e\x2b\x00\x00\x78\x05\x79\x05\x0e\x01\x8e\x05\x98\x05\x00\x00\x00\x00\x75\x29\x00\x00\x00\x00\x00\x00\x61\x2f\x00\x00\x41\x03\x97\x05\x9e\x05\x00\x00\xac\x05\xaf\x1f\x50\x21\xd1\x02\x00\x00\x00\x00\xdd\x02\xc0\x05\x3a\x20\xa6\x01\xc7\x05\xd9\x05\xdd\x05\xe0\x05\xe7\x05\x00\x00\x5a\x2c\x5a\x2c\x5a\x2c\x75\x29\x74\x2e\x00\x00\x00\x00\x00\x00\x75\x29\x00\x00\x61\x2f\x3f\x18\x75\x29\x75\x29\x75\x29\x75\x29\xb0\x05\x74\x05\x33\x00\x00\x00\x30\x01\x5a\x00\x00\x00\x00\x00\x00\x00\x7c\x2f\x00\x00\xb7\x05\x00\x00\x5a\x2c\x86\x05\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x02\x5a\x2c\x0d\x06\x1a\x06\x11\x01\x0b\x00\x20\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x06\x3c\x06\x00\x00\x00\x00\x30\x06\x3a\x06\x3d\x06\x22\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x21\x45\x06\x00\x00\x00\x00\x54\x06\x00\x00\x00\x00\x00\x00\x75\x29\xbe\x26\x00\x00\x58\x06\x00\x00\x00\x00\x00\x00\x66\x22\x00\x00\x66\x22\x75\x29\x07\x24\x63\x06\x00\x00\x00\x00\x66\x22\x75\x29\x07\x24\x00\x00\x00\x00\x72\x06\x00\x00\x75\x29\x75\x29\x00\x00\x49\x27\x00\x00\x00\x00\x75\x29\x00\x00\x00\x00\x00\x00\x9f\x06\x5a\x00\x00\x00\x00\x00\x00\x00\x71\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x14\x00\x00\x00\x00\x00\x00\x5a\x2c\x38\x00\x3f\x18\x2e\x06\x9d\x06\x9f\x02\x00\x00\x00\x00\x00\x00\x8f\x06\x00\x00\xa5\x18\x4d\x31\xb3\x06\xb3\x06\x21\x00\xb3\x06\xd1\x06\x68\x31\x68\x31\x7c\x2f\xb6\x31\x53\x02\xcd\x06\x00\x00\x7b\x34\x00\x2a\x00\x00\xaf\x06\x00\x00\x00\x00\x00\x00\x00\x00\x75\x29\xe3\x06\x6c\x02\xec\x06\x5a\x00\x94\x06\x00\x00\x75\x29\x00\x00\x75\x29\x00\x07\x0e\x07\xf1\x22\x5a\x00\x75\x29\x75\x29\xf9\x06\x00\x00\x00\x00\x09\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd4\x2d\x00\x00\x00\x00\x18\x19\x00\x00\x18\x19\x18\x19\x18\x19\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x03\x00\x00\x9d\x02\x41\x01\xd2\x02\x00\x00\x00\x00\xe3\x33\x18\x19\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x10\x18\x07\x27\x07\x5a\x00\x5a\x00\x8e\x03\xeb\x06\x00\x00\x00\x00\x00\x2a\x03\x07\x3b\x07\x4e\x07\x5d\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x02\x00\x00\x00\x00\x45\x07\x10\x07\x86\x0e\x60\x07\x60\x07\x00\x00\x59\x07\x00\x00\x00\x00\x70\x07\x00\x00\x00\x00\x00\x00\x82\x07\x00\x00\x4d\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc6\x2c\xd4\x2d\x00\x00\x00\x00\x94\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf1\x22\x00\x00\x00\x00\x00\x00\x75\x29\x00\x00\x00\x00\x00\x00\x00\x00\x49\x27\x00\x00\x00\x00\x29\x00\x61\x07\x00\x00\x7b\x07\x00\x00\xda\x01\x85\x03\xc1\x03\xce\x03\xea\x03\xee\x03\x55\x04\xa8\x04\xed\x04\xfb\x04\x1c\x05\x60\x05\x8c\x05\xd1\x05\x05\x06\x09\x06\x16\x06\x40\x06\x4c\x06\x6a\x06\x89\x06\x00\x00\x88\x07\x8a\x07\xbe\x07\x28\x07\x00\x00\xa8\x07\xba\x07\x00\x00\xf0\x2d\x51\x07\x17\x00\x00\x00\xd0\x07\xd1\x07\x30\x00\x39\x00\x00\x00\xd7\x07\xcb\x30\x46\x00\xcb\x30\x18\x19\xcb\x30\xcb\x30\xc5\x2f\xcf\x07\x90\x04\x22\x03\xd8\x07\x06\x1c\x3e\x1d\x74\x02\x18\x19\x6e\x07\x76\x07\x78\x07\x84\x07\x8c\x07\x98\x07\xb3\x07\x00\x00\x00\x00\x00\x00\x18\x19\x18\x19\x0d\x08\x30\x07\x30\x07\x00\x05\x00\x05\xcb\x30\x18\x19\x08\x04\x18\x19\x20\x0f\x20\x08\xfb\x07\xbb\x01\x00\x00\x00\x00\xac\x01\x00\x00\x24\x08\x31\x08\x00\x00\x00\x00\x92\x24\x36\x08\x00\x00\x5a\x00\x2d\x08\x39\x08\x00\x00\x00\x00\x00\x00\xd4\x27\x00\x00\x6e\x00\x00\x00\x00\x00\x32\x08\x00\x00\xfb\x02\x00\x00\x33\x08\x00\x00\x00\x00\x34\x08\x00\x00\x00\x00\x00\x00\x75\x29\x46\x2f\x00\x00\x00\x00\x00\x00\x4d\x08\x00\x00\x1b\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x3b\x00\x5c\x08\x5a\x2c\x00\x00\x4e\x08\x52\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x41\x04\x00\x00\x00\x00\x00\x00\x75\x29\x1d\x25\x75\x29\x0c\x08\x03\x00\x1d\x25\x00\x00\x00\x00\x00\x00\x00\x00\x95\x06\xff\x07\x75\x29\x5f\x28\x00\x00\x53\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xef\x31\x00\x00\x00\x00\x2d\x04\x15\x08\xfe\x07\xd4\x2d\x16\x08\xab\x06\x37\x01\x00\x00\x01\x08\x55\x08\x00\x00\x75\x29\x5f\x28\x0f\x08\x6f\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x16\x10\x08\x00\x00\x60\x08\x72\x08\x00\x00\x68\x08\x00\x00\x8f\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x08\x00\x00\xc2\x09\x66\x08\x00\x00\x4c\x04\x18\x19\xea\x28\xea\x28\xc1\x32\x84\x19\xc1\x32\x00\x00\xc1\x32\x8b\x02\xf9\x07\xfa\x07\xfc\x07\x6d\x08\x78\x08\x8d\x08\x73\x08\x3d\x08\x9d\x08\x00\x00\x68\x31\x00\x00\x68\x31\x00\x00\x00\x00\x00\x00\x9a\x08\x22\x32\x22\x32\x00\x00\x18\x08\x99\x05\x00\x00\x00\x00\x5a\x2c\x00\x00\x00\x00\xce\x02\x78\x02\x99\x08\x00\x00\x83\x08\x95\x08\x94\x08\xa2\x08\x00\x00\x00\x00\xd4\x2d\x00\x00\xd4\x2d\x00\x00\x00\x00\x75\x29\xd0\x04\xa0\x08\x82\x2a\x4f\x11\xa0\x08\x22\x08\x26\x08\x42\x08\x00\x00\xe1\x2c\x00\x00\x64\x04\x00\x00\x00\x00\xae\x08\xa7\x08\x00\x00\x00\x00\xb5\x08\xc2\x09\x00\x00\xd8\x04\xdd\x2e\xe9\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x08\x00\x00\xb6\x08\x00\x00\x00\x00\xd4\x2d\x00\x00\xc2\x08\x69\x08\x00\x00\x75\x29\x00\x00\x3a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x29\x3d\x32\xf0\x19\xb3\x08\x00\x00\xf0\x19\x00\x00\x00\x00\x00\x00\x00\x00\xaf\x08\xb8\x08\x00\x00\x00\x00\x06\x1c\x00\x00\x00\x00\x00\x00\x61\x08\x00\x00\x00\x00\xad\x08\xd4\x2d\x95\x33\xf0\x19\x4c\x00\x00\x00\xc4\x08\xf0\x19\x00\x00\x00\x00\xd4\x2d\xaf\x33\xbe\x08\x00\x00\x00\x00\xce\x08\x00\x00\xc9\x08\x00\x00\x1e\x17\x9c\x02\x3f\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd2\x08\xa1\x03\x00\x00\x00\x00\x00\x00\x58\x32\xf0\x19\xd6\x08\x00\x00\xa4\x1d\x00\x00\x00\x00\x90\x08\xe8\x08\x00\x00\xa4\x08\x00\x00\x9f\x02\xa4\x08\x81\x08\xe3\x08\xe5\x08\xbb\x01\x00\x00\x00\x00\x8e\x08\xe0\x08\x00\x00\x75\x29\xea\x28\xf2\x08\x00\x00\x75\x29\x75\x29\x75\x29\x00\x00\xeb\x08\x00\x00\xb0\x08\xa8\x08\xbd\x06\x50\x00\x00\x00\x00\x00\x13\x00\xd8\x04\x00\x00\x00\x00\x9b\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb7\x08\x00\x00\x0d\x03\x00\x00\x00\x00\x00\x00\x00\x00\x25\x33\x82\x00\x56\x1a\xa4\x1d\x00\x00\x00\x00\xfc\x08\xff\x08\x6f\x13\xb4\x08\x00\x00\x00\x00\x9c\x02\x75\x29\x00\x00\x00\x00\x09\x09\xfa\x08\x0a\x1e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbb\x08\x00\x00\xe3\x33\x00\x00\x11\x09\x7a\x33\x00\x00\x06\x1c\x00\x00\xc1\x32\x9e\x08\x17\x09\x00\x00\x00\x00\xa1\x08\x0e\x09\x8b\x32\x00\x00\xc1\x32\x14\x09\xf7\x08\x00\x00\x75\x29\x13\x09\x1e\x09\x32\x09\x00\x00\x00\x00\x5e\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x2f\x38\x09\x68\x2d\x00\x00\x22\x04\x7b\x34\x00\x00\x00\x00\x36\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd4\x2d\x45\x09\x00\x00\x7b\x34\x75\x29\x2b\x09\x00\x00\x00\x00\x00\x00\xc2\x1a\x00\x00\x00\x00\x00\x00\x2e\x1b\x00\x00\x00\x00\x27\x09\x00\x00\x42\x09\xd6\x11\x46\x09\x5a\x00\xe3\x33\x00\x00\x00\x00\xba\x0f\x47\x09\x5a\x00\x00\x00\x0a\x1e\x00\x00\x00\x00\x00\x00\x4a\x09\x47\x30\x6c\x1c\x00\x00\x0a\x1e\x60\x09\x00\x00\x2d\x02\x4c\x09\x5a\x00\x00\x00\x00\x00\xe4\x16\x00\x00\x75\x29\x00\x00\x00\x00\x00\x00\x5f\x09\x00\x00\xf8\x2e\x00\x00\x55\x09\x68\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5a\x09\x00\x00\x0a\x1e\x5f\x01\xbb\x02\x00\x00\x00\x00\x69\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x09\xe4\x12\x50\x17\xfd\x33\x00\x00\x00\x00\x9a\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x1e\x00\x00\x9a\x1b\x9a\x1b\x17\x34\xc8\x10\x6a\x09\x5a\x00\x00\x00\x00\x00\x9a\x1b\x00\x00\x3a\x09\xed\x08\x00\x00\x00\x00\x04\x31\x3d\x09\x00\x00\x00\x00\x75\x29\x00\x00\x72\x09\x00\x00\x00\x00\x17\x34\x00\x00\xcb\x06\x00\x00\x62\x09\x83\x00\x66\x09\x5d\x12\x76\x09\xc9\x04\xd3\x04\xd8\x1c\x9a\x1b\x00\x00\x6e\x0d\xd8\x1c\x00\x00\x41\x10\x76\x09\x00\x00\xe9\x30\x9a\x1b\xd3\x17\x34\x03\x76\x09\x00\x00\x7d\x09\x74\x09\x00\x00\x00\x00\x00\x00\x8a\x09\xa6\x32\xae\x02\x00\x00\x00\x00\x62\x30\x8d\x09\x7d\x30\x00\x00\x00\x00\x00\x00\xe9\x30\x00\x00\x00\x00\x00\x00\x80\x09\x9a\x1b\x00\x00\x37\x05\x00\x00\xd4\x2d\x9a\x1b\x50\x09\x2f\x09\x00\x00\x9a\x1b\x00\x00\x9a\x1b\x9a\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x09\x00\x00\x8f\x09\x00\x00\x00\x00\xd4\x2d\xc9\x33\x00\x00\x00\x00\x7f\x03\x00\x00\x00\x00\x48\x03\x00\x00\x00\x00\xa7\x09\x00\x00\x00\x00\x68\x31\x92\x09\x95\x09\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x1b\x00\x00\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\x02\x00\x7d\x38\x9d\x3f\x04\x00\xf6\x06\xab\x37\xaa\x09\x01\x00\xfd\xff\xff\xff\xfe\xff\x06\x00\x52\x03\x93\x05\x00\x00\x00\x00\xba\x09\x00\x00\xbb\x09\x00\x00\x00\x00\x00\x00\xac\x09\x00\x00\x00\x00\x00\x00\x00\x00\x44\x10\x00\x00\x00\x00\x00\x00\x1b\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x52\x3c\xb3\x3c\xd8\x3c\x39\x3d\x00\x00\xc2\x35\xe7\x0c\x25\x47\xe1\x0c\x42\x47\xba\x3f\x00\x00\x9a\x38\xf4\x38\xc5\x45\x13\x07\xc7\x08\x62\x07\xfc\x00\x00\x00\x4a\x03\x1f\x41\x0c\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x41\x62\xff\x00\x00\x00\x00\x00\x00\x22\x38\xce\xff\x70\xff\xa1\x36\x73\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x0c\x00\x00\x00\x00\xe3\x02\x00\x00\x63\x09\x00\x00\x00\x00\x00\x00\x00\x00\xad\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x05\x8c\x06\xa0\x06\xbb\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x11\x39\x5a\x03\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x09\x00\x00\x00\x00\x00\x00\x0f\x05\x6c\x05\x00\x00\x00\x00\xdf\xff\x00\x00\x00\x00\x00\x00\xd6\x03\x00\x00\x00\x00\x05\x00\x72\x04\x5d\x05\xc3\x08\x00\x00\x00\x00\x07\x00\x0d\x00\x00\x00\x00\x00\x76\x00\xcc\x08\x00\x00\x00\x00\xb3\xff\x00\x00\x00\x00\x00\x00\x55\x06\x1f\x09\x57\x07\x00\x00\x00\x00\xc0\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\xd9\x04\x00\x00\x00\x00\xcf\x0b\x00\x00\x00\x00\xbd\x01\xc1\x09\x00\x00\x00\x00\x00\x00\xf8\x06\x00\x00\x00\x00\x00\x00\x00\x00\x93\x35\xed\x35\x00\x00\x00\x00\x66\x47\x00\x00\x00\x00\x2d\x09\x00\x00\x09\x00\x23\x00\x00\x00\x00\x00\x2a\x01\x00\x00\x12\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x02\x21\x09\x00\x00\x00\x00\x00\x00\x10\x03\x80\x01\x00\x00\x00\x00\xcb\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x83\x47\x00\x00\x00\x00\x00\x00\xa2\x46\x00\x00\x72\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x46\x00\x00\x00\x00\x00\x00\xd3\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5c\x3d\xe0\x3d\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5c\x3d\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x0c\xa7\x47\xc4\x47\x6b\x39\xd5\x01\x00\x00\x00\x00\x00\x00\x61\x46\x00\x00\x4d\x06\x6c\x07\x96\x41\xf0\x41\x0d\x42\x67\x42\xbe\x09\x00\x00\x7b\x00\x00\x00\xd0\x08\xdb\x08\x95\x05\x9f\x05\xe5\x02\x47\x03\x00\x00\xab\x03\x00\x00\xe8\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x03\x05\x48\xe6\x08\xc2\x05\xe7\x08\x00\x00\x11\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x06\x00\x00\x48\x06\x00\x00\xc6\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbd\x3d\x00\x00\x00\x00\x00\x00\x4b\x06\x00\x00\x00\x00\x00\x00\x14\x40\x31\x40\x00\x00\xb9\x05\x00\x00\x00\x00\x00\x00\x41\x3e\x00\x00\x64\x3e\x84\x42\x5a\x34\x00\x00\x00\x00\x00\x00\xc5\x3e\xde\x42\xb4\x34\x00\x00\x26\x00\x2c\x00\x00\x00\xfb\x42\x55\x43\x00\x00\x47\x36\x00\x00\x00\x00\x61\x46\x00\x00\x00\x00\x00\x00\xbc\x09\xe1\x08\xb0\x06\x00\x00\x00\x00\xf0\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x06\x00\x00\x00\x00\x00\x00\x29\x48\x00\x00\x04\x0a\x00\x00\x00\x00\xd7\x08\x00\x00\x00\x00\x00\x00\xaf\x09\x00\x00\x1e\x0c\x76\x01\x96\x09\x98\x09\x9b\x09\xa0\x09\x2c\x06\x68\x03\x79\x03\x01\x04\x4d\x01\x38\x01\x00\x00\x00\x00\x08\x06\xe4\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x40\x7a\xff\x68\x02\x00\x00\xf1\x08\x00\x00\x00\x00\x72\x43\x00\x00\xcc\x43\x00\x00\x20\x09\x72\x36\xf8\x08\xe9\x43\x43\x44\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x05\x00\x00\x00\x00\x18\x0a\x00\x00\x35\x0a\x64\x0a\x78\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\xff\xbc\x0a\xc0\x06\x06\x07\x00\x00\x00\x00\x00\x00\x00\x00\x19\x02\x00\x00\x00\x00\xf9\x08\xfb\x08\xdc\x09\x00\x00\x3b\x09\x00\x00\x01\x47\xf6\x09\x1c\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x07\x00\x00\x66\x0a\x72\x07\x00\x00\x00\x00\x00\x00\xa5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x37\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x04\x89\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x36\x00\x00\x00\x00\x00\x00\x60\x44\x00\x00\x00\x00\x00\x00\x83\x07\x26\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x09\x05\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x09\x73\x04\x00\x00\x87\x04\xd9\x0a\xce\x04\xe0\x04\x5d\x01\x00\x00\xac\x06\x00\x00\x00\x00\x04\x0c\x7f\x02\xb2\xff\x1b\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x52\x04\x2f\x0b\x99\x09\xb9\x09\xbd\x09\xff\x04\x6e\x05\xe8\x00\x9a\x07\x46\x01\xb7\x07\xa7\x01\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xeb\xff\x00\x00\x00\x00\x26\x3f\x00\x00\x00\x00\x08\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xba\x44\x7f\x04\x00\x00\x00\x00\x00\x00\xf9\x09\x00\x00\x91\x07\x9e\x07\x00\x00\x00\x00\x00\x00\x00\x00\x1d\x09\x46\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb2\x07\xbd\x07\x10\x09\x00\x00\x00\x00\x00\x00\xd7\x44\x0e\x35\x31\x45\x00\x00\x00\x00\x68\x35\x00\x00\x00\x00\xcd\x07\x00\x00\x4f\x05\x00\x00\xe2\x39\x05\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x03\x00\x00\x00\x00\x9f\x01\xa7\x05\xa3\x09\xb4\x09\xbf\x05\x00\x00\x00\x00\x00\x00\x85\x09\x8b\x09\x00\x00\xff\x39\x80\x37\x8e\x09\xe0\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\xff\xa5\x09\x06\x04\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\xff\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x09\x03\x0a\x02\x05\x00\x00\x00\x00\x08\x0a\xcb\x07\xa8\x40\x02\x41\xe9\x06\x43\x0b\x7b\x01\x00\x00\xfd\x00\x34\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe7\x09\xea\x09\x00\x00\xb0\x02\x00\x00\x2e\x03\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\xd9\xff\x00\x00\x00\x00\xe1\xff\x86\x09\x00\x00\x6a\x48\x00\x00\x00\x00\x00\x00\x70\x09\x9d\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1d\x13\x00\x00\xfd\x09\x00\x00\x00\x00\x59\x3a\xc5\x00\x00\x00\x7e\x46\x6f\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf6\xff\x00\x00\x00\x00\x94\x09\x00\x00\x00\x00\x36\x0a\x00\x00\x00\x00\x00\x00\xaf\x05\x00\x00\x3f\x09\x7c\x00\x74\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x05\x00\x00\x00\x00\x00\x00\x00\x00\x76\x3a\x00\x00\x84\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x46\xd1\xff\x76\x04\x00\x00\x00\x00\x8a\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x0b\x00\x00\xd9\x09\x00\x00\x4f\x09\x00\x00\x00\x00\xb9\x07\x6d\x0c\xdb\x00\xdf\x07\x1a\x0a\x00\x00\x57\x09\x60\x0b\x00\x00\x00\x00\x20\x0d\x57\x00\x00\x00\x00\x00\x00\x00\x5e\x09\x00\x00\x00\x00\x00\x00\x04\x02\xe6\x06\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf7\xff\x00\x00\x00\x00\x00\x00\x00\x00\xe3\x00\x0e\x08\x00\x00\x00\x00\xa0\x0c\xed\x09\x00\x00\xd0\x05\x61\x09\x00\x00\xde\x09\x00\x00\x64\x09\xdc\x05\xf7\x09\x00\x00\x00\x00\xe8\x02\x00\x00\x00\x00\xd1\x09\xa6\x09\x00\x00\xd0\x3a\x43\x3f\x00\x00\x00\x00\xed\x3a\x47\x3b\x64\x3b\x00\x00\x00\x00\x00\x00\x54\x0a\x5a\x0a\x00\x00\x71\x09\x00\x00\x00\x00\x6e\x06\x73\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x06\x00\x00\xa7\x00\x00\x00\x35\x00\x44\x00\x00\x00\xe6\x00\x9c\x00\x21\x08\xd6\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x38\x06\x6a\x07\x00\x00\x00\x00\xea\x06\xbe\x3b\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x02\x2e\x00\x31\x00\x47\x02\x00\x00\x9c\x07\x00\x00\x00\x00\x1a\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x0a\x00\x00\x7e\xff\x00\x00\x7f\x09\xe6\x00\x00\x00\x34\x0c\x00\x00\x99\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x1a\x07\x00\x00\x00\x00\x00\x00\x4e\x45\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x19\x00\x00\x00\x56\x06\x80\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x05\x00\x00\x00\x00\xa6\x06\xdb\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x04\x00\x00\x00\x00\x00\x00\x7d\x0b\x4a\x00\x4e\x00\x00\x00\x00\x00\xd3\xff\x11\x05\x00\x00\x87\x09\x68\x00\x00\x00\x00\x00\x94\x02\x00\x00\x88\x09\x00\x00\x66\x04\x00\x00\x00\x00\x00\x00\x00\x00\x16\x00\x21\x08\x00\x00\xac\x04\x90\x09\x00\x00\xa9\x00\x00\x00\x89\x09\x00\x00\x00\x00\xb5\x06\x00\x00\x35\x3c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfb\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x08\x00\x00\x00\x00\x00\x00\x21\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x08\x00\x00\x00\x00\xfa\x09\x8a\x05\x5a\x0c\x00\x00\x00\x00\x00\x00\x3e\x08\x00\x00\x00\x00\x2a\x08\x00\x00\x00\x00\x00\x00\x00\x00\x80\x05\x00\x00\x9d\x01\x9a\x03\xe2\xff\x40\x03\x00\x00\x8c\x09\x00\x00\x00\x00\x82\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4d\x00\x00\x00\x00\x00\x00\x00\xa8\x45\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x09\x00\x00\x2f\x05\x00\x00\xf3\x01\x5c\x0a\x77\x0c\x21\x04\x00\x00\x60\x12\x8b\x0c\x00\x00\xc2\x02\x00\x00\x00\x00\x89\x01\x96\x08\xc5\x08\xb6\xff\x00\x00\x00\x00\x00\x00\x80\x0a\x00\x00\x00\x00\x00\x00\x00\x00\xb4\x01\xd1\x00\x00\x00\x00\x00\xd2\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\xe7\x01\x00\x00\x00\x00\x00\x00\x6f\x0a\xe2\x08\x00\x00\x70\x0a\x00\x00\x3b\x0f\xf6\x08\xe5\x06\x2d\x0a\x00\x00\x0a\x09\x00\x00\x3e\x04\x39\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\x06\x00\x00\x2b\x08\x00\x00\x00\x00\x31\x13\x06\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x00\x00\x00\x81\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x4d\x09\x00\x00\x00\x00\x00\x00"#

happyAdjustOffset :: Happy_GHC_Exts.Int# -> Happy_GHC_Exts.Int#
happyAdjustOffset off = off

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\x19\xfd\x00\x00\x00\x00\x19\xfd\x00\x00\x00\x00\x00\x00\x19\xfd\x19\xfd\x19\xfd\x19\xfd\x00\x00\x00\x00\xea\xff\xef\xfc\x00\x00\xe2\xff\x00\x00\xe2\xff\x00\x00\x00\x00\x00\x00\xbc\xff\x85\xfd\x61\xfe\x5f\xfe\x59\xfe\x58\xfe\x56\xfe\x54\xfe\x4e\xfe\x44\xfe\x3f\xfe\x36\xfe\x33\xfe\x24\xfe\x00\x00\x00\x00\x2f\xfe\x71\xfd\x7a\xfd\x30\xfe\x32\xfe\x79\xfd\x31\xfe\x6c\xfd\x3e\xfd\x50\xfd\x6a\xfd\x65\xfd\x34\xfd\x2e\xfe\x4d\xfd\x51\xfd\x4f\xfd\x36\xfd\x35\xfd\x32\xfd\x33\xfd\x23\xfd\x21\xfd\x22\xfd\x20\xfd\x1f\xfd\x1e\xfd\x1d\xfd\x1c\xfd\x1b\xfd\x1a\xfd\x00\x00\x00\x00\x00\x00\xa7\xfd\x4e\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x19\xfd\x00\x00\x00\x00\x18\xfe\x00\x00\x00\x00\xfd\xfd\x49\xfd\x3d\xfd\x3c\xfd\x3a\xfd\x3b\xfd\x48\xfd\x47\xfd\x46\xfd\x45\xfd\x44\xfd\x43\xfd\x42\xfd\x41\xfd\x4c\xfd\x00\x00\x19\xfd\x38\xfd\x39\xfd\x4a\xfd\x19\xfd\x19\xfd\x19\xfd\x00\x00\x19\xfd\x4b\xfd\x37\xfd\x40\xfd\x3f\xfd\x00\x00\x00\x00\x00\x00\x01\xff\xd0\xfe\x07\xff\xfd\xfe\xee\xfe\x00\x00\xe6\xfe\xe5\xfe\xfc\xfe\xdf\xfe\x00\x00\xd3\xfe\x00\x00\x00\x00\xfb\xfc\xd8\xfe\xfb\xfe\xfc\xfc\xe8\xfe\xe7\xfe\x00\x00\x00\x00\x00\x00\x00\x00\xf0\xfe\xe2\xfe\xe3\xfe\xf1\xfe\x00\x00\x00\x00\xef\xfe\xfa\xfc\xf9\xfc\xf8\xfc\xc8\xfe\x00\x00\x00\x00\x00\x00\xd6\xff\xd6\xff\x95\xfd\x00\x00\x19\xfd\x00\x00\x61\xfe\x00\x00\xe2\xff\xf1\xff\xef\xff\x19\xfd\x00\x00\xe2\xff\x00\x00\x36\xff\x00\x00\xd6\xff\xd6\xff\x00\x00\xd7\xff\xd9\xff\x00\x00\xe0\xfe\xe1\xfe\x00\x00\xed\xfe\x78\xfd\x77\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\xff\xd0\xfe\xcd\xfe\x00\x00\x00\x00\xdc\xfe\xcd\xfe\x00\x00\x00\x00\x00\x00\xda\xfe\x0e\xfe\xcd\xfe\x00\x00\x00\x00\x00\x00\x52\xfd\x31\xfd\x00\x00\x2e\xfd\x2a\xfd\x2d\xfd\x28\xfd\x2f\xfd\x24\xfd\x30\xfd\xde\xfe\x26\xfd\x53\xfd\x00\x00\x29\xfd\xe3\xfe\x25\xfd\x00\x00\xd1\xfe\xe4\xfe\xfa\xfe\xfe\xfe\x00\x00\xd5\xfe\x5b\xfd\x00\x00\xf6\xfc\xf5\xfc\x00\x00\x00\x00\xcf\xfe\xf4\xfc\xf3\xfc\x00\x00\x00\x00\x00\x00\x00\x00\x84\xfd\x8a\xfd\x8a\xfd\x00\x00\x3c\xfe\x00\x00\x45\xfe\x87\xfd\x4c\xfe\x50\xfe\xd6\xff\xd6\xff\x46\xfe\x00\x00\x4a\xfe\x00\x00\xc4\xfd\xf8\xfd\xf4\xfd\xf7\xfd\xf6\xfd\xf5\xfd\xf0\xfd\xef\xfd\xee\xfd\xed\xfd\xeb\xfd\xec\xfd\xea\xfd\xe9\xfd\xe8\xfd\xe7\xfd\xe6\xfd\xe5\xfd\xe4\xfd\xe3\xfd\xe2\xfd\xe1\xfd\xe0\xfd\xf2\xfd\xf1\xfd\xdf\xfd\xde\xfd\xdd\xfd\xdc\xfd\xdb\xfd\xda\xfd\xd9\xfd\xd8\xfd\xd7\xfd\xd6\xfd\xd5\xfd\xd4\xfd\xd3\xfd\xd2\xfd\xd1\xfd\xd0\xfd\xcf\xfd\xce\xfd\xcd\xfd\xcc\xfd\xcb\xfd\xca\xfd\xc9\xfd\xf3\xfd\xc8\xfd\xc7\xfd\xc6\xfd\x19\xfe\x1a\xfe\x00\x00\x00\x00\x00\x00\x1c\xfe\x1b\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x58\xfe\x00\x00\x00\x00\x05\xfe\x00\x00\x94\xfd\x47\xfe\x38\xfe\x37\xfe\xff\xfe\x00\x00\x3d\xfe\x19\xfd\x09\xfe\xa6\xfd\xa5\xfd\x00\x00\x55\xfd\x54\xfd\x00\x00\x5f\xfd\x2c\xfd\x2b\xfd\x00\x00\x27\xfd\xc0\xfd\x00\x00\xbf\xfd\x72\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x75\xfd\x0c\xfe\x09\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x5b\xfd\x00\x00\x2c\xfd\x2b\xfd\x76\xfd\x29\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x40\xfe\x57\xfd\x56\xfd\x5e\xfe\x61\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xba\xff\x00\x00\xec\xfc\xee\xfc\x00\x00\x00\x00\xd6\xff\xd6\xff\xd6\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\xff\x0d\xff\x70\xfd\x69\xfd\x00\x00\x00\x00\x00\x00\xd6\xff\x00\x00\x00\x00\xea\xff\xec\xff\x17\xfd\x18\xfd\xf0\xfc\x00\xfd\xff\xfc\xd6\xff\xed\xfc\xd6\xff\xbd\xff\xb8\xff\xbb\xff\x5a\xfe\x5b\xfe\x5c\xfe\x5d\xfe\x60\xfe\x00\x00\x00\x00\x57\xfe\x55\xfe\x00\x00\x82\xfd\x7f\xfd\x00\x00\x35\xfe\x81\xfd\x86\xfd\x39\xfe\x3a\xfe\x6b\xfd\x64\xfd\x27\xfe\x17\xfe\x10\xfe\x16\xfe\x2d\xfe\x15\xfe\x11\xfe\x73\xfd\x0f\xfe\x2c\xfe\x00\x00\x00\x00\x2b\xfe\x0a\xfe\x0d\xfe\x74\xfd\x2a\xfe\x00\x00\x29\xfe\x00\x00\xbe\xfd\x00\x00\x00\x00\x08\xfe\x28\xfe\x00\x00\x00\x00\x00\x00\x48\xfe\xd6\xff\xd6\xff\x3e\xfe\x00\x00\x00\x00\x26\xfe\x00\x00\x22\xfe\x21\xfe\x00\x00\x20\xfe\x1f\xfe\x51\xff\x9f\xff\x00\x00\xd6\xff\x91\xff\x90\xff\x00\x00\x7b\xff\x52\xff\x4b\xff\x4a\xff\x50\xff\x83\xff\x58\xfe\x4f\xff\x16\xfd\x4e\xff\x00\x00\x00\x00\x00\x00\x5b\xff\x00\x00\x01\xfd\x9d\xff\x9c\xff\x9b\xff\x64\xff\x5a\xff\x00\x00\x00\x00\x1d\xff\x1d\xff\x1d\xff\x1d\xff\x1f\xff\x11\xff\x11\xff\x00\x00\x3d\xff\x00\x00\x00\x00\x1d\xfe\x00\x00\xc1\xfd\x00\xfe\x00\x00\xfa\xfd\xfe\xfd\x4b\xfe\xfc\xfd\x00\x00\x19\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x4d\xfe\x00\x00\x3b\xfe\x00\x00\x00\x00\x88\xfd\x8a\xfd\x00\x00\x00\x00\x00\x00\x00\x00\xd4\xfe\x04\xff\x00\x00\x05\xff\x06\xff\x02\xff\xdd\xfe\xd6\xfe\xd7\xfe\xdb\xfe\xf9\xfe\xf4\xfe\x00\x00\xd9\xfe\xf8\xfe\x00\x00\xf7\xfe\x00\x00\x00\x00\x00\x00\xeb\xfe\xf6\xfe\xf5\xfe\xf2\xfe\x00\x00\xea\xfe\x00\x00\x00\x00\x00\x00\xc9\xfe\xc7\xfe\x00\x00\x00\x00\xd6\xff\xd6\xff\xbf\xff\xdb\xff\xd8\xff\xde\xff\x55\xff\x00\x00\x00\x00\x00\x00\x00\x00\xdf\xff\x00\x00\xc4\xfd\xe4\xff\xc1\xfd\x00\x00\xd4\xff\x00\x00\x00\x00\x34\xff\x4c\xff\x35\xff\x4d\xff\xd6\xff\x53\xff\x67\xfe\xd6\xff\x7c\xfd\x32\xfe\x00\x00\xd7\xff\xda\xff\xdd\xff\xd2\xfe\x00\x00\xe9\xfe\xec\xfe\xce\xfe\xcb\xfe\xcc\xfe\xca\xfe\x00\x00\x9d\xfe\x9c\xfe\x9a\xfe\x96\xfe\xfd\xfc\x95\xfe\x94\xfe\x00\x00\x00\x00\x98\xfe\xf7\xfc\x00\x00\x42\xfe\x43\xfe\x8d\xfd\x8b\xfd\x8c\xfd\x8a\xfd\x8e\xfd\x4f\xfe\x52\xfe\x00\x00\x92\xfd\x93\xfd\x8f\xfd\xd6\xff\x00\x00\x49\xfe\x05\xfe\x00\x00\x00\x00\xc2\xfd\x00\x00\xc5\xfd\x00\x00\x4d\xfd\x32\xfd\x49\xfd\x3d\xfd\x3c\xfd\x3a\xfd\x3b\xfd\x48\xfd\x47\xfd\x46\xfd\x45\xfd\x44\xfd\x43\xfd\x42\xfd\x41\xfd\x4c\xfd\x38\xfd\x39\xfd\x4a\xfd\x4b\xfd\xf9\xfd\x67\xfd\x8c\xfe\x00\x00\x00\x00\x3e\xff\x3c\xff\x3a\xff\x37\xff\x00\x00\x00\x00\x00\x00\x12\xff\x00\x00\x0f\xff\x00\x00\x00\x00\x20\xff\x1d\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\xfd\x04\xfd\x03\xfd\x57\xff\x00\x00\xc2\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\xfe\x00\x00\xd7\xff\x93\xff\x00\x00\x00\x00\x9e\xff\xa9\xfd\x00\x00\xab\xfd\x00\x00\x19\xfd\x06\xfe\x53\xfe\x00\x00\x00\x00\x9f\xfd\x00\x00\xa2\xfd\xb6\xfd\xb4\xfd\xb3\xfd\xb2\xfd\x00\x00\xa4\xfd\x09\xfe\xb8\xfd\x5e\xfd\xba\xfd\xbc\xfd\x09\xfe\xb9\xfd\x0b\xfe\x14\xfe\x07\xfe\x03\xfe\x04\xfe\x12\xfe\x13\xfe\x00\x00\x00\x00\x34\xfe\x5a\xfd\x60\xfd\xb6\xff\xb9\xff\x00\x00\x00\x00\xeb\xff\xe8\xff\xe5\xff\x00\x00\x00\x00\x00\x00\x0a\xff\x00\x00\x00\x00\xe7\xff\x09\xff\x6f\xfd\x68\xfd\x0b\xff\xe6\xff\xe9\xff\xd6\xff\xd6\xff\x00\x00\xb7\xff\x83\xfd\x80\xfd\xbd\xfd\x00\x00\x00\x00\xb1\xfd\x00\x00\x00\x00\xa0\xfd\xa1\xfd\xd6\xff\x9c\xfd\x00\x00\xa8\xfd\x00\x00\x00\x00\x25\xfe\xa0\xff\x59\xfd\x58\xfd\x99\xff\x5d\xfd\x63\xfd\x00\x00\x1e\xfe\x92\xff\x8e\xfe\xa6\xfe\xbb\xfe\x00\x00\xaf\xfe\x49\xff\x00\x00\x32\xff\x69\xfe\x65\xfe\x63\xfe\x00\x00\x00\x00\x69\xfe\x25\xff\x31\xff\x30\xff\x2f\xff\x2e\xff\x2d\xff\x2c\xff\x2b\xff\x2a\xff\x00\x00\x88\xfe\xc4\xfe\x7a\xff\x00\x00\x58\xff\x03\xff\x59\xff\x64\xff\x66\xff\x67\xff\x68\xff\x69\xff\x6a\xff\x65\xff\x78\xfe\x6e\xff\x00\x00\x00\x00\x08\xff\x78\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\xfd\x12\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1a\xff\x21\xff\x80\xff\x13\xff\x7f\xff\x00\x00\x10\xff\x7e\xff\x7d\xff\x00\x00\x00\x00\x00\x00\x42\xff\x00\x00\x00\x00\xfd\xfd\x01\xfe\x00\x00\xff\xfd\xfb\xfd\x00\x00\x91\xfd\x4c\xfe\x89\xfd\x00\x00\x00\x00\x00\x00\x9d\xfe\x93\xfe\x99\xfe\x00\x00\xf3\xfe\x00\x00\xc0\xff\xdc\xff\x00\x00\xd7\xff\x7e\xfd\x00\x00\xd7\xff\x56\xff\x00\x00\x00\x00\x00\x00\xd5\xff\xd0\xff\xf0\xff\x00\x00\xfd\xfd\xed\xff\x00\x00\xd0\xff\xce\xff\xcd\xff\xcb\xff\x00\x00\xd1\xff\x00\x00\x00\x00\x00\x00\xe3\xff\xe1\xff\xe0\xff\x54\xff\x7d\xfd\x00\x00\x7b\xfd\x00\x00\x9b\xfe\x97\xfe\x00\x00\x91\xfe\x00\x00\x00\x00\x90\xfd\x00\x00\xc3\xfd\x4a\xfe\x8b\xfe\x7c\xff\x3b\xff\x39\xff\x38\xff\x0e\xff\x14\xff\x22\xff\x00\x00\x00\x00\x00\x00\x00\x00\x1c\xff\x00\x00\x43\xff\x46\xff\x47\xff\x66\xfd\x0d\xfd\x00\x00\x0e\xfd\x05\xfd\x00\x00\x09\xfd\xc8\xfe\x11\xfd\x14\xfd\x15\xfd\x8f\xff\x98\xff\x00\x00\x00\x00\x00\x00\x6f\xff\x86\xff\x19\xfd\x00\x00\x84\xff\x8a\xff\x00\x00\x00\x00\xc1\xfe\xbf\xfe\x87\xff\x19\xfd\x81\xff\x00\x00\x6e\xfd\x00\x00\x00\x00\x00\x00\x29\xff\x28\xff\x27\xff\x26\xff\x6b\xfe\x19\xfd\x00\x00\x66\xfe\x64\xfe\x6c\xfe\x00\x00\x00\x00\xb5\xfe\xb3\xfe\x00\x00\xc8\xfe\x8d\xfe\xa6\xfe\x19\xfd\x8c\xff\xa5\xfe\xa3\xfe\x01\xfd\xa6\xfe\xbb\xfe\x00\x00\x00\x00\x00\x00\xac\xfd\xaa\xfd\x69\xfe\x99\xfd\x97\xfd\x00\x00\xd7\xff\x9e\xfd\xb5\xfd\x00\x00\x00\x00\x00\x00\xa3\xfd\xb7\xfd\xbb\xfd\xb4\xff\xd7\xff\x00\x00\x00\x00\xf1\xfc\xf2\xfc\xb2\xff\x00\x00\xb0\xfd\xae\xfd\xaf\xfd\x9d\xfd\x9a\xfd\x98\xfd\x9b\xfd\x9a\xff\x5c\xfd\x62\xfd\xa6\xfe\x89\xff\x00\x00\xa4\xfe\xd6\xff\xd6\xff\x8b\xff\x00\x00\x00\x00\xaa\xfe\x00\x00\xb1\xfe\xae\xfe\x00\x00\xd8\xfe\x00\x00\xaf\xfe\x48\xff\x33\xff\x00\x00\x00\x00\x6a\xfe\x82\xff\x00\x00\x00\x00\x00\x00\xd6\xff\xd6\xff\xc4\xfe\xc5\xfe\xc4\xfe\x79\xff\x85\xff\xd6\xff\xd6\xff\x6d\xff\x6c\xff\x6b\xff\x8d\xff\x76\xff\x77\xff\x63\xff\x97\xff\x00\x00\x13\xfd\x19\xfd\x00\x00\x06\xfd\x00\x00\x10\xfd\x00\x00\x00\x00\x41\xff\x3f\xff\x1b\xff\x00\x00\x00\x00\x18\xff\x16\xff\x00\x00\x00\x00\x00\x00\x96\xfd\x00\x00\x00\x00\x90\xfe\x00\x00\xc6\xfe\xc7\xff\x00\x00\xcc\xff\xc2\xff\xc1\xff\xc8\xff\x00\x00\x00\x00\xd1\xff\xd2\xff\x00\x00\x00\x00\xcf\xff\xd3\xff\x00\x00\xc5\xff\xc3\xff\xa2\xff\xa1\xff\xca\xff\xc4\xff\x92\xfe\x00\x00\x00\x00\x51\xfe\x00\x00\x00\x00\x00\x00\x17\xff\x19\xff\x44\xff\x00\x00\x45\xff\x0c\xfd\x07\xfd\x00\x00\xd6\xff\xd6\xff\x00\x00\x8e\xff\x19\xfd\x76\xfe\x00\x00\x00\x00\x00\x00\xbe\xfe\xc0\xfe\x86\xfe\x00\x00\x00\x00\x23\xff\x00\x00\x6d\xfd\x62\xfe\xb4\xfe\x00\x00\x00\x00\xaa\xfe\xb2\xfe\x00\x00\x00\x00\xb0\xfe\x00\x00\x00\x00\x00\x00\xa2\xfe\x9e\xfe\x00\x00\x88\xff\x00\x00\xb5\xff\xbe\xff\xb3\xff\x00\x00\xaf\xff\xd0\xff\xad\xfd\x9f\xfe\x00\x00\xa1\xfe\xbc\xfe\xbd\xfe\xd6\xff\xb8\xfe\x00\x00\xad\xfe\x00\xff\x00\x00\x00\x00\xa8\xfe\xac\xfe\xd7\xfe\x24\xff\x89\xfe\x8a\xfe\x83\xfe\xd6\xff\x84\xfe\x82\xfe\x80\xfe\x00\x00\x00\x00\xc3\xfe\x79\xfe\x7a\xfe\x00\x00\x70\xfe\x71\xfe\xd6\xff\x74\xfe\x72\xfe\x73\xfe\x5b\xff\x00\x00\x62\xff\x00\x00\x00\x00\x00\x00\x55\xff\x00\x00\x00\x00\x08\xfd\x40\xff\x00\x00\x1e\xff\x00\x00\x00\x00\x8f\xfe\xc9\xff\x00\x00\x00\x00\xee\xff\xc6\xff\x00\x00\x02\xfe\x00\x00\x0a\xfd\x0b\xfd\x96\xff\x94\xff\x00\x00\x5d\xff\x00\x00\x00\x00\x00\x00\xd7\xff\x77\xfe\x8e\xfe\x72\xff\x00\x00\x00\x00\x81\xfe\x00\x00\x00\x00\x7f\xfe\xd7\xff\x87\xfe\xab\xfe\x00\x00\x00\x00\x00\x00\xd7\xff\xba\xfe\xa0\xfe\x00\x00\xd0\xff\xac\xff\xab\xff\xfe\xfc\xa8\xff\x00\x00\x00\x00\xa9\xff\xaa\xff\x00\x00\x00\x00\xd1\xff\xb0\xff\xb9\xfe\xb7\xfe\x00\x00\xa7\xfe\xa9\xfe\x85\xfe\x7a\xff\x00\x00\x7b\xfe\x75\xff\x7d\xfe\x00\x00\x00\x00\xa6\xfe\xbb\xfe\x75\xfe\x00\x00\x60\xff\x5e\xff\x00\x00\x61\xff\x95\xff\x15\xff\x41\xfe\x5c\xff\x5f\xff\x6f\xfe\xa6\xfe\x6e\xfe\x98\xff\x71\xff\x7c\xfe\x00\x00\x00\x00\x49\xff\x7e\xfe\x00\x00\xad\xff\xb1\xff\x00\x00\xa3\xff\xa6\xff\x00\x00\xa7\xff\xa5\xff\x00\x00\x00\x00\x00\x00\x74\xff\x70\xff\x6d\xfe\x73\xff\x00\x00\xa4\xff\xb6\xfe"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x04\x00\x04\x00\x04\x00\x02\x00\x04\x00\x04\x00\x11\x00\x12\x00\x13\x00\x04\x00\x38\x00\x11\x00\x2b\x00\x40\x00\x0b\x00\x0b\x00\x47\x00\x48\x00\x49\x00\x0d\x00\x0e\x00\x0d\x00\x0e\x00\x4a\x00\x67\x00\x0d\x00\x0e\x00\x21\x00\x22\x00\x4e\x00\x40\x00\x47\x00\x48\x00\x49\x00\x70\x00\x53\x00\x54\x00\x1b\x00\x0d\x00\x0e\x00\x4a\x00\x17\x00\x40\x00\x13\x00\x0d\x00\x0e\x00\x79\x00\x0d\x00\x0e\x00\x1b\x00\x0d\x00\x0e\x00\x4a\x00\x1b\x00\x40\x00\xd6\x00\x0d\x00\x0e\x00\x0d\x00\x0e\x00\xcb\x00\x0d\x00\x0e\x00\x1f\x00\x4a\x00\x0d\x00\x0e\x00\x3d\x00\xcb\x00\xd6\x00\x66\x00\x67\x00\xd6\x00\x3d\x00\x1b\x00\x23\x00\x01\x00\x1b\x00\x1c\x00\x00\x00\x0d\x00\x0e\x00\x0d\x00\x1b\x00\x1b\x00\x1b\x00\x0d\x00\x0e\x00\x2f\x00\x00\x00\x0d\x00\x0e\x00\xe9\x00\x1c\x00\x14\x00\x15\x00\x4b\x00\x15\x00\x60\x00\x02\x01\x22\x00\x3c\x00\x48\x00\x0a\x00\x4a\x00\x0c\x00\x1b\x00\xf8\x00\xf9\x00\x1e\x00\x24\x00\x24\x00\x24\x00\x02\x01\xf5\x00\x02\x01\x02\x01\x9c\x00\x31\x00\x1e\x00\x50\x00\x53\x00\x54\x00\x02\x01\xf5\x00\x6b\x00\x7c\x00\x4e\x00\x47\x00\x48\x00\x00\x00\x4a\x00\x4b\x00\x28\x00\x3d\x00\x6d\x00\x4f\x00\x52\x00\x3d\x00\x0a\x00\x17\x00\x18\x00\x11\x01\x48\x00\x49\x00\x16\x00\x72\x00\x75\x00\x27\x00\x80\x00\x81\x00\x10\x01\x11\x01\x6d\x00\x25\x00\x2e\x00\x27\x00\x1b\x00\xe9\x00\x6d\x00\x1e\x00\x2c\x00\x2d\x00\x2e\x00\x6d\x00\x9b\x00\x25\x00\xf5\x00\x33\x00\xf8\x00\xf9\x00\x77\x00\xe3\x00\xf8\x00\xf9\x00\x96\x00\x3b\x00\x9b\x00\x75\x00\xe4\x00\x3f\x00\x96\x00\x41\x00\x42\x00\x43\x00\x28\x00\x77\x00\xe3\x00\x18\x00\x90\x00\xf5\x00\xf6\x00\x90\x00\x18\x00\x10\x01\x11\x01\xf5\x00\xf5\x00\xf6\x00\xfe\x00\xff\x00\x25\x00\x9b\x00\x27\x00\x23\x00\xf5\x00\xf6\x00\x02\x01\x2c\x00\x2d\x00\x2e\x00\x9b\x00\x02\x01\x9b\x00\xf5\x00\x33\x00\xf8\x00\xf9\x00\xe5\x00\x75\x00\xd4\x00\xe3\x00\xe9\x00\x3b\x00\x02\x01\xe7\x00\xdc\x00\x3f\x00\x24\x00\x41\x00\x42\x00\x43\x00\xdc\x00\xf4\x00\xf5\x00\xf6\x00\x02\x01\xf8\x00\xf9\x00\xf5\x00\xf6\x00\xcc\x00\x11\x01\xf9\x00\x23\x00\x24\x00\xd4\x00\xcc\x00\x02\x01\xb1\x00\xe5\x00\xb3\x00\xb4\x00\xe5\x00\x02\x01\x02\x01\x02\x01\xe9\x00\x02\x01\x02\x01\x0f\x01\x02\x01\x02\x01\x02\x01\x0e\x01\xf4\x00\xf5\x00\xf6\x00\xf4\x00\xf5\x00\xf6\x00\x9a\x00\xf8\x00\xf9\x00\x15\x01\x17\x01\x16\x01\xe4\x00\x06\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xf5\x00\xf6\x00\xa8\x00\xa9\x00\xaa\x00\x78\x00\x79\x00\xad\x00\xae\x00\xaf\x00\xe3\x00\xf5\x00\x0f\x01\xf5\x00\xe7\x00\xe3\x00\x1b\x00\x86\x00\xe3\x00\xb9\x00\xe3\x00\x23\x00\xe7\x00\x4b\x00\xe7\x00\x27\x00\x06\x00\x07\x00\xf5\x00\xf6\x00\x2c\x00\x1b\x00\xf9\x00\xf5\x00\xf6\x00\x9a\x00\xf5\x00\xf6\x00\xf5\x00\xf6\x00\xf9\x00\x11\x01\xf9\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x70\x00\xf5\x00\xa8\x00\xa9\x00\xaa\x00\x00\x00\x0e\x01\xad\x00\xae\x00\xaf\x00\xdf\x00\x70\x00\xe1\x00\xe2\x00\x18\x00\x23\x00\xe5\x00\xe6\x00\xf5\x00\xb9\x00\xe9\x00\x29\x00\xe5\x00\x66\x00\x67\x00\x23\x00\xe9\x00\x23\x00\x10\x01\x11\x01\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xf4\x00\xf5\x00\xf6\x00\x1a\x00\xf8\x00\xf9\x00\x70\x00\x01\x01\x10\x01\x11\x01\x04\x01\x05\x01\xea\x00\x02\x01\x3b\x00\xed\x00\x0a\x01\xef\x00\x23\x00\x1a\x00\xdf\x00\x2c\x00\xe1\x00\xe2\x00\x29\x00\xed\x00\xe5\x00\xe6\x00\x23\x00\xfb\x00\xe9\x00\x14\x01\xfe\x00\xff\x00\xe9\x00\x46\x00\x47\x00\x48\x00\x49\x00\xfb\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xf8\x00\xf9\x00\xf8\x00\xf9\x00\xde\x00\xe3\x00\x25\x00\x01\x01\x27\x00\xe7\x00\x04\x01\x05\x01\xe6\x00\x2c\x00\x2d\x00\x2e\x00\x0a\x01\x90\x00\x91\x00\x92\x00\x33\x00\x1a\x00\xe3\x00\xf5\x00\xf6\x00\xe7\x00\xe7\x00\xf9\x00\x3b\x00\xf7\x00\x23\x00\x18\x00\x3f\x00\x7a\x00\x41\x00\x42\x00\x43\x00\x09\x00\x0a\x00\xe3\x00\xf5\x00\xf6\x00\x23\x00\xf9\x00\xf9\x00\x25\x00\xe5\x00\x27\x00\x23\x00\xf5\x00\xa7\x00\x2c\x00\x8d\x00\x4b\x00\x2e\x00\x39\x00\x3a\x00\xf5\x00\xf6\x00\x33\x00\xf5\x00\xf4\x00\xf5\x00\xf6\x00\x75\x00\x25\x00\x26\x00\x3b\x00\xb9\x00\x1a\x00\xbb\x00\x3f\x00\x3b\x00\x41\x00\x42\x00\x43\x00\x10\x01\x11\x01\x23\x00\x33\x00\x34\x00\x35\x00\xf5\x00\xf5\x00\xf6\x00\xf8\x00\xf9\x00\x10\x01\x11\x01\x5b\x00\x31\x00\x5d\x00\xf5\x00\x34\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x08\x01\x69\x00\x6a\x00\x6b\x00\x5b\x00\x81\x00\x00\x00\x10\x01\x11\x01\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x10\x01\x11\x01\x1a\x00\x7a\x00\x9a\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\xe7\x00\xe8\x00\x23\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x4c\x00\x4d\x00\xa8\x00\xa9\x00\xaa\x00\xa7\x00\x8d\x00\xad\x00\xae\x00\xaf\x00\xe3\x00\xf9\x00\x4b\x00\x06\x00\x07\x00\x23\x00\x75\x00\x25\x00\x26\x00\xb9\x00\x28\x00\x29\x00\x18\x00\xb9\x00\x25\x00\xbb\x00\x27\x00\x9a\x00\xf5\x00\xf6\x00\x17\x00\x33\x00\x34\x00\x35\x00\x1b\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x29\x00\x00\x00\xa8\x00\xa9\x00\xaa\x00\xf5\x00\xf6\x00\xad\x00\xae\x00\xaf\x00\x3e\x00\x3f\x00\x06\x00\x41\x00\x42\x00\x43\x00\xe7\x00\xe8\x00\xdf\x00\xb9\x00\xe1\x00\xe2\x00\x87\x00\x07\x01\xe5\x00\xe6\x00\x80\x00\x81\x00\xe9\x00\x17\x00\xf5\x00\xf6\x00\x7a\x00\xe5\x00\xf9\x00\xf5\x00\xf6\x00\x2d\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\x06\x00\x07\x00\x06\x01\xf4\x00\xf5\x00\xf6\x00\x8d\x00\x01\x01\x07\x01\xe6\x00\x04\x01\x05\x01\xdf\x00\x1b\x00\xe1\x00\xe2\x00\x0a\x01\x17\x00\xe5\x00\xe6\x00\xf5\x00\xf6\x00\xe9\x00\x06\x00\xf5\x00\x1b\x00\xf7\x00\xf8\x00\xf9\x00\xe3\x00\x2c\x00\x1c\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\x08\x01\x17\x00\xf5\x00\x2c\x00\x09\x00\xf8\x00\xf9\x00\x01\x01\xf5\x00\xf6\x00\x04\x01\x05\x01\x10\x01\x11\x01\xda\x00\xdb\x00\x0a\x01\xf5\x00\x9a\x00\x06\x00\xf8\x00\xf9\x00\x1a\x00\x71\x00\x25\x00\xe5\x00\x27\x00\x75\x00\xa4\x00\x10\x01\x11\x01\x23\x00\xa8\x00\x26\x00\xaa\x00\x2d\x00\x17\x00\xad\x00\xae\x00\xaf\x00\xf4\x00\xf5\x00\xf6\x00\xe5\x00\x10\x01\x11\x01\x33\x00\x34\x00\x35\x00\xb9\x00\x3f\x00\x9c\x00\x41\x00\x42\x00\x43\x00\x1d\x00\x5a\x00\x5b\x00\xf4\x00\xf5\x00\xf6\x00\x23\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x25\x00\xe4\x00\x27\x00\x18\x00\x1a\x00\x07\x00\x09\x00\x0a\x00\x06\x00\x07\x00\x23\x00\x0d\x00\x0e\x00\x23\x00\x23\x00\xdd\x00\xde\x00\xdf\x00\xf5\x00\xe1\x00\xe2\x00\x2e\x00\x2c\x00\xe5\x00\xe6\x00\x17\x00\x3f\x00\xe9\x00\x41\x00\x42\x00\x43\x00\x56\x00\x57\x00\x58\x00\x2c\x00\x26\x00\x2e\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\x06\x00\x07\x00\x76\x00\xb3\x00\x33\x00\x34\x00\x35\x00\x01\x01\xe7\x00\xe8\x00\x04\x01\x05\x01\x1c\x00\x81\x00\x82\x00\x27\x00\x0a\x01\x17\x00\x91\x00\x92\x00\x1c\x00\x94\x00\x2e\x00\x5a\x00\x5b\x00\x20\x00\xf9\x00\x9a\x00\x23\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xa4\x00\xd1\x00\x06\x00\x07\x00\xa8\x00\xd5\x00\xaa\x00\x06\x00\x07\x00\xad\x00\xae\x00\xaf\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x17\x00\x2a\x00\xb9\x00\x18\x00\x2d\x00\x17\x00\x1c\x00\x19\x00\x01\x00\x92\x00\xf2\x00\x94\x00\x9b\x00\x1f\x00\x23\x00\x08\x00\x09\x00\x9a\x00\xfa\x00\xfb\x00\xfc\x00\x18\x00\xfe\x00\xff\x00\x00\x01\x23\x00\x25\x00\xa4\x00\x27\x00\x27\x00\x10\x00\xa8\x00\x23\x00\xaa\x00\x2c\x00\x10\x00\xad\x00\xae\x00\xaf\x00\x10\x00\xdf\x00\xf5\x00\xe1\x00\xe2\x00\xf8\x00\xf9\x00\xe5\x00\xe6\x00\xb9\x00\x9c\x00\xe9\x00\x3e\x00\x3f\x00\x29\x00\x41\x00\x42\x00\x43\x00\x75\x00\x57\x00\x58\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\x9b\x00\x10\x01\x11\x01\x9c\x00\xf2\x00\xe3\x00\x25\x00\x01\x01\x27\x00\xe7\x00\x04\x01\x05\x01\xfa\x00\xfb\x00\x1d\x00\x1c\x00\x0a\x01\x58\x00\x59\x00\xdf\x00\x23\x00\xe1\x00\xe2\x00\xf5\x00\xf6\x00\xe5\x00\xe6\x00\xf9\x00\x9c\x00\xe9\x00\x01\x00\x28\x00\x3f\x00\x2a\x00\x41\x00\x42\x00\x43\x00\x08\x00\x09\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\x1c\x00\x55\x00\x56\x00\x57\x00\x58\x00\x8a\x00\x8b\x00\x01\x01\x23\x00\xf5\x00\x04\x01\x05\x01\xf8\x00\xf9\x00\x6e\x00\x2a\x00\x0a\x01\x1d\x00\x55\x00\x56\x00\x57\x00\x58\x00\xea\x00\x39\x00\x3a\x00\xed\x00\x18\x00\xef\x00\xf5\x00\x03\x00\x9a\x00\xf8\x00\xf9\x00\x22\x00\x08\x00\x09\x00\x10\x01\x11\x01\x20\x00\xfb\x00\xa4\x00\x20\x00\xfe\x00\xff\x00\xa8\x00\x28\x00\xaa\x00\x2a\x00\x23\x00\xad\x00\xae\x00\xaf\x00\x90\x00\x91\x00\x92\x00\x10\x01\x11\x01\x5b\x00\x28\x00\x5d\x00\x2a\x00\xb9\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xf2\x00\x69\x00\x6a\x00\x6b\x00\xbc\x00\xbd\x00\xbe\x00\x9a\x00\xfa\x00\xfb\x00\xfc\x00\x2c\x00\xfe\x00\xff\x00\x00\x01\xe3\x00\x28\x00\xa4\x00\x2a\x00\xe7\x00\x28\x00\xa8\x00\x2a\x00\xaa\x00\x8c\x00\x8d\x00\xad\x00\xae\x00\xaf\x00\xdf\x00\xe9\x00\xe1\x00\xe2\x00\xf5\x00\xf6\x00\xe5\x00\xe6\x00\xf9\x00\xb9\x00\xe9\x00\xe3\x00\xf4\x00\xf5\x00\xf6\x00\xe7\x00\xf8\x00\xf9\x00\x29\x00\x2a\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xe0\x00\xe1\x00\xf5\x00\xf6\x00\xf5\x00\xf6\x00\xf9\x00\x01\x01\xf9\x00\xe9\x00\x04\x01\x05\x01\x0f\x01\x06\x00\x07\x00\xfb\x00\x0a\x01\xe3\x00\xfe\x00\xff\x00\xdf\x00\xe7\x00\xe1\x00\xe2\x00\xf8\x00\xf9\x00\xe5\x00\xe6\x00\x29\x00\x2a\x00\xe9\x00\x58\x00\x59\x00\x3a\x00\xe3\x00\xf5\x00\xf6\x00\x18\x00\xe7\x00\xf9\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\xf5\x00\xf6\x00\x01\x01\x4f\x00\xf9\x00\x04\x01\x05\x01\x29\x00\x2a\x00\x71\x00\x3a\x00\x0a\x01\x74\x00\x75\x00\x5b\x00\x28\x00\x5d\x00\x2a\x00\xe6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x18\x00\x69\x00\x6a\x00\x6b\x00\x18\x00\x3c\x00\xf5\x00\x18\x00\xf7\x00\xf8\x00\xf9\x00\xfc\x00\x18\x00\xfe\x00\xff\x00\x00\x01\x5b\x00\x0a\x00\x5d\x00\x0c\x00\x9b\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x0d\x00\x69\x00\x6a\x00\x6b\x00\x10\x01\x11\x01\x9b\x00\x5b\x00\x5c\x00\x5d\x00\x4c\x00\x4d\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x44\x00\x45\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x5a\x00\x5b\x00\x53\x00\x54\x00\x55\x00\x56\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x44\x00\x45\x00\x28\x00\x5b\x00\x2a\x00\x5d\x00\x04\x00\x05\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x06\x00\x07\x00\x6a\x00\x6b\x00\x44\x00\x45\x00\xe3\x00\x5b\x00\x2e\x00\x5d\x00\xe7\x00\x6e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x29\x00\x2a\x00\x6a\x00\x6b\x00\xf5\x00\xf6\x00\x1b\x00\x5b\x00\xf9\x00\x5d\x00\x29\x00\x2a\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x77\x00\xe6\x00\x6a\x00\x6b\x00\x5e\x00\x4e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x28\x00\x28\x00\xf5\x00\x2a\x00\xf7\x00\xf8\x00\xf9\x00\x0c\x00\x0d\x00\x0e\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x28\x00\xe6\x00\x2a\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x2a\x00\x09\x00\x2c\x00\x0b\x00\xbc\x00\xbd\x00\xbe\x00\x10\x01\x11\x01\xf5\x00\x5b\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x20\x00\x25\x00\x26\x00\x28\x00\x28\x00\x2a\x00\xf5\x00\x26\x00\xf7\x00\xf8\x00\xf9\x00\x3b\x00\x43\x00\x10\x01\x11\x01\x33\x00\x34\x00\x35\x00\x42\x00\x43\x00\x33\x00\x34\x00\x35\x00\xe5\x00\xda\x00\xdb\x00\xf5\x00\xe6\x00\x43\x00\xf8\x00\xf9\x00\x29\x00\x2a\x00\x10\x01\x11\x01\xe5\x00\x08\x00\x09\x00\xf4\x00\xf5\x00\xf6\x00\x3b\x00\xf5\x00\xe5\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\x42\x00\x43\x00\xf4\x00\xf5\x00\xf6\x00\x10\x01\x11\x01\x0c\x00\x0d\x00\x0e\x00\xf4\x00\xf5\x00\xf6\x00\x43\x00\xf5\x00\xe9\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\x18\x00\x10\x01\x11\x01\x28\x00\xf2\x00\x2a\x00\xf4\x00\xf5\x00\xf6\x00\x2c\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xf5\x00\x1c\x00\xf7\x00\xf8\x00\xf9\x00\x05\x00\x06\x00\x10\x01\x11\x01\x9d\x00\x9e\x00\x9f\x00\x06\x00\x07\x00\xf5\x00\x0d\x00\x0e\x00\xf8\x00\xf9\x00\x0f\x01\x2e\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x0d\x00\x0e\x00\x10\x01\x11\x01\x17\x00\x23\x00\x19\x00\xe5\x00\x28\x00\xa4\x00\x2a\x00\x20\x00\x1f\x00\xa8\x00\x22\x00\xaa\x00\x10\x01\x11\x01\xad\x00\xae\x00\xaf\x00\x23\x00\xf4\x00\xf5\x00\xf6\x00\xe5\x00\x1a\x00\x98\x00\x99\x00\x9a\x00\xb9\x00\x41\x00\x42\x00\x43\x00\xf5\x00\x0d\x00\x0e\x00\xf8\x00\xf9\x00\xa4\x00\xf4\x00\xf5\x00\xf6\x00\xa8\x00\x18\x00\xaa\x00\x5a\x00\x5b\x00\xad\x00\xae\x00\xaf\x00\x18\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xb9\x00\x10\x01\x11\x01\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\xdf\x00\x18\x00\xe1\x00\xe2\x00\xf2\x00\x18\x00\xe5\x00\xe6\x00\x18\x00\x28\x00\xe9\x00\x2a\x00\xfa\x00\xfb\x00\xfc\x00\x18\x00\xfe\x00\xff\x00\x00\x01\x53\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\x9d\x00\x9e\x00\x9f\x00\xdf\x00\x9b\x00\xe1\x00\xe2\x00\x01\x01\x06\x00\xe5\x00\xe6\x00\x05\x00\x06\x00\xe9\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\xcf\x00\xd0\x00\xd1\x00\x9b\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\x82\x00\x83\x00\x84\x00\x75\x00\x28\x00\xa4\x00\x2a\x00\x01\x01\x28\x00\xa8\x00\x2a\x00\xaa\x00\x0d\x00\x0e\x00\xad\x00\xae\x00\xaf\x00\x7b\x00\x7c\x00\x7d\x00\x23\x00\x28\x00\x5b\x00\x2a\x00\x5d\x00\x7e\x00\xb9\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xe9\x00\x1d\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x82\x00\x83\x00\x84\x00\x0d\x00\x0e\x00\xf4\x00\xf5\x00\xf6\x00\x25\x00\xf8\x00\xf9\x00\x23\x00\x82\x00\x83\x00\x84\x00\x25\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x2a\x00\x28\x00\xdf\x00\x2a\x00\xe1\x00\xe2\x00\xb4\x00\xb5\x00\xe5\x00\xe6\x00\x2c\x00\x0f\x01\xe9\x00\x28\x00\xf5\x00\x2a\x00\x23\x00\xf8\x00\xf9\x00\xe9\x00\x4f\x00\x50\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\x2c\x00\xf4\x00\xf5\x00\xf6\x00\x25\x00\xf8\x00\xf9\x00\x01\x01\x1e\x00\x1f\x00\x20\x00\x1d\x00\x10\x01\x11\x01\x28\x00\x5b\x00\x2a\x00\x5d\x00\x68\x00\xb3\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x0f\x01\xf2\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x82\x00\x83\x00\x84\x00\xfa\x00\xfb\x00\xfc\x00\x0d\x00\xfe\x00\xff\x00\x00\x01\x5b\x00\x28\x00\x5d\x00\x2a\x00\x17\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x0d\x00\x0e\x00\x6a\x00\x6b\x00\x2c\x00\x6d\x00\x2e\x00\xe9\x00\xbd\x00\xbe\x00\xf4\x00\xf5\x00\xf6\x00\xe6\x00\xf8\x00\xf9\x00\x0d\x00\x0e\x00\xf4\x00\xf5\x00\xf6\x00\x1f\x00\xf8\x00\xf9\x00\x2a\x00\xf2\x00\x2c\x00\x1b\x00\xf5\x00\x1d\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\x10\x00\xfe\x00\xff\x00\x00\x01\x18\x00\x1b\x00\x5b\x00\x1d\x00\x5d\x00\x0f\x01\xb3\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x10\x01\x11\x01\x6a\x00\x6b\x00\x49\x00\x6d\x00\x6e\x00\x5b\x00\xb1\x00\x5d\x00\xb3\x00\x1c\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xb3\x00\x1d\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x7a\x00\xb9\x00\x5b\x00\xbb\x00\x5d\x00\x0d\x00\x0e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x1d\x00\xe6\x00\x6a\x00\x6b\x00\x28\x00\x6d\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x1b\x00\xf2\x00\x0f\x00\x10\x00\xf5\x00\x25\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\x1d\x00\xfe\x00\xff\x00\x00\x01\x4e\x00\x85\x00\xe6\x00\xbc\x00\xbd\x00\xbe\x00\xb3\x00\x9c\x00\xf4\x00\xf5\x00\xf6\x00\x1d\x00\xf8\x00\xf9\x00\xf2\x00\x10\x01\x11\x01\xf5\x00\x48\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\x5b\x00\x17\x00\x5d\x00\x0d\x00\x0e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x10\x00\x69\x00\x6a\x00\x6b\x00\xbc\x00\xbd\x00\xbe\x00\x10\x01\x11\x01\x82\x00\x83\x00\x84\x00\x82\x00\x83\x00\x84\x00\x10\x00\x5b\x00\x2a\x00\x5d\x00\x61\x00\xe6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x1b\x00\x69\x00\x6a\x00\x6b\x00\x0d\x00\x0e\x00\xf5\x00\x29\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\xeb\x00\x0d\x00\x0e\x00\xee\x00\x23\x00\xf0\x00\xf5\x00\xf2\x00\xf7\x00\xf8\x00\xf9\x00\x18\x00\xe6\x00\x10\x01\x11\x01\xfa\x00\xfb\x00\xfc\x00\x0d\x00\xfe\x00\xff\x00\x00\x01\x2a\x00\xfa\x00\xfb\x00\x17\x00\x18\x00\xf5\x00\x23\x00\xf7\x00\xf8\x00\xf9\x00\x4e\x00\x10\x01\x11\x01\x5b\x00\x29\x00\x5d\x00\x17\x00\x18\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x0d\x00\x0e\x00\x6a\x00\x6b\x00\x9b\x00\x6d\x00\x10\x01\x11\x01\x5b\x00\x0a\x00\x5d\x00\x0d\x00\x0e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x2c\x00\x69\x00\x6a\x00\x6b\x00\xe0\x00\xe1\x00\x0d\x00\x0e\x00\xe6\x00\x23\x00\xf5\x00\xf6\x00\x10\x00\xe9\x00\x29\x00\x2a\x00\xfe\x00\xff\x00\x7c\x00\x7d\x00\xfe\x00\xff\x00\xf2\x00\xf5\x00\x9b\x00\xf7\x00\xf8\x00\xf9\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\x23\x00\x5b\x00\x1f\x00\x5d\x00\x29\x00\xe6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x2a\x00\x69\x00\x6a\x00\x6b\x00\x10\x01\x11\x01\xf5\x00\x9b\x00\xf7\x00\xf8\x00\xf9\x00\x71\x00\x72\x00\xf5\x00\xf6\x00\x9b\x00\x5b\x00\x9b\x00\x5d\x00\x0d\x00\x0e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x9b\x00\x69\x00\x6a\x00\x6b\x00\x10\x01\x11\x01\x72\x00\x5b\x00\x9b\x00\x5d\x00\x0d\x00\x0e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x9b\x00\x69\x00\x6a\x00\x6b\x00\x0d\x00\x0e\x00\x2c\x00\x5b\x00\x1b\x00\x5d\x00\xe6\x00\x43\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xe5\x00\x69\x00\x6a\x00\x6b\x00\xe9\x00\xf5\x00\x1c\x00\xf7\x00\xf8\x00\xf9\x00\x2d\x00\xe6\x00\x1d\x00\x29\x00\x2a\x00\xf4\x00\xf5\x00\xf6\x00\x2c\x00\xf8\x00\xf9\x00\x23\x00\x10\x00\x2c\x00\x2c\x00\x2c\x00\xf5\x00\x06\x00\xf7\x00\xf8\x00\xf9\x00\x18\x00\x10\x01\x11\x01\x5b\x00\x18\x00\x5d\x00\x60\x00\x6e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x23\x00\x69\x00\x6a\x00\x6b\x00\x65\x00\x7d\x00\x10\x01\x11\x01\x7d\x00\x69\x00\xe6\x00\x2c\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x29\x00\x18\x00\x23\x00\x7d\x00\x7d\x00\x7d\x00\xf5\x00\x2a\x00\xf7\x00\xf8\x00\xf9\x00\x9b\x00\x9b\x00\x29\x00\x9b\x00\x20\x00\x5b\x00\x0d\x00\x5d\x00\x29\x00\xe6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x69\x00\x69\x00\x6a\x00\x6b\x00\x10\x01\x11\x01\xf5\x00\x10\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\x18\x00\x9b\x00\x1b\x00\x20\x00\x33\x00\x23\x00\x06\x00\x07\x00\x18\x00\x1b\x00\x0a\x00\x9b\x00\x0c\x00\x7d\x00\xf5\x00\x9b\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\x18\x00\x10\x01\x11\x01\x17\x00\x23\x00\x19\x00\x17\x00\x2a\x00\x18\x00\x0d\x00\x67\x00\x1f\x00\x23\x00\x20\x00\xf5\x00\x1d\x00\xf7\x00\xf8\x00\xf9\x00\x2c\x00\x28\x00\x10\x01\x11\x01\x5b\x00\x7d\x00\x5d\x00\x1c\x00\x23\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x1c\x00\x69\x00\x6a\x00\x6b\x00\x1c\x00\x10\x01\x11\x01\x5b\x00\x29\x00\x5d\x00\xe6\x00\x65\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x7d\x00\x69\x00\x6a\x00\x6b\x00\x2c\x00\xf5\x00\x1c\x00\xf7\x00\xf8\x00\xf9\x00\x25\x00\x65\x00\x25\x00\x7d\x00\x2c\x00\x1b\x00\x23\x00\x5f\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x6d\x00\xf5\x00\x7c\x00\x1c\x00\xf8\x00\xf9\x00\x1c\x00\x65\x00\x69\x00\x10\x01\x11\x01\x5b\x00\x18\x00\x5d\x00\x29\x00\xe6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x1c\x00\x69\x00\x6a\x00\x6b\x00\x10\x01\x11\x01\xf5\x00\x26\x00\xf7\x00\xf8\x00\xf9\x00\x7d\x00\x9b\x00\x23\x00\x28\x00\x9b\x00\x5b\x00\x2a\x00\x5d\x00\x49\x00\x23\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x18\x00\x69\x00\x6a\x00\x6b\x00\x10\x01\x11\x01\x18\x00\x5b\x00\x0d\x00\x5d\x00\x29\x00\x2e\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x1c\x00\x69\x00\x6a\x00\x6b\x00\x18\x00\x1d\x00\x1d\x00\x5b\x00\x06\x00\x5d\x00\xe6\x00\x1d\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xe9\x00\x69\x00\x6a\x00\x6b\x00\x17\x00\xf5\x00\x23\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\xf4\x00\xf5\x00\xf6\x00\x18\x00\xf8\x00\xf9\x00\x29\x00\x68\x00\x1c\x00\x4c\x00\x1d\x00\x9b\x00\x4c\x00\x18\x00\xf5\x00\x2a\x00\xf7\x00\xf8\x00\xf9\x00\x2a\x00\x1b\x00\x10\x01\x11\x01\x5b\x00\x18\x00\x5d\x00\x23\x00\x0f\x01\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x17\x00\x69\x00\x6a\x00\x6b\x00\x18\x00\x10\x01\x11\x01\x5b\x00\x29\x00\x5d\x00\xe6\x00\x7d\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x65\x00\x69\x00\x6a\x00\x6b\x00\x65\x00\xf5\x00\x2c\x00\xf7\x00\xf8\x00\xf9\x00\x18\x00\x2e\x00\x2c\x00\x18\x00\x09\x00\x09\x00\x19\x00\xba\x00\x64\x00\xe6\x00\x02\x01\x6f\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x03\x01\x0d\x01\xbf\x00\xb3\x00\xa6\x00\xb3\x00\x10\x01\x11\x01\xf5\x00\x1a\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\x0d\x01\x03\x01\xf9\x00\xf9\x00\x1b\x00\x26\x00\x0c\x01\x03\x01\x36\x00\x0a\x00\x51\x00\x26\x00\x51\x00\x28\x00\xf5\x00\x51\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\x51\x00\x10\x01\x11\x01\x03\x01\x33\x00\x34\x00\x35\x00\xd8\x00\x03\x00\xbf\x00\x03\x01\x03\x01\x8e\x00\x03\x01\xf5\x00\xfb\x00\xf7\x00\xf8\x00\xf9\x00\x51\x00\x4c\x00\x10\x01\x11\x01\x5b\x00\x4c\x00\x5d\x00\x03\x01\x73\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x1c\x00\xf9\x00\x6a\x00\x6b\x00\x76\x00\x10\x01\x11\x01\x5b\x00\x0d\x01\x5d\x00\xe6\x00\x9b\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x9b\x00\x9f\x00\x6a\x00\x6b\x00\x4d\x00\xf5\x00\x2f\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\x8f\x00\x36\x00\x95\x00\x34\x00\x30\x00\x52\x00\x50\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\xba\x00\xd1\x00\xf5\x00\xa6\x00\xf7\x00\xf8\x00\xf9\x00\x11\x00\x6f\x00\x10\x01\x11\x01\x5b\x00\x0d\x01\x5d\x00\xba\x00\x35\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x09\x01\x02\x01\x6a\x00\x6b\x00\x6f\x00\x10\x01\x11\x01\x5b\x00\x02\x01\x5d\x00\x84\x00\x02\x01\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x9b\x00\x76\x00\x6a\x00\x6b\x00\x0c\x01\x1d\x00\x18\x00\x5b\x00\x03\x01\x5d\x00\x37\x00\xd1\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x0d\x01\x02\x01\x6a\x00\x6b\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\xf9\x00\x03\x01\x03\x01\x03\x01\x93\x00\x32\x00\x03\x01\x5b\x00\x11\x00\x5d\x00\xe6\x00\x03\x01\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xe9\x00\x2f\x00\x6a\x00\x6b\x00\x31\x00\xf5\x00\x76\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\xf4\x00\xf5\x00\xf6\x00\x2a\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\x10\x01\x11\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\x0f\x01\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x10\x01\x11\x01\x5b\x00\xff\xff\x5d\x00\xe6\x00\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\xf5\x00\xe9\x00\xf7\x00\xf8\x00\xf9\x00\xe6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf4\x00\xf5\x00\xf6\x00\xff\xff\xf8\x00\xf9\x00\xff\xff\xff\xff\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xe6\x00\xff\xff\x10\x01\x11\x01\x9c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x01\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\x10\x01\x11\x01\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xe6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x10\x01\x11\x01\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x10\x01\x11\x01\xff\xff\xff\xff\xff\xff\xe6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xeb\x00\xff\xff\xff\xff\xee\x00\xff\xff\xf0\x00\xff\xff\xf2\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xe6\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xff\xff\xfe\x00\xff\x00\x00\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\x10\x01\x11\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x10\x01\x11\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xe6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\xff\xff\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xe6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\x6a\x00\x6b\x00\x10\x01\x11\x01\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\x6b\x00\x10\x01\x11\x01\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xe6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xe6\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xe6\x00\x5b\x00\x10\x01\x11\x01\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\x10\x01\x11\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0b\x01\xff\xff\xff\xff\xff\xff\xff\xff\x10\x01\x11\x01\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xe6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\x10\x01\x11\x01\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xff\xff\xe6\x00\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xf5\x00\x0b\x01\xf7\x00\xf8\x00\xf9\x00\xff\xff\x10\x01\x11\x01\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe6\x00\x10\x01\x11\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xf5\x00\xff\xff\xff\xff\xf8\x00\xf9\x00\xff\xff\xff\xff\x10\x01\x11\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x10\x01\x11\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\xff\xff\x5d\x00\xff\xff\xe6\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\x5e\x00\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x00\x10\x01\x11\x01\xf8\x00\xf9\x00\xff\xff\xff\xff\xe6\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\x10\x01\x11\x01\xff\xff\xff\xff\xff\xff\xff\xff\x5e\x00\xff\xff\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xff\xff\xff\xff\xe6\x00\xff\xff\xff\xff\xff\xff\x10\x01\x11\x01\x5f\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\x7e\x00\x7f\x00\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe6\x00\xff\xff\xff\xff\xff\xff\xf4\x00\xf5\x00\xf6\x00\xff\xff\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\x10\x01\x11\x01\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xe6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\x0f\x01\xff\xff\xff\xff\xff\xff\xf5\x00\xff\xff\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\x10\x01\x11\x01\xe9\x00\xff\xff\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\x23\x00\xff\xff\x25\x00\x26\x00\xf5\x00\x28\x00\x29\x00\xf8\x00\xf9\x00\xb9\x00\x10\x01\x11\x01\xff\xff\xff\xff\xff\xff\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\xff\xff\xff\xff\xee\x00\xff\xff\x10\x01\x11\x01\xf2\x00\xff\xff\xff\xff\xf5\x00\xff\xff\xff\xff\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xff\xff\xff\xff\xff\xff\xe9\x00\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xf5\x00\xff\xff\xff\xff\xf8\x00\xf9\x00\x10\x01\x11\x01\x12\x01\x13\x01\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xf5\x00\xff\xff\xff\xff\xf8\x00\xf9\x00\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\x10\x01\x11\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x10\x01\x11\x01\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xe9\x00\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xf4\x00\xf5\x00\xf6\x00\x2b\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x0f\x01\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\xff\xff\x76\x00\xff\xff\x78\x00\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xff\xff\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x92\x00\x93\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\x9a\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\x18\x00\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x26\x00\x19\x00\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\x6d\x00\xff\xff\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\xff\xff\x76\x00\xff\xff\x78\x00\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xff\xff\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x92\x00\x93\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\xff\xff\x76\x00\xff\xff\x78\x00\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xff\xff\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x92\x00\x93\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9a\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\x64\x00\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xe9\x00\x6b\x00\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\x71\x00\xff\xff\xff\xff\x74\x00\xf4\x00\xf5\x00\xf6\x00\xff\xff\xf8\x00\xf9\x00\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x0f\x01\xff\xff\xff\xff\x93\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\x64\x00\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\x6f\x00\x70\x00\x71\x00\xff\xff\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x93\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xeb\x00\x68\x00\x69\x00\xee\x00\x6b\x00\xf0\x00\xff\xff\xf2\x00\x6f\x00\x70\x00\x71\x00\xff\xff\xff\xff\x74\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xff\xff\xfe\x00\xff\x00\x00\x01\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x93\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xeb\x00\x68\x00\x69\x00\xee\x00\x6b\x00\xf0\x00\xff\xff\xf2\x00\x6f\x00\x70\x00\x71\x00\xff\xff\xff\xff\x74\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xff\xff\xfe\x00\xff\x00\x00\x01\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x93\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x74\x00\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x93\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x74\x00\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x93\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xeb\x00\x68\x00\x69\x00\xee\x00\x6b\x00\xf0\x00\xff\xff\xf2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x74\x00\xff\xff\xfa\x00\xfb\x00\xfc\x00\xff\xff\xfe\x00\xff\x00\x00\x01\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\x93\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\xff\xff\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\xff\xff\x0c\x00\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\x8e\x00\x8f\x00\x24\x00\x25\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\x2e\x00\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\xf4\x00\xf5\x00\xf6\x00\xff\xff\xf8\x00\xf9\x00\xff\xff\x3d\x00\x3e\x00\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xf4\x00\xf5\x00\xf6\x00\xff\xff\xf8\x00\xf9\x00\xff\xff\x0f\x01\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\x0a\x00\x7e\x00\x0c\x00\x0d\x00\x81\x00\x82\x00\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\x19\x00\xff\xff\x8e\x00\x8f\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\xff\xff\x0c\x00\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\x8e\x00\x8f\x00\x24\x00\x25\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\xff\xff\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x23\x00\xff\xff\x25\x00\x26\x00\xff\xff\x28\x00\x29\x00\x2a\x00\xff\xff\x2c\x00\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x33\x00\x34\x00\x35\x00\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\x0d\x00\x81\x00\x82\x00\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\x1a\x00\x8e\x00\x8f\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\x20\x00\x21\x00\x8e\x00\x8f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\x20\x00\x21\x00\x8e\x00\x8f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\x52\x00\x21\x00\x8e\x00\x8f\x00\x24\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x72\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\x0d\x00\x81\x00\x82\x00\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\x19\x00\xff\xff\x8e\x00\x8f\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\x52\x00\x21\x00\x8e\x00\x8f\x00\x24\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\xff\xff\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x72\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\x1c\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\x8e\x00\x8f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x69\x00\xff\xff\x6b\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x7e\x00\x19\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\xff\xff\xff\xff\x6b\x00\xff\xff\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x72\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\x18\x00\x7e\x00\x7f\x00\x0d\x00\x81\x00\x82\x00\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\xff\xff\x17\x00\x26\x00\x19\x00\x28\x00\x8e\x00\x8f\x00\xff\xff\xff\xff\x1f\x00\x2e\x00\x21\x00\xff\xff\xff\xff\x24\x00\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\x8e\x00\x8f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\x8e\x00\x8f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x69\x00\xff\xff\x6b\x00\x06\x00\x07\x00\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x7e\x00\x19\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\x32\x00\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\x8e\x00\x8f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\x8e\x00\x8f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\x8e\x00\x8f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\x8e\x00\x8f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x6b\x00\x06\x00\x07\x00\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x7e\x00\x19\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\x8e\x00\x8f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x6b\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x7e\x00\x19\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x6b\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x7e\x00\x19\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x6b\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\xff\xff\xff\xff\x10\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x7e\x00\x19\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\xff\xff\x46\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\xff\xff\x28\x00\x29\x00\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x8f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\x1a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\x1a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\x2c\x00\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\x25\x00\x26\x00\xff\xff\x28\x00\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\x79\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\x79\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\x7a\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\x1b\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\x7a\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\x1c\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x74\x00\xff\xff\xff\xff\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\x00\x8a\x00\x8b\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x74\x00\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x30\x00\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\x21\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3a\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\xff\xff\x0a\x00\xff\xff\x0c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x1f\x00\xff\xff\x06\x00\x07\x00\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\x75\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x1f\x00\xff\xff\x06\x00\x07\x00\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xad\x00\xae\x00\xaf\x00\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x68\x00\x69\x00\xff\xff\x6b\x00\xb9\x00\x01\x00\xff\xff\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\x75\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x1f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x24\x00\x09\x00\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\x17\x00\xff\xff\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\x26\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x33\x00\x34\x00\x35\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\x68\x00\x69\x00\x01\x00\x6b\x00\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\x81\x00\x82\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x68\x00\x69\x00\x01\x00\x6b\x00\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\x81\x00\x82\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\x01\x00\x6b\x00\x03\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\x81\x00\x82\x00\x68\x00\x69\x00\x01\x00\x6b\x00\x03\x00\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\x24\x00\xff\xff\xff\xff\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x81\x00\x82\x00\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x1c\x00\x81\x00\x82\x00\x68\x00\x69\x00\xff\xff\x6b\x00\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\x75\x00\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x01\x00\xff\xff\x03\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x1d\x00\xff\xff\x68\x00\x69\x00\x06\x00\x6b\x00\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x18\x00\xff\xff\x7e\x00\x7f\x00\x01\x00\x81\x00\x82\x00\xff\xff\xff\xff\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x68\x00\x69\x00\x01\x00\x6b\x00\x03\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\x81\x00\x82\x00\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\x03\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7b\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x01\x00\xff\xff\xff\xff\x68\x00\x69\x00\x06\x00\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x17\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x81\x00\x82\x00\x68\x00\x69\x00\x06\x00\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\x01\x00\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\x81\x00\x82\x00\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\x19\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x01\x00\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\x17\x00\x81\x00\x82\x00\x68\x00\x69\x00\x01\x00\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\x81\x00\x82\x00\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\x01\x00\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\x81\x00\x82\x00\x68\x00\x69\x00\x01\x00\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x17\x00\x81\x00\x82\x00\x68\x00\x69\x00\x01\x00\x6b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x81\x00\x82\x00\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x17\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x81\x00\x82\x00\x68\x00\x69\x00\xff\xff\x6b\x00\xff\xff\xff\xff\xff\xff\x26\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\x7e\x00\x7f\x00\x01\x00\x81\x00\x82\x00\xff\xff\xff\xff\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\x26\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x01\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\x6b\x00\x17\x00\x52\x00\x53\x00\x54\x00\x55\x00\x01\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x26\x00\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\x6b\x00\x17\x00\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\x01\x00\x6b\x00\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\x01\x00\xff\xff\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\x01\x00\xff\xff\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\x6b\x00\x52\x00\x53\x00\x54\x00\x55\x00\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\x01\x00\xff\xff\x81\x00\x82\x00\xff\xff\x06\x00\x6b\x00\x08\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7e\x00\xff\xff\xff\xff\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xff\xff\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xff\xff\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc5\x00\xc6\x00\xc7\x00\xff\xff\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc6\x00\xc7\x00\xff\xff\xc9\x00\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xd2\x00\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xb9\x00\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\x01\x01\xd7\x00\xff\xff\xd9\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xb9\x00\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xb9\x00\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\x01\x01\xd7\x00\xff\xff\xd9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc8\x00\xc9\x00\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xd2\x00\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xb9\x00\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\x01\x01\xd7\x00\xff\xff\xd9\x00\xff\xff\xac\x00\xad\x00\xae\x00\xaf\x00\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xb9\x00\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xb9\x00\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\x01\x01\xd7\x00\xff\xff\xd9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc8\x00\xc9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc8\x00\xc9\x00\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xd2\x00\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xb9\x00\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xd9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xc9\x00\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd3\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x01\x01\x02\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xb0\x00\xff\xff\xff\xff\xb3\x00\xb4\x00\xff\xff\xb6\x00\xff\xff\xb8\x00\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xb0\x00\xff\xff\xff\xff\xb3\x00\xb4\x00\xff\xff\xb6\x00\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb6\x00\xff\xff\xff\xff\xb9\x00\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xc2\x00\xc3\x00\xe9\x00\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xff\xff\xfd\x00\xff\xff\xff\x00\x00\x01\x01\x01\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xff\xff\xfd\x00\xff\xff\xff\x00\x00\x01\x01\x01\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb6\x00\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xc3\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xca\x00\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xb6\x00\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xff\xff\xfd\x00\xff\xff\xff\x00\x00\x01\x01\x01\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xff\xff\xfd\x00\xff\xff\xff\x00\x00\x01\x01\x01\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xb2\x00\xff\xff\xff\xff\xff\xff\xb6\x00\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb6\x00\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xff\xff\xfd\x00\xff\xff\xff\x00\x00\x01\x01\x01\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xff\xff\xfd\x00\xff\xff\xff\x00\x00\x01\x01\x01\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb6\x00\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb6\x00\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xff\xff\xfd\x00\xff\xff\xff\x00\x00\x01\x01\x01\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xff\xff\xfd\x00\xff\xff\xff\x00\x00\x01\x01\x01\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb6\x00\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xec\x00\xff\xff\xee\x00\xff\xff\xff\xff\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xff\xff\xfd\x00\xff\xff\xff\x00\x00\x01\x01\x01\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xcd\x00\xce\x00\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xce\x00\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xb7\x00\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb8\x00\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb7\x00\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd2\x00\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\x01\x01\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xa5\x00\xff\xff\xe9\x00\xa8\x00\xa9\x00\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xb9\x00\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xa8\x00\xff\xff\xaa\x00\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xac\x00\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x01\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xb9\x00\xff\xff\xff\xff\xbc\x00\xbd\x00\xbe\x00\x01\x01\xc0\x00\xc1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xff\xff\xff\xff\xbc\x00\xbd\x00\xbe\x00\xff\xff\xc0\x00\xc1\x00\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x01\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x01\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x01\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x01\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x01\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xad\x00\xae\x00\xaf\x00\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xb9\x00\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\x01\x01\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x01\xff\xff\xdf\x00\xff\xff\xe1\x00\xe2\x00\xff\xff\xff\xff\xe5\x00\xe6\x00\xff\xff\xff\xff\xe9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\x12\x00\x0e\x00\x10\x00\xa8\x00\x14\x00\xa9\x00\xae\x03\xaf\x03\xb0\x03\x0c\x00\xf0\x04\x22\x05\x08\x05\xb0\x00\xa0\x00\x59\x02\x85\x03\xb3\x02\xb4\x02\xb5\x00\x51\x02\xb5\x00\x1b\x02\xff\x00\x67\x03\xb5\x00\x51\x02\x23\x05\x24\x05\xf7\x03\xb0\x00\xcc\x03\xb3\x02\xb4\x02\x47\x02\x72\x04\x73\x04\x50\x02\xb5\x00\xa7\x04\xb1\x00\xae\xff\xb0\x00\x8a\x04\xb5\x00\xa7\x04\x30\x05\xb5\x00\x1b\x02\x80\x03\xb5\x00\xf0\x02\x33\x03\x50\x02\xb0\x00\x04\x01\xb5\x00\xf0\x02\xb5\x00\xad\x04\xda\x01\xb5\x00\xad\x04\xc2\x02\x4f\x04\xb5\x00\xbc\x04\x54\x02\x91\x02\xfe\x00\xca\x03\x84\x00\xf8\x00\x52\x02\x80\x03\xe0\x01\x5f\x04\x19\xfd\xa7\x01\xa0\x01\xb5\x00\xbc\x04\x7a\x03\x7e\x03\x18\x02\x50\x02\xb5\x00\xf4\x04\x76\x01\xa0\x01\xb5\x00\xf4\x04\x7e\x04\xa3\x00\x8c\x04\x8d\x04\xd5\x04\x02\x05\x23\x04\xf9\x00\x55\x05\x77\x01\xae\x00\xdb\x00\xaf\x00\xdd\x00\x50\x02\x31\x00\x32\x00\xa1\x01\x8e\x04\x60\x04\x8e\x04\xf9\x00\x89\x00\xdb\x01\xf9\x00\xff\xff\x7b\x03\xa1\x01\x90\x03\x9a\x04\x73\x04\xdb\x01\x89\x00\xc9\x04\x24\x04\x50\x04\x19\x02\x5a\x00\xa0\x01\x5b\x00\x5c\x00\xe0\x00\xf6\x04\x17\x00\x1a\x02\xdd\x02\xf5\x04\xdb\x00\x4c\x02\x4d\x02\xa4\x04\xcd\x03\xb4\x02\x80\x04\xc4\x02\xb0\x00\x2b\x03\xd6\x04\xd7\x04\x6e\x02\x8c\x00\x17\x00\xe7\x01\xca\x01\xe8\x01\x43\x05\xd2\x04\x19\xfd\xa1\x01\x4e\x02\xea\x01\xeb\x01\xde\x02\x14\x03\xbb\x04\x89\x00\xec\x01\x8a\x00\x32\x00\xbe\x04\xb5\x02\x31\x00\x32\x00\xa9\x04\xed\x01\x84\x03\xb0\x00\xf8\x03\xee\x01\xa8\x04\xef\x01\xf0\x01\xf1\x01\x37\x03\xbd\x04\xb5\x02\x9d\x03\xaf\x04\x2e\x00\x95\x01\xae\x04\x34\x02\x48\x02\x8c\x00\xf9\x03\x2e\x00\x74\x04\x1a\x03\xd7\x00\xe7\x01\x81\x03\xe8\x01\xc7\x01\x2e\x00\x95\x01\xb2\x00\x9e\x03\xea\x01\xeb\x01\x7f\x03\xf1\x04\x22\x03\x89\x00\xec\x01\x8a\x00\x32\x00\xb1\x03\x89\x01\x1d\x02\x25\x05\x7a\x02\xed\x01\xb2\x00\x26\x05\x55\x02\xee\x01\x65\x05\xef\x01\xf0\x01\xf1\x01\x53\x02\x2d\x00\x2e\x00\x2f\x00\xb2\x00\x31\x00\x32\x00\x2e\x00\x95\x01\xf3\x02\x09\x05\x96\x01\x57\x05\x58\x05\x1c\x02\xf1\x02\xb2\x00\xbf\x01\x47\x03\xc0\x01\xc1\x01\xb1\x03\x0d\x00\x0d\x00\x0d\x00\x7a\x02\x0d\x00\x0d\x00\xb2\x03\xa1\x00\xa1\x00\x0d\x00\x27\x05\x2d\x00\x2e\x00\x2f\x00\x2d\x00\x2e\x00\x2f\x00\xf2\x01\x31\x00\x32\x00\x0f\x00\x13\x00\x11\x00\xf8\x03\x3a\x00\xf3\x01\x1a\x00\xf4\x01\x1c\x00\x2e\x00\x74\x04\x1d\x00\x1e\x00\x1f\x00\xd0\x04\xd1\x04\x20\x00\x21\x00\x22\x00\x25\x05\xf9\x03\xb2\x03\x89\x00\x26\x05\xb5\x02\x50\x02\xbf\x04\x8f\x04\x23\x00\x8f\x04\xd8\x01\x90\x04\x46\x03\x90\x04\xd9\x01\xa3\x01\xa4\x01\x2e\x00\x95\x01\xda\x01\x50\x02\x96\x01\x2e\x00\x95\x01\xf2\x01\x2e\x00\x95\x01\x2e\x00\x95\x01\x96\x01\x45\x05\x96\x01\xf3\x01\x1a\x00\xf4\x01\x1c\x00\x61\x04\x89\x00\x1d\x00\x1e\x00\x1f\x00\xff\xff\x27\x05\x20\x00\x21\x00\x22\x00\x26\x00\x47\x02\x27\x00\x28\x00\x70\x02\x08\x04\x29\x00\x2a\x00\x89\x00\x23\x00\x2b\x00\x09\x04\x81\x04\x3c\x01\x84\x00\x3c\x02\x82\x04\xe0\x01\x57\x04\x8c\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x2d\x00\x2e\x00\x2f\x00\x39\x02\x31\x00\x32\x00\x5f\x05\x33\x00\xe4\x04\x8c\x00\xf5\x01\xf6\x01\x38\x03\xa4\x01\xe1\x01\x39\x03\xf7\x01\x3a\x03\x08\x04\x69\x01\x26\x00\x3a\x02\x27\x00\x28\x00\x1e\x05\xb9\x04\x29\x00\x2a\x00\xcf\x00\x3b\x03\x2b\x00\xa5\x01\x3c\x03\xd7\x00\xd2\x04\xb1\x02\xb2\x02\xb3\x02\xb4\x02\x3b\x03\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xc0\x04\x32\x00\x31\x00\x32\x00\xbc\x03\x8f\x04\xe7\x01\x33\x00\xe8\x01\x90\x04\xf5\x01\xf6\x01\xbd\x03\xe9\x01\xea\x01\xeb\x01\xf7\x01\x8c\x01\x8d\x01\x8e\x01\xec\x01\x3b\x02\x8f\x04\x2e\x00\x95\x01\x2a\x05\x90\x04\x96\x01\xed\x01\x30\x00\x3c\x02\xc3\x01\xee\x01\x41\x03\xef\x01\xf0\x01\xf1\x01\xda\x00\xdb\x00\x4c\x04\x2e\x00\x95\x01\xcf\x00\x96\x01\x96\x01\xe7\x01\x47\x03\xe8\x01\x36\x03\x89\x00\x14\x02\x6a\x01\x42\x03\xd5\x04\x3f\x03\x0d\x05\x0b\x05\x2e\x00\x95\x01\xec\x01\x89\x00\x2d\x00\x2e\x00\x2f\x00\xb0\x00\x3e\x03\xdf\x00\xed\x01\x15\x02\x38\x02\x16\x02\xee\x01\x37\x03\xef\x01\xf0\x01\xf1\x01\x48\x02\x8c\x00\xc7\x01\xe2\x00\x60\x01\xe4\x00\x89\x00\x2e\x00\xdc\x03\x8a\x00\x32\x00\x48\x02\x8c\x00\x7b\x00\x95\x00\x7c\x00\x89\x00\x96\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xdd\x03\x0c\x05\x86\x00\x87\x00\x2f\x02\x34\x05\xff\xff\x3d\x01\x8c\x00\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x48\x02\x8c\x00\xce\x00\x14\x04\xf2\x01\xda\x00\xdb\x00\xdc\x00\xdd\x00\xae\x02\xaf\x02\xcf\x00\xf3\x01\x1a\x00\xf4\x01\x1c\x00\x8c\x03\x8d\x03\x1d\x00\x1e\x00\x1f\x00\x77\x04\x15\x04\x20\x00\x21\x00\x22\x00\xb5\x02\x96\x01\xd5\x04\x3a\x00\x3b\x00\xe1\x02\xb0\x00\x7f\x01\xdf\x00\x23\x00\xe0\x00\xe2\x02\x36\x02\x15\x02\xe7\x01\x16\x02\xe8\x01\xf2\x01\x2e\x00\x95\x01\x80\x04\xe2\x00\x60\x01\xe4\x00\x50\x02\xf3\x01\x1a\x00\xf4\x01\x1c\x00\x37\x02\xff\xff\x1d\x00\x1e\x00\x1f\x00\x2e\x00\x71\x03\x20\x00\x21\x00\x22\x00\x63\x02\x64\x02\x3a\x00\xef\x01\xf0\x01\xf1\x01\xc6\x02\xc7\x02\x26\x00\x23\x00\x27\x00\x28\x00\x86\x01\x72\x03\x29\x00\x2a\x00\x54\x05\xd7\x04\x2b\x00\xb1\x02\x2e\x00\xc8\x02\x3d\x05\x47\x03\x96\x01\x2e\x00\x71\x03\x95\xfd\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x3a\x00\x3b\x00\xc9\x02\x2d\x00\x2e\x00\x2f\x00\x3e\x05\x33\x00\xde\x03\x88\x00\xf5\x01\xf6\x01\x26\x00\x50\x02\x27\x00\x28\x00\xf7\x01\x69\x03\x29\x00\x2a\x00\x2e\x00\xdc\x03\x2b\x00\x3a\x00\x89\x00\x50\x02\x30\x00\x8a\x00\x32\x00\x2b\x05\x91\x02\x79\x01\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x9f\x04\xb1\x02\x89\x00\x91\x02\xda\x00\x8a\x00\x32\x00\x33\x00\x2e\x00\x95\x01\xf5\x01\xf6\x01\x8b\x00\x8c\x00\xb3\x01\xb4\x01\xf7\x01\x89\x00\xf2\x01\x3a\x00\xb0\x01\x32\x00\xce\x01\xf2\x03\xe7\x01\xb5\x01\xe8\x01\xac\x04\x65\x02\x8b\x00\x8c\x00\xc7\x01\x1d\x00\xdf\x00\x1f\x00\x78\x01\xb1\x02\x20\x00\x21\x00\x22\x00\x2d\x00\x2e\x00\x2f\x00\x47\x03\x2c\x02\x8c\x00\xe2\x00\x60\x01\xe4\x00\x23\x00\xdd\x04\xff\xff\xef\x01\xf0\x01\xf1\x01\x1c\x05\x69\x03\x6a\x03\x2d\x00\x2e\x00\x2f\x00\x1d\x05\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xe7\x01\x52\x04\xe8\x01\xc6\x01\xcb\x01\x9a\x01\xda\x00\xdb\x00\x3a\x00\x3b\x00\x36\x03\xb5\x00\x9b\x01\xcf\x00\xc7\x01\x66\x02\x67\x02\x26\x00\xf9\x03\x27\x00\x28\x00\xc8\x03\x6a\x01\x29\x00\x68\x02\x80\x04\xdd\x04\x2b\x00\xef\x01\xf0\x01\xf1\x01\xd0\x03\xba\x02\xbb\x02\xc9\x01\xdf\x00\xca\x01\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x3a\x00\x3b\x00\xd7\x02\xd1\x00\xe2\x00\x60\x01\xe4\x00\x33\x00\xae\x02\xdb\x03\xf5\x01\xf6\x01\xfb\x00\xd8\x02\xd9\x02\x29\x03\xf7\x01\xc2\x04\xde\x04\xdf\x04\xb4\x00\xe0\x04\xca\x01\xb0\x04\x6a\x03\x71\x02\x96\x01\xf2\x01\x3c\x02\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x65\x02\x8e\x02\x3a\x00\x3b\x00\x1d\x00\x8f\x02\x1f\x00\x3a\x00\x3b\x00\x20\x00\x21\x00\x22\x00\xe7\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x80\x04\x6e\x03\x23\x00\xff\x04\x6f\x03\xbf\x00\xfb\x00\xc0\x00\x8e\x01\x35\x05\xd2\x00\xe0\x04\xba\x00\xc1\x00\x00\x05\x8f\x01\xac\x00\xf2\x01\xd3\x00\xd4\x00\xd5\x00\x5d\x05\xd6\x00\xd7\x00\xd8\x00\xd2\x01\xe7\x01\x65\x02\xe8\x01\xd3\x01\xf8\x00\x1d\x00\x5e\x05\x1f\x00\xd4\x01\xf7\x00\x20\x00\x21\x00\x22\x00\xf6\x00\x26\x00\x89\x00\x27\x00\x28\x00\x8a\x00\x32\x00\x29\x00\x2a\x00\x23\x00\xff\xff\x2b\x00\x63\x02\x64\x02\xe5\x00\xef\x01\xf0\x01\xf1\x01\xb0\x00\xcf\x03\xbb\x02\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xb9\x00\x8b\x00\x8c\x00\xff\xff\x0f\x02\x93\x01\xe7\x01\x33\x00\xe8\x01\x94\x01\xf5\x01\xf6\x01\xd3\x00\xd4\x00\x5f\x05\xb4\x00\xf7\x01\x91\x01\x92\x01\x26\x00\x1d\x05\x27\x00\x28\x00\x2e\x00\x95\x01\x29\x00\x2a\x00\x96\x01\xff\xff\x2b\x00\x90\x01\xf7\xfd\xbb\x03\xf7\xfd\xef\x01\xf0\x01\xf1\x01\x8f\x01\xac\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xa3\x00\xbc\x02\xb9\x02\xba\x02\xbb\x02\x99\x03\x79\x02\x33\x00\x36\x03\x89\x00\xf5\x01\xf6\x01\x8a\x00\x32\x00\x21\x02\x4f\x04\xf7\x01\x51\x02\xb8\x02\xb9\x02\xba\x02\xbb\x02\x38\x03\x0a\x05\x0b\x05\x39\x03\x42\x02\x37\x04\x89\x00\xaa\x00\xf2\x01\x8a\x00\x32\x00\x41\x02\xab\x00\xac\x00\x8b\x00\x8c\x00\x40\x02\x3b\x03\x65\x02\x3f\x02\x3c\x03\xd7\x00\x1d\x00\xf6\xfd\x1f\x00\xf6\xfd\x3e\x02\x20\x00\x21\x00\x22\x00\x8c\x01\x8d\x01\x8e\x01\x8b\x00\x8c\x00\x7b\x00\xef\xfd\x7c\x00\xef\xfd\x23\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x0f\x02\x0c\x05\x86\x00\x87\x00\x08\x01\x09\x01\x0a\x01\xf2\x01\xd3\x00\xd4\x00\x70\x01\x3d\x02\xd6\x00\xd7\x00\xd8\x00\x93\x01\xee\xfd\x65\x02\xee\xfd\x94\x01\xed\xfd\x1d\x00\xed\xfd\x1f\x00\x5e\x02\x5f\x02\x20\x00\x21\x00\x22\x00\x26\x00\x7a\x02\x27\x00\x28\x00\x2e\x00\x95\x01\x29\x00\x2a\x00\x96\x01\x23\x00\x2b\x00\x93\x01\x7b\x02\x2e\x00\x2f\x00\x94\x01\x31\x00\x32\x00\x44\x03\x45\x03\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xbb\x00\xbc\x00\x2e\x00\x95\x01\x2e\x00\x16\x04\x96\x01\x33\x00\x17\x04\xbd\x00\xf5\x01\xf6\x01\x7c\x02\xa3\x01\xa4\x01\x19\x03\xf7\x01\x93\x01\x1a\x03\xd7\x00\x26\x00\x94\x01\x27\x00\x28\x00\x31\x00\x32\x00\x29\x00\x2a\x00\x44\x03\x45\x03\x2b\x00\x91\x01\xb7\x02\x38\x05\x93\x01\x2e\x00\x95\x01\x35\x02\x94\x01\x96\x01\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x19\x02\x5a\x00\x8a\x04\x5b\x00\x5c\x00\x2e\x00\x95\x01\x33\x00\x1a\x02\x96\x01\xf5\x01\xf6\x01\xe9\x03\xea\x03\xf2\x03\x49\x05\xf7\x01\xf3\x03\xf4\x03\x7b\x00\xeb\xfd\x7c\x00\xeb\xfd\x88\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x33\x02\x0c\x05\x86\x00\x87\x00\x32\x02\x5b\x03\x89\x00\x31\x02\x30\x00\x8a\x00\x32\x00\x70\x01\x27\xfd\xd6\x00\xd7\x00\xd8\x00\x7b\x00\xdb\x00\x7c\x00\xdd\x00\x29\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x2a\x02\x0c\x05\x86\x00\x87\x00\x8b\x00\x8c\x00\x28\x02\x7b\x00\x5c\x03\x5d\x03\xad\x03\xae\x03\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x71\x04\x6e\x04\xc5\x00\x87\x00\x5e\x03\xc7\x00\xda\x04\x6a\x03\xfe\x03\xff\x03\x00\x04\x01\x04\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x6d\x04\x6e\x04\xec\xfd\x7b\x00\xec\xfd\x7c\x00\x38\x00\x39\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xa3\x01\xa4\x01\x6f\x04\x87\x00\xf8\x04\x6e\x04\x93\x01\x7b\x00\x23\x02\x7c\x00\x94\x01\x21\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x44\x03\x45\x03\x6f\x04\x87\x00\x2e\x00\x95\x01\x20\x02\x7b\x00\x96\x01\x7c\x00\x3c\x05\x3d\x05\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x1b\x02\x88\x00\x6f\x04\x87\x00\xd3\x04\x14\x02\xd4\x04\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x12\x02\xea\xfd\x89\x00\xea\xfd\x30\x00\x8a\x00\x32\x00\xb7\x00\xb5\x00\xb6\x00\x96\x03\x97\x03\x77\x02\x78\x02\x79\x02\xe9\xfd\x88\x00\xe9\xfd\xda\x00\xdb\x00\xdc\x00\xdd\x00\x4c\x03\xda\x00\x4d\x03\xdc\x00\x58\x02\x09\x01\x0a\x01\x8b\x00\x8c\x00\x89\x00\x2e\x02\x30\x00\x8a\x00\x32\x00\x88\x00\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xc9\x00\x7f\x01\xdf\x00\xe8\xfd\xe0\x00\xe8\xfd\x89\x00\xdf\x00\x30\x00\x8a\x00\x32\x00\xe7\x04\xe7\x01\x8b\x00\x8c\x00\xe2\x00\x60\x01\xe4\x00\xe8\x04\xe9\x04\xe2\x00\x60\x01\xe4\x00\x7b\x03\x26\x03\xb4\x01\x89\x00\x88\x00\xe6\x01\x8a\x00\x32\x00\x51\x05\x52\x05\x8b\x00\x8c\x00\xb5\x01\x57\x02\xac\x00\x2d\x00\x2e\x00\x2f\x00\xe7\x04\x89\x00\x78\x03\x30\x00\x8a\x00\x32\x00\x88\x00\xe8\x04\xe9\x04\x2d\x00\x2e\x00\x2f\x00\x8b\x00\x8c\x00\xb4\x00\xb5\x00\xb6\x00\x2d\x00\x2e\x00\x2f\x00\xe4\x01\x89\x00\x7a\x02\x30\x00\x8a\x00\x32\x00\x88\x00\xe3\x01\x8b\x00\x8c\x00\xe7\xfd\x0f\x02\xe7\xfd\x7b\x02\x2e\x00\x2f\x00\xe2\x01\x31\x00\x32\x00\xd3\x00\xd4\x00\x89\x00\xdd\x01\x30\x00\x8a\x00\x32\x00\x89\x01\x8a\x01\x8b\x00\x8c\x00\x4d\x03\x49\x03\x4a\x03\x3a\x00\x3b\x00\x89\x00\xb5\x00\x9d\x01\x8a\x00\x32\x00\x7c\x02\xca\x01\xea\x04\xeb\x04\xec\x04\xed\x04\xb5\x00\x9c\x01\x8b\x00\x8c\x00\x3f\x01\xd0\x01\x40\x01\x76\x03\xe6\xfd\x65\x02\xe6\xfd\xd1\x01\x41\x01\x1d\x00\xd7\x01\x1f\x00\x8b\x00\x8c\x00\x20\x00\x21\x00\x22\x00\xd0\x01\x2d\x00\x2e\x00\x2f\x00\x75\x03\xcf\x01\x3f\x05\xec\x04\xed\x04\x23\x00\x15\x05\xf0\x01\xf1\x01\x89\x00\xb5\x00\x15\x03\x8a\x00\x32\x00\x65\x02\x2d\x00\x2e\x00\x2f\x00\x1d\x00\xc8\x01\x1f\x00\x0e\x05\x6a\x03\x20\x00\x21\x00\x22\x00\xbf\x01\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x23\x00\x8b\x00\x8c\x00\x7b\x04\x77\x02\x78\x02\x79\x02\x7c\x04\x26\x00\xbe\x01\x27\x00\x28\x00\xd2\x00\xbd\x01\x29\x00\x2a\x00\x2a\xfd\xe5\xfd\x2b\x00\xe5\xfd\xd3\x00\xd4\x00\xd5\x00\x2d\xfd\xd6\x00\xd7\x00\xd8\x00\xaa\x01\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x48\x03\x49\x03\x4a\x03\x26\x00\xa8\x01\x27\x00\x28\x00\x33\x00\x3a\x00\x29\x00\x2a\x00\x12\x03\x8a\x01\x2b\x00\x7b\x04\x77\x02\x78\x02\x79\x02\xfd\x04\x1b\x04\x1c\x04\x1d\x04\x1c\x03\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x10\x04\x11\x04\x12\x04\xb0\x00\xe4\xfd\x16\x05\xe4\xfd\x33\x00\xe3\xfd\x1d\x00\xe3\xfd\x1f\x00\xb5\x00\x11\x03\x20\x00\x21\x00\x22\x00\x09\x04\x0a\x04\x0b\x04\x17\x03\xe2\xfd\x7b\x00\xe2\xfd\x7c\x00\x10\x03\x23\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x7a\x02\x0c\x03\xcf\x00\x87\x00\xd0\x00\xc7\x00\x40\x04\x11\x04\x12\x04\xb5\x00\x10\x03\x7b\x02\x2e\x00\x2f\x00\x0e\x03\x31\x00\x32\x00\x0b\x03\x3b\x04\x11\x04\x12\x04\x0d\x03\x75\x02\x76\x02\x77\x02\x78\x02\x79\x02\x0a\x03\xdb\xfd\x26\x00\xdb\xfd\x27\x00\x28\x00\x02\x03\x03\x03\x29\x00\x2a\x00\xcd\x01\x7c\x02\x2b\x00\xda\xfd\x89\x00\xda\xfd\xcf\x00\x8a\x00\x32\x00\x7a\x02\xbd\x02\xbe\x02\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x6a\x01\x7b\x02\x2e\x00\x2f\x00\xfe\x02\x31\x00\x32\x00\x33\x00\xc5\x04\xc6\x04\xc7\x04\xf3\x02\x8b\x00\x8c\x00\xd8\xfd\x7b\x00\xd8\xfd\x7c\x00\xdb\x02\xd1\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x7c\x02\x0f\x02\xcf\x00\x87\x00\xd0\x00\xc7\x00\xc2\x04\x11\x04\x12\x04\xd3\x00\xd4\x00\x70\x01\xe9\x02\xd6\x00\xd7\x00\xd8\x00\x7b\x00\xc6\xfd\x7c\x00\xc6\xfd\xda\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xe4\x02\xe5\x02\xc5\x00\x87\x00\x91\x02\x45\x02\x1f\x04\x7a\x02\xad\x02\x0a\x01\xd4\x01\x2e\x00\x2f\x00\x88\x00\xb0\x01\x32\x00\xb5\x00\x6c\x02\x7b\x02\x2e\x00\x2f\x00\xc2\x02\x31\x00\x32\x00\x68\xfe\xd2\x00\x68\xfe\x50\x02\x89\x00\x2e\x04\x30\x00\x8a\x00\x32\x00\xd3\x00\xd4\x00\xd5\x00\xc0\x02\xd6\x00\xd7\x00\xd8\x00\xbe\x01\x43\x05\x7b\x00\x45\x05\x7c\x00\x7c\x02\xd1\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x8b\x00\x8c\x00\xc9\x00\x87\x00\x95\x02\xca\x00\xcb\x00\x7b\x00\x07\x03\xc4\x00\xc0\x01\xdd\x01\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x46\x02\x8e\x02\xc5\x00\x87\x00\xc6\x00\xc7\x00\x8c\x02\x15\x02\x7b\x00\x16\x02\x7c\x00\x6a\x02\x6b\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x89\x02\x88\x00\xc5\x00\x87\x00\x82\x02\xcb\x04\xd0\x02\xd1\x02\xd2\x02\xd3\x02\xd4\x02\xd5\x02\x88\x02\xb5\x04\xa7\x03\xa8\x03\x89\x00\x81\x02\x30\x00\x8a\x00\x32\x00\xd3\x00\xd4\x00\xd5\x00\x63\x02\xd6\x00\xd7\x00\xd8\x00\x5c\x02\xcc\x04\x88\x00\x00\x05\x09\x01\x0a\x01\xcc\x00\xdf\x02\xaf\x01\x2e\x00\x2f\x00\x62\x02\xb0\x01\x32\x00\x0f\x02\x8b\x00\x8c\x00\x89\x00\xae\x00\x30\x00\x8a\x00\x32\x00\xd3\x00\xd4\x00\x7b\x00\xaa\x03\x7c\x00\xa3\x03\xa4\x03\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xa7\x03\x85\x00\x86\x00\x87\x00\xfb\x04\x09\x01\x0a\x01\x8b\x00\x8c\x00\x4c\x05\x11\x04\x12\x04\x62\x05\x11\x04\x12\x04\xa6\x03\x7b\x00\xa0\x03\x7c\x00\x54\x01\x88\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x50\x02\x45\x01\x86\x00\x87\x00\xa0\x03\xa1\x03\x89\x00\x9d\x03\x30\x00\x8a\x00\x32\x00\x88\x00\x50\x03\x51\x03\x52\x03\x53\x03\x54\x03\x55\x03\x56\x03\x57\x03\x7a\x01\xb5\x00\x91\x03\x7b\x01\xcc\xfe\xe4\x01\x89\x00\xeb\x00\x30\x00\x8a\x00\x32\x00\x9c\x03\x88\x00\x8b\x00\x8c\x00\xd3\x00\xd4\x00\x7d\x01\x95\x03\xd6\x00\xd7\x00\xd8\x00\x8e\x03\x6f\x03\xd4\x00\x23\x03\x4d\x02\x89\x00\x75\x03\x30\x00\x8a\x00\x32\x00\x8f\x03\x8b\x00\x8c\x00\x7b\x00\x8b\x03\x7c\x00\x22\x03\x4d\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x29\x04\x2b\x04\xc5\x00\x87\x00\x89\x03\x42\x02\x8b\x00\x8c\x00\x7b\x00\xdb\x00\x7c\x00\x29\x04\x2a\x04\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x88\x03\xae\x01\x86\x00\x87\x00\xbb\x00\xbc\x00\x1f\x04\x20\x04\x88\x00\x87\x03\x2e\x00\xe3\x03\x83\x03\xbd\x00\x63\x04\x64\x04\x51\x04\xd7\x00\xb4\x04\x0b\x04\x1a\x03\xd7\x00\x2a\x02\x89\x00\x85\x03\x30\x00\x8a\x00\x32\x00\x31\x00\x32\x00\xd3\x00\xd4\x00\x82\x03\x7b\x00\xc2\x02\x7c\x00\x71\x03\x88\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x6d\x03\x45\x03\x86\x00\x87\x00\x8b\x00\x8c\x00\x89\x00\x66\x03\x30\x00\x8a\x00\x32\x00\xaa\x04\xab\x04\x2e\x00\x99\x04\x65\x03\x7b\x00\x64\x03\x7c\x00\x1f\x05\x20\x05\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x63\x03\x40\x03\x86\x00\x87\x00\x8b\x00\x8c\x00\x60\x03\x7b\x00\x62\x03\x7c\x00\x19\x05\x1a\x05\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x61\x03\xe6\x03\x86\x00\x87\x00\x0f\x05\x10\x05\x5a\x03\x7b\x00\x50\x02\x7c\x00\x88\x00\x3f\x03\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x41\x01\x60\x04\x86\x00\x87\x00\x42\x01\x89\x00\xb4\x00\x30\x00\x8a\x00\x32\x00\x35\x03\x88\x00\x30\x03\x61\x05\x64\x04\x2d\x00\x2e\x00\x2f\x00\x2a\x03\x31\x00\x32\x00\x2e\x03\x26\x03\x2a\x03\xcd\x01\xc9\x01\x89\x00\x3a\x00\x30\x00\x8a\x00\x32\x00\x1f\x03\x8b\x00\x8c\x00\x7b\x00\x1e\x03\x7c\x00\x25\x04\x21\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x19\x04\x4b\x04\x86\x00\x87\x00\x14\x04\x10\x04\x8b\x00\x8c\x00\x03\x04\x0d\x04\x88\x00\x4d\x03\xe8\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xf2\x03\xf0\x03\xd0\xfe\x03\x04\xf7\x03\xee\x03\x89\x00\xeb\x03\x30\x00\x8a\x00\x32\x00\xdb\x03\xda\x03\xd8\x03\xd9\x03\xd7\x03\x7b\x00\xd6\x03\x7c\x00\xd5\x03\x88\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xd4\x03\x11\x05\x86\x00\x87\x00\x8b\x00\x8c\x00\x89\x00\xc0\x02\x30\x00\x8a\x00\x32\x00\x88\x00\xcf\x03\xcc\x03\x20\x02\xc4\x03\xc5\x03\xc3\x03\x3a\x00\x3b\x00\xc2\x03\x50\x02\xdb\x00\xbb\x03\xdd\x00\xb9\x03\x89\x00\xba\x03\x30\x00\x8a\x00\x32\x00\x88\x00\x88\x04\x8b\x00\x8c\x00\xbf\x00\x87\x04\xc0\x00\x85\x04\xa0\x03\x7e\x04\x7b\x04\x7a\x04\xc1\x00\x6d\x04\x71\x04\x89\x00\x6c\x04\x30\x00\x8a\x00\x32\x00\x66\x04\xe0\x00\x8b\x00\x8c\x00\x7b\x00\x68\x04\x7c\x00\x5d\x04\x57\x04\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x56\x04\x05\x05\x86\x00\x87\x00\xb4\x00\x8b\x00\x8c\x00\x7b\x00\x54\x04\x7c\x00\x88\x00\x14\x04\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x10\x04\x33\x05\x86\x00\x87\x00\x4b\x04\x89\x00\x40\x04\x30\x00\x8a\x00\x32\x00\x3a\x04\x14\x04\x39\x04\x03\x04\x91\x02\x50\x02\x2e\x03\x30\x04\x95\x03\x76\x02\x77\x02\x78\x02\x79\x02\x17\x00\x89\x00\xc4\x04\xb7\x04\x8a\x00\x32\x00\x65\xfd\x14\x04\x0d\x04\x8b\x00\x8c\x00\x7b\x00\xb3\x04\x7c\x00\xb2\x04\x88\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xa4\x04\x31\x05\x86\x00\x87\x00\x8b\x00\x8c\x00\x89\x00\x9c\x04\x30\x00\x8a\x00\x32\x00\xa7\x04\x9f\x04\x9e\x04\x96\x04\x9d\x04\x7b\x00\x99\x04\x7c\x00\x98\x04\x95\x04\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x94\x04\x52\x05\x86\x00\x87\x00\x8b\x00\x8c\x00\x8c\x04\x7b\x00\xfd\x04\x7c\x00\xfa\x04\xf4\x04\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xf3\x04\x4d\x05\x86\x00\x87\x00\xda\x04\xe7\x04\xdd\x04\x7b\x00\x3a\x00\x7c\x00\x88\x00\xd0\x04\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x7a\x02\x4a\x05\x86\x00\x87\x00\xca\x04\x89\x00\x3c\x02\x30\x00\x8a\x00\x32\x00\x88\x00\x7b\x02\x2e\x00\x2f\x00\x22\x05\x31\x00\x32\x00\x1f\x05\x19\x05\x64\xfd\x05\x05\x08\x05\x04\x05\x02\x05\x47\x05\x89\x00\x44\x05\x30\x00\x8a\x00\x32\x00\x41\x05\x50\x02\x8b\x00\x8c\x00\x7b\x00\x30\x05\x7c\x00\x2f\x05\x7c\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x2d\x05\x48\x05\x86\x00\x87\x00\x57\x05\x8b\x00\x8c\x00\x7b\x00\xf2\x03\x7c\x00\x88\x00\x10\x04\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x14\x04\x66\x05\x86\x00\x87\x00\x14\x04\x89\x00\x66\x04\x30\x00\x8a\x00\x32\x00\x5c\x05\x65\x05\x66\x04\x15\x00\x87\x01\x86\x01\x84\x01\x06\x01\xe6\x00\x88\x00\x44\x01\xba\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x4b\x02\x56\x02\x12\x02\x44\x02\x1e\x02\xcc\x00\x8b\x00\x8c\x00\x89\x00\xa8\x01\x30\x00\x8a\x00\x32\x00\x88\x00\xa1\x01\x9e\x01\x17\x03\x14\x03\x0e\x03\xe7\x02\xd5\x02\xe6\x02\xce\x02\x5c\x02\xc5\x02\xdf\x00\xc4\x02\xe0\x00\x89\x00\xc2\x02\x30\x00\x8a\x00\x32\x00\x88\x00\xc0\x02\x8b\x00\x8c\x00\x8c\x02\xe2\x00\x60\x01\xe4\x00\x86\x02\xaa\x03\x5a\x02\x84\x02\x60\x02\x89\x03\x5f\x02\x89\x00\x19\x03\x30\x00\x8a\x00\x32\x00\x7c\x03\x57\x03\x8b\x00\x8c\x00\x7b\x00\x4e\x03\x7c\x00\x2e\x03\x58\x03\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x24\x03\x20\x03\xe5\x00\x87\x00\x0e\x04\x8b\x00\x8c\x00\x7b\x00\x28\x04\x7c\x00\x88\x00\x06\x04\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x01\x04\x05\x04\x2b\x02\x87\x00\xfc\x03\x89\x00\xf0\x03\x30\x00\x8a\x00\x32\x00\x88\x00\xf5\x03\xee\x03\xec\x03\xeb\x03\xe7\x03\xd2\x03\xd1\x03\x0d\x04\x76\x02\x77\x02\x78\x02\x79\x02\xc9\x03\xc6\x03\x89\x00\xc5\x03\x30\x00\x8a\x00\x32\x00\x85\x04\x68\x04\x8b\x00\x8c\x00\x7b\x00\x83\x04\x7c\x00\x88\x04\x5d\x04\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x66\x04\x5b\x04\xe2\x02\x87\x00\x41\x04\x8b\x00\x8c\x00\x7b\x00\x54\x04\x7c\x00\x3d\x04\x3e\x04\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x36\x04\x3a\x04\xdb\x02\x87\x00\x3c\x04\x2e\x04\x9d\x03\x7b\x00\x2c\x04\x7c\x00\xa5\x04\x35\x04\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xc4\x04\xa2\x04\x74\x02\x87\x00\xbf\x03\x76\x02\x77\x02\x78\x02\x79\x02\x17\x04\xe5\x04\xdb\x04\xce\x04\x17\x05\x3a\x05\x06\x05\x7b\x00\x2d\x05\x7c\x00\x88\x00\x41\x05\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x7a\x02\x53\x05\x73\x02\x87\x00\x4f\x05\x89\x00\x4b\x05\x30\x00\x8a\x00\x32\x00\x88\x00\x7b\x02\x2e\x00\x2f\x00\x63\x05\x31\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x7b\x00\x00\x00\x7c\x00\x00\x00\x7c\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x72\x02\x87\x00\x00\x00\x8b\x00\x8c\x00\x7b\x00\x00\x00\x7c\x00\x88\x00\x00\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x71\x02\x87\x00\x00\x00\x89\x00\x7a\x02\x30\x00\x8a\x00\x32\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x02\x2e\x00\x2f\x00\x00\x00\x31\x00\x32\x00\x00\x00\x00\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x88\x00\x00\x00\x8b\x00\x8c\x00\xdf\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7c\x02\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x00\x00\x7b\x00\x00\x00\x7c\x00\x00\x00\x88\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x6d\x02\x87\x00\x8b\x00\x8c\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x00\x00\x00\x7c\x00\x00\x00\x00\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x77\x03\x87\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7a\x01\x00\x00\x00\x00\x7b\x01\x00\x00\xa2\x03\x00\x00\xeb\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x88\x00\x00\x00\xd3\x00\xd4\x00\x7d\x01\x00\x00\xd6\x00\xd7\x00\xd8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x7b\x00\x00\x00\x7c\x00\x00\x00\x00\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x66\x03\x87\x00\x00\x00\x8b\x00\x8c\x00\x7b\x00\x00\x00\x7c\x00\x00\x00\x00\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x5a\x03\x87\x00\x00\x00\x00\x00\x00\x00\x7b\x00\x00\x00\xdf\x03\x00\x00\x88\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x00\x00\xe0\x03\x00\x00\x00\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x00\x00\x00\x7c\x00\x00\x00\x88\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x5a\x04\x87\x00\x8b\x00\x8c\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x00\x00\x00\xdf\x03\x00\x00\x00\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x00\x00\xe0\x03\x8b\x00\x8c\x00\x00\x00\x00\x00\x7b\x00\x00\x00\x69\x04\x00\x00\x00\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x00\x00\x6a\x04\x00\x00\x00\x00\x00\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x88\x00\x7b\x00\x00\x00\xc2\x00\x00\x00\x00\x00\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x88\x00\x2d\x02\x8b\x00\x8c\x00\x00\x00\x00\x00\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x03\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x00\x00\x00\x6b\x03\x00\x00\x88\x00\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x00\x00\x88\x00\xca\x02\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x89\x00\xf7\x04\x30\x00\x8a\x00\x32\x00\x00\x00\x8b\x00\x8c\x00\x7b\x00\x00\x00\xa0\x04\x00\x00\x00\x00\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x7b\x00\x00\x00\x12\x05\x00\x00\x00\x00\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x32\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x00\x00\x00\x39\x05\x00\x00\x00\x00\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x00\x00\x00\x36\x05\x00\x00\x88\x00\xc3\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x62\x04\x76\x02\x77\x02\x78\x02\x79\x02\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x42\x04\x00\x00\x43\x04\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x00\x00\x44\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x00\x8b\x00\x8c\x00\x8a\x00\x32\x00\x00\x00\x00\x00\x88\x00\x00\x00\x00\x00\x00\x00\x45\x04\x46\x04\x00\x00\xe8\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\xe9\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x04\x00\x00\xb7\x04\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\x88\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x4f\x01\x00\x00\x50\x01\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\xb8\x04\x46\x04\x7a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x00\x00\x00\x00\x00\x00\x00\x7b\x02\x2e\x00\x2f\x00\x00\x00\x31\x00\x32\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x00\x00\x7c\x02\x00\x00\x00\x00\x00\x00\x89\x00\x00\x00\x30\x00\x8a\x00\x32\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x47\x04\x00\x00\x4d\x01\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\xe1\x02\x00\x00\x7f\x01\xdf\x00\x89\x00\xe0\x00\x38\x05\x48\x04\x32\x00\x23\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x60\x01\xe4\x00\x00\x00\x00\x00\x00\x00\x59\x04\x76\x02\x77\x02\x78\x02\x79\x02\x00\x00\x00\x00\xea\x00\x00\x00\x8b\x00\x8c\x00\xeb\x00\x00\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x32\x00\xd3\x00\xd4\x00\x00\x00\x00\x00\x00\x00\x47\x04\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x89\x00\x00\x00\x00\x00\x48\x04\x32\x00\x8b\x00\x8c\x00\xec\x00\xed\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x32\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x8c\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x50\x02\x00\x00\x7a\x02\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x7b\x02\x2e\x00\x2f\x00\x4b\x00\x31\x00\x32\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\xf9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x7c\x02\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfa\x01\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\xfb\x01\xfc\x01\xfd\x01\xfe\x01\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x17\x00\x00\x00\xff\x01\x00\x02\x01\x02\x02\x02\xa6\x00\x72\x00\x00\x00\x03\x02\x00\x00\x73\x00\x00\x00\x00\x00\x04\x02\x00\x00\x00\x00\x75\x00\x76\x00\x05\x02\x77\x00\x78\x00\x06\x02\x07\x02\x08\x02\x09\x02\x00\x00\x0a\x02\x79\x00\x7a\x00\x7b\x00\x0b\x02\x0c\x02\x00\x00\x00\x00\x00\x00\x00\x00\x0d\x02\x0e\x02\x00\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x00\x00\x0f\x02\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x11\x02\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xdf\x00\x47\x00\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\xe2\x00\x60\x01\xe4\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\xf9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfa\x01\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\xfb\x01\xfc\x01\xfd\x01\xfe\x01\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x17\x00\x00\x00\xff\x01\x00\x02\x01\x02\x02\x02\xa6\x00\x72\x00\x00\x00\x03\x02\x00\x00\x73\x00\x00\x00\x00\x00\x04\x02\x00\x00\x00\x00\x75\x00\x76\x00\x05\x02\x77\x00\x78\x00\x06\x02\x07\x02\x08\x02\x09\x02\x00\x00\x0a\x02\x79\x00\x7a\x00\x7b\x00\x0b\x02\x0c\x02\x00\x00\x00\x00\x00\x00\x00\x00\x0d\x02\x0e\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x02\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\xf9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfa\x01\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\xfb\x01\xfc\x01\xfd\x01\xfe\x01\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\xff\x01\x00\x02\x01\x02\x02\x02\xa6\x00\x72\x00\x00\x00\x03\x02\x00\x00\x73\x00\x00\x00\x00\x00\x04\x02\x00\x00\x00\x00\x75\x00\x76\x00\x05\x02\x77\x00\x78\x00\x06\x02\x07\x02\x08\x02\x09\x02\x00\x00\x0a\x02\x79\x00\x7a\x00\x7b\x00\x0b\x02\x0c\x02\x00\x00\x00\x00\x00\x00\x00\x00\x0d\x02\x0e\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x02\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x4e\x05\x76\x02\x77\x02\x78\x02\x79\x02\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x50\x02\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\xf9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\xe2\x04\xe3\x04\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x7a\x02\x6f\x00\x00\x00\x00\x00\x00\x00\xff\x01\x00\x02\x01\x02\x00\x00\x00\x00\x72\x00\x7b\x02\x2e\x00\x2f\x00\x00\x00\x31\x00\x32\x00\xe4\x04\x00\x00\x00\x00\x75\x00\x76\x00\x05\x02\x77\x00\x78\x00\x06\x02\x07\x02\x08\x02\x09\x02\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x7c\x02\x00\x00\x00\x00\x0e\x02\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\xf9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\xe2\x04\xe3\x04\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\xff\x01\x00\x02\x01\x02\x00\x00\x00\x00\x72\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x04\x00\x00\x00\x00\x75\x00\x76\x00\x05\x02\x77\x00\x78\x00\x06\x02\x07\x02\x08\x02\x09\x02\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x02\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x50\x02\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\xf9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x7a\x01\x6d\x00\x6e\x00\x7b\x01\x6f\x00\x7c\x01\x00\x00\xeb\x00\xff\x01\x00\x02\x01\x02\x00\x00\x00\x00\x72\x00\x00\x00\xd3\x00\xd4\x00\x7d\x01\x00\x00\xd6\x00\xd7\x00\xd8\x00\x00\x00\x75\x00\x76\x00\x05\x02\x77\x00\x78\x00\x06\x02\x07\x02\x08\x02\x09\x02\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x02\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\xf9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x7a\x01\x6d\x00\x6e\x00\x7b\x01\x6f\x00\xe4\x01\x00\x00\xeb\x00\xff\x01\x00\x02\x01\x02\x00\x00\x00\x00\x72\x00\x00\x00\xd3\x00\xd4\x00\x7d\x01\x00\x00\xd6\x00\xd7\x00\xd8\x00\x00\x00\x75\x00\x76\x00\x05\x02\x77\x00\x78\x00\x06\x02\x07\x02\x08\x02\x09\x02\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x02\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x50\x02\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\xf9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\xef\x04\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\x00\x00\x00\x03\x02\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x04\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x06\x02\x07\x02\x08\x02\x09\x02\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x02\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\xf9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\xef\x04\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\x00\x00\x00\x03\x02\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x04\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x06\x02\x07\x02\x08\x02\x09\x02\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x02\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x7a\x01\x6d\x00\x6e\x00\x7b\x01\x6f\x00\xa2\x03\x00\x00\xeb\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\x00\x00\x00\xd3\x00\xd4\x00\x7d\x01\x00\x00\xd6\x00\xd7\x00\xd8\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x06\x02\x07\x02\x08\x02\x09\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x0e\x02\xda\x00\xdb\x00\xdc\x00\xdd\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\xde\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x00\x00\xcf\x00\x94\x00\x00\x00\xdf\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x00\x00\x00\x00\x00\x95\x00\x00\x00\xe2\x00\xe3\x00\xe4\x00\xc0\x03\x77\x02\x78\x02\x79\x02\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x60\x05\x76\x02\x77\x02\x78\x02\x79\x02\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x00\x00\xef\x00\xdb\x00\x00\x00\xdd\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\xf0\x00\x00\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x7a\x02\x00\x00\x00\x00\xf1\x00\x00\x00\x00\x00\x95\x00\xf2\x00\xf3\x00\x96\x00\xf4\x00\x7b\x02\x2e\x00\x2f\x00\x00\x00\x31\x00\x32\x00\x00\x00\x97\x00\x98\x00\x7a\x02\x00\x00\x00\x00\x00\x00\x00\x00\xf5\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x7b\x02\x2e\x00\x2f\x00\x00\x00\x31\x00\x32\x00\x00\x00\x7c\x02\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7c\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\xdb\x00\x75\x00\xdd\x00\x8e\x00\x77\x00\x78\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x74\x01\x91\x00\x00\x00\x9f\x00\xa0\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x00\x00\xcf\x00\x94\x00\x00\x00\x00\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x00\x00\xef\x00\xdb\x00\x00\x00\xdd\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\xf0\x00\x00\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf1\x00\x00\x00\x00\x00\x95\x00\x00\x00\xf3\x00\x96\x00\xf4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf5\x00\x00\x00\x9a\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\xe1\x02\x00\x00\x7f\x01\xdf\x00\x00\x00\xe0\x00\xe2\x02\x67\xfe\x00\x00\x67\xfe\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x60\x01\xe4\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x8e\x00\x77\x00\x78\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x00\x00\x91\x00\xce\x00\x9f\x00\xa0\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x00\x00\xcf\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\xc9\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x44\x02\x93\x00\x9f\x00\xa0\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\xfb\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x03\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x5d\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x02\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x8e\x00\x77\x00\x78\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\xce\x04\x91\x00\x00\x00\x9f\x00\xa0\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x00\x00\x00\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x03\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x5d\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\x05\x00\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x9f\x00\xa0\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x33\x05\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x00\x00\x00\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x75\x00\x91\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x00\x00\x00\x00\x94\x00\x00\x00\x00\x00\x00\x00\x9f\x00\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x02\x00\x00\x00\x00\x6f\x00\x00\x00\x00\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xcd\x02\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\xde\x00\x75\x00\xce\x02\x8e\x00\x77\x00\x78\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcf\x00\x00\x00\x90\x00\xdf\x00\x91\x00\xe0\x00\x9f\x00\xa0\x00\x00\x00\x00\x00\x92\x00\xe1\x00\x93\x00\x00\x00\x00\x00\x94\x00\xe2\x00\x60\x01\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe3\x03\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\xff\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x75\x00\x91\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x00\x00\x00\x00\x94\x00\x00\xff\x00\x00\x00\x00\x9f\x00\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\xf2\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe3\x03\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\xff\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x75\x00\x91\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x00\x00\x00\x00\x94\x00\x00\xff\x00\x00\x00\x00\x9f\x00\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x90\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x9f\x00\xa0\x00\x94\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x75\x00\x91\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x00\x00\x00\x00\x94\x00\x00\x00\x00\x00\x00\x00\x9f\x00\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x04\x75\x00\x91\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x00\x00\x00\x00\x94\x00\x00\x00\x00\x00\x00\x00\x9f\x00\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x8f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x75\x00\x91\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x92\x00\x00\x00\x93\x00\x00\x00\x00\x00\x94\x00\x00\x00\x00\x00\x00\x00\x9f\x00\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x96\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x9a\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x7f\x01\xdf\x00\x00\x00\xe0\x00\x80\x01\x00\x00\x00\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x60\x01\xe4\x00\x81\x01\x82\x01\x83\x01\x84\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x00\xa0\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x74\x01\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\xcf\x00\x4a\x00\x5f\x01\xdf\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x4b\x00\x6a\x01\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x75\x01\x60\x01\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x69\x01\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\xcf\x00\x4a\x00\x5f\x01\xdf\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x4b\x00\x6a\x01\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x60\x01\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\xce\x01\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\xc7\x01\x4a\x00\x5f\x01\xdf\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x60\x01\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xc6\x01\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\xc7\x01\x4a\x00\x5f\x01\xdf\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x60\x01\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x64\x01\x49\x00\x00\x00\x00\x00\x4a\x00\x5f\x01\xdf\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x60\x01\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x5f\x01\xdf\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x4b\x00\xcd\x01\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x60\x01\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\xc7\x01\x4a\x00\x5f\x01\xdf\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x60\x01\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x5f\x01\xdf\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x60\x01\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x26\x02\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x74\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x02\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\xfa\x02\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x50\x02\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x02\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\xfa\x02\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x04\x01\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x02\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x2d\x03\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x02\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x72\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x7a\x00\x7b\x00\x9a\x02\x36\x00\x37\x00\x38\x00\x39\x00\x9b\x02\x3b\x00\x0e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x01\x9c\x02\x9d\x02\x9e\x02\x9f\x02\xa0\x02\xa1\x02\xa2\x02\xa3\x02\xa4\x02\xa5\x02\xa6\x02\xa7\x02\xa8\x02\xa9\x02\x1e\x01\x1f\x01\x20\x01\x21\x01\x22\x01\x23\x01\x24\x01\x25\x01\xaa\x02\xab\x02\x28\x01\xac\x02\x2a\x01\x2b\x01\x2c\x01\x2d\x01\x2e\x01\x2f\x01\x30\x01\x31\x01\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x39\x01\x3a\x01\x3b\x01\xad\x02\x76\x00\x00\x00\x77\x00\x78\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x4e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\x00\x00\x00\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x54\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdf\x01\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x00\x00\x57\x00\x58\x00\x59\x00\x00\x00\x5a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x37\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\xdb\x00\x00\x00\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x7e\x02\x99\x03\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x37\x00\x7f\x02\x00\x00\x3a\x00\x3b\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb4\x03\x00\x00\x00\x00\x80\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\x03\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x37\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x00\x00\xb6\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb7\x03\x00\x00\x00\x00\x75\x00\x76\x00\xb8\x03\x77\x00\x78\x00\x7e\x02\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x37\x00\x7f\x02\x00\x00\x3a\x00\x3b\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x03\x00\x00\x00\x00\x00\x00\xb4\x03\x00\x00\x00\x00\x80\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x79\x01\x21\x00\x22\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x23\x00\x35\x00\x00\x00\x37\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x00\x00\xb6\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb7\x03\x00\x00\x00\x00\x75\x00\x76\x00\xb8\x03\x77\x00\x78\x00\x7e\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x7f\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\xda\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\xb7\x02\x00\x00\x80\x02\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\xdf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x60\x01\xe4\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x6d\x00\x6e\x00\x35\x00\x6f\x00\x37\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x44\x01\x77\x00\x78\x00\x00\x00\x00\x00\x35\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\xb9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x6d\x00\x6e\x00\x35\x00\x6f\x00\x37\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\xb4\x03\x77\x00\x78\x00\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x35\x00\x6f\x00\x37\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\xb7\x01\x77\x00\x78\x00\x6d\x00\x6e\x00\x35\x00\x6f\x00\x37\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x00\x00\x4a\x00\x00\x00\x00\x00\xb9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x05\x00\x00\x00\x00\x75\x00\x76\x00\x2a\x05\x77\x00\x78\x00\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x01\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x35\x00\x77\x00\x78\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x74\x03\x77\x00\x78\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x75\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\xfd\x00\x00\x99\x01\x0f\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x01\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x01\x92\x04\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x93\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x35\x00\x00\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\xb7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\xd9\x04\x00\x00\x6d\x00\x6e\x00\x3a\x00\x6f\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x01\x5a\x05\x00\x00\x75\x00\x76\x00\x35\x00\x77\x00\x78\x00\x00\x00\x00\x00\x3a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x01\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x6d\x00\x6e\x00\x35\x00\x6f\x00\x37\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\xb7\x01\x77\x00\x78\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x37\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x05\x00\x00\x00\x00\x75\x00\x76\x00\x2a\x05\x77\x00\x78\x00\xb7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x01\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x93\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x35\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x3a\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\xb1\x02\x00\x00\x00\x00\x75\x00\x76\x00\x35\x00\x77\x00\x78\x00\x6d\x00\x6e\x00\x3a\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x01\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x35\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\xb7\x02\x77\x00\x78\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x3f\x01\x00\x00\x40\x01\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x41\x01\x00\x00\x3a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x35\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\xb7\x02\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x76\x04\x77\x00\x78\x00\x6d\x00\x6e\x00\x35\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x4e\x04\x77\x00\x78\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x35\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x76\x04\x77\x00\x78\x00\x6d\x00\x6e\x00\x35\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x4e\x04\x77\x00\x78\x00\x6d\x00\x6e\x00\x35\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x76\x00\x35\x00\x77\x00\x78\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x4a\x02\x00\x00\x00\x00\x75\x00\x76\x00\x35\x00\x77\x00\x78\x00\x6d\x00\x6e\x00\x00\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x4b\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x02\x00\x00\x00\x00\x75\x00\x76\x00\x35\x00\x77\x00\x78\x00\x00\x00\x00\x00\x3a\x00\x3b\x00\x00\x00\x00\x00\x00\x00\xbc\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x35\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x4a\x02\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x35\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\xa2\x04\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x4a\x02\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x59\x04\x00\x00\x00\x00\x4a\x02\x00\x00\x00\x00\x00\x00\x35\x00\x6f\x00\x00\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\xc5\xfe\x00\x00\x6f\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x35\x00\x00\x00\x6f\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x6f\x00\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x6f\x00\xc5\xfe\xc5\xfe\xc5\xfe\xc5\xfe\x00\x00\xc5\xfe\xc5\xfe\xc5\xfe\xc5\xfe\xc5\xfe\xc5\xfe\xc5\xfe\xc5\xfe\xc5\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\xc5\xfe\x5d\x00\x9b\x00\x9c\x00\x9d\x00\x00\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc5\xfe\x0c\x01\x00\x00\xc5\xfe\xc5\xfe\x00\x00\x0d\x01\x6f\x00\x0e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x00\x00\x77\x00\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x01\x10\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01\x20\x01\x21\x01\x22\x01\x23\x01\x24\x01\x25\x01\x26\x01\x27\x01\x28\x01\x29\x01\x2a\x01\x2b\x01\x2c\x01\x2d\x01\x2e\x01\x2f\x01\x30\x01\x31\x01\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x39\x01\x3a\x01\x3b\x01\x3c\x01\xe9\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x02\xf5\x02\xf6\x02\xf7\x02\x00\x00\xf8\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xe9\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf4\x02\xf5\x02\xf6\x02\xf7\x02\x00\x00\xf8\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xe9\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x04\xf6\x02\xf7\x02\x00\x00\xf8\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xe9\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x04\xf7\x02\x00\x00\xf8\x02\x00\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\xec\x02\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x23\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x33\x00\x26\x02\x00\x00\x24\x02\x51\x01\x52\x01\xfc\x00\x21\x00\x22\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x23\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x23\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x33\x00\x23\x02\x00\x00\x24\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xe9\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\x02\xeb\x02\x00\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\xec\x02\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x23\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x33\x00\x85\x02\x00\x00\x24\x02\x00\x00\xfb\x00\xfc\x00\x21\x00\x22\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x23\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x23\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x33\x00\x93\x03\x00\x00\x24\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xe9\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x03\xeb\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xe9\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x04\xeb\x02\x00\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\xec\x02\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x23\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x00\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xe9\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x19\x04\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\x02\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\xa6\x00\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x33\x00\x02\x01\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x49\x01\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x48\x01\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\xc1\x00\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xb9\x01\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x2b\x03\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x1a\x04\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x04\x04\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xbe\x03\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x78\x04\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x34\x04\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x32\x04\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x31\x04\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x30\x04\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xb3\x04\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\xfa\x04\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xca\x04\xa7\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x6b\x01\x00\x00\x00\x00\x6c\x01\x66\x01\x00\x00\x6d\x01\x00\x00\x6e\x01\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x58\x01\x00\x00\x59\x01\x00\x00\x00\x00\x5a\x01\x6f\x01\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xd3\x00\xd4\x00\x70\x01\x5b\x01\xd6\x00\x71\x01\x72\x01\x33\x00\x54\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x64\x01\x00\x00\x00\x00\x65\x01\x66\x01\x00\x00\x67\x01\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x01\x00\x00\x00\x00\x23\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x61\x01\x62\x01\x2b\x00\x00\x00\x00\x00\x58\x01\x00\x00\x59\x01\x00\x00\x00\x00\x5a\x01\xeb\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xd3\x00\xd4\x00\x00\x00\x5b\x01\x00\x00\x5c\x01\x5d\x01\x33\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x58\x01\x00\x00\x59\x01\x00\x00\x00\x00\x5a\x01\xeb\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xd3\x00\xd4\x00\x00\x00\x5b\x01\x00\x00\x5c\x01\x5d\x01\x33\x00\x54\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x01\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x01\x54\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x57\x01\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\xc3\x01\x00\x00\x00\x00\x00\x00\xc4\x01\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x58\x01\x00\x00\x59\x01\x00\x00\x00\x00\x5a\x01\xeb\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xd3\x00\xd4\x00\x00\x00\x5b\x01\x00\x00\x5c\x01\x5d\x01\x33\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x58\x01\x00\x00\x59\x01\x00\x00\x00\x00\x5a\x01\xeb\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xd3\x00\xd4\x00\x00\x00\x5b\x01\x00\x00\x5c\x01\x5d\x01\x33\x00\x54\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x08\x03\x00\x00\x00\x00\x00\x00\xc4\x01\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x01\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x58\x01\x00\x00\x59\x01\x00\x00\x00\x00\x5a\x01\xeb\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xd3\x00\xd4\x00\x00\x00\x5b\x01\x00\x00\x5c\x01\x5d\x01\x33\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x58\x01\x00\x00\x59\x01\x00\x00\x00\x00\x5a\x01\xeb\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xd3\x00\xd4\x00\x00\x00\x5b\x01\x00\x00\x5c\x01\x5d\x01\x33\x00\x54\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x03\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x02\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x58\x01\x00\x00\x59\x01\x00\x00\x00\x00\x5a\x01\xeb\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xd3\x00\xd4\x00\x00\x00\x5b\x01\x00\x00\x5c\x01\x5d\x01\x33\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x58\x01\x00\x00\x59\x01\x00\x00\x00\x00\x5a\x01\xeb\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xd3\x00\xd4\x00\x00\x00\x5b\x01\x00\x00\x5c\x01\x5d\x01\x33\x00\xfb\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x02\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x58\x01\x00\x00\x59\x01\x00\x00\x00\x00\x5a\x01\xeb\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\xd3\x00\xd4\x00\x00\x00\x5b\x01\x00\x00\x5c\x01\x5d\x01\x33\x00\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x30\x03\x31\x03\x00\x00\x00\x00\x00\x00\x32\x03\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x33\x04\x00\x00\x00\x00\x00\x00\x32\x03\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x00\x00\x00\x4b\x01\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x05\x03\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x03\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x03\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x92\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x02\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe5\x03\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\xa3\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x03\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x05\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\xad\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\xac\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\xab\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\xaa\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\xfa\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\xef\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\xee\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8a\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x89\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x83\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x82\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x03\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x27\x03\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x27\x04\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x25\x04\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x96\x04\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x47\x05\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x01\x1a\x00\x47\x01\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\xd5\x01\x1a\x00\x47\x01\x1c\x00\x00\x00\x33\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x76\x04\x1a\x00\x47\x01\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\xb1\x01\x00\x00\x2b\x00\xb2\x01\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x23\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\xb2\x01\x00\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\xdd\x01\xfc\x00\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x02\x21\x00\x22\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x23\x00\x00\x00\x00\x00\x96\x02\x09\x01\x0a\x01\x33\x00\x97\x02\x98\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x96\x02\x09\x01\x0a\x01\x00\x00\x97\x02\xab\x03\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x01\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x01\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x02\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x01\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbb\x01\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\xba\x01\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x03\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x03\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x02\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x03\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x03\x21\x00\x22\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x23\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x33\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x26\x00\x00\x00\x27\x00\x28\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (11, 787) [
	(11 , happyReduce_11),
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251),
	(252 , happyReduce_252),
	(253 , happyReduce_253),
	(254 , happyReduce_254),
	(255 , happyReduce_255),
	(256 , happyReduce_256),
	(257 , happyReduce_257),
	(258 , happyReduce_258),
	(259 , happyReduce_259),
	(260 , happyReduce_260),
	(261 , happyReduce_261),
	(262 , happyReduce_262),
	(263 , happyReduce_263),
	(264 , happyReduce_264),
	(265 , happyReduce_265),
	(266 , happyReduce_266),
	(267 , happyReduce_267),
	(268 , happyReduce_268),
	(269 , happyReduce_269),
	(270 , happyReduce_270),
	(271 , happyReduce_271),
	(272 , happyReduce_272),
	(273 , happyReduce_273),
	(274 , happyReduce_274),
	(275 , happyReduce_275),
	(276 , happyReduce_276),
	(277 , happyReduce_277),
	(278 , happyReduce_278),
	(279 , happyReduce_279),
	(280 , happyReduce_280),
	(281 , happyReduce_281),
	(282 , happyReduce_282),
	(283 , happyReduce_283),
	(284 , happyReduce_284),
	(285 , happyReduce_285),
	(286 , happyReduce_286),
	(287 , happyReduce_287),
	(288 , happyReduce_288),
	(289 , happyReduce_289),
	(290 , happyReduce_290),
	(291 , happyReduce_291),
	(292 , happyReduce_292),
	(293 , happyReduce_293),
	(294 , happyReduce_294),
	(295 , happyReduce_295),
	(296 , happyReduce_296),
	(297 , happyReduce_297),
	(298 , happyReduce_298),
	(299 , happyReduce_299),
	(300 , happyReduce_300),
	(301 , happyReduce_301),
	(302 , happyReduce_302),
	(303 , happyReduce_303),
	(304 , happyReduce_304),
	(305 , happyReduce_305),
	(306 , happyReduce_306),
	(307 , happyReduce_307),
	(308 , happyReduce_308),
	(309 , happyReduce_309),
	(310 , happyReduce_310),
	(311 , happyReduce_311),
	(312 , happyReduce_312),
	(313 , happyReduce_313),
	(314 , happyReduce_314),
	(315 , happyReduce_315),
	(316 , happyReduce_316),
	(317 , happyReduce_317),
	(318 , happyReduce_318),
	(319 , happyReduce_319),
	(320 , happyReduce_320),
	(321 , happyReduce_321),
	(322 , happyReduce_322),
	(323 , happyReduce_323),
	(324 , happyReduce_324),
	(325 , happyReduce_325),
	(326 , happyReduce_326),
	(327 , happyReduce_327),
	(328 , happyReduce_328),
	(329 , happyReduce_329),
	(330 , happyReduce_330),
	(331 , happyReduce_331),
	(332 , happyReduce_332),
	(333 , happyReduce_333),
	(334 , happyReduce_334),
	(335 , happyReduce_335),
	(336 , happyReduce_336),
	(337 , happyReduce_337),
	(338 , happyReduce_338),
	(339 , happyReduce_339),
	(340 , happyReduce_340),
	(341 , happyReduce_341),
	(342 , happyReduce_342),
	(343 , happyReduce_343),
	(344 , happyReduce_344),
	(345 , happyReduce_345),
	(346 , happyReduce_346),
	(347 , happyReduce_347),
	(348 , happyReduce_348),
	(349 , happyReduce_349),
	(350 , happyReduce_350),
	(351 , happyReduce_351),
	(352 , happyReduce_352),
	(353 , happyReduce_353),
	(354 , happyReduce_354),
	(355 , happyReduce_355),
	(356 , happyReduce_356),
	(357 , happyReduce_357),
	(358 , happyReduce_358),
	(359 , happyReduce_359),
	(360 , happyReduce_360),
	(361 , happyReduce_361),
	(362 , happyReduce_362),
	(363 , happyReduce_363),
	(364 , happyReduce_364),
	(365 , happyReduce_365),
	(366 , happyReduce_366),
	(367 , happyReduce_367),
	(368 , happyReduce_368),
	(369 , happyReduce_369),
	(370 , happyReduce_370),
	(371 , happyReduce_371),
	(372 , happyReduce_372),
	(373 , happyReduce_373),
	(374 , happyReduce_374),
	(375 , happyReduce_375),
	(376 , happyReduce_376),
	(377 , happyReduce_377),
	(378 , happyReduce_378),
	(379 , happyReduce_379),
	(380 , happyReduce_380),
	(381 , happyReduce_381),
	(382 , happyReduce_382),
	(383 , happyReduce_383),
	(384 , happyReduce_384),
	(385 , happyReduce_385),
	(386 , happyReduce_386),
	(387 , happyReduce_387),
	(388 , happyReduce_388),
	(389 , happyReduce_389),
	(390 , happyReduce_390),
	(391 , happyReduce_391),
	(392 , happyReduce_392),
	(393 , happyReduce_393),
	(394 , happyReduce_394),
	(395 , happyReduce_395),
	(396 , happyReduce_396),
	(397 , happyReduce_397),
	(398 , happyReduce_398),
	(399 , happyReduce_399),
	(400 , happyReduce_400),
	(401 , happyReduce_401),
	(402 , happyReduce_402),
	(403 , happyReduce_403),
	(404 , happyReduce_404),
	(405 , happyReduce_405),
	(406 , happyReduce_406),
	(407 , happyReduce_407),
	(408 , happyReduce_408),
	(409 , happyReduce_409),
	(410 , happyReduce_410),
	(411 , happyReduce_411),
	(412 , happyReduce_412),
	(413 , happyReduce_413),
	(414 , happyReduce_414),
	(415 , happyReduce_415),
	(416 , happyReduce_416),
	(417 , happyReduce_417),
	(418 , happyReduce_418),
	(419 , happyReduce_419),
	(420 , happyReduce_420),
	(421 , happyReduce_421),
	(422 , happyReduce_422),
	(423 , happyReduce_423),
	(424 , happyReduce_424),
	(425 , happyReduce_425),
	(426 , happyReduce_426),
	(427 , happyReduce_427),
	(428 , happyReduce_428),
	(429 , happyReduce_429),
	(430 , happyReduce_430),
	(431 , happyReduce_431),
	(432 , happyReduce_432),
	(433 , happyReduce_433),
	(434 , happyReduce_434),
	(435 , happyReduce_435),
	(436 , happyReduce_436),
	(437 , happyReduce_437),
	(438 , happyReduce_438),
	(439 , happyReduce_439),
	(440 , happyReduce_440),
	(441 , happyReduce_441),
	(442 , happyReduce_442),
	(443 , happyReduce_443),
	(444 , happyReduce_444),
	(445 , happyReduce_445),
	(446 , happyReduce_446),
	(447 , happyReduce_447),
	(448 , happyReduce_448),
	(449 , happyReduce_449),
	(450 , happyReduce_450),
	(451 , happyReduce_451),
	(452 , happyReduce_452),
	(453 , happyReduce_453),
	(454 , happyReduce_454),
	(455 , happyReduce_455),
	(456 , happyReduce_456),
	(457 , happyReduce_457),
	(458 , happyReduce_458),
	(459 , happyReduce_459),
	(460 , happyReduce_460),
	(461 , happyReduce_461),
	(462 , happyReduce_462),
	(463 , happyReduce_463),
	(464 , happyReduce_464),
	(465 , happyReduce_465),
	(466 , happyReduce_466),
	(467 , happyReduce_467),
	(468 , happyReduce_468),
	(469 , happyReduce_469),
	(470 , happyReduce_470),
	(471 , happyReduce_471),
	(472 , happyReduce_472),
	(473 , happyReduce_473),
	(474 , happyReduce_474),
	(475 , happyReduce_475),
	(476 , happyReduce_476),
	(477 , happyReduce_477),
	(478 , happyReduce_478),
	(479 , happyReduce_479),
	(480 , happyReduce_480),
	(481 , happyReduce_481),
	(482 , happyReduce_482),
	(483 , happyReduce_483),
	(484 , happyReduce_484),
	(485 , happyReduce_485),
	(486 , happyReduce_486),
	(487 , happyReduce_487),
	(488 , happyReduce_488),
	(489 , happyReduce_489),
	(490 , happyReduce_490),
	(491 , happyReduce_491),
	(492 , happyReduce_492),
	(493 , happyReduce_493),
	(494 , happyReduce_494),
	(495 , happyReduce_495),
	(496 , happyReduce_496),
	(497 , happyReduce_497),
	(498 , happyReduce_498),
	(499 , happyReduce_499),
	(500 , happyReduce_500),
	(501 , happyReduce_501),
	(502 , happyReduce_502),
	(503 , happyReduce_503),
	(504 , happyReduce_504),
	(505 , happyReduce_505),
	(506 , happyReduce_506),
	(507 , happyReduce_507),
	(508 , happyReduce_508),
	(509 , happyReduce_509),
	(510 , happyReduce_510),
	(511 , happyReduce_511),
	(512 , happyReduce_512),
	(513 , happyReduce_513),
	(514 , happyReduce_514),
	(515 , happyReduce_515),
	(516 , happyReduce_516),
	(517 , happyReduce_517),
	(518 , happyReduce_518),
	(519 , happyReduce_519),
	(520 , happyReduce_520),
	(521 , happyReduce_521),
	(522 , happyReduce_522),
	(523 , happyReduce_523),
	(524 , happyReduce_524),
	(525 , happyReduce_525),
	(526 , happyReduce_526),
	(527 , happyReduce_527),
	(528 , happyReduce_528),
	(529 , happyReduce_529),
	(530 , happyReduce_530),
	(531 , happyReduce_531),
	(532 , happyReduce_532),
	(533 , happyReduce_533),
	(534 , happyReduce_534),
	(535 , happyReduce_535),
	(536 , happyReduce_536),
	(537 , happyReduce_537),
	(538 , happyReduce_538),
	(539 , happyReduce_539),
	(540 , happyReduce_540),
	(541 , happyReduce_541),
	(542 , happyReduce_542),
	(543 , happyReduce_543),
	(544 , happyReduce_544),
	(545 , happyReduce_545),
	(546 , happyReduce_546),
	(547 , happyReduce_547),
	(548 , happyReduce_548),
	(549 , happyReduce_549),
	(550 , happyReduce_550),
	(551 , happyReduce_551),
	(552 , happyReduce_552),
	(553 , happyReduce_553),
	(554 , happyReduce_554),
	(555 , happyReduce_555),
	(556 , happyReduce_556),
	(557 , happyReduce_557),
	(558 , happyReduce_558),
	(559 , happyReduce_559),
	(560 , happyReduce_560),
	(561 , happyReduce_561),
	(562 , happyReduce_562),
	(563 , happyReduce_563),
	(564 , happyReduce_564),
	(565 , happyReduce_565),
	(566 , happyReduce_566),
	(567 , happyReduce_567),
	(568 , happyReduce_568),
	(569 , happyReduce_569),
	(570 , happyReduce_570),
	(571 , happyReduce_571),
	(572 , happyReduce_572),
	(573 , happyReduce_573),
	(574 , happyReduce_574),
	(575 , happyReduce_575),
	(576 , happyReduce_576),
	(577 , happyReduce_577),
	(578 , happyReduce_578),
	(579 , happyReduce_579),
	(580 , happyReduce_580),
	(581 , happyReduce_581),
	(582 , happyReduce_582),
	(583 , happyReduce_583),
	(584 , happyReduce_584),
	(585 , happyReduce_585),
	(586 , happyReduce_586),
	(587 , happyReduce_587),
	(588 , happyReduce_588),
	(589 , happyReduce_589),
	(590 , happyReduce_590),
	(591 , happyReduce_591),
	(592 , happyReduce_592),
	(593 , happyReduce_593),
	(594 , happyReduce_594),
	(595 , happyReduce_595),
	(596 , happyReduce_596),
	(597 , happyReduce_597),
	(598 , happyReduce_598),
	(599 , happyReduce_599),
	(600 , happyReduce_600),
	(601 , happyReduce_601),
	(602 , happyReduce_602),
	(603 , happyReduce_603),
	(604 , happyReduce_604),
	(605 , happyReduce_605),
	(606 , happyReduce_606),
	(607 , happyReduce_607),
	(608 , happyReduce_608),
	(609 , happyReduce_609),
	(610 , happyReduce_610),
	(611 , happyReduce_611),
	(612 , happyReduce_612),
	(613 , happyReduce_613),
	(614 , happyReduce_614),
	(615 , happyReduce_615),
	(616 , happyReduce_616),
	(617 , happyReduce_617),
	(618 , happyReduce_618),
	(619 , happyReduce_619),
	(620 , happyReduce_620),
	(621 , happyReduce_621),
	(622 , happyReduce_622),
	(623 , happyReduce_623),
	(624 , happyReduce_624),
	(625 , happyReduce_625),
	(626 , happyReduce_626),
	(627 , happyReduce_627),
	(628 , happyReduce_628),
	(629 , happyReduce_629),
	(630 , happyReduce_630),
	(631 , happyReduce_631),
	(632 , happyReduce_632),
	(633 , happyReduce_633),
	(634 , happyReduce_634),
	(635 , happyReduce_635),
	(636 , happyReduce_636),
	(637 , happyReduce_637),
	(638 , happyReduce_638),
	(639 , happyReduce_639),
	(640 , happyReduce_640),
	(641 , happyReduce_641),
	(642 , happyReduce_642),
	(643 , happyReduce_643),
	(644 , happyReduce_644),
	(645 , happyReduce_645),
	(646 , happyReduce_646),
	(647 , happyReduce_647),
	(648 , happyReduce_648),
	(649 , happyReduce_649),
	(650 , happyReduce_650),
	(651 , happyReduce_651),
	(652 , happyReduce_652),
	(653 , happyReduce_653),
	(654 , happyReduce_654),
	(655 , happyReduce_655),
	(656 , happyReduce_656),
	(657 , happyReduce_657),
	(658 , happyReduce_658),
	(659 , happyReduce_659),
	(660 , happyReduce_660),
	(661 , happyReduce_661),
	(662 , happyReduce_662),
	(663 , happyReduce_663),
	(664 , happyReduce_664),
	(665 , happyReduce_665),
	(666 , happyReduce_666),
	(667 , happyReduce_667),
	(668 , happyReduce_668),
	(669 , happyReduce_669),
	(670 , happyReduce_670),
	(671 , happyReduce_671),
	(672 , happyReduce_672),
	(673 , happyReduce_673),
	(674 , happyReduce_674),
	(675 , happyReduce_675),
	(676 , happyReduce_676),
	(677 , happyReduce_677),
	(678 , happyReduce_678),
	(679 , happyReduce_679),
	(680 , happyReduce_680),
	(681 , happyReduce_681),
	(682 , happyReduce_682),
	(683 , happyReduce_683),
	(684 , happyReduce_684),
	(685 , happyReduce_685),
	(686 , happyReduce_686),
	(687 , happyReduce_687),
	(688 , happyReduce_688),
	(689 , happyReduce_689),
	(690 , happyReduce_690),
	(691 , happyReduce_691),
	(692 , happyReduce_692),
	(693 , happyReduce_693),
	(694 , happyReduce_694),
	(695 , happyReduce_695),
	(696 , happyReduce_696),
	(697 , happyReduce_697),
	(698 , happyReduce_698),
	(699 , happyReduce_699),
	(700 , happyReduce_700),
	(701 , happyReduce_701),
	(702 , happyReduce_702),
	(703 , happyReduce_703),
	(704 , happyReduce_704),
	(705 , happyReduce_705),
	(706 , happyReduce_706),
	(707 , happyReduce_707),
	(708 , happyReduce_708),
	(709 , happyReduce_709),
	(710 , happyReduce_710),
	(711 , happyReduce_711),
	(712 , happyReduce_712),
	(713 , happyReduce_713),
	(714 , happyReduce_714),
	(715 , happyReduce_715),
	(716 , happyReduce_716),
	(717 , happyReduce_717),
	(718 , happyReduce_718),
	(719 , happyReduce_719),
	(720 , happyReduce_720),
	(721 , happyReduce_721),
	(722 , happyReduce_722),
	(723 , happyReduce_723),
	(724 , happyReduce_724),
	(725 , happyReduce_725),
	(726 , happyReduce_726),
	(727 , happyReduce_727),
	(728 , happyReduce_728),
	(729 , happyReduce_729),
	(730 , happyReduce_730),
	(731 , happyReduce_731),
	(732 , happyReduce_732),
	(733 , happyReduce_733),
	(734 , happyReduce_734),
	(735 , happyReduce_735),
	(736 , happyReduce_736),
	(737 , happyReduce_737),
	(738 , happyReduce_738),
	(739 , happyReduce_739),
	(740 , happyReduce_740),
	(741 , happyReduce_741),
	(742 , happyReduce_742),
	(743 , happyReduce_743),
	(744 , happyReduce_744),
	(745 , happyReduce_745),
	(746 , happyReduce_746),
	(747 , happyReduce_747),
	(748 , happyReduce_748),
	(749 , happyReduce_749),
	(750 , happyReduce_750),
	(751 , happyReduce_751),
	(752 , happyReduce_752),
	(753 , happyReduce_753),
	(754 , happyReduce_754),
	(755 , happyReduce_755),
	(756 , happyReduce_756),
	(757 , happyReduce_757),
	(758 , happyReduce_758),
	(759 , happyReduce_759),
	(760 , happyReduce_760),
	(761 , happyReduce_761),
	(762 , happyReduce_762),
	(763 , happyReduce_763),
	(764 , happyReduce_764),
	(765 , happyReduce_765),
	(766 , happyReduce_766),
	(767 , happyReduce_767),
	(768 , happyReduce_768),
	(769 , happyReduce_769),
	(770 , happyReduce_770),
	(771 , happyReduce_771),
	(772 , happyReduce_772),
	(773 , happyReduce_773),
	(774 , happyReduce_774),
	(775 , happyReduce_775),
	(776 , happyReduce_776),
	(777 , happyReduce_777),
	(778 , happyReduce_778),
	(779 , happyReduce_779),
	(780 , happyReduce_780),
	(781 , happyReduce_781),
	(782 , happyReduce_782),
	(783 , happyReduce_783),
	(784 , happyReduce_784),
	(785 , happyReduce_785),
	(786 , happyReduce_786),
	(787 , happyReduce_787)
	]

happy_n_terms = 157 :: Int
happy_n_nonterms = 280 :: Int

happyReduce_11 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_11 = happySpecReduce_2  0# happyReduction_11
happyReduction_11 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn14
		 (let (os,ss,l) = happy_var_1 in map (\x -> x os ss l) happy_var_2
	)}}

happyReduce_12 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_12 = happySpecReduce_2  1# happyReduction_12
happyReduction_12 happy_x_2
	happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn15
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_13 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_13 = happySpecReduce_1  1# happyReduction_13
happyReduction_13 happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	happyIn15
		 ([happy_var_1]
	)}

happyReduce_14 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_14 = happyMonadReduce 2# 2# happyReduction_14
happyReduction_14 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut17 happy_x_2 of { happy_var_2 -> 
	( checkPageModule happy_var_2 happy_var_1)}})
	) (\r -> happyReturn (happyIn16 r))

happyReduce_15 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_15 = happyMonadReduce 5# 2# happyReduction_15
happyReduction_15 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 XCodeTagOpen) -> 
	case happyOut22 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 XCodeTagClose) -> 
	case happyOut17 happy_x_5 of { happy_var_5 -> 
	( let (os,ss,l) = happy_var_1 in checkHybridModule happy_var_5 (happy_var_3 os ss l) happy_var_2 happy_var_4)}}}}})
	) (\r -> happyReturn (happyIn16 r))

happyReduce_16 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_16 = happySpecReduce_2  2# happyReduction_16
happyReduction_16 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut22 happy_x_2 of { happy_var_2 -> 
	happyIn16
		 (let (os,ss,l) = happy_var_1 in happy_var_2 os ss l
	)}}

happyReduce_17 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_17 = happyMonadReduce 9# 3# happyReduction_17
happyReduction_17 (happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut202 happy_x_2 of { happy_var_2 -> 
	case happyOut205 happy_x_3 of { happy_var_3 -> 
	case happyOut207 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XStdTagClose) -> 
	case happyOut200 happy_x_6 of { happy_var_6 -> 
	case happyOutTok happy_x_7 of { (Loc happy_var_7 XCloseTagOpen) -> 
	case happyOut202 happy_x_8 of { happy_var_8 -> 
	case happyOutTok happy_x_9 of { (Loc happy_var_9 XStdTagClose) -> 
	( do { n <- checkEqNames happy_var_2 happy_var_8;
                                                                       let { cn = reverse happy_var_6;
                                                                             as = reverse happy_var_3; };
                                                                       return $ XTag (happy_var_1 <^^> happy_var_9 <** [happy_var_1,happy_var_5,happy_var_7,happy_var_9]) n as happy_var_4 cn })}}}}}}}}})
	) (\r -> happyReturn (happyIn17 r))

happyReduce_18 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_18 = happyReduce 5# 3# happyReduction_18
happyReduction_18 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut202 happy_x_2 of { happy_var_2 -> 
	case happyOut205 happy_x_3 of { happy_var_3 -> 
	case happyOut207 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XEmptyTagClose) -> 
	happyIn17
		 (XETag (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_5]) happy_var_2 (reverse happy_var_3) happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_19 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_19 = happySpecReduce_3  4# happyReduction_19
happyReduction_19 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut272 happy_x_1 of { happy_var_1 -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut273 happy_x_3 of { happy_var_3 -> 
	happyIn18
		 (let (os,ss,ml) = happy_var_2 in (os,happy_var_1:ss++[happy_var_3],happy_var_1 <^^> happy_var_3)
	)}}}

happyReduce_20 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_20 = happySpecReduce_3  5# happyReduction_20
happyReduction_20 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut20 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOut19 happy_x_3 of { happy_var_3 -> 
	happyIn19
		 (let (os,ss,ml) = happy_var_3;
                                                             ss' = reverse happy_var_2 ++ ss;
                                                             l'  = case happy_var_2 of
                                                                    [] -> ann happy_var_1
                                                                    _  -> ann happy_var_1 <++> nIS (last happy_var_2);
                                                         in (happy_var_1 : os, ss', Just $ l'  <+?> ml)
	)}}}

happyReduce_21 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_21 = happySpecReduce_0  5# happyReduction_21
happyReduction_21  =  happyIn19
		 (([],[],Nothing)
	)

happyReduce_22 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_22 = happyReduce 4# 6# happyReduction_22
happyReduction_22 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LANGUAGE) -> 
	case happyOut21 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	happyIn20
		 (LanguagePragma (happy_var_1 <^^> happy_var_4 <** (happy_var_1:snd happy_var_2 ++ reverse happy_var_3 ++ [happy_var_4])) (fst happy_var_2)
	) `HappyStk` happyRest}}}}

happyReduce_23 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_23 = happySpecReduce_3  6# happyReduction_23
happyReduction_23 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn20
		 (let Loc l (OPTIONS (mc, s)) = happy_var_1
                                                      in OptionsPragma (l <^^> happy_var_3 <** (l:reverse happy_var_2 ++ [happy_var_3])) (readTool mc) s
	)}}}

happyReduce_24 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_24 = happySpecReduce_3  6# happyReduction_24
happyReduction_24 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ANN) -> 
	case happyOut103 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn20
		 (AnnModulePragma (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_25 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_25 = happySpecReduce_3  7# happyReduction_25
happyReduction_25 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut263 happy_x_3 of { happy_var_3 -> 
	happyIn21
		 ((fst happy_var_1 ++ [happy_var_3], snd happy_var_1 ++ [happy_var_2])
	)}}}

happyReduce_26 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_26 = happySpecReduce_2  7# happyReduction_26
happyReduction_26 happy_x_2
	happy_x_1
	 =  case happyOut263 happy_x_2 of { happy_var_2 -> 
	happyIn21
		 (([happy_var_2],[])
	)}

happyReduce_27 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_27 = happySpecReduce_2  8# happyReduction_27
happyReduction_27 happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_1 of { happy_var_1 -> 
	case happyOut25 happy_x_2 of { happy_var_2 -> 
	happyIn22
		 (let (is,ds,ss1,inf) = happy_var_2
                 in \os ss l -> Module (l <++> inf <** (ss ++ ss1)) happy_var_1 os is ds
	)}}

happyReduce_28 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_28 = happyReduce 5# 9# happyReduction_28
happyReduction_28 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Module) -> 
	case happyOut283 happy_x_2 of { happy_var_2 -> 
	case happyOut24 happy_x_3 of { happy_var_3 -> 
	case happyOut29 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 KW_Where) -> 
	happyIn23
		 (Just $ ModuleHead (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_5]) happy_var_2 happy_var_3 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_29 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_29 = happySpecReduce_0  9# happyReduction_29
happyReduction_29  =  happyIn23
		 (Nothing
	)

happyReduce_30 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_30 = happySpecReduce_3  10# happyReduction_30
happyReduction_30 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DEPRECATED) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn24
		 (let Loc l (StringTok (s,_)) = happy_var_2 in Just $ DeprText (happy_var_1 <^^> happy_var_3 <** [happy_var_1,l,happy_var_3]) s
	)}}}

happyReduce_31 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_31 = happySpecReduce_3  10# happyReduction_31
happyReduction_31 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 WARNING) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn24
		 (let Loc l (StringTok (s,_)) = happy_var_2 in Just $ WarnText (happy_var_1 <^^> happy_var_3 <** [happy_var_1,l,happy_var_3]) s
	)}}}

happyReduce_32 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_32 = happySpecReduce_0  10# happyReduction_32
happyReduction_32  =  happyIn24
		 (Nothing
	)

happyReduce_33 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_33 = happySpecReduce_3  11# happyReduction_33
happyReduction_33 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut26 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn25
		 (let (is,ds,ss) = happy_var_2 in (is,ds,happy_var_1:ss ++ [happy_var_3], happy_var_1 <^^> happy_var_3)
	)}}}

happyReduce_34 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_34 = happyReduce 4# 11# happyReduction_34
happyReduction_34 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut272 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_2 of { happy_var_2 -> 
	case happyOut273 happy_x_3 of { happy_var_3 -> 
	happyIn25
		 (let (is,ds,ss) = happy_var_2 in (is,ds,happy_var_1:ss ++ [happy_var_3], happy_var_1 <^^> happy_var_3)
	) `HappyStk` happyRest}}}

happyReduce_35 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_35 = happyReduce 4# 12# happyReduction_35
happyReduction_35 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut37 happy_x_2 of { happy_var_2 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	case happyOut58 happy_x_4 of { happy_var_4 -> 
	happyIn26
		 ((reverse (fst happy_var_2), fst happy_var_4, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3 ++ snd happy_var_4)
	) `HappyStk` happyRest}}}}

happyReduce_36 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_36 = happySpecReduce_2  12# happyReduction_36
happyReduction_36 happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut58 happy_x_2 of { happy_var_2 -> 
	happyIn26
		 (([], fst happy_var_2, reverse happy_var_1 ++ snd happy_var_2)
	)}}

happyReduce_37 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_37 = happySpecReduce_3  12# happyReduction_37
happyReduction_37 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut37 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn26
		 ((reverse (fst happy_var_2), [], reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3)
	)}}}

happyReduce_38 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_38 = happySpecReduce_1  12# happyReduction_38
happyReduction_38 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn26
		 (([], [], reverse happy_var_1)
	)}

happyReduce_39 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_39 = happySpecReduce_2  13# happyReduction_39
happyReduction_39 happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 SemiColon) -> 
	happyIn27
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_40 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_40 = happySpecReduce_1  14# happyReduction_40
happyReduction_40 happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 (happy_var_1
	)}

happyReduce_41 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_41 = happySpecReduce_0  14# happyReduction_41
happyReduction_41  =  happyIn28
		 ([]
	)

happyReduce_42 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_42 = happySpecReduce_1  15# happyReduction_42
happyReduction_42 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn29
		 (Just happy_var_1
	)}

happyReduce_43 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_43 = happySpecReduce_0  15# happyReduction_43
happyReduction_43  =  happyIn29
		 (Nothing
	)

happyReduce_44 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_44 = happyReduce 4# 16# happyReduction_44
happyReduction_44 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut32 happy_x_2 of { happy_var_2 -> 
	case happyOut31 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn30
		 (ExportSpecList (happy_var_1 <^^> happy_var_4 <** (happy_var_1:reverse (snd happy_var_2) ++ happy_var_3 ++ [happy_var_4])) (reverse (fst happy_var_2))
	) `HappyStk` happyRest}}}}

happyReduce_45 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_45 = happySpecReduce_3  16# happyReduction_45
happyReduction_45 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut31 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn30
		 (ExportSpecList (happy_var_1 <^^> happy_var_3 <** (happy_var_1:happy_var_2++[happy_var_3])) []
	)}}}

happyReduce_46 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_46 = happySpecReduce_1  17# happyReduction_46
happyReduction_46 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Comma) -> 
	happyIn31
		 ([happy_var_1]
	)}

happyReduce_47 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_47 = happySpecReduce_0  17# happyReduction_47
happyReduction_47  =  happyIn31
		 ([  ]
	)

happyReduce_48 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_48 = happySpecReduce_3  18# happyReduction_48
happyReduction_48 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	happyIn32
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_49 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_49 = happySpecReduce_1  18# happyReduction_49
happyReduction_49 happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn32
		 (([happy_var_1],[])
	)}

happyReduce_50 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_50 = happySpecReduce_1  19# happyReduction_50
happyReduction_50 happy_x_1
	 =  case happyOut243 happy_x_1 of { happy_var_1 -> 
	happyIn33
		 (EVar (ann happy_var_1) happy_var_1
	)}

happyReduce_51 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_51 = happyMonadReduce 2# 19# happyReduction_51
happyReduction_51 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut36 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled ExplicitNamespaces;
                                                      return (EAbs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1, srcInfoSpan (ann happy_var_2)]) (TypeNamespace (nIS happy_var_1 <** [happy_var_1])) happy_var_2) })}})
	) (\r -> happyReturn (happyIn33 r))

happyReduce_52 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_52 = happySpecReduce_1  19# happyReduction_52
happyReduction_52 happy_x_1
	 =  case happyOut285 happy_x_1 of { happy_var_1 -> 
	happyIn33
		 (EAbs (ann happy_var_1) (NoNamespace (ann happy_var_1)) happy_var_1
	)}

happyReduce_53 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_53 = happySpecReduce_3  19# happyReduction_53
happyReduction_53 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut285 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn33
		 (EThingWith (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3])    (NoWildcard noSrcSpan) happy_var_1 []
	)}}}

happyReduce_54 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_54 = happyMonadReduce 4# 19# happyReduction_54
happyReduction_54 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut285 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut34 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	( mkEThingWith (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:reverse (snd happy_var_3) ++ [happy_var_4])) happy_var_1 (reverse $ fst happy_var_3))}}}})
	) (\r -> happyReturn (happyIn33 r))

happyReduce_55 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_55 = happySpecReduce_2  19# happyReduction_55
happyReduction_55 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Module) -> 
	case happyOut283 happy_x_2 of { happy_var_2 -> 
	happyIn33
		 (EModuleContents (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_56 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_56 = happyMonadReduce 2# 19# happyReduction_56
happyReduction_56 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut247 happy_x_2 of { happy_var_2 -> 
	(  do { checkEnabled PatternSynonyms;
                                                      return $ EAbs (nIS happy_var_1 <++> (ann happy_var_2) <** [happy_var_1])
                                                                 (PatternNamespace (nIS happy_var_1)) happy_var_2 })}})
	) (\r -> happyReturn (happyIn33 r))

happyReduce_57 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_57 = happySpecReduce_3  20# happyReduction_57
happyReduction_57 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut34 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	happyIn34
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_58 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_58 = happySpecReduce_1  20# happyReduction_58
happyReduction_58 happy_x_1
	 =  case happyOut35 happy_x_1 of { happy_var_1 -> 
	happyIn34
		 (([happy_var_1],[])
	)}

happyReduce_59 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_59 = happySpecReduce_1  21# happyReduction_59
happyReduction_59 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DotDot) -> 
	happyIn35
		 (Left happy_var_1
	)}

happyReduce_60 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_60 = happySpecReduce_1  21# happyReduction_60
happyReduction_60 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn35
		 (Right happy_var_1
	)}

happyReduce_61 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_61 = happySpecReduce_1  22# happyReduction_61
happyReduction_61 happy_x_1
	 =  case happyOut243 happy_x_1 of { happy_var_1 -> 
	happyIn36
		 (happy_var_1
	)}

happyReduce_62 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_62 = happySpecReduce_1  22# happyReduction_62
happyReduction_62 happy_x_1
	 =  case happyOut247 happy_x_1 of { happy_var_1 -> 
	happyIn36
		 (happy_var_1
	)}

happyReduce_63 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_63 = happySpecReduce_3  23# happyReduction_63
happyReduction_63 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	happyIn37
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_64 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_64 = happySpecReduce_1  23# happyReduction_64
happyReduction_64 happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	happyIn37
		 (([happy_var_1],[])
	)}

happyReduce_65 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_65 = happyReduce 8# 24# happyReduction_65
happyReduction_65 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Import) -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOut40 happy_x_3 of { happy_var_3 -> 
	case happyOut41 happy_x_4 of { happy_var_4 -> 
	case happyOut42 happy_x_5 of { happy_var_5 -> 
	case happyOut283 happy_x_6 of { happy_var_6 -> 
	case happyOut43 happy_x_7 of { happy_var_7 -> 
	case happyOut44 happy_x_8 of { happy_var_8 -> 
	happyIn38
		 (let { (mmn,ss,ml) = happy_var_7 ;
                                      l = nIS happy_var_1 <++> ann happy_var_6 <+?> ml <+?> (fmap ann) happy_var_8 <** (happy_var_1:snd happy_var_2 ++ snd happy_var_3 ++ snd happy_var_4 ++ snd happy_var_5 ++ ss)}
                                 in ImportDecl l happy_var_6 (fst happy_var_4) (fst happy_var_2) (fst happy_var_3) (fst happy_var_5) mmn happy_var_8
	) `HappyStk` happyRest}}}}}}}}

happyReduce_66 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_66 = happySpecReduce_2  25# happyReduction_66
happyReduction_66 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 SOURCE) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 PragmaEnd) -> 
	happyIn39
		 ((True,[happy_var_1,happy_var_2])
	)}}

happyReduce_67 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_67 = happySpecReduce_0  25# happyReduction_67
happyReduction_67  =  happyIn39
		 ((False,[])
	)

happyReduce_68 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_68 = happyMonadReduce 1# 26# happyReduction_68
happyReduction_68 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	( do { checkEnabledOneOf [Safe, SafeImports, Trustworthy] ;
                                                 return (True, [happy_var_1]) })})
	) (\r -> happyReturn (happyIn40 r))

happyReduce_69 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_69 = happySpecReduce_0  26# happyReduction_69
happyReduction_69  =  happyIn40
		 ((False, [])
	)

happyReduce_70 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_70 = happySpecReduce_1  27# happyReduction_70
happyReduction_70 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Qualified) -> 
	happyIn41
		 ((True,[happy_var_1])
	)}

happyReduce_71 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_71 = happySpecReduce_0  27# happyReduction_71
happyReduction_71  =  happyIn41
		 ((False, [])
	)

happyReduce_72 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_72 = happyMonadReduce 1# 28# happyReduction_72
happyReduction_72 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { happy_var_1 -> 
	( do { checkEnabled PackageImports ;
                                                      let { Loc l (StringTok (s,_)) = happy_var_1 } ;
                                                      return $ (Just s,[l]) })})
	) (\r -> happyReturn (happyIn42 r))

happyReduce_73 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_73 = happySpecReduce_0  28# happyReduction_73
happyReduction_73  =  happyIn42
		 ((Nothing,[])
	)

happyReduce_74 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_74 = happySpecReduce_2  29# happyReduction_74
happyReduction_74 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_As) -> 
	case happyOut283 happy_x_2 of { happy_var_2 -> 
	happyIn43
		 ((Just happy_var_2,[happy_var_1],Just (nIS happy_var_1 <++> ann happy_var_2))
	)}}

happyReduce_75 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_75 = happySpecReduce_0  29# happyReduction_75
happyReduction_75  =  happyIn43
		 ((Nothing,[],Nothing)
	)

happyReduce_76 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_76 = happySpecReduce_1  30# happyReduction_76
happyReduction_76 happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	happyIn44
		 (Just happy_var_1
	)}

happyReduce_77 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_77 = happySpecReduce_0  30# happyReduction_77
happyReduction_77  =  happyIn44
		 (Nothing
	)

happyReduce_78 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_78 = happyReduce 5# 31# happyReduction_78
happyReduction_78 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	case happyOut31 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn45
		 (let {(b,ml,s) = happy_var_1 ;
                                                      l = (ml <?+> (happy_var_2 <^^> happy_var_5)) <** (s ++ happy_var_2:reverse (snd happy_var_3) ++ happy_var_4 ++ [happy_var_5])}
                                                 in ImportSpecList l b (reverse (fst happy_var_3))
	) `HappyStk` happyRest}}}}}

happyReduce_79 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_79 = happyReduce 4# 31# happyReduction_79
happyReduction_79 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut31 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn45
		 (let {(b,ml,s) = happy_var_1 ; l = (ml <?+> (happy_var_2 <^^> happy_var_4)) <** (s ++ happy_var_2:happy_var_3 ++ [happy_var_4])}
                                                 in ImportSpecList l b []
	) `HappyStk` happyRest}}}}

happyReduce_80 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_80 = happySpecReduce_1  32# happyReduction_80
happyReduction_80 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Hiding) -> 
	happyIn46
		 ((True,Just (nIS happy_var_1),[happy_var_1])
	)}

happyReduce_81 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_81 = happySpecReduce_0  32# happyReduction_81
happyReduction_81  =  happyIn46
		 ((False,Nothing,[])
	)

happyReduce_82 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_82 = happySpecReduce_3  33# happyReduction_82
happyReduction_82 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut47 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn47
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_83 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_83 = happySpecReduce_1  33# happyReduction_83
happyReduction_83 happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	happyIn47
		 (([happy_var_1],[])
	)}

happyReduce_84 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_84 = happySpecReduce_1  34# happyReduction_84
happyReduction_84 happy_x_1
	 =  case happyOut241 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (IVar (ann happy_var_1) happy_var_1
	)}

happyReduce_85 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_85 = happyMonadReduce 2# 34# happyReduction_85
happyReduction_85 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut241 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled ExplicitNamespaces;
                                                      return (IAbs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1, srcInfoSpan (ann happy_var_2)]) (TypeNamespace (nIS happy_var_1 <** [happy_var_1])) happy_var_2) })}})
	) (\r -> happyReturn (happyIn48 r))

happyReduce_86 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_86 = happyMonadReduce 2# 34# happyReduction_86
happyReduction_86 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut245 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled PatternSynonyms;
                                                      return (IAbs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1, srcInfoSpan (ann happy_var_2)]) (PatternNamespace (nIS happy_var_1 <** [happy_var_1])) happy_var_2) })}})
	) (\r -> happyReturn (happyIn48 r))

happyReduce_87 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_87 = happySpecReduce_1  34# happyReduction_87
happyReduction_87 happy_x_1
	 =  case happyOut284 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (IAbs (ann happy_var_1) (NoNamespace (ann happy_var_1)) happy_var_1
	)}

happyReduce_88 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_88 = happyReduce 4# 34# happyReduction_88
happyReduction_88 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut284 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DotDot) -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn48
		 (IThingAll  (ann happy_var_1 <++> nIS happy_var_4 <** [happy_var_2,happy_var_3,happy_var_4]) happy_var_1
	) `HappyStk` happyRest}}}}

happyReduce_89 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_89 = happySpecReduce_3  34# happyReduction_89
happyReduction_89 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut284 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn48
		 (IThingWith (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3])    happy_var_1 []
	)}}}

happyReduce_90 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_90 = happyReduce 4# 34# happyReduction_90
happyReduction_90 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut284 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut49 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn48
		 (IThingWith (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:reverse (snd happy_var_3) ++ [happy_var_4])) happy_var_1 (reverse (fst happy_var_3))
	) `HappyStk` happyRest}}}}

happyReduce_91 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_91 = happySpecReduce_3  35# happyReduction_91
happyReduction_91 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut50 happy_x_3 of { happy_var_3 -> 
	happyIn49
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_92 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_92 = happySpecReduce_1  35# happyReduction_92
happyReduction_92 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn49
		 (([happy_var_1],[])
	)}

happyReduce_93 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_93 = happySpecReduce_1  36# happyReduction_93
happyReduction_93 happy_x_1
	 =  case happyOut241 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (VarName (ann happy_var_1) happy_var_1
	)}

happyReduce_94 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_94 = happySpecReduce_1  36# happyReduction_94
happyReduction_94 happy_x_1
	 =  case happyOut245 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (ConName (ann happy_var_1) happy_var_1
	)}

happyReduce_95 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_95 = happySpecReduce_3  37# happyReduction_95
happyReduction_95 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_2 of { happy_var_2 -> 
	case happyOut54 happy_x_3 of { happy_var_3 -> 
	happyIn51
		 (let (ops,ss,l) = happy_var_3
                                                 in InfixDecl (ann happy_var_1 <++> l <** (snd happy_var_2 ++ reverse ss)) happy_var_1 (fst happy_var_2) (reverse ops)
	)}}}

happyReduce_96 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_96 = happySpecReduce_0  38# happyReduction_96
happyReduction_96  =  happyIn52
		 ((Nothing, [])
	)

happyReduce_97 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_97 = happyMonadReduce 1# 38# happyReduction_97
happyReduction_97 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { happy_var_1 -> 
	( let Loc l (IntTok (i,_)) = happy_var_1 in checkPrec i >>= \i -> return (Just i, [l]))})
	) (\r -> happyReturn (happyIn52 r))

happyReduce_98 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_98 = happySpecReduce_1  39# happyReduction_98
happyReduction_98 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Infix) -> 
	happyIn53
		 (AssocNone  $ nIS happy_var_1
	)}

happyReduce_99 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_99 = happySpecReduce_1  39# happyReduction_99
happyReduction_99 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_InfixL) -> 
	happyIn53
		 (AssocLeft  $ nIS happy_var_1
	)}

happyReduce_100 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_100 = happySpecReduce_1  39# happyReduction_100
happyReduction_100 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_InfixR) -> 
	happyIn53
		 (AssocRight $ nIS happy_var_1
	)}

happyReduce_101 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_101 = happySpecReduce_3  40# happyReduction_101
happyReduction_101 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut253 happy_x_3 of { happy_var_3 -> 
	happyIn54
		 (let (ops,ss,l) = happy_var_1 in (happy_var_3 : ops, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_102 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_102 = happySpecReduce_1  40# happyReduction_102
happyReduction_102 happy_x_1
	 =  case happyOut253 happy_x_1 of { happy_var_1 -> 
	happyIn54
		 (([happy_var_1],[],ann happy_var_1)
	)}

happyReduce_103 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_103 = happySpecReduce_0  41# happyReduction_103
happyReduction_103  =  happyIn55
		 (Nothing
	)

happyReduce_104 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_104 = happySpecReduce_1  41# happyReduction_104
happyReduction_104 happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	happyIn55
		 (Just happy_var_1
	)}

happyReduce_105 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_105 = happyReduce 4# 42# happyReduction_105
happyReduction_105 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 Bar) -> 
	case happyOut287 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightArrow) -> 
	case happyOut57 happy_x_4 of { happy_var_4 -> 
	happyIn56
		 (InjectivityInfo (nIS happy_var_1 <++> ann (last happy_var_4) <** [happy_var_1,happy_var_3]) happy_var_2 (reverse happy_var_4)
	) `HappyStk` happyRest}}}}

happyReduce_106 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_106 = happySpecReduce_2  43# happyReduction_106
happyReduction_106 happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOut287 happy_x_2 of { happy_var_2 -> 
	happyIn57
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_107 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_107 = happySpecReduce_1  43# happyReduction_107
happyReduction_107 happy_x_1
	 =  case happyOut287 happy_x_1 of { happy_var_1 -> 
	happyIn57
		 ([happy_var_1]
	)}

happyReduce_108 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_108 = happyMonadReduce 2# 44# happyReduction_108
happyReduction_108 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	( checkRevDecls (fst happy_var_1) >>= \ds -> return (ds, snd happy_var_1 ++ reverse happy_var_2))}})
	) (\r -> happyReturn (happyIn58 r))

happyReduce_109 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_109 = happySpecReduce_3  45# happyReduction_109
happyReduction_109 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut60 happy_x_3 of { happy_var_3 -> 
	happyIn59
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_110 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_110 = happySpecReduce_1  45# happyReduction_110
happyReduction_110 happy_x_1
	 =  case happyOut60 happy_x_1 of { happy_var_1 -> 
	happyIn59
		 (([happy_var_1],[])
	)}

happyReduce_111 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_111 = happyMonadReduce 1# 46# happyReduction_111
happyReduction_111 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut65 happy_x_1 of { happy_var_1 -> 
	( checkEnabled RoleAnnotations >> return happy_var_1)})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_112 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_112 = happyMonadReduce 4# 46# happyReduction_112
happyReduction_112 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut105 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut119 happy_x_4 of { happy_var_4 -> 
	( do { dh <- checkSimpleType happy_var_2;
                       let {l = nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]};
                       return (TypeDecl l dh happy_var_4) })}}}})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_113 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_113 = happyMonadReduce 6# 46# happyReduction_113
happyReduction_113 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Family) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	case happyOut62 happy_x_4 of { happy_var_4 -> 
	case happyOut55 happy_x_5 of { happy_var_5 -> 
	case happyOut69 happy_x_6 of { happy_var_6 -> 
	( do { dh <- checkSimpleType happy_var_3;
                       let {l = nIS happy_var_1 <++> ann happy_var_3 <** [happy_var_1,happy_var_2]};
                       case happy_var_6 of {
                         Nothing    -> return (TypeFamDecl l dh happy_var_4 happy_var_5);
                         Just (x,a) -> return (ClosedTypeFamDecl (l <** [a]) dh happy_var_4 happy_var_5 x); }})}}}}}})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_114 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_114 = happyMonadReduce 5# 46# happyReduction_114
happyReduction_114 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut104 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 Equals) -> 
	case happyOut119 happy_x_5 of { happy_var_5 -> 
	( do { -- no checkSimpleType happy_var_4 since dtype may contain type patterns
                       checkEnabled TypeFamilies ;
                       let {l = nIS happy_var_1 <++> ann happy_var_5 <** [happy_var_1,happy_var_2,happy_var_4]};
                       return (TypeInsDecl l happy_var_3 happy_var_5) })}}}}})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_115 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_115 = happyMonadReduce 4# 46# happyReduction_115
happyReduction_115 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	case happyOut136 happy_x_3 of { happy_var_3 -> 
	case happyOut144 happy_x_4 of { happy_var_4 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_2;
                       let { (qds,ss,minf) = happy_var_3;
                             l = happy_var_1 <> happy_var_2 <+?> minf <+?> fmap ann (listToMaybe happy_var_4) <** ss};
                       checkDataOrNew happy_var_1 qds;
                       return (DataDecl l happy_var_1 cs dh (reverse qds) (reverse happy_var_4)) })}}}})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_116 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_116 = happyMonadReduce 5# 46# happyReduction_116
happyReduction_116 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	case happyOut155 happy_x_3 of { happy_var_3 -> 
	case happyOut132 happy_x_4 of { happy_var_4 -> 
	case happyOut144 happy_x_5 of { happy_var_5 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_2;
                       let { (gs,ss,minf) = happy_var_4;
                             derivs' = reverse happy_var_5;
                             l = ann happy_var_1 <+?> minf <+?> fmap ann (listToMaybe happy_var_5) <** (snd happy_var_3 ++ ss)};
                       checkDataOrNewG happy_var_1 gs;
                       case (gs, fst happy_var_3) of
                        ([], Nothing) -> return (DataDecl l happy_var_1 cs dh [] derivs')
                        _ -> checkEnabled GADTs >> return (GDataDecl l happy_var_1 cs dh (fst happy_var_3) (reverse gs) derivs') })}}}}})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_117 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_117 = happyMonadReduce 4# 46# happyReduction_117
happyReduction_117 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Family) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	case happyOut61 happy_x_4 of { happy_var_4 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_3;
                       let {l = nIS happy_var_1 <++> ann happy_var_3 <+?> (fmap ann) happy_var_4 <** [happy_var_1,happy_var_2]};
                       return (DataFamDecl l cs dh happy_var_4) })}}}})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_118 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_118 = happyMonadReduce 5# 46# happyReduction_118
happyReduction_118 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	case happyOut136 happy_x_4 of { happy_var_4 -> 
	case happyOut144 happy_x_5 of { happy_var_5 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       checkEnabled TypeFamilies ;
                       let { (qds,ss,minf) = happy_var_4 ;
                             l = happy_var_1 <> happy_var_3 <+?> minf <+?> fmap ann (listToMaybe happy_var_5) <** happy_var_2:ss };
                       checkDataOrNew happy_var_1 qds;
                       return (DataInsDecl l happy_var_1 happy_var_3 (reverse qds) (reverse happy_var_5)) })}}}}})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_119 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_119 = happyMonadReduce 6# 46# happyReduction_119
happyReduction_119 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	case happyOut155 happy_x_4 of { happy_var_4 -> 
	case happyOut132 happy_x_5 of { happy_var_5 -> 
	case happyOut144 happy_x_6 of { happy_var_6 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       checkEnabled TypeFamilies ;
                       let {(gs,ss,minf) = happy_var_5;
                            derivs' = reverse happy_var_6;
                            l = ann happy_var_1 <+?> minf <+?> fmap ann (listToMaybe derivs') <** (happy_var_2:snd happy_var_4 ++ ss)};
                       checkDataOrNewG happy_var_1 gs;
                       return (GDataInsDecl l happy_var_1 happy_var_3 (fst happy_var_4) (reverse gs) derivs') })}}}}}})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_120 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_120 = happyMonadReduce 4# 46# happyReduction_120
happyReduction_120 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Class) -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	case happyOut129 happy_x_3 of { happy_var_3 -> 
	case happyOut157 happy_x_4 of { happy_var_4 -> 
	( do { (cs,dh) <- checkClassHeader happy_var_2;
                       let {(fds,ss1,minf1) = happy_var_3;(mcs,ss2,minf2) = happy_var_4} ;
                       let { l = nIS happy_var_1 <++> ann happy_var_2 <+?> minf1 <+?> minf2 <** (happy_var_1:ss1 ++ ss2)} ;
                       return (ClassDecl l cs dh fds mcs) })}}}})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_121 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_121 = happyMonadReduce 4# 46# happyReduction_121
happyReduction_121 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Instance) -> 
	case happyOut68 happy_x_2 of { happy_var_2 -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	case happyOut163 happy_x_4 of { happy_var_4 -> 
	( do { ih <- checkInstHeader happy_var_3;
                       let {(mis,ss,minf) = happy_var_4};
                       return (InstDecl (nIS happy_var_1 <++> ann happy_var_3 <+?> minf <** (happy_var_1:ss)) happy_var_2 ih mis) })}}}})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_122 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_122 = happyMonadReduce 5# 46# happyReduction_122
happyReduction_122 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOut282 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_Instance) -> 
	case happyOut68 happy_x_4 of { happy_var_4 -> 
	case happyOut120 happy_x_5 of { happy_var_5 -> 
	( do { checkEnabled StandaloneDeriving ;
                       ih <- checkInstHeader happy_var_5;
                       let {l = nIS happy_var_1 <++> ann happy_var_5 <** [happy_var_1,happy_var_3]};
                       return (DerivDecl l happy_var_2 happy_var_4 ih) })}}}}})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_123 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_123 = happyReduce 4# 46# happyReduction_123
happyReduction_123 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Default) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut74 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn60
		 (DefaultDecl (happy_var_1 <^^> happy_var_4 <** (happy_var_1:happy_var_2 : snd happy_var_3 ++ [happy_var_4])) (fst happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_124 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_124 = happyMonadReduce 1# 46# happyReduction_124
happyReduction_124 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut176 happy_x_1 of { happy_var_1 -> 
	( do
              checkToplevel happy_var_1
              checkExpr happy_var_1 >>= \e -> return (SpliceDecl (ann e) e))})
	) (\r -> happyReturn (happyIn60 r))

happyReduce_125 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_125 = happyReduce 5# 46# happyReduction_125
happyReduction_125 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Foreign) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Import) -> 
	case happyOut90 happy_x_3 of { happy_var_3 -> 
	case happyOut91 happy_x_4 of { happy_var_4 -> 
	case happyOut92 happy_x_5 of { happy_var_5 -> 
	happyIn60
		 (let (s,n,t,ss) = happy_var_5 in ForImp (nIS happy_var_1 <++> ann t <** (happy_var_1:happy_var_2:ss)) happy_var_3 happy_var_4 s n t
	) `HappyStk` happyRest}}}}}

happyReduce_126 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_126 = happyReduce 4# 46# happyReduction_126
happyReduction_126 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Foreign) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Export) -> 
	case happyOut90 happy_x_3 of { happy_var_3 -> 
	case happyOut92 happy_x_4 of { happy_var_4 -> 
	happyIn60
		 (let (s,n,t,ss) = happy_var_4 in ForExp (nIS happy_var_1 <++> ann t <** (happy_var_1:happy_var_2:ss)) happy_var_3    s n t
	) `HappyStk` happyRest}}}}

happyReduce_127 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_127 = happySpecReduce_3  46# happyReduction_127
happyReduction_127 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 RULES) -> 
	case happyOut93 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn60
		 (RulePragmaDecl (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) $ reverse happy_var_2
	)}}}

happyReduce_128 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_128 = happySpecReduce_3  46# happyReduction_128
happyReduction_128 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DEPRECATED) -> 
	case happyOut99 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn60
		 (DeprPragmaDecl (happy_var_1 <^^> happy_var_3 <** (happy_var_1:snd happy_var_2++[happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_129 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_129 = happySpecReduce_3  46# happyReduction_129
happyReduction_129 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 WARNING) -> 
	case happyOut99 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn60
		 (WarnPragmaDecl (happy_var_1 <^^> happy_var_3 <** (happy_var_1:snd happy_var_2++[happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_130 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_130 = happySpecReduce_3  46# happyReduction_130
happyReduction_130 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ANN) -> 
	case happyOut103 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn60
		 (AnnPragma      (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_131 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_131 = happyReduce 4# 46# happyReduction_131
happyReduction_131 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 COMPLETE) -> 
	case happyOut246 happy_x_2 of { happy_var_2 -> 
	case happyOut156 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	happyIn60
		 (let com = maybe [] ((:[]) . fst) happy_var_3; ts = fmap snd happy_var_3 in
(CompletePragma (happy_var_1 <^^> happy_var_4 <** ([happy_var_1] ++ fst happy_var_2 ++ com ++ [happy_var_4])) (snd happy_var_2) ts)
	) `HappyStk` happyRest}}}}

happyReduce_132 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_132 = happySpecReduce_1  46# happyReduction_132
happyReduction_132 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn60
		 (happy_var_1
	)}

happyReduce_133 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_133 = happySpecReduce_0  47# happyReduction_133
happyReduction_133  =  happyIn61
		 (Nothing
	)

happyReduce_134 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_134 = happySpecReduce_2  47# happyReduction_134
happyReduction_134 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut149 happy_x_2 of { happy_var_2 -> 
	happyIn61
		 ((Just $ KindSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2)
	)}}

happyReduce_135 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_135 = happySpecReduce_0  48# happyReduction_135
happyReduction_135  =  happyIn62
		 (Nothing
	)

happyReduce_136 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_136 = happySpecReduce_2  48# happyReduction_136
happyReduction_136 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut149 happy_x_2 of { happy_var_2 -> 
	happyIn62
		 ((Just $ KindSig  (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2)
	)}}

happyReduce_137 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_137 = happySpecReduce_2  48# happyReduction_137
happyReduction_137 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut126 happy_x_2 of { happy_var_2 -> 
	happyIn62
		 ((Just $ TyVarSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2)
	)}}

happyReduce_138 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_138 = happySpecReduce_0  49# happyReduction_138
happyReduction_138  =  happyIn63
		 ((Nothing, Nothing)
	)

happyReduce_139 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_139 = happySpecReduce_2  49# happyReduction_139
happyReduction_139 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut149 happy_x_2 of { happy_var_2 -> 
	happyIn63
		 ((Just (KindSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2), Nothing)
	)}}

happyReduce_140 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_140 = happySpecReduce_3  49# happyReduction_140
happyReduction_140 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut126 happy_x_2 of { happy_var_2 -> 
	case happyOut56 happy_x_3 of { happy_var_3 -> 
	happyIn63
		 ((Just (TyVarSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2), Just happy_var_3)
	)}}}

happyReduce_141 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_141 = happySpecReduce_0  50# happyReduction_141
happyReduction_141  =  happyIn64
		 ((Nothing, Nothing, Nothing)
	)

happyReduce_142 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_142 = happySpecReduce_2  50# happyReduction_142
happyReduction_142 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut149 happy_x_2 of { happy_var_2 -> 
	happyIn64
		 ((Just (KindSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2), Nothing, Nothing)
	)}}

happyReduce_143 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_143 = happySpecReduce_3  50# happyReduction_143
happyReduction_143 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut119 happy_x_2 of { happy_var_2 -> 
	case happyOut55 happy_x_3 of { happy_var_3 -> 
	happyIn64
		 ((Nothing, Just (happy_var_1, happy_var_2), happy_var_3)
	)}}}

happyReduce_144 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_144 = happyMonadReduce 4# 51# happyReduction_144
happyReduction_144 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Role) -> 
	case happyOut117 happy_x_3 of { happy_var_3 -> 
	case happyOut66 happy_x_4 of { happy_var_4 -> 
	( mkRoleAnnotDecl happy_var_1 happy_var_2 happy_var_3 (reverse happy_var_4))}}}})
	) (\r -> happyReturn (happyIn65 r))

happyReduce_145 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_145 = happySpecReduce_0  52# happyReduction_145
happyReduction_145  =  happyIn66
		 ([]
	)

happyReduce_146 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_146 = happySpecReduce_2  52# happyReduction_146
happyReduction_146 happy_x_2
	happy_x_1
	 =  case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOut67 happy_x_2 of { happy_var_2 -> 
	happyIn66
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_147 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_147 = happySpecReduce_1  53# happyReduction_147
happyReduction_147 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn67
		 (let (VarId v) = unLoc happy_var_1 in (Just v, nIS $ loc happy_var_1)
	)}

happyReduce_148 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_148 = happySpecReduce_1  53# happyReduction_148
happyReduction_148 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Underscore) -> 
	happyIn67
		 ((Nothing, nIS happy_var_1)
	)}

happyReduce_149 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_149 = happySpecReduce_2  54# happyReduction_149
happyReduction_149 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 OVERLAP) -> 
	happyIn68
		 (Just (Overlap (nIS happy_var_1))
	)}

happyReduce_150 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_150 = happySpecReduce_2  54# happyReduction_150
happyReduction_150 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 OVERLAPS) -> 
	happyIn68
		 (Just (Overlaps (nIS happy_var_1))
	)}

happyReduce_151 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_151 = happySpecReduce_2  54# happyReduction_151
happyReduction_151 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 OVERLAPPING) -> 
	happyIn68
		 (Just (Overlapping (nIS happy_var_1))
	)}

happyReduce_152 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_152 = happySpecReduce_2  54# happyReduction_152
happyReduction_152 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 OVERLAPPABLE) -> 
	happyIn68
		 (Just (Overlappable (nIS happy_var_1))
	)}

happyReduce_153 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_153 = happySpecReduce_2  54# happyReduction_153
happyReduction_153 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 INCOHERENT) -> 
	happyIn68
		 (Just (Incoherent (nIS happy_var_1))
	)}

happyReduce_154 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_154 = happySpecReduce_2  54# happyReduction_154
happyReduction_154 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 NO_OVERLAP) -> 
	happyIn68
		 (Just (NoOverlap (nIS happy_var_1))
	)}

happyReduce_155 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_155 = happySpecReduce_0  54# happyReduction_155
happyReduction_155  =  happyIn68
		 (Nothing
	)

happyReduce_156 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_156 = happySpecReduce_0  55# happyReduction_156
happyReduction_156  =  happyIn69
		 (Nothing
	)

happyReduce_157 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_157 = happySpecReduce_2  55# happyReduction_157
happyReduction_157 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	happyIn69
		 (Just (happy_var_2, happy_var_1)
	)}}

happyReduce_158 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_158 = happySpecReduce_3  56# happyReduction_158
happyReduction_158 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_2 of { happy_var_2 -> 
	happyIn70
		 (happy_var_2
	)}

happyReduce_159 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_159 = happySpecReduce_3  56# happyReduction_159
happyReduction_159 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_2 of { happy_var_2 -> 
	happyIn70
		 (happy_var_2
	)}

happyReduce_160 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_160 = happySpecReduce_3  57# happyReduction_160
happyReduction_160 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn71
		 (happy_var_1 ++ [happy_var_3]
	)}}

happyReduce_161 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_161 = happySpecReduce_2  57# happyReduction_161
happyReduction_161 happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 (happy_var_1
	)}

happyReduce_162 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_162 = happySpecReduce_1  57# happyReduction_162
happyReduction_162 happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 ([happy_var_1]
	)}

happyReduce_163 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_163 = happyMonadReduce 3# 58# happyReduction_163
happyReduction_163 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut119 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Equals) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	( do { checkEnabled TypeFamilies ;
                        return (TypeEqn (ann happy_var_1 <++> ann happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3) })}}})
	) (\r -> happyReturn (happyIn72 r))

happyReduce_164 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_164 = happySpecReduce_1  59# happyReduction_164
happyReduction_164 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	happyIn73
		 (DataType $ nIS happy_var_1
	)}

happyReduce_165 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_165 = happySpecReduce_1  59# happyReduction_165
happyReduction_165 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_NewType) -> 
	happyIn73
		 (NewType  $ nIS happy_var_1
	)}

happyReduce_166 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_166 = happyMonadReduce 1# 60# happyReduction_166
happyReduction_166 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut122 happy_x_1 of { happy_var_1 -> 
	( do { ts <- mapM checkType (fst happy_var_1);
                                              return $ (reverse ts, reverse (snd happy_var_1)) })})
	) (\r -> happyReturn (happyIn74 r))

happyReduce_167 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_167 = happySpecReduce_1  60# happyReduction_167
happyReduction_167 happy_x_1
	 =  case happyOut106 happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (([happy_var_1],[])
	)}

happyReduce_168 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_168 = happySpecReduce_0  60# happyReduction_168
happyReduction_168  =  happyIn74
		 (([],[])
	)

happyReduce_169 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_169 = happyMonadReduce 3# 61# happyReduction_169
happyReduction_169 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut76 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	( checkRevDecls (fst happy_var_2) >>= \ds -> return (ds, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3))}}})
	) (\r -> happyReturn (happyIn75 r))

happyReduce_170 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_170 = happySpecReduce_1  61# happyReduction_170
happyReduction_170 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn75
		 (([],reverse happy_var_1)
	)}

happyReduce_171 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_171 = happySpecReduce_3  62# happyReduction_171
happyReduction_171 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut77 happy_x_3 of { happy_var_3 -> 
	happyIn76
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_172 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_172 = happySpecReduce_1  62# happyReduction_172
happyReduction_172 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn76
		 (([happy_var_1],[])
	)}

happyReduce_173 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_173 = happySpecReduce_1  63# happyReduction_173
happyReduction_173 happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_174 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_174 = happySpecReduce_1  63# happyReduction_174
happyReduction_174 happy_x_1
	 =  case happyOut51 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_175 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_175 = happySpecReduce_1  63# happyReduction_175
happyReduction_175 happy_x_1
	 =  case happyOut168 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_176 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_176 = happySpecReduce_1  63# happyReduction_176
happyReduction_176 happy_x_1
	 =  case happyOut274 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_177 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_177 = happySpecReduce_1  63# happyReduction_177
happyReduction_177 happy_x_1
	 =  case happyOut280 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_178 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_178 = happySpecReduce_3  64# happyReduction_178
happyReduction_178 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn78
		 (BDecls (happy_var_1 <^^> happy_var_3 <** (happy_var_1:snd happy_var_2++[happy_var_3])) (fst happy_var_2)
	)}}}

happyReduce_179 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_179 = happySpecReduce_3  64# happyReduction_179
happyReduction_179 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut272 happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	case happyOut273 happy_x_3 of { happy_var_3 -> 
	happyIn78
		 (let l' = if null (fst happy_var_2) then nIS happy_var_3 else (ann . last $ fst happy_var_2)
                                         in BDecls (nIS happy_var_1 <++> l' <** (happy_var_1:snd happy_var_2++[happy_var_3])) (fst happy_var_2)
	)}}}

happyReduce_180 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_180 = happySpecReduce_1  65# happyReduction_180
happyReduction_180 happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	happyIn79
		 (happy_var_1
	)}

happyReduce_181 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_181 = happySpecReduce_1  65# happyReduction_181
happyReduction_181 happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	happyIn79
		 (happy_var_1
	)}

happyReduce_182 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_182 = happyMonadReduce 3# 66# happyReduction_182
happyReduction_182 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut178 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	( do { v <- checkSigVar happy_var_1;
                                                               return $ TypeSig (happy_var_1 <> happy_var_3 <** [happy_var_2]) [v] happy_var_3 })}}})
	) (\r -> happyReturn (happyIn80 r))

happyReduce_183 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_183 = happyMonadReduce 5# 66# happyReduction_183
happyReduction_183 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut178 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut89 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DoubleColon) -> 
	case happyOut119 happy_x_5 of { happy_var_5 -> 
	( do { v <- checkSigVar happy_var_1;
                                                               let {(vs,ss,_) = happy_var_3 ; l = happy_var_1 <> happy_var_5 <** (happy_var_2 : reverse ss ++ [happy_var_4]) } ;
                                                               return $ TypeSig l (v : reverse vs) happy_var_5 })}}}}})
	) (\r -> happyReturn (happyIn80 r))

happyReduce_184 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_184 = happyReduce 4# 67# happyReduction_184
happyReduction_184 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut243 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	happyIn81
		 (let Loc l (INLINE s) = happy_var_1 in InlineSig (l <^^> happy_var_4 <** [l,happy_var_4]) s happy_var_2 happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_185 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_185 = happyReduce 4# 67# happyReduction_185
happyReduction_185 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 INLINE_CONLIKE) -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut243 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	happyIn81
		 (InlineConlikeSig (happy_var_1 <^^> happy_var_4 <** [happy_var_1,happy_var_4]) happy_var_2 happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_186 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_186 = happyReduce 6# 67# happyReduction_186
happyReduction_186 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 SPECIALISE) -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut243 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DoubleColon) -> 
	case happyOut82 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 PragmaEnd) -> 
	happyIn81
		 (SpecSig (happy_var_1 <^^> happy_var_6 <** (happy_var_1: happy_var_4 : snd happy_var_5 ++ [happy_var_6])) happy_var_2 happy_var_3 (fst happy_var_5)
	) `HappyStk` happyRest}}}}}}

happyReduce_187 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_187 = happyReduce 6# 67# happyReduction_187
happyReduction_187 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut243 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DoubleColon) -> 
	case happyOut82 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 PragmaEnd) -> 
	happyIn81
		 (let Loc l (SPECIALISE_INLINE s) = happy_var_1
               in SpecInlineSig (l <^^> happy_var_6 <** (l:happy_var_4:snd happy_var_5++[happy_var_6])) s happy_var_2 happy_var_3 (fst happy_var_5)
	) `HappyStk` happyRest}}}}}}

happyReduce_188 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_188 = happyMonadReduce 4# 67# happyReduction_188
happyReduction_188 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 SPECIALISE) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	( do { ih <- checkInstHeader happy_var_3;
                                                               let {l = happy_var_1 <^^> happy_var_4 <** [happy_var_1,happy_var_2,happy_var_4]};
                                                               return $ InstSig l ih })}}}})
	) (\r -> happyReturn (happyIn81 r))

happyReduce_189 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_189 = happySpecReduce_3  67# happyReduction_189
happyReduction_189 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 MINIMAL) -> 
	case happyOut84 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn81
		 (MinimalPragma (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_190 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_190 = happySpecReduce_1  68# happyReduction_190
happyReduction_190 happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	happyIn82
		 (([happy_var_1],[])
	)}

happyReduce_191 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_191 = happySpecReduce_3  68# happyReduction_191
happyReduction_191 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut82 happy_x_3 of { happy_var_3 -> 
	happyIn82
		 ((happy_var_1 : fst happy_var_3, happy_var_2 : snd happy_var_3)
	)}}}

happyReduce_192 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_192 = happyMonadReduce 1# 69# happyReduction_192
happyReduction_192 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut120 happy_x_1 of { happy_var_1 -> 
	( checkType $ mkTyForall (ann happy_var_1) Nothing Nothing happy_var_1)})
	) (\r -> happyReturn (happyIn83 r))

happyReduce_193 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_193 = happySpecReduce_1  70# happyReduction_193
happyReduction_193 happy_x_1
	 =  case happyOut85 happy_x_1 of { happy_var_1 -> 
	happyIn84
		 (Just happy_var_1
	)}

happyReduce_194 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_194 = happySpecReduce_0  70# happyReduction_194
happyReduction_194  =  happyIn84
		 (Nothing
	)

happyReduce_195 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_195 = happySpecReduce_1  71# happyReduction_195
happyReduction_195 happy_x_1
	 =  case happyOut86 happy_x_1 of { happy_var_1 -> 
	happyIn85
		 (happy_var_1
	)}

happyReduce_196 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_196 = happySpecReduce_3  71# happyReduction_196
happyReduction_196 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut86 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut85 happy_x_3 of { happy_var_3 -> 
	happyIn85
		 (OrFormula (ann happy_var_1 <++>  ann happy_var_3 <** [happy_var_2]) [happy_var_1,happy_var_3]
	)}}}

happyReduce_197 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_197 = happySpecReduce_1  72# happyReduction_197
happyReduction_197 happy_x_1
	 =  case happyOut87 happy_x_1 of { happy_var_1 -> 
	happyIn86
		 (happy_var_1
	)}

happyReduce_198 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_198 = happySpecReduce_3  72# happyReduction_198
happyReduction_198 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut87 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	happyIn86
		 (AndFormula (ann happy_var_1 <++> ann happy_var_3 <** [happy_var_2]) [happy_var_1,happy_var_3]
	)}}}

happyReduce_199 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_199 = happySpecReduce_3  73# happyReduction_199
happyReduction_199 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut85 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn87
		 (ParenFormula (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_200 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_200 = happySpecReduce_1  73# happyReduction_200
happyReduction_200 happy_x_1
	 =  case happyOut241 happy_x_1 of { happy_var_1 -> 
	happyIn87
		 (VarFormula (ann happy_var_1) happy_var_1
	)}

happyReduce_201 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_201 = happySpecReduce_1  74# happyReduction_201
happyReduction_201 happy_x_1
	 =  case happyOut78 happy_x_1 of { happy_var_1 -> 
	happyIn88
		 (happy_var_1
	)}

happyReduce_202 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_202 = happySpecReduce_3  74# happyReduction_202
happyReduction_202 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut234 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn88
		 (IPBinds (happy_var_1 <^^> happy_var_3 <** snd happy_var_2) (fst happy_var_2)
	)}}}

happyReduce_203 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_203 = happySpecReduce_3  74# happyReduction_203
happyReduction_203 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut272 happy_x_1 of { happy_var_1 -> 
	case happyOut234 happy_x_2 of { happy_var_2 -> 
	happyIn88
		 (let l' =  ann . last $ fst happy_var_2
                                         in IPBinds (nIS happy_var_1 <++> l' <** snd happy_var_2) (fst happy_var_2)
	)}}

happyReduce_204 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_204 = happySpecReduce_3  75# happyReduction_204
happyReduction_204 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut241 happy_x_3 of { happy_var_3 -> 
	happyIn89
		 (let (ns,ss,l) = happy_var_1 in (happy_var_3 : ns, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_205 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_205 = happyMonadReduce 1# 75# happyReduction_205
happyReduction_205 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut243 happy_x_1 of { happy_var_1 -> 
	( do { n <- checkUnQual happy_var_1;
                                              return ([n],[],ann n) })})
	) (\r -> happyReturn (happyIn89 r))

happyReduce_206 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_206 = happySpecReduce_1  76# happyReduction_206
happyReduction_206 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_StdCall) -> 
	happyIn90
		 (StdCall    (nIS happy_var_1)
	)}

happyReduce_207 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_207 = happySpecReduce_1  76# happyReduction_207
happyReduction_207 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CCall) -> 
	happyIn90
		 (CCall      (nIS happy_var_1)
	)}

happyReduce_208 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_208 = happySpecReduce_1  76# happyReduction_208
happyReduction_208 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CPlusPlus) -> 
	happyIn90
		 (CPlusPlus  (nIS happy_var_1)
	)}

happyReduce_209 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_209 = happySpecReduce_1  76# happyReduction_209
happyReduction_209 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_DotNet) -> 
	happyIn90
		 (DotNet     (nIS happy_var_1)
	)}

happyReduce_210 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_210 = happySpecReduce_1  76# happyReduction_210
happyReduction_210 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Jvm) -> 
	happyIn90
		 (Jvm        (nIS happy_var_1)
	)}

happyReduce_211 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_211 = happySpecReduce_1  76# happyReduction_211
happyReduction_211 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Js) -> 
	happyIn90
		 (Js         (nIS happy_var_1)
	)}

happyReduce_212 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_212 = happySpecReduce_1  76# happyReduction_212
happyReduction_212 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_JavaScript) -> 
	happyIn90
		 (JavaScript (nIS happy_var_1)
	)}

happyReduce_213 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_213 = happySpecReduce_1  76# happyReduction_213
happyReduction_213 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CApi) -> 
	happyIn90
		 (CApi       (nIS happy_var_1)
	)}

happyReduce_214 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_214 = happySpecReduce_1  77# happyReduction_214
happyReduction_214 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	happyIn91
		 (Just $ PlaySafe  (nIS happy_var_1) False
	)}

happyReduce_215 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_215 = happySpecReduce_1  77# happyReduction_215
happyReduction_215 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Unsafe) -> 
	happyIn91
		 (Just $ PlayRisky (nIS happy_var_1)
	)}

happyReduce_216 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_216 = happySpecReduce_1  77# happyReduction_216
happyReduction_216 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Threadsafe) -> 
	happyIn91
		 (Just $ PlaySafe  (nIS happy_var_1) True
	)}

happyReduce_217 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_217 = happySpecReduce_1  77# happyReduction_217
happyReduction_217 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Interruptible) -> 
	happyIn91
		 (Just $ PlayInterruptible (nIS happy_var_1)
	)}

happyReduce_218 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_218 = happySpecReduce_0  77# happyReduction_218
happyReduction_218  =  happyIn91
		 (Nothing
	)

happyReduce_219 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_219 = happyReduce 4# 78# happyReduction_219
happyReduction_219 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut242 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut104 happy_x_4 of { happy_var_4 -> 
	happyIn92
		 (let Loc l (StringTok (s,_)) = happy_var_1 in (Just s, happy_var_2, happy_var_4, [l,happy_var_3])
	) `HappyStk` happyRest}}}}

happyReduce_220 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_220 = happySpecReduce_3  78# happyReduction_220
happyReduction_220 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut242 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut104 happy_x_3 of { happy_var_3 -> 
	happyIn92
		 ((Nothing, happy_var_1, happy_var_3, [happy_var_2])
	)}}}

happyReduce_221 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_221 = happySpecReduce_3  79# happyReduction_221
happyReduction_221 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut93 happy_x_1 of { happy_var_1 -> 
	case happyOut94 happy_x_3 of { happy_var_3 -> 
	happyIn93
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_222 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_222 = happySpecReduce_2  79# happyReduction_222
happyReduction_222 happy_x_2
	happy_x_1
	 =  case happyOut93 happy_x_1 of { happy_var_1 -> 
	happyIn93
		 (happy_var_1
	)}

happyReduce_223 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_223 = happySpecReduce_1  79# happyReduction_223
happyReduction_223 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn93
		 ([happy_var_1]
	)}

happyReduce_224 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_224 = happySpecReduce_0  79# happyReduction_224
happyReduction_224  =  happyIn93
		 ([]
	)

happyReduce_225 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_225 = happyMonadReduce 6# 80# happyReduction_225
happyReduction_225 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut96 happy_x_3 of { happy_var_3 -> 
	case happyOut176 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 Equals) -> 
	case happyOut174 happy_x_6 of { happy_var_6 -> 
	( do { let {Loc l (StringTok (s,_)) = happy_var_1};
                                                                  e <- checkRuleExpr happy_var_4;
                                                                  return $ Rule (nIS l <++> ann happy_var_6 <** l:snd happy_var_3 ++ [happy_var_5]) s happy_var_2 (fst happy_var_3) e happy_var_6 })}}}}}})
	) (\r -> happyReturn (happyIn94 r))

happyReduce_226 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_226 = happySpecReduce_0  81# happyReduction_226
happyReduction_226  =  happyIn95
		 (Nothing
	)

happyReduce_227 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_227 = happySpecReduce_3  81# happyReduction_227
happyReduction_227 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn95
		 (let Loc l (IntTok (i,_)) = happy_var_2 in Just $ ActiveFrom  (happy_var_1 <^^> happy_var_3 <** [happy_var_1,l,happy_var_3])    (fromInteger i)
	)}}}

happyReduce_228 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_228 = happyReduce 4# 81# happyReduction_228
happyReduction_228 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Tilde) -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightSquare) -> 
	happyIn95
		 (let Loc l (IntTok (i,_)) = happy_var_3 in Just $ ActiveUntil (happy_var_1 <^^> happy_var_4 <** [happy_var_1,happy_var_2,l,happy_var_4]) (fromInteger i)
	) `HappyStk` happyRest}}}}

happyReduce_229 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_229 = happySpecReduce_0  82# happyReduction_229
happyReduction_229  =  happyIn96
		 ((Nothing,[])
	)

happyReduce_230 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_230 = happySpecReduce_3  82# happyReduction_230
happyReduction_230 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	case happyOut97 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Dot) -> 
	happyIn96
		 ((Just happy_var_2,[happy_var_1,happy_var_3])
	)}}}

happyReduce_231 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_231 = happySpecReduce_1  83# happyReduction_231
happyReduction_231 happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	happyIn97
		 ([happy_var_1]
	)}

happyReduce_232 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_232 = happySpecReduce_2  83# happyReduction_232
happyReduction_232 happy_x_2
	happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	case happyOut97 happy_x_2 of { happy_var_2 -> 
	happyIn97
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_233 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_233 = happySpecReduce_1  84# happyReduction_233
happyReduction_233 happy_x_1
	 =  case happyOut260 happy_x_1 of { happy_var_1 -> 
	happyIn98
		 (RuleVar (ann happy_var_1) happy_var_1
	)}

happyReduce_234 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_234 = happyReduce 5# 84# happyReduction_234
happyReduction_234 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut260 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut119 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn98
		 (TypedRuleVar (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_3,happy_var_5]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_235 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_235 = happySpecReduce_3  85# happyReduction_235
happyReduction_235 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut99 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 SemiColon) -> 
	case happyOut100 happy_x_3 of { happy_var_3 -> 
	happyIn99
		 ((fst happy_var_3 : fst happy_var_1, snd happy_var_1 ++ (happy_var_2:snd happy_var_3))
	)}}}

happyReduce_236 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_236 = happySpecReduce_2  85# happyReduction_236
happyReduction_236 happy_x_2
	happy_x_1
	 =  case happyOut99 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 SemiColon) -> 
	happyIn99
		 ((fst happy_var_1, snd happy_var_1 ++ [happy_var_2])
	)}}

happyReduce_237 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_237 = happySpecReduce_1  85# happyReduction_237
happyReduction_237 happy_x_1
	 =  case happyOut100 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 (([fst happy_var_1],snd happy_var_1)
	)}

happyReduce_238 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_238 = happySpecReduce_0  85# happyReduction_238
happyReduction_238  =  happyIn99
		 (([],[])
	)

happyReduce_239 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_239 = happySpecReduce_2  86# happyReduction_239
happyReduction_239 happy_x_2
	happy_x_1
	 =  case happyOut101 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	happyIn100
		 (let Loc l (StringTok (s,_)) = happy_var_2 in ((fst happy_var_1,s),snd happy_var_1 ++ [l])
	)}}

happyReduce_240 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_240 = happySpecReduce_1  87# happyReduction_240
happyReduction_240 happy_x_1
	 =  case happyOut102 happy_x_1 of { happy_var_1 -> 
	happyIn101
		 (([happy_var_1],[])
	)}

happyReduce_241 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_241 = happySpecReduce_3  87# happyReduction_241
happyReduction_241 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut102 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut101 happy_x_3 of { happy_var_3 -> 
	happyIn101
		 ((happy_var_1 : fst happy_var_3, happy_var_2 : snd happy_var_3)
	)}}}

happyReduce_242 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_242 = happySpecReduce_1  88# happyReduction_242
happyReduction_242 happy_x_1
	 =  case happyOut245 happy_x_1 of { happy_var_1 -> 
	happyIn102
		 (happy_var_1
	)}

happyReduce_243 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_243 = happySpecReduce_1  88# happyReduction_243
happyReduction_243 happy_x_1
	 =  case happyOut241 happy_x_1 of { happy_var_1 -> 
	happyIn102
		 (happy_var_1
	)}

happyReduce_244 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_244 = happyMonadReduce 3# 89# happyReduction_244
happyReduction_244 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut263 happy_x_2 of { happy_var_2 -> 
	case happyOut187 happy_x_3 of { happy_var_3 -> 
	( checkExpr happy_var_3 >>= \e -> return (TypeAnn   (nIS happy_var_1 <++> ann e <** [happy_var_1]) happy_var_2 e))}}})
	) (\r -> happyReturn (happyIn103 r))

happyReduce_245 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_245 = happyMonadReduce 2# 89# happyReduction_245
happyReduction_245 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Module) -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	( checkExpr happy_var_2 >>= \e -> return (ModuleAnn (nIS happy_var_1 <++> ann e <** [happy_var_1])    e))}})
	) (\r -> happyReturn (happyIn103 r))

happyReduce_246 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_246 = happyMonadReduce 2# 89# happyReduction_246
happyReduction_246 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut102 happy_x_1 of { happy_var_1 -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	( checkExpr happy_var_2 >>= \e -> return (Ann (happy_var_1 <> e) happy_var_1 e))}})
	) (\r -> happyReturn (happyIn103 r))

happyReduce_247 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_247 = happyMonadReduce 1# 90# happyReduction_247
happyReduction_247 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut105 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)})
	) (\r -> happyReturn (happyIn104 r))

happyReduce_248 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_248 = happySpecReduce_1  91# happyReduction_248
happyReduction_248 happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	happyIn105
		 (splitTilde happy_var_1
	)}

happyReduce_249 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_249 = happySpecReduce_3  91# happyReduction_249
happyReduction_249 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	case happyOut118 happy_x_2 of { happy_var_2 -> 
	case happyOut105 happy_x_3 of { happy_var_3 -> 
	happyIn105
		 (TyInfix (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_250 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_250 = happySpecReduce_3  91# happyReduction_250
happyReduction_250 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	case happyOut288 happy_x_2 of { happy_var_2 -> 
	case happyOut105 happy_x_3 of { happy_var_3 -> 
	happyIn105
		 (TyInfix (happy_var_1 <> happy_var_3) happy_var_1 (UnpromotedName (ann happy_var_2) happy_var_2) happy_var_3
	)}}}

happyReduce_251 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_251 = happySpecReduce_3  91# happyReduction_251
happyReduction_251 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	happyIn105
		 (TyFun (happy_var_1 <> happy_var_3 <** [happy_var_2]) (splitTilde happy_var_1) happy_var_3
	)}}}

happyReduce_252 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_252 = happyMonadReduce 1# 92# happyReduction_252
happyReduction_252 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut107 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)})
	) (\r -> happyReturn (happyIn106 r))

happyReduce_253 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_253 = happySpecReduce_3  93# happyReduction_253
happyReduction_253 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut244 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut105 happy_x_3 of { happy_var_3 -> 
	happyIn107
		 (let l = (happy_var_1 <> happy_var_3 <** [happy_var_2]) in TyPred l $ IParam l happy_var_1 happy_var_3
	)}}}

happyReduce_254 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_254 = happySpecReduce_1  93# happyReduction_254
happyReduction_254 happy_x_1
	 =  case happyOut105 happy_x_1 of { happy_var_1 -> 
	happyIn107
		 (happy_var_1
	)}

happyReduce_255 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_255 = happyMonadReduce 1# 94# happyReduction_255
happyReduction_255 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut110 happy_x_1 of { happy_var_1 -> 
	( checkType (splitTilde happy_var_1))})
	) (\r -> happyReturn (happyIn108 r))

happyReduce_256 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_256 = happyMonadReduce 1# 95# happyReduction_256
happyReduction_256 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut111 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)})
	) (\r -> happyReturn (happyIn109 r))

happyReduce_257 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_257 = happySpecReduce_2  96# happyReduction_257
happyReduction_257 happy_x_2
	happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	case happyOut111 happy_x_2 of { happy_var_2 -> 
	happyIn110
		 (TyApp (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_258 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_258 = happySpecReduce_1  96# happyReduction_258
happyReduction_258 happy_x_1
	 =  case happyOut111 happy_x_1 of { happy_var_1 -> 
	happyIn110
		 (happy_var_1
	)}

happyReduce_259 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_259 = happySpecReduce_1  97# happyReduction_259
happyReduction_259 happy_x_1
	 =  case happyOut116 happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (TyCon   (ann happy_var_1) happy_var_1
	)}

happyReduce_260 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_260 = happyMonadReduce 1# 97# happyReduction_260
happyReduction_260 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut286 happy_x_1 of { happy_var_1 -> 
	( checkTyVar happy_var_1)})
	) (\r -> happyReturn (happyIn111 r))

happyReduce_261 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_261 = happySpecReduce_2  97# happyReduction_261
happyReduction_261 happy_x_2
	happy_x_1
	 =  case happyOut113 happy_x_1 of { happy_var_1 -> 
	case happyOut111 happy_x_2 of { happy_var_2 -> 
	happyIn111
		 (let (mstrict, mupack) = happy_var_1
                                        in bangType mstrict mupack happy_var_2
	)}}

happyReduce_262 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_262 = happySpecReduce_3  97# happyReduction_262
happyReduction_262 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut122 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn111
		 (TyTuple (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse (happy_var_3:snd happy_var_2))) Boxed   (reverse (fst happy_var_2))
	)}}}

happyReduce_263 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_263 = happySpecReduce_3  97# happyReduction_263
happyReduction_263 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut124 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn111
		 (TyUnboxedSum (happy_var_1 <^^> happy_var_3 <** (happy_var_1: reverse (happy_var_3: snd happy_var_2))) (reverse (fst happy_var_2))
	)}}}

happyReduce_264 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_264 = happySpecReduce_3  97# happyReduction_264
happyReduction_264 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut123 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn111
		 (TyTuple (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse (happy_var_3:snd happy_var_2))) Unboxed (reverse (fst happy_var_2))
	)}}}

happyReduce_265 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_265 = happySpecReduce_3  97# happyReduction_265
happyReduction_265 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn111
		 (TyList  (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_266 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_266 = happySpecReduce_3  97# happyReduction_266
happyReduction_266 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ParArrayLeftSquare) -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 ParArrayRightSquare) -> 
	happyIn111
		 (TyParArray  (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_267 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_267 = happySpecReduce_3  97# happyReduction_267
happyReduction_267 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn111
		 (TyParen (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_268 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_268 = happyReduce 5# 97# happyReduction_268
happyReduction_268 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut149 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn111
		 (TyKind  (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_3,happy_var_5]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_269 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_269 = happySpecReduce_3  97# happyReduction_269
happyReduction_269 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THParenEscape) -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn111
		 (let l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) in TySplice l $ ParenSplice l happy_var_2
	)}}}

happyReduce_270 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_270 = happySpecReduce_1  97# happyReduction_270
happyReduction_270 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (let Loc l (THIdEscape s) = happy_var_1 in TySplice (nIS l) $ IdSplice (nIS l) s
	)}

happyReduce_271 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_271 = happySpecReduce_1  97# happyReduction_271
happyReduction_271 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Underscore) -> 
	happyIn111
		 (TyWildCard (nIS happy_var_1) Nothing
	)}

happyReduce_272 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_272 = happySpecReduce_1  97# happyReduction_272
happyReduction_272 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (let Loc l (THQuasiQuote (n,q)) = happy_var_1 in TyQuasiQuote (nIS l) n q
	)}

happyReduce_273 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_273 = happyMonadReduce 1# 97# happyReduction_273
happyReduction_273 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut112 happy_x_1 of { happy_var_1 -> 
	( checkEnabled DataKinds >> return (TyPromoted (ann happy_var_1) happy_var_1))})
	) (\r -> happyReturn (happyIn111 r))

happyReduce_274 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_274 = happyMonadReduce 2# 98# happyReduction_274
happyReduction_274 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut238 happy_x_2 of { happy_var_2 -> 
	( fmap (PromotedCon (nIS happy_var_1 <++> ann happy_var_2  <** [happy_var_1]) True) (pexprToQName happy_var_2))}})
	) (\r -> happyReturn (happyIn112 r))

happyReduce_275 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_275 = happyMonadReduce 4# 98# happyReduction_275
happyReduction_275 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut123 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightSquare) -> 
	( PromotedList  (happy_var_1 <^^> happy_var_4 <** (happy_var_1:reverse(happy_var_4:snd happy_var_3))) True . reverse <$> mapM checkType (fst happy_var_3))}}})
	) (\r -> happyReturn (happyIn112 r))

happyReduce_276 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_276 = happyMonadReduce 3# 98# happyReduction_276
happyReduction_276 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut122 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	( PromotedList  (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse(happy_var_3:snd happy_var_2))) False . reverse <$> mapM checkType (fst happy_var_2))}}})
	) (\r -> happyReturn (happyIn112 r))

happyReduce_277 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_277 = happySpecReduce_3  98# happyReduction_277
happyReduction_277 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn112
		 (PromotedList  (happy_var_1 <^^> happy_var_3 <** [happy_var_1, happy_var_3]) True []
	)}}

happyReduce_278 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_278 = happyMonadReduce 4# 98# happyReduction_278
happyReduction_278 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut123 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	( PromotedTuple (happy_var_1 <^^> happy_var_4 <** (happy_var_1:reverse(happy_var_4:snd happy_var_3))) . reverse <$> mapM checkType (fst happy_var_3))}}})
	) (\r -> happyReturn (happyIn112 r))

happyReduce_279 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_279 = happySpecReduce_1  98# happyReduction_279
happyReduction_279 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn112
		 (let Loc l (IntTok  (i,raw)) = happy_var_1 in PromotedInteger (nIS l) i raw
	)}

happyReduce_280 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_280 = happySpecReduce_1  98# happyReduction_280
happyReduction_280 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn112
		 (let Loc l (StringTok (s,raw)) = happy_var_1 in PromotedString (nIS l) s raw
	)}

happyReduce_281 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_281 = happySpecReduce_1  99# happyReduction_281
happyReduction_281 happy_x_1
	 =  case happyOut114 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 ((Just happy_var_1, Nothing)
	)}

happyReduce_282 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_282 = happySpecReduce_1  99# happyReduction_282
happyReduction_282 happy_x_1
	 =  case happyOut115 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 ((Nothing, Just happy_var_1)
	)}

happyReduce_283 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_283 = happySpecReduce_2  99# happyReduction_283
happyReduction_283 happy_x_2
	happy_x_1
	 =  case happyOut115 happy_x_1 of { happy_var_1 -> 
	case happyOut114 happy_x_2 of { happy_var_2 -> 
	happyIn113
		 ((Just happy_var_2, Just happy_var_1)
	)}}

happyReduce_284 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_284 = happySpecReduce_1  100# happyReduction_284
happyReduction_284 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	happyIn114
		 ((BangedTy, happy_var_1)
	)}

happyReduce_285 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_285 = happySpecReduce_1  100# happyReduction_285
happyReduction_285 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Tilde) -> 
	happyIn114
		 ((LazyTy, happy_var_1)
	)}

happyReduce_286 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_286 = happySpecReduce_2  101# happyReduction_286
happyReduction_286 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 UNPACK) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 PragmaEnd) -> 
	happyIn115
		 ((Unpack ((nIS happy_var_1 <++> nIS happy_var_2) <** [happy_var_1,happy_var_2]))
	)}}

happyReduce_287 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_287 = happySpecReduce_2  101# happyReduction_287
happyReduction_287 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 NOUNPACK) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 PragmaEnd) -> 
	happyIn115
		 ((NoUnpack ((nIS happy_var_1 <++> nIS happy_var_2) <** [happy_var_1,happy_var_2]))
	)}}

happyReduce_288 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_288 = happySpecReduce_1  102# happyReduction_288
happyReduction_288 happy_x_1
	 =  case happyOut117 happy_x_1 of { happy_var_1 -> 
	happyIn116
		 (happy_var_1
	)}

happyReduce_289 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_289 = happySpecReduce_2  102# happyReduction_289
happyReduction_289 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightParen) -> 
	happyIn116
		 (unit_tycon_name              (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_290 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_290 = happySpecReduce_3  102# happyReduction_290
happyReduction_290 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn116
		 (fun_tycon_name               (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_2,happy_var_3])
	)}}}

happyReduce_291 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_291 = happySpecReduce_2  102# happyReduction_291
happyReduction_291 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightSquare) -> 
	happyIn116
		 (list_tycon_name              (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_292 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_292 = happySpecReduce_3  102# happyReduction_292
happyReduction_292 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut193 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn116
		 (tuple_tycon_name             (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse happy_var_2 ++ [happy_var_3])) Boxed (length happy_var_2)
	)}}}

happyReduce_293 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_293 = happySpecReduce_2  102# happyReduction_293
happyReduction_293 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightHashParen) -> 
	happyIn116
		 (unboxed_singleton_tycon_name (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_294 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_294 = happySpecReduce_3  102# happyReduction_294
happyReduction_294 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut193 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn116
		 (tuple_tycon_name             (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse happy_var_2 ++ [happy_var_3])) Unboxed (length happy_var_2)
	)}}}

happyReduce_295 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_295 = happySpecReduce_1  103# happyReduction_295
happyReduction_295 happy_x_1
	 =  case happyOut262 happy_x_1 of { happy_var_1 -> 
	happyIn117
		 (happy_var_1
	)}

happyReduce_296 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_296 = happySpecReduce_3  103# happyReduction_296
happyReduction_296 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut256 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn117
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_297 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_297 = happySpecReduce_3  103# happyReduction_297
happyReduction_297 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut266 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn117
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_298 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_298 = happySpecReduce_1  104# happyReduction_298
happyReduction_298 happy_x_1
	 =  case happyOut252 happy_x_1 of { happy_var_1 -> 
	happyIn118
		 (UnpromotedName (ann happy_var_1) happy_var_1
	)}

happyReduce_299 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_299 = happySpecReduce_2  104# happyReduction_299
happyReduction_299 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut256 happy_x_2 of { happy_var_2 -> 
	happyIn118
		 (PromotedName (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_300 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_300 = happyMonadReduce 1# 105# happyReduction_300
happyReduction_300 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut120 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)})
	) (\r -> happyReturn (happyIn119 r))

happyReduce_301 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_301 = happyReduce 4# 106# happyReduction_301
happyReduction_301 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	case happyOut125 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Dot) -> 
	case happyOut120 happy_x_4 of { happy_var_4 -> 
	happyIn120
		 (mkTyForall (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) (Just (reverse (fst happy_var_2))) Nothing happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_302 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_302 = happySpecReduce_2  106# happyReduction_302
happyReduction_302 happy_x_2
	happy_x_1
	 =  case happyOut121 happy_x_1 of { happy_var_1 -> 
	case happyOut120 happy_x_2 of { happy_var_2 -> 
	happyIn120
		 (mkTyForall (happy_var_1 <> happy_var_2) Nothing (Just happy_var_1) happy_var_2
	)}}

happyReduce_303 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_303 = happySpecReduce_1  106# happyReduction_303
happyReduction_303 happy_x_1
	 =  case happyOut107 happy_x_1 of { happy_var_1 -> 
	happyIn120
		 (happy_var_1
	)}

happyReduce_304 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_304 = happyMonadReduce 2# 107# happyReduction_304
happyReduction_304 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut110 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleArrow) -> 
	( checkPContext $ (amap (\l -> l <++> nIS happy_var_2 <** (srcInfoPoints l ++ [happy_var_2]))) (splitTilde happy_var_1))}})
	) (\r -> happyReturn (happyIn121 r))

happyReduce_305 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_305 = happySpecReduce_3  108# happyReduction_305
happyReduction_305 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut123 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	happyIn122
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_306 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_306 = happySpecReduce_1  109# happyReduction_306
happyReduction_306 happy_x_1
	 =  case happyOut120 happy_x_1 of { happy_var_1 -> 
	happyIn123
		 (([happy_var_1],[])
	)}

happyReduce_307 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_307 = happySpecReduce_3  109# happyReduction_307
happyReduction_307 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut123 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	happyIn123
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_308 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_308 = happySpecReduce_3  110# happyReduction_308
happyReduction_308 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut120 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	happyIn124
		 (([happy_var_3, happy_var_1], [happy_var_2])
	)}}}

happyReduce_309 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_309 = happySpecReduce_3  110# happyReduction_309
happyReduction_309 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut124 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	happyIn124
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_310 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_310 = happySpecReduce_2  111# happyReduction_310
happyReduction_310 happy_x_2
	happy_x_1
	 =  case happyOut125 happy_x_1 of { happy_var_1 -> 
	case happyOut126 happy_x_2 of { happy_var_2 -> 
	happyIn125
		 ((happy_var_2 : fst happy_var_1, Just (snd happy_var_1 <?+> ann happy_var_2))
	)}}

happyReduce_311 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_311 = happySpecReduce_0  111# happyReduction_311
happyReduction_311  =  happyIn125
		 (([],Nothing)
	)

happyReduce_312 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_312 = happySpecReduce_1  112# happyReduction_312
happyReduction_312 happy_x_1
	 =  case happyOut286 happy_x_1 of { happy_var_1 -> 
	happyIn126
		 (UnkindedVar (ann happy_var_1) happy_var_1
	)}

happyReduce_313 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_313 = happyReduce 5# 112# happyReduction_313
happyReduction_313 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut286 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut149 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn126
		 (KindedVar (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_3,happy_var_5]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_314 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_314 = happySpecReduce_2  113# happyReduction_314
happyReduction_314 happy_x_2
	happy_x_1
	 =  case happyOut127 happy_x_1 of { happy_var_1 -> 
	case happyOut286 happy_x_2 of { happy_var_2 -> 
	happyIn127
		 ((happy_var_2 : fst happy_var_1, Just (snd happy_var_1 <?+> ann happy_var_2))
	)}}

happyReduce_315 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_315 = happySpecReduce_0  113# happyReduction_315
happyReduction_315  =  happyIn127
		 (([], Nothing)
	)

happyReduce_316 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_316 = happySpecReduce_2  114# happyReduction_316
happyReduction_316 happy_x_2
	happy_x_1
	 =  case happyOut127 happy_x_1 of { happy_var_1 -> 
	case happyOut286 happy_x_2 of { happy_var_2 -> 
	happyIn128
		 ((happy_var_2 : fst happy_var_1, snd happy_var_1 <?+> ann happy_var_2)
	)}}

happyReduce_317 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_317 = happySpecReduce_0  115# happyReduction_317
happyReduction_317  =  happyIn129
		 (([],[], Nothing)
	)

happyReduce_318 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_318 = happyMonadReduce 2# 115# happyReduction_318
happyReduction_318 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 Bar) -> 
	case happyOut130 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled FunctionalDependencies ;
                                              let {(fds,ss,l) = happy_var_2} ;
                                              return (reverse fds, happy_var_1 : reverse ss, Just (nIS happy_var_1 <++> l)) })}})
	) (\r -> happyReturn (happyIn129 r))

happyReduce_319 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_319 = happySpecReduce_3  116# happyReduction_319
happyReduction_319 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut130 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut131 happy_x_3 of { happy_var_3 -> 
	happyIn130
		 (let (fds,ss,l) = happy_var_1 in (happy_var_3 : fds, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_320 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_320 = happySpecReduce_1  116# happyReduction_320
happyReduction_320 happy_x_1
	 =  case happyOut131 happy_x_1 of { happy_var_1 -> 
	happyIn130
		 (([happy_var_1],[],ann happy_var_1)
	)}

happyReduce_321 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_321 = happySpecReduce_3  117# happyReduction_321
happyReduction_321 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut127 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut128 happy_x_3 of { happy_var_3 -> 
	happyIn131
		 (FunDep (snd happy_var_1 <?+> nIS happy_var_2 <++> snd happy_var_3 <** [happy_var_2]) (reverse (fst happy_var_1)) (reverse (fst happy_var_3))
	)}}}

happyReduce_322 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_322 = happyMonadReduce 4# 118# happyReduction_322
happyReduction_322 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut133 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( return (fst happy_var_3, happy_var_1 : happy_var_2 : snd happy_var_3 ++ [happy_var_4], Just $ happy_var_1 <^^> happy_var_4))}}}})
	) (\r -> happyReturn (happyIn132 r))

happyReduce_323 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_323 = happyMonadReduce 4# 118# happyReduction_323
happyReduction_323 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut272 happy_x_2 of { happy_var_2 -> 
	case happyOut133 happy_x_3 of { happy_var_3 -> 
	case happyOut273 happy_x_4 of { happy_var_4 -> 
	( return (fst happy_var_3, happy_var_1 : happy_var_2 : snd happy_var_3 ++ [happy_var_4], Just $ happy_var_1 <^^> happy_var_4))}}}})
	) (\r -> happyReturn (happyIn132 r))

happyReduce_324 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_324 = happyMonadReduce 0# 118# happyReduction_324
happyReduction_324 (happyRest) tk
	 = happyThen ((( checkEnabled EmptyDataDecls >> return ([],[],Nothing)))
	) (\r -> happyReturn (happyIn132 r))

happyReduce_325 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_325 = happySpecReduce_3  119# happyReduction_325
happyReduction_325 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut134 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn133
		 ((fst happy_var_2, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3)
	)}}}

happyReduce_326 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_326 = happySpecReduce_3  120# happyReduction_326
happyReduction_326 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut134 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut135 happy_x_3 of { happy_var_3 -> 
	happyIn134
		 ((happy_var_3 ++ fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_327 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_327 = happySpecReduce_1  120# happyReduction_327
happyReduction_327 happy_x_1
	 =  case happyOut135 happy_x_1 of { happy_var_1 -> 
	happyIn134
		 ((happy_var_1,[])
	)}

happyReduce_328 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_328 = happyMonadReduce 3# 121# happyReduction_328
happyReduction_328 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	( do { c <- checkUnQual happy_var_1;
                                               return [GadtDecl (happy_var_1 <> happy_var_3 <** [happy_var_2]) c Nothing happy_var_3] })}}})
	) (\r -> happyReturn (happyIn135 r))

happyReduce_329 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_329 = happyMonadReduce 7# 121# happyReduction_329
happyReduction_329 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 LeftCurly) -> 
	case happyOut142 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightCurly) -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 RightArrow) -> 
	case happyOut119 happy_x_7 of { happy_var_7 -> 
	( do { c <- checkUnQual happy_var_1;
                                              return [GadtDecl (happy_var_1 <> happy_var_7 <** [happy_var_2,happy_var_3,happy_var_5,happy_var_6] ++ snd happy_var_4) c (Just (reverse $ fst happy_var_4)) happy_var_7] })}}}}}}})
	) (\r -> happyReturn (happyIn135 r))

happyReduce_330 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_330 = happySpecReduce_2  122# happyReduction_330
happyReduction_330 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut137 happy_x_2 of { happy_var_2 -> 
	happyIn136
		 (let (ds,ss,l) = happy_var_2 in (ds, happy_var_1 : reverse ss, Just $ nIS happy_var_1 <++> l)
	)}}

happyReduce_331 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_331 = happySpecReduce_3  123# happyReduction_331
happyReduction_331 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut137 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut138 happy_x_3 of { happy_var_3 -> 
	happyIn137
		 (let (ds,ss,l) = happy_var_1 in (happy_var_3 : ds, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_332 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_332 = happySpecReduce_1  123# happyReduction_332
happyReduction_332 happy_x_1
	 =  case happyOut138 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (([happy_var_1],[],ann happy_var_1)
	)}

happyReduce_333 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_333 = happyMonadReduce 3# 124# happyReduction_333
happyReduction_333 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut139 happy_x_1 of { happy_var_1 -> 
	case happyOut121 happy_x_2 of { happy_var_2 -> 
	case happyOut140 happy_x_3 of { happy_var_3 -> 
	( do { checkEnabled ExistentialQuantification ;
                                               ctxt <- checkContext (Just happy_var_2) ;
                                               let {(mtvs,ss,ml) = happy_var_1} ;
                                               return $ QualConDecl (ml <?+> ann happy_var_3 <** ss) mtvs ctxt happy_var_3 })}}})
	) (\r -> happyReturn (happyIn138 r))

happyReduce_334 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_334 = happySpecReduce_2  124# happyReduction_334
happyReduction_334 happy_x_2
	happy_x_1
	 =  case happyOut139 happy_x_1 of { happy_var_1 -> 
	case happyOut140 happy_x_2 of { happy_var_2 -> 
	happyIn138
		 (let (mtvs, ss, ml) = happy_var_1 in QualConDecl (ml <?+> ann happy_var_2 <** ss) mtvs Nothing happy_var_2
	)}}

happyReduce_335 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_335 = happyMonadReduce 3# 125# happyReduction_335
happyReduction_335 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	case happyOut125 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Dot) -> 
	( checkEnabled ExistentialQuantification >> return (Just (fst happy_var_2), [happy_var_1,happy_var_3], Just $ happy_var_1 <^^> happy_var_3))}}})
	) (\r -> happyReturn (happyIn139 r))

happyReduce_336 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_336 = happySpecReduce_0  125# happyReduction_336
happyReduction_336  =  happyIn139
		 ((Nothing, [], Nothing)
	)

happyReduce_337 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_337 = happySpecReduce_1  126# happyReduction_337
happyReduction_337 happy_x_1
	 =  case happyOut141 happy_x_1 of { happy_var_1 -> 
	happyIn140
		 (let (n,ts,l) = happy_var_1 in ConDecl l n ts
	)}

happyReduce_338 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_338 = happySpecReduce_3  126# happyReduction_338
happyReduction_338 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut108 happy_x_1 of { happy_var_1 -> 
	case happyOut251 happy_x_2 of { happy_var_2 -> 
	case happyOut108 happy_x_3 of { happy_var_3 -> 
	happyIn140
		 (InfixConDecl (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_339 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_339 = happyMonadReduce 3# 126# happyReduction_339
happyReduction_339 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	( do { c <- checkUnQual happy_var_1; return $ RecDecl (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3]) c [] })}}})
	) (\r -> happyReturn (happyIn140 r))

happyReduce_340 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_340 = happyMonadReduce 4# 126# happyReduction_340
happyReduction_340 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut142 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( do { c <- checkUnQual happy_var_1;
                                              return $ RecDecl (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:reverse (snd happy_var_3) ++ [happy_var_4])) c (reverse (fst happy_var_3)) })}}}})
	) (\r -> happyReturn (happyIn140 r))

happyReduce_341 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_341 = happyMonadReduce 1# 127# happyReduction_341
happyReduction_341 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut110 happy_x_1 of { happy_var_1 -> 
	( do { (c,ts) <- splitTyConApp happy_var_1;
                                              return (c, ts, ann happy_var_1) })})
	) (\r -> happyReturn (happyIn141 r))

happyReduce_342 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_342 = happySpecReduce_3  128# happyReduction_342
happyReduction_342 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut142 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut143 happy_x_3 of { happy_var_3 -> 
	happyIn142
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_343 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_343 = happySpecReduce_1  128# happyReduction_343
happyReduction_343 happy_x_1
	 =  case happyOut143 happy_x_1 of { happy_var_1 -> 
	happyIn142
		 (([happy_var_1],[])
	)}

happyReduce_344 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_344 = happySpecReduce_3  129# happyReduction_344
happyReduction_344 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	happyIn143
		 (let (ns,ss,l) = happy_var_1 in FieldDecl (l <++> ann happy_var_3 <** (reverse ss ++ [happy_var_2])) (reverse ns) happy_var_3
	)}}}

happyReduce_345 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_345 = happySpecReduce_0  130# happyReduction_345
happyReduction_345  =  happyIn144
		 ([]
	)

happyReduce_346 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_346 = happySpecReduce_1  130# happyReduction_346
happyReduction_346 happy_x_1
	 =  case happyOut145 happy_x_1 of { happy_var_1 -> 
	happyIn144
		 (happy_var_1
	)}

happyReduce_347 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_347 = happySpecReduce_2  131# happyReduction_347
happyReduction_347 happy_x_2
	happy_x_1
	 =  case happyOut145 happy_x_1 of { happy_var_1 -> 
	case happyOut146 happy_x_2 of { happy_var_2 -> 
	happyIn145
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_348 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_348 = happySpecReduce_1  131# happyReduction_348
happyReduction_348 happy_x_1
	 =  case happyOut146 happy_x_1 of { happy_var_1 -> 
	happyIn145
		 ([happy_var_1]
	)}

happyReduce_349 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_349 = happySpecReduce_3  132# happyReduction_349
happyReduction_349 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOut282 happy_x_2 of { happy_var_2 -> 
	case happyOut148 happy_x_3 of { happy_var_3 -> 
	happyIn146
		 (let l = nIS happy_var_1 <++> ann happy_var_3 <** [happy_var_1] in Deriving l happy_var_2 [IRule (ann happy_var_3) Nothing Nothing happy_var_3]
	)}}}

happyReduce_350 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_350 = happyReduce 4# 132# happyReduction_350
happyReduction_350 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOut282 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 LeftParen) -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn146
		 (Deriving (happy_var_1 <^^> happy_var_4 <** [happy_var_1,happy_var_3,happy_var_4]) happy_var_2 []
	) `HappyStk` happyRest}}}}

happyReduce_351 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_351 = happyReduce 5# 132# happyReduction_351
happyReduction_351 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOut282 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 LeftParen) -> 
	case happyOut147 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn146
		 (-- Distinguish deriving (Show) from deriving Show (#189)
                                        case fst happy_var_4 of
                                          [ts] -> Deriving (happy_var_1 <^^> happy_var_5 <** [happy_var_1]) happy_var_2 [IParen (happy_var_3 <^^> happy_var_5 <** [happy_var_3,happy_var_5]) ts]
                                          tss  -> Deriving (happy_var_1 <^^> happy_var_5 <** happy_var_1:happy_var_3: reverse (snd happy_var_4) ++ [happy_var_5]) happy_var_2 (reverse tss)
	) `HappyStk` happyRest}}}}}

happyReduce_352 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_352 = happyMonadReduce 1# 133# happyReduction_352
happyReduction_352 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut123 happy_x_1 of { happy_var_1 -> 
	( checkDeriving (fst happy_var_1) >>= \ds -> return (ds, snd happy_var_1))})
	) (\r -> happyReturn (happyIn147 r))

happyReduce_353 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_353 = happySpecReduce_1  134# happyReduction_353
happyReduction_353 happy_x_1
	 =  case happyOut262 happy_x_1 of { happy_var_1 -> 
	happyIn148
		 (IHCon (ann happy_var_1) happy_var_1
	)}

happyReduce_354 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_354 = happyMonadReduce 1# 135# happyReduction_354
happyReduction_354 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut150 happy_x_1 of { happy_var_1 -> 
	( checkEnabled KindSignatures >> return happy_var_1)})
	) (\r -> happyReturn (happyIn149 r))

happyReduce_355 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_355 = happySpecReduce_1  136# happyReduction_355
happyReduction_355 happy_x_1
	 =  case happyOut151 happy_x_1 of { happy_var_1 -> 
	happyIn150
		 (happy_var_1
	)}

happyReduce_356 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_356 = happySpecReduce_3  136# happyReduction_356
happyReduction_356 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut151 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut150 happy_x_3 of { happy_var_3 -> 
	happyIn150
		 (KindFn (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_357 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_357 = happySpecReduce_1  137# happyReduction_357
happyReduction_357 happy_x_1
	 =  case happyOut152 happy_x_1 of { happy_var_1 -> 
	happyIn151
		 (happy_var_1
	)}

happyReduce_358 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_358 = happySpecReduce_2  137# happyReduction_358
happyReduction_358 happy_x_2
	happy_x_1
	 =  case happyOut151 happy_x_1 of { happy_var_1 -> 
	case happyOut152 happy_x_2 of { happy_var_2 -> 
	happyIn151
		 (KindApp (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_359 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_359 = happySpecReduce_1  138# happyReduction_359
happyReduction_359 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Star) -> 
	happyIn152
		 (KindStar  (nIS happy_var_1)
	)}

happyReduce_360 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_360 = happySpecReduce_3  138# happyReduction_360
happyReduction_360 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut150 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn152
		 (KindParen (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_361 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_361 = happyMonadReduce 1# 138# happyReduction_361
happyReduction_361 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut153 happy_x_1 of { happy_var_1 -> 
	( checkKind happy_var_1 >> return happy_var_1)})
	) (\r -> happyReturn (happyIn152 r))

happyReduce_362 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_362 = happyMonadReduce 1# 138# happyReduction_362
happyReduction_362 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut258 happy_x_1 of { happy_var_1 -> 
	( checkEnabled PolyKinds >> return (KindVar (ann happy_var_1) happy_var_1))})
	) (\r -> happyReturn (happyIn152 r))

happyReduce_363 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_363 = happySpecReduce_1  139# happyReduction_363
happyReduction_363 happy_x_1
	 =  case happyOut285 happy_x_1 of { happy_var_1 -> 
	happyIn153
		 (KindVar (ann happy_var_1) happy_var_1
	)}

happyReduce_364 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_364 = happySpecReduce_2  139# happyReduction_364
happyReduction_364 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightParen) -> 
	happyIn153
		 (let l = happy_var_1 <^^> happy_var_2 in KindVar l (unit_tycon_name l)
	)}}

happyReduce_365 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_365 = happyReduce 5# 139# happyReduction_365
happyReduction_365 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut149 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Comma) -> 
	case happyOut154 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn153
		 (KindTuple (happy_var_1 <^^> happy_var_5 <** (happy_var_1:happy_var_3:reverse (happy_var_5:snd happy_var_4))) (happy_var_2:reverse (fst happy_var_4))
	) `HappyStk` happyRest}}}}}

happyReduce_366 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_366 = happySpecReduce_3  139# happyReduction_366
happyReduction_366 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut149 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn153
		 (KindList  ((happy_var_1 <^^> happy_var_3) <** [happy_var_1, happy_var_3]) happy_var_2
	)}}}

happyReduce_367 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_367 = happySpecReduce_1  140# happyReduction_367
happyReduction_367 happy_x_1
	 =  case happyOut150 happy_x_1 of { happy_var_1 -> 
	happyIn154
		 (([happy_var_1], [])
	)}

happyReduce_368 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_368 = happySpecReduce_3  140# happyReduction_368
happyReduction_368 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut150 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut154 happy_x_3 of { happy_var_3 -> 
	happyIn154
		 ((happy_var_1 : (fst happy_var_3), happy_var_2 : (snd happy_var_3))
	)}}}

happyReduce_369 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_369 = happySpecReduce_0  141# happyReduction_369
happyReduction_369  =  happyIn155
		 ((Nothing,[])
	)

happyReduce_370 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_370 = happySpecReduce_2  141# happyReduction_370
happyReduction_370 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut149 happy_x_2 of { happy_var_2 -> 
	happyIn155
		 ((Just happy_var_2,[happy_var_1])
	)}}

happyReduce_371 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_371 = happySpecReduce_0  142# happyReduction_371
happyReduction_371  =  happyIn156
		 (Nothing
	)

happyReduce_372 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_372 = happySpecReduce_2  142# happyReduction_372
happyReduction_372 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut116 happy_x_2 of { happy_var_2 -> 
	happyIn156
		 (Just (happy_var_1, happy_var_2)
	)}}

happyReduce_373 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_373 = happyMonadReduce 4# 143# happyReduction_373
happyReduction_373 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( checkClassBody (fst happy_var_3) >>= \vs -> return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (happy_var_1 <^^> happy_var_4)))}}}})
	) (\r -> happyReturn (happyIn157 r))

happyReduce_374 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_374 = happyMonadReduce 4# 143# happyReduction_374
happyReduction_374 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut272 happy_x_2 of { happy_var_2 -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	case happyOut273 happy_x_4 of { happy_var_4 -> 
	( do { vs <- checkClassBody (fst happy_var_3);
                                              let { l' = if null (fst happy_var_3) then nIS happy_var_4 else (ann . last $ fst happy_var_3) };
                                              return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (nIS happy_var_1 <++> l')) })}}}})
	) (\r -> happyReturn (happyIn157 r))

happyReduce_375 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_375 = happySpecReduce_0  143# happyReduction_375
happyReduction_375  =  happyIn157
		 ((Nothing,[],Nothing)
	)

happyReduce_376 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_376 = happyMonadReduce 3# 144# happyReduction_376
happyReduction_376 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut159 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	( checkRevClsDecls (fst happy_var_2) >>= \cs -> return (cs, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3))}}})
	) (\r -> happyReturn (happyIn158 r))

happyReduce_377 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_377 = happySpecReduce_1  144# happyReduction_377
happyReduction_377 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn158
		 (([],reverse happy_var_1)
	)}

happyReduce_378 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_378 = happySpecReduce_3  145# happyReduction_378
happyReduction_378 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut159 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut160 happy_x_3 of { happy_var_3 -> 
	happyIn159
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_379 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_379 = happySpecReduce_1  145# happyReduction_379
happyReduction_379 happy_x_1
	 =  case happyOut160 happy_x_1 of { happy_var_1 -> 
	happyIn159
		 (([happy_var_1],[])
	)}

happyReduce_380 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_380 = happySpecReduce_1  146# happyReduction_380
happyReduction_380 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn160
		 (ClsDecl (ann happy_var_1) happy_var_1
	)}

happyReduce_381 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_381 = happyMonadReduce 1# 146# happyReduction_381
happyReduction_381 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut162 happy_x_1 of { happy_var_1 -> 
	( checkEnabled TypeFamilies >> return happy_var_1)})
	) (\r -> happyReturn (happyIn160 r))

happyReduce_382 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_382 = happyMonadReduce 2# 146# happyReduction_382
happyReduction_382 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Default) -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	( checkEnabled DefaultSignatures >> checkDefSigDef happy_var_2 >>= \(n,t,l) -> return (ClsDefSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1,l]) n t))}})
	) (\r -> happyReturn (happyIn160 r))

happyReduce_383 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_383 = happySpecReduce_0  147# happyReduction_383
happyReduction_383  =  happyIn161
		 ([]
	)

happyReduce_384 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_384 = happySpecReduce_1  147# happyReduction_384
happyReduction_384 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Family) -> 
	happyIn161
		 ([happy_var_1]
	)}

happyReduce_385 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_385 = happyMonadReduce 4# 148# happyReduction_385
happyReduction_385 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	case happyOut61 happy_x_4 of { happy_var_4 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_3;
                    return (ClsDataFam (nIS happy_var_1 <++> ann happy_var_3 <+?> (fmap ann) happy_var_4 <** [happy_var_1]) cs dh happy_var_4) })}}})
	) (\r -> happyReturn (happyIn162 r))

happyReduce_386 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_386 = happyMonadReduce 3# 148# happyReduction_386
happyReduction_386 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	case happyOut64 happy_x_3 of { happy_var_3 -> 
	( mkAssocType happy_var_1 happy_var_2 happy_var_3)}}})
	) (\r -> happyReturn (happyIn162 r))

happyReduce_387 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_387 = happyMonadReduce 4# 148# happyReduction_387
happyReduction_387 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	case happyOut63 happy_x_4 of { happy_var_4 -> 
	( do { dh <- checkSimpleType happy_var_3;
                    return (ClsTyFam  (nIS happy_var_1 <++> ann happy_var_3 <+?> (fmap ann) (fst happy_var_4)
                                                          <+?> (fmap ann) (snd happy_var_4)
                                                          <** [happy_var_1]) dh (fst happy_var_4) (snd happy_var_4)) })}}})
	) (\r -> happyReturn (happyIn162 r))

happyReduce_388 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_388 = happySpecReduce_3  148# happyReduction_388
happyReduction_388 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn162
		 (ClsTyDef (nIS happy_var_1 <++> ann happy_var_3 <** [happy_var_1,happy_var_2]) happy_var_3
	)}}}

happyReduce_389 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_389 = happyMonadReduce 4# 149# happyReduction_389
happyReduction_389 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut164 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( checkInstBody (fst happy_var_3) >>= \vs -> return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (happy_var_1 <^^> happy_var_4)))}}}})
	) (\r -> happyReturn (happyIn163 r))

happyReduce_390 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_390 = happyMonadReduce 4# 149# happyReduction_390
happyReduction_390 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut272 happy_x_2 of { happy_var_2 -> 
	case happyOut164 happy_x_3 of { happy_var_3 -> 
	case happyOut273 happy_x_4 of { happy_var_4 -> 
	( checkInstBody (fst happy_var_3) >>= \vs -> return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (happy_var_1 <^^> happy_var_4)))}}}})
	) (\r -> happyReturn (happyIn163 r))

happyReduce_391 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_391 = happySpecReduce_0  149# happyReduction_391
happyReduction_391  =  happyIn163
		 ((Nothing, [], Nothing)
	)

happyReduce_392 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_392 = happyMonadReduce 3# 150# happyReduction_392
happyReduction_392 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut165 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	( checkRevInstDecls (fst happy_var_2) >>= \is -> return (is, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3))}}})
	) (\r -> happyReturn (happyIn164 r))

happyReduce_393 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_393 = happySpecReduce_1  150# happyReduction_393
happyReduction_393 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn164
		 (([],reverse happy_var_1)
	)}

happyReduce_394 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_394 = happySpecReduce_3  151# happyReduction_394
happyReduction_394 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut165 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut166 happy_x_3 of { happy_var_3 -> 
	happyIn165
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_395 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_395 = happySpecReduce_1  151# happyReduction_395
happyReduction_395 happy_x_1
	 =  case happyOut166 happy_x_1 of { happy_var_1 -> 
	happyIn165
		 (([happy_var_1],[])
	)}

happyReduce_396 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_396 = happySpecReduce_1  152# happyReduction_396
happyReduction_396 happy_x_1
	 =  case happyOut168 happy_x_1 of { happy_var_1 -> 
	happyIn166
		 (InsDecl (ann happy_var_1) happy_var_1
	)}

happyReduce_397 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_397 = happyMonadReduce 1# 152# happyReduction_397
happyReduction_397 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut167 happy_x_1 of { happy_var_1 -> 
	( checkEnabled TypeFamilies >> return happy_var_1)})
	) (\r -> happyReturn (happyIn166 r))

happyReduce_398 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_398 = happySpecReduce_1  152# happyReduction_398
happyReduction_398 happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	happyIn166
		 (InsDecl (ann happy_var_1) happy_var_1
	)}

happyReduce_399 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_399 = happyMonadReduce 1# 152# happyReduction_399
happyReduction_399 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut80 happy_x_1 of { happy_var_1 -> 
	( checkEnabled InstanceSigs >> return (InsDecl (ann happy_var_1) happy_var_1))})
	) (\r -> happyReturn (happyIn166 r))

happyReduce_400 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_400 = happyMonadReduce 4# 153# happyReduction_400
happyReduction_400 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut104 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut119 happy_x_4 of { happy_var_4 -> 
	( do { -- no checkSimpleType happy_var_4 since dtype may contain type patterns
                       return (InsType (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) happy_var_2 happy_var_4) })}}}})
	) (\r -> happyReturn (happyIn167 r))

happyReduce_401 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_401 = happyMonadReduce 4# 153# happyReduction_401
happyReduction_401 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut119 happy_x_2 of { happy_var_2 -> 
	case happyOut136 happy_x_3 of { happy_var_3 -> 
	case happyOut144 happy_x_4 of { happy_var_4 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       let {(ds,ss,minf) = happy_var_3};
                       checkDataOrNew happy_var_1 ds;
                       return (InsData (happy_var_1 <> happy_var_2 <+?> minf <+?> fmap ann (listToMaybe happy_var_4) <** ss ) happy_var_1 happy_var_2 (reverse ds) (reverse happy_var_4)) })}}}})
	) (\r -> happyReturn (happyIn167 r))

happyReduce_402 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_402 = happyMonadReduce 5# 153# happyReduction_402
happyReduction_402 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut119 happy_x_2 of { happy_var_2 -> 
	case happyOut155 happy_x_3 of { happy_var_3 -> 
	case happyOut132 happy_x_4 of { happy_var_4 -> 
	case happyOut144 happy_x_5 of { happy_var_5 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       let { (gs,ss,minf) = happy_var_4 } ;
                       checkDataOrNewG happy_var_1 gs;
                       return $ InsGData (ann happy_var_1 <+?> minf <+?> fmap ann (listToMaybe happy_var_5) <** (snd happy_var_3 ++ ss)) happy_var_1 happy_var_2 (fst happy_var_3) (reverse gs) (reverse happy_var_5) })}}}}})
	) (\r -> happyReturn (happyIn167 r))

happyReduce_403 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_403 = happyMonadReduce 4# 154# happyReduction_403
happyReduction_403 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut178 happy_x_1 of { happy_var_1 -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	( checkValDef ((happy_var_1 <> happy_var_3 <+?> (fmap ann) (fst happy_var_4)) <** (snd happy_var_4)) happy_var_1 happy_var_2 happy_var_3 (fst happy_var_4))}}}})
	) (\r -> happyReturn (happyIn168 r))

happyReduce_404 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_404 = happyMonadReduce 4# 154# happyReduction_404
happyReduction_404 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	case happyOut171 happy_x_3 of { happy_var_3 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	( do { checkEnabled BangPatterns ;
                                              let { l = nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1] };
                                              p <- checkPattern (BangPat l happy_var_2);
                                              return $ PatBind (p <> happy_var_3 <+?> (fmap ann) (fst happy_var_4) <** snd happy_var_4)
                                                          p happy_var_3 (fst happy_var_4) })}}}})
	) (\r -> happyReturn (happyIn168 r))

happyReduce_405 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_405 = happySpecReduce_2  155# happyReduction_405
happyReduction_405 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	happyIn169
		 ((Just happy_var_2, [happy_var_1])
	)}}

happyReduce_406 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_406 = happySpecReduce_0  155# happyReduction_406
happyReduction_406  =  happyIn169
		 ((Nothing, [])
	)

happyReduce_407 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_407 = happyMonadReduce 2# 156# happyReduction_407
happyReduction_407 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut119 happy_x_2 of { happy_var_2 -> 
	( checkEnabled ScopedTypeVariables >> return (Just (happy_var_2, happy_var_1)))}})
	) (\r -> happyReturn (happyIn170 r))

happyReduce_408 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_408 = happySpecReduce_0  156# happyReduction_408
happyReduction_408  =  happyIn170
		 (Nothing
	)

happyReduce_409 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_409 = happySpecReduce_2  157# happyReduction_409
happyReduction_409 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	happyIn171
		 (UnGuardedRhs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_410 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_410 = happySpecReduce_1  157# happyReduction_410
happyReduction_410 happy_x_1
	 =  case happyOut172 happy_x_1 of { happy_var_1 -> 
	happyIn171
		 (GuardedRhss (snd happy_var_1) (reverse $ fst happy_var_1)
	)}

happyReduce_411 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_411 = happySpecReduce_2  158# happyReduction_411
happyReduction_411 happy_x_2
	happy_x_1
	 =  case happyOut172 happy_x_1 of { happy_var_1 -> 
	case happyOut173 happy_x_2 of { happy_var_2 -> 
	happyIn172
		 ((happy_var_2 : fst happy_var_1, snd happy_var_1 <++> ann happy_var_2)
	)}}

happyReduce_412 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_412 = happySpecReduce_1  158# happyReduction_412
happyReduction_412 happy_x_1
	 =  case happyOut173 happy_x_1 of { happy_var_1 -> 
	happyIn172
		 (([happy_var_1],ann happy_var_1)
	)}

happyReduce_413 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_413 = happyMonadReduce 4# 159# happyReduction_413
happyReduction_413 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 Bar) -> 
	case happyOut214 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut174 happy_x_4 of { happy_var_4 -> 
	( do { checkPatternGuards (fst happy_var_2);
                                       return $ GuardedRhs (nIS happy_var_1 <++> ann happy_var_4 <** (happy_var_1:snd happy_var_2 ++ [happy_var_3])) (reverse (fst happy_var_2)) happy_var_4 })}}}})
	) (\r -> happyReturn (happyIn173 r))

happyReduce_414 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_414 = happyMonadReduce 1# 160# happyReduction_414
happyReduction_414 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut175 happy_x_1 of { happy_var_1 -> 
	( checkExpr happy_var_1)})
	) (\r -> happyReturn (happyIn174 r))

happyReduce_415 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_415 = happySpecReduce_3  161# happyReduction_415
happyReduction_415 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut119 happy_x_3 of { happy_var_3 -> 
	happyIn175
		 (ExpTypeSig      (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_416 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_416 = happySpecReduce_1  161# happyReduction_416
happyReduction_416 happy_x_1
	 =  case happyOut176 happy_x_1 of { happy_var_1 -> 
	happyIn175
		 (happy_var_1
	)}

happyReduce_417 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_417 = happySpecReduce_2  161# happyReduction_417
happyReduction_417 happy_x_2
	happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	case happyOut254 happy_x_2 of { happy_var_2 -> 
	happyIn175
		 (PostOp          (happy_var_1 <> happy_var_2)          happy_var_1 happy_var_2
	)}}

happyReduce_418 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_418 = happySpecReduce_3  161# happyReduction_418
happyReduction_418 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftArrowTail) -> 
	case happyOut175 happy_x_3 of { happy_var_3 -> 
	happyIn175
		 (LeftArrApp      (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_419 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_419 = happySpecReduce_3  161# happyReduction_419
happyReduction_419 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrowTail) -> 
	case happyOut175 happy_x_3 of { happy_var_3 -> 
	happyIn175
		 (RightArrApp     (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_420 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_420 = happySpecReduce_3  161# happyReduction_420
happyReduction_420 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftDblArrowTail) -> 
	case happyOut175 happy_x_3 of { happy_var_3 -> 
	happyIn175
		 (LeftArrHighApp  (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_421 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_421 = happySpecReduce_3  161# happyReduction_421
happyReduction_421 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightDblArrowTail) -> 
	case happyOut175 happy_x_3 of { happy_var_3 -> 
	happyIn175
		 (RightArrHighApp (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_422 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_422 = happySpecReduce_1  162# happyReduction_422
happyReduction_422 happy_x_1
	 =  case happyOut177 happy_x_1 of { happy_var_1 -> 
	happyIn176
		 (happy_var_1
	)}

happyReduce_423 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_423 = happySpecReduce_1  162# happyReduction_423
happyReduction_423 happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	happyIn176
		 (happy_var_1
	)}

happyReduce_424 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_424 = happySpecReduce_3  163# happyReduction_424
happyReduction_424 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	case happyOut254 happy_x_2 of { happy_var_2 -> 
	case happyOut179 happy_x_3 of { happy_var_3 -> 
	happyIn177
		 (InfixApp (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_425 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_425 = happySpecReduce_1  163# happyReduction_425
happyReduction_425 happy_x_1
	 =  case happyOut179 happy_x_1 of { happy_var_1 -> 
	happyIn177
		 (happy_var_1
	)}

happyReduce_426 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_426 = happySpecReduce_3  164# happyReduction_426
happyReduction_426 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	case happyOut254 happy_x_2 of { happy_var_2 -> 
	case happyOut182 happy_x_3 of { happy_var_3 -> 
	happyIn178
		 (InfixApp (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_427 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_427 = happySpecReduce_1  164# happyReduction_427
happyReduction_427 happy_x_1
	 =  case happyOut182 happy_x_1 of { happy_var_1 -> 
	happyIn178
		 (happy_var_1
	)}

happyReduce_428 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_428 = happyReduce 4# 165# happyReduction_428
happyReduction_428 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 Backslash) -> 
	case happyOut185 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightArrow) -> 
	case happyOut175 happy_x_4 of { happy_var_4 -> 
	happyIn179
		 (Lambda (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) (reverse happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_429 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_429 = happyReduce 4# 165# happyReduction_429
happyReduction_429 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Let) -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_In) -> 
	case happyOut175 happy_x_4 of { happy_var_4 -> 
	happyIn179
		 (Let    (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3])    happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_430 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_430 = happyReduce 8# 165# happyReduction_430
happyReduction_430 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_If) -> 
	case happyOut175 happy_x_2 of { happy_var_2 -> 
	case happyOut180 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 KW_Then) -> 
	case happyOut175 happy_x_5 of { happy_var_5 -> 
	case happyOut180 happy_x_6 of { happy_var_6 -> 
	case happyOutTok happy_x_7 of { (Loc happy_var_7 KW_Else) -> 
	case happyOut175 happy_x_8 of { happy_var_8 -> 
	happyIn179
		 (If     (nIS happy_var_1 <++> ann happy_var_8 <** (happy_var_1:happy_var_3 ++ happy_var_4:happy_var_6 ++ [happy_var_7])) happy_var_2 happy_var_5 happy_var_8
	) `HappyStk` happyRest}}}}}}}}

happyReduce_431 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_431 = happyMonadReduce 2# 165# happyReduction_431
happyReduction_431 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_If) -> 
	case happyOut225 happy_x_2 of { happy_var_2 -> 
	( checkEnabled MultiWayIf >>
                                           let (alts, inf, ss) = happy_var_2
                                           in return (MultiIf (nIS happy_var_1 <++> inf <** (happy_var_1:ss)) alts))}})
	) (\r -> happyReturn (happyIn179 r))

happyReduce_432 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_432 = happyReduce 4# 165# happyReduction_432
happyReduction_432 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Proc) -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightArrow) -> 
	case happyOut175 happy_x_4 of { happy_var_4 -> 
	happyIn179
		 (Proc   (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3])    happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_433 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_433 = happySpecReduce_1  165# happyReduction_433
happyReduction_433 happy_x_1
	 =  case happyOut183 happy_x_1 of { happy_var_1 -> 
	happyIn179
		 (happy_var_1
	)}

happyReduce_434 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_434 = happyMonadReduce 1# 166# happyReduction_434
happyReduction_434 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 SemiColon) -> 
	( checkEnabled DoAndIfThenElse >> return [happy_var_1])})
	) (\r -> happyReturn (happyIn180 r))

happyReduce_435 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_435 = happySpecReduce_0  166# happyReduction_435
happyReduction_435  =  happyIn180
		 ([]
	)

happyReduce_436 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_436 = happySpecReduce_1  167# happyReduction_436
happyReduction_436 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 SemiColon) -> 
	happyIn181
		 ([happy_var_1]
	)}

happyReduce_437 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_437 = happySpecReduce_0  167# happyReduction_437
happyReduction_437  =  happyIn181
		 ([]
	)

happyReduce_438 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_438 = happyReduce 4# 168# happyReduction_438
happyReduction_438 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Case) -> 
	case happyOut175 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_Of) -> 
	case happyOut217 happy_x_4 of { happy_var_4 -> 
	happyIn182
		 (let (als, inf, ss) = happy_var_4 in Case (nIS happy_var_1 <++> inf <** (happy_var_1:happy_var_3:ss)) happy_var_2 als
	) `HappyStk` happyRest}}}}

happyReduce_439 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_439 = happyMonadReduce 3# 168# happyReduction_439
happyReduction_439 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 Backslash) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Case) -> 
	case happyOut217 happy_x_3 of { happy_var_3 -> 
	( do { checkEnabled LambdaCase ;
                                              let { (als, inf, ss) = happy_var_3 } ;
                                              return (LCase (nIS happy_var_1 <++> inf <** (happy_var_1:happy_var_2:ss)) als) })}}})
	) (\r -> happyReturn (happyIn182 r))

happyReduce_440 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_440 = happySpecReduce_2  168# happyReduction_440
happyReduction_440 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Minus) -> 
	case happyOut184 happy_x_2 of { happy_var_2 -> 
	happyIn182
		 (NegApp (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_441 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_441 = happySpecReduce_2  168# happyReduction_441
happyReduction_441 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Do) -> 
	case happyOut228 happy_x_2 of { happy_var_2 -> 
	happyIn182
		 (let (sts, inf, ss) = happy_var_2 in Do   (nIS happy_var_1 <++> inf <** happy_var_1:ss) sts
	)}}

happyReduce_442 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_442 = happySpecReduce_2  168# happyReduction_442
happyReduction_442 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_MDo) -> 
	case happyOut228 happy_x_2 of { happy_var_2 -> 
	happyIn182
		 (let (sts, inf, ss) = happy_var_2 in MDo  (nIS happy_var_1 <++> inf <** happy_var_1:ss) sts
	)}}

happyReduce_443 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_443 = happySpecReduce_1  168# happyReduction_443
happyReduction_443 happy_x_1
	 =  case happyOut184 happy_x_1 of { happy_var_1 -> 
	happyIn182
		 (happy_var_1
	)}

happyReduce_444 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_444 = happyReduce 4# 169# happyReduction_444
happyReduction_444 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 CORE) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	case happyOut175 happy_x_4 of { happy_var_4 -> 
	happyIn183
		 (let Loc l (StringTok (s,_)) = happy_var_2 in CorePragma (nIS happy_var_1 <++> ann happy_var_4 <** [l,happy_var_3]) s happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_445 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_445 = happyReduce 4# 169# happyReduction_445
happyReduction_445 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 SCC) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	case happyOut175 happy_x_4 of { happy_var_4 -> 
	happyIn183
		 (let Loc l (StringTok (s,_)) = happy_var_2 in SCCPragma  (nIS happy_var_1 <++> ann happy_var_4 <** [l,happy_var_3]) s happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_446 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_446 = happyReduce 11# 169# happyReduction_446
happyReduction_446 (happy_x_11 `HappyStk`
	happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 GENERATED) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 Colon) -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 Minus) -> 
	case happyOutTok happy_x_7 of { happy_var_7 -> 
	case happyOutTok happy_x_8 of { (Loc happy_var_8 Colon) -> 
	case happyOutTok happy_x_9 of { happy_var_9 -> 
	case happyOutTok happy_x_10 of { (Loc happy_var_10 PragmaEnd) -> 
	case happyOut175 happy_x_11 of { happy_var_11 -> 
	happyIn183
		 (let { Loc l0 (StringTok (s,_)) = happy_var_2;
                                                  Loc l1 (IntTok (i1,_))   = happy_var_3;
                                                  Loc l2 (IntTok (i2,_))   = happy_var_5;
                                                  Loc l3 (IntTok (i3,_))   = happy_var_7;
                                                  Loc l4 (IntTok (i4,_))   = happy_var_9}
                                             in GenPragma (nIS happy_var_1 <++> ann happy_var_11 <** [happy_var_1,l0,l1,happy_var_4,l2,happy_var_6,l3,happy_var_8,l4,happy_var_10])
                                                      s (fromInteger i1, fromInteger i2)
                                                        (fromInteger i3, fromInteger i4) happy_var_11
	) `HappyStk` happyRest}}}}}}}}}}}

happyReduce_447 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_447 = happySpecReduce_2  170# happyReduction_447
happyReduction_447 happy_x_2
	happy_x_1
	 =  case happyOut184 happy_x_1 of { happy_var_1 -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	happyIn184
		 (App (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_448 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_448 = happySpecReduce_1  170# happyReduction_448
happyReduction_448 happy_x_1
	 =  case happyOut187 happy_x_1 of { happy_var_1 -> 
	happyIn184
		 (happy_var_1
	)}

happyReduce_449 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_449 = happySpecReduce_2  171# happyReduction_449
happyReduction_449 happy_x_2
	happy_x_1
	 =  case happyOut185 happy_x_1 of { happy_var_1 -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	happyIn185
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_450 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_450 = happySpecReduce_1  171# happyReduction_450
happyReduction_450 happy_x_1
	 =  case happyOut186 happy_x_1 of { happy_var_1 -> 
	happyIn185
		 ([happy_var_1]
	)}

happyReduce_451 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_451 = happyMonadReduce 1# 172# happyReduction_451
happyReduction_451 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut187 happy_x_1 of { happy_var_1 -> 
	( checkPattern happy_var_1)})
	) (\r -> happyReturn (happyIn186 r))

happyReduce_452 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_452 = happyMonadReduce 2# 172# happyReduction_452
happyReduction_452 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	( checkPattern (BangPat (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2))}})
	) (\r -> happyReturn (happyIn186 r))

happyReduce_453 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_453 = happyMonadReduce 3# 173# happyReduction_453
happyReduction_453 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut243 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 At) -> 
	case happyOut187 happy_x_3 of { happy_var_3 -> 
	( do { n <- checkUnQual happy_var_1;
                                              return (AsPat (happy_var_1 <> happy_var_3 <** [happy_var_2]) n happy_var_3) })}}})
	) (\r -> happyReturn (happyIn187 r))

happyReduce_454 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_454 = happyMonadReduce 3# 173# happyReduction_454
happyReduction_454 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut243 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RPCAt) -> 
	case happyOut187 happy_x_3 of { happy_var_3 -> 
	( do { n <- checkUnQual happy_var_1;
                                              return (CAsRP (happy_var_1 <> happy_var_3 <** [happy_var_2]) n happy_var_3) })}}})
	) (\r -> happyReturn (happyIn187 r))

happyReduce_455 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_455 = happySpecReduce_2  173# happyReduction_455
happyReduction_455 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Tilde) -> 
	case happyOut187 happy_x_2 of { happy_var_2 -> 
	happyIn187
		 (IrrPat (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_456 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_456 = happySpecReduce_2  173# happyReduction_456
happyReduction_456 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 TApp) -> 
	case happyOut109 happy_x_2 of { happy_var_2 -> 
	happyIn187
		 (TypeApp (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_457 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_457 = happySpecReduce_1  173# happyReduction_457
happyReduction_457 happy_x_1
	 =  case happyOut188 happy_x_1 of { happy_var_1 -> 
	happyIn187
		 (happy_var_1
	)}

happyReduce_458 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_458 = happyMonadReduce 3# 174# happyReduction_458
happyReduction_458 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut188 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	( liftM (amap (const (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3]))) $ mkRecConstrOrUpdate happy_var_1 [])}}})
	) (\r -> happyReturn (happyIn188 r))

happyReduce_459 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_459 = happyMonadReduce 4# 174# happyReduction_459
happyReduction_459 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut188 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut232 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( liftM (amap (const (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:snd happy_var_3 ++ [happy_var_4]))))
                                              $ mkRecConstrOrUpdate happy_var_1 (fst happy_var_3))}}}})
	) (\r -> happyReturn (happyIn188 r))

happyReduce_460 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_460 = happySpecReduce_1  174# happyReduction_460
happyReduction_460 happy_x_1
	 =  case happyOut189 happy_x_1 of { happy_var_1 -> 
	happyIn188
		 (happy_var_1
	)}

happyReduce_461 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_461 = happySpecReduce_1  175# happyReduction_461
happyReduction_461 happy_x_1
	 =  case happyOut244 happy_x_1 of { happy_var_1 -> 
	happyIn189
		 (IPVar (ann happy_var_1) happy_var_1
	)}

happyReduce_462 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_462 = happySpecReduce_1  175# happyReduction_462
happyReduction_462 happy_x_1
	 =  case happyOut257 happy_x_1 of { happy_var_1 -> 
	happyIn189
		 (happy_var_1
	)}

happyReduce_463 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_463 = happySpecReduce_1  175# happyReduction_463
happyReduction_463 happy_x_1
	 =  case happyOut243 happy_x_1 of { happy_var_1 -> 
	happyIn189
		 (Var (ann happy_var_1) happy_var_1
	)}

happyReduce_464 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_464 = happySpecReduce_1  175# happyReduction_464
happyReduction_464 happy_x_1
	 =  case happyOut237 happy_x_1 of { happy_var_1 -> 
	happyIn189
		 (happy_var_1
	)}

happyReduce_465 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_465 = happySpecReduce_1  175# happyReduction_465
happyReduction_465 happy_x_1
	 =  case happyOut271 happy_x_1 of { happy_var_1 -> 
	happyIn189
		 (Lit (ann happy_var_1) happy_var_1
	)}

happyReduce_466 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_466 = happySpecReduce_3  175# happyReduction_466
happyReduction_466 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut196 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn189
		 (Paren (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_467 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_467 = happyMonadReduce 3# 175# happyReduction_467
happyReduction_467 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut190 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	( do { e <- mkSumOrTuple Boxed (happy_var_1 <^^> happy_var_3) (snd happy_var_2)
                                            ; return $ amap (\l -> l <** [happy_var_1] ++ fst happy_var_2 ++ [happy_var_3]) e })}}})
	) (\r -> happyReturn (happyIn189 r))

happyReduce_468 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_468 = happySpecReduce_3  175# happyReduction_468
happyReduction_468 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut196 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn189
		 (TupleSection (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) Unboxed [Just happy_var_2]
	)}}}

happyReduce_469 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_469 = happyMonadReduce 3# 175# happyReduction_469
happyReduction_469 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut190 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	( do { e <- mkSumOrTuple Unboxed (happy_var_1 <^^> happy_var_3) (snd happy_var_2)
                                          ; return $ amap (\l -> l <** [happy_var_1] ++ fst happy_var_2 ++ [happy_var_3]) e })}}})
	) (\r -> happyReturn (happyIn189 r))

happyReduce_470 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_470 = happySpecReduce_3  175# happyReduction_470
happyReduction_470 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut208 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn189
		 (amap (\l -> l <** [happy_var_3]) $ happy_var_2 (happy_var_1 <^^> happy_var_3 <** [happy_var_1])
	)}}}

happyReduce_471 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_471 = happySpecReduce_3  175# happyReduction_471
happyReduction_471 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ParArrayLeftSquare) -> 
	case happyOut216 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 ParArrayRightSquare) -> 
	happyIn189
		 (amap (\l -> l <** [happy_var_3]) $ happy_var_2 (happy_var_1 <^^> happy_var_3 <** [happy_var_1])
	)}}}

happyReduce_472 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_472 = happyMonadReduce 3# 175# happyReduction_472
happyReduction_472 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut198 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	( checkEnabled RegularPatterns >> return (Paren (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2))}}})
	) (\r -> happyReturn (happyIn189 r))

happyReduce_473 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_473 = happySpecReduce_3  175# happyReduction_473
happyReduction_473 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 RPGuardOpen) -> 
	case happyOut197 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RPGuardClose) -> 
	happyIn189
		 (SeqRP (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse (snd happy_var_2) ++ [happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_474 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_474 = happyReduce 5# 175# happyReduction_474
happyReduction_474 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 RPGuardOpen) -> 
	case happyOut175 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Bar) -> 
	case happyOut214 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RPGuardClose) -> 
	happyIn189
		 (GuardRP (happy_var_1 <^^> happy_var_5 <** (happy_var_1:happy_var_3 : snd happy_var_4 ++ [happy_var_5])) happy_var_2 $ (reverse $ fst happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_475 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_475 = happySpecReduce_1  175# happyReduction_475
happyReduction_475 happy_x_1
	 =  case happyOut199 happy_x_1 of { happy_var_1 -> 
	happyIn189
		 (happy_var_1
	)}

happyReduce_476 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_476 = happySpecReduce_1  175# happyReduction_476
happyReduction_476 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn189
		 (let Loc l (THIdEscape s) = happy_var_1 in SpliceExp (nIS l) $ IdSplice (nIS l) s
	)}

happyReduce_477 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_477 = happySpecReduce_3  175# happyReduction_477
happyReduction_477 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THParenEscape) -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn189
		 (let l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) in SpliceExp l $ ParenSplice l happy_var_2
	)}}}

happyReduce_478 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_478 = happySpecReduce_3  175# happyReduction_478
happyReduction_478 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THExpQuote) -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 THCloseQuote) -> 
	happyIn189
		 (let l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) in BracketExp l $ ExpBracket l happy_var_2
	)}}}

happyReduce_479 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_479 = happyMonadReduce 3# 175# happyReduction_479
happyReduction_479 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 THPatQuote) -> 
	case happyOut176 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 THCloseQuote) -> 
	( do { p <- checkPattern happy_var_2;
                                              let {l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) };
                                              return $ BracketExp l $ PatBracket l p })}}})
	) (\r -> happyReturn (happyIn189 r))

happyReduce_480 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_480 = happySpecReduce_3  175# happyReduction_480
happyReduction_480 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THTypQuote) -> 
	case happyOut119 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 THCloseQuote) -> 
	happyIn189
		 (let l = happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3] in BracketExp l $ TypeBracket l happy_var_2
	)}}}

happyReduce_481 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_481 = happyReduce 5# 175# happyReduction_481
happyReduction_481 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 THDecQuote) -> 
	case happyOut272 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOut273 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 THCloseQuote) -> 
	happyIn189
		 (let l = happy_var_1 <^^> happy_var_5 <** (happy_var_1:snd happy_var_3 ++ [happy_var_5])
                                            in BracketExp l $ DeclBracket (happy_var_1 <^^> happy_var_5 <** (happy_var_2:snd happy_var_3 ++ [happy_var_4,happy_var_5])) (fst happy_var_3)
	) `HappyStk` happyRest}}}}}

happyReduce_482 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_482 = happySpecReduce_3  175# happyReduction_482
happyReduction_482 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn189
		 (let {l1 = happy_var_1 <^^> happy_var_3 <** [happy_var_1];
                                             l2 = happy_var_2 <^^> happy_var_3 <** [happy_var_2,happy_var_3];}
                                         in VarQuote l1 (unit_con_name l2)
	)}}}

happyReduce_483 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_483 = happySpecReduce_2  175# happyReduction_483
happyReduction_483 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut243 happy_x_2 of { happy_var_2 -> 
	happyIn189
		 (VarQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_484 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_484 = happySpecReduce_2  175# happyReduction_484
happyReduction_484 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut247 happy_x_2 of { happy_var_2 -> 
	happyIn189
		 (VarQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_485 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_485 = happySpecReduce_2  175# happyReduction_485
happyReduction_485 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THTyQuote) -> 
	case happyOut286 happy_x_2 of { happy_var_2 -> 
	happyIn189
		 (TypQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) (UnQual (ann happy_var_2) happy_var_2)
	)}}

happyReduce_486 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_486 = happySpecReduce_2  175# happyReduction_486
happyReduction_486 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THTyQuote) -> 
	case happyOut116 happy_x_2 of { happy_var_2 -> 
	happyIn189
		 (TypQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_487 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_487 = happySpecReduce_1  175# happyReduction_487
happyReduction_487 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn189
		 (let Loc l (THQuasiQuote (n,q)) = happy_var_1 in QuasiQuote (nIS l) n q
	)}

happyReduce_488 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_488 = happySpecReduce_2  176# happyReduction_488
happyReduction_488 happy_x_2
	happy_x_1
	 =  case happyOut196 happy_x_1 of { happy_var_1 -> 
	case happyOut191 happy_x_2 of { happy_var_2 -> 
	happyIn190
		 ((fst happy_var_2, STuple (Just happy_var_1 : snd happy_var_2))
	)}}

happyReduce_489 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_489 = happySpecReduce_2  176# happyReduction_489
happyReduction_489 happy_x_2
	happy_x_1
	 =  case happyOut196 happy_x_1 of { happy_var_1 -> 
	case happyOut194 happy_x_2 of { happy_var_2 -> 
	happyIn190
		 ((happy_var_2, SSum 0 (length happy_var_2) happy_var_1)
	)}}

happyReduce_490 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_490 = happySpecReduce_2  176# happyReduction_490
happyReduction_490 happy_x_2
	happy_x_1
	 =  case happyOut193 happy_x_1 of { happy_var_1 -> 
	case happyOut192 happy_x_2 of { happy_var_2 -> 
	happyIn190
		 ((happy_var_1 ++ (fst happy_var_2), STuple ((map (const Nothing) happy_var_1) ++ snd happy_var_2))
	)}}

happyReduce_491 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_491 = happySpecReduce_3  176# happyReduction_491
happyReduction_491 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut194 happy_x_1 of { happy_var_1 -> 
	case happyOut196 happy_x_2 of { happy_var_2 -> 
	case happyOut195 happy_x_3 of { happy_var_3 -> 
	happyIn190
		 ((happy_var_1 ++ happy_var_3, SSum (length happy_var_1) (length happy_var_3) happy_var_2)
	)}}}

happyReduce_492 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_492 = happySpecReduce_2  177# happyReduction_492
happyReduction_492 happy_x_2
	happy_x_1
	 =  case happyOut193 happy_x_1 of { happy_var_1 -> 
	case happyOut192 happy_x_2 of { happy_var_2 -> 
	happyIn191
		 ((reverse happy_var_1 ++ fst happy_var_2, map (const Nothing) (tail happy_var_1) ++ snd happy_var_2)
	)}}

happyReduce_493 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_493 = happySpecReduce_2  178# happyReduction_493
happyReduction_493 happy_x_2
	happy_x_1
	 =  case happyOut196 happy_x_1 of { happy_var_1 -> 
	case happyOut191 happy_x_2 of { happy_var_2 -> 
	happyIn192
		 ((fst happy_var_2, Just happy_var_1 : snd happy_var_2)
	)}}

happyReduce_494 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_494 = happySpecReduce_1  178# happyReduction_494
happyReduction_494 happy_x_1
	 =  case happyOut196 happy_x_1 of { happy_var_1 -> 
	happyIn192
		 (([], [Just happy_var_1])
	)}

happyReduce_495 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_495 = happySpecReduce_0  178# happyReduction_495
happyReduction_495  =  happyIn192
		 (([], [Nothing])
	)

happyReduce_496 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_496 = happySpecReduce_2  179# happyReduction_496
happyReduction_496 happy_x_2
	happy_x_1
	 =  case happyOut193 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	happyIn193
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_497 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_497 = happySpecReduce_1  179# happyReduction_497
happyReduction_497 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Comma) -> 
	happyIn193
		 ([happy_var_1]
	)}

happyReduce_498 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_498 = happySpecReduce_2  180# happyReduction_498
happyReduction_498 happy_x_2
	happy_x_1
	 =  case happyOut194 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	happyIn194
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_499 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_499 = happySpecReduce_1  180# happyReduction_499
happyReduction_499 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Bar) -> 
	happyIn194
		 ([happy_var_1]
	)}

happyReduce_500 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_500 = happySpecReduce_1  181# happyReduction_500
happyReduction_500 happy_x_1
	 =  case happyOut194 happy_x_1 of { happy_var_1 -> 
	happyIn195
		 (happy_var_1
	)}

happyReduce_501 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_501 = happySpecReduce_0  181# happyReduction_501
happyReduction_501  =  happyIn195
		 ([]
	)

happyReduce_502 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_502 = happySpecReduce_1  182# happyReduction_502
happyReduction_502 happy_x_1
	 =  case happyOut175 happy_x_1 of { happy_var_1 -> 
	happyIn196
		 (happy_var_1
	)}

happyReduce_503 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_503 = happySpecReduce_2  182# happyReduction_503
happyReduction_503 happy_x_2
	happy_x_1
	 =  case happyOut255 happy_x_1 of { happy_var_1 -> 
	case happyOut176 happy_x_2 of { happy_var_2 -> 
	happyIn196
		 (PreOp (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_504 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_504 = happyMonadReduce 3# 182# happyReduction_504
happyReduction_504 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut175 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut224 happy_x_3 of { happy_var_3 -> 
	( do {checkEnabled ViewPatterns;
                                             return $ ViewPat (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3})}}})
	) (\r -> happyReturn (happyIn196 r))

happyReduce_505 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_505 = happySpecReduce_3  183# happyReduction_505
happyReduction_505 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut197 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut175 happy_x_3 of { happy_var_3 -> 
	happyIn197
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_506 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_506 = happySpecReduce_1  183# happyReduction_506
happyReduction_506 happy_x_1
	 =  case happyOut175 happy_x_1 of { happy_var_1 -> 
	happyIn197
		 (([happy_var_1],[])
	)}

happyReduce_507 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_507 = happySpecReduce_3  184# happyReduction_507
happyReduction_507 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut175 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut198 happy_x_3 of { happy_var_3 -> 
	happyIn198
		 (EitherRP (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_508 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_508 = happySpecReduce_3  184# happyReduction_508
happyReduction_508 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut175 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut175 happy_x_3 of { happy_var_3 -> 
	happyIn198
		 (EitherRP (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_509 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_509 = happyMonadReduce 10# 185# happyReduction_509
happyReduction_509 (happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut202 happy_x_2 of { happy_var_2 -> 
	case happyOut205 happy_x_3 of { happy_var_3 -> 
	case happyOut207 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XStdTagClose) -> 
	case happyOut200 happy_x_6 of { happy_var_6 -> 
	case happyOut181 happy_x_7 of { happy_var_7 -> 
	case happyOutTok happy_x_8 of { (Loc happy_var_8 XCloseTagOpen) -> 
	case happyOut202 happy_x_9 of { happy_var_9 -> 
	case happyOutTok happy_x_10 of { (Loc happy_var_10 XStdTagClose) -> 
	( do { n <- checkEqNames happy_var_2 happy_var_9;
                                                                       let { cn = reverse happy_var_6;
                                                                             as = reverse happy_var_3;
                                                                             l  = happy_var_1 <^^> happy_var_10 <** [happy_var_1,happy_var_5] ++ happy_var_7 ++ [happy_var_8,srcInfoSpan (ann happy_var_9),happy_var_10] };
                                                                       return $ XTag l n as happy_var_4 cn })}}}}}}}}}})
	) (\r -> happyReturn (happyIn199 r))

happyReduce_510 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_510 = happyReduce 5# 185# happyReduction_510
happyReduction_510 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut202 happy_x_2 of { happy_var_2 -> 
	case happyOut205 happy_x_3 of { happy_var_3 -> 
	case happyOut207 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XEmptyTagClose) -> 
	happyIn199
		 (XETag   (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_5]) happy_var_2 (reverse happy_var_3) happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_511 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_511 = happySpecReduce_3  185# happyReduction_511
happyReduction_511 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 XCodeTagOpen) -> 
	case happyOut175 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 XCodeTagClose) -> 
	happyIn199
		 (XExpTag (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_512 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_512 = happyReduce 5# 185# happyReduction_512
happyReduction_512 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 XChildTagOpen) -> 
	case happyOut200 happy_x_2 of { happy_var_2 -> 
	case happyOut181 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 XCloseTagOpen) -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XCodeTagClose) -> 
	happyIn199
		 (XChildTag (happy_var_1 <^^> happy_var_5 <** (happy_var_1:happy_var_3++[happy_var_4,happy_var_5])) (reverse happy_var_2)
	) `HappyStk` happyRest}}}}}

happyReduce_513 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_513 = happySpecReduce_2  186# happyReduction_513
happyReduction_513 happy_x_2
	happy_x_1
	 =  case happyOut200 happy_x_1 of { happy_var_1 -> 
	case happyOut201 happy_x_2 of { happy_var_2 -> 
	happyIn200
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_514 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_514 = happySpecReduce_0  186# happyReduction_514
happyReduction_514  =  happyIn200
		 ([]
	)

happyReduce_515 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_515 = happySpecReduce_1  187# happyReduction_515
happyReduction_515 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn201
		 (let Loc l (XPCDATA pcd) = happy_var_1 in XPcdata (nIS l) pcd
	)}

happyReduce_516 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_516 = happySpecReduce_3  187# happyReduction_516
happyReduction_516 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 XRPatOpen) -> 
	case happyOut197 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 XRPatClose) -> 
	happyIn201
		 (XRPats (happy_var_1 <^^> happy_var_3 <** (snd happy_var_2 ++ [happy_var_1,happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_517 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_517 = happySpecReduce_1  187# happyReduction_517
happyReduction_517 happy_x_1
	 =  case happyOut199 happy_x_1 of { happy_var_1 -> 
	happyIn201
		 (happy_var_1
	)}

happyReduce_518 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_518 = happySpecReduce_3  188# happyReduction_518
happyReduction_518 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut203 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Colon) -> 
	case happyOut203 happy_x_3 of { happy_var_3 -> 
	happyIn202
		 (let {Loc l1 s1 = happy_var_1; Loc l2 s2 = happy_var_3}
                                         in XDomName (nIS l1 <++> nIS l2 <** [l1,happy_var_2,l2]) s1 s2
	)}}}

happyReduce_519 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_519 = happySpecReduce_1  188# happyReduction_519
happyReduction_519 happy_x_1
	 =  case happyOut203 happy_x_1 of { happy_var_1 -> 
	happyIn202
		 (let Loc l str = happy_var_1 in XName (nIS l) str
	)}

happyReduce_520 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_520 = happySpecReduce_1  189# happyReduction_520
happyReduction_520 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn203
		 (let Loc l (VarId  s) = happy_var_1 in Loc l s
	)}

happyReduce_521 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_521 = happySpecReduce_1  189# happyReduction_521
happyReduction_521 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn203
		 (let Loc l (ConId  s) = happy_var_1 in Loc l s
	)}

happyReduce_522 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_522 = happySpecReduce_1  189# happyReduction_522
happyReduction_522 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn203
		 (let Loc l (DVarId s) = happy_var_1 in Loc l $ mkDVar s
	)}

happyReduce_523 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_523 = happySpecReduce_1  189# happyReduction_523
happyReduction_523 happy_x_1
	 =  case happyOut204 happy_x_1 of { happy_var_1 -> 
	happyIn203
		 (happy_var_1
	)}

happyReduce_524 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_524 = happySpecReduce_1  190# happyReduction_524
happyReduction_524 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	happyIn204
		 (Loc happy_var_1 "type"
	)}

happyReduce_525 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_525 = happySpecReduce_1  190# happyReduction_525
happyReduction_525 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Class) -> 
	happyIn204
		 (Loc happy_var_1 "class"
	)}

happyReduce_526 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_526 = happySpecReduce_1  190# happyReduction_526
happyReduction_526 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	happyIn204
		 (Loc happy_var_1 "data"
	)}

happyReduce_527 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_527 = happySpecReduce_1  190# happyReduction_527
happyReduction_527 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Foreign) -> 
	happyIn204
		 (Loc happy_var_1 "foreign"
	)}

happyReduce_528 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_528 = happySpecReduce_1  190# happyReduction_528
happyReduction_528 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Export) -> 
	happyIn204
		 (Loc happy_var_1 "export"
	)}

happyReduce_529 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_529 = happySpecReduce_1  190# happyReduction_529
happyReduction_529 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	happyIn204
		 (Loc happy_var_1 "safe"
	)}

happyReduce_530 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_530 = happySpecReduce_1  190# happyReduction_530
happyReduction_530 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Unsafe) -> 
	happyIn204
		 (Loc happy_var_1 "unsafe"
	)}

happyReduce_531 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_531 = happySpecReduce_1  190# happyReduction_531
happyReduction_531 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Interruptible) -> 
	happyIn204
		 (Loc happy_var_1 "interruptible"
	)}

happyReduce_532 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_532 = happySpecReduce_1  190# happyReduction_532
happyReduction_532 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Threadsafe) -> 
	happyIn204
		 (Loc happy_var_1 "threadsafe"
	)}

happyReduce_533 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> P (HappyAbsSyn )
happyReduce_533 = happySpecReduce_1  190# happyReduction_533
happyReduction_533 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_StdCall) -> 
	happyIn204
		 (Loc happy_var_1 "stdcall"
	)}

happyReduce_534 :: () => Happy_GHC_Exts.Int# -> Loc Token -> Happy_G