*-----------------------------------------------------------------------
*     TMSTLS : THE ROUTINE FOR DRAWING STREAM LINES (COORD. OF SPHERIC.)
*-----------------------------------------------------------------------
*     COPYRIGHT (C) 2000-2017 GFD DENNOU CLUB. ALL RIGHTS RESERVED.
*-----------------------------------------------------------------------
      SUBROUTINE TMSTLS( L, T, U, V, NX, NY )


      IMPLICIT NONE

      INTEGER NXZ
      PARAMETER (NXZ=10)
      INTEGER NYZ
      PARAMETER (NYZ=10)

*-- AGREENMENT
      INTEGER  NX        !* GRID NUMBERS FOR X-DIRECTION
      INTEGER  NY        !* GRID NUMBERS FOR Y-DIRECTION
      REAL     U(NX,NY)  !* VECTOR COMPONENT OF X-DIRECTION
      REAL     V(NX,NY)  !* VECTOR COMPONENT OF Y-DIRECTION
      REAL     L(NX)     !* GRID POINTS OF ZONAL DIR. [UNIT:DEGREE]
      REAL     T(NY)     !* GRID POINTS OF MERIDIONAL DIR. [UNIT:DEGREE]

*-- INTERNAL VARIABLES
      REAL     TRX(2,NXZ*NYZ,NXZ*NYZ)  !* STREAM LINE OF X-COORDINATE
      REAL     TRY(2,NXZ*NYZ,NXZ*NYZ)  !* STREAM LINE OF Y-COORDINATE
      INTEGER  NM(2,NXZ*NYZ)         !* ARRAY NUMBER IN EACH STREAM LINE
      REAL     X(NXZ), Y(NYZ)
      REAL     TMPU(NXZ,NYZ), TMPV(NXZ,NYZ)

      CALL TMZTLS( L, T, U, V, NX, NY
     & ,TRX,TRY,NM,X,Y,TMPU,TMPV )

      END SUBROUTINE TMSTLS

