<?php

// Define the superglobals
/**
 * An associative array containing references to all variables which are currently defined in the global scope of the script. 
 * The variable names are the keys of the array.
 */
$GLOBALS = array();

/**
 * $_SERVER is an array containing information such as headers, paths, and script locations. 
 * The entries in this array are created by the web server. There is no guarantee that every web server will provide any of these; 
 * servers may omit some, or provide others not listed here. 
 * That said, a large number of these variables are accounted for in the CGI/1.1 specification, so you should be able to expect those.
 **/
$_SERVER = array();

/**
 * An associative array of variables passed to the current script via the URL parameters.
 */
$_GET = array();

/**
 * An associative array of variables passed to the current script via the HTTP POST method.
 */
$_POST = array();

/**
 * An associative array of items uploaded to the current script via the HTTP POST method.
 */
$_FILES = array();

/**
 * An associative array of variables passed to the current script via HTTP Cookies.
 */
$_COOKIE = array();

/**
 * An associative array containing session variables available to the current script. 
 * See the Session functions documentation for more information on how this is used.
 */
$_SESSION = array();

/**
 * An associative array that by default contains the contents of $_GET, $_POST and $_COOKIE.
 */
$_REQUEST = array();

/**
 * An associative array of variables passed to the current script via the environment method.
 * These variables are imported into PHP's global namespace from the environment under which the PHP parser is running. Many are provided by the shell under which PHP is running and different systems are likely running different kinds of shells, a definitive list is impossible. Please see your shell's documentation for a list of defined environment variables.
 * their environment variables include the CGI variables, placed there regardless of whether PHP is running as a server module or CGI processor.
 */ 
$_ENV = array();

/**
 * $php_errormsg is a variable containing the text of the last error message generated by PHP. This variable will only be available within the scope in which the error occurred, 
 * and only if the track_errors configuration option is turned on (it defaults to off).
 */
$php_​errormsg = "";

/**
 * $HTTP_RAW_POST_DATA contains the raw POST data. See always_populate_raw_post_data
 */
$HTTP_​RAW_​POST_​DATA = "";

/**
 *The $http_response_header array is similar to the get_headers() function. When using the HTTP wrapper, $http_response_header will be populated with the HTTP response headers. 
 * $http_response_header will be created in the local scope.
 */
$http_​response_​header = array();

/**
 * Contains the number of arguments passed to the current script when running from the command line.
 * Note: The script's filename is always passed as an argument to the script, therefore the minimum value of $argc is 1.
 * Note: This variable is not available when register_argc_argv is disabled.
 */
$argc = 1;

/**
 * Contains an array of all the arguments passed to the script when running from the command line.
 * Note: The first argument $argv[0] is always the name that was used to run the script.
 * Note: This variable is not available when register_argc_argv is disabled.
 */
$argv = array();

?>
