import re

#
# This file shows how to create a custom configuration file format.
#
# A file format is parsed by a function that gets the file pathname as the only
# parameter, and yields key, value pairs.
#

def parser(pathname):
    """
    Parse a configuration file containing lines in the form "key value"
    """
    for lineno, line in enumerate(open(pathname)):
        line = line.strip()
        if not line: continue       # Strip empty lines
        if line[0] == '#': continue # Strip comment lines
        vals = line.strip().split(None, 1)
        if len(vals) == 1:
            # ParseError is provided to us by cfget
            raise ParseError(line, lineno, "found key without a value")
        yield vals[0], vals[1]

def init(db):
    """
    This function is called by cfget when it loads this file as a plugin.

    The parameter 'db' is the main cfget engine, to which we can attach
    parsers, template engines and dump functions.
    """

    # Add the new file format. The name is used in --format=NAME
    db.add_format("spaces", parser)
