v {xschem version=3.4.4 file_version=1.2
*
* This file is part of XSCHEM,
* a schematic capture and Spice/Vhdl/Verilog netlisting tool for circuit
* simulation.
* Copyright (C) 1998-2023 Stefan Frederik Schippers
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
}
G {}
K {}
V {}
S {}
E {}
B 2 1030 -330 1570 -130 {flags=graph
y1=-5.7
y2=44
ypos1=0
ypos2=2
divy=5
subdivy=1
unity=1
x1=3
x2=10

subdivx=8



unitx=M
divx=10
dataset=
color=4
node=DIFFOUT
color=4}
B 2 1030 -550 1570 -350 {flags=graph
y1=-180
y2=180
ypos1=0
ypos2=2
divy=5
subdivy=1
unity=1
x1=3
x2=10

subdivx=8



unitx=M
divx=10
dataset=
color=4

color=7
node=ph(DIFFOUT)}
B 2 1420 -617.5 1558 -555 {flags=image
alpha=0.6
filter="gm convert png:- -transparent black png:-"
image=/home/schippes/sda7/1.png
image_data=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}
T {CMOS DIFFERENTIAL AMPLIFIER
EXAMPLE} 40 -680 0 0 0.4 0.4 {}
T {Feedback
network 
loading} 870 -490 0 0 0.4 0.4 {}
T {gain AC plot at 10uA bias current} 1030 -120 0 0 0.4 0.4 {layer=5}
N 30 -240 30 -210 {lab=VCC}
N 30 -240 60 -240 {lab=VCC}
N 190 -230 190 -180 {lab=GN}
N 190 -180 230 -180 {lab=GN}
N 230 -180 230 -150 {lab=GN}
N 230 -150 410 -150 {lab=GN}
N 450 -220 450 -180 {lab=D}
N 380 -250 400 -250 {lab=0}
N 500 -250 520 -250 {lab=0}
N 380 -220 520 -220 {lab=D}
N 320 -250 340 -250 {lab=PLUS}
N 560 -250 580 -250 {lab=MINUS}
N 520 -400 570 -400 {lab=VCC}
N 330 -400 380 -400 {lab=VCC}
N 420 -400 480 -400 {lab=#net1}
N 420 -400 420 -370 {lab=#net1}
N 380 -370 420 -370 {lab=#net1}
N 380 -370 380 -280 {lab=#net1}
N 520 -370 520 -280 {lab=DIFFOUT}
N 520 -470 520 -430 {lab=VCC}
N 380 -470 520 -470 {lab=VCC}
N 380 -470 380 -430 {lab=VCC}
N 450 -490 450 -470 {lab=VCC}
N 520 -330 900 -330 {lab=DIFFOUT}
N 30 -370 30 -340 {lab=PLUS}
N 30 -370 60 -370 {lab=PLUS}
N 450 -120 450 -90 {lab=0}
N 450 -120 470 -120 {lab=0}
N 470 -150 470 -120 {lab=0}
N 450 -150 470 -150 {lab=0}
N 190 -120 190 -90 {lab=0}
N 170 -120 190 -120 {lab=0}
N 170 -150 170 -120 {lab=0}
N 170 -150 190 -150 {lab=0}
N 830 -600 830 -580 {lab=DIFFOUT_L}
N 830 -520 830 -500 {lab=0}
N 750 -250 750 -220 { lab=#net2}
N 750 -160 750 -140 { lab=0}
N 580 -250 580 -230 { lab=MINUS}
N 720 -230 750 -230 { lab=#net2}
N 650 -600 650 -580 {lab=D_L}
N 650 -520 650 -500 {lab=0}
N 790 -470 790 -450 { lab=DIFFOUT_L}
N 790 -390 790 -370 { lab=D_L}
N 830 -420 850 -420 { lab=DIFFOUT}
N 850 -420 850 -330 { lab=DIFFOUT}
N 580 -230 660 -230 { lab=MINUS}
N 890 -330 890 -250 { lab=DIFFOUT}
N 880 -250 890 -250 { lab=DIFFOUT}
N 750 -250 820 -250 { lab=#net2}
N 750 -220 800 -220 {
lab=#net2}
N 750 -160 800 -160 {
lab=0}
C {lab_pin.sym} 30 -150 0 0 {name=p17 lab=0  net_name=true}
C {title.sym} 160 -30 0 0 {name=l1 author="Stefan Schippers"  net_name=true}
C {nmos4.sym} 430 -150 0 0 {name=m1 model=cmosn w=5u l=2u m=1  net_name=true}
C {pmos4.sym} 500 -400 0 0 {name=mtop_2nd model=cmosp w=5u l=2u m=1  net_name=true}
C {vsource.sym} 30 -180 0 0 {name=VVCC value=5  net_name=true}
C {lab_pin.sym} 450 -90 0 0 {name=p1 lab=0  net_name=true}
C {lab_pin.sym} 60 -240 0 1 {name=p2 lab=VCC  net_name=true}
C {nmos4.sym} 210 -150 0 1 {name=m3 model=cmosn w=5u l=2u m=1  net_name=true}
C {lab_pin.sym} 190 -90 0 0 {name=p3 lab=0  net_name=true}
C {isource.sym} 190 -260 0 0 {name=IBIAS value=10u  net_name=true}
C {lab_pin.sym} 190 -290 0 0 {name=p4 lab=0  net_name=true}
C {nmos4.sym} 360 -250 0 0 {name=m4 model=cmosn w=10u l=1u m=1  net_name=true}
C {lab_pin.sym} 400 -250 0 1 {name=p5 lab=0  net_name=true}
C {nmos4.sym} 540 -250 0 1 {name=m5 model=cmosn w=10u l=1u m=1  net_name=true}
C {lab_pin.sym} 500 -250 0 0 {name=p0 lab=0  net_name=true}
C {lab_pin.sym} 570 -400 0 1 {name=p6 lab=VCC  net_name=true}
C {pmos4.sym} 400 -400 0 1 {name=mtop_1st model=cmosp w=5u l=2u m=1  net_name=true}
C {lab_pin.sym} 330 -400 0 0 {name=p7 lab=VCC  net_name=true}
C {lab_pin.sym} 450 -490 0 0 {name=p8 lab=VCC  net_name=true}
C {lab_pin.sym} 320 -250 0 0 {name=p9 lab=PLUS  net_name=true}
C {lab_pin.sym} 580 -250 0 1 {name=p10 lab=MINUS  net_name=true}
C {lab_pin.sym} 900 -330 0 1 {name=p11 lab=DIFFOUT  net_name=true}
C {lab_pin.sym} 190 -200 0 0 {name=p13 lab=GN  net_name=true}
C {lab_pin.sym} 30 -280 0 0 {name=p14 lab=0  net_name=true}
C {vsource.sym} 30 -310 0 0 {name=VPLUS value="dc 2.5"
}
C {lab_pin.sym} 60 -370 0 1 {name=p15 lab=PLUS  net_name=true}
C {code.sym} 10 -550 0 0 {name=STIMULI
only_toplevel=true
value="


** models are generally not free: you must download
** SPICE models for active devices and put them  into the below 
** referenced file in netlist/simulation directory.
** http://bwrcs.eecs.berkeley.edu/Classes/icdesign/ee241_s00/ASSIGNMENTS/TSMC035-n96g-params.txt
.include \\"models_cmos_example.txt\\"

.control
.ac dec 10 1000 10G

** ngspice
* .save all

** xyce, not needed if -r given om cmdline
* .print tran format=raw v(diffout) v(plus) v(minus)
"  net_name=true}
C {lab_pin.sym} 790 -570 0 0 {name=l18 lab=DIFFOUT}
C {lab_pin.sym} 790 -530 0 0 {name=l19 lab=0}
C {lab_pin.sym} 830 -500 0 0 {name=l20 lab=0}
C {lab_pin.sym} 830 -600 0 1 {name=l21 lab=DIFFOUT_L}
C {vcvs.sym} 830 -550 0 0 {name=e1 value=1}
C {lab_pin.sym} 750 -140 0 0 {name=p12 lab=0  net_name=true}
C {lab_pin.sym} 450 -200 0 0 {name=p16 lab=D}
C {lab_pin.sym} 610 -570 0 0 {name=l2 lab=D}
C {lab_pin.sym} 610 -530 0 0 {name=l3 lab=0}
C {lab_pin.sym} 650 -500 0 0 {name=l4 lab=0}
C {lab_pin.sym} 650 -600 0 1 {name=l5 lab=D_L}
C {vcvs.sym} 650 -550 0 0 {name=e2 value=1}
C {nmos4.sym} 810 -420 0 1 {name=m7 model=cmosn w=10u l=1u m=1  net_name=true}
C {lab_pin.sym} 790 -470 0 0 {name=l6 lab=DIFFOUT_L}
C {lab_pin.sym} 790 -370 0 0 {name=l7 lab=D_L}
C {lab_pin.sym} 790 -420 0 0 {name=p18 lab=0  net_name=true}
C {vsource.sym} 690 -230 3 0 {name=VLOOP value="dc 0 ac 1 0"}
C {res.sym} 750 -190 0 0 {name=R2
value=10G
m=1}
C {ind.sym} 850 -250 1 0 {name=L1
m=1
value=100k
footprint=1206
device=inductor}
C {launcher.sym} 1040 -580 0 0 {name=h2
descr="View raw file"
tclcommand="textwindow $netlist_dir/[file tail [file rootname [xschem get current_name]]].raw"
}
C {launcher.sym} 1040 -770 0 0 {name=h5 
descr=" Ctrl-Left-Click to load/unload
embedded waveforms" 
tclcommand="xschem raw_read_from_attr"
spice_data="
VGl0bGU6ICoqIHNjaF9wYXRoOiAvaG9tZS9zY2hpcHBlcy94c2NoZW0tcmVwby90cnVuay94c2NoZW1fbGlicmFyeS9leGFtcGxlcy90ZXN0X2FjX3h5Y2Uuc2NoCkRh
dGU6IFdlZCBGZWIgMDIgMTA6MDE6MzUgMjAyMgpQbG90bmFtZTogQUMgQW5hbHlzaXMKRmxhZ3M6IGNvbXBsZXgKTm8uIFZhcmlhYmxlczogMTcKTm8uIFBvaW50czog
NzEgICAgICAgICAgICAgICAgClZhcmlhYmxlczoKCTAJZnJlcXVlbmN5CWZyZXF1ZW5jeQoJMQlECXZvbHRhZ2UKCTIJRF9MCXZvbHRhZ2UKCTMJRElGRk9VVAl2b2x0
YWdlCgk0CURJRkZPVVRfTAl2b2x0YWdlCgk1CUUxI2JyYW5jaAljdXJyZW50Cgk2CUUyI2JyYW5jaAljdXJyZW50Cgk3CUdOCXZvbHRhZ2UKCTgJTDEjYnJhbmNoCWN1
cnJlbnQKCTkJTUlOVVMJdm9sdGFnZQoJMTAJTkVUMQl2b2x0YWdlCgkxMQlORVQyCXZvbHRhZ2UKCTEyCVBMVVMJdm9sdGFnZQoJMTMJVkNDCXZvbHRhZ2UKCTE0CVZM
T09QI2JyYW5jaAljdXJyZW50CgkxNQlWUExVUyNicmFuY2gJY3VycmVudAoJMTYJVlZDQyNicmFuY2gJY3VycmVudApCaW5hcnk6CgAAAAAAQI9AAAAAAAAAAAC08TCD
6+2zP8OfoloVmk6/tPEwg+vtsz/Dn6JaFZpOv/dH321gxmLA0sv9LS+o2b/3R99tYMZiwNLL/S0vqNm/CpQQaug+iD+c8KVGo4EAP89m6WLoPoi/CTj9LZGEAL+9p0l4
gZ/aPUn4NdrpVEE+AABwdzrsBb7nYmka1wqQPmyVAgAAAPA/AAAAANBCPD2duIvjEkbKP/YukzDFi2S/AAAAAGCrxD3MjLeo0UI8PQAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAZ6CScYqYnz3iGFG07TMovkcRjABE6Uk9FK5gjxbNsD2tVdWSG9tbvhhtENyOH4y+ID0mn7Ork0AAAAAAAAAAAHzCl3nX7bM/OeOsT7kWRr98wpd5
1+2zPznjrE+5Fka/v7bHoGTGYsAraBKeGobSv7+2x6BkxmLAK2gSnhqG0r+bgmvR7T6IPw1HgMeO1Pc+uNdyyu0+iL/GBTby7tv3vtGa900DM9g9RQ3/T6jRRT4AANiz
HCX5vQeIcG5hfIk+bJ4BAAAA8D8AAAAAmJMpPQWi0Wf4Rco/s7UZdf8PXr8AAAAAwOa5PRtJH3aVkyk9AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABUmK5k
zbecPcgPNMA8eC6+GxPFsjWfRz1AkjWAqia1PSc+aMzZI1y+9+geepSFhL4RZguhksOYQAAAAAAAAAAAUHdiY8vtsz84AuPG9YA9v1B3YmPL7bM/OALjxvWAPb8PFj8p
Z8ZiwEqPlowVwci/DxY/KWfGYsBKj5aMFcHIv8IV5xPxPog/ymY0iWTV7z7NIjgN8T6Iv0RwErH25+++JEF9aJJb1D1oU79x3HdLPgAAYCz4sOq9BBC4qII+hD6SAgEA
AADwPwAAAAAAVhU9TrVjXehFyj+lA1goRaJUvwAAAAAgKbA9L0cUURlWFT0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADGDaJceKJg9bF/t1/ctM76VrCM0
Wf5DPeR7d/OYoLo9EhtWFuVPXL48v97NtgZ8vl2SS5wMLZ9AAAAAAAAAAAAA47OkxO2zP0dFdDStZjC/AOOzpMTtsz9HRXQ0rWYwv2D4PJNoxmLAt6/H5NWOu79g+DyT
aMZiwLevx+TVjru/2F+h5fI+iD97U4+KorPhPuRDZ9/yPoi/DCm8sQPL4b6GAVJa0InMPcGoNoJFSlE+AACQOF2a170v7pR6nhSAPj2gAAAAAPA/AAAAAOB2/Tw2julN
30XKPzw3xiKpm0i/AAAAAKAHpD2gsaK4w3b9PAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAhkEbq3LtkD2FhbZaSiU4vs0KyrZffDw92PdhicXCwD1Dcqwi
v2hcvqR+XcJUgHC+ls9Z2sWfo0AAAAAAAAAAAFC42cjB7bM/0oD+QuuvEL9QuNnIwe2zP9KA/kLrrxC/3b3jLGnGYsCl4AgcvUycv9294yxpxmLApeAIHL1MnL951SCr
8z6IPx6+Dg3HDMI+5+efpfM+iL/JA/CRgoLCvsqM5nJSerI9jNIoZ1XEVT4AAIBA0UCzvfJpZY3li3k+MWIAAAAA8D8AAAAAIJHSPDQSvUTbRco/Aj9tA4CEMr8AAAAA
QIyYPYleKWAykdI8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB9o6Y3SOF1PU4aBonJZT6+2FlFg9aDJD0/lMjZvxnFPYoTsCnFc1y+sTl9QptrV74xPXkp
jrSoQAAAAAAAAAAAzDTcMcLtsz8z0l+GYVcfP8w03DHC7bM/M9JfhmFXHz9irV0XacZiwKRNaNoIEKo/Yq1dF2nGYsCkTWjaCBCqPwmNBo/zPog/MhxqvnXf0L7XHauK
8z6Iv574rARaldA+Px3VWEBZxb2L7eugJ2dbPgAAwF02K7w9hxw0AdNKdD4LOwAAAADwPwAAAADAnNS8TGfcYttFyj/eseKiwWMmPwAAAACAhY09KiJBX6yc1LwAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIFXd7DAYIm9r7+ZM1giQ75lQ1tH66Eyve02775mkMo9jPCAS1hzXL6LORHZ1OpRPlB/lrYkGq9AAAAAAAAAAACQ22X2
xe2zP0YofUt8QjQ/kNtl9sXtsz9GKH1LfEI0P9pxBU5oxmLAi3CPN2/qwD/acQVOaMZiwItwjzdv6sA/sqhBi/I+iD9pyysPqtXlvoxht4jyPoi/7wFVEASn5T5PA6La
5nThvVe5K5HKP2E+AAAAoIULzT3FA/SWZB5wPlciAAAAAPA/AAAAAABD37wg/Meu30XKP+uzsgxvwEQ/AAAAAIArgT18JnK2IULfvAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAA54/pYQe8pL2Nr7iKpRZIvlBnRGXhGlC9YYLtaZy40D3IIIMIYWdcvq9+QSfDGm4+eBJuUd+Ts0AAAAAAAAAAANzap+bN7bM/8rALUKjhQD/c2qfm
ze2zP/KwC1Co4UA/lWZlpWbGYsDur3yTdjfMP5VmZaVmxmLA7q98k3Y3zD/zK8Bn8D6IP5JGUPygMvK+ox0XaPA+iL8Nk4HzQxXyPvnzW9IUVfK9/6iYoi+3ZT4AACAP
Az7TPZxryndpm2k+whIAAAAA8D8AAAAAALncvCS+6RXpRco/VEnwU2mBUj8AAAAAAMJyPYTnu8kEuNy8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQp5A/
QcW1vS0BepJWU06+Nk6u/J4fYb06WD5+AA3VPdOXEC9KTVy+yKNDsEBtej5fTkfNkqW4QAAAAAAAAAAAVF5Judvtsz/KeKeGNIhIP1ReSbnb7bM/yninhjSISD+8TdbB
Y8ZiwP3UHBuTgtQ/vE3WwWPGYsD91Bwbk4LUPxXpVK7sPog/H0jBrYBy+r68RDyz7D6Iv1Xa8U+JTfo+WstMyd3GAL7l2erwrFZrPgAAoFZbONY9QFNz+CJXZD7tCAAA
AADwPwAAAAAARtS8fvnSn/lFyj92tqaO4J5bPwAAAAAA2mE9KChgsg9E1LwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJNjau3168O9EYNdjLgWU74LLHPo
A4BvvbTRAvVrgNo9QnReJnIfXL4u1XissJqDPgau6EdIB79AAAAAAAAAAADU/BNq8u2zPzSYqU6WvlA/1PwTavLtsz80mKlOlr5QP8tKtwNfxmLAStkW2wIB3D/LSrcD
X8ZiwErZFtsCAdw/eAY2keY+iD+40yH/cw0Cv+QuWZ3mPoi/JAmcLi/2AT99Y8QgvNYMvojus457NXE+AABgBFkZ2D00mQXhKChgPrgCAAAAAPA/AAAAAABUwrwUa1/e
FEbKP7zeztVuGmM/AAAAAADART3QaUPZ51LCvAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzXeTcSkf0b3PC7+U/gdYvuVs206BJHu9R+in8pyu4D0/qJPL
89NbvgEdYa//CYs+AwAAAACIw0AAAAAAAAAAAPBhyt4W7rM/B4tkWVMdVj/wYcreFu6zPweLZFlTHVY/44r6ZFfGYsB1VjfQl37iP+OK+mRXxmLAdVY30Jd+4j9zV5O+
3D6IP/Fau2i91we/F2At1tw+iL87cO5EcroHP4NufUhQ+he+fRStoFSqdT4AACCIzkjZPQDI1Gnlqlk+nP3/////7z8AAAAAAHCqPAsq77JARso/1t0LZ9VpaT8AAAAA
ACAzvQAfvgyklqo8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACbyx+oh3jcvS0SojjbQF6+rIP/12WZhr1y02LAhwDlPYaiGsCDWlu+fGjtHvL0kT5szO+G
oJbIQAAAAAAAAAAAxOK39VDusz/maRVcgalcP8Tit/VQ7rM/5mkVXIGpXD+ZLphAS8ZiwA/zT/jG+Oc/mS6YQEvGYsAP80/4xvjnP5P7rxfNPog/9zXNTAbnDr9iaHVB
zT6Iv3p2zoglwg4/bBBrKjOQI76D7g8Au0Z7PgAAwFQ8CNo9EL+dlmVjVD6r+P/////vPwAAAAAA7NA8345Ck4ZGyj++f5ja0YlwPwAAAAAAVE29MBZcKzzs0DwAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFnibtmTOue9PGwmYQ0LY74nIEUAIXSSvchEsAbycOo9JArVO+yYWr4uLEipqFmXPpo/Tkl39M5AAAAAAAAAAAC0qlA4
re6zPxyTPRAsXmI/tKpQOK3usz8ckz0QLF5iP/avtfc3xmLAsraDM7G57j/2r7X3N8ZiwLK2gzOxue4/1v/GO7Q+iD8fmLt0wM0Tv6wyWIK0Poi/7O9L8Im2Ez80OpVB
TJEvvva8m6quK4E+AABQVvSA2j1AXQdr2TFQPo71/////+8/AAAAAADk3zzhHAWU9UbKP9+tGI8iQHU/AAAAAADkVL3AP6iqcuTfPAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAeZ7h6bO98r1Mv2Q7PPlnvhmRRyytyp29EZZr7Bel8D05uw9HZWVZvj24FRSh/J0+fTuv4Sd800AAAAAAAAAAADR7jY8/77M/rIht7+hhZz80e42P
P++zP6yIbe/oYWc/g6XtYBnGYsChHgrKqo7zP4Ol7WAZxmLAoR4KyqqO8z8ACX7NjD6IP3WtSajgNRm/Pj6yQY0+iL8ZIAyopxgZPxm3PR3RSzm+bNa0gHaehT4AALAx
Bc3aPYB4FqMqukk+lfP/////7z8AAAAAAGToPL3XpKmlR8o/gNOCqgwYez8AAAAAANZYvcA04u26Zeg8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADjSXPX
Fgn+vZJ6bFAjLm6+6cCGJ1zhp70vd/7H/PT0PYpcbliRfVe+HJqyISEcoz5/Q/BQt4fYQAAAAAAAAAAA2BMXjyfwsz9yqU+bPaRtP9gTF48n8LM/cqlPmz2kbT9/qo7i
6MViwJqVgVH2yvg/f6qO4ujFYsCalYFR9sr4P7btukpOPog/rvAT4ID1H7/USkIHTz6IvxOSDzm30B8/F0EKlIYvRL661wcVujiLPgAAMCLa/No9QPavMV9vRD5Y8v//
///vPwAAAAAAGvE8KZ/J0rxIyj+CLB41jzCBPwAAAAAAUFu9YJKoEloa8TwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP96o2yr9we+78he8CH/cr7Sf0Bp
NQ+zvYIW5jJLY/o9HhTOgy14VL7uZwyvUT6oPoKM17Ox4d5AAAAAAAAAAACYrZZDl/GzP/BN4YcovXI/mK2WQ5fxsz/wTeGHKL1yPxoYawacxWLAwebHT/VY/z8aGGsG
nMViwMHmx0/1WP8/HnQuN+s9iD/t6BdZODQkv61uU2bsPYi/nrX0pxAdJD/JxzgJuhBQvuJGQznNI5E+AAAwPcYa2z2A0IOxKjtAPpDx/////+8/AAAAAADs9jyoi8RI
d0rKPzYUc7E5v4U/AAAAAADgXL2gkjfhi+72PAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFRT9bj8TE77Q9GSu9Ol3vtFtp19uV769jQCbomCdAD4A0mjv
wlxPvlYot4e4qq4+lQ8e8lZw40AAAAAAAAAAADzb7vnd87M/MGW9ok6ndz882+753fOzPzBlvaJOp3c/UUgZOSLFYsAGz7H128gDQFFIGTkixWLABs+x9dvIA0BRzN40
Tj2IP4Q4AcG+gCm/+L6jGVA9iL9PPd33mGMpP+IPXReVh1m+Ob2gn2eWlT4AAED4Pi3bPQDzqaB6yDk+E/H/////7z8AAAAAAAD+PKw8sXc0Tco/AqqCOvB1iz8AAAAA
ANpdvWAZrM3J/P08AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAW1vk8B1Aevnfvw1JbGn6+CUXQ0hwcyL3io7jwBe0EPq9veLOiL0C+hsEBBU5csz4Zl8kl
13joQAAAAAAAAAAApNEgTXn3sz+ZpvXmNtN9P6TRIE1597M/mab15jbTfT/xpF05YcRiwGvi2nNe8ghA8aRdOWHEYsBr4tpzXvIIQCjxyGtVPIg/v2aJxxcUML+xj1Zw
WDyIv6xMGpm/ATA/aJukcElDZL7C6VlLTDKbPgAAIBNBONs9AG/jzh96ND7D8P/////vPwAAAAAAVAM9Rzbvg4tRyj/L7xF0FVGRPwAAAAAAel69QOxQTOxRAz0AAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADOtCDYjDyi+WzZ9FyPygr6wSujEByPTvUrvCMXBXAo+GSetMeRxLz6DTSN2mWq4Pv0hmYD3zu5AAAAAAAAAAADk+qka
MP2zPzagwNknyoI/5PqpGjD9sz82oMDZJ8qCP+SBz3Uvw2LAd/5VW8tuD0Dkgc91L8NiwHf+VVvLbg9AY2mbRss6iD/6F+icP0I0v0X3FRPQOoi/82mJ7ygrND9AH+zq
IBJwvtpRW7p1I6E+AAAg+Sw+2z0AIIKf7kIwPpHw/////+8/AAAAAACuCD1eLVm5a1jKP647lNBs0pU/AAAAAADeXr1QxMQ3IawIPQAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAjtZWWO8UM766RHu6gtiHvjEBgvA/W969bPLYAL6cED5BOeEMu/pWPtWFTDSVxL4+x2zxLI1k80AAAAAAAAAAADi8PQo9BrQ/W1RhFXSphz84vD0K
PQa0P1tUYRV0qYc/d54HKUvBYsDSqfVBscoTQHeeBylLwWLA0qn1QbHKE0C+9RD9WjiIPweI4XkSgzm/fvqum2I4iL9v2JhLBGY5P6R8Drtlenm+7EBhZVydpT4AAOAy
SkDbPQAIQD/d0ik+c/D/////7z8AAAAAAFgPPRl/crhPY8o/zhbJFJF7mz8AAAAAABpfvSBvYdPrVA89AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABOEQBk
ckA+vqiFe2E7Ao6+pnWv2kIQ6L15BlkDKfMUPmQzfBBPk2o+JeLPLtZfwz4IAAAAAGr4QAAAAAAAAAAAWBV1e5EUtD+uUSxhhsiNP1gVdXuRFLQ/rlEsYYbIjT+3Cz1c
TL5iwENg7rt16RhAtws9XEy+YsBDYO67dekYQKhvWYt+NIg/EKYOKFYOQL9Cl1ahijSIv0IbOwUe+D8/+ca5tLEvhL43WTxQxkmrPgAAEGQOP9s9APhRjut/JD5i8P//
///vPwAAAAAA1BM92xcz/410yj8+jJZ9/0uhPwAAAAAAPF+92DQ9t5LSEz0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA7zuaT590e+vJHF7cvgkr7y1H/C
2BDzvYAILGhOcho+7ISgB/46eT4Sfk6LK2PIPou/q6hIvP5AAAAAAAAAAADIJhhnPiu0P0PKtPgEvJI/yCYYZz4rtD9DyrT4BLySP3qHEfuOuWLAK8lD7ixXH0B6hxH7
jrliwCvJQ+4sVx9AKeCvb2IuiD+RgzSsAzNEvyYV8JZ1Loi/oCGixgYcRD/I0oM4c/iPvtyIdZvkQLE+AAAQbTc62z0AAHsTdEQgPlnw/////+8/AAAAAAAEGT3tDiYc
14/KP16XXQKnwqU/AAAAAABOX72go9DYLwUZPQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEqjnBg/7Ur4HCkOrY76XvuUVdXA/Mv69iz1S7RG4ID723lhi
cxCGPq5JGCFQrs4+w+fQjcpYA0EAAAAAAAAAAKxE2Z0XT7Q/F1HIBJ+Nlz+sRNmdF0+0PxdRyASfjZc/Y502tBCyYsDRtZCMbbMjQGOdNrQQsmLA0bWQjG2zI0BfVwmu
uSSIP6QICAYTZUm/0NCcAdgkiL/DVXvrLUhJPwxPl9TJTJm+Ddi+pJDftT4AAKD9vjDbPQCgNkCLzRk+V/D/////7z8AAAAAAIQfPTZTSBv6uso/4Lg+OERbqz8AAAAA
AFJfvcAgXD1xhR89AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZueMaoApevg9asfbP2J2+V7/bjG/lB75PG1N78DAlPiB8ApxUgJI+2Av4CzpJ0z5gChva
MVsIQQAAAAAAAAAACENLHa+HtD/IkaIVSJWdPwhDSx2vh7Q/yJGiFUiVnT/lT3twPKZiwC8L3zOevihA5U97cDymYsAvC98znr4oQL6itBd6FYg/iV5I3nDlT7902bAO
qhWIvzh412cnwU8/YA2SZ3cApL7BV7up/ta7PgAAsI2mINs9AGAYcgByFD5b8P/////vPwAAAAAA1CM9fQkt7hL/yj8As1oRxC2xPwAAAAAASl+9sL6rn03SIz0AAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUqw0tRwGe+vCsMhkC+or72DCGzcuQSvj7yuMFu9io+okvEqNhKnj5jN7M3BDnYPmRULCWlqQ5BAAAAAAAAAAA0HV0r
0eC0P+kwEL8xjaI/NB1dK9HgtD/pMBC/MY2iP55e+d6ak2LA4gROvN8IL0CeXvnempNiwOIETrzfCC9AAZJJ4HX9hz9IUFdeiwBUv2nsGJ/B/Ye/sQKOvcrpUz+xYSd0
fZSvvmHQ2E8S08E+AADwi5QG2z0AoH97Si0QPmfw/////+8/AAAAAADkKD2Vh/K/U2rLP0TcZ4LuirU/AAAAAAAyX71gQrpScOEoPQAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAA78WcGz3Acr4yS1KtIIKnvsoK7Wo/1B2+XnA5fQlBMT67THDKhW6oPoZAn6nOYN4+1LdmEA9NE0EAAAAAAAAAAH8HClWybLU/BQGpoR43pz9/BwpV
smy1PwUBqaEeN6c/nMxX0l12YsA104QkGmszQJzMV9JddmLANdOEJBprM0DIxzpExdeHP6dSpTjXB1m/W8vRmzzYh7/1yFdhX+tYP/e3Qomt37i+owpB+HsIxz4AABA+
N93aPQAAa5ajigk+ffD/////7z8AAAAAACgvPYETbUCkEsw/OIpDzdfzuj8AAAAAAAZfvTB9NzzaJi89AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAljhM0
YYp9vqZi1dXka62++ZagTtd+J74MTKm8Y0c2PkgVYft7gLM+eNsBCGkB4z5+k6WubEwYQQAAAAAAAAAAf2lWXflGtj96fzE1YvOsP39pVl35RrY/en8xNWLzrD8vj+Wk
vUhiwKF382pANzhAL4/lpL1IYsChd/NqQDc4QI5bX+z0nIc/dGGxAfI2X7+hht1LsJ2HvwQvJ21zE18/TSqyM8yFw75SodBOrSnOPgAAkMBinNo9AIAl868XBD6g8P//
///vPwBoPYQubjM9EwbqX0kZzT+9SwQItszAPwAAAAAAwF69AGo9hC5uMz0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAdffPRJMIe+eJeRCVtZsr7fVHfH
IXEyvpsrrbZqJD0+xF9QxhTfvj5lH657XrLnPuT8O+8Mlx5BAAAAAAAAAAAylM9gmJi3P8MdscJe9LE/MpTPYJiYtz/DHbHCXvSxPyT5zUwrAmLAh6be/lAJPkAk+c1M
KwJiwIem3v5QCT5AT/yjfPxBhz9Qo/Sc1Ftjv+NB5RUhQ4e/IlS349JFYz9TqkE1f3rOvmaa9NgTH9Q+AACAL+832j0AACVyWXD/Pdfw/////+8/AKfr2Q8bOD3Z4C/d
ha/OP/s7BV5k08Q/AAAAAABSXr0ApuvZDxs4PQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAALu45edMakr671gA4i8S2vpTU+q84yzy+eLjkPO9oQz6G77SK
fzrIPp1nVVxaYu0+QbVfsFpBI0EAAAAAAAAAAIZYjPq+m7k/Qg7r5DIWtj+GWIz6vpu5P0IO6+QyFrY/Dpu5NX2WYcBjckM9iHlCQA6buTV9lmHAY3JDPYh5QkBWcEpl
LreGPxxj3sFx0Ge/0S4QjPO4hr+jsLtmYrVnP+daSKm0l9e+aUqxbfmC2z4AAIADjp7ZPQAAQW21Y/g9LvH/////7z8AaUbYXKg9Pb0Lwt6rjdA/XeZgW36YyT8AAAAA
AKRdvQBqRthcqD09AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABlpUYo1wmcvuo32kNHBry+ejFe/qlKRr6w98ZhsHtKPhNMxn9/0tI+3rmv3b0Q8j78xy14
sD0oQQAAAAAAAAAA+FjQ6KmdvD/Sen0uPdW6P/hY0Oipnbw/0np9Lj3Vuj8lwQFVjvVgwHjBGPX1cUZAJcEBVY71YMB4wRj19XFGQNLwbvO654U/lQyNRaHubL8N43sM
cOqFv44/VdrGzWw/Krh20E8I4r5Yc09aX17jPgAAUGBBudg9AACbt0iu8j2u8f/////vP4Bz1JpmBEI9WnMpy9Bc0j/IiyiLOA3PPwAAAAAApFy9AHPUmmYEQj0AAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADGwIDkwcaW+qUmPpjIKwb7OzvZyuQpRvujc/6ysmFI+LPCa1uzY3D4wI1gdnO71Pg8AAACAhC5BAAAAAAAAAAAnzrrq
uHzAPy8HH3vHAMA/J8666rh8wD8vBx97xwDAP10J2vxTDGDAVnihhuXFSkBdCdr8UwxgwFZ4oYblxUpAYQjScha7hD/U4TyFYUFxv1JxjUMnv4S/P0vd0c4tcT/hKyew
Ow7rvvbqwZsyIOw+AABw4uhs1z0AAB5QRhXsPWny/////+8/QM0I7wt+RT2+LAik8PvUP3H1zbAketI/AAAAAAAuW72AzQjvC35FPQAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAnz9X7XkZsL7++0kBL1vEvt6aK6YNlFm+LuboZ/rsWj4ehC29BbDlPrwAWLeTIfo+uldraa01M0EAAAAAAAAAAAS1hKErgsM/b+DVqw+Zwj8EtYSh
K4LDP2/g1asPmcI/3uUMWPiRXcAcnsB1jh1PQN7lDFj4kV3AHJ7AdY4dT0BvwUU+SBqDP6wegA/XDXS/t9jwFTsgg7+xGmZ/IfdzP6drL0kKxPO+nXxmuTv49D4AAFCk
IKDVPQAAPBMxjeQ9bvP/////7z/AiSYrpvpIPQbKXakzntg/z+kbmFpl1T8AAAAAACRZvYCJJium+kg9AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADBJUu7
MI63vl0Dd3Dstse+b0awY2yyYr7HEeDr7wNkPpyCEp3Ywe8+66wX2IFQ/j64IUUx/S44QQAAAAAAAAAAzL/77A9zxz835EOHud7EP8y/++wPc8c/N+RDh7nexD/cM0XZ
bEZawNiQmDWkdVFA3DNF2WxGWsDYkJg1pHVRQFHh8KmY+oA/HT7KemOBdr+edWYsAAOBvx6OG774Z3Y/sj/j53jd+75kzCxj8ML/PgAA4PUPR9M9AAAQ8tcC3T2/9P//
///vP4Am5Mh7CEw9YYcNMkJb3T9e2F0LXd/XPwAAAAAAgla9gCbkyHsITD0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAE7cmU3Ho8C+4A5rhOS2yr4rR+PB
t2FqvuRoJbTCO24+TM3p9u1x9j6rfzxTEPYAP/3MoVD+cT5BAAAAAAAAAAAsdSfoXDPMP1DQV5zgacY/LHUn6FwzzD9Q0Fec4GnGPx7RZUZ1TVbAjBEXzLPAUkAe0WVG
dU1WwIwRF8yzwFJAmxyDiEXWfD+QhN2wFix4v4iRJPn/7Hy/tl4lw+cQeD9W2e1AScYCv0Js8S/BDwg/AAD40mly0D0AALD3bY/TPVj2/////+8/QJ9HIB8cTj3gzqTd
b4jhP9IofgOCZ9k/AAAAAABQU70An0cgHxxOPQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMlbSg/F/xr6/xOEaeN3MvkpxeLLYzHG+fkJxAQjadj7hu/YW
9lv+Po/WBBxdIgI/wbQ7NwcqQ0EAAAAAAAAAAKOjN1zptNA/b6pR7pLixj+jozdc6bTQP2+qUe6S4sY//8i/YK/xUcDq035FdyZTQP/Iv2Cv8VHA6tN+RXcmU0AdkF5h
/Dd3P7lmDM4yr3i/zSs/pjRVd7/HYyGBoJN4P9jfPa1GAQi/fiV38ZT0ET8AAHB6sK7KPQAAELN1AMk9F/j/////7z/AB8j9jb9OPV/wuvxmqeQ/KcAvPnCP2T8AAAAA
AKRPvcAHyP2Nv049AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAATKjC2Bu3MviZMbclrwc2+JLkpEH7Pdr6Pp2/2vAWBPpmOcfbWhAM/Drams0hiAj/NZYDU
UiBIQQAAAAAAAAAAen8sklZJ0z8B2utGiCrGP3p/LJJWSdM/AdrrRogqxj8aPQgiiUJLwG3cEnyojVJAGj0IIolCS8Bt3BJ8qI1SQKvW0yRXqHE/OyOQiyLqd78YqJq7
+stxv/ilkyS2z3c/0KlNeQ4GDb+Crda7tRoaPwAAWHSwiMQ9AABge4Arvj3T+f/////vP2BviqYzyk09KLQ59ZTA5z+JOO1nKC3YPwAAAAAAtEi9gG+KpjPKTT0AAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMNSzZDgo9G+7ti3AptBzb7ZVIXc7a17vuj3Yj9At4g+QnkgUkbPBz+G9NOjppoBP2L4TtqHX05BAAAAAAAAAAD3+V3+
pJfVP3ce4f+WbcQ/9/ld/qSX1T93HuH/lm3EP35zCOAkjEPALfPYs/waUUB+cwjgJIxDwC3z2LP8GlFAw2W//ppfaT8fyA5UNgx2vxatoxtWsmm/WrKmwEX0dT/WZMOG
55sQv732xmZGZiI/AABQlFcTvj0AAEDjQi+xPWD7/////+8/cNUOgwF3Sz3+D+e9yIDqP3g/CgSYbtU/AAAAAACAQr1w1Q6DAXdLPQAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAA6BwfVm551L6dQ52RiZnLvrCwtgCF3X++ZkhnoJtnkT4JdSJ4EaMLP6433Cc+2/8+En6FFWgeU0EAAAAAAAAAAFUU+2kIedc/CzvN0woKwj9VFPtp
CHnXPws7zdMKCsI/YzCGiNKDOsCrYVuwuTpOQGMwhojSgzrAq2FbsLk6TkBm8lTF9UNhPzrXE8Uke3O/g7XQuf2fYb+9tNt1lGZzP7yA97zsDxK/wHwfplIuKT8AAJDk
DBy1PQAAwNEFhKI9ovz/////7z+QVSY6rERIPUicX1XRuew/5aTRHtO80T8AAAAAAPA6vYBVJjqsREg9AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADOwr1n
jsbWvml4rkGBRMm+FwJYbkh+gb5WfGGFv82XPtElltKHvg4/o19t27ZN+z6UondcsRFYQQAAAAAAAAAA/VHrqwPl2D/zCqDFu8u+P/1R66sD5dg/8wqgxbvLvj+toiRU
VQAxwFfWQzBE1ElAraIkVFUAMcBX1kMwRNRJQN/kWqCJRFY/B3sA3vCkcL9Nib13hwpXvy305B0rlHA/IdTR7vu4Er8fS/wXuM4wPwAAkHSCp6w9AADAJGPckj2X/f//
///vP9Dpj9U+vEQ9k444ICpf7j/gjtPyjxDLPwAAAAAASDO90OmP1T68RD0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKM/ON+mf9i+7nPBAzTJxr6GTURu
vWyCvnTmv3Wqwp8+lnpju/mIED+M0MDZhC/2PgE6OZYcTV5BAAAAAAAAAAA9BHpDrujZP5chvkgIn7k/PQR6Q67o2T+XIb5ICJ+5PwjmGBEgbCTAD6IUtf6FRUAI5hgR
IGwkwA+iFLX+hUVAch9LJOoHSz/YhPLykbxrv5MfzbpTp0y/EKvik7iiaz/k1+Y40nYSv8AlEDQtAzY/AAAI9nf3oj0AAID4FP+BPUX+/////+8/aH0C+jZHQT0471T3
AX3vP3ybZFrrRcI/AAAAAACwK71ofQL6NkdBPQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAqHE32CGz2b7G6cHt15PEvmG8FG52rYK+ovF0t/TJpD6T+Kii
XVgRP44qGbzA+vA+DAAAANASY0EAAAAAAAAAAFBg34Mlmto/pDZPtuHptD9QYN+DJZraP6Q2T7bh6bQ/LPg9qi1DFsA2FPu2/5xBQCz4PaotQxbANhT7tv+cQUC1k3Mc
mhw+P/5C8RW0sWa/Dm7T6ES6QL8gRJBgRZ9mPwUoWKIXGBG/dbwTtLluPD8AABDkVaiYPQAAAHSEKm89vf7/////7z9QxHB070Y8Pas8MJs1FPA/TMc+EIfWsj8AAAAA
ADAkvVDEcHTvRjw9AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADQGNghlnnavqNgR+MB7MK+PxAvuo8ugr7+ZBSZENeqPjZGOFf93RE/4TExgqvj5z6tLcbD
GANoQQAAAAAAAAAArwWwXpYP2z85xQw6atKwP68FsF6WD9s/OcUMOmrSsD/Kn/3W890DwGIuI8nmcjxAyp/91vPdA8BiLiPJ5nI8QEIFy7T1ciw/QWMlqLtSYr9Lf7YS
uZ8xv1PYQzdQR2I/rHDH4sKDDL/TUC0YCC9CPwAAeMKuoo89AAAAdqUXVj0M///////vPwBjpgSp1TY908Ui9ck58D8Amxk6M8pxPwAAAAAAgB69CGOmBKnVNj0AAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAANP9ay476tq+JMk7bwX9wb7XK5oh/MiAvtq60j7tJ7E++wX7WnIpEj+7fpZ67KTcPitqln28Om5BAAAAAAAAAAAf8P09
J1vbP5lZ3L8Suao/H/D9PSdb2z+ZWdy/ErmqP1jA5sgLNN+/y8/kcdy9NkBYwObICzTfv8vP5HHcvTZAFHZEJFqJDz8nZfJ9gUhdv0AII2rhcx2/zoY0uvc+XT9cvYoM
mqgCv/2V/+yuGEc/AAA4YngWhD0AAABw3o8rPT///////+8/6InW5VdAMj0urTCLwzPwP+rjQjF+2LC/AAAAAAAgGL3oidblV0AyPQAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMr6/7DcV274ZhvKRR+TBvrQithnxZXy+zFMf3XLGtT6o+vzxhkUSP4SJV9eLxsQ+ISBl8j4Hc0EAAAAAAAAAALNgtjgdits/ylorYPj0pD+zYLY4
HYrbP8paK2D49KQ/gC/Dkky56D/rfuFQegQyQIAvw5JMueg/637hUHoEMkC8LgR/clcEvy7SRBGfL1e/WKngivHT675buTJS4zJXP9AeWs4rbdS+uAmUqkUuTT8AAHBI
iEh5PQAAADDYWDG9X///////7z+A1/NA/OksPTrUX2HMAPA/+BywNaytwb8AAAAAACAUvXDX80D86Sw9AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADTxKzh
0gHbviSmVHsUv8K+pwDt0Qnoc77QMHZ083u7Ptlc0275NhI/1swuY0Y+vb72oQoFifR3QQAAAAAAAAAAkfm3R3Wl2z8BL2mxdS+gP5H5t0d1pds/AS9psXUvoD8EFZUR
oJr4P9A54HG9SSxABBWVEaCa+D/QOeBxvUksQMtbNpeN3xm/kccjPyIvUr9wTSASTcQIP1BtskDsPlI/ZnDn4NwTBz/w6SoGW1lSPwAAUC8IiG89AAAAIMlsO71y////
///vP1iQCaXMsCY90FLty9gy7z9ClZfGTFLLvwAAAAAAwBG9SJAJpcywJj0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACW5H9KPrtq+bjZskQa3xL4MBZYM
COFavjam2tV7QsE+/f1/uI38ET9AKsqXQ8DYvkV/oIlnKH5BAAAAAAAAAACvmD4G5bLbP0yxen36fJg/r5g+BuWy2z9MsXp9+nyYPzEa80m+b/8/rmKt1c/3JUAxGvNJ
vm//P65irdXP9yVA+m0XEl9IIb+RNeqVnjNMv9jtEIpCYBU/z1U1pslrTD9ncwu166EfPxsKdxc991Y/AABA9FNzYz0AAACYetU7vX7//////+8/oD8bvLecIT04+zd0
lOHtP0vyyezOpdK/AAAAAABAEL2gPxu8t5whPQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4opNC5ES2r4dJO6CTg7IvkqU0JKG5mk+/FuVX9WRxT6X+8uT
/Y8RP9q7aReJAeW+QFtx6LT7gkEAAAAAAAAAAIyVpYLXtds/u1tPsGv7kT+MlaWC17XbP7tbT7Br+5E/AMbJImA4AUBB82US2dQgQADGySJgOAFAQfNlEtnUIECqnYIx
ESMjvzhumk1Cj0W/lvmfmfWMGT9qXojREN9FP0g6N8G1Xy8/DFV8wKCTXD8AAIDo0KxXPQAAALjPODi9g///////7z/grkf0dfcaPTWvMoTS7us/ErkL+Vyf178AAAAA
AEAPvfCuR/R19xo9AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAARP5uu5iDZvpAluqCuLM2+gVHiXn6IhD4mnSDZis7KPlIAEL9A6BA/Q/4apHRg7b6a3eYa
AuaHQQAAAAAAAAAAMlgju1Gw2z8+2BWzoEaJPzJYI7tRsNs/PtgVs6BGiT+hu0mwTE8BQMg0bV7lXRlAobtJsExPAUDING1e5V0ZQDI7BVtoJCO/p8QIGmoxQL96dxYf
VDYaP2zXa7qXlkA/xEavkGePOz/Mhl8/uaNhPwAAAKqhV0w9AAAArBdXM72D///////vPyAVPpyuSxQ9sb8QEpxC6T/KqgkREzXcvwAAAAAAQA+9IBU+nK5LFD0AAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAPjjVtgfz9e+jUQLMotV0r6OQBBvTsmTPvKzeFkejtA+W02oCjL8Dz+r3n5NXYTyvj+LlbMdFo5BAAAAAAAAAAC0qj9y
wqPbP3OnStvJoIA/tKo/csKj2z9zp0rbyaCAP7UBrVeCWQBAtm+1B97BEkC1Aa1XglkAQLZvtQfewRJAgEMTezDEIb8Bzmpr4dU3vy/+4Di1Shg/rQGJFlLCOD+iW7pr
bqtGP7MVZN06iWU/AAAAUqylQD0AAAAYTgUtvX///////+8/EIkqJkL1DT2h9Fk3Pd/lP9/MqVJs19+/AAAAAAAgEL0QiSomQvUNPQAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAoK2lHzgf1r6BoaMOu6vXvsbJYi6hz58+QmEsPc5R1D6RwU625KUNP/8+oXnbofW+Q8Tj3THwkkEAAAAAAAAAAPv8e4ipkds/zQIPUH6xcz/7/HuI
qZHbP80CD1B+sXM/Tx2eekpa/T8IfkLYfTsLQE8dnnpKWv0/CH5C2H07C0BQrATh1+Yev1K6swZGMTG/DEFd+wigFD99wtZxtDIyP/6YbkUc0VE/p++n5LDhaT8AAAAm
rzIzPQAAAEBXsSS9e///////7z8o3xKehK8FPc3jrHpI8+E/+qHIM+/24L8AAAAAAKAQvTDfEp6ErwU9AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB1s8Et
2yjUvl9EsWa9FN++qnpUxZ/fpj67F/JMIM/YPrEC6k6L7go/GMlxlWWm974TAAAAhNeXQQAAAAAAAAAAULTRr+J72z9T7elaezFjP1C00a/ie9s/U+3pWnsxYz9i8lvr
Okv5P+lKJw4UgANAYvJb6zpL+T/pSicOFIADQN4SFuKCVxm/kDK9V11sKL+0vA8xoxIQP7LAJxeveSo/ghAS3MPtWj+GtIMJj2xuPwAAABjl1iU9AAAAoPRTHL1z////
///vP3BtLE677v48ahA5AWOz2z/LmEEgbAzhvwAAAAAAoBG9cG0sTrvu/jwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAALzsj0bIGdK+Zc7ilMeK5L5VdOWE
+jCuPk+Ey7LENN4+1ckEYIAVCD9UbL/gjVb4vhy5t/TeA55BAAAAAAAAAABwYXXIfGTbP7u2f2LpT0U/cGF1yHxk2z+7tn9i6U9FP2Y8Z2G9NfU/dK65EfnM+z9mPGdh
vTX1P3SuuRH5zPs/MJb2gBvGE79tG/hD0j4hv0QLXuZ45gY/PFyRU5o4Iz/rDMEVio1jP1Y7VUJyWnE/AAAA/FS7GD0AAABIWt4SvW3//////+8/yIUVBy7v9TxKuxGN
mPzTP2M4ycmFM+C/AAAAAABgEr3QhRUHLu/1PAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIo4D8Zko0L7aKEu0chrrvn6WchAqj7I+nkHpNA1m4j7h9Npk
tmUFPxVWJ/rtwve+XgJ+zrXkokEAAAAAAAAAAFGQFjdmTds/XC2bYjVwN79RkBY3Zk3bP1wtm2I1cDe/2Nvv482c8T+cPYuzJvHzP9jb7+PNnPE/nD2Lsybx8z9HYcep
oMQNv1d+ARDHfRi/KburGiJy/T7VK1jyhh4cP55Ktkm8KGs/eWNIW3MLcz8AAAAQCS8MPQAAAPg65Ai9Z///////7z+wRdJ5E0jvPL02aJXk1so/jE/lodZQ3b8AAAAA
ACATvdBF0nkTSO88AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD3K4IW6QLNvvktE97ZwPG+feRE4yuEtT4VSz1kZ37mPkx3v6U2GgM/rYSu+mlF9r4taP6u
DsmnQQAAAAAAAAAApv4ZlVI42z+WnBL0V2BJv6b+GZVSONs/lpwS9FdgSb/PQvGOHYDtP44R06+GCu0/z0Lxjh2A7T+OEdOvhgrtP0h+yENyAQa/yiYEclSnEb+Hjm2u
9mjwPvp5aruf3xQ/r75jgSzycT+kje8UTPRzPwAAAAAOTQA9AAAAGA2PAL1h///////vPyDc4ghBqeY8lztzOFeVwD/v2XSI5n3ZvwAAAAAA4BO9INziCEGp5jwAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACLxYRNTdcq+PO2PK60M975peuSUbcm3Po5Cn0wcpus+pk3D+a5NAT+XpktAjVn0vnhKTUar8a1BAAAAAAAAAAAX3eV7
1SbbP5yMkuIj4Ua/F93le9Um2z+cjJLiI+FGvwP+suvrR+k/2F421PWM5T8D/rLr60fpP9heNtT1jOU/9nI6mVBLAL/tymohLfEJv/jW4Eh7MNs+BjCXvSiNDz+BaNW4
yX52P576TNYJ4HM/AAAAwJw38zwAAADgKov2vF///////+8/IFSs4s3J4Dz6JS69vzWyP9tNoV4qhdW/AAAAAAAgFL0YVKzizcngPAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAvqsEqDqtyL7z0VqT7Kv9vj8WPXHyTrk+zCXnZ3oX8T6iMShdyvn/PhibnmtMcfK+jk8EtkDZskEAAAAAAAAAAJK/eYtcGts/kEMY9uT/L7+Sv3mL
XBrbP5BDGPbk/y+/WghcjClW5j+B/vtKuUngP1oIXIwpVuY/gf77SrlJ4D9sL3k/Hp74vtstPFbmZwO/APtiC4Pxdz5gaYhTDkYIPxRCJcC1x3o/kP7LvHnVcj8AAABQ
CBPnPAAAAPCXpO+8XP//////7z/wS0p0Y4HZPH5DGk2PV58/f50mlOzL0b8AAAAAAIAUvfBLSnRjgdk8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACShyG0
MJnHvh3To7L+9gK/WnLyykwVuj5YYmvaVj71PhfVTWJhJ/4+X502u17f8L4Uso0iorq3QQAAAAAAAAAAOHljuewT2z+2SvhYu3M9Pzh5Y7nsE9s/tkr4WLtzPT8f8vAG
OlvkPwER0Fs0/tg/H/LwBjpb5D8BEdBbNP7YP3KvZcUFPPO+aAq6jmls/b4efyGyWqHRvgIJT4dp+gI/E3wNGC10fj+vBrhGbRNxPwAAACDHH9w8AAAA4BTo5rxb////
///vPziiIPos29M8sH+5FmLuaz/UoMZ46wnNvwAAAAAAoBS9OKIg+izb0zwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEcuGFHdIMe+dK22C20dCL+Hl264
3iO6PmM1uQgphfo+mKYAhavy/D6j7PeD3q7vvgWVoKGC371BAAAAAAAAAABDbZrO1hPbP+ikfEzPIlQ/Q22aztYT2z/opHxMzyJUP1ctIcIFDuM/F3dwIg1j0z9XLSHC
BQ7jPxd3cCINY9M/vxM3RuBN775EOUsrMXv2vrabyDs2bd2+fuxEj6Qe/j4fKV26566APyJJ3uB04W0/AAAAQDFU0TwAAACgNwjhvFr//////+8/sAO5S8OZzzwkPwSs
qbaNv/fSMtrafce/AAAAAADAFL2wA7lLw5nPPAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAArssBdWErx76EQG359osOv/qkTCDLh7k+yGF5rVGcAD/AjWSX
DS/8PnDudaoC8e6+Cnc9kNLNwkEAAAAAAAAAAKCLuseLGds/csmExQvdXz+gi7rHixnbP3LJhMUL3V8/rumUh8k14j+zLhZpnk3OP67plIfJNeI/sy4WaZ5Nzj9OoGEJ
AInqvmnWPv90OfG+iMelzhaF4r4bGgBy8kP4PhYmTrHMxYE/F1NXVcN0aT8AAAAA/YPFPAAAAKDl29m8Wf//////7z/AN5GhRpbJPDxk+TIe3Jq/cHq+1x3owr8AAAAA
AOAUvcg3kaFGlsk8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABp7YDVKJ7HviuNqkurSxO/tDd9GK5ZuD5yuv2kW9wEPz136txYufs+5vWU1Umw775YtVxV
PqzHQQAAAAAAAAAACPYk6poj2z/QxjlYEkZkPwj2JOqaI9s/0MY5WBJGZD9tR3TaSKrhPw52yuASzcc/bUd02kiq4T8OdsrgEs3HP2jlwLbXU+e+4UOEG0Zb6r7sZ2xq
XPTkvqXyyPhE5fM+LRJJiXyOgj/eOYpNgEZlPwAAAIDM2Lo8AAAAsObs07xZ///////vP7j5ny4P9MQ8dmDpHShcob8WU5YtNVa+vwAAAAAA4BS9wPmfLg/0xDwAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGilt3E8Wci+Slq5ynJVGL9wzYhx+sO2PiC2qCuSPgo/92zx2lR3+z4wovpZugrxvhwAAABlzc1BAAAAAAAAAADizc/n
8S/bP5SXXV5mimY/4s3P5/Ev2z+Ul11eZopmP+xhj+V3UOE/FX3tnJnBwj/sYY/ld1DhPxV97ZyZwcI/qvTuTXYk5b4Sh1VDDQ/kvrwVRO/igOa+o9i1saKu8D62ZAuP
XBuDPyIqmE7SiWE/AAAAABjOsDwAAABQsAbPvFj//////+8/MAKkm5I8wTyhZ3G0/vGjvywX57MiSbi/AAAAAAAAFb0wAqSbkjzBPAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAALQkCfDs3yb48lsAyW6cev+BHjywvAbU+ihgqyLmGED+7b6fe2FX7PgY5xFaxKPO+tdPyWGvC0kEAAAAAAAAAAA8Jg69rPNs/E42A+KC9Zj8PCYOv
azzbPxONgPigvWY/zO/RprAW4T8cr7voM6G9P8zv0aawFuE/HK+76DOhvT+AEYnW56Tjvg5dzGzNNt6+Xq5a01x85758lECzy8/sPnTBMuuCfIM/qPKxRGifXD8AAAAA
YBalPAAAAFDRUsi8Wf//////7z/gjw8Kn1G8PLUVazrBpqW/lzJcp4dos78AAAAAAOAUvfCPDwqfUbw8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB5EaC3
1BPKvmaIGKLGSyO/2vIfp+RNsz7Jo2fn4NIUP1YjFMxAR/s+mNQjNC1S9r75gh1C453XQQAAAAAAAAAAw+ijE25H2z9acIBGvlZlP8PooxNuR9s/WnCARr5WZT94Df8w
k/HgP73kW8tGcbc/eA3/MJPx4D+95FvLRnG3P1ZzJt7hnuK+KSKvmcNP1r5UeMDTixvovuajMM6h1+k+QVKEvnK+gz8vP1TnLy1XPwAAAADegJo8AAAAcF8ow7xZ////
///vP/C9dUrlJLc8mQ1/3ZvGpr+U6hwhsfmuvwAAAAAA4BS9+L11SuUktzwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAyr7Gj1Mq+n+HybmdJKL/wAWGc
zdaxPiPDIgjNPRo/TJXlJXRC+z6DrcsJerL6vj4CvlpSu91BAAAAAAAAAABN8bP4NFDbP4r0jygy/GI/TfGz+DRQ2z+K9I8oMvxiP06Mc1HL2eA/bsKVH+6Rsj9OjHNR
y9ngP27ClR/ukbI/3FoMRgHu4b5dpdIp5rfPvjvnSOAwgOi+cwh5IhBG6D72/gI6gOqDP0Yac+9HqFI/AAAAAG6tkDwAAAAAH0S+vFn//////+8/6K4W3QzLsjyAhq+C
P4Onv9cR0Efpr6i/AAAAAADgFL3orhbdDMuyPAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQJkBIBty77IFwsTAZEuv7eTayevr7A+EqFeaEuIID/s9sbr
AUL7PrPf3mT3QQC/jk7wCwu34kEAAAAAAAAAABsZGiWzVts/wy4tKmdDYD8bGRols1bbP8MuLSpnQ2A/Hx8qKpvK4D+H0jCyX3KtPx8fKiqbyuA/h9Iwsl9yrT9OqOvA
aHjhvh49Hj5R1MS+GHv77Ma/6L4Y7DWHkgLoPtbAV8iAB4Q/BRDEJPfoTT8AAAAArAKFPAAAAJCY9be8WP//////7z+YGBHvylWuPJIJoZfk/ae/odTAzt6no78AAAAA
AAAVvZgYEe/KVa48AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGUj9tNd7LvtouIlNJPDO/6LXPfwqurz6AeTQZxdMkP7wkNVwTQ/s+wP9m8hsKBL92Y4Xj
kI/nQQAAAAAAAAAAXtdyBkFb2z9wXCxYdiVbP17XcgZBW9s/cFwsWHYlWz8lrSTK78DgPz6NkMOWXKc/Ja0kyu/A4D8+jZDDllynPzosizRZK+G+gkQRVl17tr5XU45V
7ufovrRdq1z+B+k+39TrgFwahD+1NP4q3uZHPwAAAAB4eXo8AAAAYC3+srxY///////vP/AnSsvOXKg8kGK7ZQBNqL8Xy3/jokafvwAAAAAAABW9+CdKy85cqDwAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMgseGUbLcy+QTetSxU2OL8SW2VpeH+uPtb4w/eZOyo/Pig6lGVE+z5BmYvDiuQIv50eMatKqe1BAAAAAAAAAADECf5m
VV7bP0zJvG+EQ1Y/xAn+ZlVe2z9MybxvhENWPzGvyRHMuuA/giID772Koj8xr8kRzLrgP4IiA++9iqI/OtdAZnD54L4Yfir1ydySvuukBrFHAem+SAhqeXVj6z7tHBLM
gSaEPw1yQiyKD0M/AAAAAJiwcDwAAAAQwBuuvFj//////+8/oExRnat+ozxohuitsH+ov+VveUeZ3pi/AAAAAAAAFb2oTFGdq36jPAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAlJZfsGRizL78FJLS0nk+v7MoT4tus60+zTE7laaEMD+KqK+ohUX7Psw08pb2Eg+/Jl0EpbGr8kEAAAAAAAAAABj5fptdYNs/KHcc/BENUj8Y+X6b
XWDbPyh3HPwRDVI/WwfvJei24D90jL5QCnGdP1sH7yXotuA/dIy+UApxnT9PotSpZNngvjARd7OeXqk+qYzwmUcR6b52cBFutTTvPk/p0JVGLoQ/+R6Q551bPj8AAAAA
8A9lPAAAAEAY6Ke8Wf//////7z8wPR68yx6fPCBYhpIBoKi/x23Eo6PEk78AAAAAAOAUvTg9HrzLHp88AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAutjv3
hoXMvqNMaDZ8LkO/7gbbtQYtrT59pMiqwcw0P7676qtbRvs+cx+F4a10E7/Q1Ew0R4H3QQAAAAAAAAAAG0c7Y69h2z96DFGr4w1NPxtHO2OvYds/egxRq+MNTT8LMLX+
cbTgP3PnnHXmYJc/CzC1/nG04D9z55x15mCXP319EeDwxOC+LxFOSlWzvj6oT/OBYBvpvt286A7LV/I+nitopjgzhD8I5IVoQic4PwAAAADAllo8AAAAsFv0orxY////
///vP+B+M4UDzJg8linmM4m0qL9A4UV1K2uPvwAAAAAAABW94H4zhQPMmDwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFY89F9UnMy+45ioqoolSL+5KkJ1
2NWsPpGDBY51MDo/L0P7O/BG+z6+IWEINWkYv7Pis+pNl/1BAAAAAAAAAACEegRyiGLbP7155KpiRUc/hHoEcohi2z+9eeSqYkVHP0/MFqvjsuA/YixGzPiQkj9PzBar
47LgP2IsRsz4kJI/dsv7y/C34L5od9jM9yjJPnVEq7K/Iem+YXkerFkP9j7fTSYVXDaEP2XNtIagNDM/AAAAACDEUDwAAACwmRGevFj//////+8/YGUgwn28kzyePAgB
jMGovy4Imbm49oi/AAAAAAAAFb1oZSDCfbyTPAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAO1VqYvqqzL7u574/x2VOv2c+uyfcnaw+2BBptpt8QD9+V7eK
U0f7Pu9zw1CTqh6/FQAAIF+gAkIAAAAAAAAAAK8Gxf8SY9s/9b5u4BSVQj+vBsX/EmPbP/W+buAUlUI/+DTGC+ix4D9UK2/s032NP/g0xgvoseA/VCtv7NN9jT+od4Pz
sq/gvghtj/OeJtI+SwTI/8Ql6b6gQOOrrPP6Pkg0M+FYOIQ/4XoD+feHLj8AAAAAQB5FPAAAAEDh6pe8Wf//////7z/QXvzO5WSPPAtZMZXHyai/Mg/QMT7Vg78AAAAA
AOAUvdhe/M7lZI88AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAqnkSrU7TMvooTnYc1IlO/Fg/TOyN6rD648agUwcFEPw5ccXeUR/s+KoPyFgVHI78="}
C {capa.sym} 800 -190 0 0 {name=C1
m=1
value=1
footprint=1206
device="ceramic capacitor"}
C {launcher.sym} 1040 -670 0 0 {name=h1 
descr="tcleval(Select arrow and 
Ctrl key + Left Button-Click to load/unload waveforms
from $netlist_dir/[file tail [file rootname [xschem get current_name]]].raw)" 
tclcommand="
xschem raw_read $netlist_dir/[file tail [file rootname [xschem get current_name]]].raw
"
}
C {launcher.sym} 1210 -70 0 0 {name=h3
descr="Graph Manual page"
url="https://xschem.sourceforge.io/stefan/xschem_man/graphs.html"}
