/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.wiredtiger.db;

/**
  * @copydoc WT_ASYNC_OP
  * @ingroup wt_java
  */
public class AsyncOp {
 private long swigCPtr;
 protected boolean swigCMemOwn;
 protected boolean javaRaw;
 protected String keyFormat;
 protected String valueFormat;
 protected PackOutputStream keyPacker;
 protected PackOutputStream valuePacker;
 protected PackInputStream keyUnpacker;
 protected PackInputStream valueUnpacker;

 protected AsyncOp(long cPtr, boolean cMemoryOwn) {
   swigCMemOwn = cMemoryOwn;
   swigCPtr = cPtr;
   keyFormat = getKey_format();
   valueFormat = getValue_format();
   javaRaw = _java_raw();
   keyPacker = new PackOutputStream(keyFormat, javaRaw);
   valuePacker = new PackOutputStream(valueFormat, javaRaw);
   wiredtigerJNI.AsyncOp__java_init(swigCPtr, this, this);
 }

 protected static long getCPtr(AsyncOp obj) {
	 return ((obj == null) ? 0 : obj.swigCPtr);
 }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        throw new UnsupportedOperationException("C++ destructor does not have public access");
      }
      swigCPtr = 0;
    }
  }


	/**
	 * Retrieve the format string for this async_op's key.
	 */
	public String getKeyFormat() {
		return keyFormat;
	}

	/**
	 * Retrieve the format string for this async_op's value.
	 */
	public String getValueFormat() {
		return valueFormat;
	}

	/**
	 * Append a byte to the async_op's key.
	 *
	 * \param value The value to append.
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putKeyByte(byte value)
	throws WiredTigerPackingException {
		keyUnpacker = null;
		keyPacker.addByte(value);
		return this;
	}

	/**
	 * Append a byte array to the async_op's key.
	 *
	 * \param value The value to append.
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putKeyByteArray(byte[] value)
	throws WiredTigerPackingException {
		this.putKeyByteArray(value, 0, value.length);
		return this;
	}

	/**
	 * Append a byte array to the async_op's key.
	 *
	 * \param value The value to append.
	 * \param off The offset into value at which to start.
	 * \param len The length of the byte array.
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putKeyByteArray(byte[] value, int off, int len)
	throws WiredTigerPackingException {
		keyUnpacker = null;
		keyPacker.addByteArray(value, off, len);
		return this;
	}

	/**
	 * Append an integer to the async_op's key.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putKeyInt(int value)
	throws WiredTigerPackingException {
		keyUnpacker = null;
		keyPacker.addInt(value);
		return this;
	}

	/**
	 * Append a long to the async_op's key.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putKeyLong(long value)
	throws WiredTigerPackingException {
		keyUnpacker = null;
		keyPacker.addLong(value);
		return this;
	}

	/**
	 * Append a record number to the async_op's key.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putKeyRecord(long value)
	throws WiredTigerPackingException {
		keyUnpacker = null;
		keyPacker.addRecord(value);
		return this;
	}

	/**
	 * Append a short integer to the async_op's key.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putKeyShort(short value)
	throws WiredTigerPackingException {
		keyUnpacker = null;
		keyPacker.addShort(value);
		return this;
	}

	/**
	 * Append a string to the async_op's key.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putKeyString(String value)
	throws WiredTigerPackingException {
		keyUnpacker = null;
		keyPacker.addString(value);
		return this;
	}

	/**
	 * Append a byte to the async_op's value.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putValueByte(byte value)
	throws WiredTigerPackingException {
		valueUnpacker = null;
		valuePacker.addByte(value);
		return this;
	}

	/**
	 * Append a byte array to the async_op's value.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putValueByteArray(byte[] value)
	throws WiredTigerPackingException {
		this.putValueByteArray(value, 0, value.length);
		return this;
	}

	/**
	 * Append a byte array to the async_op's value.
	 *
	 * \param value The value to append
	 * \param off The offset into value at which to start.
	 * \param len The length of the byte array.
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putValueByteArray(byte[] value, int off, int len)
	throws WiredTigerPackingException {
		valueUnpacker = null;
		valuePacker.addByteArray(value, off, len);
		return this;
	}

	/**
	 * Append an integer to the async_op's value.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putValueInt(int value)
	throws WiredTigerPackingException {
		valueUnpacker = null;
		valuePacker.addInt(value);
		return this;
	}

	/**
	 * Append a long to the async_op's value.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putValueLong(long value)
	throws WiredTigerPackingException {
		valueUnpacker = null;
		valuePacker.addLong(value);
		return this;
	}

	/**
	 * Append a record number to the async_op's value.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putValueRecord(long value)
	throws WiredTigerPackingException {
		valueUnpacker = null;
		valuePacker.addRecord(value);
		return this;
	}

	/**
	 * Append a short integer to the async_op's value.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putValueShort(short value)
	throws WiredTigerPackingException {
		valueUnpacker = null;
		valuePacker.addShort(value);
		return this;
	}

	/**
	 * Append a string to the async_op's value.
	 *
	 * \param value The value to append
	 * \return This async_op object, so put calls can be chained.
	 */
	public AsyncOp putValueString(String value)
	throws WiredTigerPackingException {
		valueUnpacker = null;
		valuePacker.addString(value);
		return this;
	}

	/**
	 * Retrieve a byte from the async_op's key.
	 *
	 * \return The requested value.
	 */
	public byte getKeyByte()
	throws WiredTigerPackingException {
		return getKeyUnpacker().getByte();
	}

	/**
	 * Retrieve a byte array from the async_op's key.
	 *
	 * \param output The byte array where the returned value will be stored.
	 *	       The array should be large enough to store the entire
	 *	       data item, if not a truncated value will be returned.
	 */
	public void getKeyByteArray(byte[] output)
	throws WiredTigerPackingException {
		this.getKeyByteArray(output, 0, output.length);
	}

	/**
	 * Retrieve a byte array from the async_op's key.
	 *
	 * \param output The byte array where the returned value will be stored.
	 * \param off Offset into the destination buffer to start copying into.
	 * \param len The length should be large enough to store the entire
	 *	      data item, if not a truncated value will be returned.
	 */
	public void getKeyByteArray(byte[] output, int off, int len)
	throws WiredTigerPackingException {
		getKeyUnpacker().getByteArray(output, off, len);
	}

	/**
	 * Retrieve a byte array from the async_op's key.
	 *
	 * \return The requested value.
	 */
	public byte[] getKeyByteArray()
	throws WiredTigerPackingException {
		return getKeyUnpacker().getByteArray();
	}

	/**
	 * Retrieve an integer from the async_op's key.
	 *
	 * \return The requested value.
	 */
	public int getKeyInt()
	throws WiredTigerPackingException {
		return getKeyUnpacker().getInt();
	}

	/**
	 * Retrieve a long from the async_op's key.
	 *
	 * \return The requested value.
	 */
	public long getKeyLong()
	throws WiredTigerPackingException {
		return getKeyUnpacker().getLong();
	}

	/**
	 * Retrieve a record number from the async_op's key.
	 *
	 * \return The requested value.
	 */
	public long getKeyRecord()
	throws WiredTigerPackingException {
		return getKeyUnpacker().getRecord();
	}

	/**
	 * Retrieve a short integer from the async_op's key.
	 *
	 * \return The requested value.
	 */
	public short getKeyShort()
	throws WiredTigerPackingException {
		return getKeyUnpacker().getShort();
	}

	/**
	 * Retrieve a string from the async_op's key.
	 *
	 * \return The requested value.
	 */
	public String getKeyString()
	throws WiredTigerPackingException {
		return getKeyUnpacker().getString();
	}

	/**
	 * Retrieve a byte from the async_op's value.
	 *
	 * \return The requested value.
	 */
	public byte getValueByte()
	throws WiredTigerPackingException {
		return getValueUnpacker().getByte();
	}

	/**
	 * Retrieve a byte array from the async_op's value.
	 *
	 * \param output The byte array where the returned value will be stored.
	 *	       The array should be large enough to store the entire
	 *	       data item, if not a truncated value will be returned.
	 */
	public void getValueByteArray(byte[] output)
	throws WiredTigerPackingException {
		this.getValueByteArray(output, 0, output.length);
	}

	/**
	 * Retrieve a byte array from the async_op's value.
	 *
	 * \param output The byte array where the returned value will be stored.
	 * \param off Offset into the destination buffer to start copying into.
	 * \param len The length should be large enough to store the entire
	 *	      data item, if not a truncated value will be returned.
	 */
	public void getValueByteArray(byte[] output, int off, int len)
	throws WiredTigerPackingException {
		getValueUnpacker().getByteArray(output, off, len);
	}

	/**
	 * Retrieve a byte array from the async_op's value.
	 *
	 * \return The requested value.
	 */
	public byte[] getValueByteArray()
	throws WiredTigerPackingException {
		return getValueUnpacker().getByteArray();
	}

	/**
	 * Retrieve an integer from the async_op's value.
	 *
	 * \return The requested value.
	 */
	public int getValueInt()
	throws WiredTigerPackingException {
		return getValueUnpacker().getInt();
	}

	/**
	 * Retrieve a long from the async_op's value.
	 *
	 * \return The requested value.
	 */
	public long getValueLong()
	throws WiredTigerPackingException {
		return getValueUnpacker().getLong();
	}

	/**
	 * Retrieve a record number from the async_op's value.
	 *
	 * \return The requested value.
	 */
	public long getValueRecord()
	throws WiredTigerPackingException {
		return getValueUnpacker().getRecord();
	}

	/**
	 * Retrieve a short integer from the async_op's value.
	 *
	 * \return The requested value.
	 */
	public short getValueShort()
	throws WiredTigerPackingException {
		return getValueUnpacker().getShort();
	}

	/**
	 * Retrieve a string from the async_op's value.
	 *
	 * \return The requested value.
	 */
	public String getValueString()
	throws WiredTigerPackingException {
		return getValueUnpacker().getString();
	}

	/**
	 * Insert the async_op's current key/value into the table.
	 *
	 * \return The status of the operation.
	 */
	public int insert()
	throws WiredTigerException {
		byte[] key = keyPacker.getValue();
		byte[] value = valuePacker.getValue();
		keyPacker.reset();
		valuePacker.reset();
		return insert_wrap(key, value);
	}

	/**
	 * Update the async_op's current key/value into the table.
	 *
	 * \return The status of the operation.
	 */
	public int update()
	throws WiredTigerException {
		byte[] key = keyPacker.getValue();
		byte[] value = valuePacker.getValue();
		keyPacker.reset();
		valuePacker.reset();
		return update_wrap(key, value);
	}

	/**
	 * Remove the async_op's current key/value into the table.
	 *
	 * \return The status of the operation.
	 */
	public int remove()
	throws WiredTigerException {
		byte[] key = keyPacker.getValue();
		keyPacker.reset();
		return remove_wrap(key);
	}

	/**
	 * Search for an item in the table.
	 *
	 * \return The result of the comparison.
	 */
	public int search()
	throws WiredTigerException {
		int ret = search_wrap(keyPacker.getValue());
		keyPacker.reset();
		valuePacker.reset();
		return ret;
	}

	/**
	 * Set up the key unpacker or return previously cached value.
	 *
	 * \return The key unpacker.
	 */
	private PackInputStream getKeyUnpacker()
	throws WiredTigerPackingException {
		if (keyUnpacker == null)
			keyUnpacker =
			    new PackInputStream(keyFormat, get_key_wrap(),
			    javaRaw);
		return keyUnpacker;
	}

	/**
	 * Set up the value unpacker or return previously cached value.
	 *
	 * \return The value unpacker.
	 */
	private PackInputStream getValueUnpacker()
	throws WiredTigerPackingException {
		if (valueUnpacker == null)
			valueUnpacker =
			    new PackInputStream(valueFormat, get_value_wrap(),
			    javaRaw);
		return valueUnpacker;
	}


  public Connection getConnection() {
    long cPtr = wiredtigerJNI.AsyncOp_connection_get(swigCPtr, this);
    return (cPtr == 0) ? null : new Connection(cPtr, false);
  }

  protected String getKey_format() {
    return wiredtigerJNI.AsyncOp_key_format_get(swigCPtr, this);
  }

  protected String getValue_format() {
    return wiredtigerJNI.AsyncOp_value_format_get(swigCPtr, this);
  }

  
  /**
   * @copydoc WT_ASYNC_OP::compact
   */
  public  int compact() throws com.wiredtiger.db.WiredTigerException {
    return wiredtigerJNI.AsyncOp_compact(swigCPtr, this);
  }

  
  /**
   * @copydoc WT_ASYNC_OP::get_type
   */
  public  AsyncOpType getType() {
    return AsyncOpType.swigToEnum(wiredtigerJNI.AsyncOp_getType(swigCPtr, this));
  }

  protected byte[] get_key_wrap() {
	return (wiredtigerJNI.AsyncOp_get_key_wrap(swigCPtr, this));
}

  protected byte[] get_value_wrap() {
	return (wiredtigerJNI.AsyncOp_get_value_wrap(swigCPtr, this));
}

  protected int insert_wrap(byte[] k, byte[] v) {
    return wiredtigerJNI.AsyncOp_insert_wrap(swigCPtr, this, k, v);
  }

  protected int remove_wrap(byte[] k) {
    return wiredtigerJNI.AsyncOp_remove_wrap(swigCPtr, this, k);
  }

  protected int search_wrap(byte[] k) {
    return wiredtigerJNI.AsyncOp_search_wrap(swigCPtr, this, k);
  }

  protected int update_wrap(byte[] k, byte[] v) {
    return wiredtigerJNI.AsyncOp_update_wrap(swigCPtr, this, k, v);
  }

  protected boolean _java_raw() {
    return wiredtigerJNI.AsyncOp__java_raw(swigCPtr, this);
  }

  protected int _java_init(Object jasyncop) {
    return wiredtigerJNI.AsyncOp__java_init(swigCPtr, this, jasyncop);
  }

  
  /**
   * @copydoc WT_ASYNC_OP::get_id
   */
  public  int getId() throws com.wiredtiger.db.WiredTigerException {
    return wiredtigerJNI.AsyncOp_getId(swigCPtr, this);
  }

}
