/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.macro;

import java.util.Enumeration;
import java.util.Vector;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagText;
import rene.util.xml.XmlTree;
import rene.util.xml.XmlWriter;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.objects.ConstructionObject;

public class Macro
extends Construction
implements Cloneable {
    public String Name;
    public String[] Prompts;
    public ConstructionObject[] Params;
    public String[] PromptFor = new String[0];
    public String[] PromptName = new String[0];
    public String[] LastParams;
    public boolean[] Fixed;
    boolean Protected = false;
    boolean HideDuplicates = true;

    public Macro(ZirkelCanvas zirkelCanvas, String string, String string2, String[] stringArray) {
        this.Name = string;
        this.Comment = string2;
        this.Prompts = stringArray;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String string) {
        this.Name = string;
    }

    public String getComment() {
        return this.Comment;
    }

    public String[] getPrompts() {
        return this.Prompts;
    }

    public void setParams(ConstructionObject[] constructionObjectArray) {
        this.Params = constructionObjectArray;
    }

    public ConstructionObject[] getParams() {
        return this.Params;
    }

    public void initLast() {
        this.LastParams = new String[this.Params.length];
    }

    public void setLast(String string, int n) {
        try {
            this.LastParams[n] = string;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLast(int n) {
        if (this.LastParams != null && this.LastParams[n] != null) {
            return this.LastParams[n];
        }
        return "";
    }

    public void setPromptFor(String[] stringArray) {
        this.PromptFor = stringArray;
        this.PromptName = new String[this.PromptFor.length];
        for (int i = 0; i < this.PromptFor.length; ++i) {
            this.PromptName[i] = this.PromptFor[i];
        }
    }

    public void setPromptName(int n, String string) {
        this.PromptName[n] = string;
    }

    public boolean promptFor(String string) {
        return this.getPromptFor(string) >= 0;
    }

    public int getPromptFor(String string) {
        for (int i = 0; i < this.PromptFor.length; ++i) {
            if (!this.PromptFor[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getPromptName(String string) {
        for (int i = 0; i < this.PromptFor.length; ++i) {
            if (!this.PromptFor[i].equals(string)) continue;
            return this.PromptName[i];
        }
        return "";
    }

    public int countPrompts() {
        return this.PromptFor.length;
    }

    public void saveMacro(XmlWriter xmlWriter) {
        int n;
        xmlWriter.startTagStart("Macro");
        xmlWriter.printArg("Name", this.Name);
        if (!this.HideDuplicates) {
            xmlWriter.printArg("showduplicates", "true");
        }
        xmlWriter.startTagEndNewLine();
        for (n = 0; n < this.Params.length; ++n) {
            xmlWriter.startTagStart("Parameter");
            xmlWriter.printArg("name", this.Params[n].getName());
            if (this.Fixed != null && this.Fixed[n] && this.LastParams != null && this.LastParams[n] != null) {
                xmlWriter.printArg("fixed", this.LastParams[n]);
            }
            xmlWriter.startTagEnd();
            xmlWriter.print(this.Prompts[n]);
            xmlWriter.endTagNewLine("Parameter");
        }
        if (!this.getComment().equals("")) {
            xmlWriter.startTagNewLine("Comment");
            xmlWriter.printParagraphs(this.getComment(), 60);
            xmlWriter.endTagNewLine("Comment");
        }
        xmlWriter.startTagNewLine("Objects");
        this.save(xmlWriter);
        xmlWriter.endTagNewLine("Objects");
        if (this.PromptFor.length > 0) {
            xmlWriter.startTagStart("PromptFor");
            for (n = 0; n < this.PromptFor.length; ++n) {
                xmlWriter.printArg("object" + n, this.PromptFor[n]);
                xmlWriter.printArg("prompt" + n, this.PromptName[n]);
            }
            xmlWriter.finishTagNewLine();
        }
        xmlWriter.endTagNewLine("Macro");
    }

    public Macro(ZirkelCanvas zirkelCanvas, XmlTree xmlTree) throws ConstructionException {
        int n;
        Object object;
        Object object2;
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.name().equals("Macro")) {
            throw new ConstructionException("No macro!");
        }
        if (!xmlTag.hasParam("Name")) {
            throw new ConstructionException("Name missing!");
        }
        this.Name = xmlTag.getValue("Name");
        if (xmlTag.hasParam("showduplicates")) {
            this.HideDuplicates = false;
        }
        Enumeration enumeration = xmlTree.getContent();
        while (enumeration.hasMoreElements()) {
            XmlTree xmlTree2 = (XmlTree)enumeration.nextElement();
            xmlTag = xmlTree2.getTag();
            if (xmlTag.name().equals("Objects")) {
                this.readConstruction(xmlTree2);
                break;
            }
            if (!xmlTag.name().equals("Comment")) continue;
            try {
                this.setComment(xmlTree2.parseComment());
            }
            catch (Exception exception) {
                throw new ConstructionException("Illegal Comment");
            }
        }
        int n2 = 0;
        enumeration = xmlTree.getContent();
        while (enumeration.hasMoreElements()) {
            int n3;
            XmlTree xmlTree3 = (XmlTree)enumeration.nextElement();
            xmlTag = xmlTree3.getTag();
            if (xmlTag.name().equals("Parameter")) {
                if (!xmlTag.hasParam("name")) {
                    throw new ConstructionException("Parameter name missing!");
                }
                ++n2;
                continue;
            }
            if (!xmlTag.name().equals("PromptFor")) continue;
            if (xmlTag.hasParam("object")) {
                object2 = new String[]{xmlTag.getValue("object")};
                this.setPromptFor((String[])object2);
                if (!xmlTag.hasParam("prompt")) continue;
                this.setPromptName(0, xmlTag.getValue("prompt"));
                continue;
            }
            int n4 = 0;
            while (xmlTag.hasParam("object" + n4)) {
                ++n4;
            }
            object = new String[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                object[n3] = xmlTag.getValue("object" + n3);
            }
            this.setPromptFor((String[])object);
            for (n3 = 0; n3 < n4; ++n3) {
                if (!xmlTag.hasParam("prompt" + n3)) continue;
                this.setPromptName(n3, xmlTag.getValue("prompt" + n3));
            }
        }
        this.Params = new ConstructionObject[n2];
        this.initLast();
        this.Prompts = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.Prompts[n] = "";
        }
        n = 0;
        enumeration = xmlTree.getContent();
        while (enumeration.hasMoreElements()) {
            object2 = (XmlTree)enumeration.nextElement();
            xmlTag = ((XmlTree)object2).getTag();
            if (!xmlTag.name().equals("Parameter")) continue;
            this.Params[n] = this.find(xmlTag.getValue("name"));
            if (this.Params[n] == null) {
                throw new ConstructionException("Illegal parameter " + xmlTag.getValue("name") + "!");
            }
            if (xmlTag.hasParam("fixed")) {
                if (this.Fixed == null) {
                    this.Fixed = new boolean[n2];
                    for (int i = 0; i < n2; ++i) {
                        this.Fixed[i] = false;
                    }
                }
                this.Fixed[n] = true;
                this.LastParams[n] = xmlTag.getValue("fixed");
            }
            object = ((XmlTree)object2).getContent();
            while (object.hasMoreElements()) {
                xmlTree = (XmlTree)object.nextElement();
                if (!(xmlTree.getTag() instanceof XmlTagText)) continue;
                this.Prompts[n] = ((XmlTagText)xmlTree.getTag()).getContent();
            }
            ++n;
        }
    }

    public Vector getTargets() {
        Vector<ConstructionObject> vector = new Vector<ConstructionObject>();
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isTarget()) continue;
            vector.addElement(constructionObject);
        }
        return vector;
    }

    public boolean hasFixed() {
        int n;
        for (n = 0; n < this.Prompts.length; ++n) {
            if (!this.Prompts[n].startsWith("=")) continue;
            return true;
        }
        if (this.Fixed == null) {
            return false;
        }
        for (n = 0; n < this.Fixed.length; ++n) {
            if (!this.Fixed[n]) continue;
            return true;
        }
        return false;
    }

    public boolean isFixed(int n) {
        if (this.Fixed == null) {
            return false;
        }
        return this.Fixed[n];
    }

    public void setFixed(int n, boolean bl) {
        if (this.Fixed == null) {
            return;
        }
        this.Fixed[n] = bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isProtected() {
        return this.Protected;
    }

    public void setProtected(boolean bl) {
        this.Protected = bl;
    }

    public boolean hideDuplicates() {
        return this.HideDuplicates;
    }

    public void hideDuplicates(boolean bl) {
        this.HideDuplicates = bl;
    }
}

