#ifndef INCLUDED_SURVIVAL_
#define INCLUDED_SURVIVAL_

// Tumor:
//     Survival:
//         #              value        spread      dist:
//         type:  a        .00004475   .000004392  Normal  
//         type:  b       1.85867      .0420       Normal
//         type:  c      - .271        .0101       Normal
//         type:  d       2.0167       .0366       Normal
//
//      # 4 columns per a..d parameter, according to table S4:
//      # lungX: X is the table S4 column index
//         lung0: a        .00143      .00095      Normal 
//         lung0: b       1.84559      .33748      Normal 
//         lung0: c       -.22794      .07823      Normal 
//         lung0: d       1.06799      .16226      Normal 
//         
//         lung1: a        .01530      .00381      Normal 
//         lung1: b       1.69434      .10979      Normal 
//         lung1: c       -.19358      .02105      Normal 
//         lung1: d        .66690      .03869      Normal 
//         
//         lung2: a        .78600      .29815      Normal 
//         lung2: b        .69791      .05425      Normal 
//         lung2: c        .0          .0          Normal 
//         lung2: d        .0          .0          Normal 
//         
//         lung3: a       1.25148      .32305      Normal 
//         lung3: b        .77852      .34149      Normal 
//         lung3: c        .0          .0          Normal 
//         lung3: d        .0          .0          Normal 
//

#include "../vsd/vsd.h"
#include "../probgroup/probgroup.h"

class Survival
{
        // d_vsdMatrix is a [][4] matrix. 
        // with BC simulations only row 0 is filled and used, and d_vsdRow is
        // set to 0, its default value. The member pointer 'd_cptVSDrow' 
        // performs no action (cals noop()).
        //
        // with LC simulations 4 rows are filled with, resp. the 
        // lung0 thru lung4 VSD values, and the member pointer d_cptVSDrow
        // computes d_vsdRow using S3, S4 and the tumor diameter (calls
        // cptVSDrow()). 
    VSDmatrix d_vsdMatrix;
                                    
    ProbGroup::Vector d_s3;
    size_t d_vsdRow = 0;

    void (Survival::*d_vary)(std::ostream &out);
    void (Survival::*d_write)(std::ostream &out) const;

    void (Survival::*d_cptVSDrow)(double diameter);

    static char const *s_lungColumn[4];           // cf. data.cc
    static char const *s_noColon[4];              // cf. data.cc

    public:
        Survival();

        bool metastatis() const;                                    // .f
        VSD const &operator[](size_t idx) const;                    // .f
                                        // determine random vsd-value(s)

        void setVSD(double diameter);   // with LC: cpt the row of  // .f
                                        // d_vsdMatrix to use 
                                        // with BC: noop.

        void vary(std::ostream &out);   // and write to 'out'       // .f
        void writeParameters(std::ostream &out) const;              // .f

    private:
        void cptVSDrow(double diameter);
        void noop(double diameter);   

        void loadS3();
        void loadS4();

        void lungParameters(std::ostream &out) const;
        void s3parameters(std::ostream &out) const;

        void varyBreast(std::ostream &out);   
        void varyLung(std::ostream &out);   

        void writeBreast(std::ostream &out) const;   
        void writeLung(std::ostream &out) const;   
};

#include "survival.f"

//        ProbGroup::Vector const &s3() const;                        // .f

#endif






