/*
   divmod-1.c from the execute part of the gcc torture tests.
 */

#include <testfwk.h>

#ifdef __SDCC
#pragma std_c99
#endif

div1 (signed char x)
{
  return x / -1;
}

div2 (signed short x)
{
  return x / -1;
}

div3 (signed char x, signed char y)
{
  return x / y;
}

div4 (signed short x, signed short y)
{
  return x / y;
}

mod1 (signed char x)
{
  return x % -1;
}

mod2 (signed short x)
{
  return x % -1;
}

mod3 (signed char x, signed char y)
{
  return x % y;
}

mod4 (signed short x, signed short y)
{
  return x % y;
}

#ifndef __SDCC_pdk14 // Lack of memory
#if !(defined (__SDCC_pdk15) && defined(__SDCC_STACK_AUTO)) // Lack of code memory
signed long
mod5 (signed long x, signed long y)
{
  return x % y;
}
     
unsigned long
mod6 (unsigned long x, unsigned long y)
{
  return x % y;
}
#endif
#endif
     
void
testTortureExecute (void)
{
  if (div1 (-(1 << 7)) != 1 << 7)
    ASSERT (0);
  if (div2 (-(1 << 15)) != 1 << 15)
    ASSERT (0);
  if (div3 (-(1 << 7), -1) != 1 << 7)
    ASSERT (0);
  if (div4 (-(1 << 15), -1) != 1 << 15)
    ASSERT (0);
  if (mod1 (-(1 << 7)) != 0)
    ASSERT (0);
  if (mod2 (-(1 << 15)) != 0)
    ASSERT (0);
  if (mod3 (-(1 << 7), -1) != 0)
    ASSERT (0);
  if (mod4 (-(1 << 15), -1) != 0)
    ASSERT (0);
#ifndef __SDCC_pdk14 // Lack of memory
#if !(defined (__SDCC_pdk15) && defined(__SDCC_STACK_AUTO)) // Lack of code memory
  if (mod5 (0x50000000, 2) != 0)
    ASSERT (0);
  if (mod6 (0x50000000, 2) != 0)
    ASSERT (0);
#endif
#endif
  
  return;
}
