# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, Generic, List, Optional, TypeVar
import warnings

from azure.core.exceptions import map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest

from ... import models

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class WorkspaceAclOperations:
    """WorkspaceAclOperations async operations.

    You should not instantiate directly this class, but create a Client instance that will create it for you and attach it as attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.synapse.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def get_access_control_info(
        self,
        workspace_name: str,
        artifact_name: Optional[str] = None,
        **kwargs
    ) -> "models.WorkspaceAccessControlResponse":
        """Get access control info.

        :param workspace_name: The name of the workspace to execute operations on.
        :type workspace_name: str
        :param artifact_name:
        :type artifact_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WorkspaceAccessControlResponse or the result of cls(response)
        :rtype: ~azure.synapse.models.WorkspaceAccessControlResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls: ClsType["models.WorkspaceAccessControlResponse"] = kwargs.pop('cls', None)
        error_map = kwargs.pop('error_map', {})

        _resource = models.GetAccessControlInfoRequest(artifact_name=artifact_name)
        api_version = "2019-11-01-preview"

        # Construct URL
        url = self.get_access_control_info.metadata['url']
        path_format_arguments = {
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str', skip_quote=True),
            'SynapseDnsSuffix': self._serialize.url("self._config.synapse_dns_suffix", self._config.synapse_dns_suffix, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters: Dict[str, Any] = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters: Dict[str, Any] = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json'

        # Construct body
        body_content = self._serialize.body(_resource, 'GetAccessControlInfoRequest')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.ErrorResponseException.from_response(response, self._deserialize)

        deserialized = self._deserialize('WorkspaceAccessControlResponse', pipeline_response)

        if cls:
          return cls(pipeline_response, deserialized, {})

        return deserialized
    get_access_control_info.metadata = {'url': '/getAccessControl'}

    async def set_workspace_administrators(
        self,
        workspace_name: str,
        administrators: Optional[List[str]] = None,
        **kwargs
    ) -> "models.WorkspaceAccessControlResponse":
        """Replace Admins of the Workspace.

        :param workspace_name: The name of the workspace to execute operations on.
        :type workspace_name: str
        :param administrators:
        :type administrators: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WorkspaceAccessControlResponse or the result of cls(response)
        :rtype: ~azure.synapse.models.WorkspaceAccessControlResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls: ClsType["models.WorkspaceAccessControlResponse"] = kwargs.pop('cls', None)
        error_map = kwargs.pop('error_map', {})

        _request = models.SetWorkspaceAdministratorsRequest(administrators=administrators)
        api_version = "2019-11-01-preview"

        # Construct URL
        url = self.set_workspace_administrators.metadata['url']
        path_format_arguments = {
            'workspaceName': self._serialize.url("workspace_name", workspace_name, 'str', skip_quote=True),
            'SynapseDnsSuffix': self._serialize.url("self._config.synapse_dns_suffix", self._config.synapse_dns_suffix, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters: Dict[str, Any] = {}
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters: Dict[str, Any] = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json'

        # Construct body
        body_content = self._serialize.body(_request, 'SetWorkspaceAdministratorsRequest')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.ErrorResponseException.from_response(response, self._deserialize)

        deserialized = self._deserialize('WorkspaceAccessControlResponse', pipeline_response)

        if cls:
          return cls(pipeline_response, deserialized, {})

        return deserialized
    set_workspace_administrators.metadata = {'url': '/setWorkspaceAdmins'}
