# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CreateParentGroupInfo(Model):
    """(Optional) The ID of the parent management group used during creation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: The fully qualified ID for the parent management group.  For
     example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
    :type id: str
    :ivar name: The name of the parent management group
    :vartype name: str
    :ivar display_name: The friendly name of the parent management group.
    :vartype display_name: str
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CreateParentGroupInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.display_name = None
