#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright (c) 2021 Pyresample developers
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU Lesser General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
# details.
#
# You should have received a copy of the GNU Lesser General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Definitions for geographic regions."""

from typing import Union

from .area import AreaDefinition, DynamicAreaDefinition  # noqa
from .base import BaseDefinition  # noqa
from .swath import CoordinateDefinition, SwathDefinition  # noqa

StaticGeometry = Union[SwathDefinition, CoordinateDefinition, AreaDefinition]
