/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import weka.core.Memory;
import weka.core.Utils;
import weka.gui.Messages;
import weka.gui.visualize.VisualizeUtils;

public class MemoryUsagePanel
extends JPanel {
    private static final long serialVersionUID = -4812319791687471721L;
    protected static String PROPERTY_FILE = "weka/gui/MemoryUsage.props";
    protected static Properties PROPERTIES;
    protected Vector<Double> m_History;
    protected Memory m_Memory = new Memory();
    protected MemoryMonitor m_Monitor;
    protected JButton m_ButtonGC;
    protected Vector<Double> m_Percentages;
    protected Hashtable<Double, Color> m_Colors;
    protected Color m_DefaultColor;
    protected Color m_BackgroundColor;
    protected Point m_FrameLocation;

    public MemoryUsagePanel() {
        int interval;
        int left;
        int top;
        int width;
        int height;
        this.m_History = new Vector();
        this.m_Percentages = new Vector();
        this.m_Colors = new Hashtable();
        this.m_BackgroundColor = this.parseColor("BackgroundColor", Color.WHITE);
        this.m_DefaultColor = this.parseColor("DefaultColor", Color.GREEN);
        String[] percs = PROPERTIES.getProperty("Percentages", "70,80,90").split(",");
        for (int i = 0; i < percs.length; ++i) {
            if (PROPERTIES.getProperty(percs[i]) != null) {
                double perc;
                try {
                    perc = Double.parseDouble(percs[i]);
                }
                catch (Exception e) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("MemoryUsagePanel_Error_First")).append(percs[i]);
                    Messages.getInstance();
                    System.err.println(stringBuilder2.append(Messages.getString("MemoryUsagePanel_Error_Second")).toString());
                    continue;
                }
                Color color = this.parseColor(percs[i], null);
                if (color == null) continue;
                this.m_Percentages.add(perc);
                this.m_Colors.put(perc, color);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder3 = stringBuilder.append(Messages.getString("MemoryUsagePanel_Error_Third")).append(percs[i]);
            Messages.getInstance();
            System.err.println(stringBuilder3.append(Messages.getString("MemoryUsagePanel_Error_Fourth")).toString());
        }
        Collections.sort(this.m_Percentages);
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "East");
        Messages.getInstance();
        this.m_ButtonGC = new JButton(Messages.getString("MemoryUsagePanel_ButtonGC_JButton_Text"));
        Messages.getInstance();
        this.m_ButtonGC.setToolTipText(Messages.getString("MemoryUsagePanel_ButtonGC_SetToolTipText_Text"));
        this.m_ButtonGC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.gc();
            }
        });
        panel.add((Component)this.m_ButtonGC, "North");
        try {
            height = Integer.parseInt(PROPERTIES.getProperty("Height", "" + (int)this.m_ButtonGC.getPreferredSize().getHeight()));
            width = Integer.parseInt(PROPERTIES.getProperty("Width", "400"));
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("MemoryUsagePanel_Error_Fifth")).append(e).toString());
            height = (int)this.m_ButtonGC.getPreferredSize().getHeight();
            width = 400;
        }
        this.setPreferredSize(new Dimension(width, height));
        try {
            top = Integer.parseInt(PROPERTIES.getProperty("Top", "0"));
            left = Integer.parseInt(PROPERTIES.getProperty("Left", "0"));
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("MemoryUsagePanel_Error_Sixth")).append(e).toString());
            top = 0;
            left = 0;
        }
        this.m_FrameLocation = new Point(left, top);
        try {
            interval = Integer.parseInt(PROPERTIES.getProperty("Interval", "1000"));
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("MemoryUsagePanel_Error_Seventh")).append(e).toString());
            interval = 1000;
        }
        this.m_Monitor = new MemoryMonitor();
        this.m_Monitor.setInterval(interval);
        this.m_Monitor.setPriority(10);
        this.m_Monitor.start();
    }

    protected Color parseColor(String prop, Color defValue) {
        Color result = defValue;
        try {
            String colorStr = PROPERTIES.getProperty(prop);
            Color color = VisualizeUtils.processColour(colorStr, result);
            if (color == null) {
                throw new Exception(colorStr);
            }
            result = color;
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("MemoryUsagePanel_Error_Eighth")).append(e.getMessage());
            Messages.getInstance();
            System.err.println(stringBuilder2.append(Messages.getString("MemoryUsagePanel_Error_Nineth")).toString());
        }
        return result;
    }

    public boolean isMonitoring() {
        return this.m_Monitor.isMonitoring();
    }

    public void stopMonitoring() {
        this.m_Monitor.stopMonitoring();
    }

    public Point getFrameLocation() {
        return this.m_FrameLocation;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.m_BackgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        double scale = (double)this.getHeight() / 100.0;
        for (int i = 0; i < this.m_History.size(); ++i) {
            double perc = this.m_History.get(i);
            Color color = this.m_DefaultColor;
            for (int n = this.m_Percentages.size() - 1; n >= 0; --n) {
                if (!(perc >= this.m_Percentages.get(n))) continue;
                color = this.m_Colors.get(this.m_Percentages.get(n));
                break;
            }
            g.setColor(color);
            int len = (int)Math.round(perc * scale);
            g.drawLine(i, this.getHeight() - 1, i, this.getHeight() - len);
        }
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            Enumeration<?> keys = PROPERTIES.propertyNames();
            if (!keys.hasMoreElements()) {
                Messages.getInstance();
                throw new Exception(Messages.getString("MemoryUsagePanel_Exception_Text"));
            }
        }
        catch (Exception ex) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("MemoryUsagePanel_Exception_JOptionPaneShowMessageDialog_Text_First")).append(System.getProperties().getProperty("user.home"));
            Messages.getInstance();
            String string = stringBuilder2.append(Messages.getString("MemoryUsagePanel_Exception_JOptionPaneShowMessageDialog_Text_Third")).toString();
            Messages.getInstance();
            JOptionPane.showMessageDialog(null, string, Messages.getString("MemoryUsagePanel_Exception_JOptionPaneShowMessageDialog_Text_Fourth"), 0);
        }
    }

    protected class MemoryMonitor
    extends Thread {
        protected int m_Interval;
        protected boolean m_Monitoring;

        public MemoryMonitor() {
            this.setInterval(1000);
        }

        public int getInterval() {
            return this.m_Interval;
        }

        public void setInterval(int value) {
            this.m_Interval = value;
        }

        public boolean isMonitoring() {
            return this.m_Monitoring;
        }

        public void stopMonitoring() {
            this.m_Monitoring = false;
        }

        public void run() {
            this.m_Monitoring = true;
            while (this.m_Monitoring) {
                try {
                    Thread.sleep(this.m_Interval);
                    if (!this.m_Monitoring) continue;
                    Runnable doUpdate = new Runnable(){

                        public void run() {
                            MemoryMonitor.this.update();
                        }
                    };
                    SwingUtilities.invokeLater(doUpdate);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }

        protected void update() {
            double perc = (double)MemoryUsagePanel.this.m_Memory.getCurrent() / (double)MemoryUsagePanel.this.m_Memory.getMax();
            perc = Math.round(perc * 1000.0) / 10L;
            StringBuilder stringBuilder = new StringBuilder().append("").append(perc);
            Messages.getInstance();
            MemoryUsagePanel.this.setToolTipText(stringBuilder.append(Messages.getString("MemoryUsagePanel_MemoryMonitor_Update_SetToolTipText_Text")).toString());
            MemoryUsagePanel.this.m_History.insertElementAt(perc, 0);
            Dimension size = MemoryUsagePanel.this.getSize();
            while ((double)MemoryUsagePanel.this.m_History.size() > size.getWidth()) {
                MemoryUsagePanel.this.m_History.remove(MemoryUsagePanel.this.m_History.size() - 1);
            }
            MemoryUsagePanel.this.repaint();
        }
    }
}

