---
title: PICOTOOL-SAVE
section: 1
header: User Commands
---
# NAME

picotool\-save \- Save the program / memory stored in flash on the device to a file\.

# SYNOPSIS

picotool save \[\-p\] \[\-v\] \[\-\-family \<family\_id\>\] \<filename\> \[\-t \<type\>\] \[device\-selection\]

picotool save \-a \[\-v\] \[\-\-family \<family\_id\>\] \<filename\> \[\-t \<type\>\] \[device\-selection\]

picotool save \-r \<from\> \<to\> \[\-v\] \[\-\-family \<family\_id\>\] \<filename\> \[\-t \<type\>\] \[device\-selection\]


# OPTIONS

Selection of data to save

**\-p**, **\-\-program**
: Save the installed program only\. This is the default

**\-a**, **\-\-all**
: Save all of flash memory

**\-r**, **\-\-range**
: Save a range of memory\. Note that UF2s always store complete 256byte\-aligned blocks of 256 bytes, and the range is expandedaccordingly

\<*from*\>
: The lower address bound in hex

\<*to*\>
: The upper address bound in hex

Other

**\-v**, **\-\-verify**
: Verify the data was saved correctly

**\-\-family**
: Specify the family ID to save the file as

\<*family\_id*\>
: family ID to save file as

File to save to

\<*filename*\>
: The file name

**\-t** \<*type*\>
: Specify file type \(uf2 \| elf \| bin\) explicitly, ignoring fileextension

Source device selection

**\-\-bus** \<*bus*\>
: Filter devices by USB bus number

**\-\-address** \<*addr*\>
: Filter devices by USB device address

**\-\-vid** \<*vid*\>
: Filter by vendor id

**\-\-pid** \<*pid*\>
: Filter by product id

**\-\-ser** \<*ser*\>
: Filter by serial number

**\-f**, **\-\-force**
: Force a device not in BOOTSEL mode but running compatible code toreset so the command can be executed\. After executing the command\(unless the command itself is a 'reboot'\) the device will berebooted back to application mode

**\-F**, **\-\-force\-no\-reboot**
: Force a device not in BOOTSEL mode but running compatible code toreset so the command can be executed\. After executing the command\(unless the command itself is a 'reboot'\) the device will be leftconnected and accessible to picotool, but without the USB drivemounted

