iem - collection of utility libraries for Pure Data (Pd)
========================================================

This is a collection of (unrelated) external libraries for Pd,
developed at the Institute of Electronic Music and Acoustics (iem) at the
University of Music and Performing Arts Graz, Austria.

# LICENSE
Each library comes with their own license, but all are released under an open
source license (GPL2+, BSD-3).

# CONTENTS

## Pd libraries

### iem_adaptfilt
adaptive filtering

https://git.iem.at/pd/iem_adaptfilt

### iem_dp
double precision

https://git.iem.at/pd/iem_dp

### iem_roomsim
room simulation

https://git.iem.at/pd/iem_roomsim

### iem_spec2
optimized objects for spectral processing

https://git.iem.at/pd/iem_spec2

### iem_tab
table maths

https://git.iem.at/pd/iem_tab

## Pd GUI plugins

### kiosk-plugin
run Pure Data in kiosk mode

https://git.iem.at/pd-gui/kiosk-plugin

### patch2svg-plugin
save patches as SVG 

https://git.iem.at/pd-gui/patch2svg-plugin

### tclprompt-plugin
pd-gui plugin that (re)adds a wee tcl-prompt to the Pd-console

https://git.iem.at/pd-gui/tclprompt-plugin

### punish/triggerize-plugin
pd-gui plugin that helps avoiding fan-outs by inserting [trigger] as appropriate.

https://git.iem.at/pd-gui/punish

### punish/patcherize-plugin
pd-gui plugin that helps refactoring code into abstraction/subpatches.

https://git.iem.at/pd-gui/punish
