// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type CreateNetworkAclRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* 私有网络id  */
    VpcId string `json:"vpcId"`

    /* networkAcl名称  */
    NetworkAclName string `json:"networkAclName"`

    /* 描述,允许输入UTF-8编码下的全部字符，不超过256字符 (Optional) */
    Description *string `json:"description"`
}

/*
 * param regionId: Region ID (Required)
 * param vpcId: 私有网络id (Required)
 * param networkAclName: networkAcl名称 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateNetworkAclRequest(
    regionId string,
    vpcId string,
    networkAclName string,
) *CreateNetworkAclRequest {

	return &CreateNetworkAclRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/networkAcls/",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        VpcId: vpcId,
        NetworkAclName: networkAclName,
	}
}

/*
 * param regionId: Region ID (Required)
 * param vpcId: 私有网络id (Required)
 * param networkAclName: networkAcl名称 (Required)
 * param description: 描述,允许输入UTF-8编码下的全部字符，不超过256字符 (Optional)
 */
func NewCreateNetworkAclRequestWithAllParams(
    regionId string,
    vpcId string,
    networkAclName string,
    description *string,
) *CreateNetworkAclRequest {

    return &CreateNetworkAclRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkAcls/",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        VpcId: vpcId,
        NetworkAclName: networkAclName,
        Description: description,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateNetworkAclRequestWithoutParam() *CreateNetworkAclRequest {

    return &CreateNetworkAclRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkAcls/",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *CreateNetworkAclRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param vpcId: 私有网络id(Required) */
func (r *CreateNetworkAclRequest) SetVpcId(vpcId string) {
    r.VpcId = vpcId
}

/* param networkAclName: networkAcl名称(Required) */
func (r *CreateNetworkAclRequest) SetNetworkAclName(networkAclName string) {
    r.NetworkAclName = networkAclName
}

/* param description: 描述,允许输入UTF-8编码下的全部字符，不超过256字符(Optional) */
func (r *CreateNetworkAclRequest) SetDescription(description string) {
    r.Description = &description
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateNetworkAclRequest) GetRegionId() string {
    return r.RegionId
}

type CreateNetworkAclResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CreateNetworkAclResult `json:"result"`
}

type CreateNetworkAclResult struct {
    NetworkAclId string `json:"networkAclId"`
}