Minutes from 38th OpenVDB TSC meeting, January 16th, 2020, (GMT)

Attendees: *Nick* A., *Dan* B., *Jeff* L., *Ken* M.

Additional Attendees: Bruce Chernia (Intel), Nathan Walster (Framestore),
Manuel Gamito (Framestore), Mark Elendt (SideFX), Daniel Lee (SideFX)

Regrets: *Peter* C.

Agenda:

1) Confirm quorum
2) Secretary
3) Discussion on per-node-meta-data
4) Update on MRes from Bifrost
5) Google Summer Of Code
6) Faster tree-merge based on the recently added addChild methods.
7) Next meeting

1) Quorum was confirmed.

2) Secretary was Nick Avramoussis

3) Background: Various studios are using (or want to use) OpenVDB's data
structure for custom rendering of volumes. From previous discussions with
Framestore, the TSC understands that some of the statistical data that's needed
from VDBs (min/max/average etc) can be cumbersome to compute and store. The TSC
has been discussing ways in which the leaf nodes of VDBs could be used to store
additional 'metadata'. The aim was to gather a better understanding of the use
case and whether these paths could align.

The particular rendering technique being discussed uses ray tracking and
requires sampling collision distances withing the volume. These samples further
need to be aware of the localised minimum and maximum values. This localised
region is typically the size of a VDB leaf nodes with a given filter parameter.
This means that reductions can map well to a leaf node, but there is no way to
store this value alongside the node itself (in the same volume). To solve,
additional minimum and maximum volumes are stored alongside the source
(surface/density) volume. These extra volumes are computed on write of the final
source volume and hold tiled extrema representations of the source. That is,
each leaf node of the source grid corresponds to a tile value in each minimum
and maximum grid. There can be high computation expense necessary to compute
these volumes depending on the filter parameters, which can be further
influenced by velocity (for motion blur). Additionally, users are able to modify
the source grids final values at render time using AX, requiring statistics to
be recomputed. An ideal work-flow would involve values not being recomputed in
areas where they don't need to be, with the ability to keep them in sync with
the source grid using some sort of native VDB data structure. The challenge with
this synchronisation is ensuring that other applications know when this data
needs to be regenerated, however the implementations in most of the scenarios
being discussed are completely custom. Custom tree types are also being
leveraged, which would make an AX or native storage solution potentially more
complex. It was noted that these custom types may not be necessary and could
potentially be dropped in favour of standard vector types. Conclusion:

 - It would be useful to have faster and more general reduction tools in VDB to
   compute hierarchal values, with more general approaches allowing users to
   specify their own filter/reduction requirements. An initial simple example
   could include new header functionality which takes a VDB and returns
   tiled/consolidated leaf level values as a new tree.

 - It would be possible to extend AX to support such reductions. Controls to
   choose tree level iteration and coordinate lookups would be necessary.

 - Storing blind data at the leaf node level would provide a native solution for
   'linking' custom statistics to their corresponding locations. This would
   avoid having sidecar files/vdbs to hold this extra data. VDB's LOD structure
   was also mentioned as a way of providing a more closely coupled set of grids
   (also see additional notes). The general consensus was that a more specific
   solution for customizable reduction may be easier to begin with.

Jeff to look at Mantras implementation of extrema values and feedback. Dan to
put together a Google doc with ideas.

4) Update on MRes from Bifrost

Ken continues to be in contact with Autodesk who remain committed to the MRes
discussion. Ken to implement a simple MRes example provided by Micheal Bang
(Autodesk) in VDB's LOD grid structure and share it with Autodesk to help
compare and demonstrate the pros of the MRes structure.

5) Google Summer Of Code

Dan to put together a Google doc on project ideas.

6) ~Time

Additional notes:

General consensus that a more extensive (better than just a vector of grids)
native way to 'link' or group VDBs together would be extremely useful. In
addition to grouping statistical data, a common scenario that comes up in
simulations is linking collision SDFs to their collision velocity fields. It
becomes difficult on read of a VDB file to infer this link without metadata or
relying on naming conventions. Nick to create a ticket describing the problem.

8) Next meeting

January 23th 2020. 2pm-3pm EST (GMT-5).
