/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.tuckey.web.filters.urlrewrite.BackReferenceReplacer;
import org.tuckey.web.filters.urlrewrite.ConditionMatch;
import org.tuckey.web.filters.urlrewrite.VariableReplacer;
import org.tuckey.web.filters.urlrewrite.utils.Log;
import org.tuckey.web.filters.urlrewrite.utils.NumberUtils;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class SetAttribute {
    private static Log log = Log.getLog(class$org$tuckey$web$filters$urlrewrite$SetAttribute == null ? (class$org$tuckey$web$filters$urlrewrite$SetAttribute = SetAttribute.class$("org.tuckey.web.filters.urlrewrite.SetAttribute")) : class$org$tuckey$web$filters$urlrewrite$SetAttribute);
    private boolean initialised = false;
    private boolean valid = false;
    private String error = null;
    private short type;
    private String name;
    private String value;
    private int numericValue;
    private Locale locale;
    private Cookie cookie;
    private static final short SET_TYPE_REQUEST = 0;
    private static final short SET_TYPE_SESSION = 1;
    private static final short SET_TYPE_RESPONSE_HEADER = 2;
    private static final short SET_TYPE_COOKIE = 3;
    private static final short SET_TYPE_CONTENT_TYPE = 4;
    private static final short SET_TYPE_CHARSET = 5;
    private static final short SET_TYPE_LOCALE = 6;
    private static final short SET_TYPE_STAUS = 7;
    private boolean valueContainsVariable = false;
    private boolean valueContainsBackRef = false;
    private static Pattern replacementVarPattern = Pattern.compile("(?<!\\\\)\\$([0-9])");
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$SetAttribute;

    public String getType() {
        if (this.type == 2) {
            return "response-header";
        }
        if (this.type == 1) {
            return "session";
        }
        if (this.type == 3) {
            return "cookie";
        }
        if (this.type == 4) {
            return "content-type";
        }
        if (this.type == 5) {
            return "charset";
        }
        if (this.type == 6) {
            return "locale";
        }
        if (this.type == 7) {
            return "status";
        }
        return "request";
    }

    public void setType(String typeStr) {
        if ("response-header".equals(typeStr)) {
            this.type = (short)2;
        } else if ("session".equals(typeStr)) {
            this.type = 1;
        } else if ("cookie".equals(typeStr)) {
            this.type = (short)3;
        } else if ("content-type".equals(typeStr)) {
            this.type = (short)4;
        } else if ("charset".equals(typeStr)) {
            this.type = (short)5;
        } else if ("locale".equals(typeStr)) {
            this.type = (short)6;
        } else if ("status".equals(typeStr)) {
            this.type = (short)7;
        } else if ("request".equals(typeStr) || StringUtils.isBlank(typeStr)) {
            this.type = 0;
        } else {
            this.setError("type (" + typeStr + ") is not valid");
        }
    }

    private void setError(String s) {
        log.error("set " + this.getDisplayName() + " had error: " + s);
        this.error = s;
    }

    public String getError() {
        return this.error;
    }

    public String getDisplayName() {
        return "Set " + this.getType() + " " + this.name + " " + this.value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void execute(HttpServletRequest hsRequest, HttpServletResponse hsResponse) {
        this.execute(null, null, hsRequest, hsResponse);
    }

    public void execute(ConditionMatch lastConditionMatch, Matcher toMatcher, HttpServletRequest hsRequest, HttpServletResponse hsResponse) {
        Matcher replacementVarMatcher;
        if (log.isDebugEnabled()) {
            log.debug("set " + this.getDisplayName() + " called");
        }
        if (!this.valid) {
            log.debug("not valid, skipping");
            return;
        }
        if (!this.initialised) {
            log.debug("not initialised, skipping");
            return;
        }
        String value = this.value;
        if (this.valueContainsBackRef) {
            value = BackReferenceReplacer.replace(lastConditionMatch, value);
        }
        if (this.valueContainsVariable) {
            value = VariableReplacer.replace(value, hsRequest);
        }
        if (toMatcher != null && (replacementVarMatcher = replacementVarPattern.matcher(value)).find()) {
            value = toMatcher.replaceAll(value);
        }
        if (this.type == 0) {
            log.debug("setting request attrib");
            hsRequest.setAttribute(this.name, (Object)value);
        } else if (this.type == 1) {
            log.debug("setting session attrib");
            HttpSession session = hsRequest.getSession(true);
            if (session == null) {
                log.warn("could not create a new session for a request");
            } else {
                session.setAttribute(this.name, (Object)value);
            }
        } else if (this.type == 2) {
            log.debug("setting response header");
            hsResponse.addHeader(this.name, value);
        } else if (this.type == 7) {
            log.debug("setting status");
            hsResponse.setStatus(this.numericValue);
        } else if (this.type == 3) {
            log.debug("setting status");
            hsResponse.addCookie(this.cookie);
        } else if (this.type == 4) {
            log.debug("setting content type");
            hsResponse.setContentType(value);
        } else if (this.type == 5) {
            log.debug("setting charset");
            hsResponse.setCharacterEncoding(value);
        } else if (this.type == 6) {
            log.debug("setting charset");
            hsResponse.setLocale(this.locale);
        } else {
            log.warn("unknown type" + this.type);
        }
    }

    public boolean initialise() {
        this.initialised = true;
        if (this.value != null) {
            if (BackReferenceReplacer.containsBackRef(this.value)) {
                this.valueContainsBackRef = true;
            }
            if (VariableReplacer.containsVariable(this.value)) {
                this.valueContainsVariable = true;
            }
        }
        if (this.type == 7) {
            this.initNumericValue();
        } else if (this.type == 6) {
            this.locale = null;
            if (this.value == null) {
                this.setError("Locale is not valid because value is null");
            } else if (this.value.matches("[a-zA-Z][a-zA-Z]")) {
                this.locale = new Locale(this.value);
            } else if (this.value.matches("[a-zA-Z][a-zA-Z]-[a-zA-Z][a-zA-Z]")) {
                this.locale = new Locale(this.value.substring(1, 2), this.value.substring(2, 4));
            } else if (this.value.matches("[a-zA-Z][a-zA-Z]-[a-zA-Z][a-zA-Z]-.*")) {
                this.locale = new Locale(this.value.substring(1, 2), this.value.substring(4, 5), this.value.substring(6, this.value.length()));
            } else {
                this.setError("Locale " + this.value + " is not valid (valid locales are, zh, zh-CN, zh-CN-rural)");
            }
        } else if (this.type == 3) {
            this.cookie = null;
            if (this.value != null && this.name != null) {
                if (this.value.indexOf(":") != -1) {
                    String[] items = this.value.split(":");
                    this.cookie = new Cookie(this.name, items[0]);
                    if (items.length > 1) {
                        this.cookie.setDomain(items[1]);
                    }
                    if (items.length > 2) {
                        this.cookie.setMaxAge(NumberUtils.stringToInt(items[2]));
                    }
                    if (items.length > 3) {
                        this.cookie.setPath(items[3]);
                    }
                } else {
                    this.cookie = new Cookie(this.name, this.value);
                }
            } else {
                this.setError("cookie must have a name and a value");
            }
        }
        if (this.error == null) {
            this.valid = true;
        }
        return this.valid;
    }

    private void initNumericValue() {
        if (this.numericValue == 0) {
            this.numericValue = NumberUtils.stringToInt(StringUtils.trim(this.value));
            if (this.numericValue == 0 && !"0".equals(this.value)) {
                this.setError("Value " + this.value + " is not a valid number (tried to cast to java type long)");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

