/*
   linuxinfo_loongarch.c

   Copyright (C) 2023 JiaLing Zhang <zhangjialing@loongson.cn>

   This is the LoongArch port of linuxinfo
   */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "linuxinfo.h"

#ifdef system_loongarch

void GetHardwareInfo(int fd, struct hw_stat *hw)
{
	int processors = 0;
	float bogomips = 0.0;
	float tempMHz = 0.0;
	char temp_string[BUFSIZ], temp_string2[BUFSIZ];
	char family[BUFSIZ]="Unknown";
	char model[BUFSIZ]="Unknown";

	while (read_line(fd, temp_string, BUFSIZ) != 0)
	{
		if(splitstring(temp_string, temp_string2)){

			/* CPU count */
			if ( !strncmp(temp_string, "processor", strlen("processor")))
				processors++;

			/* CPU Family */
			if ( !strncmp(temp_string, "CPU Family", strlen("CPU Family")))
				strcpy(family, temp_string2);

			if ( !strncmp(temp_string, "Model Name", strlen("Model Name")))
				strcpy(model, temp_string2);

			if ( !strncmp(temp_string, "CPU MHz", strlen("CPU MHz"))) {
				if (atol(temp_string2) > tempMHz){
					tempMHz = atol(temp_string2);
				}
			}

			if ( !(strncmp(temp_string,"BogoMIPS",8))) 
				bogomips = bogomips + atof(temp_string2);
		}
	}

	sprintf(hw->hw_memory, LONGSPEC, getphysicalmemory());
	hw->hw_processors = processors;

	sprintf(hw->hw_cpuinfo, "%s %s", family,model);

	if (bogomips == 0.0)
		sprintf(hw->hw_bogomips, "?");
	else
		sprintf(hw->hw_bogomips, "%0.2f", bogomips);

	if (tempMHz == 0.0)
		sprintf(hw->hw_megahertz, "?");
	else
		sprintf(hw->hw_megahertz, "%d", (int)tempMHz);

}
#endif /* system_loongarch */
