
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaPlayerControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaPlayerControl>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMediaContent>
#include <QMediaTimeRange>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaPlayerControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMediaPlayerControl::staticMetaObject);
}


// QMediaTimeRange QMediaPlayerControl::availablePlaybackRanges()


static void _init_f_availablePlaybackRanges_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaTimeRange > ();
}

static void _call_f_availablePlaybackRanges_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaTimeRange > ((QMediaTimeRange)((QMediaPlayerControl *)cls)->availablePlaybackRanges ());
}


// int QMediaPlayerControl::bufferStatus()


static void _init_f_bufferStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bufferStatus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayerControl *)cls)->bufferStatus ());
}


// qint64 QMediaPlayerControl::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayerControl *)cls)->duration ());
}


// bool QMediaPlayerControl::isAudioAvailable()


static void _init_f_isAudioAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAudioAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl *)cls)->isAudioAvailable ());
}


// bool QMediaPlayerControl::isMuted()


static void _init_f_isMuted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMuted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl *)cls)->isMuted ());
}


// bool QMediaPlayerControl::isSeekable()


static void _init_f_isSeekable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSeekable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl *)cls)->isSeekable ());
}


// bool QMediaPlayerControl::isVideoAvailable()


static void _init_f_isVideoAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVideoAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl *)cls)->isVideoAvailable ());
}


// QMediaContent QMediaPlayerControl::media()


static void _init_f_media_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaContent > ();
}

static void _call_f_media_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaContent > ((QMediaContent)((QMediaPlayerControl *)cls)->media ());
}


// QMediaPlayer::MediaStatus QMediaPlayerControl::mediaStatus()


static void _init_f_mediaStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ();
}

static void _call_f_mediaStatus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ((qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::MediaStatus>(((QMediaPlayerControl *)cls)->mediaStatus ()));
}


// const QIODevice *QMediaPlayerControl::mediaStream()


static void _init_f_mediaStream_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QIODevice * > ();
}

static void _call_f_mediaStream_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QIODevice * > ((const QIODevice *)((QMediaPlayerControl *)cls)->mediaStream ());
}


// void QMediaPlayerControl::pause()


static void _init_f_pause_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_pause_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->pause ();
}


// void QMediaPlayerControl::play()


static void _init_f_play_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_play_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->play ();
}


// double QMediaPlayerControl::playbackRate()


static void _init_f_playbackRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_playbackRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QMediaPlayerControl *)cls)->playbackRate ());
}


// qint64 QMediaPlayerControl::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayerControl *)cls)->position ());
}


// void QMediaPlayerControl::setMedia(const QMediaContent &media, QIODevice *stream)


static void _init_f_setMedia_3944 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("media");
  decl->add_arg<const QMediaContent & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMedia_3944 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  QIODevice *arg2 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->setMedia (arg1, arg2);
}


// void QMediaPlayerControl::setMuted(bool mute)


static void _init_f_setMuted_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mute");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMuted_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->setMuted (arg1);
}


// void QMediaPlayerControl::setPlaybackRate(double rate)


static void _init_f_setPlaybackRate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlaybackRate_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->setPlaybackRate (arg1);
}


// void QMediaPlayerControl::setPosition(qint64 position)


static void _init_f_setPosition_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPosition_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->setPosition (arg1);
}


// void QMediaPlayerControl::setVolume(int volume)


static void _init_f_setVolume_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVolume_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->setVolume (arg1);
}


// QMediaPlayer::State QMediaPlayerControl::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::State>::target_type > ((qt_gsi::Converter<QMediaPlayer::State>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::State>(((QMediaPlayerControl *)cls)->state ()));
}


// void QMediaPlayerControl::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl *)cls)->stop ();
}


// int QMediaPlayerControl::volume()


static void _init_f_volume_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_volume_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayerControl *)cls)->volume ());
}


// static QString QMediaPlayerControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaPlayerControl::tr (arg1, arg2, arg3));
}


// static QString QMediaPlayerControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaPlayerControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMediaPlayerControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("availablePlaybackRanges", "@brief Method QMediaTimeRange QMediaPlayerControl::availablePlaybackRanges()\n", true, &_init_f_availablePlaybackRanges_c0, &_call_f_availablePlaybackRanges_c0);
  methods += new qt_gsi::GenericMethod ("bufferStatus", "@brief Method int QMediaPlayerControl::bufferStatus()\n", true, &_init_f_bufferStatus_c0, &_call_f_bufferStatus_c0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Method qint64 QMediaPlayerControl::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod ("isAudioAvailable?", "@brief Method bool QMediaPlayerControl::isAudioAvailable()\n", true, &_init_f_isAudioAvailable_c0, &_call_f_isAudioAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isMuted?|:muted", "@brief Method bool QMediaPlayerControl::isMuted()\n", true, &_init_f_isMuted_c0, &_call_f_isMuted_c0);
  methods += new qt_gsi::GenericMethod ("isSeekable?", "@brief Method bool QMediaPlayerControl::isSeekable()\n", true, &_init_f_isSeekable_c0, &_call_f_isSeekable_c0);
  methods += new qt_gsi::GenericMethod ("isVideoAvailable?", "@brief Method bool QMediaPlayerControl::isVideoAvailable()\n", true, &_init_f_isVideoAvailable_c0, &_call_f_isVideoAvailable_c0);
  methods += new qt_gsi::GenericMethod ("media", "@brief Method QMediaContent QMediaPlayerControl::media()\n", true, &_init_f_media_c0, &_call_f_media_c0);
  methods += new qt_gsi::GenericMethod ("mediaStatus", "@brief Method QMediaPlayer::MediaStatus QMediaPlayerControl::mediaStatus()\n", true, &_init_f_mediaStatus_c0, &_call_f_mediaStatus_c0);
  methods += new qt_gsi::GenericMethod ("mediaStream", "@brief Method const QIODevice *QMediaPlayerControl::mediaStream()\n", true, &_init_f_mediaStream_c0, &_call_f_mediaStream_c0);
  methods += new qt_gsi::GenericMethod ("pause", "@brief Method void QMediaPlayerControl::pause()\n", false, &_init_f_pause_0, &_call_f_pause_0);
  methods += new qt_gsi::GenericMethod ("play", "@brief Method void QMediaPlayerControl::play()\n", false, &_init_f_play_0, &_call_f_play_0);
  methods += new qt_gsi::GenericMethod (":playbackRate", "@brief Method double QMediaPlayerControl::playbackRate()\n", true, &_init_f_playbackRate_c0, &_call_f_playbackRate_c0);
  methods += new qt_gsi::GenericMethod (":position", "@brief Method qint64 QMediaPlayerControl::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
  methods += new qt_gsi::GenericMethod ("setMedia", "@brief Method void QMediaPlayerControl::setMedia(const QMediaContent &media, QIODevice *stream)\n", false, &_init_f_setMedia_3944, &_call_f_setMedia_3944);
  methods += new qt_gsi::GenericMethod ("setMuted|muted=", "@brief Method void QMediaPlayerControl::setMuted(bool mute)\n", false, &_init_f_setMuted_864, &_call_f_setMuted_864);
  methods += new qt_gsi::GenericMethod ("setPlaybackRate|playbackRate=", "@brief Method void QMediaPlayerControl::setPlaybackRate(double rate)\n", false, &_init_f_setPlaybackRate_1071, &_call_f_setPlaybackRate_1071);
  methods += new qt_gsi::GenericMethod ("setPosition|position=", "@brief Method void QMediaPlayerControl::setPosition(qint64 position)\n", false, &_init_f_setPosition_986, &_call_f_setPosition_986);
  methods += new qt_gsi::GenericMethod ("setVolume|volume=", "@brief Method void QMediaPlayerControl::setVolume(int volume)\n", false, &_init_f_setVolume_767, &_call_f_setVolume_767);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QMediaPlayer::State QMediaPlayerControl::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QMediaPlayerControl::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod (":volume", "@brief Method int QMediaPlayerControl::volume()\n", true, &_init_f_volume_c0, &_call_f_volume_c0);
  methods += gsi::qt_signal<bool > ("audioAvailableChanged(bool)", "audioAvailableChanged", gsi::arg("audioAvailable"), "@brief Signal declaration for QMediaPlayerControl::audioAvailableChanged(bool audioAvailable)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QMediaTimeRange & > ("availablePlaybackRangesChanged(const QMediaTimeRange &)", "availablePlaybackRangesChanged", gsi::arg("ranges"), "@brief Signal declaration for QMediaPlayerControl::availablePlaybackRangesChanged(const QMediaTimeRange &ranges)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("bufferStatusChanged(int)", "bufferStatusChanged", gsi::arg("percentFilled"), "@brief Signal declaration for QMediaPlayerControl::bufferStatusChanged(int percentFilled)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QMediaPlayerControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("durationChanged(qint64)", "durationChanged", gsi::arg("duration"), "@brief Signal declaration for QMediaPlayerControl::durationChanged(qint64 duration)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QString & > ("error(int, const QString &)", "error", gsi::arg("error"), gsi::arg("errorString"), "@brief Signal declaration for QMediaPlayerControl::error(int error, const QString &errorString)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QMediaContent & > ("mediaChanged(const QMediaContent &)", "mediaChanged", gsi::arg("content"), "@brief Signal declaration for QMediaPlayerControl::mediaChanged(const QMediaContent &content)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & > ("mediaStatusChanged(QMediaPlayer::MediaStatus)", "mediaStatusChanged", gsi::arg("status"), "@brief Signal declaration for QMediaPlayerControl::mediaStatusChanged(QMediaPlayer::MediaStatus status)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("mutedChanged(bool)", "mutedChanged", gsi::arg("mute"), "@brief Signal declaration for QMediaPlayerControl::mutedChanged(bool mute)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QMediaPlayerControl::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("playbackRateChanged(double)", "playbackRateChanged", gsi::arg("rate"), "@brief Signal declaration for QMediaPlayerControl::playbackRateChanged(double rate)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("positionChanged(qint64)", "positionChanged", gsi::arg("position"), "@brief Signal declaration for QMediaPlayerControl::positionChanged(qint64 position)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("seekableChanged(bool)", "seekableChanged", gsi::arg("seekable"), "@brief Signal declaration for QMediaPlayerControl::seekableChanged(bool seekable)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaPlayer::State>::target_type & > ("stateChanged(QMediaPlayer::State)", "stateChanged", gsi::arg("newState"), "@brief Signal declaration for QMediaPlayerControl::stateChanged(QMediaPlayer::State newState)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("videoAvailableChanged(bool)", "videoAvailableChanged", gsi::arg("videoAvailable"), "@brief Signal declaration for QMediaPlayerControl::videoAvailableChanged(bool videoAvailable)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("volumeChanged(int)", "volumeChanged", gsi::arg("volume"), "@brief Signal declaration for QMediaPlayerControl::volumeChanged(int volume)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMediaPlayerControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMediaPlayerControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QMediaPlayerControl> decl_QMediaPlayerControl (qtdecl_QMediaControl (), "QtMultimedia", "QMediaPlayerControl_Native",
  methods_QMediaPlayerControl (),
  "@hide\n@alias QMediaPlayerControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaPlayerControl> &qtdecl_QMediaPlayerControl () { return decl_QMediaPlayerControl; }

}


class QMediaPlayerControl_Adaptor : public QMediaPlayerControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMediaPlayerControl_Adaptor();

  //  [adaptor ctor] QMediaPlayerControl::QMediaPlayerControl()
  QMediaPlayerControl_Adaptor() : QMediaPlayerControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QMediaPlayerControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMediaPlayerControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMediaPlayerControl::isSignalConnected(signal);
  }

  //  [expose] int QMediaPlayerControl::receivers(const char *signal)
  int fp_QMediaPlayerControl_receivers_c1731 (const char *signal) const {
    return QMediaPlayerControl::receivers(signal);
  }

  //  [expose] QObject *QMediaPlayerControl::sender()
  QObject * fp_QMediaPlayerControl_sender_c0 () const {
    return QMediaPlayerControl::sender();
  }

  //  [expose] int QMediaPlayerControl::senderSignalIndex()
  int fp_QMediaPlayerControl_senderSignalIndex_c0 () const {
    return QMediaPlayerControl::senderSignalIndex();
  }

  //  [emitter impl] void QMediaPlayerControl::audioAvailableChanged(bool audioAvailable)
  void emitter_QMediaPlayerControl_audioAvailableChanged_864(bool audioAvailable)
  {
    emit QMediaPlayerControl::audioAvailableChanged(audioAvailable);
  }

  //  [adaptor impl] QMediaTimeRange QMediaPlayerControl::availablePlaybackRanges()
  QMediaTimeRange cbs_availablePlaybackRanges_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("availablePlaybackRanges");
  }

  virtual QMediaTimeRange availablePlaybackRanges() const
  {
    if (cb_availablePlaybackRanges_c0_0.can_issue()) {
      return cb_availablePlaybackRanges_c0_0.issue<QMediaPlayerControl_Adaptor, QMediaTimeRange>(&QMediaPlayerControl_Adaptor::cbs_availablePlaybackRanges_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("availablePlaybackRanges");
    }
  }

  //  [emitter impl] void QMediaPlayerControl::availablePlaybackRangesChanged(const QMediaTimeRange &ranges)
  void emitter_QMediaPlayerControl_availablePlaybackRangesChanged_2766(const QMediaTimeRange &ranges)
  {
    emit QMediaPlayerControl::availablePlaybackRangesChanged(ranges);
  }

  //  [adaptor impl] int QMediaPlayerControl::bufferStatus()
  int cbs_bufferStatus_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("bufferStatus");
  }

  virtual int bufferStatus() const
  {
    if (cb_bufferStatus_c0_0.can_issue()) {
      return cb_bufferStatus_c0_0.issue<QMediaPlayerControl_Adaptor, int>(&QMediaPlayerControl_Adaptor::cbs_bufferStatus_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("bufferStatus");
    }
  }

  //  [emitter impl] void QMediaPlayerControl::bufferStatusChanged(int percentFilled)
  void emitter_QMediaPlayerControl_bufferStatusChanged_767(int percentFilled)
  {
    emit QMediaPlayerControl::bufferStatusChanged(percentFilled);
  }

  //  [emitter impl] void QMediaPlayerControl::destroyed(QObject *)
  void emitter_QMediaPlayerControl_destroyed_1302(QObject *arg1)
  {
    emit QMediaPlayerControl::destroyed(arg1);
  }

  //  [adaptor impl] qint64 QMediaPlayerControl::duration()
  qint64 cbs_duration_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("duration");
  }

  virtual qint64 duration() const
  {
    if (cb_duration_c0_0.can_issue()) {
      return cb_duration_c0_0.issue<QMediaPlayerControl_Adaptor, qint64>(&QMediaPlayerControl_Adaptor::cbs_duration_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("duration");
    }
  }

  //  [emitter impl] void QMediaPlayerControl::durationChanged(qint64 duration)
  void emitter_QMediaPlayerControl_durationChanged_986(qint64 duration)
  {
    emit QMediaPlayerControl::durationChanged(duration);
  }

  //  [emitter impl] void QMediaPlayerControl::error(int error, const QString &errorString)
  void emitter_QMediaPlayerControl_error_2684(int _error, const QString &errorString)
  {
    emit QMediaPlayerControl::error(_error, errorString);
  }

  //  [adaptor impl] bool QMediaPlayerControl::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMediaPlayerControl::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMediaPlayerControl_Adaptor, bool, QEvent *>(&QMediaPlayerControl_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMediaPlayerControl::event(_event);
    }
  }

  //  [adaptor impl] bool QMediaPlayerControl::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QMediaPlayerControl::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMediaPlayerControl_Adaptor, bool, QObject *, QEvent *>(&QMediaPlayerControl_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QMediaPlayerControl::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QMediaPlayerControl::isAudioAvailable()
  bool cbs_isAudioAvailable_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isAudioAvailable");
  }

  virtual bool isAudioAvailable() const
  {
    if (cb_isAudioAvailable_c0_0.can_issue()) {
      return cb_isAudioAvailable_c0_0.issue<QMediaPlayerControl_Adaptor, bool>(&QMediaPlayerControl_Adaptor::cbs_isAudioAvailable_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isAudioAvailable");
    }
  }

  //  [adaptor impl] bool QMediaPlayerControl::isMuted()
  bool cbs_isMuted_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isMuted");
  }

  virtual bool isMuted() const
  {
    if (cb_isMuted_c0_0.can_issue()) {
      return cb_isMuted_c0_0.issue<QMediaPlayerControl_Adaptor, bool>(&QMediaPlayerControl_Adaptor::cbs_isMuted_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isMuted");
    }
  }

  //  [adaptor impl] bool QMediaPlayerControl::isSeekable()
  bool cbs_isSeekable_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isSeekable");
  }

  virtual bool isSeekable() const
  {
    if (cb_isSeekable_c0_0.can_issue()) {
      return cb_isSeekable_c0_0.issue<QMediaPlayerControl_Adaptor, bool>(&QMediaPlayerControl_Adaptor::cbs_isSeekable_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isSeekable");
    }
  }

  //  [adaptor impl] bool QMediaPlayerControl::isVideoAvailable()
  bool cbs_isVideoAvailable_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isVideoAvailable");
  }

  virtual bool isVideoAvailable() const
  {
    if (cb_isVideoAvailable_c0_0.can_issue()) {
      return cb_isVideoAvailable_c0_0.issue<QMediaPlayerControl_Adaptor, bool>(&QMediaPlayerControl_Adaptor::cbs_isVideoAvailable_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isVideoAvailable");
    }
  }

  //  [adaptor impl] QMediaContent QMediaPlayerControl::media()
  QMediaContent cbs_media_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("media");
  }

  virtual QMediaContent media() const
  {
    if (cb_media_c0_0.can_issue()) {
      return cb_media_c0_0.issue<QMediaPlayerControl_Adaptor, QMediaContent>(&QMediaPlayerControl_Adaptor::cbs_media_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("media");
    }
  }

  //  [emitter impl] void QMediaPlayerControl::mediaChanged(const QMediaContent &content)
  void emitter_QMediaPlayerControl_mediaChanged_2605(const QMediaContent &content)
  {
    emit QMediaPlayerControl::mediaChanged(content);
  }

  //  [adaptor impl] QMediaPlayer::MediaStatus QMediaPlayerControl::mediaStatus()
  qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type cbs_mediaStatus_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("mediaStatus");
  }

  virtual QMediaPlayer::MediaStatus mediaStatus() const
  {
    if (cb_mediaStatus_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMediaPlayer::MediaStatus>(cb_mediaStatus_c0_0.issue<QMediaPlayerControl_Adaptor, qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type>(&QMediaPlayerControl_Adaptor::cbs_mediaStatus_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("mediaStatus");
    }
  }

  //  [emitter impl] void QMediaPlayerControl::mediaStatusChanged(QMediaPlayer::MediaStatus status)
  void emitter_QMediaPlayerControl_mediaStatusChanged_2858(QMediaPlayer::MediaStatus status)
  {
    emit QMediaPlayerControl::mediaStatusChanged(status);
  }

  //  [adaptor impl] const QIODevice *QMediaPlayerControl::mediaStream()
  const QIODevice * cbs_mediaStream_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("mediaStream");
  }

  virtual const QIODevice * mediaStream() const
  {
    if (cb_mediaStream_c0_0.can_issue()) {
      return cb_mediaStream_c0_0.issue<QMediaPlayerControl_Adaptor, const QIODevice *>(&QMediaPlayerControl_Adaptor::cbs_mediaStream_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("mediaStream");
    }
  }

  //  [emitter impl] void QMediaPlayerControl::mutedChanged(bool mute)
  void emitter_QMediaPlayerControl_mutedChanged_864(bool mute)
  {
    emit QMediaPlayerControl::mutedChanged(mute);
  }

  //  [emitter impl] void QMediaPlayerControl::objectNameChanged(const QString &objectName)
  void emitter_QMediaPlayerControl_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QMediaPlayerControl::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QMediaPlayerControl::pause()
  void cbs_pause_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("pause");
  }

  virtual void pause()
  {
    if (cb_pause_0_0.can_issue()) {
      cb_pause_0_0.issue<QMediaPlayerControl_Adaptor>(&QMediaPlayerControl_Adaptor::cbs_pause_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("pause");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::play()
  void cbs_play_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("play");
  }

  virtual void play()
  {
    if (cb_play_0_0.can_issue()) {
      cb_play_0_0.issue<QMediaPlayerControl_Adaptor>(&QMediaPlayerControl_Adaptor::cbs_play_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("play");
    }
  }

  //  [adaptor impl] double QMediaPlayerControl::playbackRate()
  double cbs_playbackRate_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("playbackRate");
  }

  virtual double playbackRate() const
  {
    if (cb_playbackRate_c0_0.can_issue()) {
      return cb_playbackRate_c0_0.issue<QMediaPlayerControl_Adaptor, double>(&QMediaPlayerControl_Adaptor::cbs_playbackRate_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("playbackRate");
    }
  }

  //  [emitter impl] void QMediaPlayerControl::playbackRateChanged(double rate)
  void emitter_QMediaPlayerControl_playbackRateChanged_1071(double rate)
  {
    emit QMediaPlayerControl::playbackRateChanged(rate);
  }

  //  [adaptor impl] qint64 QMediaPlayerControl::position()
  qint64 cbs_position_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("position");
  }

  virtual qint64 position() const
  {
    if (cb_position_c0_0.can_issue()) {
      return cb_position_c0_0.issue<QMediaPlayerControl_Adaptor, qint64>(&QMediaPlayerControl_Adaptor::cbs_position_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("position");
    }
  }

  //  [emitter impl] void QMediaPlayerControl::positionChanged(qint64 position)
  void emitter_QMediaPlayerControl_positionChanged_986(qint64 position)
  {
    emit QMediaPlayerControl::positionChanged(position);
  }

  //  [emitter impl] void QMediaPlayerControl::seekableChanged(bool seekable)
  void emitter_QMediaPlayerControl_seekableChanged_864(bool seekable)
  {
    emit QMediaPlayerControl::seekableChanged(seekable);
  }

  //  [adaptor impl] void QMediaPlayerControl::setMedia(const QMediaContent &media, QIODevice *stream)
  void cbs_setMedia_3944_0(const QMediaContent &media, QIODevice *stream)
  {
    __SUPPRESS_UNUSED_WARNING (media);
    __SUPPRESS_UNUSED_WARNING (stream);
    throw qt_gsi::AbstractMethodCalledException("setMedia");
  }

  virtual void setMedia(const QMediaContent &media, QIODevice *stream)
  {
    if (cb_setMedia_3944_0.can_issue()) {
      cb_setMedia_3944_0.issue<QMediaPlayerControl_Adaptor, const QMediaContent &, QIODevice *>(&QMediaPlayerControl_Adaptor::cbs_setMedia_3944_0, media, stream);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setMedia");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::setMuted(bool mute)
  void cbs_setMuted_864_0(bool mute)
  {
    __SUPPRESS_UNUSED_WARNING (mute);
    throw qt_gsi::AbstractMethodCalledException("setMuted");
  }

  virtual void setMuted(bool mute)
  {
    if (cb_setMuted_864_0.can_issue()) {
      cb_setMuted_864_0.issue<QMediaPlayerControl_Adaptor, bool>(&QMediaPlayerControl_Adaptor::cbs_setMuted_864_0, mute);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setMuted");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::setPlaybackRate(double rate)
  void cbs_setPlaybackRate_1071_0(double rate)
  {
    __SUPPRESS_UNUSED_WARNING (rate);
    throw qt_gsi::AbstractMethodCalledException("setPlaybackRate");
  }

  virtual void setPlaybackRate(double rate)
  {
    if (cb_setPlaybackRate_1071_0.can_issue()) {
      cb_setPlaybackRate_1071_0.issue<QMediaPlayerControl_Adaptor, double>(&QMediaPlayerControl_Adaptor::cbs_setPlaybackRate_1071_0, rate);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setPlaybackRate");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::setPosition(qint64 position)
  void cbs_setPosition_986_0(qint64 position)
  {
    __SUPPRESS_UNUSED_WARNING (position);
    throw qt_gsi::AbstractMethodCalledException("setPosition");
  }

  virtual void setPosition(qint64 position)
  {
    if (cb_setPosition_986_0.can_issue()) {
      cb_setPosition_986_0.issue<QMediaPlayerControl_Adaptor, qint64>(&QMediaPlayerControl_Adaptor::cbs_setPosition_986_0, position);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setPosition");
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::setVolume(int volume)
  void cbs_setVolume_767_0(int volume)
  {
    __SUPPRESS_UNUSED_WARNING (volume);
    throw qt_gsi::AbstractMethodCalledException("setVolume");
  }

  virtual void setVolume(int volume)
  {
    if (cb_setVolume_767_0.can_issue()) {
      cb_setVolume_767_0.issue<QMediaPlayerControl_Adaptor, int>(&QMediaPlayerControl_Adaptor::cbs_setVolume_767_0, volume);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setVolume");
    }
  }

  //  [adaptor impl] QMediaPlayer::State QMediaPlayerControl::state()
  qt_gsi::Converter<QMediaPlayer::State>::target_type cbs_state_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("state");
  }

  virtual QMediaPlayer::State state() const
  {
    if (cb_state_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMediaPlayer::State>(cb_state_c0_0.issue<QMediaPlayerControl_Adaptor, qt_gsi::Converter<QMediaPlayer::State>::target_type>(&QMediaPlayerControl_Adaptor::cbs_state_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("state");
    }
  }

  //  [emitter impl] void QMediaPlayerControl::stateChanged(QMediaPlayer::State newState)
  void emitter_QMediaPlayerControl_stateChanged_2247(QMediaPlayer::State newState)
  {
    emit QMediaPlayerControl::stateChanged(newState);
  }

  //  [adaptor impl] void QMediaPlayerControl::stop()
  void cbs_stop_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("stop");
  }

  virtual void stop()
  {
    if (cb_stop_0_0.can_issue()) {
      cb_stop_0_0.issue<QMediaPlayerControl_Adaptor>(&QMediaPlayerControl_Adaptor::cbs_stop_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("stop");
    }
  }

  //  [emitter impl] void QMediaPlayerControl::videoAvailableChanged(bool videoAvailable)
  void emitter_QMediaPlayerControl_videoAvailableChanged_864(bool videoAvailable)
  {
    emit QMediaPlayerControl::videoAvailableChanged(videoAvailable);
  }

  //  [adaptor impl] int QMediaPlayerControl::volume()
  int cbs_volume_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("volume");
  }

  virtual int volume() const
  {
    if (cb_volume_c0_0.can_issue()) {
      return cb_volume_c0_0.issue<QMediaPlayerControl_Adaptor, int>(&QMediaPlayerControl_Adaptor::cbs_volume_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("volume");
    }
  }

  //  [emitter impl] void QMediaPlayerControl::volumeChanged(int volume)
  void emitter_QMediaPlayerControl_volumeChanged_767(int volume)
  {
    emit QMediaPlayerControl::volumeChanged(volume);
  }

  //  [adaptor impl] void QMediaPlayerControl::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QMediaPlayerControl::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMediaPlayerControl_Adaptor, QChildEvent *>(&QMediaPlayerControl_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QMediaPlayerControl::childEvent(event);
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QMediaPlayerControl::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMediaPlayerControl_Adaptor, QEvent *>(&QMediaPlayerControl_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QMediaPlayerControl::customEvent(event);
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMediaPlayerControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMediaPlayerControl_Adaptor, const QMetaMethod &>(&QMediaPlayerControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMediaPlayerControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMediaPlayerControl::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QMediaPlayerControl::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMediaPlayerControl_Adaptor, QTimerEvent *>(&QMediaPlayerControl_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QMediaPlayerControl::timerEvent(event);
    }
  }

  gsi::Callback cb_availablePlaybackRanges_c0_0;
  gsi::Callback cb_bufferStatus_c0_0;
  gsi::Callback cb_duration_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isAudioAvailable_c0_0;
  gsi::Callback cb_isMuted_c0_0;
  gsi::Callback cb_isSeekable_c0_0;
  gsi::Callback cb_isVideoAvailable_c0_0;
  gsi::Callback cb_media_c0_0;
  gsi::Callback cb_mediaStatus_c0_0;
  gsi::Callback cb_mediaStream_c0_0;
  gsi::Callback cb_pause_0_0;
  gsi::Callback cb_play_0_0;
  gsi::Callback cb_playbackRate_c0_0;
  gsi::Callback cb_position_c0_0;
  gsi::Callback cb_setMedia_3944_0;
  gsi::Callback cb_setMuted_864_0;
  gsi::Callback cb_setPlaybackRate_1071_0;
  gsi::Callback cb_setPosition_986_0;
  gsi::Callback cb_setVolume_767_0;
  gsi::Callback cb_state_c0_0;
  gsi::Callback cb_stop_0_0;
  gsi::Callback cb_volume_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMediaPlayerControl_Adaptor::~QMediaPlayerControl_Adaptor() { }

//  Constructor QMediaPlayerControl::QMediaPlayerControl() (adaptor class)

static void _init_ctor_QMediaPlayerControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QMediaPlayerControl_Adaptor> ();
}

static void _call_ctor_QMediaPlayerControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaPlayerControl_Adaptor *> (new QMediaPlayerControl_Adaptor ());
}


// emitter void QMediaPlayerControl::audioAvailableChanged(bool audioAvailable)

static void _init_emitter_audioAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("audioAvailable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_audioAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_audioAvailableChanged_864 (arg1);
}


// QMediaTimeRange QMediaPlayerControl::availablePlaybackRanges()

static void _init_cbs_availablePlaybackRanges_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaTimeRange > ();
}

static void _call_cbs_availablePlaybackRanges_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaTimeRange > ((QMediaTimeRange)((QMediaPlayerControl_Adaptor *)cls)->cbs_availablePlaybackRanges_c0_0 ());
}

static void _set_callback_cbs_availablePlaybackRanges_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_availablePlaybackRanges_c0_0 = cb;
}


// emitter void QMediaPlayerControl::availablePlaybackRangesChanged(const QMediaTimeRange &ranges)

static void _init_emitter_availablePlaybackRangesChanged_2766 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ranges");
  decl->add_arg<const QMediaTimeRange & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_availablePlaybackRangesChanged_2766 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaTimeRange &arg1 = gsi::arg_reader<const QMediaTimeRange & >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_availablePlaybackRangesChanged_2766 (arg1);
}


// int QMediaPlayerControl::bufferStatus()

static void _init_cbs_bufferStatus_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_bufferStatus_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayerControl_Adaptor *)cls)->cbs_bufferStatus_c0_0 ());
}

static void _set_callback_cbs_bufferStatus_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_bufferStatus_c0_0 = cb;
}


// emitter void QMediaPlayerControl::bufferStatusChanged(int percentFilled)

static void _init_emitter_bufferStatusChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("percentFilled");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_bufferStatusChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_bufferStatusChanged_767 (arg1);
}


// void QMediaPlayerControl::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMediaPlayerControl::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QMediaPlayerControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_destroyed_1302 (arg1);
}


// void QMediaPlayerControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// qint64 QMediaPlayerControl::duration()

static void _init_cbs_duration_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_duration_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayerControl_Adaptor *)cls)->cbs_duration_c0_0 ());
}

static void _set_callback_cbs_duration_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_duration_c0_0 = cb;
}


// emitter void QMediaPlayerControl::durationChanged(qint64 duration)

static void _init_emitter_durationChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_durationChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_durationChanged_986 (arg1);
}


// emitter void QMediaPlayerControl::error(int error, const QString &errorString)

static void _init_emitter_error_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("errorString");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_error_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_error_2684 (arg1, arg2);
}


// bool QMediaPlayerControl::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMediaPlayerControl::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QMediaPlayerControl::isAudioAvailable()

static void _init_cbs_isAudioAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isAudioAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_isAudioAvailable_c0_0 ());
}

static void _set_callback_cbs_isAudioAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_isAudioAvailable_c0_0 = cb;
}


// bool QMediaPlayerControl::isMuted()

static void _init_cbs_isMuted_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isMuted_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_isMuted_c0_0 ());
}

static void _set_callback_cbs_isMuted_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_isMuted_c0_0 = cb;
}


// bool QMediaPlayerControl::isSeekable()

static void _init_cbs_isSeekable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isSeekable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_isSeekable_c0_0 ());
}

static void _set_callback_cbs_isSeekable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_isSeekable_c0_0 = cb;
}


// exposed bool QMediaPlayerControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->fp_QMediaPlayerControl_isSignalConnected_c2394 (arg1));
}


// bool QMediaPlayerControl::isVideoAvailable()

static void _init_cbs_isVideoAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isVideoAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayerControl_Adaptor *)cls)->cbs_isVideoAvailable_c0_0 ());
}

static void _set_callback_cbs_isVideoAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_isVideoAvailable_c0_0 = cb;
}


// QMediaContent QMediaPlayerControl::media()

static void _init_cbs_media_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaContent > ();
}

static void _call_cbs_media_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaContent > ((QMediaContent)((QMediaPlayerControl_Adaptor *)cls)->cbs_media_c0_0 ());
}

static void _set_callback_cbs_media_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_media_c0_0 = cb;
}


// emitter void QMediaPlayerControl::mediaChanged(const QMediaContent &content)

static void _init_emitter_mediaChanged_2605 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("content");
  decl->add_arg<const QMediaContent & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_mediaChanged_2605 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_mediaChanged_2605 (arg1);
}


// QMediaPlayer::MediaStatus QMediaPlayerControl::mediaStatus()

static void _init_cbs_mediaStatus_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ();
}

static void _call_cbs_mediaStatus_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ((qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type)((QMediaPlayerControl_Adaptor *)cls)->cbs_mediaStatus_c0_0 ());
}

static void _set_callback_cbs_mediaStatus_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_mediaStatus_c0_0 = cb;
}


// emitter void QMediaPlayerControl::mediaStatusChanged(QMediaPlayer::MediaStatus status)

static void _init_emitter_mediaStatusChanged_2858 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("status");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_mediaStatusChanged_2858 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_mediaStatusChanged_2858 (arg1);
}


// const QIODevice *QMediaPlayerControl::mediaStream()

static void _init_cbs_mediaStream_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QIODevice * > ();
}

static void _call_cbs_mediaStream_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QIODevice * > ((const QIODevice *)((QMediaPlayerControl_Adaptor *)cls)->cbs_mediaStream_c0_0 ());
}

static void _set_callback_cbs_mediaStream_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_mediaStream_c0_0 = cb;
}


// emitter void QMediaPlayerControl::mutedChanged(bool mute)

static void _init_emitter_mutedChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mute");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_mutedChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_mutedChanged_864 (arg1);
}


// emitter void QMediaPlayerControl::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_objectNameChanged_4567 (arg1);
}


// void QMediaPlayerControl::pause()

static void _init_cbs_pause_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_pause_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_pause_0_0 ();
}

static void _set_callback_cbs_pause_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_pause_0_0 = cb;
}


// void QMediaPlayerControl::play()

static void _init_cbs_play_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_play_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_play_0_0 ();
}

static void _set_callback_cbs_play_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_play_0_0 = cb;
}


// double QMediaPlayerControl::playbackRate()

static void _init_cbs_playbackRate_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_playbackRate_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QMediaPlayerControl_Adaptor *)cls)->cbs_playbackRate_c0_0 ());
}

static void _set_callback_cbs_playbackRate_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_playbackRate_c0_0 = cb;
}


// emitter void QMediaPlayerControl::playbackRateChanged(double rate)

static void _init_emitter_playbackRateChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_playbackRateChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_playbackRateChanged_1071 (arg1);
}


// qint64 QMediaPlayerControl::position()

static void _init_cbs_position_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_position_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayerControl_Adaptor *)cls)->cbs_position_c0_0 ());
}

static void _set_callback_cbs_position_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_position_c0_0 = cb;
}


// emitter void QMediaPlayerControl::positionChanged(qint64 position)

static void _init_emitter_positionChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_positionChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_positionChanged_986 (arg1);
}


// exposed int QMediaPlayerControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMediaPlayerControl_Adaptor *)cls)->fp_QMediaPlayerControl_receivers_c1731 (arg1));
}


// emitter void QMediaPlayerControl::seekableChanged(bool seekable)

static void _init_emitter_seekableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("seekable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_seekableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_seekableChanged_864 (arg1);
}


// exposed QObject *QMediaPlayerControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaPlayerControl_Adaptor *)cls)->fp_QMediaPlayerControl_sender_c0 ());
}


// exposed int QMediaPlayerControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayerControl_Adaptor *)cls)->fp_QMediaPlayerControl_senderSignalIndex_c0 ());
}


// void QMediaPlayerControl::setMedia(const QMediaContent &media, QIODevice *stream)

static void _init_cbs_setMedia_3944_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("media");
  decl->add_arg<const QMediaContent & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setMedia_3944_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = args.read<const QMediaContent & > (heap);
  QIODevice *arg2 = args.read<QIODevice * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_setMedia_3944_0 (arg1, arg2);
}

static void _set_callback_cbs_setMedia_3944_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_setMedia_3944_0 = cb;
}


// void QMediaPlayerControl::setMuted(bool mute)

static void _init_cbs_setMuted_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mute");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setMuted_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_setMuted_864_0 (arg1);
}

static void _set_callback_cbs_setMuted_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_setMuted_864_0 = cb;
}


// void QMediaPlayerControl::setPlaybackRate(double rate)

static void _init_cbs_setPlaybackRate_1071_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setPlaybackRate_1071_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_setPlaybackRate_1071_0 (arg1);
}

static void _set_callback_cbs_setPlaybackRate_1071_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_setPlaybackRate_1071_0 = cb;
}


// void QMediaPlayerControl::setPosition(qint64 position)

static void _init_cbs_setPosition_986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setPosition_986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args.read<qint64 > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_setPosition_986_0 (arg1);
}

static void _set_callback_cbs_setPosition_986_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_setPosition_986_0 = cb;
}


// void QMediaPlayerControl::setVolume(int volume)

static void _init_cbs_setVolume_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVolume_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_setVolume_767_0 (arg1);
}

static void _set_callback_cbs_setVolume_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_setVolume_767_0 = cb;
}


// QMediaPlayer::State QMediaPlayerControl::state()

static void _init_cbs_state_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::State>::target_type > ();
}

static void _call_cbs_state_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::State>::target_type > ((qt_gsi::Converter<QMediaPlayer::State>::target_type)((QMediaPlayerControl_Adaptor *)cls)->cbs_state_c0_0 ());
}

static void _set_callback_cbs_state_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_state_c0_0 = cb;
}


// emitter void QMediaPlayerControl::stateChanged(QMediaPlayer::State newState)

static void _init_emitter_stateChanged_2247 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_2247 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::State>::target_type & >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_stateChanged_2247 (arg1);
}


// void QMediaPlayerControl::stop()

static void _init_cbs_stop_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_stop_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_stop_0_0 ();
}

static void _set_callback_cbs_stop_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_stop_0_0 = cb;
}


// void QMediaPlayerControl::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayerControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QMediaPlayerControl::videoAvailableChanged(bool videoAvailable)

static void _init_emitter_videoAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("videoAvailable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_videoAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_videoAvailableChanged_864 (arg1);
}


// int QMediaPlayerControl::volume()

static void _init_cbs_volume_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_volume_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayerControl_Adaptor *)cls)->cbs_volume_c0_0 ());
}

static void _set_callback_cbs_volume_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayerControl_Adaptor *)cls)->cb_volume_c0_0 = cb;
}


// emitter void QMediaPlayerControl::volumeChanged(int volume)

static void _init_emitter_volumeChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_volumeChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QMediaPlayerControl_Adaptor *)cls)->emitter_QMediaPlayerControl_volumeChanged_767 (arg1);
}


namespace gsi
{

gsi::Class<QMediaPlayerControl> &qtdecl_QMediaPlayerControl ();

static gsi::Methods methods_QMediaPlayerControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaPlayerControl::QMediaPlayerControl()\nThis method creates an object of class QMediaPlayerControl.", &_init_ctor_QMediaPlayerControl_Adaptor_0, &_call_ctor_QMediaPlayerControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("emit_audioAvailableChanged", "@brief Emitter for signal void QMediaPlayerControl::audioAvailableChanged(bool audioAvailable)\nCall this method to emit this signal.", false, &_init_emitter_audioAvailableChanged_864, &_call_emitter_audioAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("availablePlaybackRanges", "@brief Virtual method QMediaTimeRange QMediaPlayerControl::availablePlaybackRanges()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_availablePlaybackRanges_c0_0, &_call_cbs_availablePlaybackRanges_c0_0);
  methods += new qt_gsi::GenericMethod ("availablePlaybackRanges", "@hide", true, &_init_cbs_availablePlaybackRanges_c0_0, &_call_cbs_availablePlaybackRanges_c0_0, &_set_callback_cbs_availablePlaybackRanges_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_availablePlaybackRangesChanged", "@brief Emitter for signal void QMediaPlayerControl::availablePlaybackRangesChanged(const QMediaTimeRange &ranges)\nCall this method to emit this signal.", false, &_init_emitter_availablePlaybackRangesChanged_2766, &_call_emitter_availablePlaybackRangesChanged_2766);
  methods += new qt_gsi::GenericMethod ("bufferStatus", "@brief Virtual method int QMediaPlayerControl::bufferStatus()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_bufferStatus_c0_0, &_call_cbs_bufferStatus_c0_0);
  methods += new qt_gsi::GenericMethod ("bufferStatus", "@hide", true, &_init_cbs_bufferStatus_c0_0, &_call_cbs_bufferStatus_c0_0, &_set_callback_cbs_bufferStatus_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_bufferStatusChanged", "@brief Emitter for signal void QMediaPlayerControl::bufferStatusChanged(int percentFilled)\nCall this method to emit this signal.", false, &_init_emitter_bufferStatusChanged_767, &_call_emitter_bufferStatusChanged_767);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMediaPlayerControl::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMediaPlayerControl::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QMediaPlayerControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMediaPlayerControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Virtual method qint64 QMediaPlayerControl::duration()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("duration", "@hide", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0, &_set_callback_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_durationChanged", "@brief Emitter for signal void QMediaPlayerControl::durationChanged(qint64 duration)\nCall this method to emit this signal.", false, &_init_emitter_durationChanged_986, &_call_emitter_durationChanged_986);
  methods += new qt_gsi::GenericMethod ("emit_error", "@brief Emitter for signal void QMediaPlayerControl::error(int error, const QString &errorString)\nCall this method to emit this signal.", false, &_init_emitter_error_2684, &_call_emitter_error_2684);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMediaPlayerControl::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMediaPlayerControl::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isAudioAvailable", "@brief Virtual method bool QMediaPlayerControl::isAudioAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isAudioAvailable_c0_0, &_call_cbs_isAudioAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isAudioAvailable", "@hide", true, &_init_cbs_isAudioAvailable_c0_0, &_call_cbs_isAudioAvailable_c0_0, &_set_callback_cbs_isAudioAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isMuted", "@brief Virtual method bool QMediaPlayerControl::isMuted()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isMuted_c0_0, &_call_cbs_isMuted_c0_0);
  methods += new qt_gsi::GenericMethod ("isMuted", "@hide", true, &_init_cbs_isMuted_c0_0, &_call_cbs_isMuted_c0_0, &_set_callback_cbs_isMuted_c0_0);
  methods += new qt_gsi::GenericMethod ("isSeekable", "@brief Virtual method bool QMediaPlayerControl::isSeekable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isSeekable_c0_0, &_call_cbs_isSeekable_c0_0);
  methods += new qt_gsi::GenericMethod ("isSeekable", "@hide", true, &_init_cbs_isSeekable_c0_0, &_call_cbs_isSeekable_c0_0, &_set_callback_cbs_isSeekable_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMediaPlayerControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("isVideoAvailable", "@brief Virtual method bool QMediaPlayerControl::isVideoAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isVideoAvailable_c0_0, &_call_cbs_isVideoAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isVideoAvailable", "@hide", true, &_init_cbs_isVideoAvailable_c0_0, &_call_cbs_isVideoAvailable_c0_0, &_set_callback_cbs_isVideoAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("media", "@brief Virtual method QMediaContent QMediaPlayerControl::media()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_media_c0_0, &_call_cbs_media_c0_0);
  methods += new qt_gsi::GenericMethod ("media", "@hide", true, &_init_cbs_media_c0_0, &_call_cbs_media_c0_0, &_set_callback_cbs_media_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_mediaChanged", "@brief Emitter for signal void QMediaPlayerControl::mediaChanged(const QMediaContent &content)\nCall this method to emit this signal.", false, &_init_emitter_mediaChanged_2605, &_call_emitter_mediaChanged_2605);
  methods += new qt_gsi::GenericMethod ("mediaStatus", "@brief Virtual method QMediaPlayer::MediaStatus QMediaPlayerControl::mediaStatus()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mediaStatus_c0_0, &_call_cbs_mediaStatus_c0_0);
  methods += new qt_gsi::GenericMethod ("mediaStatus", "@hide", true, &_init_cbs_mediaStatus_c0_0, &_call_cbs_mediaStatus_c0_0, &_set_callback_cbs_mediaStatus_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_mediaStatusChanged", "@brief Emitter for signal void QMediaPlayerControl::mediaStatusChanged(QMediaPlayer::MediaStatus status)\nCall this method to emit this signal.", false, &_init_emitter_mediaStatusChanged_2858, &_call_emitter_mediaStatusChanged_2858);
  methods += new qt_gsi::GenericMethod ("mediaStream", "@brief Virtual method const QIODevice *QMediaPlayerControl::mediaStream()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mediaStream_c0_0, &_call_cbs_mediaStream_c0_0);
  methods += new qt_gsi::GenericMethod ("mediaStream", "@hide", true, &_init_cbs_mediaStream_c0_0, &_call_cbs_mediaStream_c0_0, &_set_callback_cbs_mediaStream_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_mutedChanged", "@brief Emitter for signal void QMediaPlayerControl::mutedChanged(bool mute)\nCall this method to emit this signal.", false, &_init_emitter_mutedChanged_864, &_call_emitter_mutedChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QMediaPlayerControl::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("pause", "@brief Virtual method void QMediaPlayerControl::pause()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_pause_0_0, &_call_cbs_pause_0_0);
  methods += new qt_gsi::GenericMethod ("pause", "@hide", false, &_init_cbs_pause_0_0, &_call_cbs_pause_0_0, &_set_callback_cbs_pause_0_0);
  methods += new qt_gsi::GenericMethod ("play", "@brief Virtual method void QMediaPlayerControl::play()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_play_0_0, &_call_cbs_play_0_0);
  methods += new qt_gsi::GenericMethod ("play", "@hide", false, &_init_cbs_play_0_0, &_call_cbs_play_0_0, &_set_callback_cbs_play_0_0);
  methods += new qt_gsi::GenericMethod ("playbackRate", "@brief Virtual method double QMediaPlayerControl::playbackRate()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_playbackRate_c0_0, &_call_cbs_playbackRate_c0_0);
  methods += new qt_gsi::GenericMethod ("playbackRate", "@hide", true, &_init_cbs_playbackRate_c0_0, &_call_cbs_playbackRate_c0_0, &_set_callback_cbs_playbackRate_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_playbackRateChanged", "@brief Emitter for signal void QMediaPlayerControl::playbackRateChanged(double rate)\nCall this method to emit this signal.", false, &_init_emitter_playbackRateChanged_1071, &_call_emitter_playbackRateChanged_1071);
  methods += new qt_gsi::GenericMethod ("position", "@brief Virtual method qint64 QMediaPlayerControl::position()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_position_c0_0, &_call_cbs_position_c0_0);
  methods += new qt_gsi::GenericMethod ("position", "@hide", true, &_init_cbs_position_c0_0, &_call_cbs_position_c0_0, &_set_callback_cbs_position_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_positionChanged", "@brief Emitter for signal void QMediaPlayerControl::positionChanged(qint64 position)\nCall this method to emit this signal.", false, &_init_emitter_positionChanged_986, &_call_emitter_positionChanged_986);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMediaPlayerControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_seekableChanged", "@brief Emitter for signal void QMediaPlayerControl::seekableChanged(bool seekable)\nCall this method to emit this signal.", false, &_init_emitter_seekableChanged_864, &_call_emitter_seekableChanged_864);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMediaPlayerControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMediaPlayerControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setMedia", "@brief Virtual method void QMediaPlayerControl::setMedia(const QMediaContent &media, QIODevice *stream)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMedia_3944_0, &_call_cbs_setMedia_3944_0);
  methods += new qt_gsi::GenericMethod ("setMedia", "@hide", false, &_init_cbs_setMedia_3944_0, &_call_cbs_setMedia_3944_0, &_set_callback_cbs_setMedia_3944_0);
  methods += new qt_gsi::GenericMethod ("setMuted", "@brief Virtual method void QMediaPlayerControl::setMuted(bool mute)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMuted_864_0, &_call_cbs_setMuted_864_0);
  methods += new qt_gsi::GenericMethod ("setMuted", "@hide", false, &_init_cbs_setMuted_864_0, &_call_cbs_setMuted_864_0, &_set_callback_cbs_setMuted_864_0);
  methods += new qt_gsi::GenericMethod ("setPlaybackRate", "@brief Virtual method void QMediaPlayerControl::setPlaybackRate(double rate)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPlaybackRate_1071_0, &_call_cbs_setPlaybackRate_1071_0);
  methods += new qt_gsi::GenericMethod ("setPlaybackRate", "@hide", false, &_init_cbs_setPlaybackRate_1071_0, &_call_cbs_setPlaybackRate_1071_0, &_set_callback_cbs_setPlaybackRate_1071_0);
  methods += new qt_gsi::GenericMethod ("setPosition", "@brief Virtual method void QMediaPlayerControl::setPosition(qint64 position)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPosition_986_0, &_call_cbs_setPosition_986_0);
  methods += new qt_gsi::GenericMethod ("setPosition", "@hide", false, &_init_cbs_setPosition_986_0, &_call_cbs_setPosition_986_0, &_set_callback_cbs_setPosition_986_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@brief Virtual method void QMediaPlayerControl::setVolume(int volume)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVolume_767_0, &_call_cbs_setVolume_767_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@hide", false, &_init_cbs_setVolume_767_0, &_call_cbs_setVolume_767_0, &_set_callback_cbs_setVolume_767_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Virtual method QMediaPlayer::State QMediaPlayerControl::state()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("state", "@hide", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0, &_set_callback_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QMediaPlayerControl::stateChanged(QMediaPlayer::State newState)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_2247, &_call_emitter_stateChanged_2247);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Virtual method void QMediaPlayerControl::stop()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@hide", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0, &_set_callback_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMediaPlayerControl::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_videoAvailableChanged", "@brief Emitter for signal void QMediaPlayerControl::videoAvailableChanged(bool videoAvailable)\nCall this method to emit this signal.", false, &_init_emitter_videoAvailableChanged_864, &_call_emitter_videoAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("volume", "@brief Virtual method int QMediaPlayerControl::volume()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0);
  methods += new qt_gsi::GenericMethod ("volume", "@hide", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0, &_set_callback_cbs_volume_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_volumeChanged", "@brief Emitter for signal void QMediaPlayerControl::volumeChanged(int volume)\nCall this method to emit this signal.", false, &_init_emitter_volumeChanged_767, &_call_emitter_volumeChanged_767);
  return methods;
}

gsi::Class<QMediaPlayerControl_Adaptor> decl_QMediaPlayerControl_Adaptor (qtdecl_QMediaPlayerControl (), "QtMultimedia", "QMediaPlayerControl",
  methods_QMediaPlayerControl_Adaptor (),
  "@qt\n@brief Binding of QMediaPlayerControl");

}

