
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_utilities.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AssumedPartitionCheck( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_AssumedPartitionCheck_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CheckError( HYPRE_Int hypre_ierr, HYPRE_Int hypre_error_code )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CheckError_pre( precision, hypre_ierr, hypre_error_code );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ClearAllErrors( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ClearAllErrors_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ClearError( HYPRE_Int hypre_error_code )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ClearError_pre( precision, hypre_error_code );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ClearErrorMessages( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ClearErrorMessages_pre( precision );
}

/*--------------------------------------------------------------------------*/

void
HYPRE_DescribeError( HYPRE_Int hypre_ierr, char *descr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_DescribeError_pre( precision, hypre_ierr, descr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_DeviceInitialize( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_DeviceInitialize_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Finalize( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_Finalize_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Finalized( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_Finalized_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetError( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GetError_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetErrorArg( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GetErrorArg_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetErrorMessages( char **buffer, HYPRE_Int *bufsz )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GetErrorMessages_pre( precision, buffer, bufsz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetExecutionPolicy( HYPRE_ExecutionPolicy *exec_policy )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GetExecutionPolicy_pre( precision, exec_policy );
}

/*--------------------------------------------------------------------------*/

const char*
HYPRE_GetExecutionPolicyName( HYPRE_ExecutionPolicy exec_policy )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GetExecutionPolicyName_pre( precision, exec_policy );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetGlobalError( MPI_Comm comm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GetGlobalError_pre( precision, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetMemoryLocation( HYPRE_MemoryLocation *memory_location )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GetMemoryLocation_pre( precision, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Initialize( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_Initialize_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Initialized( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_Initialized_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MemoryPrintUsage( MPI_Comm comm, HYPRE_Int level, const char *function, HYPRE_Int line )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MemoryPrintUsage_pre( precision, comm, level, function, line );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PrintDeviceInfo( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PrintDeviceInfo_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PrintErrorMessages( MPI_Comm comm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PrintErrorMessages_pre( precision, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetExecutionPolicy( HYPRE_ExecutionPolicy exec_policy )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SetExecutionPolicy_pre( precision, exec_policy );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetGpuAwareMPI( HYPRE_Int use_gpu_aware_mpi )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SetGpuAwareMPI_pre( precision, use_gpu_aware_mpi );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetLogLevel( HYPRE_Int log_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SetLogLevel_pre( precision, log_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetMemoryLocation( HYPRE_MemoryLocation memory_location )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SetMemoryLocation_pre( precision, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetPrintErrorMode( HYPRE_Int mode )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SetPrintErrorMode_pre( precision, mode );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetPrintErrorVerbosity( HYPRE_Int code, HYPRE_Int verbosity )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SetPrintErrorVerbosity_pre( precision, code, verbosity );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetSpGemmUseVendor( HYPRE_Int use_vendor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SetSpGemmUseVendor_pre( precision, use_vendor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetSpMVUseVendor( HYPRE_Int use_vendor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SetSpMVUseVendor_pre( precision, use_vendor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetSpTransUseVendor( HYPRE_Int use_vendor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SetSpTransUseVendor_pre( precision, use_vendor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetUseGpuRand( HYPRE_Int use_curand )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SetUseGpuRand_pre( precision, use_curand );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Version( char **version_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_Version_pre( precision, version_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VersionNumber( HYPRE_Int *major_ptr, HYPRE_Int *minor_ptr, HYPRE_Int *patch_ptr, HYPRE_Int *single_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_VersionNumber_pre( precision, major_ptr, minor_ptr, patch_ptr, single_ptr );
}



#endif

