---
authors: Markus Rudy (@burgerdev)
state: committed
---

# Objective

Define a format for GLOME public keys at rest.

# Background

The GLOME protocol definition does not deal with key material handling, and the
reference implementation only implements a very rudimentary storage format -
32 raw octets. This causes a variety of problems, e.g. when transferring keys
between hosts or when specifying server keys for *GLOME Login*.

See also [google/glome#100](https://github.com/google/glome/issues/100).

# Requirements

* A GLOME public key at rest should be unambiguously identifiable as such.
* Public keys should be printable.
* Public keys should be easily exchanged over any medium, potentially analog.

# Design ideas

Public keys are stored in URL-safe base64 encoding and tagged with their
protocol variant version. The configuration file format accepts keys in a
format similar to [OpenSSH's `authorized_keys` format][1].

[1]: https://man.openbsd.org/sshd.8#AUTHORIZED_KEYS_FILE_FORMAT

## Public Key Format

The format of a _GLOME public key_ adheres to the ABNF below:

```abnf
public-key = key-type SP key-base64
key-type = "glome-v1"
key-base64 = 44urlsafe-base64-char
urlsafe-base64-char = "=" / "-" / "_" / ALPHA / DIGIT
```

The key type encodes the GLOME variant this key should be used with. As we
only have one variant right now, we're only defining one `key-type` here.

An example public key, like it would be printed by `glome pubkey`:

```
glome-v1 lXmlq5jynG6um_w4D4N13TRIE-x7jt0TKVNDMSRS2_I=
```

## Public Key Interpretation

An implementation must verify that the `key-type` matches its expectations and
must not produce a tag if it does not.

If the `key-type` matches the expectations, the `key-base64` part is decoded as
base64, and the resulting 32 octets are interpreted as the _raw GLOME public
key_, suitable for use with `glome_tag`.

## Consequences for the GLOME Login Configuration Format

The configuration file accepts a new `public-key` field in the `service`
section. This field must contain a key as specified in this document. The `key`
field is deprecated and will be removed for release 1.0, but will be supported
until then. If both `public-key` and `key` are present in the config file,
`public-key` will take precedence.
