/*
    This file is part of RetroWave.

    Copyright (C) 2021 ReimuNotMoe <reimu@sudomaker.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

#pragma once

#include <vector>
#include <string>
#include <sstream>

#include "RetroWave.h"
#include "Board/OPL3.h"
#include "Protocol/Serial.h"
#include "Platform/POSIX_SerialPort.h"
#include "Platform/Win32_SerialPort.h"
#include "Platform/Linux_SPI.h"

#include "logging.h"
#include "../serialport/libserial.h"

extern RetroWaveContext retrowave_global_context;
extern int retrowave_global_context_inited;

extern void retrowave_init_dosbox(const std::string& bus, const std::string& path, const std::string& spi_cs);

