/* 'checkit_tiff' is a conformance checker for baseline TIFFs
 *
 * author: Andreas Romeyke, 2015-2022
 * licensed under conditions of libtiff
 * (see http://libtiff.maptools.org/misc.html)
 *
 */

#include "check.h"
#include "check_helper.h"
#include "ctstring.h"

/* check if offsets are word aligned */
ret_t check_all_offsets_are_word_aligned(ctiff_t * ctif) {
  GET_EMPTY_RET(ret);
  TIFP_CHECK( ctif, ret);
  uint16 count = get_ifd0_count( ctif);
  for (int tagidx = 0; tagidx< count; tagidx++) {
    ifd_entry_t ifd_entry = TIFFGetRawTagIFDListEntry( ctif, ctif->ifd0, tagidx );
    if (ifd_entry.value_or_offset==is_offset) {
      uint32 offset = ifd_entry.data32offset;
      if ( 0 != (offset & 1)) {
        uint32 tag = TIFFGetRawTagListEntry( ctif, ctif->ifd0, tagidx);
        // FIXME: tif_fails?
        ret = set_value_found_ret_formatted_with_returncode( &ret, tagerror_offset_not_word_aligned, "tag %u pointing to 0x%08x and is not word-aligned", tag, offset);
        return ret;
      }
    }
  }
  ret.returncode=is_valid;
  return ret;
}
/* vim: set tabstop=2 softtabstop=2 shiftwidth=2 smarttab expandtab :*/
