*** Settings ***
Documentation       Network Teldat SNMP plugin

Resource            ${CURDIR}${/}..${/}..${/}..${/}resources/import.resource

Test Timeout        120s


*** Variables ***
${CMD}                          ${CENTREON_PLUGINS} --plugin=network::teldat::snmp::plugin


*** Test Cases ***
Cells radio ${tc}
    [Tags]    network    teldat    snmp
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=cells-radio
    ...    --hostname=127.0.0.1
    ...    --snmp-version=2c
    ...    --snmp-port=2024
    ...    --snmp-community=network/teldat/snmp/teldat
    ...    --custom-perfdata-instances=${customperfdatainstances}
    ...    --critical-status=${criticalstatus}
    ...    --warning-modules-cellradio-detected=${warningmodulescellradiodetected}
    ...    --critical-modules-cellradio-detected=${criticalmodulescellradiodetected}
    ...    --warning-module-cellradio-rsrp=${warningmodulecellradiorsrp}
    ...    --critical-module-cellradio-rsrp=${criticalmodulecellradiorsrp}
    ...    --warning-module-cellradio-rsrq=${warningmodulecellradiorsrq}
    ...    --critical-module-cellradio-rsrq=${criticalmodulecellradiorsrq}
    ...    --warning-module-cellradio-csq=${warningmodulecellradiocsq}
    ...    --critical-module-cellradio-csq=${criticalmodulecellradiocsq}
    ...    --warning-module-cellradio-snr=${warningmodulecellradiosnr}
    ...    --critical-module-cellradio-snr=${criticalmodulecellradiosnr}

    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}


    Examples:    tc   customperfdatainstances     criticalstatus                                warningmodulescellradiodetected    criticalmodulescellradiodetected    warningmodulecellradiorsrp    criticalmodulecellradiorsrp    warningmodulecellradiorsrq    criticalmodulecellradiorsrq    warningmodulecellradiocsq    criticalmodulecellradiocsq    warningmodulecellradiosnr    criticalmodulecellradiosnr    expected_result    --
            ...  1    ${EMPTY}                    ${EMPTY}                                      ${EMPTY}                           ${EMPTY}                            ${EMPTY}                      ${EMPTY}                       ${EMPTY}                      ${EMPTY}                       ${EMPTY}                     ${EMPTY}                      ${EMPTY}                     ${EMPTY}                      OK: All cellular radio interfaces are ok | 'modules.cellradio.detected.count'=3;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;;;0;
            ...  4    '%(operator) %(simIcc)'     ${EMPTY}                                      ${EMPTY}                           ${EMPTY}                            ${EMPTY}                      ${EMPTY}                       ${EMPTY}                      ${EMPTY}                       ${EMPTY}                     ${EMPTY}                      ${EMPTY}                     ${EMPTY}                      OK: All cellular radio interfaces are ok | 'modules.cellradio.detected.count'=3;;;0; '---~89330122115801091660#module.cellradio.rsrp.dbm'=-114;;;0; '---~89330122115801091660#module.cellradio.rsrq.dbm'=-18;;;0; '---~89330122115801091660#module.cellradio.snr.db'=-1;;;0; '---~89330122115801091660#module.cellradio.csq.dbm'=-73;;;0; 'PHENIX~89330122115801091660#module.cellradio.rsrp.dbm'=-114;;;0; 'PHENIX~89330122115801091660#module.cellradio.rsrq.dbm'=-18;;;0; 'PHENIX~89330122115801091660#module.cellradio.snr.db'=-1;;;0; 'PHENIX~89330122115801091660#module.cellradio.csq.dbm'=-73;;;0;
            ...  5    ${EMPTY}                    ${EMPTY}                                      2                                  ${EMPTY}                            ${EMPTY}                      ${EMPTY}                       ${EMPTY}                      ${EMPTY}                       ${EMPTY}                     ${EMPTY}                      ${EMPTY}                     ${EMPTY}                      WARNING: Number of cellular radio interfacesdetected: 3 | 'modules.cellradio.detected.count'=3;0:2;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;;;0;
            ...  6    ${EMPTY}                    ${EMPTY}                                      ${EMPTY}                           2                                   ${EMPTY}                      ${EMPTY}                       ${EMPTY}                      ${EMPTY}                       ${EMPTY}                     ${EMPTY}                      ${EMPTY}                     ${EMPTY}                      CRITICAL: Number of cellular radio interfacesdetected: 3 | 'modules.cellradio.detected.count'=3;;0:2;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;;;0;
            ...  7    ${EMPTY}                    ${EMPTY}                                      ${EMPTY}                           ${EMPTY}                            -100                          ${EMPTY}                       ${EMPTY}                      ${EMPTY}                       ${EMPTY}                     ${EMPTY}                      ${EMPTY}                     ${EMPTY}                      WARNING: cellular radio module '1' interface 'control vocal' [imei: 359072066403821] rsrp: -114 dBm - cellular radio module '1' interface 'data primary' [imei: 359072066403821] rsrp: -114 dBm | 'modules.cellradio.detected.count'=3;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;0:-100;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;0:-100;;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;;;0;
            ...  8    ${EMPTY}                    ${EMPTY}                                      ${EMPTY}                           ${EMPTY}                            ${EMPTY}                      -100                           ${EMPTY}                      ${EMPTY}                       ${EMPTY}                     ${EMPTY}                      ${EMPTY}                     ${EMPTY}                      CRITICAL: cellular radio module '1' interface 'control vocal' [imei: 359072066403821] rsrp: -114 dBm - cellular radio module '1' interface 'data primary' [imei: 359072066403821] rsrp: -114 dBm | 'modules.cellradio.detected.count'=3;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;;0:-100;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;;0:-100;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;;;0;
            ...  9    ${EMPTY}                    ${EMPTY}                                      ${EMPTY}                           ${EMPTY}                            ${EMPTY}                      ${EMPTY}                       10                            ${EMPTY}                       ${EMPTY}                     ${EMPTY}                      ${EMPTY}                     ${EMPTY}                      WARNING: cellular radio module '1' interface 'control vocal' [imei: 359072066403821] rsrq: -18 dBm - cellular radio module '1' interface 'data primary' [imei: 359072066403821] rsrq: -18 dBm | 'modules.cellradio.detected.count'=3;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;0:10;;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;0:10;;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;;;0;
            ...  10   ${EMPTY}                    ${EMPTY}                                      ${EMPTY}                           ${EMPTY}                            ${EMPTY}                      ${EMPTY}                       ${EMPTY}                      10                             ${EMPTY}                     ${EMPTY}                      ${EMPTY}                     ${EMPTY}                      CRITICAL: cellular radio module '1' interface 'control vocal' [imei: 359072066403821] rsrq: -18 dBm - cellular radio module '1' interface 'data primary' [imei: 359072066403821] rsrq: -18 dBm | 'modules.cellradio.detected.count'=3;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;;0:10;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;;0:10;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;;;0;
            ...  11   ${EMPTY}                    ${EMPTY}                                      ${EMPTY}                           ${EMPTY}                            ${EMPTY}                      ${EMPTY}                       ${EMPTY}                      ${EMPTY}                       10                           ${EMPTY}                      ${EMPTY}                     ${EMPTY}                      WARNING: cellular radio module '1' interface 'control vocal' [imei: 359072066403821] csq: -73 dBm - cellular radio module '1' interface 'data primary' [imei: 359072066403821] csq: -73 dBm | 'modules.cellradio.detected.count'=3;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;0:10;;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;0:10;;0;
            ...  12   ${EMPTY}                    ${EMPTY}                                      ${EMPTY}                           ${EMPTY}                            ${EMPTY}                      ${EMPTY}                       ${EMPTY}                      ${EMPTY}                       ${EMPTY}                     10                            ${EMPTY}                     ${EMPTY}                      CRITICAL: cellular radio module '1' interface 'control vocal' [imei: 359072066403821] csq: -73 dBm - cellular radio module '1' interface 'data primary' [imei: 359072066403821] csq: -73 dBm | 'modules.cellradio.detected.count'=3;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;;0:10;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;;0:10;0;
            ...  13   ${EMPTY}                    ${EMPTY}                                      ${EMPTY}                           ${EMPTY}                            ${EMPTY}                      ${EMPTY}                       ${EMPTY}                      ${EMPTY}                       ${EMPTY}                     ${EMPTY}                      0                            ${EMPTY}                      WARNING: cellular radio module '1' interface 'control vocal' [imei: 359072066403821] snr: -1 dB - cellular radio module '1' interface 'data primary' [imei: 359072066403821] snr: -1 dB | 'modules.cellradio.detected.count'=3;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;0:0;;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;0:0;;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;;;0;
            ...  14   ${EMPTY}                    ${EMPTY}                                      ${EMPTY}                           ${EMPTY}                            ${EMPTY}                      ${EMPTY}                       ${EMPTY}                      ${EMPTY}                       ${EMPTY}                     ${EMPTY}                      ${EMPTY}                     0                             CRITICAL: cellular radio module '1' interface 'control vocal' [imei: 359072066403821] snr: -1 dB - cellular radio module '1' interface 'data primary' [imei: 359072066403821] snr: -1 dB | 'modules.cellradio.detected.count'=3;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;;0:0;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;;0:0;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;;;0;
            ...  15   ${EMPTY}                    '\\\%{interfaceState} =~ /disconnect/'        ${EMPTY}                           ${EMPTY}                            ${EMPTY}                      ${EMPTY}                       ${EMPTY}                      ${EMPTY}                       ${EMPTY}                     ${EMPTY}                      ${EMPTY}                     ${EMPTY}                      CRITICAL: cellular radio module '1' interface 'control vocal' [imei: 359072066403821] sim status: OK [operator: ---] [imsi: 208015606540916] [interface state: disconnect(1)] [simIcc: 89330122115801091660] - cellular radio module '1' interface 'data auxiliary' [imei: 359072066403821] sim status: DETECTING [operator: ---] [imsi: 208015606540916] [interface state: disconnect(1)] [simIcc: 89330122115801091660] | 'modules.cellradio.detected.count'=3;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~control vocal~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~control vocal~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~control vocal~359072066403821#module.cellradio.csq.dbm'=-73;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrp.dbm'=-114;;;0; 'module1~data primary~359072066403821#module.cellradio.rsrq.dbm'=-18;;;0; 'module1~data primary~359072066403821#module.cellradio.snr.db'=-1;;;0; 'module1~data primary~359072066403821#module.cellradio.csq.dbm'=-73;;;0;
