#!/usr/bin/env python3

EPSILON=1e-6

def DBL(c):
  return c / 255.0

samples = [
  { 'str': "#000000",
    'fail': False,
    'red': 0.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 1.0 },
  { 'str': "#FFff00",
    'fail': False,
    'red': 1.0,
    'green': 1.0,
    'blue': 0.0,
    'alpha': 1.0 },
  { 'str': "#6495ed",
    'fail': False,
    'red': DBL(100),
    'green': DBL(149),
    'blue': DBL(237),
    'alpha': 1.0 },
  { 'str': "#fff",
    'fail': False,
    'red': 1.0,
    'green': 1.0,
    'blue': 1.0,
    'alpha': 1.0 },
  #{ 'str': "#64649595eded",
    #'fail': False,
    #'red': 1.0,
    #'green': 1.0,
    #'blue': 0.0,
    #'alpha': 1.0 },
  { 'str': "rgb(0,0,0)",
    'fail': False,
    'red': 0.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 1.0 },
  { 'str': "rgb(100,149,237)",
    'fail': False,
    'red': DBL(100),
    'green': DBL(149),
    'blue': DBL(237),
    'alpha': 1.0 },
  { 'str': "rgba(100%,0,100%,0.5)",
    'fail': False,
    'red': 1.0,
    'green': 0.0,
    'blue': 1.0,
    'alpha': 0.5 },
  { 'str': "rgb(100%,149,20%)",
    'fail': False,
    'red': 1.0,
    'green': DBL(149),
    'blue': 0.2,
    'alpha': 1.0 },
  { 'str': "rgb(foobar)",
    'fail': True,
    'red': 0.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 1.0 },
  { 'str': "rgb(100,149,237",
    'fail': True,
    'red': 0.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 1.0 },
  { 'str': "rED",
    'fail': False,
    'red': 1.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 1.0 },
  { 'str': "cornflowerblue",
    'fail': False,
    'red': DBL(100),
    'green': DBL(149),
    'blue': DBL(237),
    'alpha': 1.0 },
  { 'str': "    red",
    'fail': False,
    'red': 1.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 1.0 },
  { 'str': "red      ",
    'fail': False,
    'red': 1.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 1.0 },
  { 'str': "red",
    'fail': False,
    'red': 1.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 1.0 },
  { 'str': "red  blue",
    'fail': True,
    'red': 0.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 0.0 },
  { 'str': "transparent",
    'fail': False,
    'red': 0.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 0.0 },
  { 'str': "23foobar",
    'fail': True,
    'red': 0.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 0.0 },
  { 'str': "",
    'fail': True,
    'red': 0.0,
    'green': 0.0,
    'blue': 0.0,
    'alpha': 0.0 }
]

for sample in samples:
  color = Gimp.color_parse_css(sample['str'])
  print(color)
  if sample['fail']:
    gimp_assert('Parsing "{}" should fail.'.format(sample['str']), color is None)
  else:
    gimp_assert('Parsing "{}" should generate a color.'.format(sample['str']), color is not None)

    r, g, b, a = color.get_rgba_with_space(Babl.format("R'G'B'A double"))
    gimp_assert('"{}" generated ({}, {}, {}, {}) - expected ({}, {}, {}, {}).'.format(sample['str'],
                                                                                      r, g, b, a,
                                                                                      sample['red'],
                                                                                      sample['green'],
                                                                                      sample['blue'],
                                                                                      sample['alpha']),
                abs(r - sample['red']) < EPSILON and abs(g - sample['green']) < EPSILON and
                abs(b - sample['blue']) < EPSILON and abs(a - sample['alpha']) < EPSILON)
