include(RunCMake)

run_cmake(CMP0070-NEW)
run_cmake(CMP0070-OLD)
run_cmake(CMP0070-WARN)

run_cmake(SourceProperty)
run_cmake(SourceProperty-CMP0070-NEW)
run_cmake(SourceProperty-CMP0070-OLD)

run_cmake(CommandConflict)
if(RunCMake_GENERATOR_IS_MULTI_CONFIG)
  run_cmake(OutputConflict)
endif()
run_cmake(EmptyCondition1)
run_cmake(EmptyCondition2)
run_cmake(BadCondition)
run_cmake(DebugEvaluate)
run_cmake(GenerateSource)
run_cmake(InputAndContent)
run_cmake(OutputNameMatchesSources)
run_cmake(OutputNameMatchesObjects)
run_cmake(OutputNameMatchesOtherSources)
file(READ "${RunCMake_BINARY_DIR}/OutputNameMatchesOtherSources-build/1somefile.cpp" file_contents)
if (NOT file_contents MATCHES "generated.cpp.rule")
  message(SEND_ERROR "Rule file not in target sources! ${file_contents}")
endif()

run_cmake(COMPILE_LANGUAGE-genex)
foreach(l CXX C)
  file(READ "${RunCMake_BINARY_DIR}/COMPILE_LANGUAGE-genex-build/opts-${l}.txt" l_defs)
  if (NOT l_defs STREQUAL "LANG_IS_${l}\n")
    message(FATAL_ERROR "File content does not match: ${l_defs}")
  endif()
endforeach()

run_cmake(Target)
file(READ "${RunCMake_BINARY_DIR}/Target-build/sub1/output.txt" sub_1)
file(READ "${RunCMake_BINARY_DIR}/Target-build/sub2/output.txt" sub_2)
if(NOT sub_1 MATCHES "first" OR NOT sub_2 MATCHES "second")
  message(SEND_ERROR "Wrong target used by TARGET argument! ${sub_1} ${sub_2}")
endif()

set(timeformat "%Y%j%H%M%S")

file(REMOVE "${RunCMake_BINARY_DIR}/WriteIfDifferent-build/output_file.txt")
set(RunCMake_TEST_OPTIONS "-DTEST_FILE=WriteIfDifferent.cmake")
set(RunCMake_TEST_BINARY_DIR "${RunCMake_BINARY_DIR}/WriteIfDifferent-build")
run_cmake(WriteIfDifferent-prepare)
unset(RunCMake_TEST_OPTIONS)
unset(RunCMake_TEST_BINARY_DIR)
file(TIMESTAMP "${RunCMake_BINARY_DIR}/WriteIfDifferent-build/output_file.txt" timestamp ${timeformat})
if(NOT timestamp)
  message(SEND_ERROR "Could not get timestamp for \"${RunCMake_BINARY_DIR}/WriteIfDifferent-build/output_file.txt\"")
endif()

execute_process(COMMAND ${CMAKE_COMMAND} -E sleep 1)

set(RunCMake_TEST_NO_CLEAN ON)
run_cmake(WriteIfDifferent)
file(TIMESTAMP "${RunCMake_BINARY_DIR}/WriteIfDifferent-build/output_file.txt" timestamp_after ${timeformat})
if(NOT timestamp_after)
  message(SEND_ERROR "Could not get timestamp for \"${RunCMake_BINARY_DIR}/WriteIfDifferent-build/output_file.txt\"")
endif()
unset(RunCMake_TEST_NO_CLEAN)

if (NOT timestamp_after STREQUAL timestamp)
  message(SEND_ERROR "WriteIfDifferent changed output file.")
endif()

if (UNIX AND EXISTS /bin/sh)
  set(RunCMake_TEST_NO_CLEAN ON)
  run_cmake(CarryPermissions)
  execute_process(
    COMMAND "${RunCMake_BINARY_DIR}/CarryPermissions-build/output_script.sh"
    OUTPUT_VARIABLE script_output
    RESULT_VARIABLE script_result
    ERROR_VARIABLE script_error
    OUTPUT_STRIP_TRAILING_WHITESPACE
  )
  if (script_result)
    message(SEND_ERROR "Generated script did not execute correctly: [${script_result}]\n${script_output}\n====\n${script_error}")
  endif()
  if (NOT script_output STREQUAL SUCCESS)
    message(SEND_ERROR "Generated script did not execute correctly:\n${script_output}\n====\n${script_error}")
  endif()
  unset(RunCMake_TEST_NO_CLEAN)
endif()

if (RunCMake_GENERATOR MATCHES Makefiles)
  file(MAKE_DIRECTORY "${RunCMake_BINARY_DIR}/ReRunCMake-build/")
  file(WRITE "${RunCMake_BINARY_DIR}/ReRunCMake-build/input_file.txt" "InitialContent\n")

  set(RunCMake_TEST_NO_CLEAN ON)
  run_cmake(ReRunCMake)
  unset(RunCMake_TEST_NO_CLEAN)
  file(TIMESTAMP "${RunCMake_BINARY_DIR}/ReRunCMake-build/output_file.txt" timestamp ${timeformat})
  if(NOT timestamp)
    message(SEND_ERROR "Could not get timestamp for \"${RunCMake_BINARY_DIR}/ReRunCMake-build/output_file.txt\"")
  endif()

  execute_process(COMMAND ${CMAKE_COMMAND} -E sleep 1)

  file(WRITE "${RunCMake_BINARY_DIR}/ReRunCMake-build/input_file.txt" "ChangedContent\n")
  execute_process(COMMAND ${CMAKE_COMMAND} --build "${RunCMake_BINARY_DIR}/ReRunCMake-build/")
  file(READ "${RunCMake_BINARY_DIR}/ReRunCMake-build/output_file.txt" out_content)

  if(NOT out_content STREQUAL "ChangedContent\n")
    message(SEND_ERROR "File did not change: \"${RunCMake_BINARY_DIR}/ReRunCMake-build/output_file.txt\"")
  endif()


  file(REMOVE "${RunCMake_BINARY_DIR}/ReRunCMake-build/output_file.txt")
  execute_process(COMMAND ${CMAKE_COMMAND} --build "${RunCMake_BINARY_DIR}/ReRunCMake-build/")

  if (NOT EXISTS "${RunCMake_BINARY_DIR}/ReRunCMake-build/output_file.txt")
    message(SEND_ERROR "File did not re-generate: \"${RunCMake_BINARY_DIR}/ReRunCMake-build/output_file.txt\"")
  endif()
endif()

set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/AdjacentInOut-build)
run_cmake(AdjacentInOut)
set(RunCMake_TEST_NO_CLEAN 1)
run_cmake_command(AdjacentInOut-nowork ${CMAKE_COMMAND} --build .)
unset(RunCMake_TEST_BINARY_DIR)
unset(RunCMake_TEST_NO_CLEAN)

run_cmake(SourcePermissions1)
run_cmake(SourcePermissions2)
run_cmake(SourcePermissions3)
run_cmake(SourcePermissions4)
run_cmake(SourcePermissions5)

function(run_cmake_and_verify_after_build case)
  set(RunCMake_TEST_BINARY_DIR "${RunCMake_BINARY_DIR}/${case}-build")
  file(REMOVE_RECURSE "${RunCMake_TEST_BINARY_DIR}")
  file(MAKE_DIRECTORY "${RunCMake_TEST_BINARY_DIR}")
  set(RunCMake_TEST_NO_CLEAN 1)
  if(RunCMake_GENERATOR_IS_MULTI_CONFIG)
    set(RunCMake_TEST_OPTIONS -DCMAKE_CONFIGURATION_TYPES=Debug)
  else()
    set(RunCMake_TEST_OPTIONS -DCMAKE_BUILD_TYPE=Debug)
  endif()
  run_cmake(${case})
  run_cmake_command("${case}-build" ${CMAKE_COMMAND} --build .)
  unset(RunCMake_TEST_NO_CLEAN)
  unset(RunCMake_TEST_BINARY_DIR)
endfunction()

run_cmake_and_verify_after_build(NoSourcePermissions)
run_cmake_and_verify_after_build(UseSourcePermissions)
run_cmake_and_verify_after_build(CustomFilePermissions)

run_cmake(NewLineStyle-NoArg)
run_cmake(NewLineStyle-InvalidArg)
run_cmake_and_verify_after_build(NewLineStyle-Default)
run_cmake_and_verify_after_build(NewLineStyle-Unix)
run_cmake_and_verify_after_build(NewLineStyle-Win32)
