/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * $Id: Packet.h,v 1.9 2001/11/24 21:11:50 benoit Exp $
 *
 * Copyright (c) 2000 Remi Lefebvre <remi@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef PACKET_H
#define PACKET_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "packets.h"
#include "Logger.h"

class Packet
{
  public:
    static int encode (DdtpPacket* pkt, char* buf, int bufSize);
    static int decode (DdtpPacket* pkt, char* buf, int bufSize);

    static int decrypt (DdtpPacket* pkt, char* md5_password);
    static int encrypt (DdtpPacket* pkt, char* md5_password);

    static int getAccountId (DdtpPacket* pkt);

    static int createUpdateQuery(
        DdtpPacket*             ddtpPacket,
        ProtocolVersion         protocolVersion,
        EncryptionType          encryptionType,
        int                     accountId,
        DDTPv1UpdateQueryOpCode opCode,
        unsigned long           ipAddress,
        char*                   updatePassword);

    static int createAliveQuery(
        DdtpPacket*             ddtpPacket,
        ProtocolVersion         protocolVersion,
        int                     accountId);

    static int createAliveReply(
            DdtpPacket*             ddtpPacket,
            ProtocolVersion         protocolVersion,
            int                     accountId);

    /*
    int processDdtpPacket  (DdtpPacket* pkt);

    int  getMessageType() { return messageType_;   }
    int  getReplyStatus() { return replyStatus_;   }
    bool replyRequired()  { return replyRequired_; }
    */

  private:
    static int decryptDDTPv1Plaintext (DDTPv1Plaintext* ptmsg);
    static int encryptDDTPv1Plaintext (DDTPv1Plaintext* ptmsg);
    static int decryptDDTPv1Blowfish  (DDTPv1Blowfish*  bfmsg, char* md5_password);
    static int encryptDDTPv1Blowfish  (DDTPv1Blowfish*  bfmsg, char* md5_password);

    /*
    Logger*     log_;
#ifdef DDT_SERVER
    DdtDB*     db_;
#endif
    bool        amServer_;

    bool        replyRequired_;
    int         messageType_;
    int         replyStatus_;

    int         accountId_;

    int processDDTPv1Packet      (DDTPv1Packet*   ddtpv1);

    int processDDTPv1Message     (DDTPv1Message*  msg, int accountId);

    int processDDTPv1UpdateQuery (DDTPv1UpdateQuery* updateQuery,
                                  DDTPv1UpdateReply* updateReply,
                                  int accountId);
    int processDDTPv1UpdateReply (DDTPv1UpdateReply* updateReply);

    int processDDTPv1AliveQuery  (DDTPv1AliveQuery*  aliveQuery,
                                  DDTPv1AliveReply*  aliveReply);
    int processDDTPv1AliveReply  (DDTPv1AliveReply*  aliveReply,
                                  int accountId);
    */

};
#endif // PACKET_H
