##############################################################################
#
# Copyright (c) 2004-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

#
# OSV: Objects Services
#

import orm
import netsvc
import sql_db
import copy

import psycopg

class except_osv(Exception):
	def __init__(self, name, value, exc_type='warning'):
		self.name = name
		self.exc_type = exc_type
		self.value = value
		self.args = (exc_type,name)

class osv_pool(netsvc.Service):
	obj_pool = {}
	def __init__(self):
		self.created = []
		self._sql_error = {}
		netsvc.Service.__init__(self, 'object_proxy', audience='')
		self.joinGroup('web-services')
		self.exportMethod(self.exportedMethods)
		self.exportMethod(self.obj_list)
		self.exportMethod(self.exec_workflow)
		self.exportMethod(self.execute)
		self.exportMethod(self.execute_cr)

	def execute_cr(self, cr, uid, obj, method, *args, **kw):
		#
		# TODO: check security level
		#
		try:
			if (not method in getattr(self.obj_pool[obj],'_protected')) and len(args) and args[0] and len(self.obj_pool[obj]._inherits):
				types = {obj: args[0]}
				cr.execute('select inst_type,inst_id,obj_id from inherit where obj_type=%s and  obj_id in ('+','.join(map(str,args[0]))+')', (obj,))
				for ty,id,id2 in cr.fetchall():
					if not ty in types:
						types[ty]=[]
					types[ty].append(id)
					types[obj].remove(id2)
				for t,ids in types.items():
					if len(ids):
						t = self.obj_pool[t]
						res = getattr(t,method)(cr, uid, ids, *args[1:], **kw)
			else:
				obj = self.obj_pool[obj]
				res = getattr(obj,method)(cr, uid, *args, **kw)
			return res
		except orm.except_orm, inst:
			self.abortResponse(1, inst.value[0], inst.name, inst.value[1])
		except except_osv, inst:
			self.abortResponse(1, inst.name, inst.exc_type, inst.value)
		except psycopg.IntegrityError, inst:
			for key in self._sql_error.keys():
				if '<<'+key+'>>' in inst[0]:
					self.abortResponse(1, 'Constraint Error', 'warning', self._sql_error[key])
			self.abortResponse(1, 'Integrity Error', 'warning', inst[0])


	def execute(self, uid, obj, method, *args, **kw):
		cr = sql_db.db.cursor()
		try:
			try:
				res = self.execute_cr(cr, uid, obj, method, *args, **kw)
				cr.commit()
			except Exception:
				cr.rollback()
				raise
		finally:
			cr.close()
		return res

	def exec_workflow_cr(self, cr, uid, obj, method, *args):
		wf_service = netsvc.LocalService("workflow")
		wf_service.trg_validate(uid, obj, args[0], method, cr)
		return True

	def exec_workflow(self, uid, obj, method, *args):
		cr = sql_db.db.cursor()
		try:
			try:
				res = self.exec_workflow_cr(cr, uid, obj, method, *args)
				cr.commit()
			except Exception:
				cr.rollback()
				raise
		finally:
			cr.close()
		return res

	def obj_list(self):
		return self.obj_pool.keys()

	# adds a new object instance to the object pool. 
	# if it already existed, the instance is replaced
	def add(self, name, obj_inst):
		if self.obj_pool.has_key(name):
			del self.obj_pool[name]
		self.obj_pool[name] = obj_inst

	def get(self, name):
		return self.obj_pool.get(name, None)

osv_pools = osv_pool()

class inheritor(type):
	def __new__(cls, name, bases, d):
		parent_name = d.get('_inherit', None)
		if parent_name:
			parent_obj = osv_pools.get(parent_name)
			assert parent_obj, "parent object %s does not exist !" % parent_name
			for s in ('_columns', '_defaults'):
				new_dict = copy.copy(getattr(parent_obj.__class__, s))
				new_dict.update(d.get(s, {}))
				d[s] = new_dict
			bases = (parent_obj.__class__,)
		res = type.__new__(cls, name, bases, d)
		#
		# update _inherits of others objects
		#
		return res

class osv(orm.orm):
	__metaclass__ = inheritor

	def __init__(self):
		osv_pools.add(self._name, self)
		self.pool = osv_pools
		orm.orm.__init__(self)

class Cacheable(object):

	_cache = {}
	count = 0

	def __delete_key(self, key):
		odico = self._cache
		for key_item in key[:-1]:
			odico = odico[key_item]
		del odico[key[-1]]
	
	def __add_key(self, key, value):
		odico = self._cache
		for key_item in key[:-1]:
			odico = odico.setdefault(key_item, {})
		odico[key[-1]] = value

	def add(self, key, value):
		self.__add_key(key, value)
	
	def invalidate(self, key):
		self.__delete_key(key)
	
	def get(self, key):
		try:
			w = self._cache[key]
			return w
		except KeyError:
			return None
	
	def clear(self):
		self._cache.clear()
		self._items = []

def filter_dict(d, fields):
	res = {}
	for f in fields + ['id']:
		if f in d:
			res[f] = d[f]
	return res

class cacheable_osv(osv, Cacheable):

	_relevant = ['lang']

	def __init__(self):
		super(cacheable_osv, self).__init__()
	
	def read(self, cr, user, ids, fields=[], context={}, load='_classic_read'):
		fields = fields or self._columns.keys()
		ctx = [context.get(x, False) for x in self._relevant]
		result, tofetch = [], []
		for id in ids:
			res = self.get(self._name, id, ctx)
			if not res:
				tofetch.append(id)
			else:
				result.append(filter_dict(res, fields))

		# gen the list of "local" (ie not inherited) fields which are classic or many2one
		nfields = filter(lambda x: x[1]._classic_write, self._columns.items())
		# gen the list of inherited fields
		inherits = map(lambda x: (x[0], x[1][2]), self._inherit_fields.items())
		# complete the field list with the inherited fields which are classic or many2one
		nfields += filter(lambda x: x[1]._classic_write, inherits)
		nfields = [x[0] for x in nfields]

		res = super(cacheable_osv, self).read(cr, user, tofetch, nfields, context, load)
		for r in res:
			self.add((self._name, r['id'], ctx), r)
			result.append(filter_dict(r, fields))

		# Appel de fonction si necessaire
		tofetch = []
		for f in fields:
			if f not in nfields:
				tofetch.append(f)
		for f in tofetch:
			fvals = self._columns[f].get(cr, self, ids, f, user, context=context)
			for r in result:
				r[f] = fvals[r['id']]

		# TODO: tri par self._order !!
		return result

	def invalidate(self, key):
		del self._cache[key[0]][key[1]]
	
	def write(self, cr, user, ids, values, context={}):
		for id in ids:
			self.invalidate((self._name, id))
		return super(cacheable_osv, self).write(cr, user, ids, values, context)
	
	def unlink(self, cr, user, ids):
		self.clear()
		return super(cacheable_osv, self).unlink(cr, user, ids)

#cacheable_osv = osv

# vim:noexpandtab:
