type token =
  | VAR of (string)
  | VARLPAR of (string)
  | VARLBRA of (string)
  | STRING of (string)
  | INT of (int)
  | FLOAT of (float)
  | BOOL of (bool)
  | TIME of (int option list)
  | INTERVAL of (int option list * int option list)
  | EOF
  | BEGIN
  | END
  | GETS
  | TILD
  | DEF of (Doc.item * (string*string) list)
  | IF
  | THEN
  | ELSE
  | ELSIF
  | LPAR
  | RPAR
  | COMMA
  | SEQ
  | LBRA
  | RBRA
  | LCUR
  | RCUR
  | FUN
  | YIELDS
  | BIN0 of (string)
  | BIN1 of (string)
  | BIN2 of (string)
  | BIN3 of (string)
  | MINUS
  | NOT
  | PP_IFDEF
  | PP_ENDIF
  | PP_ENDL
  | PP_INCLUDE
  | PP_DEF
  | PP_COMMENT of (string list)

open Parsing;;
# 24 "lang/lang_parser.mly"

  open Source
  open Lang_values

  (** Parsing locations. *)
  let curpos ?pos () =
    match pos with
      | None -> Parsing.symbol_start_pos (), Parsing.symbol_end_pos ()
      | Some (i,j) -> Parsing.rhs_start_pos i, Parsing.rhs_end_pos j

  (** Create a new value with an unknown type. *)
  let mk ?pos e =
    let kind =
      T.fresh_evar ~level:(-1) ~pos:(Some (curpos ?pos ()))
    in
      if Lang_values.debug then
        Printf.eprintf "%s (%s): assigned type var %s\n"
          (T.print_pos (Utils.get_some kind.T.pos))
          (try Lang_values.print_term {t=kind;term=e} with _ -> "<?>")
          (T.print kind) ;
      { t = kind ; term = e }

      (** Time intervals *)

  let time_units = [| 7*24*60*60 ; 24*60*60 ; 60*60 ; 60 ; 1 |]

  let date =
    let to_int = function None -> 0 | Some i -> i in
    let rec aux = function
      | None::tl -> aux tl
      | [] -> failwith "Invalid time"
      | l ->
          let a = Array.of_list l in
          let n = Array.length a in
          let tu = time_units and tn = Array.length time_units in
            Array.fold_left (+) 0
              (Array.mapi (fun i s ->
                             let s =
                               if n=4 && i=0 then
                                 (to_int s) mod 7
                               else
                                 to_int s
                             in
                               tu.(tn-1 + i - n+1) * s) a)
    in
      aux

  let rec last_index e n = function
    | x::tl -> if x=e then last_index e (n+1) tl else n
    | [] -> n

  let precision d = time_units.(last_index None 0 d)
  let duration d = time_units.(Array.length time_units - 1 - 
                               last_index None 0 (List.rev d))

  let between d1 d2 =
    let p1 = precision d1 in
    let p2 = precision d2 in
    let t1 = date d1 in
    let t2 = date d2 in
      if p1<>p2 then failwith "Invalid time interval: precisions differ" ;
      (t1,t2,p1)

  let during d =
    let t,d,p = date d, duration d, precision d in
      (t,t+d,p)

  let mk_time_pred (a,b,c) =
    let args = List.map (fun x -> "", mk (Int x)) [a;b;c] in
      mk (App (mk (Var "time_in_mod"), args))

# 118 "lang/lang_parser.ml"
let yytransl_const = [|
    0 (* EOF *);
  266 (* BEGIN *);
  267 (* END *);
  268 (* GETS *);
  269 (* TILD *);
  271 (* IF *);
  272 (* THEN *);
  273 (* ELSE *);
  274 (* ELSIF *);
  275 (* LPAR *);
  276 (* RPAR *);
  277 (* COMMA *);
  278 (* SEQ *);
  279 (* LBRA *);
  280 (* RBRA *);
  281 (* LCUR *);
  282 (* RCUR *);
  283 (* FUN *);
  284 (* YIELDS *);
  289 (* MINUS *);
  290 (* NOT *);
  291 (* PP_IFDEF *);
  292 (* PP_ENDIF *);
  293 (* PP_ENDL *);
  294 (* PP_INCLUDE *);
  295 (* PP_DEF *);
    0|]

let yytransl_block = [|
  257 (* VAR *);
  258 (* VARLPAR *);
  259 (* VARLBRA *);
  260 (* STRING *);
  261 (* INT *);
  262 (* FLOAT *);
  263 (* BOOL *);
  264 (* TIME *);
  265 (* INTERVAL *);
  270 (* DEF *);
  285 (* BIN0 *);
  286 (* BIN1 *);
  287 (* BIN2 *);
  288 (* BIN3 *);
  296 (* PP_COMMENT *);
    0|]

let yylhs = "\255\255\
\001\000\003\000\003\000\004\000\004\000\002\000\002\000\002\000\
\002\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
\007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
\007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
\007\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
\005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
\005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
\008\000\012\000\012\000\012\000\013\000\013\000\009\000\009\000\
\009\000\006\000\006\000\006\000\010\000\010\000\010\000\014\000\
\014\000\015\000\015\000\011\000\011\000\011\000\000\000"

let yylen = "\002\000\
\002\000\000\000\001\000\000\000\001\000\002\000\003\000\002\000\
\003\000\002\000\003\000\001\000\002\000\001\000\001\000\001\000\
\001\000\002\000\005\000\001\000\003\000\003\000\003\000\006\000\
\003\000\006\000\003\000\003\000\003\000\003\000\003\000\001\000\
\001\000\003\000\001\000\002\000\001\000\001\000\001\000\001\000\
\002\000\005\000\001\000\003\000\003\000\003\000\006\000\003\000\
\006\000\003\000\003\000\003\000\003\000\003\000\001\000\001\000\
\003\000\003\000\001\000\000\000\003\000\001\000\000\000\001\000\
\003\000\003\000\005\000\007\000\000\000\001\000\003\000\003\000\
\002\000\002\000\000\000\005\000\002\000\000\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\000\000\000\000\039\000\035\000\038\000\
\037\000\056\000\055\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\079\000\000\000\000\000\000\000\040\000\
\000\000\000\000\000\000\000\000\016\000\012\000\015\000\014\000\
\033\000\032\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\017\000\000\000\000\000\020\000\000\000\000\000\
\000\000\000\000\000\000\041\000\000\000\000\000\000\000\000\000\
\000\000\000\000\001\000\003\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\018\000\000\000\000\000\000\000\010\000\000\000\000\000\
\000\000\000\000\000\000\000\000\044\000\000\000\045\000\046\000\
\005\000\000\000\000\000\000\000\000\000\000\000\000\000\034\000\
\000\000\000\000\057\000\048\000\000\000\000\000\000\000\000\000\
\053\000\000\000\007\000\009\000\000\000\021\000\022\000\023\000\
\000\000\011\000\000\000\025\000\000\000\000\000\000\000\000\000\
\030\000\000\000\065\000\000\000\000\000\073\000\000\000\000\000\
\000\000\000\000\000\000\058\000\000\000\000\000\000\000\000\000\
\067\000\000\000\072\000\000\000\071\000\000\000\000\000\000\000\
\042\000\000\000\000\000\019\000\000\000\000\000\077\000\000\000\
\049\000\000\000\026\000\000\000\068\000\000\000\000\000\076\000"

let yydgoto = "\002\000\
\020\000\021\000\066\000\090\000\022\000\023\000\042\000\043\000\
\044\000\093\000\144\000\055\000\045\000\094\000\126\000"

let yysindex = "\007\000\
\184\255\000\000\005\255\218\255\085\002\000\000\000\000\000\000\
\000\000\000\000\000\000\184\255\032\255\184\255\106\255\085\002\
\184\255\000\255\085\002\000\000\029\000\224\255\009\255\000\000\
\085\002\026\255\218\255\085\002\000\000\000\000\000\000\000\000\
\000\000\000\000\184\255\184\255\150\255\184\255\022\255\085\002\
\085\002\149\255\000\000\037\255\039\255\000\000\247\000\067\255\
\081\255\002\255\079\255\000\000\249\254\183\255\072\255\071\255\
\002\255\066\255\000\000\000\000\085\002\085\002\085\002\085\002\
\085\002\184\255\184\255\149\255\085\002\080\255\015\002\090\255\
\086\255\000\000\016\255\078\255\002\255\000\000\066\255\085\002\
\085\002\085\002\085\002\085\002\000\000\218\255\000\000\000\000\
\000\000\184\255\094\255\117\255\099\255\101\255\184\255\000\000\
\085\002\085\002\000\000\000\000\100\255\035\255\235\254\066\255\
\000\000\066\255\000\000\000\000\149\255\000\000\000\000\000\000\
\184\255\000\000\085\002\000\000\103\255\035\255\235\254\066\255\
\000\000\066\255\000\000\113\255\085\002\000\000\094\255\081\255\
\002\255\033\255\044\255\000\000\102\255\033\255\059\255\108\255\
\000\000\149\255\000\000\184\255\000\000\184\255\184\255\116\255\
\000\000\085\002\127\255\000\000\085\002\130\255\000\000\112\255\
\000\000\149\255\000\000\149\255\000\000\184\255\033\255\000\000"

let yyrindex = "\000\000\
\000\000\000\000\103\000\122\255\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\119\255\
\000\000\000\000\000\000\000\000\000\000\233\001\233\001\000\000\
\000\000\023\255\122\255\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\042\255\000\000\000\000\125\255\000\000\000\000\000\000\
\126\002\128\255\000\000\000\000\000\000\137\255\000\000\000\000\
\128\255\171\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\252\001\007\002\165\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\128\255\000\000\001\000\000\000\
\000\000\000\000\000\000\000\000\000\000\122\255\000\000\000\000\
\000\000\000\000\060\255\000\000\000\000\143\255\000\000\000\000\
\000\000\119\255\000\000\000\000\000\000\131\001\097\001\205\000\
\000\000\239\000\000\000\000\000\063\255\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\029\001\137\000\035\000\
\000\000\069\000\000\000\000\000\000\000\000\000\060\255\126\002\
\128\255\138\255\000\000\000\000\000\000\138\255\000\000\000\000\
\000\000\065\255\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\199\001\000\000\063\001\000\000\000\000\138\255\000\000"

let yygindex = "\000\000\
\000\000\248\255\141\000\038\000\000\000\000\000\001\003\004\000\
\231\255\199\255\129\255\070\000\000\000\000\000\040\000"

let yytablesize = 928
let yytable = "\101\000\
\013\000\070\000\091\000\048\000\024\000\051\000\147\000\001\000\
\056\000\082\000\083\000\084\000\096\000\097\000\092\000\024\000\
\025\000\024\000\057\000\117\000\024\000\080\000\081\000\082\000\
\083\000\084\000\072\000\073\000\059\000\076\000\060\000\160\000\
\049\000\050\000\029\000\114\000\115\000\069\000\024\000\024\000\
\077\000\024\000\020\000\020\000\080\000\081\000\082\000\083\000\
\084\000\142\000\143\000\020\000\020\000\020\000\020\000\020\000\
\085\000\107\000\108\000\086\000\123\000\062\000\062\000\145\000\
\081\000\082\000\083\000\084\000\031\000\024\000\024\000\141\000\
\080\000\081\000\082\000\083\000\084\000\088\000\148\000\075\000\
\075\000\124\000\061\000\061\000\074\000\074\000\130\000\080\000\
\081\000\082\000\083\000\084\000\089\000\024\000\095\000\099\000\
\100\000\083\000\024\000\110\000\112\000\113\000\043\000\116\000\
\134\000\125\000\046\000\027\000\028\000\029\000\030\000\031\000\
\032\000\033\000\034\000\035\000\024\000\127\000\128\000\133\000\
\036\000\129\000\136\000\137\000\037\000\052\000\153\000\158\000\
\016\000\146\000\038\000\150\000\039\000\151\000\152\000\149\000\
\028\000\155\000\040\000\041\000\157\000\063\000\060\000\024\000\
\064\000\024\000\024\000\069\000\078\000\159\000\046\000\027\000\
\028\000\029\000\030\000\031\000\032\000\033\000\034\000\035\000\
\059\000\024\000\070\000\067\000\036\000\140\000\139\000\132\000\
\037\000\074\000\036\000\000\000\016\000\000\000\038\000\000\000\
\039\000\080\000\081\000\082\000\083\000\084\000\040\000\041\000\
\003\000\004\000\005\000\006\000\007\000\008\000\009\000\010\000\
\011\000\012\000\000\000\000\000\000\000\013\000\014\000\000\000\
\000\000\000\000\015\000\098\000\052\000\000\000\016\000\000\000\
\017\000\000\000\018\000\080\000\081\000\082\000\083\000\084\000\
\000\000\019\000\026\000\027\000\028\000\029\000\030\000\031\000\
\032\000\033\000\034\000\035\000\000\000\000\000\000\000\000\000\
\036\000\000\000\000\000\000\000\037\000\000\000\054\000\000\000\
\016\000\000\000\038\000\000\000\039\000\060\000\000\000\000\000\
\000\000\000\000\040\000\041\000\061\000\062\000\063\000\064\000\
\065\000\013\000\013\000\013\000\013\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\000\000\000\000\013\000\013\000\
\013\000\013\000\013\000\013\000\013\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\027\000\013\000\013\000\013\000\
\000\000\013\000\013\000\029\000\029\000\029\000\029\000\029\000\
\029\000\029\000\029\000\029\000\029\000\029\000\000\000\000\000\
\029\000\029\000\029\000\029\000\029\000\029\000\029\000\029\000\
\029\000\029\000\029\000\029\000\029\000\029\000\024\000\029\000\
\029\000\029\000\000\000\029\000\029\000\031\000\031\000\031\000\
\031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
\000\000\000\000\031\000\031\000\031\000\031\000\031\000\031\000\
\031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
\051\000\031\000\031\000\031\000\000\000\031\000\031\000\043\000\
\043\000\043\000\043\000\043\000\043\000\043\000\043\000\043\000\
\043\000\043\000\000\000\000\000\043\000\043\000\043\000\043\000\
\043\000\043\000\000\000\000\000\043\000\043\000\000\000\043\000\
\043\000\043\000\050\000\043\000\043\000\043\000\043\000\043\000\
\043\000\028\000\028\000\028\000\028\000\028\000\028\000\028\000\
\028\000\028\000\028\000\028\000\000\000\000\000\028\000\028\000\
\028\000\028\000\028\000\028\000\028\000\028\000\028\000\028\000\
\028\000\028\000\028\000\028\000\066\000\028\000\028\000\000\000\
\000\000\000\000\028\000\036\000\036\000\036\000\036\000\036\000\
\036\000\036\000\036\000\036\000\036\000\036\000\000\000\000\000\
\036\000\036\000\036\000\036\000\036\000\036\000\000\000\000\000\
\036\000\036\000\000\000\036\000\036\000\036\000\047\000\036\000\
\036\000\036\000\000\000\036\000\036\000\052\000\052\000\052\000\
\052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
\000\000\000\000\052\000\052\000\052\000\052\000\052\000\052\000\
\000\000\000\000\052\000\052\000\000\000\052\000\052\000\052\000\
\002\000\052\000\052\000\052\000\000\000\052\000\052\000\054\000\
\054\000\054\000\054\000\054\000\054\000\054\000\054\000\054\000\
\054\000\054\000\000\000\006\000\054\000\054\000\054\000\054\000\
\054\000\054\000\000\000\000\000\054\000\054\000\008\000\054\000\
\054\000\054\000\000\000\054\000\054\000\054\000\087\000\054\000\
\054\000\000\000\000\000\080\000\081\000\082\000\083\000\084\000\
\000\000\000\000\000\000\000\000\000\000\027\000\027\000\027\000\
\027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
\000\000\000\000\027\000\027\000\027\000\027\000\027\000\027\000\
\027\000\027\000\027\000\027\000\027\000\027\000\027\000\027\000\
\000\000\027\000\000\000\000\000\000\000\000\000\027\000\024\000\
\024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
\024\000\024\000\000\000\000\000\024\000\024\000\024\000\024\000\
\024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
\024\000\024\000\000\000\000\000\000\000\000\000\000\000\000\000\
\024\000\051\000\051\000\051\000\051\000\051\000\051\000\051\000\
\051\000\051\000\051\000\051\000\000\000\000\000\051\000\051\000\
\051\000\051\000\051\000\051\000\000\000\000\000\051\000\051\000\
\000\000\051\000\051\000\051\000\000\000\051\000\051\000\000\000\
\000\000\000\000\051\000\050\000\050\000\050\000\050\000\050\000\
\050\000\050\000\050\000\050\000\050\000\050\000\000\000\000\000\
\050\000\050\000\050\000\050\000\050\000\050\000\000\000\000\000\
\050\000\050\000\000\000\050\000\050\000\050\000\000\000\050\000\
\000\000\000\000\000\000\000\000\050\000\066\000\066\000\066\000\
\066\000\066\000\066\000\066\000\066\000\066\000\066\000\066\000\
\000\000\000\000\066\000\066\000\066\000\066\000\066\000\066\000\
\000\000\000\000\066\000\066\000\000\000\066\000\066\000\066\000\
\000\000\000\000\000\000\000\000\000\000\000\000\066\000\047\000\
\047\000\047\000\047\000\047\000\047\000\047\000\047\000\047\000\
\047\000\047\000\000\000\000\000\047\000\047\000\047\000\047\000\
\047\000\047\000\000\000\000\000\047\000\047\000\000\000\047\000\
\047\000\047\000\000\000\000\000\000\000\000\000\000\000\000\000\
\047\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
\002\000\002\000\002\000\002\000\000\000\000\000\002\000\002\000\
\002\000\002\000\002\000\002\000\000\000\000\000\000\000\002\000\
\000\000\002\000\002\000\002\000\000\000\047\000\006\000\000\000\
\000\000\000\000\002\000\006\000\006\000\006\000\000\000\053\000\
\054\000\008\000\000\000\058\000\000\000\006\000\008\000\008\000\
\008\000\068\000\000\000\000\000\071\000\000\000\000\000\000\000\
\008\000\000\000\000\000\000\000\000\000\075\000\111\000\000\000\
\078\000\079\000\000\000\080\000\081\000\082\000\083\000\084\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\102\000\103\000\104\000\
\105\000\106\000\000\000\000\000\000\000\109\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\118\000\119\000\120\000\121\000\122\000\046\000\027\000\028\000\
\029\000\030\000\031\000\032\000\033\000\034\000\035\000\000\000\
\000\000\131\000\054\000\036\000\000\000\000\000\000\000\037\000\
\000\000\000\000\000\000\016\000\000\000\038\000\000\000\039\000\
\000\000\000\000\000\000\135\000\000\000\040\000\041\000\000\000\
\000\000\000\000\000\000\000\000\000\000\138\000\004\000\004\000\
\004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
\000\000\000\000\000\000\004\000\004\000\000\000\000\000\000\000\
\004\000\000\000\154\000\000\000\004\000\156\000\004\000\000\000\
\004\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000"

let yycheck = "\057\000\
\000\000\027\000\001\001\012\000\001\000\014\000\134\000\001\000\
\017\000\031\001\032\001\033\001\020\001\021\001\013\001\012\000\
\012\001\014\000\019\001\077\000\017\000\029\001\030\001\031\001\
\032\001\033\001\035\000\036\000\000\000\038\000\022\001\159\000\
\001\001\002\001\000\000\020\001\021\001\012\001\035\000\036\000\
\019\001\038\000\020\001\021\001\029\001\030\001\031\001\032\001\
\033\001\017\001\018\001\029\001\030\001\031\001\032\001\033\001\
\020\001\066\000\067\000\021\001\086\000\020\001\021\001\020\001\
\030\001\031\001\032\001\033\001\000\000\066\000\067\000\129\000\
\029\001\030\001\031\001\032\001\033\001\011\001\020\001\020\001\
\021\001\090\000\020\001\021\001\020\001\021\001\095\000\029\001\
\030\001\031\001\032\001\033\001\012\001\090\000\016\001\024\001\
\026\001\032\001\095\000\020\001\011\001\016\001\000\000\026\001\
\113\000\012\001\001\001\002\001\003\001\004\001\005\001\006\001\
\007\001\008\001\009\001\010\001\113\000\001\001\020\001\020\001\
\015\001\021\001\020\001\011\001\019\001\020\001\011\001\016\001\
\023\001\028\001\025\001\140\000\027\001\142\000\143\000\028\001\
\000\000\011\001\033\001\034\001\011\001\020\001\024\001\140\000\
\020\001\142\000\143\000\020\001\011\001\158\000\001\001\002\001\
\003\001\004\001\005\001\006\001\007\001\008\001\009\001\010\001\
\024\001\158\000\020\001\023\000\015\001\128\000\127\000\098\000\
\019\001\020\001\000\000\255\255\023\001\255\255\025\001\255\255\
\027\001\029\001\030\001\031\001\032\001\033\001\033\001\034\001\
\001\001\002\001\003\001\004\001\005\001\006\001\007\001\008\001\
\009\001\010\001\255\255\255\255\255\255\014\001\015\001\255\255\
\255\255\255\255\019\001\021\001\000\000\255\255\023\001\255\255\
\025\001\255\255\027\001\029\001\030\001\031\001\032\001\033\001\
\255\255\034\001\001\001\002\001\003\001\004\001\005\001\006\001\
\007\001\008\001\009\001\010\001\255\255\255\255\255\255\255\255\
\015\001\255\255\255\255\255\255\019\001\255\255\000\000\255\255\
\023\001\255\255\025\001\255\255\027\001\022\001\255\255\255\255\
\255\255\255\255\033\001\034\001\029\001\030\001\031\001\032\001\
\033\001\001\001\002\001\003\001\004\001\005\001\006\001\007\001\
\008\001\009\001\010\001\011\001\255\255\255\255\014\001\015\001\
\016\001\017\001\018\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\027\001\000\000\029\001\030\001\031\001\
\255\255\033\001\034\001\001\001\002\001\003\001\004\001\005\001\
\006\001\007\001\008\001\009\001\010\001\011\001\255\255\255\255\
\014\001\015\001\016\001\017\001\018\001\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\027\001\000\000\029\001\
\030\001\031\001\255\255\033\001\034\001\001\001\002\001\003\001\
\004\001\005\001\006\001\007\001\008\001\009\001\010\001\011\001\
\255\255\255\255\014\001\015\001\016\001\017\001\018\001\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\027\001\
\000\000\029\001\030\001\031\001\255\255\033\001\034\001\001\001\
\002\001\003\001\004\001\005\001\006\001\007\001\008\001\009\001\
\010\001\011\001\255\255\255\255\014\001\015\001\016\001\017\001\
\018\001\019\001\255\255\255\255\022\001\023\001\255\255\025\001\
\026\001\027\001\000\000\029\001\030\001\031\001\032\001\033\001\
\034\001\001\001\002\001\003\001\004\001\005\001\006\001\007\001\
\008\001\009\001\010\001\011\001\255\255\255\255\014\001\015\001\
\016\001\017\001\018\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\027\001\000\000\029\001\030\001\255\255\
\255\255\255\255\034\001\001\001\002\001\003\001\004\001\005\001\
\006\001\007\001\008\001\009\001\010\001\011\001\255\255\255\255\
\014\001\015\001\016\001\017\001\018\001\019\001\255\255\255\255\
\022\001\023\001\255\255\025\001\026\001\027\001\000\000\029\001\
\030\001\031\001\255\255\033\001\034\001\001\001\002\001\003\001\
\004\001\005\001\006\001\007\001\008\001\009\001\010\001\011\001\
\255\255\255\255\014\001\015\001\016\001\017\001\018\001\019\001\
\255\255\255\255\022\001\023\001\255\255\025\001\026\001\027\001\
\000\000\029\001\030\001\031\001\255\255\033\001\034\001\001\001\
\002\001\003\001\004\001\005\001\006\001\007\001\008\001\009\001\
\010\001\011\001\255\255\000\000\014\001\015\001\016\001\017\001\
\018\001\019\001\255\255\255\255\022\001\023\001\000\000\025\001\
\026\001\027\001\255\255\029\001\030\001\031\001\024\001\033\001\
\034\001\255\255\255\255\029\001\030\001\031\001\032\001\033\001\
\255\255\255\255\255\255\255\255\255\255\001\001\002\001\003\001\
\004\001\005\001\006\001\007\001\008\001\009\001\010\001\011\001\
\255\255\255\255\014\001\015\001\016\001\017\001\018\001\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\027\001\
\255\255\029\001\255\255\255\255\255\255\255\255\034\001\001\001\
\002\001\003\001\004\001\005\001\006\001\007\001\008\001\009\001\
\010\001\011\001\255\255\255\255\014\001\015\001\016\001\017\001\
\018\001\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\027\001\255\255\255\255\255\255\255\255\255\255\255\255\
\034\001\001\001\002\001\003\001\004\001\005\001\006\001\007\001\
\008\001\009\001\010\001\011\001\255\255\255\255\014\001\015\001\
\016\001\017\001\018\001\019\001\255\255\255\255\022\001\023\001\
\255\255\025\001\026\001\027\001\255\255\029\001\030\001\255\255\
\255\255\255\255\034\001\001\001\002\001\003\001\004\001\005\001\
\006\001\007\001\008\001\009\001\010\001\011\001\255\255\255\255\
\014\001\015\001\016\001\017\001\018\001\019\001\255\255\255\255\
\022\001\023\001\255\255\025\001\026\001\027\001\255\255\029\001\
\255\255\255\255\255\255\255\255\034\001\001\001\002\001\003\001\
\004\001\005\001\006\001\007\001\008\001\009\001\010\001\011\001\
\255\255\255\255\014\001\015\001\016\001\017\001\018\001\019\001\
\255\255\255\255\022\001\023\001\255\255\025\001\026\001\027\001\
\255\255\255\255\255\255\255\255\255\255\255\255\034\001\001\001\
\002\001\003\001\004\001\005\001\006\001\007\001\008\001\009\001\
\010\001\011\001\255\255\255\255\014\001\015\001\016\001\017\001\
\018\001\019\001\255\255\255\255\022\001\023\001\255\255\025\001\
\026\001\027\001\255\255\255\255\255\255\255\255\255\255\255\255\
\034\001\001\001\002\001\003\001\004\001\005\001\006\001\007\001\
\008\001\009\001\010\001\011\001\255\255\255\255\014\001\015\001\
\016\001\017\001\018\001\019\001\255\255\255\255\255\255\023\001\
\255\255\025\001\026\001\027\001\255\255\005\000\011\001\255\255\
\255\255\255\255\034\001\016\001\017\001\018\001\255\255\015\000\
\016\000\011\001\255\255\019\000\255\255\026\001\016\001\017\001\
\018\001\025\000\255\255\255\255\028\000\255\255\255\255\255\255\
\026\001\255\255\255\255\255\255\255\255\037\000\024\001\255\255\
\040\000\041\000\255\255\029\001\030\001\031\001\032\001\033\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\061\000\062\000\063\000\
\064\000\065\000\255\255\255\255\255\255\069\000\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\080\000\081\000\082\000\083\000\084\000\001\001\002\001\003\001\
\004\001\005\001\006\001\007\001\008\001\009\001\010\001\255\255\
\255\255\097\000\098\000\015\001\255\255\255\255\255\255\019\001\
\255\255\255\255\255\255\023\001\255\255\025\001\255\255\027\001\
\255\255\255\255\255\255\115\000\255\255\033\001\034\001\255\255\
\255\255\255\255\255\255\255\255\255\255\125\000\001\001\002\001\
\003\001\004\001\005\001\006\001\007\001\008\001\009\001\010\001\
\255\255\255\255\255\255\014\001\015\001\255\255\255\255\255\255\
\019\001\255\255\146\000\255\255\023\001\149\000\025\001\255\255\
\027\001\255\255\255\255\255\255\255\255\255\255\255\255\034\001"

let yynames_const = "\
  EOF\000\
  BEGIN\000\
  END\000\
  GETS\000\
  TILD\000\
  IF\000\
  THEN\000\
  ELSE\000\
  ELSIF\000\
  LPAR\000\
  RPAR\000\
  COMMA\000\
  SEQ\000\
  LBRA\000\
  RBRA\000\
  LCUR\000\
  RCUR\000\
  FUN\000\
  YIELDS\000\
  MINUS\000\
  NOT\000\
  PP_IFDEF\000\
  PP_ENDIF\000\
  PP_ENDL\000\
  PP_INCLUDE\000\
  PP_DEF\000\
  "

let yynames_block = "\
  VAR\000\
  VARLPAR\000\
  VARLBRA\000\
  STRING\000\
  INT\000\
  FLOAT\000\
  BOOL\000\
  TIME\000\
  INTERVAL\000\
  DEF\000\
  BIN0\000\
  BIN1\000\
  BIN2\000\
  BIN3\000\
  PP_COMMENT\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'exprs) in
    Obj.repr(
# 134 "lang/lang_parser.mly"
                     ( _1 )
# 555 "lang/lang_parser.ml"
               : Lang_values.term))
; (fun __caml_parser_env ->
    Obj.repr(
# 136 "lang/lang_parser.mly"
     ()
# 561 "lang/lang_parser.ml"
               : 's))
; (fun __caml_parser_env ->
    Obj.repr(
# 136 "lang/lang_parser.mly"
               ()
# 567 "lang/lang_parser.ml"
               : 's))
; (fun __caml_parser_env ->
    Obj.repr(
# 137 "lang/lang_parser.mly"
     ()
# 573 "lang/lang_parser.ml"
               : 'g))
; (fun __caml_parser_env ->
    Obj.repr(
# 137 "lang/lang_parser.mly"
               ()
# 579 "lang/lang_parser.ml"
               : 'g))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'cexpr) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 's) in
    Obj.repr(
# 142 "lang/lang_parser.mly"
                             ( _1 )
# 587 "lang/lang_parser.ml"
               : 'exprs))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cexpr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 's) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exprs) in
    Obj.repr(
# 143 "lang/lang_parser.mly"
                             ( mk (Seq (_1,_3)) )
# 596 "lang/lang_parser.ml"
               : 'exprs))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'binding) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 's) in
    Obj.repr(
# 144 "lang/lang_parser.mly"
                             ( let doc,name,def = _1 in
                                 mk (Let (doc,name,def,mk Unit)) )
# 605 "lang/lang_parser.ml"
               : 'exprs))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'binding) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 's) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exprs) in
    Obj.repr(
# 146 "lang/lang_parser.mly"
                             ( let doc,name,def = _1 in
                                 mk (Let (doc,name,def,_3)) )
# 615 "lang/lang_parser.ml"
               : 'exprs))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 154 "lang/lang_parser.mly"
                                     ( mk (App (mk ~pos:(1,1) (Var "~-"),
                                                ["", _2])) )
# 623 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'expr) in
    Obj.repr(
# 156 "lang/lang_parser.mly"
                                     ( _2 )
# 630 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int) in
    Obj.repr(
# 157 "lang/lang_parser.mly"
                                     ( mk (Int _1) )
# 637 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 158 "lang/lang_parser.mly"
                                     ( mk (App (mk ~pos:(1,1) (Var "not"),
                                                ["", _2])) )
# 645 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : bool) in
    Obj.repr(
# 160 "lang/lang_parser.mly"
                                     ( mk (Bool _1) )
# 652 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : float) in
    Obj.repr(
# 161 "lang/lang_parser.mly"
                                     ( mk (Float  _1) )
# 659 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 162 "lang/lang_parser.mly"
                                     ( mk (String _1) )
# 666 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'list) in
    Obj.repr(
# 163 "lang/lang_parser.mly"
                                     ( mk (List _1) )
# 673 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    Obj.repr(
# 164 "lang/lang_parser.mly"
                                     ( mk Unit )
# 679 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'expr) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'expr) in
    Obj.repr(
# 165 "lang/lang_parser.mly"
                                     ( mk (Product (_2,_4)) )
# 687 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 166 "lang/lang_parser.mly"
                                     ( mk (Var _1) )
# 694 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'app_list) in
    Obj.repr(
# 167 "lang/lang_parser.mly"
                                     ( mk (App (mk ~pos:(1,1) (Var _1),_2)) )
# 702 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'expr) in
    Obj.repr(
# 168 "lang/lang_parser.mly"
                                     ( mk (App (mk ~pos:(1,1) (Var "_[_]"),
                                           ["",_2;"",mk ~pos:(1,1) (Var _1)])) )
# 711 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'exprs) in
    Obj.repr(
# 170 "lang/lang_parser.mly"
                                     ( _2 )
# 718 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'arglist) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 172 "lang/lang_parser.mly"
                                     ( mk (Fun (_3,_6)) )
# 726 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'exprs) in
    Obj.repr(
# 173 "lang/lang_parser.mly"
                                     ( mk (Fun ([],_2)) )
# 733 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'exprs) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'exprs) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'if_elsif) in
    Obj.repr(
# 175 "lang/lang_parser.mly"
                                     ( let cond = _2 in
                                       let then_b =
                                         mk ~pos:(3,4) (Fun ([],_4))
                                       in
                                       let else_b = _5 in
                                       let op = mk ~pos:(1,1) (Var "if") in
                                         mk (App (op,["",cond;
                                                      "else",else_b;
                                                      "then",then_b])) )
# 750 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 184 "lang/lang_parser.mly"
                                   ( mk (App (mk ~pos:(2,2) (Var _2),
                                                ["",_1;"",_3])) )
# 760 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 186 "lang/lang_parser.mly"
                                   ( mk (App (mk ~pos:(2,2) (Var _2),
                                                ["",_1;"",_3])) )
# 770 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 188 "lang/lang_parser.mly"
                                   ( mk (App (mk ~pos:(2,2) (Var _2),
                                                ["",_1;"",_3])) )
# 780 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 190 "lang/lang_parser.mly"
                                   ( mk (App (mk ~pos:(2,2) (Var _2),
                                                ["",_1;"",_3])) )
# 790 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'expr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 192 "lang/lang_parser.mly"
                                   ( mk (App (mk ~pos:(2,2) (Var "-"),
                                                ["",_1;"",_3])) )
# 799 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int option list * int option list) in
    Obj.repr(
# 194 "lang/lang_parser.mly"
                                   ( mk_time_pred (between (fst _1) (snd _1)) )
# 806 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int option list) in
    Obj.repr(
# 195 "lang/lang_parser.mly"
                                   ( mk_time_pred (during _1) )
# 813 "lang/lang_parser.ml"
               : 'expr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'expr) in
    Obj.repr(
# 200 "lang/lang_parser.mly"
                                     ( _2 )
# 820 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int) in
    Obj.repr(
# 201 "lang/lang_parser.mly"
                                     ( mk (Int _1) )
# 827 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 202 "lang/lang_parser.mly"
                                     ( mk (App (mk ~pos:(1,1) (Var "not"),
                                                ["", _2])) )
# 835 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : bool) in
    Obj.repr(
# 204 "lang/lang_parser.mly"
                                     ( mk (Bool _1) )
# 842 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : float) in
    Obj.repr(
# 205 "lang/lang_parser.mly"
                                     ( mk (Float  _1) )
# 849 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 206 "lang/lang_parser.mly"
                                     ( mk (String _1) )
# 856 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'list) in
    Obj.repr(
# 207 "lang/lang_parser.mly"
                                     ( mk (List _1) )
# 863 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    Obj.repr(
# 208 "lang/lang_parser.mly"
                                     ( mk Unit )
# 869 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'expr) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'expr) in
    Obj.repr(
# 209 "lang/lang_parser.mly"
                                     ( mk (Product (_2,_4)) )
# 877 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 210 "lang/lang_parser.mly"
                                     ( mk (Var _1) )
# 884 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'app_list) in
    Obj.repr(
# 211 "lang/lang_parser.mly"
                                     ( mk (App (mk ~pos:(1,1) (Var _1),_2)) )
# 892 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'expr) in
    Obj.repr(
# 212 "lang/lang_parser.mly"
                                     ( mk (App (mk ~pos:(1,1) (Var "_[_]"),
                                           ["",_2;"",mk ~pos:(1,1) (Var _1)])) )
# 901 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'exprs) in
    Obj.repr(
# 214 "lang/lang_parser.mly"
                                     ( _2 )
# 908 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'arglist) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 216 "lang/lang_parser.mly"
                                     ( mk (Fun (_3,_6)) )
# 916 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'exprs) in
    Obj.repr(
# 217 "lang/lang_parser.mly"
                                     ( mk (Fun ([],_2)) )
# 923 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'exprs) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'exprs) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'if_elsif) in
    Obj.repr(
# 219 "lang/lang_parser.mly"
                                     ( let cond = _2 in
                                       let then_b =
                                         mk ~pos:(3,4) (Fun ([],_4))
                                       in
                                       let else_b = _5 in
                                       let op = mk ~pos:(1,1) (Var "if") in
                                         mk (App (op,["",cond;
                                                      "else",else_b;
                                                      "then",then_b])) )
# 940 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cexpr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 228 "lang/lang_parser.mly"
                                    ( mk (App (mk ~pos:(2,2) (Var _2),
                                                ["",_1;"",_3])) )
# 950 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cexpr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 230 "lang/lang_parser.mly"
                                    ( mk (App (mk ~pos:(2,2) (Var _2),
                                                ["",_1;"",_3])) )
# 960 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cexpr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 232 "lang/lang_parser.mly"
                                    ( mk (App (mk ~pos:(2,2) (Var _2),
                                                ["",_1;"",_3])) )
# 970 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cexpr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 234 "lang/lang_parser.mly"
                                    ( mk (App (mk ~pos:(2,2) (Var _2),
                                                ["",_1;"",_3])) )
# 980 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 236 "lang/lang_parser.mly"
                                    ( mk (App (mk ~pos:(2,2) (Var "-"),
                                                ["",_1;"",_3])) )
# 989 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int option list * int option list) in
    Obj.repr(
# 238 "lang/lang_parser.mly"
                                   ( mk_time_pred (between (fst _1) (snd _1)) )
# 996 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int option list) in
    Obj.repr(
# 239 "lang/lang_parser.mly"
                                   ( mk_time_pred (during _1) )
# 1003 "lang/lang_parser.ml"
               : 'cexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'inner_list) in
    Obj.repr(
# 242 "lang/lang_parser.mly"
                         ( _2 )
# 1010 "lang/lang_parser.ml"
               : 'list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'expr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'inner_list) in
    Obj.repr(
# 244 "lang/lang_parser.mly"
                           ( _1::_3 )
# 1018 "lang/lang_parser.ml"
               : 'inner_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 245 "lang/lang_parser.mly"
                           ( [_1] )
# 1025 "lang/lang_parser.ml"
               : 'inner_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 246 "lang/lang_parser.mly"
                           ( [] )
# 1031 "lang/lang_parser.ml"
               : 'inner_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 249 "lang/lang_parser.mly"
                  ( _1,_3 )
# 1039 "lang/lang_parser.ml"
               : 'app_list_elem))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 250 "lang/lang_parser.mly"
                  ( "",_1 )
# 1046 "lang/lang_parser.ml"
               : 'app_list_elem))
; (fun __caml_parser_env ->
    Obj.repr(
# 254 "lang/lang_parser.mly"
                                 ( [] )
# 1052 "lang/lang_parser.ml"
               : 'app_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'app_list_elem) in
    Obj.repr(
# 255 "lang/lang_parser.mly"
                                 ( [_1] )
# 1059 "lang/lang_parser.ml"
               : 'app_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'app_list_elem) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'app_list) in
    Obj.repr(
# 256 "lang/lang_parser.mly"
                                 ( _1::_3 )
# 1067 "lang/lang_parser.ml"
               : 'app_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 259 "lang/lang_parser.mly"
                  (
       let body = _3 in
         (Doc.none (),[]),_1,body
    )
# 1078 "lang/lang_parser.ml"
               : 'binding))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Doc.item * (string*string) list) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'g) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'exprs) in
    Obj.repr(
# 263 "lang/lang_parser.mly"
                        (
      let body = _4 in
        _1,_2,body
    )
# 1091 "lang/lang_parser.ml"
               : 'binding))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : Doc.item * (string*string) list) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'arglist) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : 'g) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'exprs) in
    Obj.repr(
# 267 "lang/lang_parser.mly"
                                         (
      let arglist = _3 in
      let body = mk (Fun (arglist,_6)) in
        _1,_2,body
    )
# 1106 "lang/lang_parser.ml"
               : 'binding))
; (fun __caml_parser_env ->
    Obj.repr(
# 274 "lang/lang_parser.mly"
                      ( [] )
# 1112 "lang/lang_parser.ml"
               : 'arglist))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'arg) in
    Obj.repr(
# 275 "lang/lang_parser.mly"
                      ( [_1] )
# 1119 "lang/lang_parser.ml"
               : 'arglist))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arg) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arglist) in
    Obj.repr(
# 276 "lang/lang_parser.mly"
                      ( _1::_3 )
# 1127 "lang/lang_parser.ml"
               : 'arglist))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'opt) in
    Obj.repr(
# 278 "lang/lang_parser.mly"
                 ( _2,_2,
                   T.fresh_evar ~level:(-1) ~pos:(Some (curpos ~pos:(2,2) ())),
                   _3 )
# 1137 "lang/lang_parser.ml"
               : 'arg))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'opt) in
    Obj.repr(
# 281 "lang/lang_parser.mly"
                 ( "",_1,
                   T.fresh_evar ~level:(-1) ~pos:(Some (curpos ~pos:(1,1) ())),
                   _2 )
# 1147 "lang/lang_parser.ml"
               : 'arg))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'expr) in
    Obj.repr(
# 285 "lang/lang_parser.mly"
              ( Some _2 )
# 1154 "lang/lang_parser.ml"
               : 'opt))
; (fun __caml_parser_env ->
    Obj.repr(
# 286 "lang/lang_parser.mly"
              ( None )
# 1160 "lang/lang_parser.ml"
               : 'opt))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'exprs) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'exprs) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'if_elsif) in
    Obj.repr(
# 289 "lang/lang_parser.mly"
                                    ( let cond = _2 in
                                      let then_b =
                                        mk ~pos:(3,4) (Fun ([],_4))
                                      in
                                      let else_b = _5 in
                                      let op = mk ~pos:(1,1) (Var "if") in
                                        mk (Fun ([],
                                          mk (App (op,["",cond;
                                                       "else",else_b;
                                                       "then",then_b])))) )
# 1178 "lang/lang_parser.ml"
               : 'if_elsif))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'exprs) in
    Obj.repr(
# 299 "lang/lang_parser.mly"
                                    ( mk ~pos:(1,2) (Fun([],_2)) )
# 1185 "lang/lang_parser.ml"
               : 'if_elsif))
; (fun __caml_parser_env ->
    Obj.repr(
# 300 "lang/lang_parser.mly"
                                    ( mk (Fun ([],mk Unit)) )
# 1191 "lang/lang_parser.ml"
               : 'if_elsif))
(* Entry scheduler *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let scheduler (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : Lang_values.term)
