DACS_INFOCARD(8)           DACS Web Services Manual           DACS_INFOCARD(8)



[1mNAME[0m
       dacs_infocard - Information Card administration

[1mSYNOPSIS[0m
       [1mdacs_infocard [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacs_infocard [22mweb service is used:

       +o   to perform a variety of administrative InfoCard functions;

       +o   as a Relying Party to register a self-issued InfoCard, creating an
           account that can be used for authentication. InfoCard-based
           authentication is performed by [34m[1mlocal_infocard_authenticate[0m[1m[22m[2], a
           [1mDACS [22mauthentication module. These accounts are used only by
           [1mlocal_infocard_authenticate [22mand are completely separate from any
           other accounts.

       +o   to act on behalf of a Relying Party to validate and extract claim
           values from a secure token created from either a self-issued or
           managed InfoCard.


           [1mNotes[0m
           +o   Many Identity Selectors can create a self-issued InfoCard, but
               you must use [34m[1mdacs_managed_infocard(8)[0m[1m[22m[3] to create a managed
               InfoCard.

           +o   If a Relying Party checks that the security token that it
               receives satisfies the validity window condition expressed by
               the token, as it typically will, then the system clocks at the
               IP/STS (e.g., [34m[1mdacs_sts(8)[0m[1m[22m[4]) and Relying Party must be
               adequately synchronized; see [34m[1mINFOCARD_TOKEN_DRIFT_SECS[0m[1m[22m[5].

           +o   Owing to the InfoCard system architecture, a Relying Party need
               not have network connectivity to a user's IP/STS (e.g.,
               [34m[1mdacs_sts(8)[0m[1m[22m[4]), although the user's browser must. This means,
               for example, that if a user (or his organization) operates his
               own IP/STS, it can be located on the same side of a firewall as
               the user's browser, which may improve the level of security of
               the IP/STS and any sensitive information it may store and
               access.

           +o   Much of the functionality of this program is also available as
               a [1mDACS [22mutility, [34m[1mdacsinfocard(1)[0m[1m[22m[6], which operates on the same
               account files.


       Accounts are accessed through [1mDACS's [22mvirtual filestore using item type
       infocards.

           [1mNote[0m
           The official nomenclature for claims can be confusing. In an
           attempt at consistency and simplification, the [1mDACS [22mdocumentation
           tries to adhere to the following definitions (with the stated
           compile-time limits):

           Claim
               A pair comprising an attribute name (the Claim type) and an
               attribute value (the Claim value). The attribute value is
               optional. The number of claims is limited to [1m10 [22mstatic claims
               and [1m20 [22mdynamic claims.

           Claim type
               A unique [34m[1mURI[0m[1m[22m[7] that consists of a Claim URI prefix followed by
               a Claim name. This can be thought of as an attribute name.
               [1mDACS [22mdoes not allow the URI to include a query or fragment
               component. A claim type is never dereferenced, it is merely a
               label. Only characters that are valid in a URI are allowed;
               therefore any invalid characters must be properly encoded.
               Claim types are case sensitive, despite the fact that they are
               URIs. There is a compile-time length limit: [1m128 [22mcharacters for
               the URI prefix and [1m32 [22mcharacters for the claim name.

           Claim URI prefix
               This URI identifies a namespace in which the Claim name lives
               (it may not include a query or fragment component). Two
                [34m[1mclaim types[0m[1m[22m[8] with different URI prefixes but the same claim
               name are distinct. The InfoCard specification uses the
               namespace http://schemas.xmlsoap.org/ws/2005/05/identity/claims
               for self-issued claims.  [1mDACS [22muses the namespace
               http://dacs.dss.ca/claims for its claims. These namespaces
               should be treated as "reserved". User-defined claims should
               live in other namespaces, preferably ones over which the user
               has some authority.

           Claim URI prefix abbreviation
               To avoid the tedious and error-prone task of having to
               repeatedly enter long Claim URI prefix strings, in designated
               contexts [1mDACS [22mrecognizes (but never requires) an abbreviation.
               Two case-sensitive abbreviations are defined: "standard"
               (equivalent to
               http://schemas.xmlsoap.org/ws/2005/05/identity/claims) and
               "dacs" (equivalent to http://dacs.dss.ca/claims).

           Claim name
               This is a URI path component. When appended to a Claim URI
               prefix (or paired with a Claim URI prefix abbreviation), it
               forms a Claim type. Only characters that are valid in a URI
               path component are allowed. It is limited to [1m32 [22mcharacters.

           Claim value
               This can be thought of as an attribute value. Technically, this
               is defined as an [34m[1mxs:string[0m[1m[22m[9], which is a sequence of [34m[1mXML[0m
               [1m[34mcharacters[0m[1m[22m[10]. Claim values are limited to [1m64 [22mcharacters.

[1mOPTIONS[0m
   [1mWeb Service Arguments[0m
       In addition to the [34m[1mstandard CGI arguments[0m[1m[22m[11], [1mdacs_infocard[0m
       understands the following CGI arguments:


       [4mOPERATION[0m
           The following operations are supported:

           +o   [4mDELETE[0m

               Delete the account associated with [4mUSERNAME[24m. This effectively
               revokes the InfoCard; a self-issued InfoCard may be
               re-registered, but a managed InfoCard becomes unusable.

                   [1mNote[0m
                   The quickest way to delete [4mall[24m accounts is to delete the
                   contents of the infocards item type; e.g., if infocards
                   points to a file, remove the file or copy /dev/null to it.

           +o   [4mDISABLE[0m

               Disable the account associated with [4mUSERNAME[24m. InfoCard-based
               authentication on this account will fail; this revokes the
               InfoCard, but in a reversible way. The request is successful if
               the account is already disabled.

           +o   [4mENABLE[0m

               Enable the existing account associated with [4mUSERNAME[24m.
               InfoCard-based authentication on this account will be possible.
               The request is successful if the account is already enabled.

           +o   [4mLIST[0m

               List all accounts.

           +o   [4mREGISTER[0m

               Register or re-register the submitted InfoCard. Exactly one set
               of credentials must accompany the request, and if registration
               is successful, the submitted InfoCard becomes associated with
               that identity.

           +o   [4mTOKEN_ATTRVALS[0m

               If the submitted token is valid, display each claim (attribute)
               value associated with the [4mATTRLIST[24m argument, which consists of
               zero or more claim names separated by a space. If [4mATTRLIST[24m is
               absent or the empty string, all claims in the token are
               displayed (note that this is not necessarily all of the claims
               associated with the InfoCard). If any requested claim is not
               found, the request is ignored (i.e., it is not an error). The
               privatepersonalidentifier claim is displayed in the friendly
               identifier syntax rather than as a base-64 encoded string. The
               InfoCard (self-issued or managed) does not need to be
               registered at the jurisdiction.

               Three syntaxes are recognized for a claim name. Some claims are
               "predefined" in that they are available in any valid token:
               issuer, confirm_method, ppid (or privatepersonalidentifier),
               exponent (self-issued only), and modulus (self-issued only).
               The second syntax is the full claim URI (e.g.,
               http://schemas.xmlsoap.org/ws/2005/05/identity/claims/webpage).
               The third syntax uses the [1mDACS [22mshorthand: the word "standard"
               or "dacs", a colon, and the claim name (e.g.,
               standard:webpage). The token is searched for each claim in the
               [4mATTRLIST[24m, other than the predefined ones.

                   [1mNote[0m
                   Only the full URI syntax can be used to identify claims in
                   an HTML OBJECT's [4mrequiredClaims[24m and [4moptionalClaims[24m param
                   tag.

           +o   [4mTOKEN_VALIDATE[0m

               Parse the submitted token and test whether it is valid.

           [4mxmlToken[0m
           [4mAUXILIARY[0m
               This is the submitted InfoCard. It is required for the
               [4mTOKEN_VALIDATE[24m, [4mTOKEN_ATTRVALS[24m, and [4mREGISTER[24m operations. The
               [4mAUXILIARY[24m parameter name may only be used for this purpose if
               the [4mxmlToken[24m parameter name is not also used.

           [4mFORMAT[0m
               By default, output is emitted in HTML. Several varieties of XML
               output can be selected, however, using the [4mFORMAT[24m argument
               (please refer to [34m[1mdacs(1)[0m[1m[22m[12] and [34m[1mdacs_passwd.dtd[0m[1m[22m[13]). A [4mFORMAT[0m
               of plain may be useful for programs that need to extract claim
               values; claims are listed one per line with the claim type,
               followed by an "=", followed by the claim value.

           [4mUSERNAME[0m
               For some operations, the name of the account to act on.

           For the [4mDELETE[24m, [4mDISABLE[24m, and [4mENABLE[24m operations, the request must be
           submitted by the account's owner or the [1mDACS [22madministrator.

           Here is an example of a form that might be used to register a
           self-issued InfoCard:

               <form name="reg_form" id="reg_form" method="post" action="/cgi-bin/dacs/dacs_infocard">
               <table>
               <tr>
               <td>
                <img src="/infocards/ic_image.jpg" onClick="reg_form.submit()"/>
               <object type="application/x-informationCard" name="xmlToken">
                <param name="tokenType" value="urn:oasis:names:tc:SAML:1.0:assertion">
                <param name="issuer" value="http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self">
                <param name="requiredClaims"
                 value="http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier">
                <param name="privacyUrl" value="https://example.com/infocards/privacy_statement.txt">
                <param Name="privacyVersion" value="3">
               </object>
               </td>
               </tr>
               <tr>
               <td align="center">
                <input type="submit" name="infocard_register" value="Register" id="infocard_register" />
               </td>
               <td>
               </td>
               </table>
               <input type="hidden" name="OPERATION" value="REGISTER">
               </form>



[1mFILES[0m
       [34m[1mdacs_infocard.css[0m[1m[22m[14]

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mBUGS[0m
       The compile-time limits are fairly arbitrary and only exist to thwart
       abuse. It should probably be possible to specify them at run-time
       instead.

       XML output is not available yet.

       Registration of a self-issued InfoCard uses the card's PPID (Private
       Personal Identifier), which differs for a given InfoCard for different
       Relying Parties. The specification does not precisely define how two
       Relying Party endpoints are compared for equality, but if an identity
       selector decides that a jurisdiction's endpoint has changed (e.g., its
       domain name has been reconfigured), all self-issued InfoCards
       previously registered at the jurisdiction will become unusable until
       they are re-registered.

       This functionality should be integrated with [34m[1mdacs_admin(8)[0m[1m[22m[15].

[1mSEE ALSO[0m
       [34m[1mdacsinfocard(1)[0m[1m[22m[6], [34m[1mdacs.conf(5)[0m[1m[22m[16], [34m[1mdacs_authenticate(8)[0m[1m[22m[17],
       [34m[1mdacs_managed_infocard(8)[0m[1m[22m[3], [34m[1mUsing InfoCards With DACS[0m[1m[22m[18]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[19])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[20] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_infocard_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_infocard_authenticate

        3. dacs_managed_infocard(8)
           http://dacs.dss.ca/man/dacs_managed_infocard.8.html

        4. dacs_sts(8)
           http://dacs.dss.ca/man/dacs_sts.8.html

        5. INFOCARD_TOKEN_DRIFT_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_TOKEN_DRIFT_SECS

        6. dacsinfocard(1)
           http://dacs.dss.ca/man/dacsinfocard.1.html

        7. URI
           http://www.rfc-editor.org/rfc/rfc3986.txt

        8. claim types
           http://dacs.dss.ca/man/#claim_types

        9. xs:string
           http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/datatypes.html#string

       10. XML characters
           http://www.w3.org/TR/2000/WD-xml-2e-20000814#NT-Char

       11. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       12. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       13. dacs_passwd.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_passwd.dtd

       14. dacs_infocard.css
           http://dacs.dss.ca/man//css/dacs_infocard.css

       15. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       16. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       17. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       18. Using InfoCards With DACS
           http://dacs.dss.ca/man/using-infocards-with-dacs.html

       19. www.dss.ca
           http://www.dss.ca

       20. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                  DACS_INFOCARD(8)
