#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include "interface.h"

#include "treedata.h"

global_data globals;

extern tree_duplicate();
extern tree_initialize();
extern tree_free();

void catch(sig,code,scp,addr)
int sig,code;
struct sigcontext *scp;
char *addr;
{
	if(sig==SIGINT)
	{
		if(quit(NULL))
			exit(0);
	}
	else
	{
		psignal(sig, "Treetool received signal");
		if(sig==SIGBUS || sig==SIGSEGV)
		{
			fprintf(stderr, "Non-recoverable Error!\n");
			fprintf(stderr, "Programmer commits suicide!\n");
			if(number_of_trees()>=1)
			{
				if(number_of_trees()==1)
					fprintf(stderr,
						"    Saving tree in file 'treetool.crash'\n");
				else
					fprintf(stderr,
						"    Saving trees in file 'treetool.crash'\n");
				fprintf(stderr, "    To recover your data, type the command ");
				fprintf(stderr, "'%s treetool.crash'\n", globals->argv[0]);
				do_save("treetool.crash", Treetool);
			}
			else
				fprintf(stderr, "No trees to save, so quitting\n");
			exit(0);
		}
	}
}

show_filename()
{
	char buf[80];

	sprintf(buf, "Treetool: %s", shortname(globals->filename));
	if(globals->modified)
		strcat(buf, "  (modified)");
	set_main_frame_name(buf);
}

change_filename(s)
char *s;
{
	if(globals->filename!=NULL)
		free(globals->filename);
	globals->filename=(char *)strdup(s);
	globals->filename_specified=1;
	show_filename();
	save_change_filename(globals->filename, Treetool);
}

set_all_busy()
{
	about_busy();
	find_busy();
	help_busy();
	branch_busy();
	node_busy();
	scale_busy();
	tree_busy();
	load_busy();
	save_busy();
	main_busy();
	globals_busy();
	print_busy();
}

set_all_notbusy()
{
	about_notbusy();
	find_notbusy();
	help_notbusy();
	branch_notbusy();
	node_notbusy();
	scale_notbusy();
	tree_notbusy();
	load_notbusy();
	save_notbusy();
	main_notbusy();
	globals_notbusy();
	print_notbusy();
	set_tool_cursor(globals->mode);
}

print_command_help()
{
printf("usage: treetool [filename] [-h] [-phenogram] [-radial] [-[no]auto]\n");
printf("                [-[no]merge]\n");
printf("   -h          -> prints out this help message\n");
printf("   -phenogram  -> specifies phenogram (boxed) tree format (or -p)\n");
printf("   -radial     -> specifies radial (flower) tree format   (or -r)\n");
printf("   -auto       -> start with automatic formatting\n");
printf("   -noauto     -> start without automatic formatting\n");
printf("   -merge      -> start with automatic node merging\n");
printf("   -nomerge    -> start without automatic node merging\n");
printf("For more info, start treetool with no arguments, and select\n");
printf("the menu item 'Help...' from the 'Help' menu.\n");
}

parse_treetool_args(argc, argv)
int argc;
char **argv;
{
	int i;
	char full[1024];

	i=1;
	while(i<argc)
	{
		if(argv[i][0]=='-')
		{
				/* it's an option */
			if(strcmp(argv[i], "-phenogram")==0 ||
					strcmp(argv[i], "-p")==0)
			{
				globals->type=Boxed;
				i++;
			}
			else if(strcmp(argv[i], "-radial")==0 ||
					strcmp(argv[i], "-r")==0)
			{
				globals->type=Flower;
				i++;
			}
			else if(strcmp(argv[i], "-nobuffer")==0)
			{
				globals->usebuffer=0;
				i++;
			}
			else if(strcmp(argv[i], "-buffer")==0)
			{
				globals->usebuffer=1;
				i++;
			}
			else if(strcmp(argv[i], "-auto")==0)
			{
				globals->autoformat=1;
				i++;
			}
			else if(strcmp(argv[i], "-merge")==0)
			{
				globals->automerge=1;
				i++;
			}
			else if(strcmp(argv[i], "-noauto")==0)
			{
				globals->autoformat=0;
				i++;
			}
			else if(strcmp(argv[i], "-nomerge")==0)
			{
				globals->automerge=0;
				i++;
			}
			else if(strcmp(argv[i], "-h")==0)
			{
				print_command_help();
				exit(0);
			}
			else
			{
				printf("Unrecognized option: %s\n", argv[i]);
				print_command_help();
				exit(0);
			}
		}
		else
		{
			/* possible filename */
			longname(argv[i], full);
			addnode(globals->filenames, strdup(full));
			change_filename(full);
			i++;
		}
	}
}

void modify()
{
	globals->modified=1;
}

void unmodify()
{
	globals->modified=0;
}

main(argc, argv, envp)
int argc;
char **argv;
char **envp;
{
#ifdef DEBUG
	chdir("/home/lab/mooch/dvlp/t4/trees");
#endif
	globals=(global_data)malloc(sizeof(global_datad));
	if(globals==NULL)
	{
		printf("No memory for global data...");
		exit(1);
	}

    fill_in_strings();

	globals->sel_type=NoSel;
	globals->selection=NULL;
	globals->clip_type=NULL;
	globals->clipboard=NULL;
	globals->filename=(char *)strdup("Untitled");
	globals->filenames=newlist();
	globals->filename_specified=0;
	globals->modified=0;
	globals->handles=1;
	globals->pagelines=0;
	globals->beeping=1;
	globals->autoformat=0;
	globals->automerge=0;
	globals->usebuffer=0;
    globals->args=targs_parse(&argc, argv);
	globals->error_string=NULL;
	globals->error=NoError;
	globals->scale=1.0;
	globals->px=0;
	globals->py=0;
	globals->mode=MouseNoMode;
	globals->bt=RoomForGroup;
	globals->type=Boxed;
	globals->argc=argc;
	globals->argv=argv;
	globals->envp=envp;


	init_trees();

	tree_set_dup(tree_duplicate);
	tree_set_free(tree_free);
	tree_set_init(tree_initialize);

    tinitialize(globals->args);

	parse_treetool_args(argc, argv);

    if(!create_main_frame(globals->args))
	{
		printf("Could not contact server.\n");
		exit(1);
	}
	init_selection();

	if(globals->filename_specified)
	{
		char *name;
		setloc(globals->frame, 10, 10);
		startlist(globals->filenames);
		while((name=listnext(globals->filenames))!=NULL)
		{
			do_command(Load, name, NULL, 0.0, 0.0, Treetool, 0, 0, 0, 0);
			free(name);
		}
		freelist(globals->filenames);
	}
	change_editing_mode(MouseTree);

	signal(SIGBUS, catch);
	signal(SIGSEGV, catch);
	signal(SIGINT, catch);
    off_and_running();
}
