#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* infotree.c:
 *
 * manages the Tree Info window, that allows the user to modify attributes
 * of the currently selected tree
 */

#include "interface.h"

#include "treedata.h"

static tframe info;
static tpanel p;
static tpmsg omsg;
static tpchoice tree_type_menu;
static tpitem tree_type_items[NoTreeType];
static tpmsg ttmsg;
static tpcheck scale_bar, show_internal_names, show_terminal_names;
static tpmsg spacer;

/* callbacks for changing various aspects of the tree.  These just call the
 * appropriate command on every selected tree */
int tree_info_choose_type(c, i)
tpchoice c;
tpitem i;
{
	tree_type j;

	j=(tree_type)titem_get_data(i);
	globals->type=j;
	do_command(EveryTree, NULL, NULL, 0.0, 0.0, j, 0, 0, 0,
		SetTreeFormat);
}

int tree_info_show_scale_bar(c, e, v)
tpcheck c;
tevent e;
int v;
{
    if(v)
		do_command(EveryTree, NULL, NULL, 0.0, 0.0,
			0, 0, 0, 0, ShowScaleBar);
    else
		do_command(EveryTree, NULL, NULL, 0.0, 0.0,
			0, 0, 0, 0, HideScaleBar);
}

int tree_info_show_internal_names(c, e, v)
tpcheck c;
tevent e;
int v;
{
    if(v)
		do_command(EveryTree, NULL, NULL, 0.0, 0.0,
			0, 0, 0, 0, ShowInternalNames);
    else
		do_command(EveryTree, NULL, NULL, 0.0, 0.0,
			0, 0, 0, 0, HideInternalNames);
}

int tree_info_show_terminal_names(c, e, v)
tpcheck c;
tevent e;
int v;
{
    if(v)
		do_command(EveryTree, NULL, NULL, 0.0, 0.0,
			0, 0, 0, 0, ShowTerminalNames);
    else
		do_command(EveryTree, NULL, NULL, 0.0, 0.0,
			0, 0, 0, 0, HideTerminalNames);
}

int create_tree_info_frame(parent, args)
tframe parent;
targs args;
{
	int i;

    info=tframe_new(parent, 580,100,50,50,0,1,0,
		"Treetool:Tree Settings", args);
    if(info==NULL)
		return(0);
    p=tframe_dialog_panel(info);
    if(p==NULL)
		return(0);

	/* create tree format menu */
    ttmsg=(tpmsg)tpmsg_new(p, 10, 10, 0, 0, NULL, NULL,
		"Tree Format:");
	tree_type_menu=(tpchoice)tpchoice_new(p, 10, 10, 0, 0, ttmsg, NULL,
		"Format", 1);
	/* add names for various tree formats */
	for(i=0;i<NoTreeType;i++)
	{
		tree_type_items[i]=(tpitem)tpitem_new(globals->tree_type_strings[i],
			tree_info_choose_type);
		tpchoice_add(tree_type_menu, tree_type_items[i], NULL);
		titem_set_data(tree_type_items[i], i);
	}
	tpchoice_set_default_item(tree_type_menu, 0);
	tpchoice_select_item(tree_type_menu, tree_type_items[0]);
	spacer=(tpmsg)tpmsg_new(p, 10, 10, 0, 0, NULL, tree_type_menu, "  ");
    omsg=(tpmsg)tpmsg_new(p, 10, 10, 0, 0, NULL, spacer,
		"Tree Display Options:");
	/* checkbox for whether to display scale bar */
    scale_bar=tpcheck_new(p, 10, 10, 0, 0, NULL, omsg,
		"Show Scale Bar");
    tpcheck_set_event_procedure(scale_bar, tree_info_show_scale_bar);
	/* checkbox for whether to show internal names */
    show_internal_names=tpcheck_new(p, 10, 0, 0, 0, NULL, scale_bar,
		"Show Internal Names");
    tpcheck_set_event_procedure(show_internal_names,
		tree_info_show_internal_names);
	/* checkbox for whether to show terminal names */
    show_terminal_names=tpcheck_new(p, 10, 0, 0, 0, NULL, show_internal_names,
		"Show Terminal Names");
    tpcheck_set_event_procedure(show_terminal_names,
    	tree_info_show_terminal_names);
    tpanel_fit(p);
    tframe_fit(info);
    tframe_hide(info);
    return(1);
}

int update_tree_info_frame(t)
	/* update the frame to express the attributes of the specified tree */
tree t;
{
	tpchoice_select_item(tree_type_menu, tree_type_items[tdta(t)->type]);
    if(tdta(t)->td->showpct)
		tpcheck_set(scale_bar);
    else
		tpcheck_unset(scale_bar);
    if(tdta(t)->td->showinternals)
		tpcheck_set(show_internal_names);
    else
		tpcheck_unset(show_internal_names);
    if(tdta(t)->td->showterminals)
		tpcheck_set(show_terminal_names);
    else
		tpcheck_unset(show_terminal_names);
}

int show_tree_info_frame()
{
	moveframetoloc(info);
    tframe_show(info);
}

int hide_tree_info_frame()
{
    tframe_hide(info);
}

int enable_tree_type_menu()
{
	tpmsg_enable(ttmsg);
	tpchoice_enable(tree_type_menu);
}

int disable_tree_type_menu()
{
	tpmsg_disable(ttmsg);
	tpchoice_disable(tree_type_menu);
}

tree_busy()
{
	if(info!=NULL)
		tframe_set_busy(info);
}

tree_notbusy()
{
	if(info!=NULL)
		tframe_set_notbusy(info);
}

grey_tree_info(numtrees, clip, multi, subtrees, nodes, branches)
	/* grey out items that don't apply, depending on the current selection */
int numtrees, clip, multi, subtrees, nodes, branches;
{
	if(branches || nodes || subtrees)
	{
		tpmsg_enable(ttmsg);
		tpchoice_enable(tree_type_menu);
		tpcheck_enable(show_internal_names);
		tpcheck_enable(show_terminal_names);
		tpcheck_enable(scale_bar);
	}
	else
	{
		tpmsg_disable(ttmsg);
		tpchoice_disable(tree_type_menu);
		tpcheck_disable(show_internal_names);
		tpcheck_disable(show_terminal_names);
		tpcheck_disable(scale_bar);
	}
}
