#include <stdio.h>

#include "generic.h"

typedef struct {
	ltgenericd g;
	} tgend, *tgen;

titem titem_parent(t)
tgen t;
{
	return(t->g.parent);
}

int titem_set_parent(t)
tgen t;
{
	t->g.parent=t;
	return(1);
}

item_type titem_type(t)
tgen t;
{
	return(t->g.what);
}

titem titem_new(parent,t,size)
tgen parent;
item_type t;
int size;
{
	tgen tmp;

	tmp=(tgen)malloc(size);
	if(tmp==NULL)	
		return(NULL);
	tmp->g.what=t;
	tmp->g.parent=parent;
	tmp->g.data=NULL;
	tmp->g.intdata=NULL;
	return(tmp);
}

int titem_free(i)
tgen i;
{
	if(i!=NULL)
	{
		free(i);
		return(1);
	}
	else
		return(0);
}

void *titem_get_data(t)
tgen t;
{
	return(t->g.data);
}

int titem_set_data(t, d)
tgen t;
void *d;
{

	t->g.data=d;
	return(1);
}

void *titem_get_intdata(t)
tgen t;
{
	return(t->g.intdata);
}

int titem_set_intdata(t, d)
tgen t;
void *d;
{

	t->g.intdata=d;
	return(1);
}

int tp_right_side(t)
tgen t;
{
	int x;

	if(t==NULL)
		return(0);

	switch(t->g.what)
	{
		case lt_pcheck:
			x=tpcheck_right_side(t)+5;
			break;
		case lt_pbutton:
			x=tpbutton_right_side(t)+5;
			break;
		case lt_pslider:
			x=tpslider_right_side(t)+5;
			break;
		case lt_pstack:
			x=tpstack_right_side(t)+5;
			break;
		case lt_pchoice:
			x=tpchoice_right_side(t)+5;
			break;
		case lt_ptext:
			x=tptext_right_side(t)+5;
			break;
		case lt_pmsg:
			x=tpmsg_right_side(t)+5;
			break;
		case lt_pmenu:
			x=tpmenu_right_side(t)+5;
			break;
		default:
			x=0;
			break;
	}
	return(x);
}

int tp_bottom_side(t)
tgen t;
{
	int x;

	if(t==NULL)
		return(0);

	switch(t->g.what)
	{
		case lt_pcheck:
			x=tpcheck_bottom_side(t)+5;
			break;
		case lt_pbutton:
			x=tpbutton_bottom_side(t)+5;
			break;
		case lt_pslider:
			x=tpslider_bottom_side(t)+5;
			break;
		case lt_pchoice:
			x=tpchoice_bottom_side(t)+5;
			break;
		case lt_pstack:
			x=tpstack_bottom_side(t)+5;
			break;
		case lt_ptext:
			x=tptext_bottom_side(t)+5;
			break;
		case lt_pmsg:
			x=tpmsg_bottom_side(t)+5;
			break;
		case lt_pmenu:
			x=tpmenu_bottom_side(t)+5;
			break;
		default:
			x=0;
			break;
	}
	return(x);
}

int tright_side(t)
tgen t;
{
	int x;
	switch(t->g.what)
	{
		case lt_canvas:
			x=tcanvas_right_side(t);
			break;
		case lt_panel:
			x=tpanel_right_side(t);
			break;
		case lt_list:
			x=tlist_right_side(t);
			break;
		default:
			x=0;
			break;
	}
	return(x);
}

int tbottom_side(t)
tgen t;
{
	int x;
	switch(t->g.what)
	{
		case lt_canvas:
			x=tcanvas_bottom_side(t);
			break;
		case lt_panel:
			x=tpanel_bottom_side(t);
			break;
		case lt_list:
			x=tlist_bottom_side(t);
			break;
		default:
			x=0;
			break;
	}
	return(x);
}

tdisplay titem_display(t)
tgen t;
{
	tdisplay x;
	switch(t->g.what)
	{
		case lt_canvas:
			x=(tdisplay)tcanvas_display(t);
			break;
		case lt_panel:
			x=(tdisplay)tpanel_display(t);
			break;
		case lt_frame:
			x=(tdisplay)tframe_display(t);
			break;
		case lt_list:
			x=(tdisplay)tlist_display(t);
			break;
		case lt_display:
			x=(tdisplay)t;
			break;
		default:
			x=NULL;
			break;
	}
	return(x);
}

void *titem_drawable(t)
tgen t;
{
	void *x;
	switch(t->g.what)
	{
		case lt_canvas:
			x=(void *)tcanvas_drawable(t);
			break;
		case lt_panel:
			x=(void *)tpanel_drawable(t);
			break;
		case lt_list:
			x=(void *)tlist_drawable(t);
			break;
		case lt_frame:
			x=(void *)tframe_drawable(t);
			break;
		default:
			x=(void *)NULL;
			break;
	}
	return(x);
}

void *titem_xview_window(t)
tgen t;
{
	void *x;
	switch(t->g.what)
	{
		case lt_canvas:
			x=(void *)tcanvas_xview(t);
			break;
		case lt_panel:
			x=(void *)tpanel_xview(t);
			break;
		case lt_list:
			x=(void *)tlist_xview(t);
			break;
		case lt_frame:
			x=(void *)tframe_xview(t);
			break;
		case lt_save:
			x=(void *)tsave_xview(t);
			break;
		case lt_load:
			x=(void *)tload_xview(t);
			break;
		case lt_event:
			x=(void *)tevent_xview_window(t);
			break;
		default:
			x=(void *)NULL;
			break;
	}
	return(x);
}
