/* MLIVAR.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <Smoothing.h>
#else
#define  __Smoothing_API
#endif
/* Common Block Declarations */

extern struct {
    integer nbr[1001];
} minombr_;

#define minombr_1 minombr_

/* Table of constant values */

/*static integer c__3 = 3;*/
/*static integer c__1 = 1;*/
static integer c__200 = 200;
static integer c__20 = 20;
static doublereal c_b15 = -1.;
static doublereal c_b16 = 1.;

/* Subroutine */ __Smoothing_API int mmlivar_(ndimen, ncofmx, nbcrmx, ncflim, nbrpnt, nbcntr, 
	tabpnt, typcnt, tabcnt, tbopnt, debfin, tabpar, nbcrbe, ncftab, 
	crbtab, tabint, errmax, numpnt, errmoy, valcri, iercod)
integer *ndimen, *ncofmx, *nbcrmx, *ncflim, *nbrpnt, *nbcntr;
doublereal *tabpnt;
integer *typcnt;
doublereal *tabcnt, *tbopnt, *debfin, *tabpar;
integer *nbcrbe, *ncftab;
doublereal *crbtab, *tabint, *errmax;
integer *numpnt;
doublereal *errmoy, *valcri;
integer *iercod;
{
    /* Initialized data */

    static doublereal calph[3] = { .4,.2,.4 };
    static integer nbcoff = -1995;

    /* System generated locals */
    integer tabpnt_dim1, tabpnt_offset, tabcnt_dim1, tabcnt_offset;
    doublereal d__1, d__2;

    /* Builtin functions */
    integer s__wsle(), do__lio(), e__wsle();
    double sqrt();

    /* Local variables */
    static logical ldbg;
    static doublereal math1[231], math2[231], math3[231], alpha[3], vpoid[2], 
	    tbopt[2];
    static integer ii, jj, kk;
    static doublereal tbecar[200];
    static integer dtheta; 
    static long int iofthe, ioffth,  eofset, pofset;/*offsets en long pmn*/
    static doublereal tbpoid[200];
    static integer ordher;
    static doublereal courbe[63];
    static doublereal ttheta[20], jestim[3], tfthet[20];
    static doublereal distot;
    extern /* Subroutine */ int macrar8_(), macrdr8_(), mmj1ref_(), mmj2ref_()
	    , mmj3ref_(), maitbr8_(), mmukpo3_();
    static integer ier;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mmarcin_(), maermsg_(), mmajlis_(), mgenmsg_()
	    , mmtheta_(), mswrdbg_(), mmlicut_(), mmliest_(), mgsomsg_(), 
	    mmcvinv_(), mmotlis_();

    /* Fortran I/O blocks */
/*    static cilist io___3 = { 0, 6, 0, 0, 0 };*/
/*    static cilist io___4 = { 0, 6, 0, 0, 0 };*/




/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*       Point d'entree du lissage variationnel de courbes */

/*     MOTS CLES : */
/*     ----------- */
/*      POINT_ENTREE, LISSAGE, VARIATIONNEL, COURBE, EN_DEVELOPPEMENT */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */
/*     NDIMEN : Dimension de l'espace */
/*     NCOFMX : Nbre maxi de coeff. pouvant etre stocke dans le tableau */
/*              CRBTAB. Cet argument sert seulement a dimensionner cette 
*/
/*              table --> (NDIMEN, NCOFMX, NBCRMX) */
/*     NBCRMX : Nombre maxi de courbes polynomiales a calculer. */
/*     NCFLIM : Nombre LIMITE de coeff des "courbes" polynomiales */
/*              d' approximation. */
/*     NBRPNT : Nombre de points a lisser  (>= 2) */
/*     NBCNTR : Nombre de point contraints (<= NBRPNT) */
/*     TABPNT : Tableau des points a lisser */
/*     TYPCNT : Tableau caracterisant les points contraints */
/*     TYPCNT(1,i) :  Indice du point contraints */
/*     TYPCNT(2,i) :  Type de la contrainte */
/*                    0 -> de passage (G0) */
/*                    1 -> passage + tangence (G1) */
/*                    2 -> passage + tangence + courbure (G2) */
/*     TABCNT  : Tableau des contraintes */
/*     TABCNT(*,1,i) : Vecteur tangent norme a respecter */
/*     TABCNT(*,2,i) : Vecteur courbure a respecter */
/*     TBOPNT : Tableau d'option du lissage */
/*        TBOPNT(1) : Tolerance de lissage ou poid de la qualite */
/*                  > 0 : Erreur max desiree sur les points */
/*                  < 0 : - le poid a affecter au critere de qualite */
/*                       ( a utiliser lorsque la precision n'est */
/*                        qu'indicative) */
/*        TBOPNT(2) : % du critere de tension (0 => valeur par defaut) */
/*        TBOPNT(3) : % du critere de flexion (0 => valeur par defaut) */
/*        TBOPNT(4) : % du critere d'ordre 3 (0 => valeur par defaut) */
/*        TBOPNT(5) : Ordre de continuite interne a respecter */
/*                  0 : C0 */
/*                  1 : C1 */
/*                  2 : C2 */
/*        TBOPNT(6) : Avec ou sans reduction du degre */
/*               0 : sans reduction du degre */
/*               1 : Avec reduction du degre */
/*        TBOPNT(7) : Avec ou sans initialisation des ti */
/*               0 = Avec */
/*               1 = Sans (on utilise les valeurs de TABPAR) */
/*        TBOPNT(8) : Avec ou sans initialisation interne */
/*               0 = Avec */
/*               1 = Sans (a utilise en cas de relissage) */
/*        TBOPNT(9) : Nombre de pas d'optimisation */
/*               0 : valeur par defaut (3) */
/*               1 : 1 seul pas ( => pas d'optimisation des parametres) */
/*               > 1 : plusieurs pas et donc optimisation des parametres 
*/
/*        TBOPNT(10) : Decoupe avec ou sans */
/*               0 : Avec decoupe */
/*               1 : Sans decoupe, on utilise les arguments NBRCBE,TABINT 
*/
/*                   Attention, s'il y a des contraintes internes, une */
/*                   mauvaise initialisation des argument ci-dessus peut 
*/
/*                   provoquer une sortie en erreur. */

/*     DEBFIN : Bornes de l' intervalle ou doivent etre definies TOUTES */
/*              les "courbes" calculees ((0,1) en general mais (-1,1) */
/*              serait plus precis). */


/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*     TABPAR : Tableaux des paramtres corespondant aux points a lisser */
/*     NBCRBE : Nombre de courbes polynomiales creees. */
/*     NCFTAB : Table des nombres de coeff. significatifs des NBCRBE */
/*              "courbes" calculees. */
/*     CRBTAB : Tableau des coeff. des "courbes" polynomiales calculees. 
*/
/*              Doit etre dimensionne a CRBTAB(NDIMEN,NCOFMX,NBCRMX). */
/*     TABINT : Table des NBCRBE + 1 bornes des intervalles de decoupe */
/*     ERRMAX : Ecart maximum au point */
/*     NUMPNT : Numero du plus mauvais point */
/*     ERRMOY : Ecart moyen aux points */
/*     VALCRI : Valeurs des criteres */
/*       VALCRI(0) : Erreur quadratique */
/*       VALCRI(1) : Energie de Tension linearise */
/*       VALCRI(2) : Energie de Flexion linearise */
/*       VALCRI(3) : "Energie du 3eme ordre" linearise */

/*       IERCOD : code d'erreur */
/*          - 2 : Non respect de l'ecart max */
/*          0   : Ok */
/*           > 0 : Echec */
/*          1   : Arguments invalide */
/*          2   : Erreur dans un sous programme */
/*          3   : Probleme d'allocation dynamique */
/*          4   : Trop de contraintes (ou nombre de courbes insuffisant) 
*/

/*     COMMONS UTILISES : */
/*     ------------------ */


/*     REFERENCES APPELEES : */
/*     --------------------- */


/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/*     Pour une utilisation dynamique, il faut realiser un 1er lissage */
/*     puis effectuer les lissages suivants avec */
/*     - Les options 7 a 10 egales a 1 */
/*     - Les arguments NBRCBE, TABINT, TABPAR rendus par l'iteration */
/*       precedente. */
/*     - Faire attention si des contraintes sont ajoute ou deplace. */

/*     L'ordre minimum des courbes est 2 * ( TBOPNT(5) + 1 ) */

/*     Deux points a lisser successif peuvent etre confondus : le poid du 
*/
/*        point dans les moindre carre sera double. */

/*     En revanche 2 points coontraints sucessif ne peuvent etre */
/*     confondus : indetermination du probleme et sortie en erreur. */

/*     si (NCFLIM - TBOPNT(5) -1) * NBCRMX - ng0 - 3*ng1 - 3*ng2 < 0 */
/*     Ou */
/*        - ng0 est le nombre de contraintes G0 */
/*        - ng1 est le nombre de contraintes "G1" */
/*        - ng2 est le nombre de contraintes "G2" */

/*     alors le systeme sera considere comme sur contraint => IERCOD = 4 
*/

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     27-11-1995: PMN; Bon code d'erreur en sortie de MMLICUT */
/*     10-10-1995: PMN; ECRITURE VERSION ORIGINALE. */
/* > */
/* ***********************************************************************
 */
/*                            DECLARATIONS */
/* ***********************************************************************
 */



/* ---  Variables statiques */


/*     VARIABLES LOCALES */



/*     INCLUDE MINOMBR */
/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*        Sert a fournir les constantes entieres de 0 a 1000 */

/*     MOTS CLES : */
/*     ----------- */
/*        TOUS,ENTIERS */

/*     DEMSCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     11-10-89 : DH ; Creation version originale */
/* > */
/* ***********************************************************************
 */


/* ***********************************************************************
 */

    /* Parameter adjustments */
    tabcnt_dim1 = *ndimen;
    tabcnt_offset = tabcnt_dim1 * 3 + 1;
    tabcnt -= tabcnt_offset;
    --crbtab;
    --ncftab;
    --tabpar;
    tabpnt_dim1 = *ndimen;
    tabpnt_offset = tabpnt_dim1 + 1;
    tabpnt -= tabpnt_offset;
    typcnt -= 3;
    --tbopnt;
    --debfin;

    /* Function Body */
/*     INCLUDE 'MINOMBR.INC' */
/* ***********************************************************************
 */
/*                      INITIALISATIONS */
/* ***********************************************************************
 */

    ldbg = mnfndeb_() >= 2;
    if (ldbg) {
	mgenmsg_("MMLIVAR", 7L);
    }
    *iercod = 0;

/* ***********************************************************************
 */
/*                     TRAITEMENT */
/* ***********************************************************************
 */

/* (0) Verifications des donnees et init generaux */

    if (*nbrpnt <= 1) {
	goto L9101;
    }
    if (*nbcntr > *nbrpnt) {
	goto L9101;
    }
    if (*nbcntr < 0) {
	goto L9101;
    }
    if (*ncflim > 21) {
	goto L9101;
    }
    if (*ncofmx < *ncflim) {
	goto L9101;
    }

    tbopt[0] = tbopnt[9];
    if (tbopt[0] == 0.) {
	tbopt[0] = 2.;
    }
/*      IF (TBOPT(1).LT.0) GOTO 9101 */

    tbopt[1] = tbopnt[10];
    if (tbopt[1] < 0.) {
	goto L9101;
    }

    ordher = (integer) tbopnt[5];
    if (ordher < 0 || ordher > 2) {
	goto L9101;
    }


/*      ALLOCATION DYNAMIQUE */

    macrar8_(nbrpnt, &c__200, tbecar, &eofset, &ier);
    if (ier > 0) {
	goto L9103;
    }
    macrar8_(nbrpnt, &c__200, tbpoid, &pofset, &ier);
    if (ier > 0) {
	goto L9103;
    }

    dtheta = *ndimen * (*ndimen - 1) * *nbcntr;
    macrar8_(&dtheta, &c__20, ttheta, &iofthe, &ier);
    if (ier > 0) {
	goto L9103;
    }
    macrar8_(&dtheta, &c__20, tfthet, &ioffth, &ier);
    if (ier > 0) {
	goto L9103;
    }

/* (1.1) Initialisation des Ti et approximation de la longueur */

    if (tbopnt[7] == 0.) {
	mmukpo3_(ndimen, nbrpnt, &tabpnt[tabpnt_offset], ndimen, &tabpar[1], &
		distot, &ier);
	if (ier > 0) {
	    goto L9102;
	}

/*        Avec peu de point il y a sans doute sous estimation... */

	if (*nbrpnt < 10) {
	    distot = (.1 / (*nbrpnt - 1) + 1.) * distot;
	}
    }
    else {
       distot = tbopnt[7]; /* On recupere l'approximation de la longueur */
    }

/*     Decoupe de l'intervalle en fonction des contraintes */

    if (tbopnt[10] == 0.) {
	mmlicut_(nbrpnt, &tabpar[1], nbcntr, &typcnt[3], ncflim, nbcrmx, &
		ordher, nbcrbe, tabint, &ier);
	if (ier == 1) {
	    goto L9104;
	}
	if (ier == 2) {
	    goto L9104;
	}
	if (ier > 0) {
	    goto L9102;
	}
    }


/* (2) Calcul des ponderations */


/* (2.1) Definition de Jq */

    if (tbopnt[8] == 0.) {
/* Computing 2nd power */
	d__1 = distot;
	jestim[0] = d__1 * d__1;
	mmliest_(ndimen, nbrpnt, nbcntr, &tabpnt[tabpnt_offset], &typcnt[3], &
		tabcnt[tabcnt_offset], &tabpar[1], &distot, &jestim[1], &
		jestim[2], &ier);
	if (ier > 0) {
	    goto L9102;
	}
    }

    for (ii = 1; ii <= 3; ++ii) {
	alpha[ii - 1] = tbopnt[ii + 1];
	if (alpha[ii - 1] == 0.) {
	    alpha[ii - 1] = calph[ii - 1];
	} else if (alpha[ii - 1] < 0.) {
	    goto L9101;
	}
    }

/* (2.2) ponderation entre les moindres carres Jo */
/*                    et le critere de qualite Jq */

    if (tbopnt[1] < 0.) {
	vpoid[1] = -tbopnt[1];
    } else if (tbopnt[1] == 0.) {
	vpoid[1] = (float)1.;
    } else {
/* Computing MAX */
	d__1 = abs(tbopnt[1]), d__2 = distot * 1e-6;
	vpoid[1] = max(d__1,d__2);
    }

    vpoid[0] = sqrt((doublereal) (*nbrpnt - *nbcntr)) * vpoid[1];
    if (vpoid[0] > 1e-9) {
	vpoid[0] = (float)1. / vpoid[0];
    }

/* (3) Calcul des formes quadratiques */

    if (*ncflim > nbcoff) {
	mmj1ref_(&c_b15, &c_b16, ncflim, &ordher, math1, &ier);
	if (ier > 0) {
	    goto L9102;
	}
	mmj2ref_(&c_b15, &c_b16, ncflim, &ordher, math2, &ier);
	if (ier > 0) {
	    goto L9102;
	}
	mmj3ref_(&c_b15, &c_b16, ncflim, &ordher, math3, &ier);
	if (ier > 0) {
	    goto L9102;
	}

	nbcoff = *ncflim;

    }

/* (4) Calcul des tables des valeurs dependant des donnees */

    mmtheta_(ndimen, nbcntr, &typcnt[3], &tabcnt[tabcnt_offset], &ttheta[
	    iofthe], &tfthet[ioffth], &ier);
    if (ier > 0) {
	goto L9102;
    }



/* (5) Lissage */


    maitbr8_(nbrpnt, &tbpoid[pofset], &c_b16);

    mmotlis_(ndimen, nbcrmx, ncflim, nbrpnt, nbcntr, &ordher, &tabpnt[
	    tabpnt_offset], &tbpoid[pofset], &typcnt[3], &tabcnt[
	    tabcnt_offset], tbopt, math1, math2, math3, vpoid, alpha, jestim, 
	    &ttheta[iofthe], &tfthet[ioffth], &distot, &tabpar[1], nbcrbe, &
	    ncftab[1], &crbtab[1], tabint, &tbecar[eofset], numpnt, errmax, 
	    errmoy, valcri, &ier);
    if (ier > 0) {
	goto L9102;
    }


/* (6) Ajustement des ponderations */

    if (tbopnt[1] > 0. && *errmax > tbopnt[1]) {

	mmajlis_(ndimen, nbcrmx, ncflim, nbrpnt, nbcntr, &ordher, &tabpnt[
		tabpnt_offset], &tbpoid[pofset], &typcnt[3], &tabcnt[
		tabcnt_offset], tbopt, math1, math2, math3, vpoid, alpha, 
		jestim, &ttheta[iofthe], &tfthet[ioffth], &distot, &tabpar[1],
		 nbcrbe, &ncftab[1], &crbtab[1], tabint, &tbecar[eofset], 
		numpnt, errmax, errmoy, valcri, &ier);
	if (ier > 0) {
	    goto L9102;
	}

    }

/* (7) Relaxation */

/*    neant */


/* (8) Conversion sur DEBFIN */

    kk = 1;
    jj = 1;

    for (ii = *nbcrbe; ii >= 1; --ii) {
	kk = (ii - 1) * *ndimen * *ncflim + 1;
	jj = (ii - 1) * *ndimen * *ncofmx + 1;
	mmcvinv_(&ncftab[ii], ndimen, &ncftab[ii], &crbtab[kk], courbe);

	mmarcin_(ndimen, ndimen, &ncftab[ii], courbe, &debfin[1], &debfin[2], 
		&crbtab[jj], &ier);
	if (ier > 0) {
	    goto L9102;
	}
    }

    if (abs(tbopnt[1]) < *errmax) {
	*iercod = -2;
    }

    goto L9999;

/* ***********************************************************************
 */
/*                   TRAITEMENT DES ERREURS */
/* ***********************************************************************
 */

L9101:
    mswrdbg_("MMLIVAR: PROBLEME AVEC LES ARGUMENTS", 36L);
    *iercod = 1;
    goto L9999;

L9102:
    *iercod = 2;
    if (ier == 3) {
	*iercod = 3;
    }
    goto L9999;

L9103:
    *iercod = 3;
    goto L9999;

L9104:
    *iercod = 4;
    goto L9999;


/* ***********************************************************************
 */
/*                   RETOUR PROGRAMME APPELANT */
/* ***********************************************************************
 */

L9999:

/* ___ DESALLOCATION, ... */

    macrdr8_(nbrpnt, &c__200, tbecar, &eofset, &ier);
    if (*iercod == 0 && ier > 0) {
	*iercod = 3;
    }
    macrdr8_(nbrpnt, &c__200, tbpoid, &pofset, &ier);
    if (ier > 0) {
	goto L9103;
    }

    macrdr8_(&dtheta, &c__20, ttheta, &iofthe, &ier);
    if (*iercod == 0 && ier > 0) {
	*iercod = 3;
    }
    macrdr8_(&dtheta, &c__20, tfthet, &ioffth, &ier);
    if (*iercod == 0 && ier > 0) {
	*iercod = 3;
    }

    maermsg_("MMLIVAR", iercod, 7L);
    if (ldbg) {
	mgsomsg_("MMLIVAR", 7L);
    }

 return 0 ;
} /* mmlivar_ */

