/* VCVIN2.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#include <Data_Data.h>
/* Common Block Declarations */

/*extern __Data_API struct {*/
extern struct {
    doublereal cnp[3721]	/* was [61][61] */;
} mmcmcnp_;

#define mmcmcnp_1 mmcmcnp_

/* Subroutine */ int mvcvin2_(ncoeff, crvold, crvnew, iercod)
integer *ncoeff;
doublereal *crvold, *crvnew;
integer *iercod;
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    static integer m1jm1, ncfm1, j, k;
    static doublereal bid;
    extern /* Subroutine */ int maermsg_();
    static doublereal cij1, cij2;




/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/************************************************************************
*******/

/*     FONCTION : */
/*     ---------- */
/*        INVERSION DU PARAMETRAGE SUR UNE CRBE 2D. */

/*     MOTS CLES : */
/*     ----------- */
/*        COURBE,2D,INVERSION,PARAMETRE. */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*        NCOEFF   : NBRE DE COEFF DE LA COURBE. */
/*        CRVOLD   : LA COURBE D'ORIGINE */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*        CRVNEW   : LA CRBE RESULTAT APRES CHANGT DE T EN 1-T */
/*        IERCOD   :  0 OK, */
/*                   10 NBRE DE COEFF NUL OU TROP GRAND. */

/*     COMMONS UTILISES   : */
/*     ---------------- */
/*    MCCNP */

/*     REFERENCES APPELEES   : */
/*     ---------------------- */
/*            Neant */
/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     L' APPEL SUIVANT EST TOUT A FAIT LEGAL : */
/*          CALL MVCVIN2(NCOEFF,CURVE,CURVE,IERCOD), LE TABLEAU CURVE */
/*     DEVENANT UN ARGUMENT D' ENTREE ET DE SORTIE (RBD). */
/*     A CAUSE DE MCCNP, LE NBRE DE COEFF DE LA COURBE EST LIMITE A */
/*     NDGCNP+1 = 61. */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     24-09-93 : MPS ; PRISE EN COMPTE NCOEFF=1 */
/*                      IMPLICIT NONE */
/*     09-01-90 : TE ; COMMON MCCNP -> MCNCNP.INC & INDICES DES CNP */
/*     05-08-88 : RBD ; ACTIVATION DE L' IERCOD */
/*     27-06-88 : RBD ; VERIFICATION QUE LES IDENTIFICATEURS CRVNEW ET */
/*                      CRVOLD PEUVENT DESIGNER LA MEME COURBE. */
/*     14-04-88 : NAK ; VERSION ORIGINALE */
/* > */
/* ***********************************************************************
 */



/*     INCLUDE MMCMCNP */
/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*      Sert a fournir les coefficients du binome (triangle de Pascal). */

/*     MOTS CLES : */
/*     ----------- */
/*      Coeff du binome de 0 a 60. read only . init par block data */

/*     DEMSCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     Les coefficients du binome forment une matrice triangulaire. */
/*     On complete cette matrice dans le tableau CNP par sa transposee. */
/*     On a donc: CNP(I,J) = CNP(J,I) pour I et J = 0, ..., 60. */

/*     L'initialisation est faite a partir du block-data MMLLL09.RES, */
/*     cree par le programme MQINICNP.FOR (voir l'equipe (AC) ). */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     03-07-90 : RBD; Ajout commentaires (nom du block-data). */
/*     19-06-90 : RBD; Le commun MMCMCNP remplace MCCNP qui est obsolete. 
*/
/*     08-01-90 : TE ; CREATION */
/* > */
/* ********************************************************************** 
*/



/* ***********************************************************************
 */

    /* Parameter adjustments */
    crvnew -= 3;
    crvold -= 3;

    /* Function Body */
    if (*ncoeff < 1 || *ncoeff - 1 > 60) {
	*iercod = 10;
	goto L9999;
    }
    *iercod = 0;


/* TERME CONSTANT DE LA NOUVELLE COURBE */

    cij1 = crvold[3];
    cij2 = crvold[4];
    i__1 = *ncoeff;
    for (k = 2; k <= i__1; ++k) {
	cij1 += crvold[(k << 1) + 1];
	cij2 += crvold[(k << 1) + 2];
    }
    crvnew[3] = cij1;
    crvnew[4] = cij2;
    if (*ncoeff == 1) {
	goto L9999;
    }

/* PUISSANCES INTERMEDIAIRES DU PARAMETRE */

    ncfm1 = *ncoeff - 1;
    m1jm1 = 1;
    i__1 = ncfm1;
    for (j = 2; j <= i__1; ++j) {
	m1jm1 = -m1jm1;
	cij1 = crvold[(j << 1) + 1];
	cij2 = crvold[(j << 1) + 2];
	i__2 = *ncoeff;
	for (k = j + 1; k <= i__2; ++k) {
	    bid = mmcmcnp_1.cnp[k - 1 + (j - 1) * 61];
	    cij1 += crvold[(k << 1) + 1] * bid;
	    cij2 += crvold[(k << 1) + 2] * bid;
	}
	crvnew[(j << 1) + 1] = cij1 * m1jm1;
	crvnew[(j << 1) + 2] = cij2 * m1jm1;
    }

/* TERME DE PLUS HAUT DEGRE */

    crvnew[(*ncoeff << 1) + 1] = -crvold[(*ncoeff << 1) + 1] * m1jm1;
    crvnew[(*ncoeff << 1) + 2] = -crvold[(*ncoeff << 1) + 2] * m1jm1;

L9999:
    if (*iercod > 0) {
	maermsg_("MVCVIN2", iercod, 7L);
    }
 return 0 ;
} /* mvcvin2_ */

