/* MDRVCK.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#include <Data_Data.h>
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif

/* Common Block Declarations */

/*extern __Data_API struct {*/
extern struct {
    doublereal cnp[3721]	/* was [61][61] */;
} mmcmcnp_;

#define mmcmcnp_1 mmcmcnp_

/* Subroutine */ __MathBase_API int mmdrvck_(ncoeff, ndimen, courbe, ideriv, tparam, pntcrb)
integer *ncoeff, *ndimen;
doublereal *courbe;
integer *ideriv;
doublereal *tparam, *pntcrb;
{
    /* Initialized data */

    static doublereal mmfack[21] = { 1.,2.,6.,24.,120.,720.,5040.,40320.,
	    362880.,3628800.,39916800.,479001600.,6227020800.,87178291200.,
	    1.307674368e12,2.0922789888e13,3.55687428096e14,6.402373705728e15,
	    1.21645100408832e17,2.43290200817664e18,5.109094217170944e19 };

    /* System generated locals */
    integer courbe_dim1, courbe_offset, i__1, i__2;

    /* Local variables */
    static integer i__, j, k, nd;
    static doublereal mfactk, bid;


/*      IMPLICIT INTEGER (I-N) */
/*      IMPLICIT DOUBLE PRECISION(A-H,O-Z) */



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*     CALCUL DE LA VALEUR D'UNE COURBE DERIVEE D' ORDRE IDERIV EN */
/*     UN POINT DE PARAMETRE TPARAM. */

/*     MOTS CLES : */
/*     ----------- */
/*     POSITIONNEMENT,COURBE,DERIVEE D' ORDRE K. */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*   NCOEFF  : Le degre +1 de la courbe. */
/*   NDIMEN   : Dimension de l'espace (2 ou 3 en general) */
/*   COURBE  : Tableau des coefficients de la courbe. */
/*   IDERIV : Ordre de derivation demande : 1=derivee 1ere, etc... */
/*   TPARAM : Valeur du parametre de la courbe. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*   PNTCRB  : Le point de parametre TPARAM sur la derivee d' ordre */
/*            IDERIV de COURBE. */

/*     COMMONS UTILISES   : */
/*     ---------------- */
/*    MMCMCNP */

/*     REFERENCES APPELEES   : */
/*     ---------------------- */
/*      .Neant. */
/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/*    Le code ci dessous a ete ecrit a partir de l' algorithme suivant : 
*/

/*    Soit P(t) = a1 + a2*t + ... an*t**n. La derivee d' ordre k de P */
/*    (comportant n-k coefficients) est calculee ainsi : */

/*       Pk(t) = a(k+1)*CNP(k,k)*k! */
/*             + a(k+2)*CNP(k+1,k)*k! * t */
/*             . */
/*             . */
/*             . */
/*             + a(n)*CNP(n-1,k)*k! * t**(n-k-1). */

/*    L' evaluation se fait suivant un schema de Horner classique. */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*      8-09-1995 : JMF ; Performance */
/*     09-01-90 : TE ; COMMON MCCNP -> MMCMCNP.INC & INDICES DES CNP */
/*     06-07-88 : RBD; Creation, sur une idee de GD. */
/* > */
/* ***********************************************************************
 */


/*     Factorielles (1 a 21)  caculees  sur VAX en R*16 */

/*     INCLUDE MMCMCNP */
/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*      Sert a fournir les coefficients du binome (triangle de Pascal). */

/*     MOTS CLES : */
/*     ----------- */
/*      Coeff du binome de 0 a 60. read only . init par block data */

/*     DEMSCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     Les coefficients du binome forment une matrice triangulaire. */
/*     On complete cette matrice dans le tableau CNP par sa transposee. */
/*     On a donc: CNP(I,J) = CNP(J,I) pour I et J = 0, ..., 60. */

/*     L'initialisation est faite a partir du block-data MMLLL09.RES, */
/*     cree par le programme MQINICNP.FOR (voir l'equipe (AC) ). */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     03-07-90 : RBD; Ajout commentaires (nom du block-data). */
/*     19-06-90 : RBD; Le commun MMCMCNP remplace MCCNP qui est obsolete. 
*/
/*     08-01-90 : TE ; CREATION */
/* > */
/* ********************************************************************** 
*/



/* ***********************************************************************
 */

    /* Parameter adjustments */
    --pntcrb;
    courbe_dim1 = *ndimen;
    courbe_offset = courbe_dim1 + 1;
    courbe -= courbe_offset;

    /* Function Body */

/* -------------- Cas ou l' ordre de derivee est plus ------------------- 
*/
/* ---------------- grand que le degre de la courbe --------------------- 
*/

    if (*ideriv >= *ncoeff) {
	i__1 = *ndimen;
	for (nd = 1; nd <= i__1; ++nd) {
	    pntcrb[nd] = 0.;
/* L100: */
	}
	goto L9999;
    }
/* ********************************************************************** 
*/
/*                         Traitement general */
/* ********************************************************************** 
*/
/* --------------------- Calcul de Factorielle(IDERIV) ------------------ 
*/

    k = *ideriv;
    if (*ideriv <= 21 && *ideriv > 0) {
	mfactk = mmfack[k - 1];
    } else {
	mfactk = 1.;
	i__1 = k;
	for (i__ = 2; i__ <= i__1; ++i__) {
	    mfactk *= i__;
/* L200: */
	}
    }

/* ------- Calcul de la derivee d' ordre IDERIV de COURBE en TPARAM ----- 
*/
/* ---> Attention : le coefficient binomial C(n,m) est represente dans */
/*                 MCCNP par CNP(N,M). */

    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	pntcrb[nd] = courbe[nd + *ncoeff * courbe_dim1] * mmcmcnp_1.cnp[*
		ncoeff - 1 + k * 61] * mfactk;
/* L300: */
    }

    i__1 = k + 1;
    for (j = *ncoeff - 1; j >= i__1; --j) {
	bid = mmcmcnp_1.cnp[j - 1 + k * 61] * mfactk;
	i__2 = *ndimen;
	for (nd = 1; nd <= i__2; ++nd) {
	    pntcrb[nd] = pntcrb[nd] * *tparam + courbe[nd + j * courbe_dim1] *
		     bid;
/* L500: */
	}
/* L400: */
    }

/* -------------------------------- The end ----------------------------- 
*/

L9999:

 return 0   ;

} /* mmdrvck_ */

