// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Xw_GraphicDevice_HeaderFile
#define _Xw_GraphicDevice_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Xw_GraphicDevice_HeaderFile
#include <Handle_Xw_GraphicDevice.hxx>
#endif

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Handle_Xw_ColorMap_HeaderFile
#include <Handle_Xw_ColorMap.hxx>
#endif
#ifndef _Handle_Xw_TypeMap_HeaderFile
#include <Handle_Xw_TypeMap.hxx>
#endif
#ifndef _Handle_Xw_WidthMap_HeaderFile
#include <Handle_Xw_WidthMap.hxx>
#endif
#ifndef _Handle_Xw_FontMap_HeaderFile
#include <Handle_Xw_FontMap.hxx>
#endif
#ifndef _Handle_Xw_MarkMap_HeaderFile
#include <Handle_Xw_MarkMap.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Aspect_GraphicDevice_HeaderFile
#include <Aspect_GraphicDevice.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Xw_TypeOfMapping_HeaderFile
#include <Xw_TypeOfMapping.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Xw_TypeOfVisual_HeaderFile
#include <Xw_TypeOfVisual.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Handle_Aspect_GraphicDriver_HeaderFile
#include <Handle_Aspect_GraphicDriver.hxx>
#endif
class Xw_ColorMap;
class Xw_TypeMap;
class Xw_WidthMap;
class Xw_FontMap;
class Xw_MarkMap;
class Aspect_GraphicDeviceDefinitionError;
class Aspect_BadAccess;
class Xw_Window;
class Aspect_GraphicDriver;


//! This class defines an X11 Graphic Device <br>
//!  Warning: An Graphic Device is defined by : <br>
//!		- a connection "host:server.screen" <br>
//!		- a colormap mapping of type Xw_TOM_xxxxx <br>
//!		- a "UseDefault" flag which permits the use of the <br>
//!			DefaultColormap if possible. <br>
//!	    The connection can be specified directly <br>
//!	    or extracted from an existing Window. <br>
//!	    All Xw_Windows may share the same Graphic Device if <br>
//!	    you don't want to have any side effects on the stations <br>
//!	    which have only one hardware pseudo-colormap . <br>
//!	    Four kind of mapping are possible : <br>
//!	    1) Xw_TOM_SIMPLERAMP <br>
//!	       Allocates the number of required colors in the <br>
//!	       colormap. <br>
//!	       The number of user colors depends directly on <br>
//!	       the hardware colormap size if UseDefault is False, <br>
//!	       or on the remainding free colors in the hardware colormap <br>
//!	       if UseDefault is True. <br>
//!	    2) Xw_TOM_BESTRAMP <br>
//!	       Allocates the number of required colors in the <br>
//!	       colormap but leaves the Odd color indexes free <br>
//!	       if possible for highlight color management. <br>
//!	       (plane 0 is reserved for this usage) <br>
//!	       The number of user colors depends directly on <br>
//!	       the hardware colormap size if UseDefault is False, <br>
//!	       or on the remainding free colors in the hardware colormap <br>
//!	       if UseDefault is True. <br>
//!	    3) Xw_TOM_COLORCUBE (the default) <br>
//!	       Allocates the maximum available colors in the colormap <br>
//!	       and builds a colorcube at this place. <br>
//!	       Any user color will be approximate and will be chosen as <br>
//!	       the nearest of the set of available colorcube colors. <br>
//!	       In this case the number of user colors can be unlimited. <br>
//!	    4) Xw_TOM_HARDWARE <br>
//!	       May do serious damage to the color system. <br>
//!	       Must be used for maintenance only. <br>
//!	    5) Xw_TOM_READONLY <br>
//!	       Allocates the number of required read only colors in the <br>
//!	       default colormap. <br>
//!	       The number of user colors depends directly on <br>
//!	       the hardware colormap size. <br>
class Xw_GraphicDevice : public Aspect_GraphicDevice {

public:
 // Methods PUBLIC
 // 

//! Create an Graphic Device on the specified Connection <br>
//!	    by using ALL screen defaults if possible <br>
//!	    (i.e:Default Colormap) <br>
//!  Warning: Raises if the Device is Badly defined <br>
Standard_EXPORT Xw_GraphicDevice(const Standard_CString Connection,const Xw_TypeOfMapping Mapping = Xw_TOM_COLORCUBE,const Standard_Integer Ncolors = 0,const Standard_Boolean UseDefault = Standard_True);

//! Destroies all ressources attached to the GraphicDevice <br>
//!	    (Windows, Colormaps, ....) <br>
//!  Warning: Raises if the Device is Badly defined <br>
Standard_EXPORT virtual  void Destroy() ;
~Xw_GraphicDevice()
{
  Destroy();
}


//! Returns the 2D oriented Device color map. <br>
Standard_EXPORT   Handle_Xw_ColorMap ColorMap2D() const;

//! Returns the 2D oriented Visual Class. <br>
Standard_EXPORT   Xw_TypeOfVisual VisualClass2D() const;

//! Returns the 2D oriented overlay Visual Class. <br>
Standard_EXPORT   Xw_TypeOfVisual OverlayVisualClass2D() const;

//! Returns the 3D oriented Device color map. <br>
Standard_EXPORT   Handle_Xw_ColorMap ColorMap3D() const;

//! Returns the 3D oriented Visual Class. <br>
Standard_EXPORT   Xw_TypeOfVisual VisualClass3D() const;

//! Returns the 3D oriented overlay Visual Class. <br>
Standard_EXPORT   Xw_TypeOfVisual OverlayVisualClass3D() const;

//! Returns the Device Type map. <br>
Standard_EXPORT   Handle_Xw_TypeMap TypeMap() const;

//! Returns the Device Width map. <br>
Standard_EXPORT   Handle_Xw_WidthMap WidthMap() const;

//! Returns the Device Font map. <br>
Standard_EXPORT   Handle_Xw_FontMap FontMap() const;

//! Returns the Device Mark map. <br>
Standard_EXPORT   Handle_Xw_MarkMap MarkMap() const;

//! Returns the Device connection string. <br>
Standard_EXPORT   Standard_CString Display() const;

//! Returns the Device Display Address. <br>
Standard_EXPORT   Standard_Address XDisplay() const;

//! Returns the Display size in PIXEL <br>
//!  Warning: Raises if the connection is not defined properly <br>
Standard_EXPORT   void DisplaySize(Standard_Integer& Width,Standard_Integer& Height) const;

//! Returns the Display size in METER <br>
//!  Warning: Raises if the connection is not defined properly <br>
Standard_EXPORT   void DisplaySize(Quantity_Length& Width,Quantity_Length& Height) const;

//! Returns the plane layer ID from a visual ID <br>
//!  Warning: Raises if the connection is not defined properly <br>
Standard_EXPORT   Standard_Integer PlaneLayer(const Standard_Integer aVisualID) const;


Standard_EXPORT virtual  Handle_Aspect_GraphicDriver GraphicDriver() const;


friend class Xw_Window;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT Xw_GraphicDevice();

//! Initializes all ressources attached to the GraphicDevice <br>
//!  Category: methods to modify the class definition <br>
//!  Warning: Raises if the Device is Badly defined <br>
Standard_EXPORT   void InitMaps(const Standard_CString Connection,const Xw_TypeOfMapping Mapping,const Standard_Integer Ncolors,const Standard_Boolean UseDefault) ;

//! Returns extended data colormap 2D structure pointer. <br>
Standard_EXPORT   Standard_Address ExtendedColorMap2D() const;

//! Returns extended data overlay colormap 2D structure pointer. <br>
Standard_EXPORT   Standard_Address ExtendedOverlayColorMap2D() const;

//! Returns extended data colormap 3D structure pointer. <br>
Standard_EXPORT   Standard_Address ExtendedColorMap3D() const;

//! Returns extended data overlay colormap 3D structure pointer. <br>
Standard_EXPORT   Standard_Address ExtendedOverlayColorMap3D() const;

//! Returns extended data typemap structure pointer. <br>
Standard_EXPORT   Standard_Address ExtendedTypeMap() const;

//! Returns extended data widthmap structure pointer. <br>
Standard_EXPORT   Standard_Address ExtendedWidthMap() const;

//! Returns extended data fontmap structure pointer. <br>
Standard_EXPORT   Standard_Address ExtendedFontMap() const;

//! Returns extended data markmap structure pointer. <br>
Standard_EXPORT   Standard_Address ExtendedMarkMap() const;

//! Returns extended data display structure pointer. <br>
Standard_EXPORT   Standard_Address ExtendedDisplay() const;


 // Fields PROTECTED
 //
Standard_Address MyExtendedDisplay;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString MyDisplay;
Handle_Xw_ColorMap MyColorMap2D;
Handle_Xw_ColorMap MyColorMap3D;
Handle_Xw_TypeMap MyTypeMap;
Handle_Xw_WidthMap MyWidthMap;
Handle_Xw_FontMap MyFontMap;
Handle_Xw_MarkMap MyMarkMap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
