// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDataStd_Directory_HeaderFile
#define _TDataStd_Directory_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TDataStd_Directory_HeaderFile
#include <Handle_TDataStd_Directory.hxx>
#endif

#ifndef _TDF_Attribute_HeaderFile
#include <TDF_Attribute.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Handle_TDF_RelocationTable_HeaderFile
#include <Handle_TDF_RelocationTable.hxx>
#endif
#ifndef _Handle_TDF_DataSet_HeaderFile
#include <Handle_TDF_DataSet.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TDF_Label;
class Standard_GUID;
class TDF_Attribute;
class TDF_RelocationTable;
class TDF_DataSet;


//! Associates a directory in the data framework with <br>
//! a TDataStd_TagSource attribute. <br>
//! You can create a new directory label and add <br>
//! sub-directory or object labels to it, <br>
class TDataStd_Directory : public TDF_Attribute {

public:
 // Methods PUBLIC
 // 

//! class methods <br>
//!          ============= <br>//! Searches for a directory attribute on the label <br>
//! current, or on one of the father labels of current. <br>
//! If a directory attribute is found, true is returned, <br>
//! and the attribute found is set as D. <br>
Standard_EXPORT static  Standard_Boolean Find(const TDF_Label& current,Handle(TDataStd_Directory)& D) ;

//!  Creates  an  enpty   Directory attribute,  located  at <br>
//!          <label>. Raises if <label> has attribute <br>
Standard_EXPORT static  Handle_TDataStd_Directory New(const TDF_Label& label) ;

//!  Creates a new sub-label and sets the <br>
//! sub-directory dir on that label. <br>
Standard_EXPORT static  Handle_TDataStd_Directory AddDirectory(const Handle(TDataStd_Directory)& dir) ;

//!  Makes new label and returns it to insert <br>
//!           other object attributes (sketch,part...etc...) <br>
Standard_EXPORT static  TDF_Label MakeObjectLabel(const Handle(TDataStd_Directory)& dir) ;

//! Directory methods <br>
//!          =============== <br>
Standard_EXPORT static const Standard_GUID& GetID() ;


Standard_EXPORT TDataStd_Directory();


Standard_EXPORT  const Standard_GUID& ID() const;


Standard_EXPORT   void Restore(const Handle(TDF_Attribute)& with) ;


Standard_EXPORT   Handle_TDF_Attribute NewEmpty() const;


Standard_EXPORT   void Paste(const Handle(TDF_Attribute)& into,const Handle(TDF_RelocationTable)& RT) const;


Standard_EXPORT virtual  void References(const Handle(TDF_DataSet)& DS) const;


Standard_EXPORT virtual  Standard_OStream& Dump(Standard_OStream& anOS) const;
//Standard_EXPORT ~TDataStd_Directory();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
